<cfcomponent displayname="Controle e manipulao de veculos" extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO
	-- Insere comentrio na coluna determinada
	-- NOTAS EXPLICATIVAS
	-- GUTO 22/11/2005 - criado
	--->
	<cffunction name="ins_comentario" displayname="Insere comentrio na coluna determinada" access="remote" returntype="struct" output="true">
		<cfargument name="placa_controle" required="true">
		<cfargument name="placa_referencia" required="true">
		<cfargument name="cod_pessoa_filial" required="true">
		<cfargument name="viagem_id" required="true" displayname="0 - Tempo Parado, 1 - Veculo, 2 - Motorista, 3 - Romaneio">
		<cfargument name="num_romaneio" required="true">
		<cfargument name="cod_pessoa_responsavel" required="true">
		<cfargument name="muda_filial_responsavel" required="true">
	    <cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_rank_frota.prc_ins_comentario" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_placa_controlw" null="yes" variable="retorno.id">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_placa" value="#arguments.placa#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_pessoa" value="#arguments.cod_pessoa#" null="#IIF(isDefined("arguments.cod_pessoa") and Len(Trim(arguments.cod_pessoa)),DE('no'),DE('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_num_romaneio" value="#arguments.num_romaneio#" null="#IIF(isDefined("arguments.num_romaneio") and Len(Trim(arguments.num_romaneio)),DE('no'),DE('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_referencia_id" value="#arguments.referencia_id#" null="#IIF(isDefined("arguments.referencia_id") and Len(Trim(arguments.referencia_id)),DE('no'),DE('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_landmark" value="#arguments.landmark#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_tipo_comentario" value="#arguments.tipo_comentario#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_comentario" value="#arguments.comentario#">
				<cfprocparam type="out" cfsqltype="cf_sql_varchar" dbvarname="p_rowid" variable="retorno.rowid">
			</cfstoredproc>

			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_rank_frota.prc_atualiza_hints" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_placa" value="#arguments.placa#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_pessoa" value="#arguments.cod_pessoa#" null="#IIF(isDefined("arguments.cod_pessoa") and Len(Trim(arguments.cod_pessoa)),DE('no'),DE('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_num_romaneio" value="#arguments.num_romaneio#" null="#IIF(isDefined("arguments.num_romaneio") and Len(Trim(arguments.num_romaneio)),DE('no'),DE('yes'))#">
			</cfstoredproc>

			<cfset retorno.mensagem = 'Comentrio inserido com sucesso.'>				
			<cfset retorno.erro = false>						
 	  <cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
	   </cfcatch>
	   </cftry>
	   <cfreturn retorno>	   
	</cffunction>
    
		<!--- 
		-- PROPSITO
		-- Destinar um veculo no controle de trfego simplificado.
		-- FABIOG 10/03/2011 15:23:51 - CRIADO
		--->
    <cffunction name='ins_inicio_viagem' displayname='Destinar um veculo no controle de trfego simplificado.' access='remote' returntype='Struct' output='true'>
        <cfargument name='PLACA_CONTROLE' required='yes'>
        <cfargument name='PLACA_REFERENCIA' required='yes'>
        <cfargument name='COD_PESSOA_FILIAL' required='yes'>
        <cfargument name='VIAGEM_ID' required='yes'>
        <cfargument name='COD_PESSOA_RESPONSAVEL' required='yes'>
        <cfargument name='MUDA_FILIAL_RESPONSAVEL' required='no' default='0'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_romaneio_dml.prc_ins_inicio_viagem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA_CONTROLE'  value='#arguments.PLACA_CONTROLE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA_REFERENCIA'  value='#arguments.PLACA_REFERENCIA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_FILIAL'  value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VIAGEM_ID'  value='#arguments.VIAGEM_ID#'  null='#iif(len(trim(arguments.VIAGEM_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ROMANEIO' variable='retorno.NUM_ROMANEIO' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_RESPONSAVEL'  value='#arguments.COD_PESSOA_RESPONSAVEL#'  null='#iif(len(trim(arguments.COD_PESSOA_RESPONSAVEL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MUDA_FILIAL_RESPONSAVEL'  value='#arguments.MUDA_FILIAL_RESPONSAVEL#'  null='#iif(len(trim(arguments.MUDA_FILIAL_RESPONSAVEL)), de('no'), de('yes'))#'>
                </cfstoredproc>
                
                <cfscript>
					ret_ro_item = this.romaneio_item_viagem(viagem_id = arguments.VIAGEM_ID);
				</cfscript>
				<cfif ret_ro_item.erro>
					<cfthrow object="#ret_ro_item.mensagem#">
				</cfif>
                
                <cfscript>
					ret_itiner = this.gerar_itinerario_viagem(viagem_id = arguments.VIAGEM_ID);
				</cfscript>
				<cfif ret_itiner.erro>
					<cfthrow object="#ret_itiner.mensagem#">
				</cfif>
                   
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Veculo destinado com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
    
     <!--- 
	-- PROPSITO
	-- Gerar o itinerrio da viagem.
	-- FABIOG 10/03/2011 15:40:31 - CRIADO
	--->
    <cffunction name='gerar_itinerario_viagem' displayname='Gerar o itinerrio da viagem.' access='remote' returntype='Struct' output='true'>
        <cfargument name='VIAGEM_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='logistica.pkg_agendamento.prc_gerar_itinerario_viagem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VIAGEM_ID'  value='#arguments.VIAGEM_ID#'  null='#iif(len(trim(arguments.VIAGEM_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Itinerrio gerado com sucesso.')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Gerar o romaneio
	-- FABIOG 10/03/2011 15:49:45 - CRIADO
	--->
    <cffunction name='romaneio_item_viagem' displayname='Gerar o romaneio' access='remote' returntype='Struct' output='true'>
        <cfargument name='VIAGEM_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='logistica.pkg_agendamento.prc_romaneio_item_viagem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VIAGEM_ID'  value='#arguments.VIAGEM_ID#'  null='#iif(len(trim(arguments.VIAGEM_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Romaneio gerado com sucesso.')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Enviar e-mail(s) de ordem de carregamento
    -- FABIOG 08/04/2011 10:22:12 - CRIADO
    --->
    <cffunction name='enviar_email_ordem_carregamento' displayname='Enviar E-mail(s)' access='remote' returntype='Struct' output='true'>
        <cfargument name='NUM_ROMANEIO' required='yes'>
        <cfargument name='ITEM_ID' required='yes'>
        <cfargument name='LISTA_EMAILS' required='yes'>
        <cftry>
        	<cftransaction action='begin'>
                <cfloop list="#arguments.ITEM_ID#" delimiters="," index="item_id">
                    <cfscript>
                        ret_email = this.enviar_ordem_carreg_email(NUM_ROMANEIO = arguments.NUM_ROMANEIO
														   		  ,ITEM_ID	    = item_id
														   		  ,LISTA_EMAILS = arguments.LISTA_EMAILS
																  );
                    </cfscript>
                    <cfif ret_email.erro>
                        <cfthrow object="#ret_email.mensagem#">
                    </cfif>
                </cfloop>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('E-mail(s) enviado(s) com sucesso.')>
			</cftransaction>
            <cfcatch>
            	<cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Gerar uma ordem de carregamento.
	-- FABIOG 08/04/2011 10:11:15 - CRIADO
	--->
	<cffunction name='gerar_ordem_carregamento' displayname='Gerar uma ordem de carregamento.' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_ROMANEIO' required='yes'>
		<cfargument name='ITEM_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_ordem_carregamento.prc_gerar_ordem_carregamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_BLOB' dbvarname='P_ARQUIVO' variable='retorno.ARQUIVO' >
				</cfstoredproc>
				<cfset retorno.erro = false>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Enviar uma ordem de carregamento por e-mail.
	-- FABIOG 08/04/2011 10:15:53 - CRIADO
	--->
	<cffunction name='enviar_ordem_carreg_email' displayname='Enviar uma ordem de carregamento por e-mail.' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_ROMANEIO' required='yes'>
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='LISTA_EMAILS' required='yes'>
		<cftry>
                <cfstoredproc procedure='oper.pkg_ordem_carregamento.prc_enviar_ordem_carreg_email' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_LISTA_EMAILS'  value='#arguments.LISTA_EMAILS#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('E-mail enviado com sucesso.')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
		<cfreturn retorno />
	</cffunction>
</cfcomponent>