<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO
	-- Gera uma quantidade de senhas de liberao
	-- ANDERSONC 23/06/2010 17:30:05 - CRIADO
	--->
	<cffunction name='gerar_senha_liberacao' displayname='Gera uma quantidade de senhas de liberao de carta frete' access='remote' returntype='Struct' output='true'>
		<cfargument name='QUANTIDADE_SENHAS' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_controle_liberacao.prc_gerar_senha_liberacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QUANTIDADE_SENHAS'  value='#arguments.QUANTIDADE_SENHAS#'  null='#iif(len(trim(arguments.QUANTIDADE_SENHAS)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Senha(s) gerada(s) com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
    <!--- 
	-- PROPSITO
	-- Cancela uma senha de liberao
	-- ANDERSONC 23/06/2010 17:31:26 - CRIADO
	--->
	<cffunction name='cancelar_senha_liberacao' displayname='Cancela uma senha de liberao de carta frete' access='remote' returntype='Struct' output='true'>
		<cfargument name='SENHA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_controle_liberacao.prc_cancelar_senha_liberacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SENHA_ID'  value='#arguments.SENHA_ID#'  null='#iif(len(trim(arguments.SENHA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Senha cancelada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
</cfcomponent>