<!-- KM&M Componentes -->
<cfcomponent displayname="Controle e manipulação de mensagens" extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPÓSITO
    -- Enviar mensagem para o totem
    -- ERICG 04/01/2011 14:25:15 - CRIADO
    --->
    <cffunction name='envia_mensagem' displayname='Enviar mensagem para o totem' access='remote' returntype='Struct' output='true'>
        <cfargument name='ASSUNTO'            required='yes'>
        <cfargument name='MENSAGEM'           required='yes'>
        <cfargument name='LISTA_COD_REGISTRO' required='yes'>
        <cfargument name='GRUPO_ID' 		  required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_totem_mensagem.prc_envia_mensagem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' 	  		dbvarname='P_ASSUNTO'  			  value='#arguments.ASSUNTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' 		dbvarname='P_MENSAGEM'  		  value='#arguments.MENSAGEM#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' 	  		dbvarname='P_LISTA_COD_REGISTRO'  value='#arguments.LISTA_COD_REGISTRO#' null='#iif(len(trim(arguments.LISTA_COD_REGISTRO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_GRUPO_ID'  		  value='#arguments.GRUPO_ID#'  null='#iif(len(trim(arguments.GRUPO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Mensagem enviada com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
	<!--- 
    -- PROPÓSITO
    -- Cancelar mensagem para o totem
    -- ERICG 04/01/2011 14:40:35 - CRIADO
    --->
    <cffunction name='cancela_mensagem' displayname='Cancelar mensagem para o totem' access='remote' returntype='Struct' output='true'>
        <cfargument name='TOTEM_MENSAGEM_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_totem_mensagem.prc_cancela_mensagem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TOTEM_MENSAGEM_ID'  value='#arguments.TOTEM_MENSAGEM_ID#'  null='#iif(len(trim(arguments.TOTEM_MENSAGEM_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Mensagem cancelada com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
</cfcomponent>