<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!---
	-- PROPSITO
	-- Inserir Tipo de Treinemanto
	-- LEOPOLDOS 08/06/2010 16:27:24 - CRIADO
	--->
	<cffunction name='ins_mot_treinamento_tipo' displayname='Inserir Tipo de Treinemanto' access='remote' returntype='Struct' output='true'>
        <cfargument name='DESCRICAO' required='yes'>
        <cfargument name='CARGA_HORARIA' required='yes'>
        <cfargument name='PERIODICIDADE' required='yes'>
        <cfargument name='TREINAMENTO_TIPO_ID' required='yes'>
        <cfargument name='CARGA_HORARIA_MINUTOS' required='yes'>
        <cfargument name='SITUACAO' required='yes'>
        <cfargument name='TREINAMENTO_OBRIGATORIO' required='no' default="0">
        <cfargument name='PAUTA' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_motorista_treinamento.prc_ins_mot_treinamento_tipo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CARGA_HORARIA#'  null='#iif(len(trim(arguments.CARGA_HORARIA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PERIODICIDADE#'  null='#iif(len(trim(arguments.PERIODICIDADE)), de('no'), de('yes'))#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TREINAMENTO_TIPO_ID#' variable='retorno.TREINAMENTO_TIPO_ID'  null='#iif(len(trim(arguments.TREINAMENTO_TIPO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CARGA_HORARIA_MINUTOS#'  null='#iif(len(trim(arguments.CARGA_HORARIA_MINUTOS)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SITUACAO#'  null='#iif(len(trim(arguments.SITUACAO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TREINAMENTO_OBRIGATORIO#'  null='#iif(len(trim(arguments.TREINAMENTO_OBRIGATORIO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PAUTA#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tipo de Treinamento inserido com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Alterar Tipo de Treinemanto
	-- LEOPOLDOS 08/06/2010 16:29:52 - CRIADO
	--->
	<cffunction name='upd_mot_treinamento_tipo' displayname='Alterar Tipo de Treinemanto' access='remote' returntype='Struct' output='true'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='CARGA_HORARIA' required='yes'>
		<cfargument name='PERIODICIDADE' required='yes'>
		<cfargument name='TREINAMENTO_TIPO_ID' required='yes'>
		<cfargument name='CARGA_HORARIA_MINUTOS' required='yes'>
		<cfargument name='SITUACAO' required='yes'>
		<cfargument name='TREINAMENTO_OBRIGATORIO' required='no' default="0">
        <cfargument name='PAUTA' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_motorista_treinamento.prc_alt_mot_treinamento_tipo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CARGA_HORARIA#'  null='#iif(len(trim(arguments.CARGA_HORARIA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PERIODICIDADE#'  null='#iif(len(trim(arguments.PERIODICIDADE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TREINAMENTO_TIPO_ID#'  null='#iif(len(trim(arguments.TREINAMENTO_TIPO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CARGA_HORARIA_MINUTOS#'  null='#iif(len(trim(arguments.CARGA_HORARIA_MINUTOS)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SITUACAO#'  null='#iif(len(trim(arguments.SITUACAO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TREINAMENTO_OBRIGATORIO#'  null='#iif(len(trim(arguments.TREINAMENTO_OBRIGATORIO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PAUTA#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tipo de Treinamento alterado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Deletar Tipo de Treinemanto
	-- LEOPOLDOS 08/06/2010 16:30:54 - CRIADO
	--->
	<cffunction name='del_mot_treinamento_tipo' displayname='Deletar Tipo de Treinemanto' access='remote' returntype='Struct' output='true'>
		<cfargument name='TREINAMENTO_TIPO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_motorista_treinamento.prc_del_mot_treinamento_tipo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TREINAMENTO_TIPO_ID#'  null='#iif(len(trim(arguments.TREINAMENTO_TIPO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tipo de Treinamento apagado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Inserir um treinamento.
	-- LEOPOLDOS 09/06/2010 08:45:00 - CRIADO
	--->
	<cffunction name='ins_mot_treinamento' displayname='Inserir um treinamento.' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_PESSOA_INSTRUTOR' required='yes'>
		<cfargument name='COD_PESSOA_INSTRUTOR_2' required='yes'>
		<cfargument name='COD_PESSOA_RESP_TECNICO' required='yes'>
		<cfargument name='ITEM_NORMA' required='yes'>
		<cfargument name='LOCAL' required='yes'>
		<cfargument name='DATA_INICIO' required='yes'>
		<cfargument name='DATA_TERMINO' required='yes'>
		<cfargument name='TREINAMENTO_TIPO_ID' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
        <cfargument name='COD_UNIDADE_NEGOCIO' required='yes'>
        <cfargument name='COD_DEPARTAMENTO' required='yes'>
        <cfargument name='COD_SETOR' required='yes'>
        <cfargument name='COD_CENTRO_CUSTO' required='yes'>
		<cfargument name='TREINAMENTO_ID' required='yes'>
        <cfargument name='PAUTA' required='no'>
		<cfargument name='CARGA_HORARIA' required='no'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_motorista_treinamento.prc_ins_mot_treinamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_INSTRUTOR#'  null='#iif(len(trim(arguments.COD_PESSOA_INSTRUTOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_INSTRUTOR_2#'  null='#iif(len(trim(arguments.COD_PESSOA_INSTRUTOR_2)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_RESP_TECNICO#'  null='#iif(len(trim(arguments.COD_PESSOA_RESP_TECNICO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5'   value='#arguments.ITEM_NORMA#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5'   value='#arguments.LOCAL#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_INICIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_TERMINO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TREINAMENTO_TIPO_ID#'  null='#iif(len(trim(arguments.TREINAMENTO_TIPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OBSERVACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='#arguments.COD_UNIDADE_NEGOCIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='#arguments.COD_DEPARTAMENTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='#arguments.COD_SETOR#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='#arguments.COD_CENTRO_CUSTO#' >
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TREINAMENTO_ID#' variable='retorno.TREINAMENTO_ID'  null='#iif(len(trim(arguments.TREINAMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  value='#arguments.PAUTA#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  value='#arguments.CARGA_HORARIA#' >
				</cfstoredproc>
                    <!--- Insero de Participantes --->
					<cfscript>
						v_cod_pessoa_participante = this.ListaToArray(lista = arguments, variavel = 'COD_PESSOA_PARTICIPANTE_PARTICIPANTE');
                    </cfscript>

                    <cfloop from="1" to="#ArrayLen(v_cod_pessoa_participante)#" index="count">
                        <cfscript>
                            ret_particip = ins_mot_trein_participante(TREINAMENTO_ID = retorno.TREINAMENTO_ID
							                                         ,COD_PESSOA     = v_cod_pessoa_participante[count]
                                                                     );
                        </cfscript>
                        <cfif ret_particip.erro>
                            <cfthrow object="#ret_particip.mensagem#">
                        </cfif>
                    </cfloop>

				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Treinamento inserido com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Alterar um treinamento.
	-- LEOPOLDOS 09/06/2010 08:47:35 - CRIADO
	--->
	<cffunction name='upd_mot_treinamento' displayname='Alterar um treinamento.' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_PESSOA_INSTRUTOR' required='yes'>
		<cfargument name='COD_PESSOA_INSTRUTOR_2' required='yes'>
		<cfargument name='COD_PESSOA_RESP_TECNICO' required='yes'>
		<cfargument name='ITEM_NORMA' required='yes'>
		<cfargument name='LOCAL' required='yes'>
		<cfargument name='DATA_INICIO' required='yes'>
		<cfargument name='DATA_TERMINO' required='yes'>
		<cfargument name='TREINAMENTO_TIPO_ID' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
        <cfargument name='COD_UNIDADE_NEGOCIO' required='yes'>
        <cfargument name='COD_DEPARTAMENTO' required='yes'>
        <cfargument name='COD_SETOR' required='yes'>
        <cfargument name='COD_CENTRO_CUSTO' required='yes'>
		<cfargument name='TREINAMENTO_ID' required='yes'>
        <cfargument name='PAUTA' required='no'>
		<cfargument name='CARGA_HORARIA' required='no'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_motorista_treinamento.prc_alt_mot_treinamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_INSTRUTOR#'  null='#iif(len(trim(arguments.COD_PESSOA_INSTRUTOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_INSTRUTOR_2#'  null='#iif(len(trim(arguments.COD_PESSOA_INSTRUTOR_2)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_RESP_TECNICO#'  null='#iif(len(trim(arguments.COD_PESSOA_RESP_TECNICO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5'   value='#arguments.ITEM_NORMA#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5'   value='#arguments.LOCAL#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_INICIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_TERMINO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TREINAMENTO_TIPO_ID#'  null='#iif(len(trim(arguments.TREINAMENTO_TIPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OBSERVACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='#arguments.COD_UNIDADE_NEGOCIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='#arguments.COD_DEPARTAMENTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='#arguments.COD_SETOR#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='#arguments.COD_CENTRO_CUSTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TREINAMENTO_ID#'  null='#iif(len(trim(arguments.TREINAMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  value='#arguments.PAUTA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  value='#arguments.CARGA_HORARIA#' >
				</cfstoredproc>
                    <!--- Insero de Participantes --->
					<cfscript>
                        v_mot_trein_participante_id = this.ListaToArray(lista = arguments, variavel = 'MOT_TREIN_PARTICIPANTE_ID_PARTICIPANTE');
						v_cod_pessoa_participante   = this.ListaToArray(lista = arguments, variavel = 'COD_PESSOA_PARTICIPANTE_PARTICIPANTE');
						v_excluir	        		= this.ListDiff(lista1 = lista_deleted_PARTICIPANTE, lista2 = ArrayToList(v_mot_trein_participante_id));
                    </cfscript>

                    <cfloop list="#v_excluir#" delimiters="," index="c_id">
						<cfscript>
                            ret_excluir = this.del_mot_trein_participante(MOT_TREIN_PARTICIPANTE_ID = c_id);
                        </cfscript>
                        <cfif ret_excluir.erro>
                            <cfthrow object="#ret_excluir.mensagem#">
                        </cfif>
                    </cfloop>

                    <cfloop from="1" to="#ArrayLen(v_mot_trein_participante_id)#" index="count">
                        <cfscript>
                            if(Not Len(Trim(v_mot_trein_participante_id[count]))) {
								ret_particip = ins_mot_trein_participante(TREINAMENTO_ID = arguments.TREINAMENTO_ID
																		, COD_PESSOA     = v_cod_pessoa_participante[count]
																		 );
							}
							else{
								ret_particip = upd_mot_trein_participante(MOT_TREIN_PARTICIPANTE_ID = v_mot_trein_participante_id[count]
								                                        , TREINAMENTO_ID            = arguments.TREINAMENTO_ID
																		, COD_PESSOA                = v_cod_pessoa_participante[count]
                                                                     );
							}
                        </cfscript>
                        <cfif ret_particip.erro>
                            <cfthrow object="#ret_particip.mensagem#">
                        </cfif>
                    </cfloop>

				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Treinamento alterado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    <!---
	-- PROPSITO
	-- Deletar um treinamento.
	-- LEOPOLDOS 09/06/2010 08:48:46 - CRIADO
	--->
	<cffunction name='del_mot_treinamento' displayname='Deletar um treinamento.' access='remote' returntype='Struct' output='true'>
		<cfargument name='TREINAMENTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_motorista_treinamento.prc_del_mot_treinamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TREINAMENTO_ID#'  null='#iif(len(trim(arguments.TREINAMENTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Treinamento apagado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
    -- PROPSITO
    -- Inserir instrutor de treinamento
    -- LEANDROR 09/06/2010 16:31:10 - CRIADO
    --->
    <cffunction name='ins_instrutor' displayname='Inserir instrutor de treinamento' access='remote' returntype='Struct' output='true'>
        <cfargument name='COD_PESSOA_INSTRUTOR' required='yes'>
		<cfargument name='CARGO' required='yes'>
		<cfargument name='REGISTRO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_motorista_treinamento.prc_ins_mot_treina_instrutor' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_INSTRUTOR#'  null='#iif(len(trim(arguments.COD_PESSOA_INSTRUTOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5'   value='#arguments.CARGO#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5'   value='#arguments.REGISTRO#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
                </cfstoredproc>

                <!--- Insero de Treinamentos --->
					<cfscript>
                        v_treinamento_tipo_id 	 = this.ListaToArray(lista = arguments, variavel = 'TREINAMENTO_TIPO_ID');
                    </cfscript>

                    <cfloop from="1" to="#ArrayLen(v_treinamento_tipo_id)#" index="count">
                        <cfscript>
                            ret = this.ins_instrutor_treinamento(COD_PESSOA_INSTRUTOR = arguments.COD_PESSOA_INSTRUTOR,
                                                                 TREINAMENTO_TIPO_ID  = v_treinamento_tipo_id[count]
                                                                 );
                        </cfscript>
                        <cfif ret.erro>
                            <cfthrow object="#ret.mensagem#">
                        </cfif>
                    </cfloop>

                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Instrutor inserido com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
    -- PROPSITO
    -- Alterar instrutor de treinamento
    -- LEANDROR 09/06/2010 16:31:10 - CRIADO
    --->
    <cffunction name='alt_instrutor' displayname='Inserir instrutor de treinamento' access='remote' returntype='Struct' output='true'>
        <cfargument name='COD_PESSOA_INSTRUTOR' required='yes'>
		<cfargument name='CARGO' required='yes'>
		<cfargument name='REGISTRO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_motorista_treinamento.prc_ins_mot_treina_instrutor' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_INSTRUTOR#'  null='#iif(len(trim(arguments.COD_PESSOA_INSTRUTOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5'   value='#arguments.CARGO#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5'   value='#arguments.REGISTRO#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
                </cfstoredproc>

				<!--- Insero de Treinamentos --->
				<cfscript>
                    v_treinamento_tipo_id 	= this.ListaToArray(lista = arguments, variavel = 'TREINAMENTO_TIPO_ID');
                    v_inserido 	 			= this.ListaToArray(lista = arguments, variavel = 'INSERIDO');
                    v_excluir	        	= this.ListDiff(lista1 = lista_deleted_TREINAMENTOS, lista2 = ArrayToList(v_treinamento_tipo_id));
                </cfscript>

                <cfloop list="#v_excluir#" delimiters="," index="c_id">
                    <cfscript>
                        ret_del = this.del_instrutor_treinamento(COD_PESSOA_INSTRUTOR = arguments.COD_PESSOA_INSTRUTOR,
                                                                 TREINAMENTO_TIPO_ID  = c_id);
                    </cfscript>
                    <cfif ret_del.erro>
                        <cfthrow object="#ret_del.mensagem#">
                    </cfif>
                </cfloop>

                <cfloop from="1" to="#ArrayLen(v_treinamento_tipo_id)#" index="count">
                    <cfscript>
                        if(v_inserido[count] neq 1){
                            ret_ins = this.ins_instrutor_treinamento(COD_PESSOA_INSTRUTOR = arguments.COD_PESSOA_INSTRUTOR,
                                                                     TREINAMENTO_TIPO_ID  = v_treinamento_tipo_id[count]);
                        }
                    </cfscript>
                    <cfif v_inserido[count] neq 1 and ret_ins.erro>
                        <cfthrow object="#ret_ins.mensagem#">
                    </cfif>
                </cfloop>

                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Instrutor alterado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!---
    -- PROPSITO
    -- Excluir instrutor de treinamento
    -- LEANDROR 09/06/2010 16:35:50 - CRIADO
    --->
    <cffunction name='del_instrutor' displayname='Excluir instrutor de treinamento' access='remote' returntype='Struct' output='true'>
        <cfargument name='COD_PESSOA_INSTRUTOR' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_motorista_treinamento.prc_del_mot_treina_instrutor' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_INSTRUTOR#'  null='#iif(len(trim(arguments.COD_PESSOA_INSTRUTOR)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Instrutor excluido com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
	-- PROPSITO
	-- Inserir os treinamentos do instrutor
	-- LEANDROR 10/06/2010 11:13:09 - CRIADO
	--->
	<cffunction name='ins_instrutor_treinamento' displayname='Inserir os treinamentos do instrutor' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_PESSOA_INSTRUTOR' required='yes'>
		<cfargument name='TREINAMENTO_TIPO_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='oper.pkg_motorista_treinamento.prc_ins_mot_treina_instr_tipo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_INSTRUTOR#'  null='#iif(len(trim(arguments.COD_PESSOA_INSTRUTOR)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TREINAMENTO_TIPO_ID#'  null='#iif(len(trim(arguments.TREINAMENTO_TIPO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Excluir os treinamentos do instrutor
	-- LEANDROR 10/06/2010 16:24:21 - CRIADO
	--->
	<cffunction name='del_instrutor_treinamento' displayname='Excluir os treinamentos do instrutor' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_PESSOA_INSTRUTOR' required='yes'>
		<cfargument name='TREINAMENTO_TIPO_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='oper.pkg_motorista_treinamento.prc_del_mot_treina_instr_tipo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_INSTRUTOR#'  null='#iif(len(trim(arguments.COD_PESSOA_INSTRUTOR)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TREINAMENTO_TIPO_ID#'  null='#iif(len(trim(arguments.TREINAMENTO_TIPO_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Inserir participantes em um treinamento
	-- RAFAEL 07/12/2012 10:48:34 - CRIADO
	--->
	<cffunction name='ins_mot_trein_participante' displayname='Inserir participantes em um treinamento' access='remote' returntype='Struct' output='true'>
		<cfargument name='TREINAMENTO_ID' required='yes'>
		<cfargument name='COD_PESSOA' required='yes'>
		<cftry>
				<cfstoredproc procedure='oper.pkg_motorista_treinamento.prc_ins_mot_trein_participante' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.MOT_TREIN_PARTICIPANTE_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TREINAMENTO_ID#'  null='#iif(len(trim(arguments.TREINAMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Alterar participantes em um treinamento
	-- RAFAEL 07/12/2012 10:49:20 - CRIADO
	--->
	<cffunction name='upd_mot_trein_participante' displayname='Alterar participantes em um treinamento' access='remote' returntype='Struct' output='true'>
		<cfargument name='MOT_TREIN_PARTICIPANTE_ID' required='yes'>
		<cfargument name='TREINAMENTO_ID' required='yes'>
		<cfargument name='COD_PESSOA' required='yes'>
		<cftry>
				<cfstoredproc procedure='oper.pkg_motorista_treinamento.prc_alt_mot_trein_participante' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MOT_TREIN_PARTICIPANTE_ID#'  null='#iif(len(trim(arguments.MOT_TREIN_PARTICIPANTE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TREINAMENTO_ID#'  null='#iif(len(trim(arguments.TREINAMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Excluir participantes de um treinamento
	-- RAFAEL 07/12/2012 10:50:37 - CRIADO
	--->
	<cffunction name='del_mot_trein_participante' displayname='Excluir participantes de um treinamento' access='remote' returntype='Struct' output='true'>
		<cfargument name='MOT_TREIN_PARTICIPANTE_ID' required='yes'>
		<cftry>
				<cfstoredproc procedure='oper.pkg_motorista_treinamento.prc_del_mot_trein_participante' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MOT_TREIN_PARTICIPANTE_ID#'  null='#iif(len(trim(arguments.MOT_TREIN_PARTICIPANTE_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
    -- PROPSITO
    -- Avaliao de treinamento
    -- MARIALICE 28/02/2013 16:59:13 - CRIADO
    --->
    <cffunction name='avaliar_treinamento' displayname='Avaliao de treinamento' access='remote' returntype='Struct' output='true'>
        <cfargument name='TREINAMENTO_ID' required='yes'>
        <cfargument name='AVALIACAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_motorista_treinamento.prc_avaliar_treinamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TREINAMENTO_ID#' variable='retorno.TREINAMENTO_ID'  null='#iif(len(trim(arguments.TREINAMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.AVALIACAO#' variable='retorno.AVALIACAO'  null='#iif(len(trim(arguments.AVALIACAO)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Treinamento avaliado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
    -- PROPSITO
    -- Avaliao de participante
    -- 10/12/2014 09:51 - CRIADO
    --->
    <cffunction name='ins_avaliar_participante' displayname='Avaliao de participante' access='remote' returntype='Struct' output='true'>
        <cfargument name='MOT_TREIN_PART_AVALIACAO_ID' required='yes'>
        <cfargument name='AVALIACAO_PARTICIPANTE' required='yes'>
        <cfargument name='TEXT_MOTIVO' required='no'>
        <cfargument name='TEXT_PLANO_ACAO' required='no'>
        <cfargument name='TEXT_RESULTADO_OBTIDO' required='no'>
        <cfargument name='MOT_TREIN_PARTICIPANTE_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_motorista_treinamento.prc_ins_mot_trein_part_aval' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MOT_TREIN_PART_AVALIACAO_ID#' variable='retorno.MOT_TREIN_PART_AVALIACAO_ID'  null='#iif(len(trim(arguments.MOT_TREIN_PART_AVALIACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.AVALIACAO_PARTICIPANTE#' variable='retorno.AVALIACAO_PARTICIPANTE'  null='#iif(len(trim(arguments.AVALIACAO_PARTICIPANTE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5'   value='#arguments.TEXT_MOTIVO#' variable='retorno.TEXT_MOTIVO'  null='#iif(len(trim(arguments.TEXT_MOTIVO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5'   value='#arguments.TEXT_PLANO_ACAO#' variable='retorno.TEXT_PLANO_ACAO'  null='#iif(len(trim(arguments.TEXT_PLANO_ACAO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5'   value='#arguments.TEXT_RESULTADO_OBTIDO#' variable='retorno.TEXT_RESULTADO_OBTIDO	'  null='#iif(len(trim(arguments.TEXT_RESULTADO_OBTIDO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MOT_TREIN_PARTICIPANTE_ID#' variable='retorno.MOT_TREIN_PARTICIPANTE_ID'  null='#iif(len(trim(arguments.MOT_TREIN_PARTICIPANTE_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Participante avaliado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
	
    <!--- 
    -- PROPSITO
    -- Edita Avaliao de participante
    -- 04/10/2017 CRIADO
    --->
    <cffunction name='upd_avaliar_participante' displayname='Avaliao de participante' access='remote' returntype='Struct' output='true'>
        <cfargument name='MOT_TREIN_PART_AVALIACAO_ID' required='yes'>
        <cfargument name='AVALIACAO_PARTICIPANTE' required='yes'>
        <cfargument name='TEXT_MOTIVO' required='no'>
        <cfargument name='TEXT_PLANO_ACAO' required='no'>
        <cfargument name='TEXT_RESULTADO_OBTIDO' required='no'>
        <cfargument name='MOT_TREIN_PARTICIPANTE_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_motorista_treinamento.prc_alt_mot_trein_part_aval' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MOT_TREIN_PART_AVALIACAO_ID#' variable='retorno.MOT_TREIN_PART_AVALIACAO_ID'  null='#iif(len(trim(arguments.MOT_TREIN_PART_AVALIACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.AVALIACAO_PARTICIPANTE#' variable='retorno.AVALIACAO_PARTICIPANTE'  null='#iif(len(trim(arguments.AVALIACAO_PARTICIPANTE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5'   value='#arguments.TEXT_MOTIVO#' variable='retorno.TEXT_MOTIVO'  null='#iif(len(trim(arguments.TEXT_MOTIVO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5'   value='#arguments.TEXT_PLANO_ACAO#' variable='retorno.TEXT_PLANO_ACAO'  null='#iif(len(trim(arguments.TEXT_PLANO_ACAO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5'   value='#arguments.TEXT_RESULTADO_OBTIDO#' variable='retorno.TEXT_RESULTADO_OBTIDO	'  null='#iif(len(trim(arguments.TEXT_RESULTADO_OBTIDO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MOT_TREIN_PARTICIPANTE_ID#' variable='retorno.MOT_TREIN_PARTICIPANTE_ID'  null='#iif(len(trim(arguments.MOT_TREIN_PARTICIPANTE_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Participante avaliado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<cffunction name='gerar_certificado' displayname='Gerar certificado de treinamento' access='remote' returntype='Struct' output='true'>
		<cfargument name='TREINAMENTO_ID' required='yes'>
		<cfargument name='COD_PESSOA_PARTICIPANTE' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_motorista_treinamento.prc_imprime_certificado' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_BLOB'  variable='retorno.ARQUIVO' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TREINAMENTO_ID#'  null='#iif(len(trim(arguments.TREINAMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_PARTICIPANTE#'  null='#iif(len(trim(arguments.COD_PESSOA_PARTICIPANTE)), de('no'), de('yes'))#'>
				</cfstoredproc>
                <cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Certificado gerado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
</cfcomponent>
