<cfcomponent extends="_transportes.funcoes.cfc_init">

	<!--- 
    -- PROPSITO
    -- Gera controle para todos os holerites criados no mes
    -- guto 09/01/2009 11:36:09 - CRIADO
    --->
    <cffunction name='prc_gera_controle_holerite' displayname='Gera controle para todos os holerites criados no mes' access='remote' returntype='Struct' output='true'>
        <cfargument name='MES_ANO_INICIO' required='yes'>
        <cfargument name='MES_ANO_FIM' required='yes'>
        <cfargument name='MES' required='no' default="">
        <cfargument name='ANO' required='no' default="">
        <cfargument name='GERAR_CONTROLE' required='no' default="0">
        <cftry>
            <cftransaction action='begin'>
                    <cfstoredproc procedure='rh.pkg_holerite_controle.prc_periodo_liberado_holerite' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                        <cfprocparam type='IN' cfsqltype='cf_sql_varchar' dbvarname='P_MES_ANO_INICIO' value='#arguments.MES_ANO_INICIO#'  null='#iif(len(trim(arguments.MES_ANO_INICIO)), de('no'), de('yes'))#'>
                        <cfprocparam type='IN' cfsqltype='cf_sql_varchar' dbvarname='P_MES_ANO_FIM' value='#arguments.MES_ANO_FIM#'  null='#iif(len(trim(arguments.MES_ANO_FIM)), de('no'), de('yes'))#'>
                    </cfstoredproc>            	 
                <cfif arguments.GERAR_CONTROLE EQ 1>	
                    <cfstoredproc procedure='rh.pkg_holerite_controle.prc_gerar_controle' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MES'  value='#arguments.MES#'  null='#iif(len(trim(arguments.MES)), de('no'), de('yes'))#'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ANO'  value='#arguments.ANO#'  null='#iif(len(trim(arguments.ANO)), de('no'), de('yes'))#'>
                    </cfstoredproc>
                </cfif>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Controles gerados com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!--- 
    -- PROPSITO
    -- Exclui controle para todos os holerites criados no mes
    -- guto 09/01/2009 11:39:40 - CRIADO
    --->
    <cffunction name='prc_exclui_controle_holerite' displayname='Exclui controle para todos os holerites criados no mes' access='remote' returntype='Struct' output='true'>
        <cfargument name='MES' required='yes'>
        <cfargument name='ANO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='rh.pkg_holerite_controle.prc_exclui_controle' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MES'  value='#arguments.MES#'  null='#iif(len(trim(arguments.MES)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ANO'  value='#arguments.ANO#'  null='#iif(len(trim(arguments.ANO)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Controles excludos com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 	
    -- PROPSITO
    -- Exclui controle
    -- guto 09/01/2009 11:41:18 - CRIADO
    --->
    <cffunction name='prc_del_rh_holerite_controle' displayname='Exclui controle' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTROLE_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='rh.pkg_holerite_controle.prc_del_rh_holerite_controle' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Controle excludo com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Marca controle como aberto
    -- guto 09/01/2009 11:42:22 - CRIADO
    --->
    <cffunction name='prc_rh_holerite_aberto' displayname='Marca controle como emitido' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTROLE_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='rh.pkg_holerite_controle.prc_rh_holerite_aberto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Recibo reaberto com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset retorno.mensagem_str = cfcatch.Detail>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction> 
    
	<!--- 
    -- PROPSITO
    -- Marca controle como emitido
    -- guto 09/01/2009 11:42:22 - CRIADO
    --->
    <cffunction name='prc_rh_holerite_emitido' displayname='Marca controle como emitido' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTROLE_ID' required='yes'>
        <cfargument name='COD_FILIAL_EMISSAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='rh.pkg_holerite_controle.prc_rh_holerite_emitido' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_FILIAL_EMISSAO'  value='#arguments.COD_FILIAL_EMISSAO#'  null='#iif(len(trim(arguments.COD_FILIAL_EMISSAO)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Recibo emitido com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Marca controle como arquivado
    -- guto 09/01/2009 11:52:01 - CRIADO
    --->
    <cffunction name='prc_rh_holerite_arquivado' displayname='Marca controle como arquivado' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTROLE_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
            	<cfloop list="#arguments.CONTROLE_ID#" index="i">
                    <cfstoredproc procedure='rh.pkg_holerite_controle.prc_rh_holerite_arquivado' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID'  value='#i#'>
                    </cfstoredproc>
                </cfloop>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Recibo arquivado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Marca controle como cancelado
    -- guto 09/01/2009 11:52:40 - CRIADO
    --->
    <cffunction name='prc_rh_holerite_cancelado' displayname='Marca controle como cancelado' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTROLE_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='rh.pkg_holerite_controle.prc_rh_holerite_cancelado' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Recibo cancelado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Gera todos os holerites do funcionrio
    -- ANDERSONC 04/08/2009 14:41:16 - ALTERADO
    --->
    <cffunction name='prc_gera_holerites' displayname='Marca controle como cancelado' access='remote' returntype='Struct' output='true'>
        <cfargument name='COD_FUNCIONARIO' required='yes'>
		<cfargument name='COD_RECIBO_TIPO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='rh.pkg_holerite_controle.prc_gerar_controle_funcionario' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_FUNCIONARIO'  value='#arguments.COD_FUNCIONARIO#'  null='#iif(len(trim(arguments.COD_FUNCIONARIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_RECIBO_TIPO'  value='#arguments.COD_RECIBO_TIPO#'  null='#iif(len(trim(arguments.COD_RECIBO_TIPO)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Holerites gerados com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>      
</cfcomponent>