<cfcomponent extends="_transportes.funcoes.cfc_init">
    <!--- 
	-- PROPSITO
	-- Insere uma atividade
	-- ANDERSONC 30/03/2011 16:40:46 - CRIADO
	--->
	<cffunction name='ins_atividade' displayname='Insere uma atividade' access='remote' returntype='Struct' output='true'>
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='qualidade.pkg_controle_registro.prc_ins_atividade' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATIVIDADE_ID' variable='retorno.ATIVIDADE_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Atividade inserida com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Altera uma atividade
	-- ANDERSONC 30/03/2011 16:45:19 - CRIADO
	--->
	<cffunction name='upd_atividade' displayname='Altera uma atividade' access='remote' returntype='Struct' output='true'>
		<cfargument name='ATIVIDADE_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='qualidade.pkg_controle_registro.prc_alt_atividade' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATIVIDADE_ID'  value='#arguments.ATIVIDADE_ID#'  null='#iif(len(trim(arguments.ATIVIDADE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Atividade alterada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Exclui uma atividade
	-- ANDERSONC 30/03/2011 16:46:39 - CRIADO
	--->
	<cffunction name='del_atividade' displayname='Exclui uma atividade' access='remote' returntype='Struct' output='true'>
		<cfargument name='ATIVIDADE_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='qualidade.pkg_controle_registro.prc_del_atividade' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATIVIDADE_ID'  value='#arguments.ATIVIDADE_ID#'  null='#iif(len(trim(arguments.ATIVIDADE_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Atividade excluda com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Insere uma descrio de registro
	-- ANDERSONC 30/03/2011 16:54:08 - CRIADO
	--->
	<cffunction name='ins_registro_descricao' displayname='Insere uma descrio de registro' access='remote' returntype='Struct' output='true'>
		<cfargument name='TITULO' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='qualidade.pkg_controle_registro.prc_ins_registro_descricao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REGISTRO_DESCRICAO_ID' variable='retorno.REGISTRO_DESCRICAO_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Descrio de registro inserida com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
	<!--- 
    -- PROPSITO
    -- Altera uma descrio de registro
    -- ANDERSONC 30/03/2011 16:55:00 - CRIADO
    --->
    <cffunction name='upd_registro_descricao' displayname='Altera uma descrio de registro' access='remote' returntype='Struct' output='true'>
        <cfargument name='REGISTRO_DESCRICAO_ID' required='yes'>
        <cfargument name='TITULO' required='yes'>
        <cfargument name='DESCRICAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='qualidade.pkg_controle_registro.prc_alt_registro_descricao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REGISTRO_DESCRICAO_ID'  value='#arguments.REGISTRO_DESCRICAO_ID#'  null='#iif(len(trim(arguments.REGISTRO_DESCRICAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Descrio de registro alterada com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Exclui uma descrio de registro
    -- ANDERSONC 30/03/2011 16:55:42 - CRIADO
    --->
    <cffunction name='del_registro_descricao' displayname='Exclui uma descrio de registro' access='remote' returntype='Struct' output='true'>
        <cfargument name='REGISTRO_DESCRICAO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='qualidade.pkg_controle_registro.prc_del_registro_descricao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REGISTRO_DESCRICAO_ID'  value='#arguments.REGISTRO_DESCRICAO_ID#'  null='#iif(len(trim(arguments.REGISTRO_DESCRICAO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Descrio de registro excluda com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Insere um registro
	-- ANDERSONC 29/03/2011 13:55:07 - CRIADO
	--->
	<cffunction name='ins_registro' displayname='Insere um registro' access='remote' returntype='Struct' output='true'>
		<cfargument name='TIPO_REGISTRO_ID' required='yes'>
		<cfargument name='REGISTRO_ID_GERADOR' required='yes'>
		<cfargument name='CLASSIFICACAO_ID' required='yes'>
		<cfargument name='PRIORIDADE' required='yes'>
		<cfargument name='COD_CLIENTE' required='yes'>
        <cfargument name='AREA_ID' required='no'>
		<cfargument name='COD_ORGANOGRAMA' required='yes'>
		<cfargument name='COD_IDENTIFICACAO' required='yes'>
		<cfargument name='COD_RESPONSAVEL' required='yes'>
		<cfargument name='ATIVIDADE_ID' required='yes'>
		<cfargument name='DATA_IDENTIFICACAO' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='REGISTRO_DESCRICAO_ID' required="no" default="">
		<cfargument name='POSSIVEIS_CAUSAS' required='yes'>
		<cfargument name='SOLUCAO_APLICAVEL' required='yes'>        
        <cfargument name='DATA_PREVISAO' required='no' default="">
        <cfargument name='DATA_CONCLUSAO' required='no' default="">    
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='qualidade.pkg_controle_registro.prc_ins_registro' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REGISTRO_ID' variable='retorno.REGISTRO_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_REGISTRO_ID'  value='#arguments.TIPO_REGISTRO_ID#'  null='#iif(len(trim(arguments.TIPO_REGISTRO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REGISTRO_ID_GERADOR'  value='#arguments.REGISTRO_ID_GERADOR#'  null='#iif(len(trim(arguments.REGISTRO_ID_GERADOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CLASSIFICACAO_ID'  value='#arguments.CLASSIFICACAO_ID#'  null='#iif(len(trim(arguments.CLASSIFICACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRIORIDADE'  value='#arguments.PRIORIDADE#'  null='#iif(len(trim(arguments.PRIORIDADE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CLIENTE'  value='#arguments.COD_CLIENTE#'  null='#iif(len(trim(arguments.COD_CLIENTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_AREA_ID' value='#arguments.AREA_ID#' null='#iif(len(trim(arguments.AREA_ID)), de('no'), de('yes'))#'>
    				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_ORGANOGRAMA'  value='#arguments.COD_ORGANOGRAMA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_IDENTIFICACAO'  value='#arguments.COD_IDENTIFICACAO#'  null='#iif(len(trim(arguments.COD_IDENTIFICACAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_RESPONSAVEL'  value='#arguments.COD_RESPONSAVEL#'  null='#iif(len(trim(arguments.COD_RESPONSAVEL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATIVIDADE_ID'  value='#arguments.ATIVIDADE_ID#'  null='#iif(len(trim(arguments.ATIVIDADE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_IDENTIFICACAO'  value='#arguments.DATA_IDENTIFICACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_PREVISAO'  value='#arguments.DATA_PREVISAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_CONCLUSAO'  value='#arguments.DATA_CONCLUSAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DESCRICAO_ID' value='#arguments.REGISTRO_DESCRICAO_ID#' null='#iif(len(trim(arguments.REGISTRO_DESCRICAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_POSSIVEIS_CAUSAS'  value='#arguments.POSSIVEIS_CAUSAS#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SOLUCAO_APLICAVEL'  value='#arguments.SOLUCAO_APLICAVEL#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<!--- Anexos --->
                <cfscript>					
                    v_anexo_id 	   = this.ListaToArray(lista = arguments, variavel = 'ANEXO_ID_ANEXOS');
                    v_reg_anexo_id = this.ListaToArray(lista = arguments, variavel = 'REG_ANEXO_ID_ANEXOS');
                    v_ordem 	   = this.ListaToArray(lista = arguments, variavel = 'ANEXO_ORDEM_ANEXOS');
                    v_excluir  	   = this.ListDiff(lista1 = arguments.lista_deleted_ANEXOS, lista2 = ArrayToList(v_reg_anexo_id));
                </cfscript>
                <cfloop list="#v_excluir#" delimiters="," index="v_reg_anexo">
                    <cfscript>
                        this.del_registro_anexo (registro_anexo_id = v_reg_anexo);
                    </cfscript>
                </cfloop>
                <cfloop from="1" to="#ArrayLen(v_reg_anexo_id)#" index="count">
                    <cfscript>
                        if(not len(trim(v_reg_anexo_id[count]))) {
                            ret = this.ins_registro_anexo(registro_id = retorno.REGISTRO_ID,
                                                            anexo_id  = v_anexo_id[count],
                                                               ordem  = v_ordem[count]);
                        } else {
                            ret = this.upd_registro_anexo(registro_anexo_id  = v_reg_anexo_id[count],
                                                                registro_id  = retorno.REGISTRO_ID,
                                                                   anexo_id  = v_anexo_id[count],
                                                                      ordem  = v_ordem[count]);
                        }
                    </cfscript>
                     <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>    
                <!--- Fim Anexos --->  
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Registro n ' & retorno.REGISTRO_ID & ' inserido com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Altera um registro
	-- ANDERSONC 29/03/2011 14:03:09 - CRIADO
	--->
	<cffunction name='upd_registro' displayname='Altera um registro' access='remote' returntype='Struct' output='true'>
		<cfargument name='REGISTRO_ID' required='yes'>
		<cfargument name='TIPO_REGISTRO_ID' required='yes'>
		<cfargument name='REGISTRO_ID_GERADOR' required='yes'>
		<cfargument name='CLASSIFICACAO_ID' required='yes'>
		<cfargument name='PRIORIDADE' required='yes'>
		<cfargument name='COD_CLIENTE' required='yes'>
        <cfargument name='AREA_ID' required='no'>
		<cfargument name='COD_ORGANOGRAMA' required='yes'>
		<cfargument name='COD_IDENTIFICACAO' required='yes'>
		<cfargument name='COD_RESPONSAVEL' required='yes'>
		<cfargument name='ATIVIDADE_ID' required='yes'>
		<cfargument name='DATA_IDENTIFICACAO' required='yes'>   
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='REGISTRO_DESCRICAO_ID' required='no' default="">
		<cfargument name='POSSIVEIS_CAUSAS' required='yes'>
		<cfargument name='SOLUCAO_APLICAVEL' required='yes'>
        <cfargument name='DATA_PREVISAO' required='no' default=''> 
        <cfargument name='DATA_CONCLUSAO' required='no' default='' >   
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='qualidade.pkg_controle_registro.prc_alt_registro' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REGISTRO_ID'  value='#arguments.REGISTRO_ID#'  null='#iif(len(trim(arguments.REGISTRO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_REGISTRO_ID'  value='#arguments.TIPO_REGISTRO_ID#'  null='#iif(len(trim(arguments.TIPO_REGISTRO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REGISTRO_ID_GERADOR'  value='#arguments.REGISTRO_ID_GERADOR#'  null='#iif(len(trim(arguments.REGISTRO_ID_GERADOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CLASSIFICACAO_ID'  value='#arguments.CLASSIFICACAO_ID#'  null='#iif(len(trim(arguments.CLASSIFICACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRIORIDADE'  value='#arguments.PRIORIDADE#'  null='#iif(len(trim(arguments.PRIORIDADE)), de('no'), de('yes'))#'>
  				    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CLIENTE'  value='#arguments.COD_CLIENTE#'  null='#iif(len(trim(arguments.COD_CLIENTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_AREA_ID' value='#arguments.AREA_ID#' null='#iif(len(trim(arguments.AREA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_ORGANOGRAMA'  value='#arguments.COD_ORGANOGRAMA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_IDENTIFICACAO'  value='#arguments.COD_IDENTIFICACAO#'  null='#iif(len(trim(arguments.COD_IDENTIFICACAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_RESPONSAVEL'  value='#arguments.COD_RESPONSAVEL#'  null='#iif(len(trim(arguments.COD_RESPONSAVEL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATIVIDADE_ID'  value='#arguments.ATIVIDADE_ID#'  null='#iif(len(trim(arguments.ATIVIDADE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_IDENTIFICACAO'  value='#arguments.DATA_IDENTIFICACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_PREVISAO'  value='#arguments.DATA_PREVISAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_CONCLUSAO'  value='#arguments.DATA_CONCLUSAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DESCRICAO_ID' value='#arguments.REGISTRO_DESCRICAO_ID#' null='#iif(len(trim(arguments.REGISTRO_DESCRICAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_POSSIVEIS_CAUSAS'  value='#arguments.POSSIVEIS_CAUSAS#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SOLUCAO_APLICAVEL'  value='#arguments.SOLUCAO_APLICAVEL#' >
				</cfstoredproc>
                <!--- Anexos --->
				<cfscript>				
                    v_anexo_id      = this.ListaToArray(lista = arguments, variavel = 'ANEXO_ID_ANEXOS');
                    v_reg_anexo_id  = this.ListaToArray(lista = arguments, variavel = 'REG_ANEXO_ID_ANEXOS');
                    v_ordem 		= this.ListaToArray(lista = arguments, variavel = 'ANEXO_ORDEM_ANEXOS');
                    v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_ANEXOS, lista2 = ArrayToList(v_reg_anexo_id));				
                </cfscript>
                <cfloop list="#v_excluir#" delimiters="," index="v_reg_anexo">
                    <cfscript>
                        this.del_registro_anexo(registro_anexo_id = v_reg_anexo);
                    </cfscript>
                </cfloop>
                <cfloop from="1" to="#ArrayLen(v_reg_anexo_id)#" index="count">
                    <cfscript>
                        if(not len(trim(v_reg_anexo_id[count]))) {
                            ret = this.ins_registro_anexo(registro_id = arguments.REGISTRO_ID,
                                                           anexo_id   = v_anexo_id[count],
                                                              ordem   = v_ordem[count]);
                        } else {
                            ret = this.upd_registro_anexo(registro_anexo_id  = v_reg_anexo_id[count],
                                                                registro_id  = arguments.REGISTRO_ID,
                                                                   anexo_id  = v_anexo_id[count],
                                                                      ordem  = v_ordem[count]);
                        }
                    </cfscript>
                     <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                 </cfloop>
                 <!--- Fim Anexos --->
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Registro alterado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Exclui um registro
	-- ANDERSONC 29/03/2011 14:04:11 - CRIADO
	--->
	<cffunction name='del_registro' displayname='Exclui um registro' access='remote' returntype='Struct' output='true'>
		<cfargument name='REGISTRO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='qualidade.pkg_controle_registro.prc_del_registro' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REGISTRO_ID'  value='#arguments.REGISTRO_ID#'  null='#iif(len(trim(arguments.REGISTRO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Registro excludo com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Envia um e-mail de resposta ao cliente
	-- ANDERSONC 11/04/2011 00:44:45 - CRIADO
	--->
	<cffunction name='envia_email_cliente' displayname='Envia um e-mail de resposta ao cliente' access='remote' returntype='Struct' output='true'>
		<cfargument name='REGISTRO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='qualidade.pkg_controle_registro.prc_envia_email_cliente' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REGISTRO_ID'  value='#arguments.REGISTRO_ID#'  null='#iif(len(trim(arguments.REGISTRO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('E-mail enviado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Marca a confirmao de um registro
	-- ANDERSONC 29/03/2011 14:04:11 - CRIADO
	--->
	<cffunction name='marcar_confirmacao_reg' displayname='Marca a confirmao de um registro' access='remote' returntype='Struct' output='true'>
		<cfargument name='REGISTRO_ID' required='yes'>
		<cftry>
				<cfstoredproc procedure='qualidade.pkg_controle_registro.prc_marcar_confirmacao_reg' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REGISTRO_ID'  value='#arguments.REGISTRO_ID#'  null='#iif(len(trim(arguments.REGISTRO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Confirmao marcada com sucesso.')>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Desmarca a confirmao de um registro
	-- ANDERSONC 29/03/2011 14:04:11 - CRIADO
	--->
	<cffunction name='desmarcar_confirmacao_reg' displayname='Desmarca a confirmao de um registro' access='remote' returntype='Struct' output='true'>
		<cfargument name='REGISTRO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='qualidade.pkg_controle_registro.prc_desmarcar_confirmacao_reg' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REGISTRO_ID'  value='#arguments.REGISTRO_ID#'  null='#iif(len(trim(arguments.REGISTRO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Confirmao desmarcada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
        <!--- 
	-- PROPSITO
	-- Insere uma tarefa
	-- FABIOG 29/03/2011 11:58:55 - CRIADO
	--->
	<cffunction name='ins_tarefa' displayname='Inserir uma SACP' access='remote' returntype='Struct' output='true'>
		<cfargument name='REGISTRO_ID' required='yes'>
		<cfargument name='SITUACAO_ID' required='yes'>
		<cfargument name='COD_RESPONSAVEL' required='yes'>
		<cfargument name='DATA_ABERTURA' required='yes'>
		<cfargument name='DATA_PREVISAO' required='yes'>
		<cfargument name='DATA_CONCLUSAO' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='ACAO_TOMADA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='qualidade.pkg_controle_registro.prc_ins_tarefa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TAREFA_ID' variable='retorno.TAREFA_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REGISTRO_ID'  value='#arguments.REGISTRO_ID#'  null='#iif(len(trim(arguments.REGISTRO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SITUACAO_ID'  value='#arguments.SITUACAO_ID#'  null='#iif(len(trim(arguments.SITUACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_RESPONSAVEL'  value='#arguments.COD_RESPONSAVEL#'  null='#iif(len(trim(arguments.COD_RESPONSAVEL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_ABERTURA'  value='#arguments.DATA_ABERTURA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_PREVISAO'  value='#arguments.DATA_PREVISAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_CONCLUSAO'  value='#arguments.DATA_CONCLUSAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ACAO_TOMADA'  value='#arguments.ACAO_TOMADA#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tarefa inserida com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Altera uma tarefa
	-- FABIOG 29/03/2011 13:34:17 - CRIADO
	--->
	<cffunction name='upd_tarefa' displayname='Alterar uma SACP' access='remote' returntype='Struct' output='true'>
		<cfargument name='TAREFA_ID' required='yes'>
		<cfargument name='REGISTRO_ID' required='yes'>
		<cfargument name='SITUACAO_ID' required='yes'>
		<cfargument name='COD_RESPONSAVEL' required='yes'>
		<cfargument name='DATA_ABERTURA' required='yes'>
		<cfargument name='DATA_PREVISAO' required='yes'>
		<cfargument name='DATA_CONCLUSAO' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='ACAO_TOMADA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='qualidade.pkg_controle_registro.prc_alt_tarefa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TAREFA_ID'  value='#arguments.TAREFA_ID#'  null='#iif(len(trim(arguments.TAREFA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REGISTRO_ID'  value='#arguments.REGISTRO_ID#'  null='#iif(len(trim(arguments.REGISTRO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SITUACAO_ID'  value='#arguments.SITUACAO_ID#'  null='#iif(len(trim(arguments.SITUACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_RESPONSAVEL'  value='#arguments.COD_RESPONSAVEL#'  null='#iif(len(trim(arguments.COD_RESPONSAVEL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_ABERTURA'  value='#arguments.DATA_ABERTURA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_PREVISAO'  value='#arguments.DATA_PREVISAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_CONCLUSAO'  value='#arguments.DATA_CONCLUSAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ACAO_TOMADA'  value='#arguments.ACAO_TOMADA#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tarefa alterada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
   
    
    <!--- 
	-- PROPSITO
	-- Exclui uma tarefa
	-- FABIOG 29/03/2011 13:35:27 - CRIADO
	--->
	<cffunction name='del_tarefa' displayname='Excluir uma tarefa.' access='remote' returntype='Struct' output='true'>
		<cfargument name='TAREFA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='qualidade.pkg_controle_registro.prc_del_tarefa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TAREFA_ID'  value='#arguments.TAREFA_ID#'  null='#iif(len(trim(arguments.TAREFA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tarefa excluda com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
        
    <!--- 
	-- PROPSITO
	-- Insere uma tarefa
	-- FABIOG 29/03/2011 11:58:55 - CRIADO
	--->
	<cffunction name='ins_sacp' displayname='Inserir uma SACP' access='remote' returntype='Struct' output='true'>
		<cfargument name='REGISTRO_ID' required='yes'>
		<cfargument name='SITUACAO_ID' required='yes'>
		<cfargument name='COD_RESPONSAVEL' required='yes'>
		<cfargument name='DATA_ABERTURA' required='yes'>
		<cfargument name='DATA_PREVISAO' required='yes'>
		<cfargument name='DATA_CONCLUSAO' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='ACAO_TOMADA' required='yes'>
        <cfargument name='BRAINSTORM' required='no' default="">
		<cfargument name='PARTICIPANTES' required='no' default="">
        <cfargument name='POSSIVEL_CAUSA_GRUPO' required='no' default="">
		<cfargument name='CAUSA_GRUPO' required='no' default="">
        <cfargument name='SOLUCAO_IMEDIATA' required='no' default="">
		<cfargument name='SOLUCAO_CONTENCAO' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='qualidade.pkg_controle_registro.prc_ins_sacp' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TAREFA_ID' variable='retorno.TAREFA_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REGISTRO_ID'  value='#arguments.REGISTRO_ID#'  null='#iif(len(trim(arguments.REGISTRO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SITUACAO_ID'  value='#arguments.SITUACAO_ID#'  null='#iif(len(trim(arguments.SITUACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_RESPONSAVEL'  value='#arguments.COD_RESPONSAVEL#'  null='#iif(len(trim(arguments.COD_RESPONSAVEL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_ABERTURA'  value='#arguments.DATA_ABERTURA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_PREVISAO'  value='#arguments.DATA_PREVISAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_CONCLUSAO'  value='#arguments.DATA_CONCLUSAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ACAO_TOMADA'  value='#arguments.ACAO_TOMADA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_BRAINSTORM'  value='#arguments.BRAINSTORM#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PARTICIPANTES'  value='#arguments.PARTICIPANTES#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_POSSIVEL_CAUSA_GRUPO'  value='#arguments.POSSIVEL_CAUSA_GRUPO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CAUSA_GRUPO'  value='#arguments.CAUSA_GRUPO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SOLUCAO_IMEDIATA'  value='#arguments.SOLUCAO_IMEDIATA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SOLUCAO_CONTENCAO'  value='#arguments.SOLUCAO_CONTENCAO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
                <cfif isdefined("session.site") and session.site eq "delpozo/">
					<cfset retorno.mensagem = JSStringFormat('Plano de ao inserido com sucesso.')>                
                <cfelseif isdefined("session.site") and session.site eq "transemba/">
					<cfset retorno.mensagem = JSStringFormat('Tarefa inserida com sucesso.')>    
                <cfelseif isdefined("session.site") and session.site eq "transemba/">
					<cfset retorno.mensagem = JSStringFormat('Tarefa inserida com sucesso.')>    
                <cfelse>
                	<cfset retorno.mensagem = JSStringFormat('SACP inserida com sucesso.')>
                </cfif>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Altera uma tarefa
	-- FABIOG 29/03/2011 13:34:17 - CRIADO
	--->
	<cffunction name='upd_sacp' displayname='Alterar uma SACP' access='remote' returntype='Struct' output='true'>
		<cfargument name='TAREFA_ID' required='yes'>
		<cfargument name='REGISTRO_ID' required='yes'>
		<cfargument name='SITUACAO_ID' required='yes'>
		<cfargument name='COD_RESPONSAVEL' required='yes'>
		<cfargument name='DATA_ABERTURA' required='yes'>
		<cfargument name='DATA_PREVISAO' required='yes'>
		<cfargument name='DATA_CONCLUSAO' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='ACAO_TOMADA' required='yes'>
        <cfargument name='BRAINSTORM' required='no' default="">
		<cfargument name='PARTICIPANTES' required='no' default="">
        <cfargument name='POSSIVEL_CAUSA_GRUPO' required='no' default="">
		<cfargument name='CAUSA_GRUPO' required='no' default="">
        <cfargument name='SOLUCAO_IMEDIATA' required='no' default="">
		<cfargument name='SOLUCAO_CONTENCAO' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='qualidade.pkg_controle_registro.prc_alt_sacp' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TAREFA_ID'  value='#arguments.TAREFA_ID#'  null='#iif(len(trim(arguments.TAREFA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REGISTRO_ID'  value='#arguments.REGISTRO_ID#'  null='#iif(len(trim(arguments.REGISTRO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SITUACAO_ID'  value='#arguments.SITUACAO_ID#'  null='#iif(len(trim(arguments.SITUACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_RESPONSAVEL'  value='#arguments.COD_RESPONSAVEL#'  null='#iif(len(trim(arguments.COD_RESPONSAVEL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_ABERTURA'  value='#arguments.DATA_ABERTURA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_PREVISAO'  value='#arguments.DATA_PREVISAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_CONCLUSAO'  value='#arguments.DATA_CONCLUSAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ACAO_TOMADA'  value='#arguments.ACAO_TOMADA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_BRAINSTORM'  value='#arguments.BRAINSTORM#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PARTICIPANTES'  value='#arguments.PARTICIPANTES#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_POSSIVEL_CAUSA_GRUPO'  value='#arguments.POSSIVEL_CAUSA_GRUPO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CAUSA_GRUPO'  value='#arguments.CAUSA_GRUPO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SOLUCAO_IMEDIATA'  value='#arguments.SOLUCAO_IMEDIATA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SOLUCAO_CONTENCAO'  value='#arguments.SOLUCAO_CONTENCAO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>                
                <cfif isdefined("session.site") and session.site eq "delpozo/">
					<cfset retorno.mensagem = JSStringFormat('Plano de ao alterado com sucesso.')>                
                <cfelseif isdefined("session.site") and session.site eq "transemba/">
					<cfset retorno.mensagem = JSStringFormat('Tarefa alterada com sucesso.')>    
                <cfelseif isdefined("session.site") and session.site eq "transemba/">
					<cfset retorno.mensagem = JSStringFormat('Tarefa alterada com sucesso.')>    
                <cfelse>
                	<cfset retorno.mensagem = JSStringFormat('SACP alterada com sucesso.')>
                </cfif>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    
    <!--- 
	-- PROPSITO
	-- Exclui uma tarefa
	-- FABIOG 29/03/2011 13:35:27 - CRIADO
	--->
	<cffunction name='del_sacp' displayname='Excluir uma tarefa.' access='remote' returntype='Struct' output='true'>
		<cfargument name='TAREFA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='qualidade.pkg_controle_registro.prc_del_sacp' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TAREFA_ID'  value='#arguments.TAREFA_ID#'  null='#iif(len(trim(arguments.TAREFA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
                <cfif isdefined("session.site") and session.site eq "delpozo/">
					<cfset retorno.mensagem = JSStringFormat('Plano de ao excludo com sucesso.')>
                <cfelse>
                	<cfset retorno.mensagem = JSStringFormat('SACP excluda com sucesso.')>
                </cfif>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Inserir a configurao de registro automtico
	-- FABIOG 16/05/2011 15:52:31 - CRIADO
	--->
	<cffunction name='ins_registro_config' displayname='Inserir a configurao de registro automtico' access='remote' returntype='Struct' output='true'>
		<cfargument name='TIPO_ID' required='yes'>
		<cfargument name='CLASSIFICACAO_ID' required='yes'>
		<cfargument name='PRIORIDADE' required='yes'>
		<cfargument name='COD_ORGANOGRAMA' required='yes'>
		<cfargument name='COD_IDENTIFICACAO' required='yes'>
		<cfargument name='COD_RESPONSAVEL' required='yes'>
		<cfargument name='ATIVIDADE_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='POSSIVEIS_CAUSAS' required='yes'>
		<cfargument name='SOLUCAO_APLICAVEL' required='yes'>
		<cfargument name='DATA_INICIO' required='yes'>
		<cfargument name='DATA_TERMINO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='qualidade.pkg_controle_registro.prc_ins_registro_config' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REGISTRO_CONFIG_ID' variable='retorno.REGISTRO_CONFIG_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_ID'  value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CLASSIFICACAO_ID'  value='#arguments.CLASSIFICACAO_ID#'  null='#iif(len(trim(arguments.CLASSIFICACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRIORIDADE'  value='#arguments.PRIORIDADE#'  null='#iif(len(trim(arguments.PRIORIDADE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_ORGANOGRAMA'  value='#arguments.COD_ORGANOGRAMA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_IDENTIFICACAO'  value='#arguments.COD_IDENTIFICACAO#'  null='#iif(len(trim(arguments.COD_IDENTIFICACAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_RESPONSAVEL'  value='#arguments.COD_RESPONSAVEL#'  null='#iif(len(trim(arguments.COD_RESPONSAVEL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATIVIDADE_ID'  value='#arguments.ATIVIDADE_ID#'  null='#iif(len(trim(arguments.ATIVIDADE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_POSSIVEIS_CAUSAS'  value='#arguments.POSSIVEIS_CAUSAS#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SOLUCAO_APLICAVEL'  value='#arguments.SOLUCAO_APLICAVEL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO'  value='#arguments.DATA_INICIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_TERMINO'  value='#arguments.DATA_TERMINO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Configurao de registro automtico inserida com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Alterar a configurao de registro automtico
	-- FABIOG 16/05/2011 16:19:25 - CRIADO
	--->
	<cffunction name='upd_registro_config' displayname='Alterar a configurao de registro automtico' access='remote' returntype='Struct' output='true'>
		<cfargument name='REGISTRO_CONFIG_ID' required='yes'>
		<cfargument name='TIPO_ID' required='yes'>
		<cfargument name='CLASSIFICACAO_ID' required='yes'>
		<cfargument name='PRIORIDADE' required='yes'>
		<cfargument name='COD_ORGANOGRAMA' required='yes'>
		<cfargument name='COD_IDENTIFICACAO' required='yes'>
		<cfargument name='COD_RESPONSAVEL' required='yes'>
		<cfargument name='ATIVIDADE_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='POSSIVEIS_CAUSAS' required='yes'>
		<cfargument name='SOLUCAO_APLICAVEL' required='yes'>
		<cfargument name='DATA_INICIO' required='yes'>
		<cfargument name='DATA_TERMINO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='qualidade.pkg_controle_registro.prc_alt_registro_config' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REGISTRO_CONFIG_ID'  value='#arguments.REGISTRO_CONFIG_ID#'  null='#iif(len(trim(arguments.REGISTRO_CONFIG_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_ID'  value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CLASSIFICACAO_ID'  value='#arguments.CLASSIFICACAO_ID#'  null='#iif(len(trim(arguments.CLASSIFICACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRIORIDADE'  value='#arguments.PRIORIDADE#'  null='#iif(len(trim(arguments.PRIORIDADE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_ORGANOGRAMA'  value='#arguments.COD_ORGANOGRAMA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_IDENTIFICACAO'  value='#arguments.COD_IDENTIFICACAO#'  null='#iif(len(trim(arguments.COD_IDENTIFICACAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_RESPONSAVEL'  value='#arguments.COD_RESPONSAVEL#'  null='#iif(len(trim(arguments.COD_RESPONSAVEL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATIVIDADE_ID'  value='#arguments.ATIVIDADE_ID#'  null='#iif(len(trim(arguments.ATIVIDADE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_POSSIVEIS_CAUSAS'  value='#arguments.POSSIVEIS_CAUSAS#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SOLUCAO_APLICAVEL'  value='#arguments.SOLUCAO_APLICAVEL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO'  value='#arguments.DATA_INICIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_TERMINO'  value='#arguments.DATA_TERMINO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Configurao de registro automtico alterada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Deletar a configurao de registro automtico
	-- FABIOG 16/05/2011 16:21:06 - CRIADO
	--->
	<cffunction name='del_registro_config' displayname='Deletar a configurao de registro automtico' access='remote' returntype='Struct' output='true'>
		<cfargument name='REGISTRO_CONFIG_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='qualidade.pkg_controle_registro.prc_del_registro_config' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REGISTRO_CONFIG_ID'  value='#arguments.REGISTRO_CONFIG_ID#'  null='#iif(len(trim(arguments.REGISTRO_CONFIG_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Configurao de registro automtico excluda com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Avaliar um registro.
	-- FABIOG 19/05/2011 10:34:37 - CRIADO
	--->
	<cffunction name='avaliar_registro' displayname='Avaliar um registro.' access='remote' returntype='Struct' output='true'>
		<cfargument name='REGISTRO_ID' required='yes'>
		<cfargument name='EFICAZ' required='yes'>
		<cfargument name='AVALIACAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='qualidade.pkg_controle_registro.prc_avaliar_registro' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REGISTRO_ID'  value='#arguments.REGISTRO_ID#'  null='#iif(len(trim(arguments.REGISTRO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EFICAZ'  value='#arguments.EFICAZ#'  null='#iif(len(trim(arguments.EFICAZ)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_AVALIACAO'  value='#arguments.AVALIACAO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Registro avaliado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
     <!--- 
	-- PROPSITO
	-- Imprimir registro
	-- MARIALICE 09/06/2011
	--->
	<cffunction name='imprimir_registro' displayname='Imprimir documento/registro' access='remote' returntype='Struct' output='true'>;
		<cfargument name='REGISTRO_ID' required='no'>
		<cfargument name='LOCALIZACAO_IMPRESSAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='qualidade.pkg_controle_documento.prc_imprimir_registro' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_IMPRESSAO_ID' variable='retorno.IMPRESSAO_ID' >
					<cfprocparam type='IN'  cfsqltype='CF_SQL_NUMERIC' dbvarname='P_REGISTRO_ID'  value='#arguments.REGISTRO_ID#'>				
					<cfprocparam type='IN'  cfsqltype='CF_SQL_NUMERIC' dbvarname='P_LOCALIZACAO_IMPRESSAO'  value='#arguments.LOCALIZACAO_IMPRESSAO#'>
                 </cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Registro impresso com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
     <!--- 
	-- PROPSITO
	-- Concluir registro
	-- MARIALICE 09/06/2011
	--->
	<cffunction name='concluir_registro' displayname='Concluir registro' access='remote' returntype='Struct' output='true'>;
		<cfargument name='REGISTRO_ID' required='yes'>
        <cfargument name='LISTA' required='no' default="0">
		<cftry>
			<cfif arguments.LISTA eq 0 and (isDefined("POSSIVEIS_CAUSAS") or isDefined("SOLUCAO_APLICAVEL"))> 
				<cfscript>
                 	ret  =  this.desmarcar_confirmacao_reg (registro_id = arguments.REGISTRO_ID);
				</cfscript>
                <cfif ret.erro>
                    <cfthrow object="#ret.mensagem#">
                </cfif>
				<cfscript>
                 	ret   =  this.upd_registro(argumentCollection = arguments);
				</cfscript>
                <cfif ret.erro>
                    <cfthrow object="#ret.mensagem#">
                </cfif>
            </cfif>    	
			<cftransaction action='begin'>
				<cfstoredproc procedure='qualidade.pkg_controle_registro.prc_concluir_registro' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN'  cfsqltype='CF_SQL_NUMERIC' dbvarname='P_REGISTRO_ID'  value='#arguments.REGISTRO_ID#'>				
                 </cfstoredproc>
                 <cfif arguments.LISTA eq 0>           
					<cfscript>
                           ret = this.marcar_confirmacao_reg (registro_id = arguments.REGISTRO_ID);
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfif>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Registro concludo com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
    -- PROPSITO
    -- Cadastrar um novo tipo de registro.
    -- JAQUELINEF 06/12/2012 10:52:33 - CRIADO
    --->
    <cffunction name='ins_tipo_registro' displayname='Cadastrar um novo tipo de registro.' access='remote' returntype='Struct' output='true'>
        <cfargument name='DESCRICAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='qualidade.pkg_controle_registro.prc_ins_tipo_registro' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Tipo de No Conformidade cadastrado com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Editar um tipo de registro.
    -- JAQUELINEF 06/12/2012 10:53:18 - CRIADO
    --->
    <cffunction name='upd_tipo_registro' displayname='Editar um tipo de registro.' access='remote' returntype='Struct' output='true'>
        <cfargument name='TIPO_REGISTRO_ID' required='yes'>
        <cfargument name='DESCRICAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='qualidade.pkg_controle_registro.prc_alt_tipo_registro' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_REGISTRO_ID'  value='#arguments.TIPO_REGISTRO_ID#'  null='#iif(len(trim(arguments.TIPO_REGISTRO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Tipo de No Conformidade alterado com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
    
	<!--- 
    -- PROPSITO
    -- Excluir um tipo de registro.
    -- JAQUELINEF 06/12/2012 10:54:02 - CRIADO
    --->
    <cffunction name='del_tipo_registro' displayname='Excluir um tipo de registro.' access='remote' returntype='Struct' output='true'>
        <cfargument name='TIPO_REGISTRO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='qualidade.pkg_controle_registro.prc_del_tipo_registro' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_REGISTRO_ID'  value='#arguments.TIPO_REGISTRO_ID#'  null='#iif(len(trim(arguments.TIPO_REGISTRO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Tipo de No Conformidade excludo com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>  
    
	<!--- 
    -- PROPSITO
    -- Cancelar um registro.
    -- MARIALICE 17/01/2013 - CRIADO
    --->
    <cffunction name='cancelar_registro' displayname='Excluir um tipo de registro.' access='remote' returntype='Struct' output='true'>
        <cfargument name='REGISTRO_ID' required='yes'>
        <cfargument name='MOTIVO_CANCELAMENTO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='qualidade.pkg_controle_registro.prc_cancela_registro' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REGISTRO_ID' value='#arguments.REGISTRO_ID#'  null='#iif(len(trim(arguments.REGISTRO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MOTIVO_CANCELAMENTO' value='#arguments.MOTIVO_CANCELAMENTO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Registro cancelado com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Cancelar um registro.
    -- MARIALICE 17/01/2013 - CRIADO
    --->
    <cffunction name='valida_registro' displayname='Excluir um tipo de registro.' access='remote' returntype='Struct' output='true'>
        <cfargument name='REGISTRO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='qualidade.pkg_controle_registro.prc_valida_registro' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REGISTRO_ID' value='#arguments.REGISTRO_ID#'  null='#iif(len(trim(arguments.REGISTRO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Registro validado com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>   
    
	<!--- 
    -- PROPSITO
    -- Insere uma rea
    -- MARIALICE 25/03/2013 17:58:53 - CRIADO
    --->
    <cffunction name='ins_area' displayname='Insere uma rea' access='remote' returntype='Struct' output='true'>
        <cfargument name='DESCRICAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='qualidade.pkg_controle_registro.prc_ins_area' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMAIL'  value='#arguments.EMAIL#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('rea inserida com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>  
    
	<!--- 
    -- PROPSITO
    -- Altera uma rea
    -- MARIALICE 25/03/2013 17:59:34 - CRIADO
    --->
    <cffunction name='upd_area' displayname='Altera uma rea' access='remote' returntype='Struct' output='true'>
        <cfargument name='AREA_ID' required='yes'>
        <cfargument name='DESCRICAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='qualidade.pkg_controle_registro.prc_alt_area' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_AREA_ID'  value='#arguments.AREA_ID#'  null='#iif(len(trim(arguments.AREA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMAIL'  value='#arguments.EMAIL#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('rea alterada com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
        
	<!--- 
    -- PROPSITO
    -- Exclui uma rea
    -- MARIALICE 25/03/2013 18:00:24 - CRIADO
    --->
    <cffunction name='del_area' displayname='Exclui uma rea' access='remote' returntype='Struct' output='true'>
        <cfargument name='AREA_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='qualidade.pkg_controle_registro.prc_del_area' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_AREA_ID'  value='#arguments.AREA_ID#'  null='#iif(len(trim(arguments.AREA_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('rea excluda com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>



	<!--- 
    -- PROPSITO
    -- Insere um anexo do registro
    -- MARIALICE 14/06/2013 - CRIADO
    --->
    <cffunction name='ins_registro_anexo' displayname='Insere um anexo do registro' access='remote' returntype='Struct' output='true'>
        <cfargument name='REGISTRO_ID' required='yes'>
        <cfargument name='ANEXO_ID' required='yes'>
    	<cfargument name='ORDEM' required='no'>
        <cftry>		
            <cfstoredproc procedure='qualidade.pkg_controle_registro.prc_ins_registro_anexo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REGISTRO_ANEXO_ID' variable='retorno.REGISTRO_ANEXO_ID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REGISTRO_ID'  value='#arguments.REGISTRO_ID#' null='#iif(len(trim(arguments.REGISTRO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_ANEXO_ID'  value='#arguments.ANEXO_ID#' null='#iif(len(trim(arguments.ANEXO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_ORDEM'  value='#arguments.ORDEM#' null='#iif(len(trim(arguments.ORDEM)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Anexo inserido com sucesso!')>            
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

 <!--- 
    -- PROPSITO
    -- Altera um anexo do registro
    -- MARIALICE 14/06/2013 - CRIADO
    --->
<cffunction name='upd_registro_anexo' displayname='Altera um anexo do registro' access='remote' returntype='Struct' output='true'>
	<cfargument name='REGISTRO_ANEXO_ID' required='yes' default="">
	<cfargument name='REGISTRO_ID' required='no' default="">
    <cfargument name='ANEXO_ID' required='no' default="">
    <cfargument name='ORDEM' required='no' default="">
	<cftry>		
        <cfstoredproc procedure='qualidade.pkg_controle_registro.prc_alt_registro_anexo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_REGISTRO_ANEXO_ID'  value='#arguments.REGISTRO_ANEXO_ID#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REGISTRO_ID'  value='#arguments.REGISTRO_ID#' null='#iif(len(trim(arguments.REGISTRO_ID)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_ANEXO_ID'  value='#arguments.ANEXO_ID#' null='#iif(len(trim(arguments.ANEXO_ID)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_ORDEM'  value='#arguments.ORDEM#' null='#iif(len(trim(arguments.ORDEM)), de('no'), de('yes'))#'>
        </cfstoredproc>
        <cfset retorno.erro = false>
        <cfset retorno.mensagem = JSStringFormat('Anexo alterado com sucesso!')>		
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

	<!--- 
    -- PROPSITO
    -- Exclui um anexo do registro
    -- MARIALICE 14/06/2013 - CRIADO
    --->
    <cffunction name='del_registro_anexo' displayname='Exclui um anexo do registro' access='remote' returntype='Struct' output='true'>
        <cfargument name='REGISTRO_ANEXO_ID' required='yes'>
        <cftry>
                <cfstoredproc procedure='qualidade.pkg_controle_registro.prc_del_registro_anexo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_REGISTRO_ANEXO_ID'  value='#arguments.REGISTRO_ANEXO_ID#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Anexo excludo com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
  
</cfcomponent>