<cfcomponent extends="_transportes.funcoes.cfc_init">
    <!--- 
	-- PROPSITO
	-- Insere uma tipo de documento
	-- JAQUELINEF 23/08/2012  - ALTERADO
	--->
    <cffunction name='ins_tipo_documento' displayname='Insere um tipo de documento' access='remote' returntype='Struct' output='true'>
        <cfargument name='DESCRICAO' required='yes'>
        <cfargument name='CODIGO' required='yes'>
        <cfargument name='CABECALHO_ID' required='yes'>
        <cfargument name='RODAPE_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='qualidade.pkg_controle_documento.prc_ins_tipo_documento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_DOCUMENTO_ID' variable='retorno.TIPO_DOCUMENTO_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CODIGO'  value='#arguments.CODIGO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CABECALHO_ID'  value='#arguments.CABECALHO_ID#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RODAPE_ID'  value='#arguments.RODAPE_ID#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Tipo de documento inserido com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Altera um tipo de documento
	-- JAQUELINEF 23/08/2012 - ALTERADO
	--->
    <cffunction name='upd_tipo_documento' displayname='Altera um tipo de documento' access='remote' returntype='Struct' output='true'>
        <cfargument name='TIPO_DOCUMENTO_ID' required='yes'>
        <cfargument name='DESCRICAO' required='yes'>
        <cfargument name='CODIGO' required='yes'>
        <cfargument name='CABECALHO_ID' required='no' default="">
        <cfargument name='RODAPE_ID' required='no' default="">        
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='qualidade.pkg_controle_documento.prc_alt_tipo_documento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_DOCUMENTO_ID'  value='#arguments.TIPO_DOCUMENTO_ID#'  null='#iif(len(trim(arguments.TIPO_DOCUMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CODIGO'  value='#arguments.CODIGO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CABECALHO_ID'  value='#arguments.CABECALHO_ID#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RODAPE_ID'  value='#arguments.RODAPE_ID#' >                    
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Tipo de documento alterado com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Exclui um tipo de documento
	-- MARIA 31/05/2011 - CRIADO
	--->
	<cffunction name='del_tipo_documento' displayname='Exclui um tipo de documento' access='remote' returntype='Struct' output='true'>
		<cfargument name='TIPO_DOCUMENTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='qualidade.pkg_controle_documento.prc_del_tipo_documento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_DOCUMENTO_ID'  value='#arguments.TIPO_DOCUMENTO_ID#'  null='#iif(len(trim(arguments.tipo_documento_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tipo de documento excludo com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
    -- PROPSITO
    -- Insere uma localizao de documento impresso
    -- MARIALICE 01/06/2011 - CRIADO
    --->
<cffunction name='ins_localizacao_impressao' displayname='Insere uma localizao de documento impresso' access='remote' returntype='Struct' output='true'>
	<cfargument name='DESCRICAO' required='yes'>
    <cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='qualidade.pkg_controle_documento.prc_ins_localizacao_impressao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LOCALIZACAO_IMPRESSAO_ID' variable='retorno.LOCALIZACAO_IMPRESSAO_ID' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Localizao inserida com sucesso!')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

	<!--- 
    -- PROPSITO
    -- Altera uma localizao de documento impresso
    -- MARIALICE 01/06/2011 - CRIADO
    --->
<cffunction name='upd_localizacao_impressao' displayname='Altera uma localizao de documento impresso' access='remote' returntype='Struct' output='true'>
	<cfargument name='LOCALIZACAO_IMPRESSAO_ID' required='yes'>
	<cfargument name='DESCRICAO' required='yes'>
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='qualidade.pkg_controle_documento.prc_alt_localizacao_impressao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LOCALIZACAO_IMPRESSAO_ID'  value='#arguments.LOCALIZACAO_IMPRESSAO_ID#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Localizao alterada com sucesso!')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

	<!--- 
    -- PROPSITO
    -- Exclui uma localizao de documento impresso
    -- MARIALICE 01/06/2011 - CRIADO
    --->
<cffunction name='del_localizacao_impressao' displayname='Exclui uma localizao de documento impresso' access='remote' returntype='Struct' output='true'>
	<cfargument name='LOCALIZACAO_IMPRESSAO_ID' required='yes'>
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='qualidade.pkg_controle_documento.prc_del_localizacao_impressao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LOCALIZACAO_IMPRESSAO_ID'  value='#arguments.LOCALIZACAO_IMPRESSAO_ID#'>
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Localizao excluda com sucesso!')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>



<!--- 
-- PROPSITO
-- Inserir documento
-- luizgomes 29/08/2014 15:09:27 - CRIADO
--->
<cffunction name='ins_documento' displayname='Inserir documento' access='remote' returntype='Struct' output='true'>
	<cfargument name='CODIGO' required='yes'>
	<cfargument name='TITULO' required='yes'>
	<cfargument name='PALAVRA_CHAVE' required='yes'>
	<cfargument name='COD_RESPONSAVEL' required='yes'>
	<cfargument name='TIPO_DOCUMENTO_ID' required='yes'>
	<cfargument name='CONTEUDO' required='yes'>
	<cfargument name='OBSERVACAO' required='yes'>
	<cfargument name='COD_ORGANOGRAMA' required='yes'>
    <cfargument name='DOCUMENTO_FORMATO' required='yes'>
	<cfargument name='PROTECAO' required='yes'>
    <cfargument name='RECUPERACAO' required='yes'>
    <cfargument name='TEMPO_RETENCAO' required='yes'>
    <cfargument name='DESCARTE' required='yes'>
    <cfargument name='ARMAZENAMENTO' required='yes'>
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='qualidade.pkg_controle_documento.prc_ins_documento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DOCUMENTO_ID' variable='retorno.DOCUMENTO_ID' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CODIGO'  value='#arguments.CODIGO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PALAVRA_CHAVE'  value='#arguments.PALAVRA_CHAVE#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_RESPONSAVEL'  value='#arguments.COD_RESPONSAVEL#'  null='#iif(len(trim(arguments.COD_RESPONSAVEL)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_DOCUMENTO_ID'  value='#arguments.TIPO_DOCUMENTO_ID#'  null='#iif(len(trim(arguments.TIPO_DOCUMENTO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VERSAO_ID' variable='retorno.VERSAO_ID' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_CONTEUDO'  value='#arguments.CONTEUDO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_ORGANOGRAMA'  value='#arguments.COD_ORGANOGRAMA#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DOCUMENTO_FORMATO'  value='#arguments.DOCUMENTO_FORMATO#'  null='#iif(len(trim(arguments.DOCUMENTO_FORMATO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROTECAO'  value='#arguments.PROTECAO#'  null='#iif(len(trim(arguments.PROTECAO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RECUPERACAO'  value='#arguments.RECUPERACAO#'  null='#iif(len(trim(arguments.RECUPERACAO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TEMPO_RETENCAO'  value='#arguments.TEMPO_RETENCAO#'  null='#iif(len(trim(arguments.TEMPO_RETENCAO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DESCARTE'  value='#arguments.DESCARTE#'  null='#iif(len(trim(arguments.DESCARTE)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ARMAZENAMENTO'  value='#arguments.ARMAZENAMENTO#'  null='#iif(len(trim(arguments.ARMAZENAMENTO)), de('no'), de('yes'))#'>
		 </cfstoredproc>
            <!--- Anexos --->
            <cfscript>					
                v_anexo_id 	   = this.ListaToArray(lista = arguments, variavel = 'ANEXO_ID_ANEXOS');
				v_doc_anexo_id = this.ListaToArray(lista = arguments, variavel = 'DOC_ANEXO_ID_ANEXOS');
				v_ordem 	   = this.ListaToArray(lista = arguments, variavel = 'ANEXO_ORDEM_ANEXOS');
                v_excluir  	   = this.ListDiff(lista1 = arguments.lista_deleted_ANEXOS, lista2 = ArrayToList(v_doc_anexo_id));
				
			</cfscript>
            <cfloop list="#v_excluir#" delimiters="," index="v_doc_anexo">
                <cfscript>
                    this.del_documento_anexo (documento_anexo_id = v_doc_anexo);
         		</cfscript>
            </cfloop>
            <cfloop from="1" to="#ArrayLen(v_doc_anexo_id)#" index="count">
                <cfscript>
                    if(not len(trim(v_doc_anexo_id[count]))) {
                        ret = this.ins_documento_anexo(versao_id  = retorno.VERSAO_ID,
                                                        anexo_id  = v_anexo_id[count],
														   ordem  = v_ordem[count]);
                    } else {
                        ret = this.upd_documento_anexo(documento_anexo_id  = v_doc_anexo_id[count],
															 	versao_id  = retorno.VERSAO_ID,
                                                           		 anexo_id  = v_anexo_id[count],
																	ordem  = v_ordem[count]);
                    }
                </cfscript>
                 <cfif ret.erro>
                    <cfthrow object="#ret.mensagem#">
                </cfif>
            </cfloop>    
            <!--- Fim Anexos --->
            
              <!--- Areas --->
            <cfscript>					
           		v_area_id 	   = this.ListaToArray(lista = arguments, variavel = 'AREA_ID_AREAS');
				v_doc_area_id  = this.ListaToArray(lista = arguments, variavel = 'DOC_AREA_ID');
	        </cfscript>
          	
            <cfloop from="1" to="#ArrayLen(v_doc_area_id)#" index="count">
                <cfscript>
                    if(not len(trim(v_doc_area_id[count]))) {
                        are = this.ins_aplicabilidade(documento_id  = retorno.DOCUMENTO_ID,
                                                           area_id  = v_area_id[count]
														);
						 }
                </cfscript>
                 <cfif are.erro>
                    <cfthrow object="#are.mensagem#">
                </cfif>
            </cfloop>    
            <!--- Fim Areas --->     
			     
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Documento inserido com sucesso.')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>
 

<!--- 
-- PROPSITO
-- Alterar tipo documento
-- luizgomes 29/08/2014 15:11:52 - CRIADO
--->
<cffunction name='upd_documento' displayname='Alterar tipo documento' access='remote' returntype='Struct' output='true'>
	<cfargument name='DOCUMENTO_ID' required='yes'>
	<cfargument name='VERSAO_ID_ATUAL' required='yes'>
	<cfargument name='CODIGO' required='yes'>
	<cfargument name='TITULO' required='yes'>
	<cfargument name='PALAVRA_CHAVE' required='yes'>
	<cfargument name='COD_RESPONSAVEL' required='yes'>
	<cfargument name='TIPO_DOCUMENTO_ID' required='yes'>
	<cfargument name='NUM_VERSAO' required='yes'>
	<cfargument name='SITUACAO_ID' required='yes'>
	<cfargument name='CONTEUDO' required='yes'>
	<cfargument name='OBSERVACAO' required='yes'>
	<cfargument name='COD_ORGANOGRAMA' required='yes'>
	<cfargument name='DOCUMENTO_FORMATO' required='yes'>
    <cfargument name='PROTECAO' required='yes'>
    <cfargument name='RECUPERACAO' required='yes'>
    <cfargument name='TEMPO_RETENCAO' required='yes'>
    <cfargument name='DESCARTE' required='yes'>
    <cfargument name='ARMAZENAMENTO' required='yes'>
   
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='qualidade.pkg_controle_documento.prc_alt_documento' datasource='#session.dsn#' username='#session.usuario#' 
            password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DOCUMENTO_ID'  value='#arguments.DOCUMENTO_ID#'  null='#iif(len(trim(arguments.DOCUMENTO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VERSAO_ID_ATUAL'  value='#arguments.VERSAO_ID_ATUAL#'  null='#iif(len(trim(arguments.VERSAO_ID_ATUAL)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CODIGO'  value='#arguments.CODIGO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PALAVRA_CHAVE'  value='#arguments.PALAVRA_CHAVE#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_RESPONSAVEL'  value='#arguments.COD_RESPONSAVEL#'  null='#iif(len(trim(arguments.COD_RESPONSAVEL)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_DOCUMENTO_ID'  value='#arguments.TIPO_DOCUMENTO_ID#'  null='#iif(len(trim(arguments.TIPO_DOCUMENTO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_VERSAO'  value='#arguments.NUM_VERSAO#'  null='#iif(len(trim(arguments.NUM_VERSAO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SITUACAO_ID'  value='#arguments.SITUACAO_ID#'  null='#iif(len(trim(arguments.SITUACAO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_CONTEUDO'  value='#arguments.CONTEUDO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_ORGANOGRAMA'  value='#arguments.COD_ORGANOGRAMA#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DOCUMENTO_FORMATO'  value='#arguments.DOCUMENTO_FORMATO#'  null='#iif(len(trim(arguments.DOCUMENTO_FORMATO)), de('no'), de('yes'))#'>
                 <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROTECAO'  value='#arguments.PROTECAO#'  null='#iif(len(trim(arguments.PROTECAO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RECUPERACAO'  value='#arguments.RECUPERACAO#'  null='#iif(len(trim(arguments.RECUPERACAO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TEMPO_RETENCAO'  value='#arguments.TEMPO_RETENCAO#'  null='#iif(len(trim(arguments.TEMPO_RETENCAO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DESCARTE'  value='#arguments.DESCARTE#'  null='#iif(len(trim(arguments.DESCARTE)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ARMAZENAMENTO'  value='#arguments.ARMAZENAMENTO#'  null='#iif(len(trim(arguments.ARMAZENAMENTO)), de('no'), de('yes'))#'>
			</cfstoredproc>	
            <!--- Anexos --->
            <cfscript>				
                v_anexo_id      = this.ListaToArray(lista = arguments, variavel = 'ANEXO_ID_ANEXOS');
				v_doc_anexo_id  = this.ListaToArray(lista = arguments, variavel = 'DOC_ANEXO_ID_ANEXOS');
				v_ordem 		= this.ListaToArray(lista = arguments, variavel = 'ANEXO_ORDEM_ANEXOS');
                v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_ANEXOS, lista2 = ArrayToList(v_doc_anexo_id));				
            </cfscript>
            <cfloop list="#v_excluir#" delimiters="," index="v_doc_anexo">
                <cfscript>
                    this.del_documento_anexo(documento_anexo_id = v_doc_anexo);
                </cfscript>
            </cfloop>
            <cfloop from="1" to="#ArrayLen(v_doc_anexo_id)#" index="count">
                <cfscript>
                    if(not len(trim(v_doc_anexo_id[count]))) {
                        ret = this.ins_documento_anexo(versao_id  = arguments.VERSAO_ID_ATUAL,
                                                        anexo_id  = v_anexo_id[count],
														   ordem  = v_ordem[count]);
                    } else {
                        ret = this.upd_documento_anexo(documento_anexo_id  = v_doc_anexo_id[count],
															    versao_id  = arguments.VERSAO_ID_ATUAL,
                                                           		 anexo_id  = v_anexo_id[count],
																	ordem  = v_ordem[count]);
                    }
                </cfscript>
                 <cfif ret.erro>
                    <cfthrow object="#ret.mensagem#">
                </cfif>
             </cfloop>
             <!--- Fim Anexos --->
             
             <!--- Areas --->
            <cfscript>				
                v_area_id 	        = this.ListaToArray(lista = arguments, variavel = 'AREA_ID_AREAS');
				v_doc_area_id       = this.ListaToArray(lista = arguments, variavel = 'DOC_AREA_ID');
				v_aplicabilidade_id = this.ListaToArray(lista = arguments, variavel = 'APLICABILIDADE_ID_AREAS');
                v_excluir_area  	= this.ListDiff(lista1 = arguments.lista_deleted_AREAS, lista2 = ArrayToList(v_aplicabilidade_id));			
            </cfscript>
            <cfloop list="#v_excluir_area#" delimiters="," index="v_doc_area">
                <cfscript>
                    this.del_aplicabilidade(aplicabilidade_id = v_doc_area);
                </cfscript>
            </cfloop>
            <cfloop from="1" to="#ArrayLen(v_doc_area_id)#" index="count">
                <cfscript>
                    if(not len(trim(v_doc_area_id[count]))) {
                        are = this.ins_aplicabilidade(documento_id  = arguments.DOCUMENTO_ID,
                                                           area_id  = v_area_id[count]
														);
				    } else {
                        are = this.alt_aplicabilidade(aplicabilidade_id  = v_aplicabilidade_id[count], 
														   p_documento_id  = arguments.DOCUMENTO_ID,
                                                           		p_area_id  = v_area_id[count]
																);
                    }
                </cfscript>
                 <cfif are.erro>
                    <cfthrow object="#are.mensagem#">
                </cfif>
             </cfloop>
             <!--- Fim Areas --->
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Documento alterado com sucesso.')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction> 
 <!--- 
    -- PROPSITO
    -- Exclui um documento
    -- MARIALICE 02/06/2011 - CRIADO
    --->
 
  
<cffunction name='del_documento' displayname='Exclui um documento' access='remote' returntype='Struct' output='true'>
	<cfargument name='DOCUMENTO_ID' required='yes'>
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='qualidade.pkg_controle_documento.prc_del_documento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_DOCUMENTO_ID' value='#arguments.VERSAO_ID#'>
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Documento excludo com sucesso!')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>


	<!--- 
    -- PROPSITO
    -- Insere uma verso do documento
    -- MARIALICE 03/06/2011 08:46:18 - CRIADO
    --->
    <cffunction name='ins_documento_versao' displayname='Insere uma verso do documento' access='remote' returntype='Struct' output='true'>
        <cfargument name='DOCUMENTO_ID' required='yes'>
        <cfargument name='NUM_VERSAO' required='yes'>
        <cfargument name='SITUACAO_ID' required='yes'>
        <cfargument name='CONTEUDO' required='yes'>
        <cfargument name='OBSERVACAO' required='yes'>
        <cfargument name='COD_RESPONSAVEL' required='yes'>
        <cftry>
                <cfstoredproc procedure='qualidade.pkg_controle_documento.prc_ins_documento_versao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VERSAO_ID' variable='retorno.VERSAO_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DOCUMENTO_ID'  value='#arguments.DOCUMENTO_ID#'  null='#iif(len(trim(arguments.DOCUMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_VERSAO'  value='#arguments.NUM_VERSAO#'  null='#iif(len(trim(arguments.NUM_VERSAO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SITUACAO_ID'  value='#arguments.SITUACAO_ID#'  null='#iif(len(trim(arguments.SITUACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_CONTEUDO'  value='#arguments.CONTEUDO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_RESPONSAVEL'  value='#arguments.COD_RESPONSAVEL#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Verso inserida com sucesso!')>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!--- 
    -- PROPSITO
    -- Altera uma verso do documento
    -- MARIALICE 02/06/2011 - CRIADO
    --->
<cffunction name='upd_documento_versao' displayname='Altera uma verso do documento' access='remote' returntype='Struct' output='true'>
	<cfargument name='VERSAO_ID' required='yes' default="">
	<cfargument name='DOCUMENTO_ID' required='no' default="">
    <cfargument name='NUM_VERSAO' required='no' default="">
    <cfargument name='SITUACAO_ID' required='no' default="">
    <cfargument name='CONTEUDO' required='no' default="">
    <cfargument name='OBSERVACAO' required='no' default="">
    <cfargument name='COD_RESPONSAVEL' required='yes'>
	<cftry>
			<cfstoredproc procedure='qualidade.pkg_controle_documento.prc_alt_documento_versao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_VERSAO_ID' value='#arguments.VERSAO_ID#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_DOCUMENTO_ID'  value='#arguments.DOCUMENTO_ID#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_NUM_VERSAO'  value='#arguments.NUM_VERSAO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_SITUACAO_ID'  value='#arguments.SITUACAO_ID#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONTEUDO'  value='#arguments.CONTEUDO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_RESPONSAVEL'  value='#arguments.COD_RESPONSAVEL#' >
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Verso alterada com sucesso!')>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

	<!--- 
    -- PROPSITO
    -- Exclui uma verso do documento
    -- MARIALICE 02/06/2011 - CRIADO
    --->
<cffunction name='del_documento_versao' displayname='Exclui uma verso do documento' access='remote' returntype='Struct' output='true'>
	<cfargument name='VERSAO_ID' required='yes'>
	<cftry>
			<cfstoredproc procedure='qualidade.pkg_controle_documento.prc_del_documento_versao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VERSAO_ID' value='#arguments.VERSAO_ID#' >
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Verso excluda com sucesso!')>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>


	<!--- 
    -- PROPSITO
    -- Insere um anexo do documento
    -- MARIALICE 03/06/2011 09:26:14 - CRIADO
    --->
    <cffunction name='ins_documento_anexo' displayname='Insere um anexo do documento' access='remote' returntype='Struct' output='true'>
        <cfargument name='VERSAO_ID' required='yes'>
        <cfargument name='ANEXO_ID' required='yes'>
    	<cfargument name='ORDEM' required='no'>
        <cftry>		
            <cfstoredproc procedure='qualidade.pkg_controle_documento.prc_ins_documento_anexo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DOCUMENTO_ANEXO_ID' variable='retorno.DOCUMENTO_ANEXO_ID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VERSAO_ID'  value='#arguments.VERSAO_ID#'  null='#iif(len(trim(arguments.VERSAO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_ANEXO_ID'  value='#arguments.ANEXO_ID#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_ORDEM'  value='#arguments.ORDEM#' null='#iif(len(trim(arguments.ORDEM)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Anexo inserido com sucesso!')>            
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

 <!--- 
    -- PROPSITO
    -- Altera um anexo do documento
    -- MARIALICE 02/06/2011 - CRIADO
    --->
<cffunction name='upd_documento_anexo' displayname='Altera um anexo do documento' access='remote' returntype='Struct' output='true'>
	<cfargument name='DOCUMENTO_ANEXO_ID' required='yes' default="">
	<cfargument name='VERSAO_ID' required='no' default="">
    <cfargument name='ANEXO_ID' required='no' default="">
    <cfargument name='ORDEM' required='no' default="">
	<cftry>		
        <cfstoredproc procedure='qualidade.pkg_controle_documento.prc_alt_documento_anexo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_DOCUMENTO_ANEXO_ID'  value='#arguments.DOCUMENTO_ANEXO_ID#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_VERSAO_ID'  value='#arguments.VERSAO_ID#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_ANEXO_ID'  value='#arguments.ANEXO_ID#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_ORDEM'  value='#arguments.ORDEM#' null='#iif(len(trim(arguments.ORDEM)), de('no'), de('yes'))#'>
        </cfstoredproc>
        <cfset retorno.erro = false>
        <cfset retorno.mensagem = JSStringFormat('Anexo alterado com sucesso!')>		
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

	<!--- 
    -- PROPSITO
    -- Exclui um anexo do documento
    -- MARIALICE 02/06/2011 - CRIADO
    --->
    <cffunction name='del_documento_anexo' displayname='Exclui um anexo do documento' access='remote' returntype='Struct' output='true'>
        <cfargument name='DOCUMENTO_ANEXO_ID' required='yes'>
        <cftry>
                <cfstoredproc procedure='qualidade.pkg_controle_documento.prc_del_documento_anexo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_DOCUMENTO_ANEXO_ID'  value='#arguments.DOCUMENTO_ANEXO_ID#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Anexo excludo com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
  
    
    <!--- 
	-- PROPSITO
	-- Insere um anexo
	-- MARIALICE 03/06/2011 13:49:01 - CRIADO
	--->
	<cffunction name='ins_anexo' displayname='Insere um anexo' access='remote' returntype='Struct' output='true'>
		<cfargument name='TITULO' required='yes'>
		<cfargument name='ANEXO' required='no' default="">
		<cfargument name='PERMITE_EXCLUIR' required='no' default="0">
		<cfargument name='GRUPO_ID' required='no' default="1">
		<cfargument name="FILEFIELD" required="no" default="anexo">
          <cftry>              	
			<cftransaction action='begin'>
           		<cfset v_anexo = ''>
				<cfset v_arquivo = ''>
				<cfset retorno.url = ''>
				<cfif len(trim(arguments[arguments.filefield]))>
					<cffile action="upload"
							filefield="#arguments.filefield#" 
							nameconflict="makeunique"
							destination="#arguments[arguments.filefield]#2"
							result="arguments.dados">                            
				<!--- torna o nome do anexo unico --->
					<cfset dest = this.unique_filename(filename = ExpandPath('/anexos/')&'anexo_qualidade.'&arguments.dados.clientfileext)>					
                    <cffile action="copy" 
							source="#arguments[arguments.filefield]#" 
							destination="#dest#"
							nameconflict="error"
							result="arguments.dados">
					<cfif not len(trim(arguments.titulo))>
						<cfset arguments.titulo = ListDeleteAt('anexo_qualidade.'&arguments.dados.clientfileext,listlen('anexo_qualidade.'&arguments.dados.clientfileext,'.'),'.')>
					</cfif>
					<cfset v_anexo = Replace(dest, ExpandPath('/anexos/'), 'http://#CGI.HTTP_HOST#/anexos/','one')>
					<cfset retorno.url = v_anexo>
				</cfif>
				<cfstoredproc procedure='qualidade.pkg_anexo.prc_ins_anexo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_URL'  value='#v_anexo#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_PERMITE_EXCLUIR'  value='#arguments.PERMITE_EXCLUIR#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_GRUPO_ID'  value='#arguments.GRUPO_ID#' >	
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ANEXO_ID' variable='retorno.ANEXO_ID'>				
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Anexo inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca um nome unico para o anexo
	-- CRISTOFER  16/05/2006
	--->		
	<cffunction name="unique_filename" access="package" output="false" returntype="string">
		<cfargument name="filename" required="yes">
		<cfargument name="original" required="no" default="#arguments.filename#">
		<cfargument name="tentativa" required="no" default="0">
		<cfif not FileExists(arguments.filename)>
			<cfreturn arguments.filename>
		<cfelse>
			<cfscript>
				ext = ListLast(arguments.original,'.');
				t = ListDeleteAt(arguments.original, listlen(arguments.original,'.'), '.');
			</cfscript>
			<cfreturn this.unique_filename(	filename = t&'('&(arguments.tentativa+1)&').'&ext,
											original = arguments.original,
											tentativa = arguments.tentativa+1)>
		</cfif>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Insere um anexo 
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="upd_anexo" displayname="" access="remote" returntype="Struct" output="true">
		<cfargument name="anexo_id" required="yes">
		<cfargument name="titulo" required="yes">
		<cfargument name="anexo" required="no" default="">
		<cfargument name="permite_excluir" required="no" default="0">
		<cfargument name="grupo_id" required="no" default="1">
		<cfargument name="filefield" required="no" default="anexo">
		<cftry>
			<cftransaction action="begin">
				<cfset v_anexo = ''>
				<cfset v_arquivo = ''>
				<cfif len(trim(arguments[arguments.filefield]))>
					<cffile action="upload"
							filefield="#arguments.filefield#" 
							nameconflict="makeunique"
							destination="#arguments[arguments.filefield]#2"
							result="arguments.dados">
				<!--- torna o nome do anexo unico --->
					<cfset dest = this.unique_filename(filename = ExpandPath('/anexos/')&'anexo_qualidade.'&arguments.dados.clientfileext)>
					<cffile action="copy" 
							source="#arguments[arguments.filefield]#" 
							destination="#dest#"
							nameconflict="error"
							result="arguments.dados">
					<cfset v_anexo = Replace(dest, ExpandPath('/anexos/'), 'http://#CGI.HTTP_HOST#/anexos/','one')>
					<cfset retorno.url = v_anexo>
				</cfif>
				<cfstoredproc procedure="qualidade.pkg_anexo.prc_alt_anexo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam dbvarname="p_anexo_id" type="in" value="#arguments.anexo_id#" cfsqltype="cf_sql_integer">
					<cfprocparam dbvarname="p_titulo" type="in" value="#arguments.titulo#" cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_url" type="inout" variable="retorno.url" value="#v_anexo#" cfsqltype="cf_sql_varchar">
					<cfprocparam dbvarname="p_permite_excluir" type="in" value="#arguments.permite_excluir#" cfsqltype="cf_sql_integer">
					<cfprocparam dbvarname="p_grupo_id" type="in" value="#arguments.grupo_id#" cfsqltype="cf_sql_integer">
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Anexo alterado com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Exclui um anexo 
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="del_anexo" access="remote" returntype="Struct" output="true">
		<cfargument name="anexo_id" required="yes">
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="qualidade.pkg_anexo.prc_del_anexo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam dbvarname="p_anexo_id" type="in" value="#arguments.anexo_id#" cfsqltype="cf_sql_integer">
					<cfprocparam dbvarname="p_url" type="out" variable="retorno.url" cfsqltype="cf_sql_varchar">
				</cfstoredproc>
				<cfif len(trim(retorno.url))>
					<cftry>
						<cffile action="delete"
								file="#Replace(retorno.url,'http://#CGI.HTTP_HOST#/',ExpandPath('/anexos/'),'all')#">
						<cfset retorno.erro = false>
						<cfcatch>
						</cfcatch>
					</cftry>
				</cfif>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Anexo excludo com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />		
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Insere um grupo de anexos
	-- cristofer 11/05/2006 11:35:45 - CRIADO
	--->
	<cffunction name='ins_anexo_grupo' displayname='Insere um grupo de anexos' access='remote' returntype='Struct' output='true'>
		<cfargument name='GRUPO_PAI_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfif not len(trim(arguments.grupo_pai_id))>  
                	 <cfquery name="anexo_grupo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                            select a.grupo_id
                              from qualidade.v$anexo_grupo a
                             where a.grupo_pai_id is null
                    </cfquery>
                    <cfset arguments.grupo_pai_id = anexo_grupo.grupo_id>
				</cfif>
				<cfstoredproc procedure='qualidade.pkg_anexo.prc_ins_anexo_grupo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_GRUPO_PAI_ID'  value='#arguments.GRUPO_PAI_ID#'  null='#iif(len(trim(arguments.GRUPO_PAI_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_GRUPO_ID' variable='retorno.GRUPO_ID'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Grupo inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera um grupo de anexos
	-- cristofer 11/05/2006 11:36:40 - CRIADO
	--->
	<cffunction name='upd_anexo_grupo' displayname='Altera um grupo de anexos' access='remote' returntype='Struct' output='true'>
		<cfargument name='GRUPO_ID' required='yes'>
		<cfargument name='GRUPO_PAI_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfif not len(trim(arguments.grupo_pai_id))>  
                	 <cfquery name="anexo_grupo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                            select a.grupo_id
                              from qualidade.v$anexo_grupo a
                             where a.grupo_pai_id is null
                    </cfquery>
                    <cfset arguments.grupo_pai_id = anexo_grupo.grupo_id>
				</cfif>
				<cfstoredproc procedure='qualidade.pkg_anexo.prc_alt_anexo_grupo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_GRUPO_ID'  value='#arguments.GRUPO_ID#'  null='#iif(len(trim(arguments.GRUPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_GRUPO_PAI_ID'  value='#arguments.GRUPO_PAI_ID#'  null='#iif(len(trim(arguments.GRUPO_PAI_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Grupo alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um grupo de anexos
	-- cristofer 11/05/2006 11:37:21 - CRIADO
	--->
	<cffunction name='del_anexo_grupo' displayname='Exclui um grupo de anexos' access='remote' returntype='Struct' output='true'>
		<cfargument name='GRUPO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='qualidade.pkg_anexo.prc_del_anexo_grupo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_GRUPO_ID'  value='#arguments.GRUPO_ID#'  null='#iif(len(trim(arguments.GRUPO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Grupo excluido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Envia um documento para avaliao
	-- MARIALICE 08/06/2011
	--->
	<cffunction name='enviar_documento_avaliacao' displayname='Envia um documento para avaliao' access='remote' returntype='Struct' output='true'>
		<cfargument name='DOCUMENTO_ID' required='yes'>
		<cfargument name='EMAIL_AVALIACAO' required='yes'>   
		<cfargument name='COD_PESSOA_APROVACAO' required='yes'>    
		<cfargument name='SITUACAO_ID' required='yes'>    
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='qualidade.pkg_controle_documento.prc_envia_documento_avaliacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DOCUMENTO_ID'  value='#arguments.DOCUMENTO_ID#'>					
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMAIL_AVALIACAO'  value='#arguments.EMAIL_AVALIACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_PESSOA_APROVACAO'  value='#arguments.COD_PESSOA_APROVACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SITUACAO_ID'  value='#arguments.SITUACAO_ID#'  >                   
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Documento enviado para avaliao com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
     <!--- 
	-- PROPSITO
	-- Avaliar documento
	-- MARIALICE 08/06/2011
	--->
	<cffunction name='avaliar_documento' displayname='Avaliar documento' access='remote' returntype='Struct' output='true'>
		<cfargument name='DOCUMENTO_ID' required='yes'>
		<cfargument name='SITUACAO_ID' required='yes'>
        <cfargument name='VERSAO_ID_ATUAL' required='yes'>
		<cfargument name='MOTIVO' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='qualidade.pkg_controle_documento.prc_avaliar_documento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_DOCUMENTO_ID'  value='#arguments.DOCUMENTO_ID#'>					
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_SITUACAO_ID'  value='#arguments.SITUACAO_ID#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_VERSAO_ID'  value='#arguments.VERSAO_ID_ATUAL#'>					
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MOTIVO_REPROVACAO'  value='#arguments.MOTIVO_REPROVACAO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_AUDITORIA_ID'  variable='retorno.AUDITORIA_ID' >				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Documento avaliado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
     <!--- 
	-- PROPSITO
	-- Imprimir documento
	-- MARIALICE 09/06/2011
	--->
	<cffunction name='imprimir_documento' displayname='Imprimir documento/registro' access='remote' returntype='Struct' output='true'>
		<cfargument name='DOCUMENTO_ID' required='no'>
		<cfargument name='LOCALIZACAO_IMPRESSAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='qualidade.pkg_controle_documento.prc_imprimir_documento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_IMPRESSAO_ID' variable='retorno.IMPRESSAO_ID' >
					<cfprocparam type='IN'  cfsqltype='CF_SQL_NUMERIC' dbvarname='P_DOCUMENTO_ID'  value='#arguments.DOCUMENTO_ID#'>				
					<cfprocparam type='IN'  cfsqltype='CF_SQL_NUMERIC' dbvarname='P_LOCALIZACAO_IMPRESSAO'  value='#arguments.LOCALIZACAO_IMPRESSAO#'>
                 </cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Documento impresso com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    

 <!--- 
    -- PROPSITO
    -- Insere uma verso do documento
    -- MARIALICE 02/06/2011 - CRIADO
    --->
<cffunction name='gerar_versao_documento' displayname='Insere uma verso do documento' access='remote' returntype='Struct' output='true'>  
    <cfargument name='DOCUMENTO_ID' required='yes'>
    <cfargument name='COD_RESPONSAVEL' required='yes'>
    <cfargument name='VERSAO_ID_ATUAL' required='yes'>
    <cfargument name='SITUACAO_ID' required='yes'>
    <cfargument name='CONTEUDO' required='yes'>
    <cfargument name='OBSERVACAO' required='yes'>
    <cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='qualidade.pkg_controle_documento.prc_gerar_versao_documento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VERSAO_ID' variable='retorno.VERSAO_ID' >   
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_DOCUMENTO_ID' value='#arguments.DOCUMENTO_ID#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_COD_RESPONSAVEL'  value='#arguments.COD_RESPONSAVEL#' >                
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_VERSAO_ID_ATUAL' value='#arguments.VERSAO_ID_ATUAL#' >  
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_SITUACAO_ID'  value='#arguments.SITUACAO_ID#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONTEUDO'  value='#arguments.CONTEUDO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
			</cfstoredproc>
			<!--- Anexos --->
            <cfscript>				
                v_anexo_id     = this.ListaToArray(lista = arguments, variavel = 'ANEXO_ID_ANEXOS');
				v_doc_anexo_id = this.ListaToArray(lista = arguments, variavel = 'DOC_ANEXO_ID_ANEXOS');
				v_ordem 	   = this.ListaToArray(lista = arguments, variavel = 'ANEXO_ORDEM_ANEXOS');
                v_excluir      = this.ListDiff(lista1 = arguments.lista_deleted_ANEXOS, lista2 = ArrayToList(v_doc_anexo_id));
            </cfscript>
            <cfloop list="#v_excluir#" delimiters="," index="v_doc_anexo">
                <cfscript>
                    this.del_documento_anexo (documento_anexo_id = v_doc_anexo);
                </cfscript>
            </cfloop>
            <cfloop from="1" to="#ArrayLen(v_doc_anexo_id)#" index="count">
                <cfscript>
                    if(not len(trim(v_doc_anexo_id[count]))) {
                        ret = this.ins_documento_anexo(versao_id  = retorno.VERSAO_ID,
                                                        anexo_id  = v_anexo_id[count],
														   ordem  = v_ordem[count]);
                    } else {
                        ret = this.upd_documento_anexo(documento_anexo_id  = v_doc_anexo_id[count],
													            versao_id  = retorno.VERSAO_ID,
                                                           		 anexo_id  = v_anexo_id[count],
														   			ordem  = v_ordem[count]);
                    }
                </cfscript>
                 <cfif ret.erro>
                    <cfthrow object="#ret.mensagem#">
                </cfif>
            </cfloop>    
            <!--- Fim Anexos --->
            
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Verso gerada com sucesso!')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

	<!--- 
    -- PROPSITO
    -- Insere um cabealho
    -- JAQUELINEF 22/08/2012 17:11:07 - CRIADO
    --->
    <cffunction name='ins_cabecalho' displayname='Insere um cabealho' access='remote' returntype='Struct' output='true'>
        <cfargument name='TITULO' required='yes'>
        <cfargument name='CONTEUDO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='qualidade.pkg_controle_documento.prc_ins_cabecalho' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CABECALHO_ID' variable='retorno.CABECALHO_ID' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VERSAO_ID_ATUAL' variable='retorno.VERSAO_ID_ATUAL' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_CONTEUDO'  value='#arguments.CONTEUDO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Cabealho inserido com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Altera um cabealho
    -- JAQUELINEF 23/08/2012 11:40:38 - CRIADO
    --->
    <cffunction name='upd_cabecalho' displayname='Altera um cabealho' access='remote' returntype='Struct' output='true'>
        <cfargument name='CABECALHO_ID' required='yes'>
        <cfargument name='TITULO' required='yes'>
        <cfargument name='CONTEUDO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='qualidade.pkg_controle_documento.prc_alt_cabecalho' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CABECALHO_ID'  value='#arguments.CABECALHO_ID#'  null='#iif(len(trim(arguments.CABECALHO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VERSAO_ID_ATUAL' variable='retorno.VERSAO_ID_ATUAL' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_VERSAO' variable='retorno.NUM_VERSAO' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_CONTEUDO'  value='#arguments.CONTEUDO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Cabealho alterado com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Inserir um rodap
    -- JAQUELINEF 23/08/2012 14:30:12 - CRIADO
    --->
    <cffunction name='ins_rodape' displayname='Inserir um rodap' access='remote' returntype='Struct' output='true'>
        <cfargument name='TITULO' required='yes'>
        <cfargument name='CONTEUDO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='qualidade.pkg_controle_documento.prc_ins_rodape' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RODAPE_ID' variable='retorno.RODAPE_ID' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VERSAO_ID_ATUAL' variable='retorno.VERSAO_ID_ATUAL' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_CONTEUDO'  value='#arguments.CONTEUDO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Rodap inserido com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
</cffunction>

	<!--- 
    -- PROPSITO
    -- Alterar um rodap
    -- JAQUELINEF 23/08/2012 14:31:29 - CRIADO
    --->
    <cffunction name='upd_rodape' displayname='Alterar um rodap' access='remote' returntype='Struct' output='true'>
        <cfargument name='RODAPE_ID' required='yes'>
        <cfargument name='TITULO' required='yes'>
        <cfargument name='CONTEUDO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='qualidade.pkg_controle_documento.prc_alt_rodape' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RODAPE_ID'  value='#arguments.RODAPE_ID#'  null='#iif(len(trim(arguments.RODAPE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VERSAO_ID_ATUAL' variable='retorno.VERSAO_ID_ATUAL' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_VERSAO' variable='retorno.NUM_VERSAO' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_CONTEUDO'  value='#arguments.CONTEUDO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Rodap altedaro com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Registrar a visualizao de documentos.
    -- JAQUELINEF 05/12/2012 11:47:51 - CRIADO
    --->
    <cffunction name='ins_visualizacao_documento' displayname='Registrar a visualizao de documentos.' access='remote' returntype='Struct' output='true'>
        <cfargument name='VERSAO_DOCUMENTO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='qualidade.pkg_controle_documento.prc_ins_visualizacao_documento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VERSAO_DOCUMENTO_ID'  value='#arguments.VERSAO_DOCUMENTO_ID#'  null='#iif(len(trim(arguments.VERSAO_DOCUMENTO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Visualizao de documento registrada com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Cadastrar um novo responsvel por aprovao de documentos/registros
    -- JAQUELINEF 05/12/2012 15:50:24 - CRIADO
    --->
    <cffunction name='ins_responsavel_aprovacao' displayname='Cadastrar um novo responsvel por aprovao de documentos/registros' access='remote' returntype='Struct' output='true'>
        <cfargument name='USUARIO' required='yes'>
        <cfargument name='EMAIL' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='qualidade.pkg_controle_documento.prc_ins_responsavel_aprovacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_USUARIO'  value='#arguments.USUARIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMAIL'  value='#arguments.EMAIL#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Responsvel cadastrado com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Alterar um responsvel por aprovao de documentos/registros
    -- JAQUELINEF 05/12/2012 15:59:18 - CRIADO
    --->
    <cffunction name='upd_responsavel_aprovacao' displayname='Alterar um responsvel por aprovao de documentos/registros' access='remote' returntype='Struct' output='true'>
        <cfargument name='USUARIO' required='yes'>
        <cfargument name='EMAIL' required='yes'>
        <cfargument name='RESPONSAVEL_APROVACAO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='qualidade.pkg_controle_documento.prc_alt_responsavel_aprovacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_USUARIO'  value='#arguments.USUARIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMAIL'  value='#arguments.EMAIL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RESPONSAVEL_APROVACAO_ID'  value='#arguments.RESPONSAVEL_APROVACAO_ID#'  null='#iif(len(trim(arguments.RESPONSAVEL_APROVACAO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Responsvel alterado com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>  
    
	<!--- 
    -- PROPSITO
    -- Excluir um responsvel por aprovao de documentos/registros
    -- JAQUELINEF 05/12/2012 16:01:12 - CRIADO
    --->
    <cffunction name='del_responsavel_aprovacao' displayname='Excluir um responsvel por aprovao de documentos/registros' access='remote' returntype='Struct' output='true'>
        <cfargument name='RESPONSAVEL_APROVACAO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='qualidade.pkg_controle_documento.prc_del_responsavel_aprovacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RESPONSAVEL_APROVACAO_ID'  value='#arguments.RESPONSAVEL_APROVACAO_ID#'  null='#iif(len(trim(arguments.RESPONSAVEL_APROVACAO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Responsvel excludo com suscesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>  
    
    <!--- 
	-- PROPSITO
	-- Avaliar documento
	-- MARIALICE 08/06/2011
	--->
	<cffunction name='alterar_status_documento' displayname='Avaliar documento' access='remote' returntype='Struct' output='true'>
		<cfargument name='DOCUMENTO_ID' required='yes'>
		<cfargument name='STATUS_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='qualidade.pkg_controle_documento.prc_alterar_status_documento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_DOCUMENTO_ID'  value='#arguments.DOCUMENTO_ID#'>					
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_STATUS_ID'  value='#arguments.STATUS_ID#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Documento alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction> 
    
    <!--- 
-- PROPSITO
-- Inserir aplicabilidade do documento
-- luizgomes 16/10/2014 15:31:34 - CRIADO
--->
<cffunction name='ins_aplicabilidade' displayname='Inserir aplicabilidade do documento' access='remote' returntype='Struct' output='true'>
	<cfargument name='DOCUMENTO_ID' required='yes'>
	<cfargument name='AREA_ID' required='yes'>
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='qualidade.pkg_aplicabilidade.prc_ins_aplicabilidade' datasource='#session.dsn#' username='#session.usuario#' 
            password='#session.senha#'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_APLICABILIDADE_ID' variable='retorno.APLICABILIDADE_ID' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DOCUMENTO_ID'  value='#arguments.DOCUMENTO_ID#' 
                   null='#iif(len(trim(arguments.DOCUMENTO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_AREA_ID'  value='#arguments.AREA_ID#'  
                   null='#iif(len(trim(arguments.AREA_ID)), de('no'), de('yes'))#'>
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Documento vinculado a rea(s) com sucesso.')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

<!--- 
-- PROPSITO
-- Alterar aplicabilidade do documento
-- luizgomes 16/10/2014 15:35:00 - CRIADO
--->
<cffunction name='alt_aplicabilidade' displayname='Alterar aplicabilidade do documento' access='remote' returntype='Struct' output='true'>
	<cfargument name='APLICABILIDADE_ID' required='yes'>
	<cfargument name='P_DOCUMENTO_ID' required='yes'>
	<cfargument name='P_AREA_ID' required='yes'>
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='qualidade.pkg_aplicabilidade.prc_alt_aplicabilidade' datasource='#session.dsn#' username='#session.usuario#' 
               password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_APLICABILIDADE_ID'  value='#arguments.APLICABILIDADE_ID#' 
                   null='#iif(len(trim(arguments.APLICABILIDADE_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DOCUMENTO_ID'  value='#arguments.P_DOCUMENTO_ID#'  
                   null='#iif(len(trim(arguments.P_DOCUMENTO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_AREA_ID'  value='#arguments.P_AREA_ID#'  
                   null='#iif(len(trim(arguments.P_AREA_ID)), de('no'), de('yes'))#'>
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Documento vinculado a sua novas rea(s) com sucesso.')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>  
<!--- 
-- PROPSITO
-- Excluir aplicabilidade do documento
-- luizgomes 16/10/2014 15:45:38 - CRIADO
--->
<cffunction name='del_aplicabilidade' displayname='Excluir aplicabilidade do documento' access='remote' returntype='Struct' output='true'>
	<cfargument name='APLICABILIDADE_ID' required='yes'>
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='qualidade.pkg_aplicabilidade.prc_del_aplicabilidade' datasource='#session.dsn#' username='#session.usuario#' 
                password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_APLICABILIDADE_ID'  value='#arguments.APLICABILIDADE_ID#'  
                    null='#iif(len(trim(arguments.APLICABILIDADE_ID)), de('no'), de('yes'))#'>
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Documento desvinculado da(s) rea(s) com sucesso.')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

</cfcomponent>