<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPSITO
    -- Cadastrar um novo requisito de avaliao de fornecedores.
    -- JAQUELINEF 10/12/2012 11:36:11 - CRIADO
    --->
    <cffunction name='ins_requisito_avaliacao' displayname='Cadastrar um novo requisito de avaliao de fornecedores.' access='remote' returntype='Struct' output='true'>
        <cfargument name='DESCRICAO' required='yes'>
        <cfargument name='RAMO_ATIVIDADE_ID' required='no' default="">
        <cfargument name='STATUS' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='qualidade.pkg_avaliacao_fornecedor.prc_ins_requisito_avaliacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_STATUS'  value='#arguments.STATUS#'  null='#iif(len(trim(arguments.STATUS)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Requisito cadastrado com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Editar um requisito de avaliao de fornecedores.
    -- JAQUELINEF 10/12/2012 11:16:26 - CRIADO
    --->
    <cffunction name='upd_requisito_avaliacao' displayname='Editar um requisito de avaliao de fornecedores.' access='remote' returntype='Struct' output='true'>
        <cfargument name='DESCRICAO' required='yes'>
        <cfargument name='RAMO_ATIVIDADE_ID' required='no' default="">
        <cfargument name='STATUS' required='yes'>
        <cfargument name='REQUISITO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='qualidade.pkg_avaliacao_fornecedor.prc_alt_requisito_avaliacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_STATUS'  value='#arguments.STATUS#'  null='#iif(len(trim(arguments.STATUS)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REQUISITO_ID'  value='#arguments.REQUISITO_ID#'  null='#iif(len(trim(arguments.REQUISITO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Requisito alterado com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
    
	<!--- 
    -- PROPSITO
    -- Excluir um requisito de avaliao de fornecedores.
    -- JAQUELINEF 10/12/2012 11:17:08 - CRIADO
    --->
    <cffunction name='del_requisito_avaliacao' displayname='Excluir um requisito de avaliao de fornecedores.' access='remote' returntype='Struct' output='true'>
        <cfargument name='REQUISITO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='qualidade.pkg_avaliacao_fornecedor.prc_del_requisito_avaliacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REQUISITO_ID'  value='#arguments.REQUISITO_ID#'  null='#iif(len(trim(arguments.REQUISITO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Requisito excludo com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Cadastrar um novo fornecedor.
    -- JAQUELINEF 10/12/2012 17:52:02 - CRIADO
    --->
    <cffunction name='ins_fornecedor' displayname='Cadastrar um novo fornecedor.' access='remote' returntype='Struct' output='true'>
        <cfargument name='RAZAO_SOCIAL' required='yes'>
        <cfargument name='NOME_FANTASIA' required='yes'>
        <cfargument name='CNPJ' required='yes'>
        <cfargument name='ENDERECO' required='yes'>
        <cfargument name='RESIDUOS' required='yes'>
        <cfargument name='COD_PESSOA_FILIAL' required='yes'>
        <cfargument name='CONTATO' required='yes'>
        <cfargument name='PRODUTOS' required='yes'>
        <cfargument name='SETOR' required='yes'>
        <cfargument name='CENTRO_CUSTO' required='yes'>
        <cfargument name='STATUS_ID' required='yes'>
        <cfargument name='QUALIFICADO' required='yes'>
        <cfargument name='COD_PESSOA' required='no' default="">
        <cfargument name='REQUISITOS' required='yes'>
        <cfargument name='DOCUMENTOS' required='yes'>
        <cfargument name='EMAILS' required='yes'>
        <cfargument name='RAMO_ATIVIDADE_ID' required='no' default="">
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='qualidade.pkg_avaliacao_fornecedor.prc_ins_fornecedor' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FORNECEDOR_ID' variable='retorno.FORNECEDOR_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RAZAO_SOCIAL'  value='#arguments.RAZAO_SOCIAL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME_FANTASIA'  value='#arguments.NOME_FANTASIA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CNPJ'  value='#arguments.CNPJ#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENDERECO'  value='#arguments.ENDERECO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RESIDUOS'  value='#arguments.RESIDUOS#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_PESSOA_FILIAL'  value='#arguments.COD_PESSOA_FILIAL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONTATO'  value='#arguments.CONTATO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PRODUTOS'  value='#arguments.PRODUTOS#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_SETOR'  value='#arguments.SETOR#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CENTRO_CUSTO'  value='#arguments.CENTRO_CUSTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_STATUS_ID'  value='#arguments.STATUS_ID#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_QUALIFICADO'  value='#arguments.QUALIFICADO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_RAMO_ATIVIDADE_ID'  value='#arguments.RAMO_ATIVIDADE_ID#'  null='#iif(len(trim(arguments.RAMO_ATIVIDADE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
                </cfstoredproc>                
                <cfscript>
    	            v_docto		   = this.ListaToArray (lista = arguments, variavel = "NOME_DOCUMENTOS");
	                v_vencimentos  = this.ListaToArray (lista = arguments, variavel = "VENCIMENTO_DOCUMENTOS");
                    v_anexo_id 	   = this.ListaToArray(lista = arguments, variavel  = 'ANEXO_ID_DOCUMENTOS');
                </cfscript>
                <cfloop from="1" to="#ArrayLen(v_docto)#" index="count">
               		<cfscript>
						this.ins_fornecedor_documento(nome          = v_docto[count]
													 ,vencimento    = v_vencimentos[count]
													 ,fornecedor_id = retorno.FORNECEDOR_ID
													 ,anexo_id  = v_anexo_id[count]);
                    </cfscript>
                </cfloop>
                
                <!--- EMAIL --->
                <cfscript>
    	            v_email = this.ListaToArray (lista = arguments, variavel = "EMAIL_ENDERECO_EMAILS");
	                v_proprietario = this.ListaToArray (lista = arguments, variavel = "PROPRIETARIO_EMAILS");
                </cfscript>
                <cfloop from="1" to="#ArrayLen(v_email)#" index="count">
               		<cfscript>
                    	this.ins_fornecedor_email(PROPRIETARIO   = v_proprietario[count]
					                             ,EMAIL_ENDERECO = v_email[count]
                                                 ,fornecedor_id  = retorno.FORNECEDOR_ID);
                    </cfscript>
                </cfloop>
                                
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Fornecedor cadastrado com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Editar um fornecedor.
    -- JAQUELINEF 10/12/2012 17:53:01 - CRIADO
    --->
    <cffunction name='upd_fornecedor' displayname='Editar um fornecedor.' access='remote' returntype='Struct' output='true'>
        <cfargument name='RAZAO_SOCIAL' required='yes'>
        <cfargument name='NOME_FANTASIA' required='yes'>
        <cfargument name='CNPJ' required='yes'>
        <cfargument name='ENDERECO' required='yes'>
        <cfargument name='RESIDUOS' required='yes'>
        <cfargument name='COD_PESSOA_FILIAL' required='yes'>
        <cfargument name='CONTATO' required='yes'>
        <cfargument name='FORNECEDOR_ID' required='yes'>
        <cfargument name='PRODUTOS' required='yes'>
        <cfargument name='SETOR' required='yes'>
        <cfargument name='CENTRO_CUSTO' required='yes'>
        <cfargument name='STATUS_ID' required='yes'>
        <cfargument name='QUALIFICADO' required='yes'>
        <cfargument name='COD_PESSOA' required='no' default="">
        <cfargument name='REQUISITOS' required='yes'>
        <cfargument name='DOCUMENTOS' required='yes'>
        <cfargument name='EMAILS' required='yes'>
        <cfargument name='RAMO_ATIVIDADE_ID' required='no' default="">
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='qualidade.pkg_avaliacao_fornecedor.prc_alt_fornecedor' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RAZAO_SOCIAL'  value='#arguments.RAZAO_SOCIAL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME_FANTASIA'  value='#arguments.NOME_FANTASIA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CNPJ'  value='#arguments.CNPJ#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENDERECO'  value='#arguments.ENDERECO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RESIDUOS'  value='#arguments.RESIDUOS#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_PESSOA_FILIAL'  value='#arguments.COD_PESSOA_FILIAL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONTATO'  value='#arguments.CONTATO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FORNECEDOR_ID'  value='#arguments.FORNECEDOR_ID#'  null='#iif(len(trim(arguments.FORNECEDOR_ID)), de('no'), de('yes'))#'>                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PRODUTOS'  value='#arguments.PRODUTOS#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_SETOR'  value='#arguments.SETOR#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CENTRO_CUSTO'  value='#arguments.CENTRO_CUSTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_STATUS_ID'  value='#arguments.STATUS_ID#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_QUALIFICADO'  value='#arguments.QUALIFICADO#' null='#iif(len(trim(arguments.QUALIFICADO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_RAMO_ATIVIDADE_ID'  value='#arguments.RAMO_ATIVIDADE_ID#'  null='#iif(len(trim(arguments.RAMO_ATIVIDADE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#' null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <!--- DOCUMENTOS --->
                <cfscript>
    	            v_docto = this.ListaToArray (lista = arguments, variavel = "NOME_DOCUMENTOS");
					v_docto_id = this.ListaToArray (lista = arguments, variavel = "DOCUMENTO_ID_DOCUMENTOS");
	                v_vencimentos = this.ListaToArray (lista = arguments, variavel = "VENCIMENTO_DOCUMENTOS");
                    v_anexo_id 	   = this.ListaToArray(lista = arguments, variavel = 'ANEXO_ID_DOCUMENTOS');
                </cfscript>
                <cfloop list="#arguments.LISTA_DELETED_DOCUMENTOS#" index="v_documento_id" delimiters=",">
                	<cfscript>
						this.del_fornecedor_documento(DOCUMENTO_ID = v_documento_id);
					</cfscript>
                </cfloop>
                <cfloop from="1" to="#ArrayLen(v_docto)#" index="count">
               		<cfscript>
						if(not len(trim(v_docto_id[count]))) {
	                    	this.ins_fornecedor_documento(NOME          = v_docto[count]
						                                 ,vencimento    = v_vencimentos[count]
                                                         ,fornecedor_id = arguments.FORNECEDOR_ID
													     ,anexo_id      = v_anexo_id[count]);
						} else{
	                    	this.alt_fornecedor_documento(DOCUMENTO_ID  = v_docto_id[count]
													     ,NOME          = v_docto[count]
						    	                         ,vencimento    = v_vencimentos[count]
                                	                     ,fornecedor_id = arguments.FORNECEDOR_ID
													     ,anexo_id  	= v_anexo_id[count]);
						}
                    </cfscript>
                </cfloop>
                
                <!--- EMAIL --->
                <cfscript>
    	            v_email = this.ListaToArray (lista = arguments, variavel = "EMAIL_ENDERECO_EMAILS");
					v_email_id = this.ListaToArray (lista = arguments, variavel = "EMAIL_ID_EMAILS");
	                v_proprietario = this.ListaToArray (lista = arguments, variavel = "PROPRIETARIO_EMAILS");
                </cfscript>
                <cfloop list="#arguments.LISTA_DELETED_EMAILS#" index="v_email_id_del" delimiters=",">
                	<cfscript>
						this.del_fornecedor_email(EMAIL_ID = v_email_id_del);
					</cfscript>
                </cfloop>
                <cfloop from="1" to="#ArrayLen(v_email)#" index="count">
               		<cfscript>
						if(not len(trim(v_email_id[count]))) {
	                    	this.ins_fornecedor_email(PROPRIETARIO   = v_proprietario[count]
						                             ,EMAIL_ENDERECO = v_email[count]
                                                     ,fornecedor_id  = arguments.FORNECEDOR_ID);
						} else{
	                    	this.alt_fornecedor_email(EMAIL_ID       = v_email_id[count]
													 ,PROPRIETARIO   = v_proprietario[count]
													 ,EMAIL_ENDERECO = v_email[count]
                                	                 ,fornecedor_id  = arguments.FORNECEDOR_ID);
						}
                    </cfscript>
                </cfloop>                
                
       			<cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Fornecedor alterado com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Excluir um fornecedor.
    -- JAQUELINEF 10/12/2012 17:54:17 - CRIADO
    --->
    <cffunction name='del_fornecedor' displayname='Excluir um fornecedor.' access='remote' returntype='Struct' output='true'>
        <cfargument name='FORNECEDOR_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='qualidade.pkg_avaliacao_fornecedor.prc_del_fornecedor' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FORNECEDOR_ID'  value='#arguments.FORNECEDOR_ID#'  null='#iif(len(trim(arguments.FORNECEDOR_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Fornecedor excludo com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
        
	<!--- 
    -- PROPSITO
    -- Inserir uma avaliao de fornecedor.
    -- JAQUELINEF 14/12/2012 12:07:31 - CRIADO
    --->
    <cffunction name='ins_avaliacao' displayname='Inserir uma avaliao de fornecedor.' access='remote' returntype='Struct' output='true'>
        <cfargument name='FORNECEDOR_ID' required='yes'>
        <cfargument name='OBSERVACAO' required='yes'>
        <cfargument name='REQUISiTOS_PONTOS' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='qualidade.pkg_avaliacao_fornecedor.prc_ins_avaliacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FORNECEDOR_ID'  value='#arguments.FORNECEDOR_ID#'  null='#iif(len(trim(arguments.FORNECEDOR_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REQUISiTOS_PONTOS'  value='#arguments.REQUISiTOS_PONTOS#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Avaliao realizada com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>        
        
	<!--- 
    -- PROPSITO
    -- Insere documentos do fornecedor
    -- GUSTAVOC 05/05/2014 17:50:54 - CRIADO
    --->
    <cffunction name='ins_fornecedor_documento' displayname='Insere documentos do fornecedor' access='remote' returntype='Struct' output='true'>
        <cfargument name='NOME' required='yes'>
        <cfargument name='VENCIMENTO' required='yes'>
        <cfargument name='FORNECEDOR_ID' required='yes'>
        <cfargument name='ANEXO_ID' required='no' default="">
                <cfstoredproc procedure='qualidade.pkg_avaliacao_fornecedor.prc_ins_fornecedor_documento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_VENCIMENTO'  value='#arguments.VENCIMENTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FORNECEDOR_ID'  value='#arguments.FORNECEDOR_ID#'  null='#iif(len(trim(arguments.FORNECEDOR_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DOC_ANEXO_ID'  value='#arguments.ANEXO_ID#'  null='#iif(len(trim(arguments.ANEXO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
        <cfreturn structnew() />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Altera documentos do fornecedor
    -- GUSTAVOC 05/05/2014 18:09:48 - CRIADO
    --->
    <cffunction name='alt_fornecedor_documento' displayname='Altera documentos do fornecedor' access='remote' returntype='Struct' output='true'>
        <cfargument name='DOCUMENTO_ID' required='yes'>
        <cfargument name='NOME' required='yes'>
        <cfargument name='VENCIMENTO' required='yes'>
        <cfargument name='FORNECEDOR_ID' required='yes'>
        <cfargument name='ANEXO_ID' required='no' default="">
                <cfstoredproc procedure='qualidade.pkg_avaliacao_fornecedor.prc_alt_fornecedor_documento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DOCUMENTO_ID'  value='#arguments.DOCUMENTO_ID#'  null='#iif(len(trim(arguments.DOCUMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_VENCIMENTO'  value='#arguments.VENCIMENTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FORNECEDOR_ID'  value='#arguments.FORNECEDOR_ID#'  null='#iif(len(trim(arguments.FORNECEDOR_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DOC_ANEXO_ID'  value='#arguments.ANEXO_ID#'  null='#iif(len(trim(arguments.ANEXO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
        <cfreturn structnew() />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Remove documento do fornecedor
    -- GUSTAVOC 05/05/2014 18:33:07 - CRIADO
    --->
    <cffunction name='del_fornecedor_documento' displayname='Remove documento do fornecedor' access='remote' returntype='Struct' output='true'>
        <cfargument name='DOCUMENTO_ID' required='yes'>
                <cfstoredproc procedure='qualidade.pkg_avaliacao_fornecedor.prc_del_fornecedor_documento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DOCUMENTO_ID'  value='#arguments.DOCUMENTO_ID#'  null='#iif(len(trim(arguments.DOCUMENTO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
        <cfreturn structnew() />
    </cffunction>
    
    
    <!--- 
    -- PROPSITO
    -- Insere email do fornecedor
    -- GUSTAVOC 05/05/2014 18:31:03 - CRIADO
    --->
    <cffunction name='ins_fornecedor_email' displayname='Insere email do fornecedor' access='remote' returntype='Struct' output='true'>
        <cfargument name='PROPRIETARIO' required='yes'>
        <cfargument name='EMAIL_ENDERECO' required='yes'>
        <cfargument name='FORNECEDOR_ID' required='yes'>
                <cfstoredproc procedure='qualidade.pkg_avaliacao_fornecedor.prc_ins_fornecedor_email' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PROPRIETARIO'  value='#arguments.PROPRIETARIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMAIL_ENDERECO'  value='#arguments.EMAIL_ENDERECO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FORNECEDOR_ID'  value='#arguments.FORNECEDOR_ID#'  null='#iif(len(trim(arguments.FORNECEDOR_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
        <cfreturn structnew() />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Altera email do fornecedor
    -- GUSTAVOC 05/05/2014 18:31:03 - CRIADO
    --->
    <cffunction name='alt_fornecedor_email' displayname='Altera email do fornecedor' access='remote' returntype='Struct' output='true'>
        <cfargument name='EMAIL_ID' required='yes'>
        <cfargument name='PROPRIETARIO' required='yes'>
        <cfargument name='EMAIL_ENDERECO' required='yes'>
        <cfargument name='FORNECEDOR_ID' required='yes'>
                <cfstoredproc procedure='qualidade.pkg_avaliacao_fornecedor.prc_alt_fornecedor_email' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EMAIL_ID'  value='#arguments.EMAIL_ID#'  null='#iif(len(trim(arguments.EMAIL_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PROPRIETARIO'  value='#arguments.PROPRIETARIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMAIL_ENDERECO'  value='#arguments.EMAIL_ENDERECO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FORNECEDOR_ID'  value='#arguments.FORNECEDOR_ID#'  null='#iif(len(trim(arguments.FORNECEDOR_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
        <cfreturn structnew() />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Remove email do fornecedor
	-- GUSTAVOC 05/05/2014 18:44:10 - CRIADO
	--->
	<cffunction name='del_fornecedor_email' displayname='Remove email do fornecedor' access='remote' returntype='Struct' output='true'>
		<cfargument name='EMAIL_ID' required='yes'>
				<cfstoredproc procedure='qualidade.pkg_avaliacao_fornecedor.prc_del_fornecedor_email' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EMAIL_ID'  value='#arguments.EMAIL_ID#'  null='#iif(len(trim(arguments.EMAIL_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
    
	<!--- 
    -- PROPSITO
    -- Insere fornecedor requisito
    -- GUSTAVOC 05/05/2014 19:18:49 - CRIADO
    --->
    <cffunction name='ins_fornecedor_requisito' displayname='Insere fornecedor requisito' access='remote' returntype='Struct' output='true'>
        <cfargument name='FORNECEDOR_ID' required='yes'>
        <cfargument name='REQUISITO_ID' required='yes'>
                <cfstoredproc procedure='qualidade.pkg_avaliacao_fornecedor.prc_ins_fornecedor_requisito' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FORNECEDOR_ID'  value='#arguments.FORNECEDOR_ID#'  null='#iif(len(trim(arguments.FORNECEDOR_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REQUISITO_ID'  value='#arguments.REQUISITO_ID#'  null='#iif(len(trim(arguments.REQUISITO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
        <cfreturn structnew() />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Insere fornecedor requisito
    -- GUSTAVOC 05/05/2014 19:19:26 - CRIADO
    --->
    <cffunction name='del_fornecedor_requisito' displayname='Remove fornecedor requisito' access='remote' returntype='Struct' output='true'>
        <cfargument name='REQUISITO_ID' required='yes'>
                <cfstoredproc procedure='qualidade.pkg_avaliacao_fornecedor.prc_del_fornecedor_requisito' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REQUISITO_ID'  value='#arguments.REQUISITO_ID#'  null='#iif(len(trim(arguments.REQUISITO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
        <cfreturn structnew() />
    </cffunction>
    

	<!--- 
    -- PROPSITO
    -- Cadastrar um ramo de atividade.
    -- MARIALICE 22/09/2014 CRIADO
    --->
    <cffunction name='ins_ramo_atividade' displayname='Cadastrar um ramo de atividade.' access='remote' returntype='Struct' output='true'>
        <cfargument name='DESCRICAO' required='yes'>
        <cftry>
        
            <cftransaction action='begin'>
                <cfstoredproc procedure='qualidade.pkg_avaliacao_fornecedor.prc_ins_ramo_atividade' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RAMO_ATIVIDADE_ID' variable='retorno.RAMO_ATIVIDADE_ID' >
                </cfstoredproc>
                
				<cfscript>
                    v_requisito = this.ListaToArray (lista = arguments, variavel = "REQUISITO_ID_REQUISITOS");
                </cfscript>
                
                <cfloop from="1" to="#ArrayLen(v_requisito)#" index="count">
                    <cfscript>
							this.ins_ramo_requisito(ramo_atividade_id = retorno.RAMO_ATIVIDADE_ID
												        ,requisito_id = v_requisito[count]);              
                    </cfscript>
                </cfloop>   
                
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Ramo de atividade cadastrado com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Editar um ramo de atividade.
    -- MARIALICE 22/09/2014 CRIADO
    --->
    <cffunction name='upd_ramo_atividade' displayname='Editar um ramo de atividade.' access='remote' returntype='Struct' output='true'>
        <cfargument name='DESCRICAO' required='yes'>
        <cfargument name='RAMO_ATIVIDADE_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='qualidade.pkg_avaliacao_fornecedor.prc_alt_ramo_atividade' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RAMO_ATIVIDADE_ID'  value='#arguments.RAMO_ATIVIDADE_ID#'  null='#iif(len(trim(arguments.RAMO_ATIVIDADE_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                
				<cfscript>
                    v_ramo_requisito_id = this.ListaToArray (lista = arguments, variavel = "RAMO_ATIVIDADE_REQUISITO_ID_REQUISITOS");
                    v_requisito         = this.ListaToArray (lista = arguments, variavel = "REQUISITO_ID_REQUISITOS");
                    v_excluir 	        = this.ListDiff(lista1 = arguments.lista_deleted_REQUISITOS, lista2 = ArrayToList(v_ramo_requisito_id));
                </cfscript>
                <cfloop list="#v_excluir#" delimiters="," index="l_id"><cfdump var="#v_excluir#">
                    <cfscript>
                        ret =  this.del_ramo_requisito(ramo_atividade_requisito_id = l_id);
                    </cfscript><cfdump var="#ret#">
                     <cfif ret.erro>
						<cfthrow object="#ret.mensagem#">
					</cfif>
                </cfloop>
                <cfloop from="1" to="#ArrayLen(v_ramo_requisito_id)#" index="count">                
					<cfscript>
						if(not len(trim(v_ramo_requisito_id[count]))) {
                           ret = this.ins_ramo_requisito(ramo_atividade_id  = arguments.RAMO_ATIVIDADE_ID
                                                	   ,requisito_id   = v_requisito[count]);
                        } else {
                           ret =  this.upd_ramo_requisito(ramo_atividade_id  = arguments.RAMO_ATIVIDADE_ID
                                                	   ,requisito_id   = v_requisito[count]
                                        ,ramo_atividade_requisito_id   = v_ramo_requisito_id[count]);
                        }
					</cfscript>
                    <cfif ret.erro>
						<cfthrow object="#ret.mensagem#">
					</cfif>
                </cfloop>
                                
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Ramo de atividade alterado com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
    
	<!--- 
    -- PROPSITO
    -- Excluir um ramo de atividade.
    -- MARIALICE 22/09/2014 CRIADO
    --->
    <cffunction name='del_ramo_atividade' displayname='Excluir um ramo de atividade.' access='remote' returntype='Struct' output='true'>
        <cfargument name='RAMO_ATIVIDADE_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='qualidade.pkg_avaliacao_fornecedor.prc_del_ramo_atividade' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RAMO_ATIVIDADE_ID'  value='#arguments.RAMO_ATIVIDADE_ID#'  null='#iif(len(trim(arguments.RAMO_ATIVIDADE_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Ramo de atividade excludo com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Insere ramo requisito
    --->
    <cffunction name='ins_ramo_requisito' displayname='Insere ramo requisito' access='remote' returntype='Struct' output='true'>
        <cfargument name='RAMO_ATIVIDADE_ID' required='yes'>
        <cfargument name='REQUISITO_ID' required='yes'>
        <cftry>		
            <cfstoredproc procedure='qualidade.pkg_avaliacao_fornecedor.prc_ins_ramo_requisito' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RAMO_ATIVIDADE_ID'  value='#arguments.RAMO_ATIVIDADE_ID#'  null='#iif(len(trim(arguments.RAMO_ATIVIDADE_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REQUISITO_ID'  value='#arguments.REQUISITO_ID#'  null='#iif(len(trim(arguments.REQUISITO_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Requisito inserido com sucesso!')>            
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Altera ramo requisito
    --->    
    <cffunction name='upd_ramo_requisito' displayname='Altera ramo requisito' access='remote' returntype='Struct' output='true'>
        <cfargument name='RAMO_ATIVIDADE_ID' required='yes'>
        <cfargument name='REQUISITO_ID' required='yes'>
        <cfargument name='RAMO_ATIVIDADE_REQUISITO_ID' required='yes'>
        <cftry>		
            <cfstoredproc procedure='qualidade.pkg_avaliacao_fornecedor.prc_alt_ramo_requisito' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RAMO_ATIVIDADE_ID'  value='#arguments.RAMO_ATIVIDADE_ID#'  null='#iif(len(trim(arguments.RAMO_ATIVIDADE_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REQUISITO_ID'  value='#arguments.REQUISITO_ID#'  null='#iif(len(trim(arguments.REQUISITO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RAMO_REQUISITO_ID'  value='#arguments.RAMO_ATIVIDADE_REQUISITO_ID#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Requisito excluido com sucesso!')>            
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Exclui ramo requisito
    --->    
    <cffunction name='del_ramo_requisito' displayname='Exclui ramo requisito' access='remote' returntype='Struct' output='true'>
        <cfargument name='RAMO_ATIVIDADE_REQUISITO_ID' required='yes'>
        <cftry>		
            <cfstoredproc procedure='qualidade.pkg_avaliacao_fornecedor.prc_del_ramo_requisito' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RAMO_REQUISITO_ID'  value='#arguments.RAMO_ATIVIDADE_REQUISITO_ID#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Requisito excluido com sucesso!')>            
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
</cfcomponent>