<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
-- PROPSITO
-- Insere as solicitaes de pernoite
-- LEANDROR 23/07/2010 15:44:14 - CRIADO
--->
<cffunction name='ins_solicitacao_pernoite' displayname='Insere as solicitaes de pernoite' access='remote' returntype='Struct' output='true'>
	<cfargument name='VEICULO_ID' required='yes'>
	<cfargument name='COD_MOTORISTA' required='yes'>
	<cfargument name='HORA_SOLICITADA_INICIO' required='yes'>
	<cfargument name='HORA_SOLICITADA_TERMINO' required='yes'>
	<cfargument name='LATITUDE' required='yes'>
	<cfargument name='LONGITUDE' required='yes'>
	<cfargument name='COD_SOLICITANTE' required='yes'>
	<cfargument name='MOTIVO_SOLICITACAO' required='yes'>
	<cfargument name='NUM_ROMANEIO' required='yes'>
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='logistica.pkg_pernoite.prc_ins_solicitacao_pernoite' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SOLICITACAO_ID' variable='retorno.SOLICITACAO_ID' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VEICULO_ID'  value='#arguments.VEICULO_ID#'  null='#iif(len(trim(arguments.VEICULO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_MOTORISTA'  value='#arguments.COD_MOTORISTA#'  null='#iif(len(trim(arguments.COD_MOTORISTA)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_HORA_SOLICITADA_INICIO'  value='#arguments.HORA_SOLICITADA_INICIO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_HORA_SOLICITADA_TERMINO'  value='#arguments.HORA_SOLICITADA_TERMINO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LATITUDE'  value='#arguments.LATITUDE#'  null='#iif(len(trim(arguments.LATITUDE)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LONGITUDE'  value='#arguments.LONGITUDE#'  null='#iif(len(trim(arguments.LONGITUDE)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_SOLICITANTE'  value='#arguments.COD_SOLICITANTE#'  null='#iif(len(trim(arguments.COD_SOLICITANTE)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MOTIVO_SOLICITACAO'  value='#arguments.MOTIVO_SOLICITACAO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Solicitao inserida com sucesso!')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

<!--- 
-- PROPSITO
-- Altera as solicitaes de pernoite
-- LEANDROR 23/07/2010 16:22:52 - CRIADO
--->
<cffunction name='alt_solicitacao_pernoite' displayname='Altera as solicitaes de pernoite' access='remote' returntype='Struct' output='true'>
	<cfargument name='SOLICITACAO_ID' required='yes'>
	<cfargument name='VEICULO_ID' required='yes'>
	<cfargument name='COD_MOTORISTA' required='yes'>
	<cfargument name='HORA_SOLICITADA_INICIO' required='yes'>
	<cfargument name='HORA_SOLICITADA_TERMINO' required='yes'>
	<cfargument name='LATITUDE' required='yes'>
	<cfargument name='LONGITUDE' required='yes'>
	<cfargument name='COD_SOLICITANTE' required='yes'>
	<cfargument name='MOTIVO_SOLICITACAO' required='yes'>
	<cfargument name='NUM_ROMANEIO' required='yes'>
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='logistica.pkg_pernoite.prc_alt_solicitacao_pernoite' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SOLICITACAO_ID'  value='#arguments.SOLICITACAO_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VEICULO_ID'  value='#arguments.VEICULO_ID#'  null='#iif(len(trim(arguments.VEICULO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_MOTORISTA'  value='#arguments.COD_MOTORISTA#'  null='#iif(len(trim(arguments.COD_MOTORISTA)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_HORA_SOLICITADA_INICIO'  value='#arguments.HORA_SOLICITADA_INICIO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_HORA_SOLICITADA_TERMINO'  value='#arguments.HORA_SOLICITADA_TERMINO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LATITUDE'  value='#arguments.LATITUDE#'  null='#iif(len(trim(arguments.LATITUDE)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LONGITUDE'  value='#arguments.LONGITUDE#'  null='#iif(len(trim(arguments.LONGITUDE)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_SOLICITANTE'  value='#arguments.COD_SOLICITANTE#'  null='#iif(len(trim(arguments.COD_SOLICITANTE)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MOTIVO_SOLICITACAO'  value='#arguments.MOTIVO_SOLICITACAO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Solicitao alterada com sucesso!')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

<!--- 
-- PROPSITO
-- Exclui as solicitaes de pernoite
-- LEANDROR 23/07/2010 16:24:14 - CRIADO
--->
<cffunction name='del_solicitacao_pernoite' displayname='Exclui as solicitaes de pernoite' access='remote' returntype='Struct' output='true'>
	<cfargument name='SOLICITACAO_ID' required='yes'>
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='logistica.pkg_pernoite.prc_del_solicitacao_pernoite' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SOLICITACAO_ID'  value='#arguments.SOLICITACAO_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_ID)), de('no'), de('yes'))#'>
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Solicitao excluda com sucesso!')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>
   
</cfcomponent>