<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO
	-- Insere uma liberao para uma gerenciadora
	-- ANDERSONC 21/12/2009 14:19:29 - CRIADO
	--->
	<cffunction name='ins_gerenciadora_liberacao' displayname='Insere uma liberao para uma gerenciadora' access='remote' returntype='Struct' output='true'>
		<cfargument name='GERENCIADORA_ID' required='yes'>
		<cfargument name='SITUACAO_ID' required='yes'>
		<cfargument name='COD_LIBERACAO' required='yes'>
		<cfargument name='TIPO_ID' required='yes'>
		<cfargument name='DATA_INICIO' required='yes'>
		<cfargument name='DATA_TERMINO' required='yes'>
		<cfargument name='NRO_VIAGENS' required='yes'>
		<cfargument name='TIPO_LIBERACAO_ID' required='yes'>
		<cfargument name='VEICULO_ID' required='yes'>
		<cfargument name='COD_MOTORISTA' required='yes'>
		<cfargument name='MOTIVO' required='yes'>
		<cfargument name='CONSULTA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='logistica.pkg_risco.prc_ins_gerenciadora_liberacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LIBERACAO_ID' variable='retorno.LIBERACAO_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_GERENCIADORA_ID'  value='#arguments.GERENCIADORA_ID#'  null='#iif(len(trim(arguments.GERENCIADORA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SITUACAO_ID'  value='#arguments.SITUACAO_ID#'  null='#iif(len(trim(arguments.SITUACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_LIBERACAO'  value='#arguments.COD_LIBERACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_ID'  value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO'  value='#arguments.DATA_INICIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_TERMINO'  value='#arguments.DATA_TERMINO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NRO_VIAGENS'  value='#arguments.NRO_VIAGENS#'  null='#iif(len(trim(arguments.NRO_VIAGENS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_LIBERACAO_ID'  value='#arguments.TIPO_LIBERACAO_ID#'  null='#iif(len(trim(arguments.TIPO_LIBERACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VEICULO_ID'  value='#arguments.VEICULO_ID#'  null='#iif(len(trim(arguments.VEICULO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_MOTORISTA'  value='#arguments.COD_MOTORISTA#'  null='#iif(len(trim(arguments.COD_MOTORISTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_MOTIVO'  value='#arguments.MOTIVO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_CONSULTA'  value='#arguments.CONSULTA#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Consulta cadastral inserida com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Cancela uma liberao de uma gerenciadora
	-- ANDERSONC 21/12/2009 14:20:19 - CRIADO
	--->
	<cffunction name='can_gerenciadora_liberacao' displayname='Cancela uma liberao de uma gerenciadora' access='remote' returntype='Struct' output='true'>
		<cfargument name='LIBERACAO_ID' required='yes'>
		<cfargument name='MOTIVO_CANCELAMENTO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='logistica.pkg_risco.prc_can_gerenciadora_liberacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LIBERACAO_ID'  value='#arguments.LIBERACAO_ID#'  null='#iif(len(trim(arguments.LIBERACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_MOTIVO_CANCELAMENTO'  value='#arguments.MOTIVO_CANCELAMENTO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Consulta cadastral cancelada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Insere uma liberao de um motorista para uma gerenciadora
	-- ANDERSONC 22/12/2009 14:04:06 - CRIADO
	--->
	<cffunction name='ins_consulta_motorista' displayname='Insere uma liberao de um motorista para uma gerenciadora' access='remote' returntype='Struct' output='true'>
		<cfargument name='GERENCIADORA_ID' required='yes'>
		<cfargument name='COD_MOTORISTA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='logistica.pkg_risco.prc_ins_consulta_motorista' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LIBERACAO_ID' variable='retorno.LIBERACAO_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_GERENCIADORA_ID'  value='#arguments.GERENCIADORA_ID#'  null='#iif(len(trim(arguments.GERENCIADORA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_MOTORISTA'  value='#arguments.COD_MOTORISTA#'  null='#iif(len(trim(arguments.COD_MOTORISTA)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Consulta cadastral inserida com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Insere uma liberao de um veculo para uma gerenciadora
	-- ANDERSONC 22/12/2009 14:21:12 - CRIADO
	--->
	<cffunction name='ins_consulta_veiculo' displayname='Insere uma liberao de um veculo para uma gerenciadora' access='remote' returntype='Struct' output='true'>
		<cfargument name='GERENCIADORA_ID' required='yes'>
		<cfargument name='VEICULO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='logistica.pkg_risco.prc_ins_consulta_veiculo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LIBERACAO_ID' variable='retorno.LIBERACAO_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_GERENCIADORA_ID'  value='#arguments.GERENCIADORA_ID#'  null='#iif(len(trim(arguments.GERENCIADORA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VEICULO_ID'  value='#arguments.VEICULO_ID#'  null='#iif(len(trim(arguments.VEICULO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Consulta cadastral inserida com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
</cfcomponent>