<cfcomponent extends="_transportes.funcoes.cfc_init">

	<!--- 
    -- PROPÓSITO
    -- Inserir Estimativa de Faturamento
    -- LEANDROR 23/04/2010 10:09:36 - CRIADO
    --->
    <cffunction name='ins_estimativa' displayname='Inserir Estimativa de Faturamento' access='remote' returntype='Struct' output='true'>
        <cfargument name='COD_CENTRO_CUSTO' required='yes'>
        <cfargument name='DATA_ESTIMATIVA' required='yes'>
        <cfargument name='VALOR_ESTIMADO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='fiscal.pkg_faturamento.prc_ins_estimativa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_ESTIMATIVA'  value='#arguments.DATA_ESTIMATIVA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_ESTIMADO'  value='#arguments.VALOR_ESTIMADO#'  null='#iif(len(trim(arguments.VALOR_ESTIMADO)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Estimativa de faturamento inserida com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
         
    <!--- 
    -- PROPÓSITO
    -- Alterar Estimativa de Faturamento
    
    -- LEANDROR 23/04/2010 10:32:04 - CRIADO
    --->
    <cffunction name='upd_estimativa' displayname='Alterar Estimativa de Faturamento' access='remote' returntype='Struct' output='true'>
        <cfargument name='COD_CENTRO_CUSTO' required='yes'>
        <cfargument name='DATA_ESTIMATIVA' required='yes'>
        <cfargument name='VALOR_ESTIMADO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='fiscal.pkg_faturamento.prc_alt_estimativa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_ESTIMATIVA'  value='#arguments.DATA_ESTIMATIVA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_ESTIMADO'  value='#arguments.VALOR_ESTIMADO#'  null='#iif(len(trim(arguments.VALOR_ESTIMADO)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Estimativa de faturamento alterada com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!--- 
	-- PROPÓSITO
	-- Inserir os faturamentos da ALL
	-- FABIOG 15/07/2011 11:55:51 - CRIADO
	--->
	<cffunction name='ins_faturamento_all' displayname='Inserir os faturamentos da ALL' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_CENTRO_CUSTO' required='yes'>
		<cfargument name='DATA_ESTIMATIVA' required='yes'>
		<cfargument name='VALOR_ESTIMADO' required='yes'>
		<cfargument name='VALOR_REALIZADO' required='yes'>
		<cfargument name='CARTA_FRETE_FATURAMENTO' required='yes'>
		<cfargument name='CARTA_FRETE_NORMAL_CUSTO' required='yes'>
		<cfargument name='CARTA_FRETE_AVULSA' required='yes'>
		<cftry>
            <cfstoredproc procedure='fiscal.pkg_faturamento.prc_ins_faturamento_all' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_ESTIMATIVA'  value='#arguments.DATA_ESTIMATIVA#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_ESTIMADO'  value='#arguments.VALOR_ESTIMADO#'  null='#iif(len(trim(arguments.VALOR_ESTIMADO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_REALIZADO'  value='#arguments.VALOR_REALIZADO#'  null='#iif(len(trim(arguments.VALOR_REALIZADO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CARTA_FRETE_FATURAMENTO'  value='#arguments.CARTA_FRETE_FATURAMENTO#'  null='#iif(len(trim(arguments.CARTA_FRETE_FATURAMENTO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CARTA_FRETE_NORMAL_CUSTO'  value='#arguments.CARTA_FRETE_NORMAL_CUSTO#'  null='#iif(len(trim(arguments.CARTA_FRETE_NORMAL_CUSTO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CARTA_FRETE_AVULSA'  value='#arguments.CARTA_FRETE_AVULSA#'  null='#iif(len(trim(arguments.CARTA_FRETE_AVULSA)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
        <cfcatch>
            <cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
            <cfset request.erro = cfcatch>
        </cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPÓSITO
	-- Inserir os faturamentos da ALL.
	-- FABIOG 14/07/2011 16:50:35 - CRIADO
	--->
	<cffunction name='faturamento_all' displayname='Inserir os faturamentos da ALL.' access='remote' returntype='Struct' output='true'>
		<cftry>
			<cftransaction action='begin'>
				<cfscript>
                    v_cod_centro_custo = this.ListaToArray(lista = arguments, variavel = 'COD_CENTRO_CUSTO_VALORES');
					v_data_estimativa  = this.ListaToArray(lista = arguments, variavel = 'DATA_ESTIMATIVA_VALORES');
					v_valor_estimado   = this.ListaToArray(lista = arguments, variavel = 'VALOR_ESTIMADO_VALORES');
					v_valor_realizado  = this.ListaToArray(lista = arguments, variavel = 'VALOR_REALIZADO_VALORES');
					v_cf_faturamento   = this.ListaToArray(lista = arguments, variavel = 'CARTA_FRETE_FATURAMENTO_VALORES');
					v_cf_normal_custo  = this.ListaToArray(lista = arguments, variavel = 'CARTA_FRETE_NORMAL_CUSTO_VALORES');
					v_cf_avulsa        = this.ListaToArray(lista = arguments, variavel = 'CARTA_FRETE_AVULSA_VALORES');
                </cfscript>
                
                <cfloop from="1" to="#ArrayLen(v_cod_centro_custo)#" index="count_cc">
                    <cfscript>
                        ret_fat = this.ins_faturamento_all(cod_centro_custo  		= v_cod_centro_custo[count_cc]
														  ,data_estimativa   		= v_data_estimativa[count_cc]
														  ,valor_estimado    		= v_valor_estimado[count_cc]
														  ,valor_realizado   	    = v_valor_realizado[count_cc]
														  ,carta_frete_faturamento  = v_cf_faturamento[count_cc]
														  ,carta_frete_normal_custo = v_cf_normal_custo[count_cc]
														  ,carta_frete_avulsa  	    = v_cf_avulsa[count_cc]
														  );
                    </cfscript>
                    <cfif ret_fat.erro>
                        <cfthrow object="#ret_fat.mensagem#">
                    </cfif>
                </cfloop>
                
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Faturamento(s)/Estimativa(s) inserido(s) com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    
    <!--- 
	-- PROPÓSITO
	-- Inserir Estimativa de Faturamento Gerencial
	-- MARIA 25/10/2011 - CRIADO
	--->
	<cffunction name='ins_estimativa_gerencial' displayname='Inserir Estimativa de Faturamento Gerencial' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_CENTRO_CUSTO' required='yes'>
		<cfargument name='DATA_ESTIMATIVA' required='yes'>
		<cfargument name='VALOR_ESTIMADO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_faturamento.prc_ins_estimativa_gerencial' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ORGANIZACIONAL_ID_GERENCIAL'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_ESTIMATIVA'  value='#arguments.DATA_ESTIMATIVA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_ESTIMADO'  value='#arguments.VALOR_ESTIMADO#'  null='#iif(len(trim(arguments.VALOR_ESTIMADO)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Estimativa de faturamento inserida com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
		 
	<!--- 
	-- PROPÓSITO
	-- Alterar Estimativa de Faturamento Gerencial
	-- MARIA 25/10/2011 - CRIADO
	--->
	<cffunction name='upd_estimativa_gerencial' displayname='Alterar Estimativa de Faturamento Gerencial' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_CENTRO_CUSTO' required='yes'>
		<cfargument name='DATA_ESTIMATIVA' required='yes'>
		<cfargument name='VALOR_ESTIMADO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_faturamento.prc_alt_estimativa_gerencial' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ORGANIZACIONAL_ID_GERENCIAL'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_ESTIMATIVA'  value='#arguments.DATA_ESTIMATIVA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_ESTIMADO'  value='#arguments.VALOR_ESTIMADO#'  null='#iif(len(trim(arguments.VALOR_ESTIMADO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Estimativa de faturamento alterada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
        
</cfcomponent>