<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPSITO
    -- Reintegrar Mensagem
    -- ANDERSONC 30/07/2010 10:23:24 - CRIADO
    --->
    <cffunction name='reintegra_mensagem' displayname='Reintegrar Mensagem' access='remote' returntype='Struct' output='true'>
        <cfargument name='MENSAGEM_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='integracao.pkg_mensagem.prc_reintegra_mensagem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MENSAGEM_ID'  value='#arguments.MENSAGEM_ID#'  null='#iif(len(trim(arguments.MENSAGEM_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Mensagem reintegrada com sucesso.')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Conferir Mensagem
    -- ANDERSONC 30/07/2010 10:26:30 - CRIADO
    --->
    <cffunction name='conferir_mensagem' displayname='Conferir Mensagem' access='remote' returntype='Struct' output='true'>
        <cfargument name='MENSAGEM_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='integracao.pkg_mensagem.prc_conferir_mensagem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MENSAGEM_ID'  value='#arguments.MENSAGEM_ID#'  null='#iif(len(trim(arguments.MENSAGEM_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Mensagem conferida com sucesso.')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Desconferir Mensagem
    -- ANDERSONC 30/07/2010 10:27:13 - CRIADO
    --->
    <cffunction name='desconferir_mensagem' displayname='Desconferir Mensagem' access='remote' returntype='Struct' output='true'>
        <cfargument name='MENSAGEM_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='integracao.pkg_mensagem.prc_desconferir_mensagem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MENSAGEM_ID'  value='#arguments.MENSAGEM_ID#'  null='#iif(len(trim(arguments.MENSAGEM_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Mensagem desconferida com sucesso.')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Restaurar Dados Originais
    -- ANDERSONC 30/07/2010 10:27:13 - CRIADO
    --->
    <cffunction name='reprocessar_mensagem' displayname='Desconferir Mensagem' access='remote' returntype='Struct' output='true'>
        <cfargument name='MENSAGEM_ID' required='yes'>
        <cftry>
        	<cftransaction action='begin'>
				<cfscript>
                    ret_conf = this.conferir_mensagem(MENSAGEM_ID = arguments.MENSAGEM_ID);
                </cfscript>
                <cfif ret_conf.erro>
                    <cfthrow object="#ret_conf.mensagem#">
                </cfif>
                
                <cfscript>
                    ret_desconf = this.desconferir_mensagem(MENSAGEM_ID = arguments.MENSAGEM_ID);
                </cfscript>
                <cfif ret_desconf.erro>
                    <cfthrow object="#ret_desconf.mensagem#">
                </cfif>
                
                <cfscript>
                    ret_reint = this.reintegra_mensagem(MENSAGEM_ID = arguments.MENSAGEM_ID);
                </cfscript>
                <cfif ret_reint.erro>
                    <cfthrow object="#ret_reint.mensagem#">
                </cfif>
                
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Dados originais restaurados com sucesso.')>
			</cftransaction>
            <cfcatch>
            	<cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Marcar como Lida / Marcar como No Lida
	-- ANDERSONC 07/03/2011 10:48:56 - CRIADO
	--->
	<cffunction name='lida_mensagem' displayname='Marcar como Lida / Marcar como No Lida' access='remote' returntype='Struct' output='true'>
		<cfargument name='MENSAGEM_ID' required='yes'>
		<cfargument name='LIDA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='integracao.pkg_mensagem.prc_lida_mensagem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MENSAGEM_ID'  value='#arguments.MENSAGEM_ID#'  null='#iif(len(trim(arguments.MENSAGEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LIDA'  value='#arguments.LIDA#'  null='#iif(len(trim(arguments.LIDA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_USUARIO'  value='#UCase(session.USUARIO)#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Mensagem marcada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
    -- PROPSITO
    -- Reintegrar Mensagem(ns)
    -- ANDERSONC 30/07/2010 10:27:13 - CRIADO
    --->
    <cffunction name='reintegrar_diversas_mensagens' displayname='Desconferir Mensagem' access='remote' returntype='Struct' output='true'>
        <cfargument name='MENSAGEM_ID' required='yes'>
        <cftry>
        	<cftransaction action='begin'>
                <cfloop list="#ListSort(arguments.MENSAGEM_ID, 'Numeric', 'ASC', ',')#" delimiters="," index="msg">
                    <cfscript>
                        ret_reint = this.reintegra_mensagem(MENSAGEM_ID = msg);
                    </cfscript>
                    <cfif ret_reint.erro>
                        <cfthrow object="#ret_reint.mensagem#">
                    </cfif>
                </cfloop>
                
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Mensagem(ns) reintegrada(s) com sucesso.')>
			</cftransaction>
            <cfcatch>
            	<cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Altera o contedo de uma mensagem
	-- ANDERSONC 30/07/2010 19:05:13 - CRIADO
	--->
	<cffunction name='upd_mensagem_conteudo' displayname='Altera o contedo de uma mensagem' access='remote' returntype='Struct' output='true'>
		<cfargument name='MENSAGEM_ID' required='yes'>
		<cfargument name='XPATH' required='yes'>
		<cfargument name='VALOR' required='yes'>
		<cftry>
            <cfstoredproc procedure='integracao.pkg_mensagem.prc_alt_mensagem_conteudo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MENSAGEM_ID'  value='#arguments.MENSAGEM_ID#'  null='#iif(len(trim(arguments.MENSAGEM_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_XPATH'  value='#arguments.XPATH#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_VALOR'  value='#arguments.VALOR#' >
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
    -- PROPSITO
    -- Alterar Dados Originais
    -- ANDERSONC 30/07/2010 10:27:13 - CRIADO
    --->
    <cffunction name='alterar_dados_originais' displayname='Desconferir Mensagem' access='remote' returntype='Struct' output='true'>
        <cfargument name='MENSAGEM_ID' required='yes'>
        <cfargument name='REINTEGRAR' required='yes'>
        <cftry>
        	<cftransaction action='begin'>
                <cfloop list="#arguments.FIELDNAMES#" delimiters="," index="campo">
                	<cfif FindNoCase('CAMPO', campo, 0) and not FindNoCase('XPATH_', campo, 0)>
                    	<cfscript>
							ret_msg = this.upd_mensagem_conteudo(MENSAGEM_ID = arguments.MENSAGEM_ID,
																 XPATH		 = arguments['XPATH_' & campo],
																 VALOR		 = arguments[campo]);
						</cfscript>
						<cfif ret_msg.erro>
							<cfthrow object="#ret_msg.mensagem#">
						</cfif>
                    </cfif>
                </cfloop>
                
                <cfif arguments.REINTEGRAR eq 1>
                    <cfscript>
                        ret_reint = this.reintegra_mensagem(MENSAGEM_ID = arguments.MENSAGEM_ID);
                    </cfscript>
                    <cfif ret_reint.erro>
                        <cfthrow object="#ret_reint.mensagem#">
                    </cfif>
                </cfif>
                
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Dados originais alterados com sucesso.')>
			</cftransaction>
            <cfcatch>
            	<cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
</cfcomponent>