<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPSITO
    -- Insere novo ticket
    -- GUTO 16/01/2010 15:35:47 - CRIADO
    --->
    <cffunction name='ins_ticket' displayname='Insere novo ticket' access='remote' returntype='Struct' output='true'>
        <cfargument name='TITULO' required='yes'>
        <cfargument name='CLIENTE_ID' required='yes'>
        <cfargument name='SOLICITANTE_ID' required='yes'>
        <cfargument name='TECNICO_ID' required='yes'>
        <cfargument name='CLASSIFICACAO_ID' required='yes'>
        <cfargument name='PRIORIDADE_ID' required='yes'>
        <cfargument name='STATUS_ID' required='yes'>
        <cfargument name='MODULO_ID' required='yes'>
        <cfargument name='DATA_CANCELAMENTO' required='yes'>
        <cfargument name='USUARIO_CANCELAMENTO' required='yes'>
        <cfargument name='DATA_FECHAMENTO' required='yes'>
        <cfargument name='USUARIO_FECHAMENTO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='kmm.pkg_ticket.prc_ins_ticket' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_TICKET' variable='retorno.NUM_TICKET' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CLIENTE_ID'  value='#arguments.CLIENTE_ID#'  null='#iif(len(trim(arguments.CLIENTE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SOLICITANTE_ID'  value='#arguments.SOLICITANTE_ID#'  null='#iif(len(trim(arguments.SOLICITANTE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TECNICO_ID'  value='#arguments.TECNICO_ID#'  null='#iif(len(trim(arguments.TECNICO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CLASSIFICACAO_ID'  value='#arguments.CLASSIFICACAO_ID#'  null='#iif(len(trim(arguments.CLASSIFICACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PRIORIDADE_ID'  value='#arguments.PRIORIDADE_ID#'  null='#iif(len(trim(arguments.PRIORIDADE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_STATUS_ID'  value='#arguments.STATUS_ID#'  null='#iif(len(trim(arguments.STATUS_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_MODULO_ID'  value='#arguments.MODULO_ID#'  null='#iif(len(trim(arguments.MODULO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_CANCELAMENTO'  value='#arguments.DATA_CANCELAMENTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_USUARIO_CANCELAMENTO'  value='#arguments.USUARIO_CANCELAMENTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_FECHAMENTO'  value='#arguments.DATA_FECHAMENTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_USUARIO_FECHAMENTO'  value='#arguments.USUARIO_FECHAMENTO#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_INTEGER' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Ticket inserido com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!--- 
    -- PROPSITO
    -- Altera ticket
    -- GUTO 16/01/2010 15:36:31 - CRIADO
    --->
    <cffunction name='upd_ticket' displayname='Altera ticket' access='remote' returntype='Struct' output='true'>
        <cfargument name='NUM_TICKET' required='yes'>
        <cfargument name='TITULO' required='yes'>
        <cfargument name='CLIENTE_ID' required='yes'>
        <cfargument name='SOLICITANTE_ID' required='yes'>
        <cfargument name='TECNICO_ID' required='yes'>
        <cfargument name='CLASSIFICACAO_ID' required='yes'>
        <cfargument name='PRIORIDADE_ID' required='yes'>
        <cfargument name='STATUS_ID' required='yes'>
        <cfargument name='MODULO_ID' required='yes'>
        <cfargument name='DATA_CANCELAMENTO' required='yes'>
        <cfargument name='USUARIO_CANCELAMENTO' required='yes'>
        <cfargument name='DATA_FECHAMENTO' required='yes'>
        <cfargument name='USUARIO_FECHAMENTO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='kmm.pkg_ticket.prc_alt_ticket' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_TICKET'  value='#arguments.NUM_TICKET#'  null='#iif(len(trim(arguments.NUM_TICKET)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CLIENTE_ID'  value='#arguments.CLIENTE_ID#'  null='#iif(len(trim(arguments.CLIENTE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SOLICITANTE_ID'  value='#arguments.SOLICITANTE_ID#'  null='#iif(len(trim(arguments.SOLICITANTE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TECNICO_ID'  value='#arguments.TECNICO_ID#'  null='#iif(len(trim(arguments.TECNICO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CLASSIFICACAO_ID'  value='#arguments.CLASSIFICACAO_ID#'  null='#iif(len(trim(arguments.CLASSIFICACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PRIORIDADE_ID'  value='#arguments.PRIORIDADE_ID#'  null='#iif(len(trim(arguments.PRIORIDADE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_STATUS_ID'  value='#arguments.STATUS_ID#'  null='#iif(len(trim(arguments.STATUS_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_MODULO_ID'  value='#arguments.MODULO_ID#'  null='#iif(len(trim(arguments.MODULO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_CANCELAMENTO'  value='#arguments.DATA_CANCELAMENTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_USUARIO_CANCELAMENTO'  value='#arguments.USUARIO_CANCELAMENTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_FECHAMENTO'  value='#arguments.DATA_FECHAMENTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_USUARIO_FECHAMENTO'  value='#arguments.USUARIO_FECHAMENTO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Ticket alterado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Exclui ticket
    -- GUTO 16/01/2010 15:37:10 - CRIADO
    --->
    <cffunction name='del_ticket' displayname='Exclui ticket' access='remote' returntype='Struct' output='true'>
        <cfargument name='NUM_TICKET' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='kmm.pkg_ticket.prc_del_ticket' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_TICKET'  value='#arguments.NUM_TICKET#'  null='#iif(len(trim(arguments.NUM_TICKET)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Ticket excludo com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
    
	<!--- 
    -- PROPSITO
    -- Insere status para o ticket
    -- GUTO 16/01/2010 10:17:32 - CRIADO
    --->
    <cffunction name='ins_ticket_status' displayname='Insere status para o ticket' access='remote' returntype='Struct' output='true'>
        <cfargument name='DESCRICAO_SUPORTE' required='yes'>
        <cfargument name='COR_SUPORTE' required='yes'>
        <cfargument name='DESCRICAO_PRODUCAO' required='yes'>
        <cfargument name='COR_PRODUCAO' required='yes'>
        <cfargument name='DESCRICAO_CLIENTE' required='yes'>
        <cfargument name='COR_CLIENTE' required='yes'>
        <cfargument name='TEMPO_ALERTA' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='kmm.pkg_ticket.prc_ins_ticket_status' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_STATUS_ID' variable='retorno.STATUS_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO_SUPORTE'  value='#arguments.DESCRICAO_SUPORTE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COR_SUPORTE'  value='#arguments.COR_SUPORTE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO_PRODUCAO'  value='#arguments.DESCRICAO_PRODUCAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COR_PRODUCAO'  value='#arguments.COR_PRODUCAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO_CLIENTE'  value='#arguments.DESCRICAO_CLIENTE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COR_CLIENTE'  value='#arguments.COR_CLIENTE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TEMPO_ALERTA'  value='#arguments.TEMPO_ALERTA#'  null='#iif(len(trim(arguments.TEMPO_ALERTA)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Status inserido com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!--- 
    -- PROPSITO
    -- Insere status para o ticket
    -- GUTO 16/01/2010 10:20:12 - CRIADO
    --->
    <cffunction name='upd_ticket_status' displayname='Insere status para o ticket' access='remote' returntype='Struct' output='true'>
        <cfargument name='STATUS_ID' required='yes'>
        <cfargument name='DESCRICAO_SUPORTE' required='yes'>
        <cfargument name='COR_SUPORTE' required='yes'>
        <cfargument name='DESCRICAO_PRODUCAO' required='yes'>
        <cfargument name='COR_PRODUCAO' required='yes'>
        <cfargument name='DESCRICAO_CLIENTE' required='yes'>
        <cfargument name='COR_CLIENTE' required='yes'>
        <cfargument name='TEMPO_ALERTA' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='kmm.pkg_ticket.prc_alt_ticket_status' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_STATUS_ID'  value='#arguments.STATUS_ID#'  null='#iif(len(trim(arguments.STATUS_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO_SUPORTE'  value='#arguments.DESCRICAO_SUPORTE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COR_SUPORTE'  value='#arguments.COR_SUPORTE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO_PRODUCAO'  value='#arguments.DESCRICAO_PRODUCAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COR_PRODUCAO'  value='#arguments.COR_PRODUCAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO_CLIENTE'  value='#arguments.DESCRICAO_CLIENTE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COR_CLIENTE'  value='#arguments.COR_CLIENTE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TEMPO_ALERTA'  value='#arguments.TEMPO_ALERTA#'  null='#iif(len(trim(arguments.TEMPO_ALERTA)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Status inserido com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Exclui status para o ticket
    -- GUTO 16/01/2010 10:22:52 - CRIADO
    --->
    <cffunction name='del_ticket_status' displayname='Exclui status para o ticket' access='remote' returntype='Struct' output='true'>
        <cfargument name='STATUS_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='kmm.pkg_ticket.prc_del_ticket_status' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_STATUS_ID'  value='#arguments.STATUS_ID#'  null='#iif(len(trim(arguments.STATUS_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Status excludo com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

<!--- 
-- PROPSITO
-- Insere novo ticket em aberto
-- GUTO 18/01/2010 09:57:13 - CRIADO
--->
<cffunction name='abre_ticket' displayname='Insere novo ticket em aberto' access='remote' returntype='Struct' output='true'>
	<cfargument name='SOLICITANTE_ID' required='yes'>
	<cfargument name='PRIORIDADE_ID' required='yes'>
	<cfargument name='MODULO_ID' required='yes'>
	<cfargument name='TITULO' required='yes'>
	<cfargument name='TEXTO' required='yes'>
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='kmm.pkg_ticket.prc_abre_ticket' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SOLICITANTE_ID'  value='#arguments.SOLICITANTE_ID#'  null='#iif(len(trim(arguments.SOLICITANTE_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRIORIDADE_ID'  value='#arguments.PRIORIDADE_ID#'  null='#iif(len(trim(arguments.PRIORIDADE_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MODULO_ID'  value='#arguments.MODULO_ID#'  null='#iif(len(trim(arguments.MODULO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_TEXTO'  value='#arguments.TEXTO#' >
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_TICKET' variable='retorno.NUM_TICKET' >
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Ticket inserido com sucesso!')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction> 

<!--- 
-- PROPSITO
-- Assumir o atendimento de um ticket
-- GUTO 18/01/2010 10:16:00 - CRIADO
--->
<cffunction name='assume_ticket' displayname='Assumir o atendimento de um ticket' access='remote' returntype='Struct' output='true'>
	<cfargument name='NUM_TICKET' required='yes'>
	<cfargument name='TECNICO_ID' required='yes'>
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='kmm.pkg_ticket.prc_assume_ticket' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_TICKET'  value='#arguments.NUM_TICKET#'  null='#iif(len(trim(arguments.NUM_TICKET)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TECNICO_ID'  value='#arguments.TECNICO_ID#'  null='#iif(len(trim(arguments.TECNICO_ID)), de('no'), de('yes'))#'>
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Ticket assumido com sucesso!')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

<!--- 
-- PROPSITO
-- Insere o atendimento em um ticket
-- GUTO 18/01/2010 10:16:50 - CRIADO
--->
<cffunction name='ins_ticket_atendimento' displayname='Insere o atendimento em um ticket' access='remote' returntype='Struct' output='true'>
	<cfargument name='NUM_TICKET' required='yes'>
	<cfargument name='TEXTO' required='yes'>
	<cfargument name='DATA' required='yes'>
	<cfargument name='RESPONSAVEL_ID' required='yes'>
	<cfargument name='PRIVADA' required='yes'>
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='kmm.pkg_ticket.prc_ins_ticket_atendimento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATENDIMENTO_ID' variable='retorno.ATENDIMENTO_ID' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_TICKET'  value='#arguments.NUM_TICKET#'  null='#iif(len(trim(arguments.NUM_TICKET)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_TEXTO'  value='#arguments.TEXTO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA'  value='#arguments.DATA#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RESPONSAVEL_ID'  value='#arguments.RESPONSAVEL_ID#'  null='#iif(len(trim(arguments.RESPONSAVEL_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRIVADA'  value='#arguments.PRIVADA#'  null='#iif(len(trim(arguments.PRIVADA)), de('no'), de('yes'))#'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_INTEGER' dbvarname='P_ROWID' variable='retorno.ROWID' >
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Mensagem inserida com sucesso!')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

<!--- 
-- PROPSITO
-- Altera o atendimento em um ticket
-- GUTO 18/01/2010 10:17:33 - CRIADO
--->
<cffunction name='upd_ticket_atendimento' displayname='Altera o atendimento em um ticket' access='remote' returntype='Struct' output='true'>
	<cfargument name='ATENDIMENTO_ID' required='yes'>
	<cfargument name='NUM_TICKET' required='yes'>
	<cfargument name='TEXTO' required='yes'>
	<cfargument name='DATA' required='yes'>
	<cfargument name='RESPONSAVEL_ID' required='yes'>
	<cfargument name='PRIVADA' required='yes'>
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='kmm.pkg_ticket.prc_alt_ticket_atendimento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATENDIMENTO_ID'  value='#arguments.ATENDIMENTO_ID#'  null='#iif(len(trim(arguments.ATENDIMENTO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_TICKET'  value='#arguments.NUM_TICKET#'  null='#iif(len(trim(arguments.NUM_TICKET)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_TEXTO'  value='#arguments.TEXTO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA'  value='#arguments.DATA#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RESPONSAVEL_ID'  value='#arguments.RESPONSAVEL_ID#'  null='#iif(len(trim(arguments.RESPONSAVEL_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRIVADA'  value='#arguments.PRIVADA#'  null='#iif(len(trim(arguments.PRIVADA)), de('no'), de('yes'))#'>
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Mensagem alterada com sucesso!')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

<!--- 
-- PROPSITO
-- Exclui o atendimento em um ticket
-- GUTO 18/01/2010 10:18:11 - CRIADO
--->
<cffunction name='del_ticket_atendimento' displayname='Exclui o atendimento em um ticket' access='remote' returntype='Struct' output='true'>
	<cfargument name='ATENDIMENTO_ID' required='yes'>
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='kmm.pkg_ticket.prc_del_ticket_atendimento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATENDIMENTO_ID'  value='#arguments.ATENDIMENTO_ID#'  null='#iif(len(trim(arguments.ATENDIMENTO_ID)), de('no'), de('yes'))#'>
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Mensagem excluda com sucesso!')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>   
</cfcomponent>