<cfcomponent  extends="_transportes.funcoes.cfc_init">
<!--- 
-- PROPSITO
-- Insere uma aplicacao
-- CRISTOFER 03/05/2011 11:50:57 - CRIADO
--->
<cffunction name='ins_aplicacao' displayname='Insere uma aplicacao' access='remote' returntype='Struct' output='true'>
	<cfargument name='COD_APLICACAO' required='yes'>
	<cfargument name='NOME' required='yes'>
	<cfargument name='RAIZ_SVN' required='yes'>
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='kmmupdate.pkg_aplicacao.prc_ins_aplicacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_APLICACAO'  value='#arguments.COD_APLICACAO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RAIZ_SVN'  value='#arguments.RAIZ_SVN#' >
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Aplicao inserida com sucesso.')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

<!--- 
-- PROPSITO
-- Altera uma aplicacao
-- CRISTOFER 03/05/2011 11:52:21 - CRIADO
--->
<cffunction name='upd_aplicacao' displayname='Altera uma aplicacao' access='remote' returntype='Struct' output='true'>
	<cfargument name='COD_APLICACAO' required='yes'>
	<cfargument name='NOME' required='yes'>
	<cfargument name='RAIZ_SVN' required='yes'>
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='kmmupdate.pkg_aplicacao.prc_alt_aplicacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_APLICACAO'  value='#arguments.COD_APLICACAO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RAIZ_SVN'  value='#arguments.RAIZ_SVN#' >
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Aplicao alterada com sucesso.')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

<!--- 
-- PROPSITO
-- Exclui uma aplicacao
-- CRISTOFER 03/05/2011 11:52:54 - CRIADO
--->
<cffunction name='del_aplicacao' displayname='Exclui uma aplicacao' access='remote' returntype='Struct' output='true'>
	<cfargument name='COD_APLICACAO' required='yes'>
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='kmmupdate.pkg_aplicacao.prc_del_aplicacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_APLICACAO'  value='#arguments.COD_APLICACAO#' >
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Aplicao excluda com sucesso.')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

</cfcomponent>