<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPSITO
    -- Atualiza um ambiente
    -- CRISTOFER 27/08/2009 21:29:16 - CRIADO
    --->
    <cffunction name='atualizar_ambiente' displayname='Atualiza um ambiente' access='remote' returntype='Struct' output='true'>
        <cfargument name='REPOSITORIO_ID' required='yes'>
        <cfargument name='CONTAINER_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='infraestrutura.pkg_ambiente.prc_atualizar_ambiente' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REPOSITORIO_ID'  value='#arguments.REPOSITORIO_ID#'  null='#iif(len(trim(arguments.REPOSITORIO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTAINER_ID'  value='#arguments.CONTAINER_ID#'  null='#iif(len(trim(arguments.CONTAINER_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Ambiente atualizado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Inativa um ambiente
    -- CRISTOFER 27/08/2009 21:34:43 - CRIADO
    --->
    <cffunction name='inativar_ambiente' displayname='Inativa um ambiente' access='remote' returntype='Struct' output='true'>
        <cfargument name='AMBIENTE_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='infraestrutura.pkg_ambiente.prc_inativar_ambiente' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_AMBIENTE_ID'  value='#arguments.AMBIENTE_ID#'  null='#iif(len(trim(arguments.AMBIENTE_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Ambiente inativado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Reativa um ambiente
    -- CRISTOFER 27/08/2009 21:35:10 - CRIADO
    --->
    <cffunction name='reativar_ambiente' displayname='Reativa um ambiente' access='remote' returntype='Struct' output='true'>
        <cfargument name='AMBIENTE_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='infraestrutura.pkg_ambiente.prc_reativar_ambiente' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_AMBIENTE_ID'  value='#arguments.AMBIENTE_ID#'  null='#iif(len(trim(arguments.AMBIENTE_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Ambiente reativado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Reativa um ambiente
    -- CRISTOFER 27/08/2009 21:35:10 - CRIADO
    --->
    <cffunction name='cancelar_atividade' displayname='Reativa um ambiente' access='remote' returntype='Struct' output='true'>
        <cfargument name='ATIVIDADE_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='infraestrutura.pkg_ambiente.prc_cancelar_atividade' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATIVIDADE_ID'  value='#arguments.ATIVIDADE_ID#'  null='#iif(len(trim(arguments.ATIVIDADE_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Atividade cancelada com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Reativa um ambiente
    -- CRISTOFER 27/08/2009 21:35:10 - CRIADO
    --->
    <cffunction name='ins_ambiente_recurso' displayname='Reativa um ambiente' access='remote' returntype='Struct' output='true'>
        <cfargument name='AMBIENTE_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='infraestrutura.pkg_ambiente.prc_ins_ambiente_recurso' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RESTRICAO_ID'  variable='retorno.RESTRICAO_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_AMBIENTE_ID'  value='#arguments.AMBIENTE_ID#'  null='#iif(len(trim(arguments.AMBIENTE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' SCALE='5' dbvarname='P_RESTRICAO_ID'  variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Ambiente reservado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Reativa um ambiente
    -- CRISTOFER 27/08/2009 21:35:10 - CRIADO
    --->
    <cffunction name='del_ambiente_recurso' displayname='Reativa um ambiente' access='remote' returntype='Struct' output='true'>
        <cfargument name='RESTRICAO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='infraestrutura.pkg_ambiente.prc_del_ambiente_recurso' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RESTRICAO_ID'  value='#arguments.RESTRICAO_ID#'  null='#iif(len(trim(arguments.RESTRICAO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Ambiente liberado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
</cfcomponent>