<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPSITO
    -- Insere lancamento
    -- GUTO 17/09/2010 14:43:00 - CRIADO
    --->
    <cffunction name='prc_ins_plano_contas_lancto' displayname='Insere lancamento' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTA_ID' required='yes'>
        <cfargument name='COD_CENTRO_CUSTO' required='yes'>
        <cfargument name='DATA' required='yes'>
        <cfargument name='VALOR' required='yes'>
        <cfargument name='COMPLEMENTO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='gerencial.pkg_plano_contas.prc_ins_plano_contas_lancto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTA_ID'  value='#arguments.CONTA_ID#'  null='#iif(len(trim(arguments.CONTA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA'  value='#arguments.DATA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR'  value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMPLEMENTO'  value='#arguments.COMPLEMENTO#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LANCAMENTO_ID' variable='retorno.LANCAMENTO_ID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Lanamento inserido com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!--- 
    -- PROPSITO
    -- Altera lancamento
    -- GUTO 17/09/2010 14:44:21 - CRIADO
    --->
    <cffunction name='prc_upd_plano_contas_lancto' displayname='Altera lancamento' access='remote' returntype='Struct' output='true'>
        <cfargument name='LANCAMENTO_ID' required='yes'>
        <cfargument name='CONTA_ID' required='yes'>
        <cfargument name='COD_CENTRO_CUSTO' required='yes'>
        <cfargument name='DATA' required='yes'>
        <cfargument name='VALOR' required='yes'>
        <cfargument name='COMPLEMENTO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='gerencial.pkg_plano_contas.prc_alt_plano_contas_lancto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LANCAMENTO_ID'  value='#arguments.LANCAMENTO_ID#'  null='#iif(len(trim(arguments.LANCAMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTA_ID'  value='#arguments.CONTA_ID#'  null='#iif(len(trim(arguments.CONTA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA'  value='#arguments.DATA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR'  value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMPLEMENTO'  value='#arguments.COMPLEMENTO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Lanamento alterado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Exclui lancamento
    -- GUTO 17/09/2010 14:45:02 - CRIADO
    --->
    <cffunction name='prc_del_plano_contas_lancto' displayname='Exclui lancamento' access='remote' returntype='Struct' output='true'>
        <cfargument name='LANCAMENTO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='gerencial.pkg_plano_contas.prc_del_plano_contas_lancto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LANCAMENTO_ID'  value='#arguments.LANCAMENTO_ID#'  null='#iif(len(trim(arguments.LANCAMENTO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Lanamento excludo com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Cancela lancamento
    -- GUTO 17/09/2010 14:45:02 - CRIADO
    --->
    <cffunction name='prc_can_plano_contas_lancto' displayname='Exclui lancamento' access='remote' returntype='Struct' output='true'>
        <cfargument name='LANCAMENTO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='gerencial.pkg_plano_contas.prc_can_plano_contas_lancto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LANCAMENTO_ID'  value='#arguments.LANCAMENTO_ID#'  null='#iif(len(trim(arguments.LANCAMENTO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Lanamento cancelado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
        
    <!--- 
    -- PROPSITO
    -- Insere lanamento manual na conta, baseado no rateio da meta de faturamento.
    -- GUTO 06/10/2010 10:41:16 - CRIADO
    --->
    <cffunction name='ins_lancto_manual_rateio' displayname='Insere lanamento manual na conta, baseado no rateio da meta de faturamento.' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTA_ID' required='yes'>
        <cfargument name='COD_CENTRO_CUSTO' required='yes'>
        <cfargument name='DATA' required='yes'>
        <cfargument name='VALOR' required='yes'>
        <cfargument name='COMPLEMENTO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='gerencial.pkg_plano_contas.prc_ins_lancto_manual_rateio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTA_ID'  value='#arguments.CONTA_ID#'  null='#iif(len(trim(arguments.CONTA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA'  value='#arguments.DATA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_TOTAL'  value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMPLEMENTO'  value='#arguments.COMPLEMENTO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Lanamento rateado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
</cfcomponent>