<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPSITO
    -- Vnculo de Centros de Custo Gerencial com Centros de Custo
    -- ANDERSONC 20/09/2010 07:29:11 - CRIADO
    --->
    <cffunction name='ins_ccusto_organizacional' displayname='Vnculo de Centros de Custo Gerencial com Centros de Custo' access='remote' returntype='Struct' output='true'>
        <cfargument name='COD_CENTRO_CUSTO' required='yes'>
        <cfargument name='ORGANIZACIONAL_ID' required='yes'>
        <cfargument name='DATA_INICIO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='gerencial.pkg_resultado_filial.prc_ins_ccusto_organizacional' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID' variable='retorno.CONTROLE_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ORGANIZACIONAL_ID'  value='#arguments.ORGANIZACIONAL_ID#'  null='#iif(len(trim(arguments.ORGANIZACIONAL_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO'  value='#arguments.DATA_INICIO#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
                
                <!--- Insero dos Oramentos --->
				<cfscript>
                    v_controle_id = this.ListaToArray(lista = arguments, variavel = 'ORCAMENTO_CONTROLE_ID_ORCAMENTO');
					v_mes 		  = this.ListaToArray(lista = arguments, variavel = 'MES_ORCAMENTO');
					v_ano 		  = this.ListaToArray(lista = arguments, variavel = 'ANO_ORCAMENTO');
					v_valor 	  = this.ListaToArray(lista = arguments, variavel = 'VALOR_ORCAMENTO');
                </cfscript>
                <cfloop from="1" to="#ArrayLen(v_controle_id)#" index="count_orc">
                    <cfscript>
                        ret = this.ins_ccusto_org_orcamento(CONTROLE_ID_CC_ORG = retorno.CONTROLE_ID,
															MES				   = v_mes[count_orc],
															ANO				   = v_ano[count_orc],
															valor			   = v_valor[count_orc]);
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>
                
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Vnculo inserido com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Vnculo de Centros de Custo Gerencial com Centros de Custo
    -- ANDERSONC 20/09/2010 07:30:36 - CRIADO
    --->
    <cffunction name='upd_ccusto_organizacional' displayname='Vnculo de Centros de Custo Gerencial com Centros de Custo' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTROLE_ID' required='yes'>
        <cfargument name='COD_CENTRO_CUSTO' required='yes'>
        <cfargument name='DATA_INICIO' required='yes'>
        <cfargument name='DATA_FIM' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='gerencial.pkg_resultado_filial.prc_alt_ccusto_organizacional' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO'  value='#arguments.DATA_INICIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_FIM'  value='#arguments.DATA_FIM#' >
                </cfstoredproc>
                
                <!--- Alterao dos Oramentos --->
				<cfscript>
                    v_controle_id = this.ListaToArray(lista = arguments, variavel = 'ORCAMENTO_CONTROLE_ID_ORCAMENTO');
					v_mes 		  = this.ListaToArray(lista = arguments, variavel = 'MES_ORCAMENTO');
					v_ano 		  = this.ListaToArray(lista = arguments, variavel = 'ANO_ORCAMENTO');
					v_valor 	  = this.ListaToArray(lista = arguments, variavel = 'VALOR_ORCAMENTO');
					v_excluir	  = this.ListDiff(lista1 = arguments.lista_deleted_ORCAMENTO, lista2 = ArrayToList(v_controle_id));
                </cfscript>
                <cfloop list="#v_excluir#" delimiters="," index="controle_id_excluir">
                    <cfscript>
                        ret = this.del_ccusto_org_orcamento(CONTROLE_ID = controle_id_excluir);
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>
                <cfloop from="1" to="#ArrayLen(v_controle_id)#" index="count_orc">
                    <cfscript>
                        if(Not Len(Trim(v_controle_id[count_orc]))) {
							ret = this.ins_ccusto_org_orcamento(CONTROLE_ID_CC_ORG = arguments.CONTROLE_ID,
																MES				   = v_mes[count_orc],
																ANO				   = v_ano[count_orc],
																valor			   = v_valor[count_orc]);
                        }
                        else {
							ret = this.upd_ccusto_org_orcamento(CONTROLE_ID = v_controle_id[count_orc],
																MES			= v_mes[count_orc],
																ANO			= v_ano[count_orc],
																valor		= v_valor[count_orc]);
                        }
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>
                
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Vnculo alterado com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Vnculo de Centros de Custo Gerencial com Centros de Custo
    -- ANDERSONC 20/09/2010 07:32:13 - CRIADO
    --->
    <cffunction name='del_ccusto_organizacional' displayname='Vnculo de Centros de Custo Gerencial com Centros de Custo' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTROLE_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='gerencial.pkg_resultado_filial.prc_del_ccusto_organizacional' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Vnculo excludo com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Vnculo de Centros de Custo Gerencial com Centros de Custo
    -- ANDERSONC 20/09/2010 07:32:58 - CRIADO
    --->
    <cffunction name='ins_ccusto_org_orcamento' displayname='Vnculo de Centros de Custo Gerencial com Centros de Custo' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTROLE_ID_CC_ORG' required='yes'>
        <cfargument name='MES' required='yes'>
        <cfargument name='ANO' required='yes'>
        <cfargument name='VALOR' required='yes'>
        <cftry>
            <cfstoredproc procedure='gerencial.pkg_resultado_filial.prc_ins_ccusto_org_orcamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID' variable='retorno.CONTROLE_ID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID_CC_ORG'  value='#arguments.CONTROLE_ID_CC_ORG#'  null='#iif(len(trim(arguments.CONTROLE_ID_CC_ORG)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MES'  value='#arguments.MES#'  null='#iif(len(trim(arguments.MES)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ANO'  value='#arguments.ANO#'  null='#iif(len(trim(arguments.ANO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR'  value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Vnculo de Centros de Custo Gerencial com Centros de Custo
    -- ANDERSONC 20/09/2010 07:33:42 - CRIADO
    --->
    <cffunction name='upd_ccusto_org_orcamento' displayname='Vnculo de Centros de Custo Gerencial com Centros de Custo' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTROLE_ID' required='yes'>
        <cfargument name='MES' required='yes'>
        <cfargument name='ANO' required='yes'>
        <cfargument name='VALOR' required='yes'>
        <cftry>
            <cfstoredproc procedure='gerencial.pkg_resultado_filial.prc_alt_ccusto_org_orcamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MES'  value='#arguments.MES#'  null='#iif(len(trim(arguments.MES)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ANO'  value='#arguments.ANO#'  null='#iif(len(trim(arguments.ANO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR'  value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Vnculo de Centros de Custo Gerencial com Centros de Custo
    -- ANDERSONC 20/09/2010 07:34:32 - CRIADO
    --->
    <cffunction name='del_ccusto_org_orcamento' displayname='Vnculo de Centros de Custo Gerencial com Centros de Custo' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTROLE_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='gerencial.pkg_resultado_filial.prc_del_ccusto_org_orcamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Vnculo de Fornecedores com Centros de Custo
    -- ANDERSONC 20/09/2010 07:35:39 - CRIADO
    --->
    <cffunction name='ins_ccusto_fornecedor' displayname='Vnculo de Fornecedores com Centros de Custo' access='remote' returntype='Struct' output='true'>
        <cfargument name='COD_CENTRO_CUSTO' required='yes'>
        <cfargument name='COD_PESSOA_FORNECEDOR' required='yes'>
        <cfargument name='TIPO_COBRANCA' required='yes'>
        <cfargument name='DATA_INICIO' required='yes'>
        <cfargument name='CUSTO_POR_KM' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='gerencial.pkg_resultado_filial.prc_ins_ccusto_fornecedor' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID' variable='retorno.CONTROLE_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_FORNECEDOR'  value='#arguments.COD_PESSOA_FORNECEDOR#'  null='#iif(len(trim(arguments.COD_PESSOA_FORNECEDOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_COBRANCA'  value='#arguments.TIPO_COBRANCA#'  null='#iif(len(trim(arguments.TIPO_COBRANCA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO'  value='#arguments.DATA_INICIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CUSTO_POR_KM'  value='#arguments.CUSTO_POR_KM#'  null='#iif(len(trim(arguments.CUSTO_POR_KM)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
                
                <!--- Insero dos Oramentos --->
				<cfscript>
                    v_controle_id = this.ListaToArray(lista = arguments, variavel = 'ORCAMENTO_CONTROLE_ID_ORCAMENTO');
					v_mes 		  = this.ListaToArray(lista = arguments, variavel = 'MES_ORCAMENTO');
					v_ano 		  = this.ListaToArray(lista = arguments, variavel = 'ANO_ORCAMENTO');
					v_valor 	  = this.ListaToArray(lista = arguments, variavel = 'VALOR_ORCAMENTO');
                </cfscript>
                <cfloop from="1" to="#ArrayLen(v_controle_id)#" index="count_orc">
                    <cfscript>
                        ret = this.ins_ccusto_fornecedor_orc(CONTROLE_ID_FORNECEDOR = retorno.CONTROLE_ID,
															 MES				   	= v_mes[count_orc],
															 ANO				   	= v_ano[count_orc],
															 valor			   		= v_valor[count_orc]);
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>
                
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Vnculo inserido com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Vnculo de Fornecedores com Centros de Custo
    -- ANDERSONC 20/09/2010 07:36:43 - CRIADO
    --->
    <cffunction name='upd_ccusto_fornecedor' displayname='Vnculo de Fornecedores com Centros de Custo' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTROLE_ID' required='yes'>
        <cfargument name='COD_CENTRO_CUSTO' required='yes'>
        <cfargument name='TIPO_COBRANCA' required='yes'>
        <cfargument name='DATA_INICIO' required='yes'>
        <cfargument name='DATA_FIM' required='yes'>
        <cfargument name='CUSTO_POR_KM' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='gerencial.pkg_resultado_filial.prc_alt_ccusto_fornecedor' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_COBRANCA'  value='#arguments.TIPO_COBRANCA#'  null='#iif(len(trim(arguments.TIPO_COBRANCA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO'  value='#arguments.DATA_INICIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_FIM'  value='#arguments.DATA_FIM#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CUSTO_POR_KM'  value='#arguments.CUSTO_POR_KM#'  null='#iif(len(trim(arguments.CUSTO_POR_KM)), de('no'), de('yes'))#'>
                </cfstoredproc>
                
                <!--- Alterao dos Oramentos --->
				<cfscript>
                    v_controle_id = this.ListaToArray(lista = arguments, variavel = 'ORCAMENTO_CONTROLE_ID_ORCAMENTO');
					v_mes 		  = this.ListaToArray(lista = arguments, variavel = 'MES_ORCAMENTO');
					v_ano 		  = this.ListaToArray(lista = arguments, variavel = 'ANO_ORCAMENTO');
					v_valor 	  = this.ListaToArray(lista = arguments, variavel = 'VALOR_ORCAMENTO');
					v_excluir	  = this.ListDiff(lista1 = arguments.lista_deleted_ORCAMENTO, lista2 = ArrayToList(v_controle_id));
                </cfscript>
                <cfloop list="#v_excluir#" delimiters="," index="controle_id_excluir">
                    <cfscript>
                        ret = this.del_ccusto_fornecedor_orc(CONTROLE_ID = controle_id_excluir);
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>
                <cfloop from="1" to="#ArrayLen(v_controle_id)#" index="count_orc">
                    <cfscript>
                        if(Not Len(Trim(v_controle_id[count_orc]))) {
							ret = this.ins_ccusto_fornecedor_orc(CONTROLE_ID_FORNECEDOR = arguments.CONTROLE_ID,
																 MES				   	= v_mes[count_orc],
																 ANO				   	= v_ano[count_orc],
																 valor			   		= v_valor[count_orc]);
                        }
                        else {
							ret = this.upd_ccusto_fornecedor_orc(CONTROLE_ID = v_controle_id[count_orc],
																 MES		 = v_mes[count_orc],
																 ANO		 = v_ano[count_orc],
																 valor		 = v_valor[count_orc]);
                        }
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>
                
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Vnculo alterado com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Vnculo de Fornecedores com Centros de Custo
    -- ANDERSONC 20/09/2010 07:37:24 - CRIADO
    --->
    <cffunction name='del_ccusto_fornecedor' displayname='Vnculo de Fornecedores com Centros de Custo' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTROLE_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='gerencial.pkg_resultado_filial.prc_del_ccusto_fornecedor' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Vnculo excludo com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Vnculo de Fornecedores com Centros de Custo
    -- ANDERSONC 20/09/2010 07:38:05 - CRIADO
    --->
    <cffunction name='ins_ccusto_fornecedor_orc' displayname='Vnculo de Fornecedores com Centros de Custo' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTROLE_ID_FORNECEDOR' required='yes'>
        <cfargument name='MES' required='yes'>
        <cfargument name='ANO' required='yes'>
        <cfargument name='VALOR' required='yes'>
        <cftry>
            <cfstoredproc procedure='gerencial.pkg_resultado_filial.prc_ins_ccusto_fornecedor_orc' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID' variable='retorno.CONTROLE_ID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID_FORNECEDOR'  value='#arguments.CONTROLE_ID_FORNECEDOR#'  null='#iif(len(trim(arguments.CONTROLE_ID_FORNECEDOR)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MES'  value='#arguments.MES#'  null='#iif(len(trim(arguments.MES)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ANO'  value='#arguments.ANO#'  null='#iif(len(trim(arguments.ANO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR'  value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Vnculo de Fornecedores com Centros de Custo
    -- ANDERSONC 20/09/2010 07:38:38 - CRIADO
    --->
    <cffunction name='upd_ccusto_fornecedor_orc' displayname='Vnculo de Fornecedores com Centros de Custo' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTROLE_ID' required='yes'>
        <cfargument name='MES' required='yes'>
        <cfargument name='ANO' required='yes'>
        <cfargument name='VALOR' required='yes'>
        <cftry>
            <cfstoredproc procedure='gerencial.pkg_resultado_filial.prc_alt_ccusto_fornecedor_orc' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MES'  value='#arguments.MES#'  null='#iif(len(trim(arguments.MES)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ANO'  value='#arguments.ANO#'  null='#iif(len(trim(arguments.ANO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR'  value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Vnculo de Fornecedores com Centros de Custo
    -- ANDERSONC 20/09/2010 07:39:53 - CRIADO
    --->
    <cffunction name='del_ccusto_fornecedor_orc' displayname='Vnculo de Fornecedores com Centros de Custo' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTROLE_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='gerencial.pkg_resultado_filial.prc_del_ccusto_fornecedor_orc' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
</cfcomponent>