<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPSITO
    -- Gera fatura
    -- guto 26/05/2009 14:05:22 - CRIADO
    --->
    <cffunction name='faturamento_manual' displayname='Gera fatura' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONHECIMENTO_ID' required='yes'>
        <cfargument name='DOCTO_ID' required='yes'>
        <cfargument name='DATA_EMISSAO' required='yes'>
        <cfargument name='DATA_VENCTO' required='yes'>
        <cfargument name='BLOQUETO_AUTOMATICO' required='yes'>
        <cfargument name='NUM_DOCTO' required='yes'>
        <cfargument name='COMENTARIO' required='no' default="">
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='finan.pkg_faturamento_ctrc.prc_faturamento_manual' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DOCTO_ID'  value='#arguments.DOCTO_ID#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_VENCTO'  value='#arguments.DATA_VENCTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_BLOQUETO_AUTOMATICO'  value='#arguments.BLOQUETO_AUTOMATICO#'  null='#iif(len(trim(arguments.BLOQUETO_AUTOMATICO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUM_DOCTO'  value='#arguments.NUM_DOCTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMENTARIO'  value='#arguments.COMENTARIO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Fatura gerada com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Gera fatura unificada (CTRC NFES)
    -- Eric 29/04/2010 00:00:00 - CRIADO
    --->
    <cffunction name='faturamento_manual_unificado' displayname='Gera fatura' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONHECIMENTO_ID' 	   required='no' default=''>
        <cfargument name='NUM_NOTA_ID' 		   required='no' default=''>
        <cfargument name='DOCTO_ID' 		   required='yes'>
        <cfargument name='DATA_EMISSAO' 	   required='yes'>
        <cfargument name='DATA_VENCTO' 		   required='yes'>
        <cfargument name='NUM_DOCTO' 		   required='yes'>
        <cfargument name='CC_FAVORECIDO' 	   required='no' default=''>
        <cfargument name='VALOR_DESCONTO'	   required='no' default='0'>
        <cfargument name='COD_PESSOA_PAGADOR'  required='yes'>
        <cfargument name='COMENTARIO'		   required='no' default=''>
        <cfargument name='BLOQUETO_AUTOMATICO' required='yes'>

        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='finan.pkg_faturamento.prc_faturamento_manual' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'           dbvarname='P_CONHECIMENTO_ID'     value='#arguments.CONHECIMENTO_ID#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'           dbvarname='P_NUM_NOTA_ID'         value='#arguments.NUM_NOTA_ID#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'           dbvarname='P_DOCTO_ID'            value='#arguments.DOCTO_ID#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'           dbvarname='P_DATA_EMISSAO'        value='#arguments.DATA_EMISSAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'           dbvarname='P_DATA_VENCTO'         value='#arguments.DATA_VENCTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'           dbvarname='P_NUM_DOCTO'           value='#arguments.NUM_DOCTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CC_FAVORECIDO'  	  value='#arguments.CC_FAVORECIDO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_DESCONTO'      value='#arguments.VALOR_DESCONTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_PESSOA_PAGADOR'  value='#arguments.COD_PESSOA_PAGADOR#' >                    
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'           dbvarname='P_COMENTARIO'          value='#arguments.COMENTARIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_BLOQUETO_AUTOMATICO' value='#arguments.BLOQUETO_AUTOMATICO#'  null='#iif(len(trim(arguments.BLOQUETO_AUTOMATICO)), de('no'), de('yes'))#'>
                    
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Fatura gerada com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!--- 
    -- PROPSITO
    -- Gera nosso numero
    -- guto 27/05/2009 11:30:44 - CRIADO
    --->
    <cffunction name='altera_bloqueto_a4' displayname='Gera nosso numero' access='remote' returntype='Struct' output='true'>
        <cfargument name='BLOQUETO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='finan.pkg_bloqueto.prc_altera_bloqueto_a4' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_BLOQUETO_ID'  value='#arguments.BLOQUETO_ID#'  null='#iif(len(trim(arguments.BLOQUETO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOSSO_NUMERO' variable='retorno.NOSSO_NUMERO' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Bloqueto alterado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Marca bloqueto como impresso
    -- guto 27/05/2009 11:32:11 - CRIADO
    --->
    <cffunction name='bloqueto_impresso' displayname='Marca bloqueto como impresso' access='remote' returntype='Struct' output='true'>
        <cfargument name='BLOQUETO_ID' required='yes'>
        <cfargument name='NOSSO_NUMERO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='finan.pkg_bloqueto.prc_bloqueto_impresso' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_BLOQUETO_ID'  value='#arguments.BLOQUETO_ID#'  null='#iif(len(trim(arguments.BLOQUETO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOSSO_NUMERO'  value='#arguments.NOSSO_NUMERO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Bloqueto alterado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset retorno.mensagem_str = cfcatch.Message>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Fatura CRT
    -- guto 28/05/2009 17:15:23 - CRIADO
    --->
    <cffunction name='prc_ins_fatura_crt' displayname='Fatura CRT' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONHECIMENTO_ID' required='yes'>
        <cfargument name='COD_PESSOA_PAGADOR' required='yes'>
        <cfargument name='DOCTO_ID' required='yes'>
        <cfargument name='DATA_EMISSAO' required='yes'>
        <cfargument name='DATA_VENCTO' required='yes'>
        <cfargument name='BLOQUETO_AUTOMATICO' required='yes'>
        <cfargument name='NUM_DOCTO' required='yes'>
        <cfargument name='CONTAS_RECEBER_ID' required='no' default="">
        <cfargument name='COMENTARIO' required='no' default="">
        <cftry>
            <cftransaction action='begin'>
               <cfloop list="#arguments.CONHECIMENTO_ID#" index="v_crt_id">
                    <cfstoredproc procedure='finan.pkg_faturamento_crt.prc_ins_fatura_crt' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONHECIMENTO_ID'  value='#v_crt_id#'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA_PAGADOR#'  null='#iif(len(trim(arguments.COD_PESSOA_PAGADOR)), de('no'), de('yes'))#'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DOCTO_ID'  value='#arguments.DOCTO_ID#' >
                        <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' >
                        <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_VENCTO'  value='#arguments.DATA_VENCTO#' >
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_BLOQUETO_AUTOMATICO'  value='#arguments.BLOQUETO_AUTOMATICO#'  null='#iif(len(trim(arguments.BLOQUETO_AUTOMATICO)), de('no'), de('yes'))#'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUM_DOCTO'  value='#arguments.NUM_DOCTO#' >
                        <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONTAS_RECEBER_ID'  value='#arguments.CONTAS_RECEBER_ID#' variable='retorno.CONTAS_RECEBER_ID'  null='#iif(len(trim(arguments.CONTAS_RECEBER_ID)), de('no'), de('yes'))#'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMENTARIO'  value='#arguments.COMENTARIO#' >
                    </cfstoredproc>
                    <cfset arguments.CONTAS_RECEBER_ID = retorno.CONTAS_RECEBER_ID>
                </cfloop>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Fatura inserida com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

<!--- 
-- PROPSITO
-- Insere faturamento na NF ES
-- guto 04/06/2009 09:10:33 - CRIADO
--->
<cffunction name='ins_nfes_contas_receber' displayname='Insere faturamento na NF ES' access='remote' returntype='Struct' output='true'>
	<cfargument name='NUM_NOTA_ID' required='yes'>
	<cfargument name='DOCTO_ID' required='yes'>
    <cfargument name='CONTAS_RECEBER_ID' required='no' default="">
	<cfargument name='NUM_DOCTO' required='yes'>
	<cfargument name='PARC_DOCTO' required='no' default="1">
	<cfargument name='COD_HISTORICO' required='no' default="1"> <!---Recebimento de Nota Fiscal de Servio--->
	<cfargument name='DATA_EMISSAO' required='yes'>
	<cfargument name='DATA_VENCTO' required='yes'>
	<cfargument name='VALOR_DOCTO' required='yes'>
	<cfargument name='BLOQUETO_AUTOMATICO' required='yes'>
	<cfargument name='CC_FAVORECIDO' required='no' default="">
	<cfargument name='FEBRABAN_LAYOUT_ARQUIVO' required='no' default="030">
    <cfargument name='COMENTARIO' required='no' default="">
	<cftry>
		<cftransaction action='begin'>
        	<cfloop list="#arguments.NUM_NOTA_ID#" index="num_nota">
                <cfstoredproc procedure='finan.pkg_faturamento_nf_es.prc_ins_nfes_contas_receber' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_NOTA_ID'  value='#num_nota#'  null='#iif(len(trim(num_nota)), de('no'), de('yes'))#'>
                    <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONTAS_RECEBER_ID'  value='#arguments.CONTAS_RECEBER_ID#' variable='retorno.CONTAS_RECEBER_ID'  null='#iif(len(trim(arguments.CONTAS_RECEBER_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DOCTO_ID'  value='#arguments.DOCTO_ID#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUM_DOCTO'  value='#arguments.NUM_DOCTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PARC_DOCTO'  value='#arguments.PARC_DOCTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_HISTORICO'  value='#arguments.COD_HISTORICO#'  null='#iif(len(trim(arguments.COD_HISTORICO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_VENCTO'  value='#arguments.DATA_VENCTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_DOCTO'  value='#arguments.VALOR_DOCTO#'  null='#iif(len(trim(arguments.VALOR_DOCTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_BLOQUETO_AUTOMATICO'  value='#arguments.BLOQUETO_AUTOMATICO#'  null='#iif(len(trim(arguments.BLOQUETO_AUTOMATICO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CC_FAVORECIDO'  value='#arguments.CC_FAVORECIDO#'  null='#iif(len(trim(arguments.CC_FAVORECIDO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_FEBRABAN_LAYOUT_ARQUIVO'  value='#arguments.FEBRABAN_LAYOUT_ARQUIVO#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMENTARIO'  value='#arguments.COMENTARIO#' >
                </cfstoredproc>
                <cfset arguments.CONTAS_RECEBER_ID = retorno.CONTAS_RECEBER_ID>
            </cfloop>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Fatura inserida com sucesso!')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction> 


	<!--- 
    -- PROPSITO
    -- Cancela contas a receber
    -- guto 27/05/2009 11:32:11 - CRIADO
    --->
    <cffunction name='cancela_contas_receber' displayname='Marca bloqueto como impresso' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTAS_RECEBER_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='finan.pkg_contas_receber.prc_cancelar_contas_receber' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONTAS_RECEBER_ID'  value='#arguments.CONTAS_RECEBER_ID#'  null='#iif(len(trim(arguments.CONTAS_RECEBER_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Fatura cancelada com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset retorno.mensagem_str = cfcatch.Message>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
</cfcomponent>