<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPSITO
    -- Efetua o pagamento de contas (Contas a pagar
    -- cristofer 26/12/2008 17:56:48 - CRIADO
    --->
    <cffunction name='pagamento' displayname='Efetua o pagamento de contas (Contas a pagar' access='remote' returntype='Struct' output='true'>
        <cfargument name='LISTA' required='yes'>
        <cfargument name='DATA_AMORTIZACAO' required='yes'>
        <cfargument name='VALOR_AMORTIZACAO' required='yes'>
        <cfargument name='TIPO_PAGTO_ID' required='yes'>
        <cfargument name='CC_SACADO' required='yes'>
        <cfargument name='CC_DOCUMENTO' required='yes'>
        <cfargument name='COD_PESSOA_PAGAMENTO' required='no' default="">
        <cfargument name='BANCO_ID' required='no' default="">
        <cfargument name='AGENCIA_ID' required='no' default="">
        <cfargument name='AGENCIA_ID_DV' required='no' default="">
        <cfargument name='CONTA' required='no' default="">
        <cfargument name='CONTA_DV' required='no' default="">
        <cfargument name='NUM_CHEQUE' required='no' default="">
        <cfargument name='SERIE_CHEQUE' required='no' default="">
        <cfargument name='CAIXA_ID' required='no' default="">
        <cftry>
            <cftransaction action='begin'>
            	<!--- Insere os juros e descontos para as contas a pagar --->
                <cfloop list="#arguments.lista#" delimiters="," index="v_contas_pagar_id">
                	<cfif isdefined("arguments.juros_"&v_contas_pagar_id) and isnumeric(arguments['JUROS_'&v_contas_pagar_id]) and arguments['JUROS_'&v_contas_pagar_id] gt 0>
                    	<cfscript>
							ret = this.insere_juro(
												CONTAS_PAGAR_ID 			= v_contas_pagar_id,
												DATA_JURO					= arguments.DATA_AMORTIZACAO,
												VALOR_JURO					= arguments['JUROS_'&v_contas_pagar_id],
												AUTENTICADO					= 1,
												NUM_LANCAMENTO_CCORRENTE	= '',
												COD_HISTORICO				= arguments.cod_historico_juros,
												OBSERVACAO					= '');
						</cfscript>
                        <cfif ret.erro>
                        	<cfthrow object="#ret.mensagem#">
                        </cfif>
                    </cfif>
                	<cfif isdefined("arguments.descontos_"&v_contas_pagar_id) and isnumeric(arguments['DESCONTOS_'&v_contas_pagar_id]) and arguments['DESCONTOS_'&v_contas_pagar_id] gt 0>
                    	<cfscript>
							ret = this.insere_desconto(
												CONTAS_PAGAR_ID				= v_contas_pagar_id,
												NUM_RECIBO					= '',
												DATA_DESCONTO				= arguments.DATA_AMORTIZACAO,
												VALOR_DESCONTO				= arguments['DESCONTOS_'&v_contas_pagar_id],
												VALOR_DESCONTO_MOEDA		= 0,
												OPERACAO					= 0,
												DESCONTO_DEVOLUCAO			= 0,
												AUTENTICADO					= 1,
												NUM_LANCAMENTO_CCORRENTE	= '',
												GERA_LANCAMENTO_CCORRENTE	= 0,
												COD_HISTORICO				= arguments.cod_historico_descontos,
												OBSERVACAO					= '');
						</cfscript>
                        <cfif ret.erro>
                        	<cfthrow object="#ret.mensagem#">
                        </cfif>
                    </cfif>
                </cfloop>
            
                <cfstoredproc procedure='finan.pkg_contas_pagar.prc_pagamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_LISTA'  value='#arguments.LISTA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_AMORTIZACAO'  value='#arguments.DATA_AMORTIZACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_AMORTIZACAO'  value='#arguments.VALOR_AMORTIZACAO#'  null='#iif(len(trim(arguments.VALOR_AMORTIZACAO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_PAGTO_ID'  value='#arguments.TIPO_PAGTO_ID#'  null='#iif(len(trim(arguments.TIPO_PAGTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CC_SACADO'  value='#arguments.CC_SACADO#'  null='#iif(len(trim(arguments.CC_SACADO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CC_DOCUMENTO'  value='#arguments.CC_DOCUMENTO#'  null='#iif(len(trim(arguments.CC_DOCUMENTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_PAGAMENTO'  value='#arguments.COD_PESSOA_PAGAMENTO#'  null='#iif(len(trim(arguments.COD_PESSOA_PAGAMENTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_BANCO_ID'  value='#arguments.BANCO_ID#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_AGENCIA_ID'  value='#arguments.AGENCIA_ID#'  null='#iif(len(trim(arguments.AGENCIA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_AGENCIA_ID_DV'  value='#arguments.AGENCIA_ID_DV#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONTA'  value='#arguments.CONTA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONTA_DV'  value='#arguments.CONTA_DV#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_CHEQUE'  value='#arguments.NUM_CHEQUE#'  null='#iif(len(trim(arguments.NUM_CHEQUE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SERIE_CHEQUE'  value='#arguments.SERIE_CHEQUE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CAIXA_ID'  value='#arguments.CAIXA_ID#'  null='#iif(len(trim(arguments.CAIXA_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Pagamento efetuado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Compensa um cheque
    -- cristofer 27/12/2008 11:57:29 - CRIADO
    --->
    <cffunction name='compensar_cheque' displayname='Compensa uma relao de cheques' access='remote' returntype='Struct' output='true'>
        <cfargument name='CC_SACADO' required='yes'>
        <cfargument name='NUM_CHEQUE' required='yes'>
        <cfargument name='SERIE_CHEQUE' required='yes'>
        <cfargument name='DATA_COMPENSACAO' required='yes'>
        <cftry>
                <cfstoredproc procedure='finan.pkg_cheque.prc_data_compensacao_cheque' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CC_SACADO'  value='#arguments.CC_SACADO#'  null='#iif(len(trim(arguments.CC_SACADO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_CHEQUE'  value='#arguments.NUM_CHEQUE#'  null='#iif(len(trim(arguments.NUM_CHEQUE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SERIE_CHEQUE'  value='#arguments.SERIE_CHEQUE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_COMPENSACAO'  value='#arguments.DATA_COMPENSACAO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfif len(trim(arguments.DATA_COMPENSACAO))>
	                <cfset retorno.mensagem = JSStringFormat('Cheque compensado com sucesso!')>
                <cfelse>
	                <cfset retorno.mensagem = JSStringFormat('Cheque estornado com sucesso!')>
                </cfif>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!--- 
    -- PROPSITO
    -- Compensa um cheque
    -- cristofer 27/12/2008 11:57:29 - CRIADO
    --->
    <cffunction name='compensar_cheques' displayname='Compensa uma relao de cheques' access='remote' returntype='Struct' output='true'>
        <cfargument name='CHEQUES_SELECIONADOS' required='yes'>
        <cfargument name='DATA_COMPENSACAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfloop list="#arguments.cheques_selecionados#" delimiters="," index="v_cheque">
                	<cfscript>
						ret = this.compensar_cheque(cc_sacado			= ListGetAt(v_cheque,1,'|'),
													num_cheque			= ListGetAt(v_cheque,2,'|'),
													serie_cheque		= ListGetAt(v_cheque,3,'|'),
													data_compensacao	= arguments.data_compensacao
													);
					</cfscript>
                    <cfif ret.erro>
                    	<cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>
                <cfset retorno.erro = false>
                <cfif len(trim(arguments.DATA_COMPENSACAO))>
	                <cfset retorno.mensagem = JSStringFormat('Cheques compensados com sucesso!')>
                <cfelse>
	                <cfset retorno.mensagem = JSStringFormat('Cheques estornados com sucesso!')>
                </cfif>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    
    <!--- 
	-- PROPSITO
	-- Insere conta a pagar simplificado
	-- wagners 22/01/2009 13:54:51 - CRIADO
	--->
	<cffunction name='ins_cpg_simples' displayname='Insere conta a pagar simplificado' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_DOCTO' required='yes'>
		<cfargument name='VALOR_DOCTO' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='DATA_VENCTO' required='yes'>
		<cfargument name='DOCTO_ID' required='yes'>
		<cfargument name='TIPO_PAGTO_ID' required='yes'>
		<cfargument name='COD_HISTORICO' required='yes'>
		<cfargument name='COD_PESSOA' required='yes'>
		<cfargument name='COD_CENTRO_CUSTO' required='yes'>
		<cfargument name='COMENTARIO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='finan.pkg_contas_pagar.prc_ins_cpg_simples' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTAS_PAGAR_ID' variable='retorno.CONTAS_PAGAR_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUM_DOCTO'  value='#arguments.NUM_DOCTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_DOCTO'  value='#arguments.VALOR_DOCTO#'  null='#iif(len(trim(arguments.VALOR_DOCTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_VENCTO'  value='#arguments.DATA_VENCTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DOCTO_ID'  value='#arguments.DOCTO_ID#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_PAGTO_ID'  value='#arguments.TIPO_PAGTO_ID#'  null='#iif(len(trim(arguments.TIPO_PAGTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_HISTORICO'  value='#arguments.COD_HISTORICO#'  null='#iif(len(trim(arguments.COD_HISTORICO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMENTARIO'  value='#arguments.COMENTARIO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Lanamento cadastrado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    
    <!--- 
	-- PROPSITO
	-- Atualiza contas a pagar
	-- wagners 23/01/2009 10:32:18 - CRIADO
	--->
	<cffunction name='upd_contas_pagar' displayname='Atualiza contas a pagar' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTAS_PAGAR_ID' required='yes'>
		<cfargument name='DOCTO_ID' required='yes'>
		<cfargument name='NUM_DOCTO' required='yes'>
		<cfargument name='PARC_DOCTO' required='no' default="1">
		<cfargument name='COD_PESSOA_EMPRESA' required='yes'>
		<cfargument name='COD_DEPARTAMENTO' required='yes'>
		<cfargument name='COD_SETOR' required='yes'>
		<cfargument name='COD_CENTRO_CUSTO' required='yes'>
		<cfargument name='COD_HISTORICO' required='yes'>
		<cfargument name='COD_PESSOA' required='yes'>
		<cfargument name='BANCO_ID' required='no' default="">
		<cfargument name='AGENCIA_ID' required='no' default="">
		<cfargument name='CONTA' required='no' default="" >
		<cfargument name='TIPO_PAGTO_ID' required='yes'>
		<cfargument name='INTEGRADO' required='no' default="0">
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='DATA_VENCTO' required='yes'>
		<cfargument name='DATA_PREVISAO' required='yes'>
		<cfargument name='VALOR_DOCTO' required='yes'>
		<cfargument name='COD_MOEDA' required='no' default="790">
		<cfargument name='VALOR_DOCTO_MOEDA' required='no'>
		<cfargument name='VARIACAO_CAMBIAL' required='no' default="0.00">
		<cfargument name='CC_SACADO' required='yes'>
		<cfargument name='CC_FAVORECIDO' required='yes'>
		<cfargument name='EXIGE_LIBERACAO_PAGAMENTO' required='no' default="0">
		<cfargument name='SITUACAO' required='no' default="0">
		<cfargument name='CODIGO_BARRAS' required='no' default="">
		<cfargument name='COMENTARIO' required='yes'>
		<cfargument name='LANCAMENTO_PREVISAO' required='no' default="0">
		<cfargument name='PERMITE_ALTERACAO' required='no' default="">
		<cfargument name='VALIDA_PERIODO_CONTABIL' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='finan.pkg_contas_pagar.prc_atualiza_contas_pagar' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTAS_PAGAR_ID'  value='#arguments.CONTAS_PAGAR_ID#'  null='#iif(len(trim(arguments.CONTAS_PAGAR_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DOCTO_ID'  value='#arguments.DOCTO_ID#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUM_DOCTO'  value='#arguments.NUM_DOCTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PARC_DOCTO'  value='#arguments.PARC_DOCTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_EMPRESA'  value='#arguments.COD_PESSOA_EMPRESA#'  null='#iif(len(trim(arguments.COD_PESSOA_EMPRESA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_DEPARTAMENTO'  value='#arguments.COD_DEPARTAMENTO#'  null='#iif(len(trim(arguments.COD_DEPARTAMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_SETOR'  value='#arguments.COD_SETOR#'  null='#iif(len(trim(arguments.COD_SETOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_HISTORICO'  value='#arguments.COD_HISTORICO#'  null='#iif(len(trim(arguments.COD_HISTORICO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_BANCO_ID'  value='#arguments.BANCO_ID#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_AGENCIA_ID'  value='#arguments.AGENCIA_ID#'  null='#iif(len(trim(arguments.AGENCIA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONTA'  value='#arguments.CONTA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_PAGTO_ID'  value='#arguments.TIPO_PAGTO_ID#'  null='#iif(len(trim(arguments.TIPO_PAGTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_INTEGRADO'  value='#arguments.INTEGRADO#'  null='#iif(len(trim(arguments.INTEGRADO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_VENCTO'  value='#arguments.DATA_VENCTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_PREVISAO'  value='#arguments.DATA_PREVISAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_DOCTO'  value='#arguments.VALOR_DOCTO#'  null='#iif(len(trim(arguments.VALOR_DOCTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_MOEDA'  value='#arguments.COD_MOEDA#'  null='#iif(len(trim(arguments.COD_MOEDA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_DOCTO_MOEDA'  value='#arguments.VALOR_DOCTO#'  null='#iif(len(trim(arguments.VALOR_DOCTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VARIACAO_CAMBIAL'  value='#arguments.VARIACAO_CAMBIAL#'  null='#iif(len(trim(arguments.VARIACAO_CAMBIAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CC_SACADO'  value='#arguments.CC_SACADO#'  null='#iif(len(trim(arguments.CC_SACADO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CC_FAVORECIDO'  value='#arguments.CC_FAVORECIDO#'  null='#iif(len(trim(arguments.CC_FAVORECIDO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EXIGE_LIBERACAO_PAGAMENTO'  value='#arguments.EXIGE_LIBERACAO_PAGAMENTO#'  null='#iif(len(trim(arguments.EXIGE_LIBERACAO_PAGAMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SITUACAO'  value='#arguments.SITUACAO#'  null='#iif(len(trim(arguments.SITUACAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CODIGO_BARRAS'  value='#arguments.CODIGO_BARRAS#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMENTARIO'  value='#arguments.COMENTARIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LANCAMENTO_PREVISAO'  value='#arguments.LANCAMENTO_PREVISAO#'  null='#iif(len(trim(arguments.LANCAMENTO_PREVISAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PERMITE_ALTERACAO'  value='#arguments.PERMITE_ALTERACAO#'  null='#iif(len(trim(arguments.PERMITE_ALTERACAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALIDA_PERIODO_CONTABIL'  value='#arguments.VALIDA_PERIODO_CONTABIL#'  null='#iif(len(trim(arguments.VALIDA_PERIODO_CONTABIL)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Lanamento alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    
    <!--- 
	-- PROPSITO
	-- Exclui contas a pagar
	-- wagners 23/01/2009 10:34:53 - CRIADO
	--->
	<cffunction name='del_contas_pagar' displayname='Exclui contas a pagar' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTAS_PAGAR_ID' required='yes'>
		<cfargument name='VALIDA_PERIODO_CONTABIL' required='no' default="">
		<cfargument name='PERMITE_ALTERACAO' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='finan.pkg_contas_pagar.prc_excluir_contas_pagar' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTAS_PAGAR_ID'  value='#arguments.CONTAS_PAGAR_ID#'  null='#iif(len(trim(arguments.CONTAS_PAGAR_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALIDA_PERIODO_CONTABIL'  value='#arguments.VALIDA_PERIODO_CONTABIL#'  null='#iif(len(trim(arguments.VALIDA_PERIODO_CONTABIL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PERMITE_ALTERACAO'  value='#arguments.PERMITE_ALTERACAO#'  null='#iif(len(trim(arguments.PERMITE_ALTERACAO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Lanamento excludo com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    
    <!--- 
    -- PROPSITO
    -- Insere um desconto no contas a pagar
    -- cristofer 09/02/2009 16:41:45 - CRIADO
    --->
    <cffunction name='insere_desconto' displayname='Insere um desconto no contas a pagar' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTAS_PAGAR_ID' required='yes'>
        <cfargument name='NUM_RECIBO' required='yes'>
        <cfargument name='DATA_DESCONTO' required='yes'>
        <cfargument name='VALOR_DESCONTO' required='yes'>
        <cfargument name='VALOR_DESCONTO_MOEDA' required='yes'>
        <cfargument name='OPERACAO' required='yes'>
        <cfargument name='DESCONTO_DEVOLUCAO' required='yes'>
        <cfargument name='AUTENTICADO' required='yes'>
        <cfargument name='NUM_LANCAMENTO_CCORRENTE' required='yes'>
        <cfargument name='GERA_LANCAMENTO_CCORRENTE' required='yes'>
        <cfargument name='COD_HISTORICO' required='yes'>
        <cfargument name='OBSERVACAO' required='yes'>
		<cfargument name='ROWID' required='no' default="">
        <cftry>
                <cfstoredproc procedure='finan.pkg_contas_pagar.prc_insere_desconto_web' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTAS_PAGAR_ID'  value='#arguments.CONTAS_PAGAR_ID#' variable='retorno.CONTAS_PAGAR_ID'  null='#iif(len(trim(arguments.CONTAS_PAGAR_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_RECIBO'  value='#arguments.NUM_RECIBO#' variable='retorno.NUM_RECIBO'  null='#iif(len(trim(arguments.NUM_RECIBO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_DESCONTO'  value='#arguments.DATA_DESCONTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_DESCONTO'  value='#arguments.VALOR_DESCONTO#'  null='#iif(len(trim(arguments.VALOR_DESCONTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_DESCONTO_MOEDA'  value='#arguments.VALOR_DESCONTO_MOEDA#'  null='#iif(len(trim(arguments.VALOR_DESCONTO_MOEDA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OPERACAO'  value='#arguments.OPERACAO#'  null='#iif(len(trim(arguments.OPERACAO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DESCONTO_DEVOLUCAO'  value='#arguments.DESCONTO_DEVOLUCAO#'  null='#iif(len(trim(arguments.DESCONTO_DEVOLUCAO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_AUTENTICADO'  value='#arguments.AUTENTICADO#'  null='#iif(len(trim(arguments.AUTENTICADO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_LANCAMENTO_CCORRENTE'  value='#arguments.NUM_LANCAMENTO_CCORRENTE#'  null='#iif(len(trim(arguments.NUM_LANCAMENTO_CCORRENTE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_GERA_LANCAMENTO_CCORRENTE'  value='#arguments.GERA_LANCAMENTO_CCORRENTE#'  null='#iif(len(trim(arguments.GERA_LANCAMENTO_CCORRENTE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_HISTORICO'  value='#arguments.COD_HISTORICO#'  null='#iif(len(trim(arguments.COD_HISTORICO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID'  value='#arguments.ROWID#' variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Desconto inserido com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!--- 
	-- PROPSITO
    -- Insere um juro no contas a pagar
    -- cristofer 09/02/2009 17:43:45 - CRIADO
	--->
    <cffunction name='insere_juro' displayname='Insere um juro no contas a pagar' access='remote' returntype='Struct' output='true'>
	<cfargument name='CONTAS_PAGAR_ID' required='yes'>
	<cfargument name='DATA_JURO' required='yes'>
	<cfargument name='VALOR_JURO' required='yes'>
	<cfargument name='NUM_LANCAMENTO_CCORRENTE' required='yes'>
	<cfargument name='AUTENTICADO' required='yes'>
	<cfargument name='COD_HISTORICO' required='yes'>
	<cfargument name='OBSERVACAO' required='yes'>
	<cfargument name='ROWID' required='no' default="">
	<cftry>
			<cfstoredproc procedure='finan.pkg_contas_pagar.prc_insere_juro_wen' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_JURO_ID' variable='retorno.JURO_ID' >
				<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTAS_PAGAR_ID'  value='#arguments.CONTAS_PAGAR_ID#' variable='retorno.CONTAS_PAGAR_ID'  null='#iif(len(trim(arguments.CONTAS_PAGAR_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_JURO'  value='#arguments.DATA_JURO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_JURO'  value='#arguments.VALOR_JURO#'  null='#iif(len(trim(arguments.VALOR_JURO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_LANCAMENTO_CCORRENTE'  value='#arguments.NUM_LANCAMENTO_CCORRENTE#'  null='#iif(len(trim(arguments.NUM_LANCAMENTO_CCORRENTE)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_AUTENTICADO'  value='#arguments.AUTENTICADO#'  null='#iif(len(trim(arguments.AUTENTICADO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_HISTORICO'  value='#arguments.COD_HISTORICO#'  null='#iif(len(trim(arguments.COD_HISTORICO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
				<cfprocparam type='INOUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID'  value='#arguments.ROWID#' variable='retorno.ROWID' >
			</cfstoredproc>
			<cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Juro inserido com sucesso!')>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
	</cffunction>
	
	<!--- 
    -- PROPSITO
    -- Marca o cheque como impresso
    -- cristofer 26/02/2009 16:53:37 - CRIADO
    --->
    <cffunction name='impresso_cheque' displayname='Marca o cheque como impresso' access='remote' returntype='Struct' output='true'>
        <cfargument name='CC_SACADO' required='yes'>
        <cfargument name='SERIE_CHEQUE' required='yes'>
        <cfargument name='NUM_CHEQUE' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='finan.pkg_cheque.prc_impresso_cheque' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CC_SACADO'  value='#arguments.CC_SACADO#'  null='#iif(len(trim(arguments.CC_SACADO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SERIE_CHEQUE'  value='#arguments.SERIE_CHEQUE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_CHEQUE'  value='#arguments.NUM_CHEQUE#'  null='#iif(len(trim(arguments.NUM_CHEQUE)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Cheque impresso com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
</cfcomponent>