<cfcomponent displayname="Controle e manipulao de veculos" extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO 
	-- Busca FROTA
	-- NOTAS EXPLICATIVAS
	--->
	<cffunction name="get_placa" returntype="string" access="remote">
		<cfargument name="cod_veiculo" required="no">
		<cfquery name="qr_result"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select oper.pkg_veiculo.fnc_get_placa('#arguments.cod_veiculo#') as placa
			  from dual
 		</cfquery>		
		<cfreturn qr_result.placa>
	</cffunction>
	<!--- 
	-- PROPSITO
	-- Cadastro do Veculo
	-- 07/12/2005 - criado
	--->
	<cffunction name="ins_veiculo" displayname="Cadastro do Veculo" access="remote" returntype="Struct" output="true">
		<cfargument name="PLACA" required="yes">
		<cfargument name="MARCA_ID" required="no" default="">
		<cfargument name="MODELO_ID" required="no" default="">
		<cfargument name="UF" required="yes">
		<cfargument name="ANO" required="no" default="">
		<cfargument name="CHASSIS" required="yes">
		<cfargument name="RENAVAN" required="yes">
		<cfargument name="COR_PREDOMINANTE" required="yes">
		<cfargument name="OBSERVACAO" required="yes">
		<cfargument name="COD_PESSOA_MOTORISTA" required="yes">	
		<cfargument name="COD_PESSOA_PROPRIETARIO" required="yes">
		<cfargument name="COD_PESSOA_PROPRIETARIO_DOCUMENTACAO" required="no" default="">
		<cfargument name="COD_PESSOA_PERMISSIONARIO" required="no" default="">	
		<cfargument name="TARA" required="no" >	
		<cfargument name="CAPACIDADE_TRACAO" required="no" >	
		<cftry>
			<cftransaction action="begin">
				<cfscript>
					conn = CreateObject("component", "_transportes.manipulacao.cfc_pessoa");
				</cfscript>
				<cfif len(trim(arguments.COD_PESSOA_PROPRIETARIO))>
					<cfscript>
						conn.ins_pessoa_modalidade(cod_pessoa = arguments.COD_PESSOA_PROPRIETARIO
													,num_modalidade = 7);
					</cfscript>
				</cfif>
				<cfif len(trim(arguments.COD_PESSOA_MOTORISTA))>
					<cfscript>
						conn.ins_pessoa_modalidade(cod_pessoa = arguments.COD_PESSOA_MOTORISTA
													,num_modalidade = 8);
					</cfscript>
				</cfif>
				<cfif len(trim(arguments.cod_pessoa_permissionario))>
					<cfscript>
						conn.ins_pessoa_modalidade(cod_pessoa = arguments.COD_PESSOA_PERMISSIONARIO
													,num_modalidade = 20);
					</cfscript>
				</cfif>
				<cfstoredproc procedure="oper.pkg_veiculo_dml.prc_insere_veiculo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_COD_VEICULO" value="#UCase(REReplace(arguments.PLACA,'-',''))#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_PLACA" value="#UCase(REReplace(arguments.PLACA,'-',''))#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_MARCA_ID" value="#arguments.MARCA_ID#" null="#iif(len(trim(arguments.MARCA_ID)), de('no'), de('yes'))#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_MODELO_ID" value="#arguments.MODELO_ID#" null="#iif(len(trim(arguments.MODELO_ID)), de('no'), de('yes'))#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_UF" value="#arguments.UF#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_ANO" value="#arguments.ANO#" null="#iif(len(trim(arguments.ANO)), de('no'), de('yes'))#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_CHASSIS" value="#UCase(arguments.CHASSIS)#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_RENAVAN" value="#arguments.RENAVAN#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_COR_PREDOMINANTE" value="#arguments.COR_PREDOMINANTE#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_CAPACIDADE_TANQUE" value="0">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_TAG_SEM_PARAR" null="yes">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DATA_INICIO_SEM_PARAR" value="">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_SITUACAO_ID" value="1">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_OBSERVACAO" value="#arguments.OBSERVACAO#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_COD_PESSOA_PROPRIETARIO" value="#arguments.COD_PESSOA_PROPRIETARIO#"  null="#iif(len(trim(arguments.COD_PESSOA_PROPRIETARIO)), de('no'), de('yes'))#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DATA_INICIO_PROPRIETARIO" value="#DateFormat(DateAdd('d',-5,Now()),'dd/mm/yyyy')#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_RASTREADOR_ID" null="yes">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DATA_INICIO_RASTREADOR" value="">
					<cfprocparam type="inout" cfsqltype="cf_sql_varchar" dbvarname="P_ROWID" null="yes" variable="returno.ROWID">
				</cfstoredproc>
				
				<cfif Len(Trim(arguments.COD_PESSOA_PROPRIETARIO_DOCUMENTACAO))>
					<cfquery datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
						insert into oper.v$veiculo_proprietario_doc
						  (placa, cod_pessoa, data_inicio)
						values
						  ('#UCase(REReplace(arguments.PLACA,'-',''))#', #arguments.COD_PESSOA_PROPRIETARIO_DOCUMENTACAO#, sysdate)
					</cfquery>			
				</cfif>
	
				<cfif Len(Trim(arguments.COD_PESSOA_PERMISSIONARIO))>
					<cfquery datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
						insert into oper.v$veiculo_permissionario
						  (placa, cod_pessoa, data_inicio)
						values
						  ('#UCase(REReplace(arguments.PLACA,'-',''))#', #arguments.COD_PESSOA_PERMISSIONARIO#, sysdate)
					</cfquery>		
				</cfif>
				
				<cfif Len(Trim(arguments.COD_PESSOA_MOTORISTA))>
					<cfquery datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
						insert into oper.v$veiculo_motorista
						  (placa, cod_pessoa, km_inicio, data_inicio, evo_id_recebimento)
						values
						  ('#UCase(REReplace(arguments.PLACA,'-',''))#', #arguments.COD_PESSOA_MOTORISTA#, 1, sysdate, NULL)
					</cfquery>		
				</cfif>
				<cfif  session.site neq "delpozo/">
					<cfstoredproc procedure="oper.pkg_veiculo_dml.PRC_VEICULO_SET_ATRIBUTO" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
							<cfprocparam dbvarname="p_placa" 	    type="in"	cfsqltype="cf_sql_varchar" value="#UCase(REReplace(arguments.PLACA,'-',''))#">
							<cfprocparam dbvarname="p_cod_atributo"	type="in"	cfsqltype="cf_sql_varchar" value="MODALIDADE">
							<cfprocparam dbvarname="p_valor"		type="in"	cfsqltype="cf_sql_varchar" value="TERCEIRO">
					</cfstoredproc>
					
					<cfif len(trim(arguments.TARA))>
						<cfstoredproc procedure="oper.pkg_veiculo_dml.PRC_VEICULO_SET_ATRIBUTO" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
							<cfprocparam dbvarname="p_placa" 	    type="in"	cfsqltype="cf_sql_varchar" value="#UCase(REReplace(arguments.PLACA,'-',''))#">
							<cfprocparam dbvarname="p_cod_atributo"	type="in"	cfsqltype="cf_sql_varchar" value="TARA">
							<cfprocparam dbvarname="p_valor"		type="in"	cfsqltype="cf_sql_varchar" value="#arguments.TARA#">
						</cfstoredproc>
					</cfif>
					
					<cfif len(trim(arguments.CAPACIDADE_TRACAO))>
						<cfstoredproc procedure="oper.pkg_veiculo_dml.PRC_VEICULO_SET_ATRIBUTO" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
							<cfprocparam dbvarname="p_placa" 	    type="in"	cfsqltype="cf_sql_varchar" value="#UCase(REReplace(arguments.PLACA,'-',''))#">
							<cfprocparam dbvarname="p_cod_atributo"	type="in"	cfsqltype="cf_sql_varchar" value="CAPACIDADE_TRACAO">
							<cfprocparam dbvarname="p_valor"		type="in"	cfsqltype="cf_sql_varchar" value="#arguments.CAPACIDADE_TRACAO#">
						</cfstoredproc>
					</cfif>
				</cfif>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Veculo cadastrado com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera dados do Veculo
	-- 07/12/2005 - criado
	--->
	<cffunction name="upd_veiculo" displayname="Altera dados do Veculo" access="remote" returntype="Struct" output="true">
		<cfargument name="PLACA" required="yes">
		<cfargument name="COD_VEICULO" required="yes">
		<cfargument name="MARCA_ID" required="yes">
		<cfargument name="MODELO_ID" required="yes">
		<cfargument name="UF" required="yes">
		<cfargument name="ANO" required="yes">
		<cfargument name="CHASSIS" required="yes">
		<cfargument name="RENAVAN" required="yes">
		<cfargument name="COR_PREDOMINANTE" required="yes">
		<cfargument name="OBSERVACAO" required="yes">
		<cfargument name="COD_PESSOA_PROPRIETARIO" required="yes">
		<cfargument name="DATA_INICIO_PROPRIETARIO" required="yes">
		<cfargument name="COD_PESSOA_MOTORISTA" required="yes">	
		<cfargument name="COD_PESSOA_PROPRIETARIO_DOCUMENTACAO" required="no" default="">
		<cfargument name="COD_PESSOA_PERMISSIONARIO" required="no" default="">	
		<cfargument name="TARA" required="no">	
		<cfargument name="CAPACIDADE_TRACAO" required="no">	
		<cftry>
			<cftransaction action="begin">
				<cfif len(trim(arguments.COD_PESSOA_PROPRIETARIO))>
					<cfscript>
						conn = CreateObject("component", "_transportes.manipulacao.cfc_pessoa");
						conn.ins_pessoa_modalidade(cod_pessoa = arguments.COD_PESSOA_PROPRIETARIO
													,num_modalidade = 3);
					</cfscript>
				</cfif>
				<cfif len(trim(arguments.COD_PESSOA_MOTORISTA))>
					<cfscript>
						conn = CreateObject("component", "_transportes.manipulacao.cfc_pessoa");
						conn.ins_pessoa_modalidade(cod_pessoa = arguments.COD_PESSOA_MOTORISTA
													,num_modalidade = 8);
					</cfscript>
				</cfif>
				<cfif len(trim(arguments.cod_pessoa_permissionario))>
					<cfscript>
						conn = CreateObject("component", "_transportes.manipulacao.cfc_pessoa");
						conn.ins_pessoa_modalidade(cod_pessoa = arguments.COD_PESSOA_PERMISSIONARIO
													,num_modalidade = 20);
					</cfscript>
				</cfif>
				<cfstoredproc procedure="oper.pkg_veiculo_dml.prc_altera_veiculo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_PLACA" value="#UCase(REReplace(arguments.PLACA,'-',''))#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_COD_VEICULO" value="#UCase(REReplace(arguments.PLACA,'-',''))#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_MARCA_ID" value="#arguments.MARCA_ID#" null="#iif(len(trim(arguments.MARCA_ID)), de('no'), de('yes'))#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_MODELO_ID" value="#arguments.MODELO_ID#" null="#iif(len(trim(arguments.MODELO_ID)), de('no'), de('yes'))#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_UF" value="#arguments.UF#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_ANO" value="#arguments.ANO#" null="#iif(len(trim(arguments.ANO)), de('no'), de('yes'))#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_CHASSIS" value="#arguments.CHASSIS#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_RENAVAN" value="#arguments.RENAVAN#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_COR_PREDOMINANTE" value="#arguments.COR_PREDOMINANTE#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_CAPACIDADE_TANQUE" value="0">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_TAG_SEM_PARAR" null="yes">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DATA_INICIO_SEM_PARAR" value="">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_SITUACAO_ID" value="1">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_OBSERVACAO" value="#arguments.OBSERVACAO#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_RASTREADOR_ID" null="yes">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_RASTREADOR_COM_PROBLEMAS" null="yes" >
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DATA_TROCA_RASTREADOR" value="">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_COD_PESSOA_PROPRIETARIO" value="#arguments.COD_PESSOA_PROPRIETARIO#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DATA_INICIO_PROPRIETARIO" value="#iif(len(trim(arguments.DATA_INICIO_PROPRIETARIO)), de(arguments.DATA_INICIO_PROPRIETARIO), de(DateFormat(Now(),'dd/mm/yyyy')))#">
				</cfstoredproc>
	
				<!---Limpa itens anteriores--->
				<cfquery datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
					delete oper.v$veiculo_proprietario_doc
					 where placa = '#UCase(REReplace(arguments.PLACA,'-',''))#'
				</cfquery>			
	
				<cfif Len(Trim(arguments.COD_PESSOA_PROPRIETARIO_DOCUMENTACAO))>
					<!---Insere novo registro--->
					<cfquery datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
						insert into oper.v$veiculo_proprietario_doc
						  (placa, cod_pessoa, data_inicio)
						values
						  ('#UCase(REReplace(arguments.PLACA,'-',''))#', #arguments.COD_PESSOA_PROPRIETARIO_DOCUMENTACAO#, sysdate)
					</cfquery>			
				</cfif>
	
				<!---Limpa itens anteriores--->
				<cfquery datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
					delete oper.v$veiculo_permissionario
					 where placa = '#UCase(REReplace(arguments.PLACA,'-',''))#'
				</cfquery>			
				
				<cfif Len(Trim(arguments.COD_PESSOA_PERMISSIONARIO))>
					<!---Insere novo registro--->
					<cfquery datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
						insert into oper.v$veiculo_permissionario
						  (placa, cod_pessoa, data_inicio)
						values
						  ('#UCase(REReplace(arguments.PLACA,'-',''))#', #arguments.COD_PESSOA_PERMISSIONARIO#, sysdate)
					</cfquery>			
				</cfif>
	
				<!---Limpa itens anteriores--->
				<cfquery datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
					delete oper.v$veiculo_motorista
					 where placa = '#UCase(REReplace(arguments.PLACA,'-',''))#'
				</cfquery>			
				
				<cfif Len(Trim(arguments.COD_PESSOA_MOTORISTA))>
					<!---Insere novo registro--->
					<cfquery datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
						insert into oper.v$veiculo_motorista
						  (placa, cod_pessoa, km_inicio, data_inicio, evo_id_recebimento)
						values
						  ('#UCase(REReplace(arguments.PLACA,'-',''))#', #arguments.COD_PESSOA_MOTORISTA#, 1, sysdate, null)
					</cfquery>		
				</cfif>
				<cfif  session.site neq "delpozo/">
					<cfstoredproc procedure="oper.pkg_veiculo_dml.PRC_VEICULO_SET_ATRIBUTO" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
							<cfprocparam dbvarname="p_placa" 	    type="in"	cfsqltype="cf_sql_varchar" value="#UCase(REReplace(arguments.PLACA,'-',''))#">
							<cfprocparam dbvarname="p_cod_atributo"	type="in"	cfsqltype="cf_sql_varchar" value="MODALIDADE">
							<cfprocparam dbvarname="p_valor"		type="in"	cfsqltype="cf_sql_varchar" value="TERCEIRO">
					</cfstoredproc>
					
					<cfif len(trim(arguments.TARA))>
						<cfstoredproc procedure="oper.pkg_veiculo_dml.PRC_VEICULO_SET_ATRIBUTO" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
							<cfprocparam dbvarname="p_placa" 	    type="in"	cfsqltype="cf_sql_varchar" value="#arguments.placa#">
							<cfprocparam dbvarname="p_cod_atributo"	type="in"	cfsqltype="cf_sql_varchar" value="TARA">
							<cfprocparam dbvarname="p_valor"		type="in"	cfsqltype="cf_sql_varchar" value="#arguments.TARA#">
						</cfstoredproc>
					</cfif>
	
					<cfif len(trim(arguments.CAPACIDADE_TRACAO))>
						<cfstoredproc procedure="oper.pkg_veiculo_dml.PRC_VEICULO_SET_ATRIBUTO" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
							<cfprocparam dbvarname="p_placa" 	    type="in"	cfsqltype="cf_sql_varchar" value="#arguments.placa#">
							<cfprocparam dbvarname="p_cod_atributo"	type="in"	cfsqltype="cf_sql_varchar" value="CAPACIDADE_TRACAO">
							<cfprocparam dbvarname="p_valor"		type="in"	cfsqltype="cf_sql_varchar" value="#arguments.CAPACIDADE_TRACAO#">
						</cfstoredproc>
					</cfif>
				</cfif>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Dados do veculo alterado com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	<!--- 
	-- PROPSITO
	-- Exclui veculo cadastrado
	-- 08/12/2005 - criado
	--->
	<cffunction name="del_veiculo" displayname="Exclui veculo cadastrado" access="remote" returntype="Struct" output="true">
		<cfargument name="COD_VEICULO" required="yes">
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="oper.pkg_veiculo_dml.prc_exclui_veiculo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_COD_VEICULO" value="#arguments.COD_VEICULO#">
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Veculo excludo com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Insere marca
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 19/12/2005 - criado
	--->
	<cffunction name="ins_marca" displayname="Insere marca" access="remote" returntype="struct" output="true">
		<cfargument name="marca" required="yes">
	    <cftry>
			<cfquery datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
				insert into oper.v$veiculo_marca
				  (marca_id, marca)
				values
				  (-1, '#arguments.marca#')
			</cfquery>

			<cfset retorno.mensagem = 'Marca inserida com sucesso.'>				
			<cfset retorno.erro = false>						
 	  <cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
	   </cfcatch>
	   </cftry>
	   <cfreturn retorno>	   
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Altera dados da marca
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 02/12/2005 - criado
	--->
	<cffunction name="upd_marca" displayname="Altera dados da Marca" access="remote" returntype="struct" output="true">
		<cfargument name="marca_id" required="yes">
		<cfargument name="marca" required="yes">
	    <cftry>
			<cfquery datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
				update oper.v$veiculo_marca
				   set marca    = '#arguments.marca#'
				 where marca_id = #arguments.marca_id#
			</cfquery>

			<cfset retorno.mensagem = 'Marca alterada com sucesso.'>				
			<cfset retorno.erro = false>						
 	  <cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
	   </cfcatch>
	   </cftry>
	   <cfreturn retorno>	   
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui marca
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 01/12/2005 - criado
	--->
	<cffunction name="del_marca" displayname="Exclui marca" access="remote" returntype="struct" output="true">
		<cfargument name="marca_id" required="yes">
	    <cftry>
			<cfquery datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
				delete oper.v$veiculo_marca
				 where marca_id = #arguments.marca_id#
			</cfquery>

			<cfset retorno.mensagem = 'Marca excluda com sucesso.'>				
			<cfset retorno.erro = false>						
 	  <cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
	   </cfcatch>
	   </cftry>
	   <cfreturn retorno>	   
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Altera local da prxima reviso
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 01/12/2005 - criado
	--->
	<cffunction name="upd_proxima_revisao" displayname="Altera local da prxima reviso" access="remote" returntype="struct" output="true">
		<cfargument name="controle_id" required="yes">
		<cfargument name="matriz" required="yes">
		<cfargument name="motivo" required="yes">
	    <cftry>
			<cfquery datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
				update oper.v$veiculo_revisao
				   set matriz = #arguments.matriz#,
				       motivo = '#arguments.motivo#'
				 where controle_id = #arguments.controle_id#
			</cfquery>

			<cfset retorno.mensagem = 'Local da prxima reviso alterado com sucesso!'>				
			<cfset retorno.erro = false>						
 	  	<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
	   	</cfcatch>
	   	</cftry>
	   <cfreturn retorno>	   
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere Composio de Veculo
	-- NOTAS EXPLICATIVAS
	--  
	-- Wagner 18/10/2006 - criado
	--->
	
	<cffunction name="set_engate" displayname="Insere composio de veiculo" access="remote" returntype="struct" output="true">
		<cfargument name="placa_1" displayname="Placa do veiculo" required="true">
		<cfargument name="placa_2" displayname="Placa do veiculo" required="true">
		<cfargument name="data" displayname="Placa do veiculo" required="yes">
 	    <cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_veiculo_dml.prc_engate_veiculo" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_placa_1" value="#arguments.placa_1#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_placa_2" value="#arguments.placa_2#">
				<cfprocparam type="in" cfsqltype="cf_sql_numeric" dbvarname="p_cod_pessoa" null="yes">
				<cfprocparam type="out" cfsqltype="cf_sql_numeric" dbvarname="p_num_romaneio" variable="retorno.num_romaneio">
				<cfprocparam type="in" cfsqltype="cf_sql_numeric" dbvarname="p_km_engate" value="0">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_data_hora_engate" value="#arguments.data#:00">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_controle_evo_id" null="yes">
				<cfprocparam type="in" cfsqltype="cf_sql_numeric" dbvarname="p_latitude" null="yes">
				<cfprocparam type="in" cfsqltype="cf_sql_numeric" dbvarname="p_longitude" null="yes">
				<cfprocparam type="in" cfsqltype="cf_sql_numeric" dbvarname="p_referencia_id" null="yes">
				<cfprocparam type="in" cfsqltype="cf_sql_numeric" dbvarname="p_local" null="yes">
			</cfstoredproc>
			<cfset retorno.mensagem = 'Composio montada com sucesso.'>				
			<cfset retorno.erro = false>						
 	  	<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
	   	</cfcatch>
	   	</cftry>
	   	<cfreturn retorno>
	</cffunction>
	
	<!--- 
    -- PROPSITO
    -- Desengata veculo terceiro
    -- guto 31/10/2007 10:34:59 - CRIADO
    --->
    <cffunction name='set_desengate_terceiro' displayname='Desengata veculo terceiro' access='remote' returntype='Struct' output='true'>
        <cfargument name='PLACA_1' required='yes'>
        <cfargument name='PLACA_2' required='yes'>
        <cfargument name='DATA_HORA_ENGATE' required='yes'>
        <cfargument name='DATA_HORA_DESENGATE' required='yes'>
        <cfargument name='KM_DESENGATE' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_veiculo_dml.prc_desengate_veiculo_terceiro' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA_1'  value='#arguments.PLACA_1#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA_2'  value='#arguments.PLACA_2#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_HORA_ENGATE'  value='#arguments.DATA_HORA_ENGATE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_HORA_DESENGATE'  value='#arguments.DATA_HORA_DESENGATE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_KM_DESENGATE'  value='#arguments.KM_DESENGATE#'  null='#iif(len(trim(arguments.KM_DESENGATE)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Veculo desengatado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>  	
    <!--- 
	-- PROPSITO
	-- Inserir verificao de laudo.
	-- LEOPOLDOS 25/06/2010 15:05:23 - CRIADO
	--->
	<cffunction name='ins_laudo_verificacao' displayname='Inserir verificao de laudo.' access='remote' returntype='Struct' output='true'>
		<cfargument name='PLACA' required='yes'>
		<cfargument name='LAUDO_ID' required='yes'>
		<cfargument name='DATA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_veiculo_laudos.prc_ins_laudo_verificacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LAUDO_ID'  value='#arguments.LAUDO_ID#'  null='#iif(len(trim(arguments.LAUDO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA'  value='#arguments.DATA#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_VERIFICACAO_ID'  variable='retorno.VERIFICACAO_ID' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Verificao inserida com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    <!--- 
	-- PROPSITO
	-- Inserir um item da verificao de laudo.
	-- LEOPOLDOS 25/06/2010 15:06:36 - CRIADO
	--->
	<cffunction name='ins_laudo_verificacao_item' displayname='Inserir um item da verificao de laudo.' access='remote' returntype='Struct' output='true'>
		<cfargument name='VERIFICACAO_ID' required='yes'>
		<cfargument name='ATRIBUTO_ID' required='yes'>
		<cfargument name='VALOR' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_veiculo_laudos.prc_ins_laudo_verificacao_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VERIFICACAO_ID'  value='#arguments.VERIFICACAO_ID#'  null='#iif(len(trim(arguments.VERIFICACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATRIBUTO_ID'  value='#arguments.ATRIBUTO_ID#'  null='#iif(len(trim(arguments.ATRIBUTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_VALOR'  value='#arguments.VALOR#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Item da verificao inserido com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    <!--- 
	-- PROPSITO
	-- Insere exceo de Laudo
	-- LEOPOLDOS 21/07/2010 10:28:04 - CRIADO
	--->
	<cffunction name='ins_laudo_excecao' displayname='Insere exceo de Laudo' access='remote' returntype='Struct' output='true'>
		<cfargument name='LAUDO_ID' required='yes'>
		<cfargument name='PLACA' required='yes'>
		<cftry>
   			<cfset arguments.placa = this.get_placa(arguments.placa)>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_veiculo_laudos.prc_ins_laudo_excecao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LAUDO_ID'  value='#arguments.LAUDO_ID#'  null='#iif(len(trim(arguments.LAUDO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Exceo inserida com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    

<!--- 
-- PROPSITO
-- Cadastro do Veculo
-- 07/12/2005 - criado
--->
<cffunction name="ins_veiculo_completo" displayname="Cadastro do Veculo com proprietario e composicao" access="remote" returntype="Struct" output="true">
  <cfargument name="VEICULO_ID" required="no">
  <cfargument name="COD_VEICULO" required="no">
  <cfargument name='PLACA' required='yes'>
  <cfargument name='AGRUPAMENTO_ID' required='yes'>
  <cfargument name='TIPO_CARROCERIA_ID' required='yes'>
  <cfargument name='MARCA_ID' required='yes'>
  <cfargument name='MODELO_ID' required='yes'>
  <cfargument name='UF' required='yes'>
  <cfargument name='ANO' required='yes'>
  <cfargument name='CHASSIS' required='yes'>
  <cfargument name='RENAVAN' required='yes'>
  <cfargument name='COR_PREDOMINANTE' required='yes'>
  <cfargument name='CAPACIDADE_TANQUE' required='no' default="">
  <cfargument name='MUNICIPIO_ID' required='yes'>
  <cfargument name='TAG_SEM_PARAR' required='no'>
  <cfargument name='DATA_INICIO_SEM_PARAR' required='no'>
  <cfargument name='SITUACAO_ID' required='no'>
  <cfargument name='OBSERVACAO' required='no' default="">
  <cfargument name='COD_PESSOA_PROPRIETARIO' required='yes'>
  <cfargument name='DATA_INICIO_PROPRIETARIO' required='no'>
  <cfargument name='RASTREADOR_ID' required='no'>
  <cfargument name='DATA_INICIO_RASTREADOR' required='no'>
  <cfargument name='NUMERO_EIXOS' required="no">
  <cfargument name='TARA' required="no">
  <cfargument name='COD_PESSOA_MOTORISTA' required="no">
  <cfargument name='DATA_INICIO_MOTORISTA' required='no'>
  <cfargument name='COD_PESSOA_PERMISSIONARIO' required="no">
  <cfargument name='COD_PESSOA_PROPRIETARIO_DOCTO' required="no">
  <cftry>
    <cftransaction action="begin">
      <cfscript>
     			conn = CreateComponent("_transportes.manipulacao.cfc_pessoa");
	     </cfscript>
      <cfif len(trim(arguments.COD_PESSOA_PROPRIETARIO))>
        <cfscript>
		         conn.ins_pessoa_modalidade(cod_pessoa = arguments.COD_PESSOA_PROPRIETARIO,num_modalidade = 7);
        </cfscript>
      </cfif>
      <cfif len(trim(arguments.COD_PESSOA_MOTORISTA))>
        <cfscript>
			conn.ins_pessoa_modalidade(cod_pessoa = arguments.COD_PESSOA_MOTORISTA,num_modalidade = 8);
		</cfscript>
      </cfif>
      <cfscript>
			if (not len(trim(arguments.VEICULO_ID))){
				  this.ins_veiculos(COD_VEICULO = '#arguments.PLACA#',
									PLACA = '#arguments.PLACA#',
									MARCA_ID = '#arguments.MARCA_ID#',
									MODELO_ID = '#arguments.MODELO_ID#',
									UF = '#arguments.UF#',
									ANO = '#arguments.ANO#',
									CHASSIS = '#arguments.CHASSIS#',
									RENAVAN = '#arguments.RENAVAN#',
									COR_PREDOMINANTE = '#arguments.COR_PREDOMINANTE#',
									MUNICIPIO_ID = '#arguments.MUNICIPIO_ID#',
									TAG_SEM_PARAR = '#arguments.TAG_SEM_PARAR#',
									DATA_INICIO_SEM_PARAR = '#arguments.DATA_INICIO_SEM_PARAR#',
									OBSERVACAO = '#arguments.OBSERVACAO#',
									COD_PESSOA_PROPRIETARIO_DOCTO = '#arguments.COD_PESSOA_PROPRIETARIO_DOCTO#',
									COD_PESSOA_PROPRIETARIO = '#arguments.COD_PESSOA_PROPRIETARIO#',
									DATA_INICIO_PROPRIETARIO = '#arguments.DATA_INICIO_PROPRIETARIO#',
									RASTREADOR_ID = '#arguments.RASTREADOR_ID#',
									DATA_INICIO_RASTREADOR = '#arguments.DATA_INICIO_RASTREADOR#',
									NUMERO_EIXOS = '#arguments.NUMERO_EIXOS#',
									TARA = '#arguments.TARA#',
									TIPO_CARROCERIA_ID = '#arguments.TIPO_CARROCERIA_ID#',
									COD_PESSOA_MOTORISTA = '#arguments.COD_PESSOA_MOTORISTA#',
									DATA_INICIO_MOTORISTA = '#arguments.DATA_INICIO_MOTORISTA#',
									COD_PESSOA_PERMISSIONARIO = '#arguments.COD_PESSOA_PERMISSIONARIO#');		   
								}
		    else {
  				  this.upd_veiculos(VEICULO_ID = '#arguments.VEICULO_ID#',
				  					PLACA = '#arguments.PLACA#',
					  			    COD_VEICULO = '#arguments.PLACA#',
									MARCA_ID = '#arguments.MARCA_ID#',
									MODELO_ID = '#arguments.MODELO_ID#',
									UF = '#arguments.UF#',
									ANO = '#arguments.ANO#',
									CHASSIS = '#arguments.CHASSIS#',
									RENAVAN = '#arguments.RENAVAN#',
									COR_PREDOMINANTE = '#arguments.COR_PREDOMINANTE#',
									CAPACIDADE_TANQUE = '#arguments.CAPACIDADE_TANQUE#',
									MUNICIPIO_ID = '#arguments.MUNICIPIO_ID#',
									TAG_SEM_PARAR = '#arguments.TAG_SEM_PARAR#',
									DATA_INICIO_SEM_PARAR = '#arguments.DATA_INICIO_SEM_PARAR#',
									COD_PESSOA_PROPRIETARIO_DOCTO = '#arguments.COD_PESSOA_PROPRIETARIO_DOCTO#',
									OBSERVACAO = '#arguments.OBSERVACAO#',
									COD_PESSOA_PROPRIETARIO = '#arguments.COD_PESSOA_PROPRIETARIO#',
									DATA_INICIO_PROPRIETARIO = '#arguments.DATA_INICIO_PROPRIETARIO#',
									RASTREADOR_ID = '#arguments.RASTREADOR_ID#',
									DATA_INICIO_RASTREADOR = '#arguments.DATA_INICIO_RASTREADOR#',
									NUMERO_EIXOS = '#arguments.NUMERO_EIXOS#',
									TARA = '#arguments.TARA#',
									TIPO_CARROCERIA_ID = '#arguments.TIPO_CARROCERIA_ID#',
									COD_PESSOA_MOTORISTA = '#arguments.COD_PESSOA_MOTORISTA#',
									DATA_INICIO_MOTORISTA = '#arguments.DATA_INICIO_MOTORISTA#',
									COD_PESSOA_PERMISSIONARIO = '#arguments.COD_PESSOA_PERMISSIONARIO#');		   
			}
					
      </cfscript>
      <!---Inseres de Carretas--->
      <cfscript>                        
          	v_sr_placa = this.ListaToArray (lista = arguments, variavel = "SR_PLACA_CARRETA");
											v_sr_veiculo_id = this.ListaToArray (lista = arguments, variavel = "SR_VEICULO_ID_CARRETA");
											v_sr_marca_id = this.ListaToArray (lista = arguments, variavel = "SR_MARCA_ID_CARRETA");
											v_sr_modelo_id = this.ListaToArray (lista = arguments, variavel = "SR_MODELO_ID_CARRETA"); 
											v_sr_uf = this.ListaToArray (lista = arguments, variavel = "SR_UF_CARRETA");                           
											v_sr_ano = this.ListaToArray (lista = arguments, variavel = "SR_ANO_CARRETA");
											v_sr_chassis = this.ListaToArray (lista = arguments, variavel = "SR_CHASSIS_CARRETA");
											v_sr_renavan = this.ListaToArray (lista = arguments, variavel = "SR_RENAVAN_CARRETA");
											v_sr_capacidade_tanque = '#arguments.CAPACIDADE_TANQUE#';
											v_sr_cor_predominante =this.ListaToArray (lista = arguments, variavel = "SR_COR_PREDOMINANTE_CARRETA");                            
											v_sr_municipio_id = this.ListaToArray (lista = arguments, variavel = "SR_MUNICIPIO_ID_CARRETA");
											v_sr_tipo_carroceria_id = this.ListaToArray (lista = arguments, variavel = "SR_TIPO_CARROCERIA_ID_CARRETA");
											v_sr_cod_veiculo = this.ListaToArray (lista = arguments, variavel = "SR_COD_VEICULO_CARRETA");				
											v_sr_tag_sem_parar = '#arguments.TAG_SEM_PARAR#';
											v_sr_data_inicio_sem_parar = '#arguments.DATA_INICIO_SEM_PARAR#';
											v_sr_situacao_id = '#arguments.SITUACAO_ID#';
											v_sr_observacao =  '#arguments.OBSERVACAO#';													
											v_cod_pessoa_proprietario = '#arguments.COD_PESSOA_PROPRIETARIO#';
											v_data_inicio_proprietario = '#arguments.DATA_INICIO_PROPRIETARIO#';
											v_sr_rastreador_id = '#arguments.RASTREADOR_ID#';
											v_sr_rastreador_com_problemas = '#arguments.RASTREADOR_COM_PROBLEMAS#';
											v_sr_data_troca_rastreador =  '#arguments.DATA_TROCA_RASTREADOR#';
											v_sr_data_inicio_rastreador = '#arguments.DATA_INICIO_RASTREADOR#';							
											v_sr_numero_eixos = this.ListaToArray (lista = arguments, variavel = "SR_NUMERO_EIXOS_CARRETA");
											v_sr_tara = this.ListaToArray (lista = arguments, variavel = "SR_TARA_CARRETA");
											v_cod_pessoa_motorista = '#arguments.COD_PESSOA_MOTORISTA#';
											v_cod_pessoa_permissionario = '#arguments.COD_PESSOA_PERMISSIONARIO#';
											v_modalidade = '#arguments.MODALIDADE#';
											v_veiculo_excluir = this.ListDiff(lista1 = arguments.lista_deleted_carreta, lista2 = ArrayToList(v_sr_veiculo_ID, ','));
      </cfscript>
      
      <cfloop list="#v_veiculo_excluir#" delimiters="," index="l_vei_id">
        <cfscript>
				this.del_veiculos(
								  VEICULO_ID  = l_vei_id
								 );
           </cfscript>
      </cfloop>
      <cfloop from="1" to="#ArrayLen(v_sr_placa)#" index="count">
        <cfscript>
			if(not len(trim(v_sr_veiculo_id[count]))) {
				   this.ins_veiculos(COD_VEICULO = v_sr_cod_veiculo[count],
									 PLACA = v_sr_placa[count],
									 MARCA_ID = v_sr_marca_id[count],
									 MODELO_ID = v_sr_modelo_id[count],
									 UF = v_sr_uf[count],
									 ANO = v_sr_ano[count], 
									 CHASSIS = v_sr_chassis[count],
									 RENAVAN = v_sr_renavan[count],
									 CAPACIDADE_TANQUE = v_sr_capacidade_tanque,
									 COR_PREDOMINANTE = v_sr_cor_predominante[count],
									 MUNICIPIO_ID = v_sr_municipio_id[count],
									 TAG_SEM_PARAR = v_sr_tag_sem_parar,
									 DATA_INICIO_SEM_PARAR = v_sr_data_inicio_sem_parar,													 
									 OBSERVACAO = v_sr_observacao,
									 COD_PESSOA_PROPRIETARIO_DOCTO = arguments.COD_PESSOA_PROPRIETARIO_DOCTO,
									 COD_PESSOA_PROPRIETARIO = v_cod_pessoa_proprietario,
									 DATA_INICIO_PROPRIETARIO = v_data_inicio_proprietario,
									 RASTREADOR_ID = v_sr_rastreador_id,
									 DATA_INICIO_RASTREADOR = v_sr_data_inicio_rastreador,
									 NUMERO_EIXOS = v_sr_numero_eixos[count],
									 TARA = v_sr_tara[count],
									 COD_PESSOA_MOTORISTA = '',
									 COD_PESSOA_PERMISSIONARIO = v_cod_pessoa_permissionario,
									 TIPO_CARROCERIA_ID = v_sr_tipo_carroceria_id[count]);
			   }else {
					this.upd_veiculos(  VEICULO_ID = v_sr_veiculo_id[count],
										PLACA = v_sr_placa[count],
										COD_VEICULO = v_sr_placa[count],
										MARCA_ID = v_sr_marca_id[count],
										MODELO_ID = v_sr_modelo_id[count],
										UF = v_sr_uf[count],
										ANO = v_sr_ano[count], 
										CHASSIS = v_sr_chassis[count],
										RENAVAN = v_sr_renavan[count],
										CAPACIDADE_TANQUE = v_sr_capacidade_tanque,
										COR_PREDOMINANTE = v_sr_cor_predominante[count],
										MUNICIPIO_ID = v_sr_municipio_id[count],
										TAG_SEM_PARAR = v_sr_tag_sem_parar,
										DATA_INICIO_SEM_PARAR = v_sr_data_inicio_sem_parar,
										OBSERVACAO = v_sr_observacao,
									    COD_PESSOA_PROPRIETARIO_DOCTO = #arguments.COD_PESSOA_PROPRIETARIO_DOCTO#,
										COD_PESSOA_PROPRIETARIO = v_cod_pessoa_proprietario,
										DATA_INICIO_PROPRIETARIO = v_data_inicio_proprietario,
										RASTREADOR_ID = v_sr_rastreador_id,
										RASTREADOR_COM_PROBLEMAS = v_sr_rastreador_com_problemas,
										DATA_TROCA_RASTREADOR =  v_sr_data_troca_rastreador,
										DATA_INICIO_RASTREADOR = v_sr_data_inicio_rastreador,
										NUMERO_EIXOS = v_sr_numero_eixos[count],
										TARA = v_sr_tara[count],
										COD_PESSOA_MOTORISTA = '',
										COD_PESSOA_PERMISSIONARIO = v_cod_pessoa_permissionario,
										MODALIDADE = v_modalidade,
										TIPO_CARROCERIA_ID = v_sr_tipo_carroceria_id[count]);
						}
        </cfscript>
      </cfloop>
      
      <cfscript>
			conn = CreateComponent("_transportes.consulta.cfc_veiculo");
			qrVeiculo = conn.get_composicao(cod_veiculo = arguments.placa);
	  </cfscript>
        
      <cfloop from="1" to="#ArrayLen(v_sr_placa)#" index="count">
        <cfscript>
				conn = CreateComponent("_transportes.consulta.cfc_veiculo");
				qrEngate = conn.get_desengate(placa = arguments.COD_VEICULO, somente_engatados = 1);
        </cfscript>
        <cfdump var="#qrEngate#">
        <cfif len(Trim('#qrEngate.data_hora_engate#'))>
			<cfdump var="count">
			<cfscript>
				if(count eq 1){	
					retD = this.set_desengate_terceiro(
												PLACA_1 = '#arguments.PLACA#',
												PLACA_2 = v_sr_placa[count],
												DATA_HORA_ENGATE= '#qrEngate.data_hora_engate#', 
												DATA_HORA_DESENGATE= LSDateFormat('12/06/2013 00:00:01', 'dd/mm/yyyy') & ' ' & LSTimeFormat(Now(), 'HH:mm:ss'),
												KM_DESENGATE = '#qrEngate.km_engate#'
												);
				}
        	</cfscript>
            <cfif isDefined("retD") and retD.erro >
               <cfthrow object="#retD.mensagem#" >
            </cfif> 
        </cfif>
      </cfloop>
      
      <cfloop from="2" to="#ArrayLen(v_sr_placa)#" index="count">
        <cfscript> 
			conn = CreateComponent("_transportes.consulta.cfc_veiculo");
			qrEngate = conn.get_desengate(placa = v_sr_placa[count - 1], somente_engatados = 1);
        </cfscript>
        <cfif len(Trim('#qrEngate.data_hora_engate#'))>
			<cfscript>
				if(count eq 2){
					retD2 = this.set_desengate_terceiro(
												PLACA_1 =  v_sr_placa[count - 1],
												PLACA_2 = v_sr_placa[count],
												DATA_HORA_ENGATE= '#qrEngate.data_hora_engate#', 
												DATA_HORA_DESENGATE= LSDateFormat(Now(), 'dd/mm/yyyy') & ' ' & LSTimeFormat(Now(), 'HH:mm:ss'),
												KM_DESENGATE = '#qrEngate.km_engate#'
											   );
				}
			</cfscript>
            <cfif isDefined("retD2") and retD2.erro >
            	<cfthrow object="#retD2.mensagem#">
            </cfif> 
        </cfif>
      </cfloop>
      
      <cfloop from="1" to="#ArrayLen(v_sr_placa)#" index="count">
        <cfscript>
			if(count eq 1){
				
				retE = this.set_engates(
								PLACA_1 = '#arguments.PLACA#',
								PLACA_2 = v_sr_placa[count],
								DATA = LSDateFormat(Now(), 'dd/mm/yyyy') & ' ' & LSTimeFormat(Now(), 'HH:mm:ss'),
								COD_PESSOA_MOTORISTA = v_cod_pessoa_motorista
							);
					}
			if(count eq 2){
				retE = this.set_engates(PLACA_1 = v_sr_placa[count - 1],
							     PLACA_2 = v_sr_placa[count],
							     DATA = LSDateFormat(Now(), 'dd/mm/yyyy') & ' ' & LSTimeFormat(Now(), 'HH:mm:ss'),
							     COD_PESSOA_MOTORISTA = v_cod_pessoa_motorista);
			}
		  </cfscript>
          <cfif isDefined("retE.erro") and retE.erro >
          	<cfthrow object="#retE#" >
          </cfif>
      </cfloop>
      
      <cfset retorno.erro = false>
      <cfset retorno.mensagem = JSStringFormat("Veculo cadastrado com sucesso!")>
    </cftransaction>
    <cfcatch>
      <cftransaction action="rollback"/>
	  <cfset retorno.erro = true>
      <cfset retorno.mensagem = cfcatch>
      <cfset request.erro = cfcatch>
    </cfcatch>
  </cftry>
  <cfreturn retorno />
</cffunction>    

<!---
Propsito: 
Insere dados da lista em veiculos
--->
<cffunction name="ins_veiculos" displayname="Cadastro do Veculo" access="remote" returntype="Struct" output="true">
  <cfargument name="COD_VEICULO" required="no">
  <cfargument name='PLACA' required='yes'>
  <cfargument name='MARCA_ID' required='yes'>
  <cfargument name='MODELO_ID' required='yes'>
  <cfargument name='UF' required='yes'>
  <cfargument name='ANO' required='yes'>
  <cfargument name='CHASSIS' required='yes'>
  <cfargument name='RENAVAN' required='yes'>
  <cfargument name='COR_PREDOMINANTE' required='yes'>
  <cfargument name='CAPACIDADE_TANQUE' required='no' default="">
  <cfargument name='MUNICIPIO_ID' required='yes'>
  <cfargument name='TAG_SEM_PARAR' required='no'>
  <cfargument name='DATA_INICIO_SEM_PARAR' required='no'>
  <cfargument name='SITUACAO_ID' required='no'>
  <cfargument name='OBSERVACAO' required='no'>
  <cfargument name='COD_PESSOA_PROPRIETARIO_DOCTO' required='yes'>
  <cfargument name='COD_PESSOA_PROPRIETARIO' required='yes'>
  <cfargument name='DATA_INICIO_PROPRIETARIO' required='no'>
  <cfargument name='RASTREADOR_ID' required='no'>
  <cfargument name='DATA_INICIO_RASTREADOR' required='no'>
  <cfargument name="NUMERO_EIXOS" required="yes">
  <cfargument name="COD_PESSOA_MOTORISTA" required="no">
  <cfargument name='DATA_INICIO_MOTORISTA' required='no'>
  <cfargument name="COD_PESSOA_PERMISSIONARIO" required="no">
  <cfargument name="MODALIDADE" required="no">
  <cfargument name="TIPO_CARROCERIA_ID" required="no">  
  <cfset arguments.COD_VEICULO = arguments.PLACA >
  
  <cfscript>
			conn = CreateComponent("_transportes.manipulacao.cfc_pessoa");
	</cfscript>
  <cfif len(trim(arguments.COD_PESSOA_PROPRIETARIO))>
    <cfscript>
             conn.ins_pessoa_modalidade(cod_pessoa = arguments.COD_PESSOA_PROPRIETARIO,num_modalidade = 7);
       </cfscript>
  </cfif>
  <cfif len(trim(arguments.COD_PESSOA_MOTORISTA))>
    <cfscript>
            conn.ins_pessoa_modalidade(cod_pessoa = arguments.COD_PESSOA_MOTORISTA,num_modalidade = 8);
        </cfscript>
  </cfif>
  <cfif len(trim(arguments.cod_pessoa_permissionario))>
    <cfscript>
              conn.ins_pessoa_modalidade(cod_pessoa = arguments.COD_PESSOA_PERMISSIONARIO,num_modalidade = 20);
       </cfscript>
  </cfif>

  <cfstoredproc procedure='oper.pkg_frota_dml.prc_ins_veiculo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_VEICULO' value='#arguments.COD_VEICULO#' >
    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MARCA_ID'  value='#arguments.MARCA_ID#'  null='#iif(len(trim(arguments.MARCA_ID)), de('no'), de('yes'))#'>
    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MODELO_ID'  value='#arguments.MODELO_ID#'  null='#iif(len(trim(arguments.MODELO_ID)), de('no'), de('yes'))#'>
    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_UF'  value='#arguments.UF#' >
    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ANO'  value='#arguments.ANO#'  null='#iif(len(trim(arguments.ANO)), de('no'), de('yes'))#'>
    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CHASSIS'  value='#arguments.CHASSIS#' >
    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RENAVAN'  value='#arguments.RENAVAN#' > 
    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COR_PREDOMINANTE'  value='#arguments.COR_PREDOMINANTE#' >
    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CAPACIDADE_TANQUE'  value='#arguments.CAPACIDADE_TANQUE#'  null='#iif(len(trim(arguments.CAPACIDADE_TANQUE)), de('no'), de('yes'))#'>
    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TAG_SEM_PARAR'  value='#arguments.TAG_SEM_PARAR#'  null='#iif(len(trim(arguments.TAG_SEM_PARAR)), de('no'), de('yes'))#'>
    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO_SEM_PARAR'  value='#arguments.DATA_INICIO_SEM_PARAR#' >
    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
    <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RASTREADOR_ID'  value='#arguments.RASTREADOR_ID#'  null='#iif(len(trim(arguments.RASTREADOR_ID)), de('no'), de('yes'))#' variable="RETORNO.RASTREADOR_ID">
    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO_RASTREADOR'  value='#arguments.DATA_INICIO_RASTREADOR#' >
    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NOTA_ID' null="yes" >
    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_CONTRATO' null="yes" >
    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5' dbvarname='P_DATA_COMPRA' null="yes" >
    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5' dbvarname='P_TIPO_COMPRA' null="yes" >
    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_CARROCERIA_ID'  value='#arguments.TIPO_CARROCERIA_ID#'  null='#iif(len(trim(arguments.TIPO_CARROCERIA_ID)), de('no'), de('yes'))#'>
    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MUNICIPIO_ID'  value='#arguments.MUNICIPIO_ID#'  null='#iif(len(trim(arguments.MUNICIPIO_ID)), de('no'), de('yes'))#'>
    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VEICULO_ID'  variable='retorno.VEICULO_ID'  null="yes" >
    <cfprocparam type='INOUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID'  variable='retorno.ROWID' null="yes" >
  </cfstoredproc> 
  
  <cfif Len(Trim(arguments.COD_PESSOA_MOTORISTA))>
    <cfscript>
		 set_motorista = this.ins_motorista_veiculo_terc(placa = UCase(REReplace(arguments.PLACA,'-','')),
		 												   cod_pessoa_motorista = arguments.COD_PESSOA_MOTORISTA,
														   km_inicio = 1,
														   data_inicio = arguments.DATA_INICIO_MOTORISTA,
														   data_fim = '');														   
	</cfscript>

    <cfif IsDefined("set_motorista.erro") and set_motorista.erro >
       <cfthrow object="#set_motorista.mensagem#">
    </cfif>
  </cfif>
  
  <cfif Len(Trim(arguments.COD_PESSOA_PROPRIETARIO))>
	  <cfscript>	
        set_proprietario = this.ins_veiculo_proprietario(placa = UCase(REReplace(arguments.PLACA,'-','')),
		                                                cod_pessoa = arguments.COD_PESSOA_PROPRIETARIO,
														data_inicio = arguments.DATA_INICIO_PROPRIETARIO);
  	  </cfscript> 
	  <cfif IsDefined("set_proprietario.erro") and set_proprietario.erro >
           <cfthrow object="#set_proprietario.mensagem#">
      </cfif>
  </cfif>

  <cfif Len(Trim(arguments.COD_PESSOA_PROPRIETARIO_DOCTO))>
	  <cfscript>	
        set_proprietario_docto = this.ins_veiculo_prop_doc(placa = UCase(REReplace(arguments.PLACA,'-','')),
													       cod_pessoa = arguments.COD_PESSOA_PROPRIETARIO_DOCTO,
													       data_inicio = arguments.DATA_INICIO_PROPRIETARIO);
  	  </cfscript> 
	  <cfif IsDefined("set_proprietario_docto.erro") and set_proprietario_docto.erro >
           <cfthrow object="#set_proprietario_docto.mensagem#">
      </cfif>
  </cfif>
    
  <cfif Len(Trim(arguments.COD_PESSOA_PERMISSIONARIO))>
	  <cfscript>	
        set_permissionario = this.ins_veiculo_permissionario(placa = UCase(REReplace(arguments.PLACA,'-','')),
		                                                     cod_pessoa = arguments.COD_PESSOA_PERMISSIONARIO,
														     data_inicio = arguments.DATA_INICIO_PROPRIETARIO);
  	  </cfscript> 
	  <cfif IsDefined("set_permissionario.erro") and set_permissionario.erro >
	       <cfthrow object="#set_situacao.mensagem#">
      </cfif>
  </cfif>  
  
  <cfscript>
     set_modalidade = this.ins_veiculo_modalidade(placa = UCase(REReplace(arguments.PLACA,'-','')),
	                                               modalidade = 'TERCEIRO',
												   data = arguments.DATA_INICIO_PROPRIETARIO,
												   VEICULO_MODALIDADE_ID = '');
  </cfscript>  
  <cfif IsDefined("set_modalidade.erro") and set_modalidade.erro >
       <cfthrow object="#set_situacao.mensagem#">
  </cfif>
  
  <cfscript>
     set_situacao = this.ins_veiculo_hist_situacao(placa = UCase(REReplace(arguments.PLACA,'-','')),
	                                               situacao_id = 1,
												   data = arguments.DATA_INICIO_PROPRIETARIO);
  </cfscript>  
  
  <cfif IsDefined("set_situacao.erro") and  set_situacao.erro >
       <cfthrow object="#set_situacao.mensagem#">
  </cfif>  
  
  <cfif len(trim(arguments.TARA))>
    <cfstoredproc procedure="oper.pkg_frota_dml.PRC_ALT_VEICULO_ATRIBUTO" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
      <cfprocparam dbvarname="p_placa" 	    type="in"	cfsqltype="cf_sql_varchar" value="#UCase(REReplace(arguments.PLACA,'-',''))#">
      <cfprocparam dbvarname="p_cod_atributo"	type="in"	cfsqltype="cf_sql_varchar" value="TARA">
      <cfprocparam dbvarname="p_valor"		type="in"	cfsqltype="cf_sql_varchar" value="#arguments.TARA#">
	  <cfprocparam cfsqltype='CF_SQL_VARCHAR' type='OUT'  dbvarname='P_ROWID' variable='retorno.ROWID' >
    </cfstoredproc>
  </cfif>
  <cfif len(trim(arguments.NUMERO_EIXOS))>
    <cfstoredproc procedure="oper.pkg_frota_dml.PRC_ALT_VEICULO_ATRIBUTO" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
      <cfprocparam dbvarname="p_placa" 	    type="in"	cfsqltype="cf_sql_varchar" value="#UCase(REReplace(arguments.PLACA,'-',''))#">
      <cfprocparam dbvarname="p_cod_atributo"	type="in"	cfsqltype="cf_sql_varchar" value="NUMERO_EIXOS">
      <cfprocparam dbvarname="p_valor"		type="in"	cfsqltype="cf_sql_varchar" value="#arguments.NUMERO_EIXOS#">
	  <cfprocparam cfsqltype='CF_SQL_VARCHAR' type='OUT' dbvarname='P_ROWID' variable='retorno.ROWID' >
    </cfstoredproc>
  </cfif>
  <cfreturn structnew() />
</cffunction>

<!---altera dados  da lista em veiculos--->
<cffunction name="upd_veiculos" displayname="Altera dados do Veculo" access="remote" returntype="Struct" output="true">
  <cfargument name="VEICULO_ID" required="no">
  <cfargument name="COD_VEICULO" required="no">
  <cfargument name='PLACA' required='yes'>
  <cfargument name='MARCA_ID' required='yes'>
  <cfargument name='MODELO_ID' required='yes'>
  <cfargument name='UF' required='yes'>
  <cfargument name='ANO' required='yes'>
  <cfargument name='CHASSIS' required='yes'>
  <cfargument name='RENAVAN' required='yes'>
  <cfargument name='COR_PREDOMINANTE' required='yes'>
  <cfargument name='CAPACIDADE_TANQUE' required='no' default="">
  <cfargument name='MUNICIPIO_ID' required='yes'>
  <cfargument name='TAG_SEM_PARAR' required='no'>
  <cfargument name='DATA_INICIO_SEM_PARAR' required='no'>
  <cfargument name='SITUACAO_ID' required='no'>
  <cfargument name='OBSERVACAO' required='no' default="">
  <cfargument name='COD_PESSOA_PROPRIETARIO' required='yes'>
  <cfargument name='DATA_INICIO_PROPRIETARIO' required='no'>
  <cfargument name='RASTREADOR_ID' required='no'>
  <cfargument name='RASTREADOR_COM_PROBLEMAS' required="no" default="">
  <cfargument name='DATA_TROCA_RASTREADOR' required="no" default="">
  <cfargument name='DATA_INICIO_RASTREADOR' required='no'>
  <cfargument name="NUMERO_EIXOS" required="yes">
  <cfargument name="COD_PESSOA_MOTORISTA" required="no">
  <cfargument name="COD_PESSOA_PERMISSIONARIO" required="no">
  <cfstoredproc procedure="oper.pkg_frota_dml.PRC_ALT_VEICULO" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_VEICULO'  value='#arguments.COD_VEICULO#' >
    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MARCA_ID'  value='#arguments.MARCA_ID#'  null='#iif(len(trim(arguments.MARCA_ID)), de('no'), de('yes'))#'>
    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MODELO_ID'  value='#arguments.MODELO_ID#'  null='#iif(len(trim(arguments.MODELO_ID)), de('no'), de('yes'))#'>
    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_UF'  value='#arguments.UF#' >
    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ANO'  value='#arguments.ANO#'  null='#iif(len(trim(arguments.ANO)), de('no'), de('yes'))#'>
    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CHASSIS'  value='#arguments.CHASSIS#' >
    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RENAVAN'  value='#arguments.RENAVAN#' >
    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COR_PREDOMINANTE'  value='#arguments.COR_PREDOMINANTE#' >
    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CAPACIDADE_TANQUE'  value='#arguments.CAPACIDADE_TANQUE#'  null='#iif(len(trim(arguments.CAPACIDADE_TANQUE)), de('no'), de('yes'))#'>
    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TAG_SEM_PARAR'  value='#arguments.TAG_SEM_PARAR#'  null='#iif(len(trim(arguments.TAG_SEM_PARAR)), de('no'), de('yes'))#'>
    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO_SEM_PARAR'  value='#arguments.DATA_INICIO_SEM_PARAR#' >
    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RASTREADOR_ID'  value='#arguments.RASTREADOR_ID#'  null='#iif(len(trim(arguments.RASTREADOR_ID)), de('no'), de('yes'))#'>
    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RASTREADOR_COM_PROBLEMAS'  value='#arguments.RASTREADOR_COM_PROBLEMAS#'  null='#iif(len(trim(arguments.RASTREADOR_COM_PROBLEMAS)), de('no'), de('yes'))#'>
    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_TROCA_RASTREADOR'  value='#arguments.DATA_TROCA_RASTREADOR#' >
    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NOTA_ID' null="yes" >
    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_CONTRATO' null="yes" >
    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_COMPRA' null="yes" >
    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TIPO_COMPRA' null="yes" >
    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_CARROCERIA_ID'  value='#arguments.TIPO_CARROCERIA_ID#'  null='#iif(len(trim(arguments.TIPO_CARROCERIA_ID)), de('no'), de('yes'))#'>
    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MUNICIPIO_ID'  value='#arguments.MUNICIPIO_ID#'  null='#iif(len(trim(arguments.MUNICIPIO_ID)), de('no'), de('yes'))#'>
  </cfstoredproc>
  
  <cfif Len(Trim(arguments.COD_PESSOA_MOTORISTA))>
    <cfscript>
		 set_motorista = this.ins_motorista_veiculo_terc(placa = UCase(REReplace(arguments.PLACA,'-','')),
		 												   cod_pessoa_motorista = arguments.COD_PESSOA_MOTORISTA,
														   km_inicio = 1,
														   data_inicio = arguments.DATA_INICIO_MOTORISTA,
														   data_fim = '');														   
	</cfscript>

    <cfif IsDefined("set_motorista.erro") and set_motorista.erro >
       <cfthrow object="#set_motorista.mensagem#">
    </cfif>
  </cfif>
  
  <!---Atualiza proprietrio--->
  <cfif Len(Trim(arguments.COD_PESSOA_PROPRIETARIO))>
     <cfscript>
        ret = this.prc_atualiza_veiculo_prop(placa = UCase(REReplace(arguments.PLACA,'-',''))
										    ,COD_PESSOA_PROPRIETARIO = arguments.COD_PESSOA_PROPRIETARIO
										    ,proprietario_desde = arguments.DATA_INICIO_PROPRIETARIO);
     </cfscript>
	 <cfif ret.erro>
        <cfthrow object="#ret.mensagem#">
     </cfif>	 
  </cfif>
  
  <!---Atualiza proprietrio--->
  <cfif Len(Trim(arguments.COD_PESSOA_PROPRIETARIO_DOCTO))>
     <cfscript>
        ret = this.prc_atualiza_veiculo_prop_doc(placa = UCase(REReplace(arguments.PLACA,'-',''))
												,COD_PESSOA_PROPRIETARIO = arguments.COD_PESSOA_PROPRIETARIO_DOCTO
												,proprietario_desde = arguments.DATA_INICIO_PROPRIETARIO);
     </cfscript>
	 <cfif ret.erro>
        <cfthrow object="#ret.mensagem#">
     </cfif>	 
  </cfif>
  
  <!---Atualiza Permissionrio--->
  <cfif Len(Trim(arguments.COD_PESSOA_PERMISSIONARIO))>
     <cfscript>
        ret = this.prc_atualiza_veiculo_permis(placa = UCase(REReplace(arguments.PLACA,'-',''))
											  ,COD_PESSOA_PROPRIETARIO = arguments.COD_PESSOA_PERMISSIONARIO
											  ,proprietario_desde = arguments.DATA_INICIO_PROPRIETARIO);
     </cfscript>
	 <cfif ret.erro>
        <cfthrow object="#ret.mensagem#">
     </cfif>	 
  </cfif>  
  
  <!---Atualiza Modaliade Atual--->
  <cfquery name="qrModalidade" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
     select max(modalidade) keep(dense_rank last order by data) modalidade
       from oper.v$veiculo_modalidade
      where placa = '#UCase(REReplace(arguments.PLACA,'-',''))#'                       
  </cfquery>			
  
  <cfif qrModalidade.MODALIDADE neq 'TERCEIRO'>
	  <cfscript>
         set_modalidade = this.ins_veiculo_modalidade(placa = UCase(REReplace(arguments.PLACA,'-','')),
                                                      modalidade = 'TERCEIRO',
                                                      data = DateFormat(now(),'dd/mm/yyyy hh:mm:ss'),
                                                      VEICULO_MODALIDADE_ID = '');
      </cfscript>  
      <cfif IsDefined("set_modalidade.erro") and set_modalidade.erro >
           <cfthrow object="#set_modalidade.mensagem#">
      </cfif>
  </cfif>
  
  <!---Atualiza situao--->
  <cfscript>
	 set_situacao = this.prc_atualiza_veiculo_situacao(placa = UCase(REReplace(arguments.PLACA,'-','')),
												       situacao_id = 1);
  </cfscript>  
  <cfif IsDefined("set_situacao.erro") and set_situacao.erro >
	   <cfthrow object="#set_situacao.mensagem#">
  </cfif>
    
  <cfif len(trim(arguments.TARA))>
    <cfstoredproc procedure="oper.pkg_frota_dml.PRC_ALT_VEICULO_ATRIBUTO" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
      <cfprocparam dbvarname="p_placa" 	    type="in"	cfsqltype="cf_sql_varchar" value="#UCase(REReplace(arguments.PLACA,'-',''))#">
      <cfprocparam dbvarname="p_cod_atributo"	type="in"	cfsqltype="cf_sql_varchar" value="TARA">
      <cfprocparam dbvarname="p_valor"		type="in"	cfsqltype="cf_sql_varchar" value="#arguments.TARA#">
	  <cfprocparam cfsqltype='CF_SQL_VARCHAR' type='OUT'  dbvarname='P_ROWID' variable='retorno.ROWID' >
    </cfstoredproc>
  </cfif>
  <cfif len(trim(arguments.NUMERO_EIXOS))>
    <cfstoredproc procedure="oper.pkg_frota_dml.PRC_ALT_VEICULO_ATRIBUTO" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
      <cfprocparam dbvarname="p_placa" 	    type="in"	cfsqltype="cf_sql_varchar" value="#UCase(REReplace(arguments.PLACA,'-',''))#">
      <cfprocparam dbvarname="p_cod_atributo"	type="in"	cfsqltype="cf_sql_varchar" value="NUMERO_EIXOS">
      <cfprocparam dbvarname="p_valor"		type="in"	cfsqltype="cf_sql_varchar" value="#arguments.NUMERO_EIXOS#">
	  <cfprocparam cfsqltype='CF_SQL_VARCHAR' type='OUT' dbvarname='P_ROWID' variable='retorno.ROWID' >
    </cfstoredproc>
  </cfif>  
  <cfreturn structnew() />
</cffunction>

<!--- 
-- PROPSITO
-- Insere motorista a veiculo terceiro
-- GUTO 24/06/2011 09:13:51 - CRIADO
--->
<cffunction name='ins_motorista_veiculo_terc' displayname='Insere motorista a veiculo terceiro' access='remote' returntype='Struct' output='true'>
	<cfargument name='PLACA' required='yes'>
	<cfargument name='COD_PESSOA_MOTORISTA' required='yes'>
	<cfargument name='KM_INICIO' required='yes'>
	<cfargument name='DATA_INICIO' required='yes'>
	<cftry>
		<!---<cftransaction action='begin'>--->
			<cfstoredproc procedure='oper.pkg_motorista.prc_ins_motorista_veiculo_terc' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_MOTORISTA'  value='#arguments.COD_PESSOA_MOTORISTA#'  null='#iif(len(trim(arguments.COD_PESSOA_MOTORISTA)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_KM_INICIO'  value='#arguments.KM_INICIO#'  null='#iif(len(trim(arguments.KM_INICIO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO'  value='#arguments.DATA_INICIO#' >
				<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Recebimento de veiculo executado com sucesso!')>
		<!---</cftransaction>--->
		<cfcatch>
			<!---<cftransaction action='rollback'/>--->
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

<!--- 
-- PROPSITO
-- Exclui motorista a veiculo terceiro atual
-- GUTO 24/06/2011 09:16:19 - CRIADO
--->
<cffunction name='del_motorista_veiculo_terc' displayname='Exclui motorista a veiculo terceiro atual' access='remote' returntype='Struct' output='true'>
	<cfargument name='COD_PESSOA_MOTORISTA' required='yes'>
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='oper.pkg_motorista.prc_del_motorista_veiculo_terc' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_MOTORISTA'  value='#arguments.COD_PESSOA_MOTORISTA#'  null='#iif(len(trim(arguments.COD_PESSOA_MOTORISTA)), de('no'), de('yes'))#'>
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Recebimento de veiculo excludo com sucesso!')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

<!--- 
-- PROPSITO
-- Insere Composio de Veculo
-- NOTAS EXPLICATIVAS
--  
-- Wagner 18/10/2006 - criado
--->
<cffunction name="set_engates" displayname="Insere composio de veiculo" access="remote" returntype="struct" output="true">
  <cfargument name="placa_1"  required="true">
  <cfargument name="placa_2"  required="true">
  <cfargument name="data" required="no" default="">
  <cfargument name="cod_pessoa_motorista" required="no" default="">
  <cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_frota_dml.prc_engate_veiculo" username="#session.usuario#" password="#session.senha#">
    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_placa_1" value="#arguments.placa_1#">
    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_placa_2" value="#arguments.placa_2#">
    <cfprocparam type="in" cfsqltype="cf_sql_numeric" dbvarname="p_cod_pessoa" value='#arguments.cod_pessoa_motorista#'  null='#iif(len(trim(arguments.cod_pessoa_motorista)), de('no'), de('yes'))#'> 
    <cfprocparam type="out" cfsqltype="cf_sql_numeric" dbvarname="p_num_romaneio" variable="retorno.num_romaneio">
    <cfprocparam type="in" cfsqltype="cf_sql_numeric" dbvarname="p_km_engate" value="0">
    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_data_hora_engate" value="#arguments.data#">
    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_controle_evo_id" null="yes">
    <cfprocparam type="in" cfsqltype="cf_sql_numeric" dbvarname="p_latitude" null="yes">
    <cfprocparam type="in" cfsqltype="cf_sql_numeric" dbvarname="p_longitude" null="yes">
    <cfprocparam type="in" cfsqltype="cf_sql_numeric" dbvarname="p_referencia_id" null="yes">
    <cfprocparam type="in" cfsqltype="cf_sql_numeric" dbvarname="p_local" null="yes">
  </cfstoredproc>
  <cfreturn structnew() />
</cffunction>

<!--- 
-- PROPSITO
-- Insere modalidade do veiculo
-- publico 24/06/2011 11:49:29 - CRIADO
--->
<cffunction name='ins_veiculo_modalidade' displayname='Insere modalidade do veiculo' access='remote' returntype='Struct' output='true'>
	<cfargument name='PLACA' required='yes'>
	<cfargument name='MODALIDADE' required='yes'>
	<cfargument name='DATA' required='yes'>
	<cfargument name='VEICULO_MODALIDADE_ID' required='yes'>
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='oper.pkg_frota_dml.prc_ins_veiculo_modalidade' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MODALIDADE'  value='#arguments.MODALIDADE#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA'  value='#arguments.DATA#' >
				<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VEICULO_MODALIDADE_ID'  value='#arguments.VEICULO_MODALIDADE_ID#' variable='retorno.VEICULO_MODALIDADE_ID'  null='#iif(len(trim(arguments.VEICULO_MODALIDADE_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Modalidade inserida com sucesso!')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

<!--- 
-- PROPSITO
-- Insere proprietario do veiculo
-- GUTO 24/06/2011 14:56:05 - CRIADO
--->
<cffunction name='ins_veiculo_proprietario' displayname='Insere proprietario do veiculo' access='remote' returntype='Struct' output='true'>
	<cfargument name='PLACA' required='yes'>
	<cfargument name='COD_PESSOA' required='yes'>
	<cfargument name='DATA_INICIO' required='yes'>
	<cfargument name='DATA_FIM' required='no' default="">
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='oper.pkg_frota_dml.prc_ins_veiculo_proprietario' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO'  value='#arguments.DATA_INICIO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_FIM'  value='#arguments.DATA_FIM#' >
				<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Proprietrio inserido com sucesso!')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

<!--- 
-- PROPSITO
-- Insere permissionario do veiculo
-- GUTO 24/06/2011 15:14:36 - CRIADO
--->
<cffunction name='ins_veiculo_permissionario' displayname='Insere permissionario do veiculo' access='remote' returntype='Struct' output='true'>
	<cfargument name='PLACA' required='yes'>
	<cfargument name='COD_PESSOA' required='yes'>
	<cfargument name='DATA_INICIO' required='yes'>
	<cfargument name='DATA_FIM' required='no' default="">
    <cfargument name='PAIS_AUTORIZADO_TRIC' required='no' default="">      
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='oper.pkg_frota_dml.prc_ins_veiculo_permissionario' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO'  value='#arguments.DATA_INICIO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_FIM'  value='#arguments.DATA_FIM#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PAIS_AUTORIZADO_TRIC'  value='#arguments.PAIS_AUTORIZADO_TRIC#'  null='#iif(len(trim(arguments.PAIS_AUTORIZADO_TRIC)), de('no'), de('yes'))#'>                                    
				<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Permissionario inserido com sucesso!')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

<!--- 
-- PROPSITO
-- Insere proprietario documentacao do veiculo
-- GUTO 24/06/2011 15:16:36 - CRIADO
--->
<cffunction name='ins_veiculo_prop_doc' displayname='Insere proprietario documentacao do veiculo' access='remote' returntype='Struct' output='true'>
	<cfargument name='PLACA' required='yes'>
	<cfargument name='COD_PESSOA' required='yes'>
	<cfargument name='DATA_INICIO' required='yes'>
	<cfargument name='DATA_FIM' required='no' default="">
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='oper.pkg_frota_dml.prc_ins_veiculo_prop_doc' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO'  value='#arguments.DATA_INICIO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_FIM'  value='#arguments.DATA_FIM#' >
				<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Proprietrio inserido com sucesso!')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

<!--- 
-- PROPSITO
-- Insere situao ao veiculo
-- GUTO 24/06/2011 15:33:06 - CRIADO
--->
<cffunction name='ins_veiculo_hist_situacao' displayname='Insere situao ao veiculo' access='remote' returntype='Struct' output='no'>
	<cfargument name='PLACA' required='yes'>
	<cfargument name='SITUACAO_ID' required='yes'>
	<cfargument name='DATA' required='yes'>
	<cfargument name='VEICULO_SITUACAO_ID' required='no' default="">
	<cftry>
			<cfstoredproc procedure='oper.pkg_frota_dml.prc_ins_veiculo_hist_situacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SITUACAO_ID'  value='#arguments.SITUACAO_ID#'  null='#iif(len(trim(arguments.SITUACAO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA'  value='#arguments.DATA#' >
				<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VEICULO_SITUACAO_ID'  value='#arguments.VEICULO_SITUACAO_ID#' variable='retorno.VEICULO_SITUACAO_ID'  null='#iif(len(trim(arguments.VEICULO_SITUACAO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Situao inserido com sucesso!')>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

	<!--- 
	-- PROPSITO
	-- Atualiza o Proprietrio de um Veculo Terceiro
	-- RAFAEL 16/10/2009 15:40:53 - CRIADO
	--->
	<cffunction name='prc_atualiza_veiculo_prop' displayname='Atualiza o Proprietrio de um Veculo Terceiro' access='remote' returntype='Struct' output='true'>
		<cfargument name='PLACA' required='yes'>
		<cfargument name='COD_PESSOA_PROPRIETARIO' required='yes'>
		<cfargument name='PROPRIETARIO_DESDE' required='yes'>
		<cftry>
				<cfstoredproc procedure='oper.pkg_frota_dml.prc_atualiza_veiculo_prop' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_PROPRIETARIO'  value='#arguments.COD_PESSOA_PROPRIETARIO#'  null='#iif(len(trim(arguments.COD_PESSOA_PROPRIETARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PROPRIETARIO_DESDE'  value='#arguments.PROPRIETARIO_DESDE#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Proprietrio alterado com sucesso.')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Atualiza o Proprietrio de um Veculo Terceiro
	-- RAFAEL 16/10/2009 15:40:53 - CRIADO
	--->
	<cffunction name='prc_atualiza_veiculo_prop_doc' displayname='Atualiza o Proprietrio de um Veculo Terceiro' access='remote' returntype='Struct' output='true'>
		<cfargument name='PLACA' required='yes'>
		<cfargument name='COD_PESSOA_PROPRIETARIO' required='yes'>
		<cfargument name='PROPRIETARIO_DESDE' required='yes'>
		<cftry>
				<cfstoredproc procedure='oper.pkg_frota_dml.prc_atualiza_veiculo_prop_doc' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_PROPRIETARIO'  value='#arguments.COD_PESSOA_PROPRIETARIO#'  null='#iif(len(trim(arguments.COD_PESSOA_PROPRIETARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PROPRIETARIO_DESDE'  value='#arguments.PROPRIETARIO_DESDE#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Proprietrio alterado com sucesso.')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Atualiza o Permissionrio de um Veculo Terceiro
	-- RAFAEL 16/10/2009 15:40:53 - CRIADO
	--->
	<cffunction name='prc_atualiza_veiculo_permis' displayname='Atualiza o Permissionrio de um Veculo Terceiro' access='remote' returntype='Struct' output='true'>
		<cfargument name='PLACA' required='yes'>
		<cfargument name='COD_PESSOA_PROPRIETARIO' required='yes'>
		<cfargument name='PROPRIETARIO_DESDE' required='yes'>
		<cftry>
				<cfstoredproc procedure='oper.pkg_frota_dml.prc_atualiza_veiculo_permis' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_PROPRIETARIO'  value='#arguments.COD_PESSOA_PROPRIETARIO#'  null='#iif(len(trim(arguments.COD_PESSOA_PROPRIETARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PROPRIETARIO_DESDE'  value='#arguments.PROPRIETARIO_DESDE#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Permissionrio alterado com sucesso.')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    
    <!--- 
	-- PROPSITO
	-- Atualizar Situao de um Veculo
	-- RAFAEL 24/10/2011 10:27:38 - CRIADO
	--->
	<cffunction name='prc_atualiza_veiculo_situacao' displayname='Atualizar Situao de um Veculo' access='remote' returntype='Struct' output='true'>
		<cfargument name='PLACA' required='yes'>
		<cfargument name='SITUACAO_ID' required='yes'>
		<cftry>
				<cfstoredproc procedure='oper.pkg_frota_dml.prc_atualiza_veiculo_situacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SITUACAO_ID'  value='#arguments.SITUACAO_ID#'  null='#iif(len(trim(arguments.SITUACAO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
	<!--- 
    -- PROPSITO
    -- Insere KM inicial para o veiculo
    -- GUTO 06/06/2012 09:36:34 - CRIADO
    --->
    <cffunction name='ins_veiculo_km_inicializacao' displayname='Insere KM inicial para o veiculo' access='remote' returntype='Struct' output='true'>
        <cfargument name='VEICULO_ID' required='yes'>
        <cfargument name='DATA_INICIALIZACAO' required='yes'>
        <cfargument name='KM' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_frota_dml.prc_ins_km_inicializacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VEICULO_ID'  value='#arguments.VEICULO_ID#'  null='#iif(len(trim(arguments.VEICULO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIALIZACAO'  value='#arguments.DATA_INICIALIZACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_KM'  value='#arguments.KM#'  null='#iif(len(trim(arguments.KM)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('KM inicial registrado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Exclui KM inicial para o veiculo
    -- GUTO 06/06/2012 09:37:59 - CRIADO
    --->
    <cffunction name='del_veiculo_km_inicializacao' displayname='Exclui KM inicial para o veiculo' access='remote' returntype='Struct' output='true'>
        <cfargument name='VEICULO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_frota_dml.prc_del_km_inicializacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VEICULO_ID'  value='#arguments.VEICULO_ID#'  null='#iif(len(trim(arguments.VEICULO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('KM inicial excludo com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
</cfcomponent>