<!-- KM&M Componentes -->
<cfcomponent displayname="Manipulao da rea de vales" extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO
	-- Alocao de Vales no sistema, primeira operao que os vales podem sofrer
	-- 01/03/2006 - criado
	--->
	<cffunction name="aloca_vales" access="remote" returntype="struct" output="true">
		<cfargument name="num_inicial" displayname="Numero do inicio da sequencia" type="numeric" required="yes">
		<cfargument name="num_final" displayname="Nmero do final da sequencia" type="numeric" required="yes">
		<cfargument name="valor" displayname="Valor dos vales" type="numeric" required="yes">
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_controla_vale.prc_aloca_vales" username="#session.usuario#" password="#session.senha#">		
					<cfprocparam dbvarname="p_num_inicial" cfsqltype="cf_sql_integer" type="in" value="#arguments.num_inicial#">
					<cfprocparam dbvarname="p_num_final" cfsqltype="cf_sql_integer" type="in" value="#arguments.num_final#">
					<cfprocparam dbvarname="p_valor" cfsqltype="cf_sql_float" type="in" value="#arguments.valor#">			
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Vales alocados com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Altera o local de troca dos vales
	-- CRISTOFER 01/03/2006 
	--->
	<cffunction name="altera_local_troca_vale" access="remote" returntype="struct" output="true">
		<cfargument name="num_vale" 		required="yes">
		<cfargument name="cod_local_troca" 	required="yes">
		<cftry>
			<cftransaction action="begin">
                <cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_controla_vale.prc_alt_local_troca" username="#session.usuario#" password="#session.senha#">		
                    <cfprocparam dbvarname="p_num_vale" cfsqltype="cf_sql_integer" type="in" value="#arguments.num_vale#">
                    <cfprocparam dbvarname="p_cod_pessoa_troca" cfsqltype="cf_sql_integer" type="in" value="#arguments.cod_local_troca#">
                </cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Local de Troca alterado com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
	<cfreturn retorno>
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Insere um log de Troca de vale
	-- 16/01/2006 - criado
	--->
	<cffunction name="cancela_vales" displayname="Cancela vales" access="remote" returntype="struct" output="true">
		<cfargument name="num_vale" 		required="no">
		<cfargument name="vale_inicial" 	required="no">
		<cfargument name="vale_final" 		required="no">
		<cfargument name="motivo" 			required="yes">
		<cfargument name="situacao" 		required="yes">
		<cfargument name="todos" 			required="no" default="0">
		<cfargument name="cod_funcionario" 	required="no" default="0">
		<cfargument name="operacao" 		required="no" default="0">
		<cfif arguments.operacao eq 1>
			<cfset arguments.vale_inicial = arguments.num_vale>
			<cfset arguments.vale_final = arguments.num_vale>
		<cfelseif arguments.operacao eq 3>
			<cfset arguments.vale_inicial = 0>
			<cfset arguments.vale_final = 0>
			<cfset arguments.todos = 1>
		</cfif>
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_controla_vale.prc_cancela_vales" username="#session.usuario#" password="#session.senha#">		
					<cfprocparam dbvarname="p_num_inicial" cfsqltype="cf_sql_integer" type="in" value="#arguments.vale_inicial#">
					<cfprocparam dbvarname="p_num_final" cfsqltype="cf_sql_integer" type="in" value="#arguments.vale_final#">
					<cfprocparam dbvarname="p_motivo" cfsqltype="cf_sql_varchar" type="in" value="#arguments.motivo#">
					<cfprocparam dbvarname="p_situacao_id" cfsqltype="cf_sql_integer" type="in" value="#arguments.situacao#">
					<cfprocparam dbvarname="p_cod_pessoa" cfsqltype="cf_sql_integer" type="in" value="#arguments.cod_funcionario#">
					<cfprocparam dbvarname="p_todos" cfsqltype="cf_sql_integer" type="in" value="#arguments.todos#">
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Vales cancelados com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Realiza a entrega dos vales ao motorista
	-- 01/03/2006
	--->
	<cffunction name="entrega_vales" access="remote" returntype="struct" output="true">
		<cfargument name="cod_funcionario"	required="yes">
		<cfargument name="num_inicial" 		required="yes">
		<cfargument name="num_final" 		required="yes">
		<cftry>
			<cftransaction action="begin">
				<!--- Varivel que receber o saldo de vales em poder do motorista --->
				<cfset retorno.saldo = 0>
				<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_controla_vale.prc_entrega_vales" username="#session.usuario#" password="#session.senha#">		
					<cfprocparam dbvarname="p_cod_funcionario" cfsqltype="cf_sql_integer" type="in" value="#arguments.cod_funcionario#">
					<cfprocparam dbvarname="p_num_inicial" cfsqltype="cf_sql_integer" type="in" value="#arguments.num_inicial#">
					<cfprocparam dbvarname="p_num_final" cfsqltype="cf_sql_integer" type="in" value="#arguments.num_final#">
					<cfprocparam dbvarname="p_saldo" cfsqltype="cf_sql_float" type="out" variable="retorno.saldo">
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Vales entregues com sucesso! Motorista com saldo de R$ #retorno.saldo#")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Estorna vales entregues
	-- 01/03/2006
	--->
	<cffunction name="estorna_vales" access="remote" returntype="struct" output="true">
		<cfargument name="cod_pessoa" 	required="yes">
		<cfargument name="num_inicial" 	 	required="yes">
		<cfargument name="num_final" 		required="yes">
		<cftry>
			<cftransaction action="begin">
				<!--- Varivel que receber o saldo de vales em poder do motorista --->
				<cfset retorno.saldo = 0>
				<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_controla_vale.prc_estorna_vales" username="#session.usuario#" password="#session.senha#">		
					<cfprocparam dbvarname="p_cod_pessoa" cfsqltype="cf_sql_integer" type="in" value="#arguments.cod_pessoa#">
					<cfprocparam dbvarname="p_num_inicial" cfsqltype="cf_sql_integer" type="in" value="#arguments.num_inicial#">
					<cfprocparam dbvarname="p_num_final" cfsqltype="cf_sql_integer" type="in" value="#arguments.num_final#">
					<cfprocparam dbvarname="p_saldo" cfsqltype="cf_sql_float" type="out" variable="retorno.saldo">
				</cfstoredproc>
				<cfset retorno.erro = false>		
				<cfset retorno.mensagem = 'Vales estornados com sucesso. Motorista com saldo de R$ '&#retorno.saldo#>		
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Insere um log de Troca de vale
	-- 16/01/2006 - criado
	--->
	<cffunction name="set_log_troca" access="remote" output="false">
		<cfargument name="num_vale" required="yes">	
        <cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_controla_vale.PRC_INS_LOG_VALES" username="#session.usuario#" password="#session.senha#">		
            <cfprocparam dbvarname="p_num_vale" cfsqltype="cf_sql_integer" type="in" value="#arguments.num_vale#">
            <cfprocparam dbvarname="p_cod_pessoa_troca" cfsqltype="cf_sql_integer" type="in" value="#session.cod_pessoa_usuario#">
        </cfstoredproc>
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Troca de Vales
	-- 01/03/2006 - criado
	--->
	<cffunction name="set_gestao" access="remote" returntype="struct" output="true">
		<cfargument name="limite_vales_motorista" displayname="Valor limite para vales em poder do motorista." required="no">	
		<cfargument name="valor_vales_eixo" displayname="Valor em R$ por eixo." required="no">	
		<cfargument name="vale_pessoal" displayname="Flag para liberao ou no de vale pessoal." required="no">	
		<cfargument name="limite_vale_pessoal_mes" displayname="Limite para retirada de vale pessoal por ms" required="no">	
		<cfargument name="limite_primeiro_vale" displayname="Limite para o primeiro vale pessoal do motorista." required="no">	
		<cfargument name="num_vales_bloco" displayname="Numero de vales por bloco." required="no">	
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_global.prc_set_parametro"  username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_id" value="1">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_modulo" value="VALE">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_valor" value="#Arguments.limite_vales_motorista#">				
				</cfstoredproc>
				<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_global.prc_set_parametro"  username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_id" value="2">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_modulo" value="VALE">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_valor" value="#Arguments.valor_vales_eixo#">				
				</cfstoredproc>
				<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_global.prc_set_parametro"  username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_id" value="3">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_modulo" value="VALE">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_valor" value="#Arguments.vale_pessoal#">				
				</cfstoredproc>
				<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_global.prc_set_parametro"  username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_id" value="4">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_modulo" value="VALE">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_valor" value="#Arguments.limite_vale_pessoal_mes#">				
				</cfstoredproc>
				<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_global.prc_set_parametro"  username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_id" value="5">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_modulo" value="VALE">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_valor" value="#Arguments.limite_primeiro_vale#">				
				</cfstoredproc>
				<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_global.prc_set_parametro"  username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_id" value="6">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_modulo" value="VALE">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_valor" value="#Arguments.num_vales_bloco#">				
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Parametros alterados com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>	
		
	<!--- 
	-- PROPSITO
	-- Troca de Vales
	-- 16/01/2006 - criado
	--->
	<cffunction name="troca_vales" displayname="Troca de vales" access="remote" returntype="struct" output="true">
		<cfargument name="cod_pessoa_funcionario" 	required="yes">
		<cfargument name="num_vale" 				required="yes">
		<cfargument name="cod_local_troca" 			required="yes">
		<cfargument name="tipo" 					required="yes">
		<cfargument name="administrativo" 			required="yes" default="0">
		<cfargument name="cod_setor" 				required="no" default="">
		<cfargument name="obs_troca" 				required="no" default="">
		<cfif not Len(trim(arguments.cod_setor))>
			<cfset arguments.cod_setor = -1>
		</cfif>		
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_controla_vale.prc_libera_troca_vale" username="#session.usuario#" password="#session.senha#">		
					<cfprocparam dbvarname="p_num_vale" cfsqltype="cf_sql_integer" type="in" value="#arguments.num_vale#">
					<cfprocparam dbvarname="p_cod_pessoa" cfsqltype="cf_sql_integer" type="in" value="#arguments.cod_pessoa_funcionario#">
					<cfprocparam dbvarname="p_cod_pessoa_troca" cfsqltype="cf_sql_integer" type="in" value="#arguments.cod_local_troca#">
					<cfprocparam dbvarname="p_tipo_vale" cfsqltype="cf_sql_integer" type="in" value="#arguments.tipo#">
					<cfprocparam dbvarname="p_vale_administrativo" cfsqltype="cf_sql_integer" type="in" value="#arguments.administrativo#">
					<cfprocparam dbvarname="p_cod_setor" cfsqltype="cf_sql_integer" type="in" value="#arguments.cod_setor#">
					<cfprocparam dbvarname="p_obs_troca" cfsqltype="cf_sql_varchar" type="in" value="#arguments.obs_troca#">
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Vale trocado com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Altera a situao atual do vale
	-- 01/03/2006 - criado
	--->	
	<cffunction name="upd_situacao_vale" access="remote" returntype="struct" output="true">
		<cfargument name="num_vale" required="yes">
		<cfargument name="situacao" required="yes">
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_controla_vale.prc_alt_situacao_vale" username="#session.usuario#" password="#session.senha#">		
					<cfprocparam dbvarname="p_num_vale" cfsqltype="cf_sql_integer" type="in" value="#arguments.num_vale#">
					<cfprocparam dbvarname="p_situacao" cfsqltype="cf_sql_integer" type="in" value="#arguments.situacao#">
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Situao alterada com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Vincular Lanamento de Caixa a um Vale
	-- RAFAEL 28/09/2009 17:15:23 - CRIADO
	--->
	<cffunction name='vincula_vale_lacto' displayname='Vincular Lanamento de Caixa a um Vale' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_VALE' required='yes'>
		<cfargument name='LANCTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_controla_vale.prc_vinc_vale_lacto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_VALE'  value='#arguments.NUM_VALE#'  null='#iif(len(trim(arguments.NUM_VALE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LANCTO_ID'  value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Lanamento Vinculado com Sucesso')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
</cfcomponent>