<!-- KM&M Componentes -->
<cfcomponent displayname="Manipulao da rea de usuarios" extends="_transportes.funcoes.cfc_init">
<!--- 
-- PROPSITO 
-- Ativa/Inativa um usuario
-- CRISTOFER  03/01/2006
--->
<cffunction name="situacao_usuario" displayname="Ativa/Inativa um usuario" access="remote" returntype="struct" output="true">
	<cfargument name="USUARIO" 	required="yes">
	<cfargument name="ATIVO" 	required="no" default="0">
	<cftry>
		<cftransaction action="begin">
		<cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				update kss.kss_usuarios
				  set ativo = #Arguments.ativo#
				 where usuario = '#Arguments.usuario#'	
		</cfquery>
		<cfset retorno.mensagem = 'Usuario #iif(arguments.ativo eq 1 , de('desbloqueado'), de('bloqueado'))# com sucesso.'>
		<cfset retorno.erro = false>		
		</cftransaction>
	<cfcatch>
		<cfset retorno.erro = true>
		<cfset retorno.mensagem = cfcatch>
		<cftransaction action="rollback" />
		<cfset request.erro = cfcatch>
	</cfcatch>
	</cftry>	
	<cfreturn retorno>
</cffunction>

	<!--- 
    -- PROPSITO 
    -- Lota o usurio em um organograma.
    -- CRISTOFER  03/01/2006
    --->
    <cffunction name="lotar_usuario" displayname="Lota o usurio em um organograma." access="remote" returntype="struct" output="true">
        <cfargument name="cod_pessoa_lotacao" 	required="yes">
        <cfargument name="cod_pessoa" 			required="yes">
        <cfargument name="cod_departamento" 	required="yes">
        <cfargument name="cod_setor" 			required="yes">
        <cfargument name="cod_centro_custo" 	required="yes">
        <cfargument name="usuario" 				required="yes">
        <cftry>
            <cftransaction action="begin">
            <cfstoredproc datasource="#session.dsn#" procedure="kss.pkg_lotacao.prc_lotar_usuario" username="#session.usuario#" password="#session.senha#">
                <cfprocparam type="in" cfsqltype="cf_sql_numeric" dbvarname="p_cod_pessoa_lotacao" value="#Arguments.cod_pessoa_lotacao#">
                <cfprocparam type="in" cfsqltype="cf_sql_numeric" dbvarname="p_cod_pessoa" value="#Arguments.cod_pessoa#">
                <cfprocparam type="in" cfsqltype="cf_sql_numeric" dbvarname="p_cod_departamento" value="#Arguments.cod_departamento#">
                <cfprocparam type="in" cfsqltype="cf_sql_numeric" dbvarname="p_cod_setor" value="#Arguments.cod_setor#">
                <cfprocparam type="in" cfsqltype="cf_sql_numeric" dbvarname="p_cod_centro_custo" value="#Arguments.cod_centro_custo#">
                <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_usuario" value="#Arguments.usuario#">
            </cfstoredproc>	
            
            <cfif UCase(session.usuario) eq UCase(usuario)>
                <cfquery name="qrLotacao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                    select p.cliente,
                           l.cod_pessoa, o.cod_departamento, o.cod_setor, o.cod_centro_custo,
                           u.usuario, nome, u.cod_pessoa as cod_pessoa_usuario,
                           s.descricao as setor, o.cod_organograma
                      from kss.kss_usuarios u
                      left join kss.v$usuario_lotacao ul
                              on u.usuario = ul.usuario
                      left join kss.v$lotacao l
                              on l.cod_lotacao = ul.cod_lotacao
                      left join kss.v$pessoa p
                             on l.cod_pessoa = p.cod_pessoa
                      left join kss.v$setor s
                             on s.cod_setor = l.cod_setor
                      left join kss.v$organograma o
                             on o.cod_pessoa = l.cod_pessoa
                            and o.cod_departamento = l.cod_departamento
                            and o.cod_setor = l.cod_setor
                            and o.cod_centro_custo = l.cod_centro_custo
                     where u.usuario = user
                </cfquery>	
                <!---Grava a lotao do usuario no session--->
                <cfif qrLotacao.recordcount gt 0>
                    <cfloop index="i" list="#qrLotacao.ColumnList#">
                        <cfset session[i] = qrLotacao[i][1]>
                    </cfloop>
                </cfif>
            </cfif>
            
            <cfset retorno.mensagem = 'Usurio lotado com sucesso.'>		
            <cfset retorno.erro = false>		
            </cftransaction>
        <cfcatch>
            <cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
            <cftransaction action="rollback" />
            <cfset request.erro = cfcatch>
        </cfcatch>
        </cftry>	
        <cfreturn retorno>
    </cffunction>
</cfcomponent>