<cfcomponent displayname="Controle e manipulao de veculos" extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPSITO
    -- Insere um municipio
    -- cristofer 09/06/2009 19:25:51 - CRIADO
    --->
    <cffunction name='ins_municipio' displayname='Insere um municipio' access='remote' returntype='Struct' output='true'>
        <cfargument name='MUNICIPIO' required='yes'>
        <cfargument name='LATITUDE' required='yes'>
        <cfargument name='LONGITUDE' required='yes'>
        <cfargument name='PAIS_ID' required='yes'>
        <cfargument name='UF_ID' required='yes'>
        <cfargument name='ALTITUDE' required='yes'>
        <cfargument name='CEP' required='yes'>
        <cfargument name='INTC_COD_MUNICIPIO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='cep.pkg_municipio.prc_ins_municipio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_MUNICIPIO_ID' variable='retorno.MUNICIPIO_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MUNICIPIO'  value='#arguments.MUNICIPIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_LATITUDE'  value='#arguments.LATITUDE#'  null='#iif(len(trim(arguments.LATITUDE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_LONGITUDE'  value='#arguments.LONGITUDE#'  null='#iif(len(trim(arguments.LONGITUDE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PAIS_ID'  value='#arguments.PAIS_ID#'  null='#iif(len(trim(arguments.PAIS_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_UF_ID'  value='#arguments.UF_ID#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ALTITUDE'  value='#arguments.ALTITUDE#'  null='#iif(len(trim(arguments.ALTITUDE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CEP'  value='#arguments.CEP#'  null='#iif(len(trim(arguments.CEP)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_INTC_COD_MUNICIPIO'  value='#arguments.INTC_COD_MUNICIPIO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Municipio inserido com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Altera um municipio
    -- cristofer 09/06/2009 19:26:50 - CRIADO
    --->
    <cffunction name='upd_municipio' displayname='Altera um municipio' access='remote' returntype='Struct' output='true'>
        <cfargument name='MUNICIPIO_ID' required='yes'>
        <cfargument name='MUNICIPIO' required='yes'>
        <cfargument name='LATITUDE' required='yes'>
        <cfargument name='LONGITUDE' required='yes'>
        <cfargument name='PAIS_ID' required='yes'>
        <cfargument name='UF_ID' required='yes'>
        <cfargument name='ALTITUDE' required='yes'>
        <cfargument name='CEP' required='yes'>
        <cfargument name='INTC_COD_MUNICIPIO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='cep.pkg_municipio.prc_alt_municipio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_MUNICIPIO_ID'  value='#arguments.MUNICIPIO_ID#'  null='#iif(len(trim(arguments.MUNICIPIO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MUNICIPIO'  value='#arguments.MUNICIPIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='10' dbvarname='P_LATITUDE'  value='#arguments.LATITUDE#'  null='#iif(len(trim(arguments.LATITUDE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='10' dbvarname='P_LONGITUDE'  value='#arguments.LONGITUDE#'  null='#iif(len(trim(arguments.LONGITUDE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PAIS_ID'  value='#arguments.PAIS_ID#'  null='#iif(len(trim(arguments.PAIS_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_UF_ID'  value='#arguments.UF_ID#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_ALTITUDE'  value='#arguments.ALTITUDE#'  null='#iif(len(trim(arguments.ALTITUDE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CEP'  value='#arguments.CEP#'  null='#iif(len(trim(arguments.CEP)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_INTC_COD_MUNICIPIO'  value='#arguments.INTC_COD_MUNICIPIO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Municipio alterado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Exclui um municipio
    -- cristofer 09/06/2009 19:27:22 - CRIADO
    --->
    <cffunction name='del_municipio' displayname='Exclui um municipio' access='remote' returntype='Struct' output='true'>
        <cfargument name='MUNICIPIO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='cep.pkg_municipio.prc_del_municipio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_MUNICIPIO_ID'  value='#arguments.MUNICIPIO_ID#'  null='#iif(len(trim(arguments.MUNICIPIO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Municipio excluido com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfif find("FKC",retorno.mensagem.detail)>
                    <cftry>
                    	<cfthrow message="No  possvel excluir, pois o municipio est vinculado a outros registros." detail="No  possvel excluir, pois o municipio est vinculado a outros registros.">
                    <cfcatch>
                    	<cfset retorno.mensagem = cfcatch>
                    </cfcatch>
                    </cftry>
                </cfif>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!--- 
	-- PROPSITO
	-- Insere nova cidade
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 01/12/2005 - criado
	--->
	<cffunction name="ins_cidade" displayname="Insere nova cidade" access="remote" returntype="struct" output="true">
		<cfargument name="municipio" required="yes">
		<cfargument name="pais_id" required="yes">
		<cfargument name="uf_id" required="yes">
		<cfargument name="cep" required="no">
		<cfargument name="intc_cod_municipio" required="no">
	    <cftry>
			<cfquery datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
				insert into cep.municipio
				  (municipio_id, municipio, pais_id, uf_id, cep, intc_cod_municipio, latitude, longitude)
				values
				  (-1, '#arguments.municipio#', #arguments.pais_id#, '#arguments.uf_id#', '#arguments.cep#', '#arguments.intc_cod_municipio#', #arguments.latitude#, #arguments.longitude#)
			</cfquery>

			<cfset retorno.mensagem = 'Cidade inserida com sucesso.'>				
			<cfset retorno.erro = false>						
 	  <cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
	   </cfcatch>
	   </cftry>
	   <cfreturn retorno>	   
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Altera dados da Cidade
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 02/12/2005 - criado
	--->
	<cffunction name="upd_cidade" displayname="Altera dados da Cidade" access="remote" returntype="struct" output="true">
		<cfargument name="municipio_id" required="yes">
		<cfargument name="municipio" required="yes">
		<cfargument name="pais_id" required="yes">
		<cfargument name="uf_id" required="yes">
		<cfargument name="cep" required="no">
		<cfargument name="intc_cod_municipio" required="no">
	    <cftry>
			<cfquery datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
				update cep.municipio
				   set municipio          = '#arguments.municipio#',
					   pais_id            = #arguments.pais_id#,
					   uf_id              = '#arguments.uf_id#',
					   cep                = '#arguments.cep#',
					   intc_cod_municipio = '#arguments.intc_cod_municipio#'
				 where municipio_id = #arguments.municipio_id#
			</cfquery>

			<cfset retorno.mensagem = 'Cidade alterada com sucesso.'>				
			<cfset retorno.erro = false>						
 	  <cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
	   </cfcatch>
	   </cftry>
	   <cfreturn retorno>	   
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui cidade
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 01/12/2005 - criado
	--->
	<cffunction name="del_cidade" displayname="Exclui cidade" access="remote" returntype="struct" output="true">
		<cfargument name="municipio_id" required="yes">
	    <cftry>
			<cfquery datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
				delete cep.municipio
				 where municipio_id = #arguments.municipio_id#
			</cfquery>

			<cfset retorno.mensagem = 'Cidade excluda com sucesso.'>				
			<cfset retorno.erro = false>						
 	  <cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
	   </cfcatch>
	   </cftry>
	   <cfreturn retorno>	   
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Insere novo banco internacional
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 01/12/2005 - criado
	--->
	<cffunction name="ins_intc_banco" displayname="Insere novo banco internacional" access="remote" returntype="struct" output="true">
		<cfargument name="descricao" required="yes">
	    <cftry>
			<cfquery datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
				insert into kss.atributo_item
				  (atributo_id, valor)
				values
				  (101, '#arguments.descricao#')
  			</cfquery>

			<cfset retorno.mensagem = 'Banco inserido com sucesso.'>				
			<cfset retorno.erro = false>						
 	  <cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
	   </cfcatch>
	   </cftry>
	   <cfreturn retorno>	   
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Altera dados do banco
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 02/12/2005 - criado
	--->
	<cffunction name="upd_intc_banco" displayname="Altera dados do banco" access="remote" returntype="struct" output="true">
		<cfargument name="item_id" required="yes">
		<cfargument name="descricao" required="yes">
	    <cftry>
			<cfquery datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
				update kss.atributo_item
				   set valor = '#arguments.descricao#'
				 where atributo_id = 101 
				   and item_id = #arguments.ITEM_ID#
 			</cfquery>

			<cfset retorno.mensagem = 'Banco alterado com sucesso.'>				
			<cfset retorno.erro = false>						
 	  <cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
	   </cfcatch>
	   </cftry>
	   <cfreturn retorno>	   
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui banco internacional
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 25/02/2006 - criado
	--->
	<cffunction name="del_intc_banco" displayname="Exclui banco internacional" access="remote" returntype="struct" output="true">
		<cfargument name="ITEM_ID" required="yes">
	    <cftry>
			<cfquery datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
				delete kss.atributo_item
				 where atributo_id = 101
				   and item_id = #arguments.ITEM_ID#
			</cfquery>

			<cfset retorno.mensagem = 'Banco excludo com sucesso.'>				
			<cfset retorno.erro = false>						
 	  <cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
	   </cfcatch>
	   </cftry>
	   <cfreturn retorno>	   
	</cffunction>		
	
	<!--- 
	-- PROPSITO
	-- Insere nova condio de venda
	-- FABIOG 30/09/2011 15:15:30 - CRIADO
	--->
	<cffunction name='ins_condicao_venda' displayname='Insere nova condio de venda' access='remote' returntype='Struct' output='true'>
		<cfargument name='INCOTERM_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_ins_condicao_venda' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_INCOTERM_ID'  value='#arguments.INCOTERM_ID#'  null='#iif(len(trim(arguments.INCOTERM_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Condio de venda inserida com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Insere nova condio de venda
	-- FABIOG 30/09/2011 15:16:19 - CRIADO
	--->
	<cffunction name='upd_condicao_venda' displayname='Insere nova condio de venda' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONDICAO_VENDA_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_upd_condicao_venda' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONDICAO_VENDA_ID'  value='#arguments.CONDICAO_VENDA_ID#'  null='#iif(len(trim(arguments.CONDICAO_VENDA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Condio de venda inserida com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui codio de venda
	-- FABIOG 30/09/2011 15:17:25 - CRIADO
	--->
	<cffunction name='del_condicao_venda' displayname='Exclui codio de venda' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONDICAO_VENDA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_del_condicao_venda' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONDICAO_VENDA_ID'  value='#arguments.CONDICAO_VENDA_ID#'  null='#iif(len(trim(arguments.CONDICAO_VENDA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Condio de venda excluda com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere nova fronteira
	-- FABIOG 30/09/2011 15:18:24 - CRIADO
	--->
	<cffunction name='ins_fronteira' displayname='Insere nova fronteira' access='remote' returntype='Struct' output='true'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='MUNICIPIO_ID_1' required='yes'>
		<cfargument name='MUNICIPIO_ID_2' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_ins_fronteira' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MUNICIPIO_ID_1'  value='#arguments.MUNICIPIO_ID_1#'  null='#iif(len(trim(arguments.MUNICIPIO_ID_1)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MUNICIPIO_ID_2'  value='#arguments.MUNICIPIO_ID_2#'  null='#iif(len(trim(arguments.MUNICIPIO_ID_2)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Fronteira inserida com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Altera dados da fronteira
	-- FABIOG 30/09/2011 15:19:13 - CRIADO
	--->
	<cffunction name='upd_fronteira' displayname='Altera dados da fronteira' access='remote' returntype='Struct' output='true'>
		<cfargument name='FRONTEIRA_ID' required='yes'>
		<cfargument name='MUNICIPIO_ID_1' required='yes'>
		<cfargument name='MUNICIPIO_ID_2' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_upd_fronteira' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FRONTEIRA_ID'  value='#arguments.FRONTEIRA_ID#'  null='#iif(len(trim(arguments.FRONTEIRA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MUNICIPIO_ID_1'  value='#arguments.MUNICIPIO_ID_1#'  null='#iif(len(trim(arguments.MUNICIPIO_ID_1)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MUNICIPIO_ID_2'  value='#arguments.MUNICIPIO_ID_2#'  null='#iif(len(trim(arguments.MUNICIPIO_ID_2)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Fronteira alterada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui fronteira
	-- FABIOG 30/09/2011 15:20:03 - CRIADO
	--->
	<cffunction name='del_fronteira' displayname='Exclui fronteira' access='remote' returntype='Struct' output='true'>
		<cfargument name='FRONTEIRA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_del_fronteira' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FRONTEIRA_ID'  value='#arguments.FRONTEIRA_ID#'  null='#iif(len(trim(arguments.FRONTEIRA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Fronteira excluda com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>			

	<!--- 
	-- PROPSITO
	-- Insere nova alfandega
	-- FABIOG 30/09/2011 15:26:55 - CRIADO
	--->
	<cffunction name='ins_alfandega' displayname='Insere nova alfandega' access='remote' returntype='Struct' output='true'>
		<cfargument name='CODIGO' required='yes'>
		<cfargument name='NOME' required='yes'>
		<cfargument name='MUNICIPIO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_ins_alfandega' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CODIGO'  value='#arguments.CODIGO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MUNICIPIO_ID'  value='#arguments.MUNICIPIO_ID#'  null='#iif(len(trim(arguments.MUNICIPIO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Alfndega inserida com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Altera dados da alfndega
	-- FABIOG 30/09/2011 15:27:44 - CRIADO
	--->
	<cffunction name='upd_alfandega' displayname='Altera dados da alfndega' access='remote' returntype='Struct' output='true'>
		<cfargument name='ALFANDEGA_ID' required='yes'>
		<cfargument name='NOME' required='yes'>
		<cfargument name='CODIGO' required='yes'>
		<cfargument name='MUNICIPIO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_upd_alfandega' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ALFANDEGA_ID'  value='#arguments.ALFANDEGA_ID#'  null='#iif(len(trim(arguments.ALFANDEGA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CODIGO'  value='#arguments.CODIGO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MUNICIPIO_ID'  value='#arguments.MUNICIPIO_ID#'  null='#iif(len(trim(arguments.MUNICIPIO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Alfndega alterada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui alfndega
	-- FABIOG 30/09/2011 15:29:29 - CRIADO
	--->
	<cffunction name='del_alfandega' displayname='Exclui alfndega' access='remote' returntype='Struct' output='true'>
		<cfargument name='ALFANDEGA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_del_alfandega' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ALFANDEGA_ID'  value='#arguments.ALFANDEGA_ID#'  null='#iif(len(trim(arguments.ALFANDEGA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Alfndega excluda com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere nova embalagem
	-- FABIOG 30/09/2011 10:40:31 - CRIADO
	--->
	<cffunction name='ins_embalagem' displayname='Insere nova embalagem' access='remote' returntype='Struct' output='true'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='ABREVIATURA' required='yes'>
		<cfargument name='CODIGO_INTC' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_cadastros.prc_ins_embalagem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ABREVIATURA'  value='#arguments.ABREVIATURA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CODIGO_INTC'  value='#arguments.CODIGO_INTC#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Embalagem inserida com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Altera dados da embalagem
	-- FABIOG 30/09/2011 10:41:47 - CRIADO
	--->
	<cffunction name='upd_embalagem' displayname='Altera dados da embalagem' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_ESPECIE' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='ABREVIATURA' required='yes'>
		<cfargument name='CODIGO_INTC' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_cadastros.prc_upd_embalagem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ESPECIE'  value='#arguments.NUM_ESPECIE#'  null='#iif(len(trim(arguments.NUM_ESPECIE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ABREVIATURA'  value='#arguments.ABREVIATURA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CODIGO_INTC'  value='#arguments.CODIGO_INTC#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Embalagem alterada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui embalagem
	-- FABIOG 30/09/2011 10:42:44 - CRIADO
	--->
	<cffunction name='del_embalagem' displayname='Exclui embalagem' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_ESPECIE' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_cadastros.prc_del_embalagem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ESPECIE'  value='#arguments.NUM_ESPECIE#'  null='#iif(len(trim(arguments.NUM_ESPECIE)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Embalagem excluda com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Insere novo produto
	-- FABIOG 30/09/2011 11:16:28 - CRIADO
	--->
	<cffunction name='ins_produto' displayname='Insere novo produto' access='remote' returntype='Struct' output='true'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='COD_NCM' required='yes'>
		<cfargument name='CATEGORIA_ID' required='yes'>
		<cfif not Len(Trim(arguments.cod_ncm))>
			<cfset arguments.cod_ncm = '0000.00.00'>
		</cfif>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_cadastros.prc_ins_produto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_NCM'  value='#arguments.COD_NCM#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CATEGORIA_ID'  value='#arguments.CATEGORIA_ID#'  null='#iif(len(trim(arguments.CATEGORIA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Produto inserido com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Altera dados do produto
	-- FABIOG 30/09/2011 11:17:47 - CRIADO
	--->
	<cffunction name='upd_produto' displayname='Altera dados do produto' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_NATUREZA' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='COD_NCM' required='yes'>
		<cfargument name='CATEGORIA_ID' required='yes'>
		<cfif not Len(Trim(arguments.cod_ncm))>
			<cfset arguments.cod_ncm = '0000.00.00'>
		</cfif>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_cadastros.prc_upd_produto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NATUREZA'  value='#arguments.NUM_NATUREZA#'  null='#iif(len(trim(arguments.NUM_NATUREZA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_NCM'  value='#arguments.COD_NCM#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CATEGORIA_ID'  value='#arguments.CATEGORIA_ID#'  null='#iif(len(trim(arguments.CATEGORIA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Produto alterado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui produto
	-- FABIOG 30/09/2011 11:18:58 - CRIADO
	--->
	<cffunction name='del_produto' displayname='Exclui produto' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_NATUREZA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_cadastros.prc_del_produto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NATUREZA'  value='#arguments.NUM_NATUREZA#'  null='#iif(len(trim(arguments.NUM_NATUREZA)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Produto excludo com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

<cffunction name="ins_intc_conhecimento" displayname="Insere um tipo de objeto" access="remote" returntype="Struct" output="true">
	<cfargument name="numero" required="no" default="">
	<cfargument name="cod_pessoa_filial" required="no" default="#session.cod_pessoa#" >
	<cfargument name="cod_organograma" required="yes">
	<cfargument name="emissao_local" required="no" default="">
	<cfargument name="emissao_municipio_id" required="yes" default="">
	<cfargument name="emissao_data" required="no" default="#DateFormat(now(), 'DD/MM/YYYY')#">
	<cfargument name="resp_local" required="yes">
	<cfargument name="resp_municipio_id" required="yes">
	<cfargument name="resp_data" required="yes">
	<cfargument name="entrega_local" required="yes">
	<cfargument name="entrega_municipio_id" required="yes">
	<cfargument name="entrega_data" required="yes">
	<cfargument name="transp_sucessivos" required="no" default="N.I.H.I.L">
	<cfargument name="cod_remetente" required="yes">
	<cfargument name="rem_endereco" required="yes">
	<cfargument name="rem_municipio" required="yes">
	<cfargument name="rem_uf" required="yes">
	<cfargument name="rem_pais" required="yes">
	<cfargument name="rem_cnpj_cpf" required="yes">
	<cfargument name="cod_destinatario" required="yes">
	<cfargument name="dest_nome" required="yes">
	<cfargument name="dest_endereco" required="yes">
	<cfargument name="dest_municipio" required="yes">
	<cfargument name="dest_uf" required="yes">
	<cfargument name="dest_pais" required="yes">
	<cfargument name="dest_cnpj_cpf" required="yes">
	<cfargument name="cod_consignatario" required="yes">
	<cfargument name="cons_nome" required="yes">
	<cfargument name="cons_endereco" required="yes">
	<cfargument name="cons_municipio" required="yes">
	<cfargument name="cons_uf" required="yes">
	<cfargument name="cons_pais" required="yes">
	<cfargument name="cons_cnpj_cpf" required="yes">
	<cfargument name="cod_notificar" required="yes">
	<cfargument name="not_nome" required="yes">
	<cfargument name="not_endereco" required="yes">
	<cfargument name="not_municipio" required="yes">
	<cfargument name="not_uf" required="yes">
	<cfargument name="not_pais" required="yes">
	<cfargument name="not_cnpj_cpf" required="yes">
	<cfargument name="mercadorias" required="no" default="">
	<cfargument name="num_especie" required="yes">
	<cfargument name="quantidade_total" required="yes">
	<cfargument name="peso_bruto" required="yes">
	<cfargument name="peso_liquido" required="yes">
	<cfargument name="unidade_id" required="yes">
	<cfargument name="m3" required="yes">
	<cfargument name="valor_total" required="yes">
	<cfargument name="valor_total_incoterm_id" required="yes">
	<cfargument name="valor_total_cod_moeda" required="yes">
	<cfargument name="total_custo_origem" required="yes">
	<cfargument name="total_custo_origem_cod_moeda" required="no" default="220">
	<cfargument name="total_custo_destino" required="yes">
	<cfargument name="total_custo_destino_cod_moeda" required="no" default="220">
	<cfargument name="valor_frt_externo" required="yes">
	<cfargument name="valor_frt_externo_cod_moeda" required="no" default="220">
	<cfargument name="valor_reembolso" required="yes">
	<cfargument name="valor_reembolso_cod_moeda" required="no" default="220">
	<cfargument name="valor_mercadorias" required="yes">
	<cfargument name="valor_mercadorias_incoterm" required="yes">
	<cfargument name="valor_mercadorias_cod_moeda" required="no" default="220">
	<cfargument name="alfandega_origem_id" required="yes">
	<cfargument name="alfandega_destino_id" required="yes">
	<cfargument name="pais_id_origem" required="yes">
	
	<cfargument name="pago_por" required="no" default="1">
	<cfargument name="declaracao_observacao" required="yes">
	<cfargument name="obs_pago_por" required="no">
	<cfargument name="adicionais_mercadoria" required="yes" >
	<cfargument name="seguro_pago_empresa" required="no" default="0" >
	<cfargument name="qtde_veiculos" required="no" default="1" >
	
	<cfargument name="emissao_data_impressao" required="no" default="" >
	<cfargument name="taxa_mercadoria_seguro" required="no" default="0" >

	<cfargument name='cod_pagador_origem' required='yes'>
	<cfargument name='pag_origem_nome' required='yes'>
	<cfargument name='pag_origem_endereco' required='yes'>
	<cfargument name='pag_origem_cidade' required='yes'>
	<cfargument name='pag_origem_uf' required='yes'>
	<cfargument name='pag_origem_pais' required='yes'>
	<cfargument name='pag_origem_cnpj_cpf' required='yes'>
	<cfargument name='cod_pagador_destino' required='yes'>
	<cfargument name='pag_destino_nome' required='yes'>
	<cfargument name='pag_destino_endereco' required='yes'>
	<cfargument name='pag_destino_cidade' required='yes'>
	<cfargument name='pag_destino_uf' required='yes'>
	<cfargument name='pag_destino_pais' required='yes'>
	<cfargument name='pag_destino_cnpj_cpf' required='yes'>    
	<cfargument name='pre_conhecimento' required='yes' default="0">
    <cfargument name='data_embarque_manual' required='no' default="">
    <cftry>
		<cfscript>
			v_descricao = this.ListaToArray (lista = arguments, variavel = "MERC_DESCRICAO_MERCADORIAS");
			v_mercadorias = "";
		</cfscript>
		<cfloop from="1" to="#ArrayLen(v_descricao)#" index="v_index">
			<cfset v_mercadorias = v_mercadorias&v_descricao[v_index]&chr(10)>			
		</cfloop>
			<cfset v_mercadorias = v_mercadorias&arguments.adicionais_mercadoria>			
		<cftransaction action="begin"> 
			<cfstoredproc procedure="fiscal.pkg_transp_internacional.prc_ins_conhecimento" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				<cfprocparam dbvarname="P_NUMERO_COD_PAIS" 				type="in"  cfsqltype="cf_sql_varchar" value="#UCase(listGetAt(arguments.numero, 1, '.'))#">
				<cfprocparam dbvarname="P_NUMERO_CERTIFICADO" 			type="in"  cfsqltype="cf_sql_varchar" value="#listGetAt(arguments.numero, 2, '.')#">
				<cfprocparam dbvarname="P_NUMERO_SEQUENCIAL" 			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#listGetAt(arguments.numero, 3, '.')#" null="#iif(len(trim(arguments.numero)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_COD_PESSOA_FILIAL" 			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.cod_pessoa_filial#" null="#iif(len(trim(arguments.cod_pessoa_filial)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_COD_ORGANOGRAMA" 			   type="in"  cfsqltype="cf_sql_varchar" value="#arguments.COD_ORGANOGRAMA#" null="#iif(len(trim(arguments.COD_ORGANOGRAMA)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_EMISSAO_LOCAL" 				type="in"  cfsqltype="cf_sql_varchar" value="#arguments.emissao_local#">
				<cfprocparam dbvarname="P_EMISSAO_MUNICIPIO_ID" 		type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.emissao_municipio_id#" null="#iif(len(trim(arguments.emissao_municipio_id)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_EMISSAO_DATA" 				type="in"  cfsqltype="cf_sql_varchar" value="#arguments.emissao_data#">
				<cfprocparam dbvarname="P_RESP_LOCAL" 					type="in"  cfsqltype="cf_sql_varchar" value="#arguments.resp_local#">
				<cfprocparam dbvarname="P_RESP_MUNICIPIO_ID" 			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.resp_municipio_id#" null="#iif(len(trim(arguments.resp_municipio_id)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_RESP_DATA" 					type="in"  cfsqltype="cf_sql_varchar" value="#arguments.resp_data#">
				<cfprocparam dbvarname="P_ENTREGA_LOCAL" 				type="in"  cfsqltype="cf_sql_varchar" value="#arguments.entrega_local#">
				<cfprocparam dbvarname="P_ENTREGA_MUNICIPIO_ID" 		type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.entrega_municipio_id#" null="#iif(len(trim(arguments.entrega_municipio_id)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_ENTREGA_DATA" 				type="in"  cfsqltype="cf_sql_varchar" value="#arguments.entrega_data#">
				<cfprocparam dbvarname="P_TRANSP_SUCESSIVOS"			type="in"  cfsqltype="cf_sql_varchar" value="#arguments.transp_sucessivos#">
				<cfprocparam dbvarname="P_COD_REMETENTE" 				type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.cod_remetente#">
				<cfprocparam dbvarname="P_REM_NOME" 					type="in"  cfsqltype="cf_sql_varchar" value="#arguments.rem_nome#">
				<cfprocparam dbvarname="P_REM_ENDERECO" 				type="in"  cfsqltype="cf_sql_varchar" value="#arguments.rem_endereco#">
				<cfprocparam dbvarname="P_REM_MUNICIPIO_ID"				type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.rem_municipio_id#" null="#iif(len(trim(arguments.rem_municipio_id)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_REM_CIDADE" 					type="in"  cfsqltype="cf_sql_varchar" value="#arguments.rem_municipio#">

				<cfprocparam dbvarname="P_REM_UF" 						type="in"  cfsqltype="cf_sql_varchar" value="#arguments.rem_uf#">
				<cfprocparam dbvarname="P_REM_PAIS" 					type="in"  cfsqltype="cf_sql_varchar" value="#arguments.rem_pais#">
				<cfprocparam dbvarname="P_REM_CNPJ_CPF" 				type="in"  cfsqltype="cf_sql_varchar" value="#arguments.rem_cnpj_cpf#">
				<cfprocparam dbvarname="P_COD_DESTINATARIO" 			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.cod_destinatario#">
				<cfprocparam dbvarname="P_DEST_NOME" 					type="in"  cfsqltype="cf_sql_varchar" value="#arguments.dest_nome#">
				<cfprocparam dbvarname="P_DEST_ENDERECO" 				type="in"  cfsqltype="cf_sql_varchar" value="#arguments.dest_endereco#">
				<cfprocparam dbvarname="P_DEST_MUNICIPIO_ID"			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.dest_municipio_id#" null="#iif(len(trim(arguments.dest_municipio_id)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_DEST_CIDADE" 					type="in"  cfsqltype="cf_sql_varchar" value="#arguments.dest_municipio#">

				<cfprocparam dbvarname="P_DEST_UF" 						type="in"  cfsqltype="cf_sql_varchar" value="#arguments.dest_uf#">
				<cfprocparam dbvarname="P_DEST_PAIS" 					type="in"  cfsqltype="cf_sql_varchar" value="#arguments.dest_pais#">
				<cfprocparam dbvarname="P_DEST_CNPJ_CPF" 				type="in"  cfsqltype="cf_sql_varchar" value="#arguments.dest_cnpj_cpf#">
				<cfprocparam dbvarname="P_COD_CONSIGNATARIO" 			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.cod_consignatario#">
				<cfprocparam dbvarname="P_CONS_NOME" 					type="in"  cfsqltype="cf_sql_varchar" value="#arguments.cons_nome#">
				<cfprocparam dbvarname="P_CONS_ENDERECO" 				type="in"  cfsqltype="cf_sql_varchar" value="#arguments.cons_endereco#">
				<cfprocparam dbvarname="P_CONS_MUNICIPIO_ID"			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.cons_municipio_id#" null="#iif(len(trim(arguments.cons_municipio_id)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_CONS_CIDADE" 					type="in"  cfsqltype="cf_sql_varchar" value="#arguments.cons_municipio#">

				<cfprocparam dbvarname="P_CONS_UF" 						type="in"  cfsqltype="cf_sql_varchar" value="#arguments.cons_uf#">
				<cfprocparam dbvarname="P_CONS_PAIS" 					type="in"  cfsqltype="cf_sql_varchar" value="#arguments.cons_pais#">
				<cfprocparam dbvarname="P_CONS_CNPJ_CPF" 				type="in"  cfsqltype="cf_sql_varchar" value="#arguments.cons_cnpj_cpf#">
				<cfprocparam dbvarname="P_COD_NOTIFICAR" 				type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.cod_notificar#" null="#iif(len(trim(arguments.cod_notificar)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_NOT_NOME" 					type="in"  cfsqltype="cf_sql_varchar" value="#arguments.not_nome#">
				<cfprocparam dbvarname="P_NOT_ENDERECO" 				type="in"  cfsqltype="cf_sql_varchar" value="#arguments.not_endereco#">
				<cfprocparam dbvarname="P_NOT_MUNICIPIO_ID"				type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.not_municipio_id#" null="#iif(len(trim(arguments.not_municipio_id)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_NOT_CIDADE" 					type="in"  cfsqltype="cf_sql_varchar" value="#arguments.not_municipio#">

				<cfprocparam dbvarname="P_NOT_UF" 						type="in"  cfsqltype="cf_sql_varchar" value="#arguments.not_uf#">
				<cfprocparam dbvarname="P_NOT_PAIS" 					type="in"  cfsqltype="cf_sql_varchar" value="#arguments.not_pais#">
				<cfprocparam dbvarname="P_NOT_CNPJ_CPF" 				type="in"  cfsqltype="cf_sql_varchar" value="#arguments.not_cnpj_cpf#">
				<cfprocparam dbvarname="P_MERCADORIAS" 					type="in"  cfsqltype="cf_sql_varchar" value="#v_mercadorias#">
				<cfprocparam dbvarname="P_NUM_ESPECIE" 					type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.num_especie#" null="#iif(len(trim(arguments.num_especie)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_QUANTIDADE_TOTAL" 			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.quantidade_total#" null="#iif(len(trim(arguments.quantidade_total)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_PESO_BRUTO" 					type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.peso_bruto#" null="#iif(len(trim(arguments.peso_bruto)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_PESO_LIQUIDO" 				type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.peso_liquido#" null="#iif(len(trim(arguments.peso_liquido)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_UNIDADE_ID" 					type="in"  cfsqltype="cf_sql_varchar" value="#arguments.unidade_id#">
				<cfprocparam dbvarname="P_M3" 							type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.m3#"  null="#iif(len(trim(arguments.m3)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_VALOR_TOTAL" 					type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#Replace(arguments.valor_total, ',', '.', 'all')#" null="#iif(len(trim(arguments.valor_total)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_VALOR_TOTAL_COD_MOEDA"		type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.valor_total_cod_moeda#">
				<cfprocparam dbvarname="P_VALOR_TOTAL_INCOTERM_ID"		type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.valor_total_incoterm_id#" null="#iif(len(trim(arguments.valor_total_incoterm_id)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_TOTAL_CUSTO_ORIGEM" 			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.total_custo_origem#" null="#iif(len(trim(arguments.total_custo_origem)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_TOTAL_CUSTO_ORIGEM_COD_MOEDA" type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.total_custo_origem_cod_moeda#" null="#iif(len(trim(arguments.total_custo_origem_cod_moeda)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_TOTAL_CUSTO_DESTINO" 			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.total_custo_destino#" null="#iif(len(trim(arguments.total_custo_destino)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_TOTAL_CUSTO_DESTINO_COD_MOED" type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.total_custo_destino_cod_moeda#" null="#iif(len(trim(arguments.total_custo_destino_cod_moeda)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_VALOR_FRT_EXTERNO" 			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#Replace(arguments.valor_frt_externo, ',', '.', 'all')#" null="#iif(len(trim(arguments.valor_frt_externo)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_VALOR_FRT_EXTERNO_COD_MOEDA"	type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.valor_frt_externo_cod_moeda#" null="#iif(len(trim(arguments.valor_frt_externo_cod_moeda)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_VALOR_REEMBOLSO" 				type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.valor_reembolso#"  null="#iif(len(trim(arguments.valor_reembolso)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_VALOR_REEMBOLSO_COD_MOEDA" 	type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.valor_reembolso_cod_moeda#" null="#iif(len(trim(arguments.valor_reembolso_cod_moeda)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_VALOR_MERCADORIAS" 			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#Replace(arguments.valor_mercadorias, ',', '.', 'all')#" null="#iif(len(trim(arguments.valor_mercadorias)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_VALOR_MERCADORIAS_COD_MOEDA" 	type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.valor_mercadorias_cod_moeda#" null="#iif(len(trim(arguments.valor_mercadorias_cod_moeda)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_VALOR_MERCADORIAS_INCOTERM" 	type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.valor_mercadorias_incoterm#" null="#iif(len(trim(arguments.valor_mercadorias_incoterm)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_ALFANDEGA_ORIGEM_ID" 			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.alfandega_origem_id#"  null="#iif(len(trim(arguments.alfandega_origem_id)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_ALFANDEGA_DESTINO_ID" 		type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.alfandega_destino_id#"  null="#iif(len(trim(arguments.alfandega_destino_id)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_PAIS_ID_ORIGEM" 				type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.pais_id_origem#"  null="#iif(len(trim(arguments.pais_id_origem)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_PAGO_POR" 					type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.pago_por#" null="#iif(len(trim(arguments.pago_por)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_DECLARACAO_OBSERVACAO" 		type="in"  cfsqltype="cf_sql_varchar" value="#arguments.declaracao_observacao#">
				<cfprocparam dbvarname="P_OBS_PAGO_POR" 				type="in"  cfsqltype="cf_sql_varchar"  value="#arguments.OBS_PAGO_POR#">
				<cfprocparam dbvarname="P_QTDE_VEICULOS"				type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.qtde_veiculos#" null="#iif(len(trim(arguments.qtde_veiculos)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_SEGURO_PAGO_EMPRESA"			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.seguro_pago_empresa#" null="#iif(len(trim(arguments.seguro_pago_empresa)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_CONHECIMENTO_ID" 				type="inout" cfsqltype="cf_sql_numeric" scale="5" null="yes" variable="retorno.conhecimento_id">
				<cfprocparam dbvarname="P_ROWID" 						type="out" cfsqltype="cf_sql_varchar" variable="retorno.rowid">			
				<cfprocparam dbvarname="P_EMISSAO_DATA_IMPRESSAO"		type="in"  cfsqltype="cf_sql_varchar" value="#arguments.emissao_data_impressao#">
				<cfprocparam dbvarname="P_TAXA_MERCADORIA_SEGURO"		type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.TAXA_MERCADORIA_SEGURO#" null="#iif(len(trim(arguments.TAXA_MERCADORIA_SEGURO)), de('no'), de('yes'))#">

				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_PAGADOR_ORIGEM'  value='#arguments.COD_PAGADOR_ORIGEM#'  null='#iif(len(trim(arguments.COD_PAGADOR_ORIGEM)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PAG_ORIGEM_NOME'  value='#arguments.PAG_ORIGEM_NOME#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PAG_ORIGEM_ENDERECO'  value='#arguments.PAG_ORIGEM_ENDERECO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PAG_ORIGEM_CIDADE'  value='#arguments.PAG_ORIGEM_CIDADE#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PAG_ORIGEM_UF'  value='#arguments.PAG_ORIGEM_UF#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PAG_ORIGEM_PAIS'  value='#arguments.PAG_ORIGEM_PAIS#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PAG_ORIGEM_CNPJ_CPF'  value='#arguments.PAG_ORIGEM_CNPJ_CPF#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_PAGADOR_DESTINO'  value='#arguments.COD_PAGADOR_DESTINO#'  null='#iif(len(trim(arguments.COD_PAGADOR_DESTINO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PAG_DESTINO_NOME'  value='#arguments.PAG_DESTINO_NOME#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PAG_DESTINO_ENDERECO'  value='#arguments.PAG_DESTINO_ENDERECO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PAG_DESTINO_CIDADE'  value='#arguments.PAG_DESTINO_CIDADE#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PAG_DESTINO_UF'  value='#arguments.PAG_DESTINO_UF#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PAG_DESTINO_PAIS'  value='#arguments.PAG_DESTINO_PAIS#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PAG_DESTINO_CNPJ_CPF'  value='#arguments.PAG_DESTINO_CNPJ_CPF#' >
				<cfprocparam dbvarname="P_PRE_CONHECIMENTO"		type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.PRE_CONHECIMENTO#" null="#iif(len(trim(arguments.PRE_CONHECIMENTO)), de('no'), de('yes'))#">
                <cfprocparam dbvarname="P_DATA_EMBARQUE_MANUAL"		type="in"  cfsqltype="cf_sql_varchar" value="#arguments.DATA_EMBARQUE_MANUAL#" null="#iif(len(trim(arguments.DATA_EMBARQUE_MANUAL)), de('no'), de('yes'))#">                
			 </cfstoredproc>
			
			<!--- Insercao de Mercadorias Transportadas --->
			<cfscript>
				v_produto_id = this.ListaToArray (lista = arguments, variavel = "MERC_PRODUTO_ID_MERCADORIAS");
				v_num_especie = this.ListaToArray (lista = arguments, variavel = "MERC_NUM_ESPECIE_MERCADORIAS");
				v_quantidade = this.ListaToArray (lista = arguments, variavel = "MERC_QUANTIDADE_MERCADORIAS");
				v_peso_bruto = this.ListaToArray (lista = arguments, variavel = "MERC_PESO_BRUTO_MERCADORIAS");
				v_peso_liquido = this.ListaToArray (lista = arguments, variavel = "MERC_PESO_LIQUIDO_MERCADORIAS");
				v_m3 = this.ListaToArray (lista = arguments, variavel = "MERC_VOLUME_MERCADORIAS");
				v_unidade_id = this.ListaToArray (lista = arguments, variavel = "MERC_UNIDADE_ID_MERCADORIAS");
				v_descricao = this.ListaToArray (lista = arguments, variavel = "MERC_DESCRICAO_MERCADORIAS");
			</cfscript>
			<cfloop from="1" to="#ArrayLen(v_descricao)#" index="count">
				<cfscript>
					this.ins_item_crt(	conhecimento_id = retorno.conhecimento_id,
					               		produto_id = v_produto_id[count],
								  		num_especie = v_num_especie[count],
								 		quantidade = v_quantidade[count],
								 		peso_bruto = v_peso_bruto[count],
										peso_liquido = v_peso_liquido[count],
										m3 = v_m3[count],
										descricao = v_descricao[count]);
				</cfscript>
			</cfloop>
			<!--- Insercao de Custos --->
			<cfscript>
				v_descricao = this.ListaToArray (lista = arguments, variavel = "CUST_DESCRICAO_CUSTOS");
				v_valor_origem = this.ListaToArray (lista = arguments, variavel = "CUST_VALOR_ORIGEM_CUSTOS");
				v_valor_origem_cod_moeda = this.ListaToArray (lista = arguments, variavel = "CUST_VALOR_ORIGEM_COD_MOEDA_CUSTOS");
				v_valor_destino = this.ListaToArray (lista = arguments, variavel = "CUST_VALOR_DESTINO_CUSTOS");
				v_valor_destino_cod_moeda = this.ListaToArray (lista = arguments, variavel = "CUST_VALOR_DESTINO_COD_MOEDA_CUSTOS");
			</cfscript>
			<cfloop from="1" to="#ArrayLen(v_descricao)#" index="count">
				<cfscript>
					this.ins_custo_crt(	conhecimento_id = retorno.conhecimento_id,
					               		descricao = v_descricao[count],
								  		valor_origem = v_valor_origem[count],
								 		valor_origem_cod_moeda = v_valor_origem_cod_moeda[count],
								 		valor_destino = v_valor_destino[count],
										valor_destino_cod_moeda = v_valor_destino_cod_moeda[count]);
				</cfscript>
			</cfloop>
			<!--- Insercao de anexos --->
			<cfscript>
				v_descricao = this.ListaToArray (lista = arguments, variavel = "ANEXO_DESCRICAO_ANEXOS");
			</cfscript>
			<cfloop from="1" to="#ArrayLen(v_descricao)#" index="count">
				<cfscript>
					this.ins_anexo_crt(	conhecimento_id = retorno.conhecimento_id,
					               		descricao = v_descricao[count]);
				</cfscript>
			</cfloop>	
				
			<!--- Alteraes dos Complementados --->
			<cfscript>
				v_tipo_id_complemento = this.ListaToArray (lista = arguments, variavel = "TIPO_COMPLEMENTO_COMPLEMENTO");
				v_conhecimento_id_complemento = this.ListaToArray (lista = arguments, variavel = "CONHECIMENTO_COMPLEMENTO_ID_COMPLEMENTO");
				v_numero_compl = this.ListaToArray (lista = arguments, variavel = "CRT_COMPLEMENTO_COMPLEMENTO");
				v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_COMPLEMENTO, lista2 = ArrayToList(v_conhecimento_id_complemento));
			</cfscript>
			<!--- Excluir os itens --->
			<cfloop list="#v_excluir#" delimiters="," index="l_id">
				<cfscript>
					ret = this.del_conhecimento_complemento (conhecimento_id = retorno.conhecimento_id,
									                	conhecimento_id_complemento   = l_id);
				</cfscript>
				<cfif ret.erro>
					<cfthrow object="#ret.mensagem#">
				</cfif>
			</cfloop>
			<cfloop from="1" to="#ArrayLen(v_conhecimento_id_complemento)#" index="count">
				<cfscript>
					ret = this.ins_conhecimento_complemento(	conhecimento_id = retorno.conhecimento_id,
					      		         						conhecimento_id_complemento = v_conhecimento_id_complemento[count],
														tipo_id = v_tipo_id_complemento[count]);
				</cfscript>
				<cfif ret.erro>
					<cfthrow object="#ret.mensagem#">
				</cfif>
			</cfloop>	

			<!--- Insercao de FRONTEIRAS --->
			<cfscript>
				v_fronteira_id = this.ListaToArray (lista = arguments, variavel = "FRONTEIRA_ID_FRONTEIRAS");
			</cfscript>
			<cfloop from="1" to="#ArrayLen(v_fronteira_id)#" index="count">
				<cfscript>
					this.ins_crt_fronteira(	conhecimento_id = retorno.conhecimento_id,
					               		    fronteira_id	= v_fronteira_id[count]);
				</cfscript>
			</cfloop>
            
            <!--- Insero de Embarques --->
            <cfscript>
				v_programacao_id			 = this.ListaToArray(lista = arguments, variavel = 'PROGRAMACAO_ID_AGENDAMENTO');
				v_embarque_id				 = this.ListaToArray(lista = arguments, variavel = 'EMBARQUE_ID_AGENDAMENTO');
				v_viagem_id     			 = this.ListaToArray(lista = arguments, variavel = 'VIAGEM_ID_AGENDAMENTO');
				v_cod_motorista 			 = this.ListaToArray(lista = arguments, variavel = 'COD_MOTORISTA_AGENDAMENTO');
				v_placa_cavalo 				 = this.ListaToArray(lista = arguments, variavel = 'PLACA_CAVALO_AGENDAMENTO');
				v_placa_carreta 			 = this.ListaToArray(lista = arguments, variavel = 'PLACA_CARRETA_AGENDAMENTO');
				v_data_saida      			 = this.ListaToArray(lista = arguments, variavel = 'DATA_SAIDA_AGENDAMENTO');
				v_previsao_chegada_fronteira = this.ListaToArray(lista = arguments, variavel = 'PREVISAO_CHEGADA_FRONTEIRA_AGENDAMENTO');
				v_fronteira_transbordo_id 	 = this.ListaToArray(lista = arguments, variavel = 'FRONTEIRA_TRANSBORDO_ID_AGENDAMENTO');
				v_observacao			     = this.ListaToArray(lista = arguments, variavel = 'OBSERVACAO_AGENDAMENTO');
			</cfscript>
			<cfloop from="1" to="#ArrayLen(v_embarque_id)#" index="count">
				<cfscript>
					ret = this.ins_viagem_embarque(PROGRAMACAO_ID			  = v_programacao_id[count],
										     	   VIAGEM_ID				  = v_viagem_id[count],
												   CONHECIMENTO_ID 		      = retorno.conhecimento_id,
												   MANIFESTO_ID			      = '',
												   COD_MOTORISTA 			  = v_cod_motorista[count],
												   PLACA_CAVALO 			  = v_placa_cavalo[count],
												   PLACA_CARRETA 			  = v_placa_carreta[count],
												   DATA_SAIDA				  = v_data_saida[count],
												   PREVISAO_CHEGADA_FRONTEIRA = v_previsao_chegada_fronteira[count],
												   FRONTEIRA_TRANSBORDO_ID    = v_fronteira_transbordo_id[count],
												   OBSERVACAO           	  = v_observacao[count]);
				</cfscript>
                <cfif ret.erro>
                    <cfthrow object="#ret.mensagem#">
                </cfif>
			</cfloop>
            
            <!--- Gera conhecimento FORM --->
			<cfscript>
                set_impressao = this.ins_intc_conhecimento_form(conhecimento_id = arguments.conhecimento_id);
            </cfscript>
           
            <cfif IsDefined("set_impressao") and set_impressao.erro>
                <cfthrow object="#set_impressao.mensagem#">
            </cfif>
			
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat("C.R.T. inserido com sucesso!")>
		</cftransaction>
		<cfcatch>
			<cftransaction action="rollback"/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />		
</cffunction>

<!--- 
-- PROPSITO
-- Altera um conhecimento internacional
-- 06/12/2005 - criado
--->
<cffunction name="upd_intc_conhecimento" displayname="Altera um conhecimento internacional" access="remote" returntype="Struct" output="true">
	<cfargument name="CONHECIMENTO_ID" required="yes">
	<cfargument name="NUMERO" required="yes">
	<cfargument name="COD_PESSOA_FILIAL" required="yes">
	<cfargument name="COD_ORGANOGRAMA" required="yes">
	<cfargument name="EMISSAO_LOCAL" required="yes">
	<cfargument name="EMISSAO_MUNICIPIO_ID" required="yes">
	<cfargument name="RESP_LOCAL" required="yes">
	<cfargument name="RESP_MUNICIPIO_ID" required="yes">
	<cfargument name="RESP_DATA" required="yes">
	<cfargument name="ENTREGA_LOCAL" required="yes">
	<cfargument name="ENTREGA_MUNICIPIO_ID" required="yes">
	<cfargument name="ENTREGA_DATA" required="yes">
	<cfargument name="TRANSP_SUCESSIVOS" required="no" default="N.I.H.I.L">
	<cfargument name="COD_REMETENTE" required="yes">
	<cfargument name="REM_NOME" required="yes">
	<cfargument name="REM_ENDERECO" required="yes">
	<cfargument name="REM_MUNICIPIO" required="yes">
	<cfargument name="REM_UF" required="yes">
	<cfargument name="REM_PAIS" required="yes">
	<cfargument name="REM_CNPJ_CPF" required="yes">
	<cfargument name="COD_DESTINATARIO" required="yes">
	<cfargument name="DEST_NOME" required="yes">
	<cfargument name="DEST_ENDERECO" required="yes">
	<cfargument name="DEST_MUNICIPIO" required="yes">
	<cfargument name="DEST_UF" required="yes">
	<cfargument name="DEST_PAIS" required="yes">
	<cfargument name="DEST_CNPJ_CPF" required="yes">
	<cfargument name="COD_CONSIGNATARIO" required="yes">
	<cfargument name="CONS_NOME" required="yes">
	<cfargument name="CONS_ENDERECO" required="yes">
	<cfargument name="CONS_MUNICIPIO" required="yes">
	<cfargument name="CONS_UF" required="yes">
	<cfargument name="CONS_PAIS" required="yes">
	<cfargument name="CONS_CNPJ_CPF" required="yes">
	<cfargument name="COD_NOTIFICAR" required="yes">
	<cfargument name="NOT_NOME" required="yes">
	<cfargument name="NOT_ENDERECO" required="yes">
	<cfargument name="NOT_MUNICIPIO" required="yes">
	<cfargument name="NOT_UF" required="yes">
	<cfargument name="NOT_PAIS" required="yes">
	<cfargument name="NOT_CNPJ_CPF" required="yes">
	<cfargument name="MERCADORIAS" required="no" default="">
	<cfargument name="NUM_ESPECIE" required="yes">
	<cfargument name="QUANTIDADE_TOTAL" required="yes">
	<cfargument name="PESO_BRUTO" required="yes">

	<cfargument name="PESO_LIQUIDO" required="yes">
	<cfargument name="UNIDADE_ID" required="yes">
	<cfargument name="M3" required="yes">
	<cfargument name="VALOR_TOTAL" required="yes">
	<cfargument name="VALOR_TOTAL_COD_MOEDA" required="yes">
	<cfargument name="VALOR_TOTAL_INCOTERM_ID" required="yes">
	
	<cfargument name="TOTAL_CUSTO_ORIGEM" required="yes">
	<cfargument name="TOTAL_CUSTO_ORIGEM_COD_MOEDA" required="yes">
	<cfargument name="TOTAL_CUSTO_DESTINO" required="yes">
	<cfargument name="TOTAL_CUSTO_DESTINO_COD_MOEDA" required="yes">
	<cfargument name="VALOR_FRT_EXTERNO" required="yes">
	<cfargument name="VALOR_FRT_EXTERNO_COD_MOEDA" required="yes">
	<cfargument name="VALOR_REEMBOLSO" required="yes">
	<cfargument name="VALOR_REEMBOLSO_COD_MOEDA" required="yes">
	<cfargument name="VALOR_MERCADORIAS" required="yes">
	<cfargument name="VALOR_MERCADORIAS_COD_MOEDA" required="yes">
	<cfargument name="VALOR_MERCADORIAS_INCOTERM" required="yes">
	<cfargument name="ALFANDEGA_ORIGEM_ID" required="yes">
	<cfargument name="ALFANDEGA_DESTINO_ID" required="yes">
	<cfargument name="PAGO_POR" required="yes">
	<cfargument name="DECLARACAO_OBSERVACAO" required="yes">
	<cfargument name="OBS_PAGO_POR" required="no">
	<cfargument name="ADICIONAIS_MERCADORIA" required="yes">
	<cfargument name="pais_id_origem" required="yes">

	<cfargument name="SEGURO_PAGO_EMPRESA" required="no" default="0" >
	<cfargument name="QTDE_VEICULOS" required="no" default="1" >
	<cfargument name="EMISSAO_DATA_IMPRESSAO" required="no" default="" >
	<cfargument name="TAXA_MERCADORIA_SEGURO" required="no" default="0" >

	<cfargument name='COD_PAGADOR_ORIGEM' required='yes'>
	<cfargument name='PAG_ORIGEM_NOME' required='yes'>
	<cfargument name='PAG_ORIGEM_ENDERECO' required='yes'>
	<cfargument name='PAG_ORIGEM_CIDADE' required='yes'>
	<cfargument name='PAG_ORIGEM_UF' required='yes'>
	<cfargument name='PAG_ORIGEM_PAIS' required='yes'>
	<cfargument name='PAG_ORIGEM_CNPJ_CPF' required='yes'>
	<cfargument name='COD_PAGADOR_DESTINO' required='yes'>
	<cfargument name='PAG_DESTINO_NOME' required='yes'>
	<cfargument name='PAG_DESTINO_ENDERECO' required='yes'>
	<cfargument name='PAG_DESTINO_CIDADE' required='yes'>
	<cfargument name='PAG_DESTINO_UF' required='yes'>
	<cfargument name='PAG_DESTINO_PAIS' required='yes'>
	<cfargument name='PAG_DESTINO_CNPJ_CPF' required='yes'>    
	<cfargument name='PRE_CONHECIMENTO' required='yes' default="0">
    <cfargument name="REGERAR_IMPRESSAO" required="no" default="0">
    <cfargument name='DATA_EMBARQUE_MANUAL' required='no' default="">
    <cftry>
		<cfscript>
			v_descricao = this.ListaToArray (lista = arguments, variavel = "MERC_DESCRICAO_MERCADORIAS");
			v_mercadorias = "";
		</cfscript>
		<cfloop from="1" to="#ArrayLen(v_descricao)#" index="v_index">
			<cfset v_mercadorias = v_mercadorias&v_descricao[v_index]&chr(10)>			
		</cfloop>
		<cfset v_mercadorias = v_mercadorias&arguments.adicionais_mercadoria>				
		<cftransaction action="begin">
			<cfstoredproc procedure="fiscal.pkg_transp_internacional.prc_alt_conhecimento" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_CONHECIMENTO_ID" value="#arguments.CONHECIMENTO_ID#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_NUMERO_COD_PAIS" value="#UCase(ListGetAt(arguments.NUMERO, 1, '.'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_NUMERO_CERTIFICADO" value="#ListGetAt(arguments.NUMERO, 2, '.')#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_NUMERO_SEQUENCIAL" value="#ListGetAt(arguments.NUMERO, 3, '.')#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_COD_PESSOA_FILIAL" value="#arguments.COD_PESSOA_FILIAL#" null="#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_COD_ORGANOGRAMA" value="#arguments.COD_ORGANOGRAMA#" null="#iif(len(trim(arguments.COD_ORGANOGRAMA)), de('no'), de('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_EMISSAO_LOCAL" value="#arguments.EMISSAO_LOCAL#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_EMISSAO_MUNICIPIO_ID" value="#arguments.EMISSAO_MUNICIPIO_ID#" null="#iif(len(trim(arguments.EMISSAO_MUNICIPIO_ID)), de('no'), de('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_EMISSAO_DATA" value="#arguments.EMISSAO_DATA#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_RESP_LOCAL" value="#arguments.RESP_LOCAL#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_RESP_MUNICIPIO_ID" value="#arguments.RESP_MUNICIPIO_ID#" null="#iif(len(trim(arguments.RESP_MUNICIPIO_ID)), de('no'), de('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_RESP_DATA" value="#arguments.RESP_DATA#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_ENTREGA_LOCAL" value="#arguments.ENTREGA_LOCAL#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_ENTREGA_MUNICIPIO_ID" value="#arguments.ENTREGA_MUNICIPIO_ID#" null="#iif(len(trim(arguments.ENTREGA_MUNICIPIO_ID)), de('no'), de('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_ENTREGA_DATA" value="#arguments.ENTREGA_DATA#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_TRANSP_SUCESSIVOS" value="#arguments.TRANSP_SUCESSIVOS#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_COD_REMETENTE" value="#arguments.COD_REMETENTE#" null="#iif(len(trim(arguments.COD_REMETENTE)), de('no'), de('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_REM_NOME" value="#arguments.REM_NOME#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_REM_ENDERECO" value="#arguments.REM_ENDERECO#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_REM_MUNICIPIO_ID" value="#arguments.REM_MUNICIPIO_ID#" null="#iif(len(trim(arguments.rem_municipio_id)), de('no'), de('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_REM_CIDADE" value="#arguments.REM_MUNICIPIO#">
				
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_REM_UF" value="#arguments.REM_UF#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_REM_PAIS" value="#arguments.REM_PAIS#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_REM_CNPJ_CPF" value="#arguments.REM_CNPJ_CPF#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_COD_DESTINATARIO" value="#arguments.COD_DESTINATARIO#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DEST_NOME" value="#arguments.DEST_NOME#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DEST_ENDERECO" value="#arguments.DEST_ENDERECO#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DEST_MUNICIPIO_ID" value="#arguments.DEST_MUNICIPIO_ID#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DEST_CIDADE" value="#arguments.DEST_MUNICIPIO#">

				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DEST_UF" value="#arguments.DEST_UF#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DEST_PAIS" value="#arguments.DEST_PAIS#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DEST_CNPJ_CPF" value="#arguments.DEST_CNPJ_CPF#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_COD_CONSIGNATARIO" value="#arguments.COD_CONSIGNATARIO#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_CONS_NOME" value="#arguments.CONS_NOME#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_CONS_ENDERECO" value="#arguments.CONS_ENDERECO#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_CONS_MUNICIPIO_ID" value="#arguments.CONS_MUNICIPIO_ID#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_CONS_CIDADE" value="#arguments.CONS_MUNICIPIO#">

				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_CONS_UF" value="#arguments.CONS_UF#">

				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_CONS_PAIS" value="#arguments.CONS_PAIS#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_CONS_CNPJ_CPF" value="#arguments.CONS_CNPJ_CPF#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_COD_NOTIFICAR" value="#arguments.COD_NOTIFICAR#" null="#iif(len(trim(arguments.COD_NOTIFICAR)), de('no'), de('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_NOT_NOME" value="#arguments.NOT_NOME#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_NOT_ENDERECO" value="#arguments.NOT_ENDERECO#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_NOT_MUNICIPIO_ID" value="#arguments.NOT_MUNICIPIO_ID#" null="#iif(len(trim(arguments.NOT_MUNICIPIO_ID)), de('no'), de('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_NOT_CIDADE" value="#arguments.NOT_MUNICIPIO#">

				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_NOT_UF" value="#arguments.NOT_UF#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_NOT_PAIS" value="#arguments.NOT_PAIS#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_NOT_CNPJ_CPF" value="#arguments.NOT_CNPJ_CPF#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_MERCADORIAS" value="#v_MERCADORIAS#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_NUM_ESPECIE" value="#arguments.NUM_ESPECIE#"  null="#iif(len(trim(arguments.NUM_ESPECIE)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_QUANTIDADE_TOTAL" 			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.quantidade_total#" null="#iif(len(trim(arguments.quantidade_total)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_PESO_BRUTO" 					type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.peso_bruto#" null="#iif(len(trim(arguments.peso_bruto)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_PESO_LIQUIDO" 				type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.peso_liquido#" null="#iif(len(trim(arguments.peso_liquido)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_UNIDADE_ID" 					type="in"  cfsqltype="cf_sql_varchar" value="#arguments.unidade_id#">
				<cfprocparam dbvarname="P_M3" 							type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.m3#" null="#iif(len(trim(arguments.m3)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_VALOR_TOTAL" 					type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.valor_total#" null="#iif(len(trim(arguments.valor_total)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_VALOR_TOTAL_COD_MOEDA"		type="in"  cfsqltype="cf_sql_integer" value="#arguments.valor_total_cod_moeda#" null="#iif(len(trim(arguments.valor_total_cod_moeda)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_VALOR_TOTAL_INCOTERM_ID"		type="in"  cfsqltype="cf_sql_integer" value="#arguments.valor_total_incoterm_id#" null="#iif(len(trim(arguments.valor_total_incoterm_id)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_TOTAL_CUSTO_ORIGEM" 			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.total_custo_origem#" null="#iif(len(trim(arguments.total_custo_origem)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_TOTAL_CUSTO_ORIGEM_COD_MOEDA" type="in"  cfsqltype="cf_sql_integer" value="#arguments.total_custo_origem_cod_moeda#" null="#iif(len(trim(arguments.total_custo_origem_cod_moeda)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_TOTAL_CUSTO_DESTINO" 			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.total_custo_destino#" null="#iif(len(trim(arguments.total_custo_destino)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_TOTAL_CUSTO_DESTINO_COD_MOED" type="in"  cfsqltype="cf_sql_integer" value="#arguments.total_custo_destino_cod_moeda#" null="#iif(len(trim(arguments.total_custo_destino_cod_moeda)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_VALOR_FRT_EXTERNO" 			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.valor_frt_externo#" null="#iif(len(trim(arguments.valor_frt_externo)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_VALOR_FRT_EXTERNO_COD_MOEDA"	type="in"  cfsqltype="cf_sql_integer" value="#arguments.valor_frt_externo_cod_moeda#" null="#iif(len(trim(arguments.valor_frt_externo_cod_moeda)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_VALOR_REEMBOLSO" 				type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.valor_reembolso#"  null="#iif(len(trim(arguments.valor_reembolso)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_VALOR_REEMBOLSO_COD_MOEDA" 	type="in"  cfsqltype="cf_sql_integer" value="#arguments.valor_reembolso_cod_moeda#" null="#iif(len(trim(arguments.valor_reembolso_cod_moeda)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_VALOR_MERCADORIAS" 			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.valor_mercadorias#" null="#iif(len(trim(arguments.valor_mercadorias)), de('no'), de('yes'))#">
			
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_VALOR_MERCADORIAS_COD_MOEDA" value="#arguments.VALOR_MERCADORIAS_COD_MOEDA#" null="#iif(len(trim(arguments.VALOR_MERCADORIAS_COD_MOEDA)), de('no'), de('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_VALOR_MERCADORIAS_INCOTERM" value="#arguments.VALOR_MERCADORIAS_INCOTERM#" null="#iif(len(trim(arguments.VALOR_MERCADORIAS_INCOTERM)), de('no'), de('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_ALFANDEGA_ORIGEM_ID" value="#arguments.ALFANDEGA_ORIGEM_ID#"  null="#iif(len(trim(arguments.ALFANDEGA_ORIGEM_ID)), de('no'), de('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_ALFANDEGA_DESTINO_ID" value="#arguments.ALFANDEGA_DESTINO_ID#"  null="#iif(len(trim(arguments.ALFANDEGA_DESTINO_ID)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_PAIS_ID_ORIGEM" 				type="in"  cfsqltype="cf_sql_integer" value="#arguments.pais_id_origem#"  null="#iif(len(trim(arguments.pais_id_origem)), de('no'), de('yes'))#">

				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_PAGO_POR" value="#arguments.PAGO_POR#"  null="#iif(len(trim(arguments.PAGO_POR)), de('no'), de('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DECLARACAO_OBSERVACAO" value="#arguments.DECLARACAO_OBSERVACAO#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_OBS_PAGO_POR" value="#arguments.OBS_PAGO_POR#">
				<cfprocparam dbvarname="P_QTDE_VEICULOS"				type="in"  cfsqltype="cf_sql_integer" value="#arguments.qtde_veiculos#" null="#iif(len(trim(arguments.qtde_veiculos)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_SEGURO_PAGO_EMPRESA"			type="in"  cfsqltype="cf_sql_integer" value="#arguments.seguro_pago_empresa#" null="#iif(len(trim(arguments.seguro_pago_empresa)), de('no'), de('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_EMISSAO_DATA_IMPRESSAO" value="#arguments.EMISSAO_DATA_IMPRESSAO#">
				<cfprocparam dbvarname="P_TAXA_MERCADORIA_SEGURO"		type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.TAXA_MERCADORIA_SEGURO#" null="#iif(len(trim(arguments.TAXA_MERCADORIA_SEGURO)), de('no'), de('yes'))#">

				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_PAGADOR_ORIGEM'  value='#arguments.COD_PAGADOR_ORIGEM#'  null='#iif(len(trim(arguments.COD_PAGADOR_ORIGEM)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PAG_ORIGEM_NOME'  value='#arguments.PAG_ORIGEM_NOME#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PAG_ORIGEM_ENDERECO'  value='#arguments.PAG_ORIGEM_ENDERECO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PAG_ORIGEM_CIDADE'  value='#arguments.PAG_ORIGEM_CIDADE#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PAG_ORIGEM_UF'  value='#arguments.PAG_ORIGEM_UF#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PAG_ORIGEM_PAIS'  value='#arguments.PAG_ORIGEM_PAIS#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PAG_ORIGEM_CNPJ_CPF'  value='#arguments.PAG_ORIGEM_CNPJ_CPF#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_PAGADOR_DESTINO'  value='#arguments.COD_PAGADOR_DESTINO#'  null='#iif(len(trim(arguments.COD_PAGADOR_DESTINO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PAG_DESTINO_NOME'  value='#arguments.PAG_DESTINO_NOME#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PAG_DESTINO_ENDERECO'  value='#arguments.PAG_DESTINO_ENDERECO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PAG_DESTINO_CIDADE'  value='#arguments.PAG_DESTINO_CIDADE#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PAG_DESTINO_UF'  value='#arguments.PAG_DESTINO_UF#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PAG_DESTINO_PAIS'  value='#arguments.PAG_DESTINO_PAIS#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PAG_DESTINO_CNPJ_CPF'  value='#arguments.PAG_DESTINO_CNPJ_CPF#' >
				<cfprocparam dbvarname="P_PRE_CONHECIMENTO"		type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.PRE_CONHECIMENTO#" null="#iif(len(trim(arguments.PRE_CONHECIMENTO)), de('no'), de('yes'))#">
                <cfprocparam dbvarname="P_REGERA_IMPRESSAO"		type="in"  cfsqltype="cf_sql_numeric" scale="5" value="0">
                <cfprocparam dbvarname="P_DATA_EMBARQUE_MANUAL"		type="in"  cfsqltype="cf_sql_varchar" value="#arguments.DATA_EMBARQUE_MANUAL#" null="#iif(len(trim(arguments.DATA_EMBARQUE_MANUAL)), de('no'), de('yes'))#">
	        </cfstoredproc>
			
			<cfset retorno.conhecimento_id = arguments.conhecimento_id>
			
			<!--- Alteraes das Mercadorias --->
			<cfscript>
				v_produto_id = this.ListaToArray (lista = arguments, variavel = "MERC_PRODUTO_ID_MERCADORIAS");
				v_num_especie = this.ListaToArray (lista = arguments, variavel = "MERC_NUM_ESPECIE_MERCADORIAS");
				v_quantidade = this.ListaToArray (lista = arguments, variavel = "MERC_QUANTIDADE_MERCADORIAS");
				v_peso_bruto = this.ListaToArray (lista = arguments, variavel = "MERC_PESO_BRUTO_MERCADORIAS");
				v_peso_liquido = this.ListaToArray (lista = arguments, variavel = "MERC_PESO_LIQUIDO_MERCADORIAS");
				v_m3 = this.ListaToArray (lista = arguments, variavel = "MERC_VOLUME_MERCADORIAS");
				v_unidade_id = this.ListaToArray (lista = arguments, variavel = "MERC_UNIDADE_ID_MERCADORIAS");
				v_descricao = this.ListaToArray (lista = arguments, variavel = "MERC_DESCRICAO_MERCADORIAS");
				v_item_id = this.ListaToArray (lista = arguments, variavel = "MERC_ITEM_ID_MERCADORIAS");
				v_merc_excluir = this.ListDiff(lista1 = arguments.lista_deleted_MERCADORIAS, lista2 = ArrayToList(v_item_id));
			</cfscript>
				<!--- Excluir os itens --->
			<cfloop list="#v_merc_excluir#" delimiters="," index="l_item_id">
				<cfscript>
					this.del_item_crt (	conhecimento_id = arguments.conhecimento_id,
					                	item_id   = l_item_id);
				</cfscript>
			</cfloop>
			<cfloop from="1" to="#ArrayLen(v_descricao)#" index="count">
				<cfscript>
				if(not len(trim(v_item_id[count]))) {
					//caso o item_id seja nulo insere
					this.ins_item_crt(	conhecimento_id = arguments.conhecimento_id,
					               		produto_id = v_produto_id[count],
								  		num_especie = v_num_especie[count],
								 		quantidade = v_quantidade[count],
								 		peso_bruto = v_peso_bruto[count],
										peso_liquido = v_peso_liquido[count],
										m3 = v_m3[count],
										descricao = v_descricao[count]);
				} else {
					//senao altera
					this.upd_item_crt(	conhecimento_id = arguments.conhecimento_id,
					               		produto_id = v_produto_id[count],
								  		num_especie = v_num_especie[count],
								 		quantidade = v_quantidade[count],
								 		peso_bruto = v_peso_bruto[count],
										peso_liquido = v_peso_liquido[count],
										m3 = v_m3[count],
										descricao = v_descricao[count],
										item_id = v_item_id[count]);
				}
				</cfscript>
			</cfloop>			
			<!--- Alteraes dos custos --->
			<cfscript>
				v_descricao = this.ListaToArray (lista = arguments, variavel = "CUST_DESCRICAO_CUSTOS");
				v_valor_origem = this.ListaToArray (lista = arguments, variavel = "CUST_VALOR_ORIGEM_CUSTOS");
				v_valor_origem_cod_moeda = this.ListaToArray (lista = arguments, variavel = "CUST_VALOR_ORIGEM_COD_MOEDA_CUSTOS");
				v_valor_destino = this.ListaToArray (lista = arguments, variavel = "CUST_VALOR_DESTINO_CUSTOS");
				v_valor_destino_cod_moeda = this.ListaToArray (lista = arguments, variavel = "CUST_VALOR_DESTINO_COD_MOEDA_CUSTOS");
				v_item_id = this.ListaToArray (lista = arguments, variavel = "CUST_ITEM_ID_CUSTOS");
				v_cust_excluir = this.ListDiff(lista1 = arguments.lista_deleted_CUSTOS, lista2 = ArrayToList(v_item_id));
			</cfscript>
				<!--- Excluir os itens --->
			<cfloop list="#v_cust_excluir#" delimiters="," index="l_item_id">
				<cfscript>
					this.del_custo_crt (conhecimento_id = arguments.conhecimento_id,
					                	item_id   = l_item_id);
				</cfscript>
			</cfloop>
			<cfloop from="1" to="#ArrayLen(v_descricao)#" index="count">
				<cfscript>
				if(not len(trim(v_item_id[count]))) {
					//caso o item_id seja nulo insere
					this.ins_custo_crt(	conhecimento_id = arguments.conhecimento_id,
					               		descricao = v_descricao[count],
								  		valor_origem = v_valor_origem[count],
								 		valor_origem_cod_moeda = v_valor_origem_cod_moeda[count],
								 		valor_destino = v_valor_destino[count],
										valor_destino_cod_moeda = v_valor_destino_cod_moeda[count]);
				} else {
					//senao altera
					this.upd_custo_crt(	conhecimento_id = arguments.conhecimento_id,
					               		descricao = v_descricao[count],
								  		valor_origem = v_valor_origem[count],
								 		valor_origem_cod_moeda = v_valor_origem_cod_moeda[count],
								 		valor_destino = v_valor_destino[count],
										valor_destino_cod_moeda = v_valor_destino_cod_moeda[count],
										item_id = v_item_id[count]);
				}
				</cfscript>
			</cfloop>				
			<!--- Alteraes dos Anexos --->
			<cfscript>
				v_descricao = this.ListaToArray (lista = arguments, variavel = "ANEXO_DESCRICAO_ANEXOS");
				v_item_id = this.ListaToArray (lista = arguments, variavel = "ANEXO_ID_ANEXOS");
				v_anexos_excluir = this.ListDiff(lista1 = arguments.lista_deleted_ANEXOS, lista2 = ArrayToList(v_item_id));
			</cfscript>
				<!--- Excluir os itens --->
			<cfloop list="#v_anexos_excluir#" delimiters="," index="l_item_id">
				<cfscript>
					this.del_anexo_crt (conhecimento_id = arguments.conhecimento_id,
					                	anexo_id   = l_item_id);
				</cfscript>
			</cfloop>
			<cfloop from="1" to="#ArrayLen(v_descricao)#" index="count">
				<cfscript>
				if(not len(trim(v_item_id[count]))) {
					//caso o item_id seja nulo insere
					this.ins_anexo_crt(	conhecimento_id = arguments.conhecimento_id,
					               		descricao = v_descricao[count]);
				} else {
					//senao altera
					this.upd_anexo_crt(	conhecimento_id = arguments.conhecimento_id,
					               		descricao = v_descricao[count],
										anexo_id = v_item_id[count]);
				}
				</cfscript>
			</cfloop>			
			
			<!--- Alteraes dos Complementados --->
			<cfscript>
				retorno.conhecimento_id = arguments.conhecimento_id;
				v_tipo_id_complemento = this.ListaToArray (lista = arguments, variavel = "TIPO_COMPLEMENTO_COMPLEMENTO");
				v_conhecimento_id_complemento = this.ListaToArray (lista = arguments, variavel = "CONHECIMENTO_COMPLEMENTO_ID_COMPLEMENTO");
				v_numero_compl = this.ListaToArray (lista = arguments, variavel = "CRT_COMPLEMENTO_COMPLEMENTO");
				v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_COMPLEMENTO, lista2 = ArrayToList(v_conhecimento_id_complemento));
			</cfscript>
				<!--- Excluir os itens --->
			<cfloop list="#v_excluir#" delimiters="," index="l_id">
				<cfscript>
					ret = this.del_conhecimento_complemento (conhecimento_id = retorno.conhecimento_id,
									                	conhecimento_id_complemento   = l_id);
				</cfscript>
				<cfif ret.erro>
					<cfthrow object="#ret.mensagem#">
				</cfif>
			</cfloop>
			<cfloop from="1" to="#ArrayLen(v_conhecimento_id_complemento)#" index="count">
				<cfscript>
					ret = this.ins_conhecimento_complemento(	conhecimento_id = retorno.conhecimento_id,
					      		         						conhecimento_id_complemento = v_conhecimento_id_complemento[count],
														tipo_id = v_tipo_id_complemento[count]);
				</cfscript>
				<cfif ret.erro>
					<cfthrow object="#ret.mensagem#">
				</cfif>
			</cfloop>	
            
			<!--- Insercao de FRONTEIRAS --->
			<cfscript>
				v_controle_id  = this.ListaToArray (lista = arguments, variavel = "CONTROLE_ID_FRONTEIRAS");
				v_fronteira_id = this.ListaToArray (lista = arguments, variavel = "FRONTEIRA_ID_FRONTEIRAS");
				v_fronteira_excluir = this.ListDiff(lista1 = arguments.lista_deleted_FRONTEIRAS, lista2 = ArrayToList(v_fronteira_id));
			</cfscript>
			<!--- Excluir os itens --->
			<cfloop list="#v_fronteira_excluir#" delimiters="," index="l_item_id">
				<cfscript>
					this.del_crt_fronteira (controle_id = l_item_id);
				</cfscript>
			</cfloop>
			<cfloop from="1" to="#ArrayLen(v_controle_id)#" index="count">
				<cfscript>
				if(not len(trim(v_controle_id[count]))) {
					//caso o item_id seja nulo insere
					this.ins_crt_fronteira(	conhecimento_id = arguments.conhecimento_id,
					               		    fronteira_id = v_fronteira_id[count]);
				} else {
					//senao altera
					this.upd_crt_fronteira(	conhecimento_id = arguments.conhecimento_id,
					               		    fronteira_id    = v_fronteira_id[count],
										    controle_id     = v_controle_id[count]);
				}
				</cfscript>
			</cfloop>
            
            <!--- Alterao de Embarques --->
            <!---<cfscript>
				v_programacao_id			 = this.ListaToArray(lista = arguments, variavel = 'PROGRAMACAO_ID_AGENDAMENTO');
				v_embarque_id				 = this.ListaToArray(lista = arguments, variavel = 'EMBARQUE_ID_AGENDAMENTO');
				v_viagem_id     			 = this.ListaToArray(lista = arguments, variavel = 'VIAGEM_ID_AGENDAMENTO');
				v_cod_motorista 			 = this.ListaToArray(lista = arguments, variavel = 'COD_MOTORISTA_AGENDAMENTO');
				v_placa_cavalo 				 = this.ListaToArray(lista = arguments, variavel = 'PLACA_CAVALO_AGENDAMENTO');
				v_placa_carreta 			 = this.ListaToArray(lista = arguments, variavel = 'PLACA_CARRETA_AGENDAMENTO');
				v_data_saida      			 = this.ListaToArray(lista = arguments, variavel = 'DATA_SAIDA_AGENDAMENTO');
				v_previsao_chegada_fronteira = this.ListaToArray(lista = arguments, variavel = 'PREVISAO_CHEGADA_FRONTEIRA_AGENDAMENTO');
				v_fronteira_transbordo_id 	 = this.ListaToArray(lista = arguments, variavel = 'FRONTEIRA_TRANSBORDO_ID_AGENDAMENTO');
				v_observacao			     = this.ListaToArray(lista = arguments, variavel = 'OBSERVACAO_AGENDAMENTO');
				v_excluir	    			 = this.ListDiff(lista1 = arguments.lista_deleted_AGENDAMENTO, lista2 = ArrayToList(v_embarque_id));
			</cfscript>
            <cfloop list="#v_excluir#" delimiters="," index="e_id">
				<cfscript>
                    ret = this.del_viagem_embarque(EMBARQUE_ID = e_id);
                </cfscript>
                <cfif ret.erro>
                    <cfthrow object="#ret.mensagem#">
                </cfif>
            </cfloop>
			<cfloop from="1" to="#ArrayLen(v_embarque_id)#" index="count">
				<cfscript>
					if(Not Len(Trim(v_embarque_id[count]))) {
						ret = this.ins_viagem_embarque(PROGRAMACAO_ID			  = v_programacao_id[count],
													   VIAGEM_ID				  = v_viagem_id[count],
													   CONHECIMENTO_ID 		      = retorno.conhecimento_id,
													   MANIFESTO_ID			      = '',
													   COD_MOTORISTA 			  = v_cod_motorista[count],
													   PLACA_CAVALO 			  = v_placa_cavalo[count],
													   PLACA_CARRETA 			  = v_placa_carreta[count],
													   DATA_SAIDA				  = v_data_saida[count],
													   PREVISAO_CHEGADA_FRONTEIRA = v_previsao_chegada_fronteira[count],
													   FRONTEIRA_TRANSBORDO_ID    = v_fronteira_transbordo_id[count],
													   OBSERVACAO           	  = v_observacao[count]);
					}
					else {
						ret = this.upd_viagem_embarque(PROGRAMACAO_ID			  = v_programacao_id[count],
													   EMBARQUE_ID			      = v_embarque_id[count],
													   VIAGEM_ID				  = v_viagem_id[count],
													   COD_MOTORISTA 			  = v_cod_motorista[count],
													   PLACA_CAVALO 			  = v_placa_cavalo[count],
													   PLACA_CARRETA 			  = v_placa_carreta[count],
													   DATA_SAIDA				  = v_data_saida[count],
													   PREVISAO_CHEGADA_FRONTEIRA = v_previsao_chegada_fronteira[count],
													   FRONTEIRA_TRANSBORDO_ID    = v_fronteira_transbordo_id[count],
													   OBSERVACAO           	  = v_observacao[count]);
					}
				</cfscript>
                <cfif ret.erro>
                    <cfthrow object="#ret.mensagem#">
                </cfif>
			</cfloop>--->
            
            <!--- Gera conhecimento FORM --->
			<cfscript>
                if(arguments.regerar_impressao eq 1) {
                    set_impressao = this.ins_intc_conhecimento_form(conhecimento_id = arguments.conhecimento_id);
                }
            </cfscript>
           
            <cfif IsDefined("set_impressao") and set_impressao.erro>
                <cfthrow object="#set_impressao.mensagem#">
            </cfif>
            			
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat("C.R.T. alterado com sucesso!")>
		</cftransaction>
		<cfcatch>
			<cftransaction action="rollback"/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

<!--- 
-- PROPSITO
-- Altera um conhecimento internacional
-- 06/12/2005 - criado
--->
<cffunction name="upd_intc_conhecimento_lib_fatura" displayname="Altera um conhecimento internacional" access="remote" returntype="Struct" output="true">
	<cfargument name="CONHECIMENTO_ID" required="yes">
	<cfargument name="RESP_LOCAL" required="yes">
	<cfargument name="RESP_MUNICIPIO_ID" required="yes">
	<cfargument name="RESP_DATA" required="yes">
	<cfargument name="ENTREGA_LOCAL" required="yes">
	<cfargument name="ENTREGA_MUNICIPIO_ID" required="yes">
	<cfargument name="ENTREGA_DATA" required="yes">
	<cfargument name="TRANSP_SUCESSIVOS" required="no" default="N.I.H.I.L">
	<cfargument name="REM_ENDERECO" required="yes">
	<cfargument name="REM_MUNICIPIO" required="yes">
	<cfargument name="REM_UF" required="yes">
	<cfargument name="REM_PAIS" required="yes">
	<cfargument name="DEST_ENDERECO" required="yes">
	<cfargument name="DEST_MUNICIPIO" required="yes">
	<cfargument name="DEST_UF" required="yes">
	<cfargument name="DEST_PAIS" required="yes">
	<cfargument name="CONS_ENDERECO" required="yes">
	<cfargument name="CONS_MUNICIPIO" required="yes">
	<cfargument name="CONS_UF" required="yes">
	<cfargument name="CONS_PAIS" required="yes">
	<cfargument name="NOT_ENDERECO" required="yes">
	<cfargument name="NOT_MUNICIPIO" required="yes">
	<cfargument name="NOT_UF" required="yes">
	<cfargument name="NOT_PAIS" required="yes">
	<cfargument name="MERCADORIAS" required="no" default="">
	<cfargument name="NUM_ESPECIE" required="yes">
	<cfargument name="QUANTIDADE_TOTAL" required="yes">
	<cfargument name="PESO_BRUTO" required="yes">
	<cfargument name="PESO_LIQUIDO" required="yes">
	<cfargument name="UNIDADE_ID" required="yes">
	<cfargument name="M3" required="yes">
	<cfargument name="VALOR_TOTAL" required="yes">
	<cfargument name="VALOR_TOTAL_COD_MOEDA" required="yes">
	<cfargument name="VALOR_TOTAL_INCOTERM_ID" required="yes">
	
	<cfargument name="VALOR_REEMBOLSO" required="yes">
	<cfargument name="VALOR_REEMBOLSO_COD_MOEDA" required="yes">
	<cfargument name="VALOR_MERCADORIAS" required="yes">
	<cfargument name="VALOR_MERCADORIAS_COD_MOEDA" required="yes">
	<cfargument name="VALOR_MERCADORIAS_INCOTERM" required="yes">
	<cfargument name="ALFANDEGA_ORIGEM_ID" required="yes">
	<cfargument name="ALFANDEGA_DESTINO_ID" required="yes">
	<cfargument name="DECLARACAO_OBSERVACAO" required="yes">
	<cfargument name="ADICIONAIS_MERCADORIA" required="yes">
	<cfargument name="pais_id_origem" required="yes">

	<cfargument name="SEGURO_PAGO_EMPRESA" required="no" default="0" >
	<cfargument name="QTDE_VEICULOS" required="no" default="1" >
	<cfargument name="EMISSAO_DATA_IMPRESSAO" required="no" default="" >
	<cfargument name="EMISSAO_DATA" required="yes" >
	<cfargument name="TAXA_MERCADORIA_SEGURO" required="no" default="0" >    
    <cfargument name="REGERAR_IMPRESSAO" required="no" default="0">
	<cftry>
		<cfscript>
			v_descricao = this.ListaToArray (lista = arguments, variavel = "MERC_DESCRICAO_MERCADORIAS");
			v_mercadorias = "";
		</cfscript>
		<cfloop from="1" to="#ArrayLen(v_descricao)#" index="v_index">
			<cfset v_mercadorias = v_mercadorias&v_descricao[v_index]&chr(10)>			
		</cfloop>
		<cfset v_mercadorias = v_mercadorias&arguments.adicionais_mercadoria>				
		<cftransaction action="begin">
			<cfstoredproc procedure="fiscal.pkg_transp_internacional.PRC_ALT_CRT_LIB_FATURA" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_CONHECIMENTO_ID" value="#arguments.CONHECIMENTO_ID#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_EMISSAO_DATA" value="#arguments.EMISSAO_DATA#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_EMISSAO_LOCAL" value="#arguments.EMISSAO_LOCAL#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_EMISSAO_MUNICIPIO_ID" value="#arguments.EMISSAO_MUNICIPIO_ID#" null="#iif(len(trim(arguments.EMISSAO_MUNICIPIO_ID)), de('no'), de('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_RESP_LOCAL" value="#arguments.RESP_LOCAL#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_RESP_MUNICIPIO_ID" value="#arguments.RESP_MUNICIPIO_ID#" null="#iif(len(trim(arguments.RESP_MUNICIPIO_ID)), de('no'), de('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_RESP_DATA" value="#arguments.RESP_DATA#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_ENTREGA_LOCAL" value="#arguments.ENTREGA_LOCAL#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_ENTREGA_MUNICIPIO_ID" value="#arguments.ENTREGA_MUNICIPIO_ID#" null="#iif(len(trim(arguments.ENTREGA_MUNICIPIO_ID)), de('no'), de('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_ENTREGA_DATA" value="#arguments.ENTREGA_DATA#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_TRANSP_SUCESSIVOS" value="#arguments.TRANSP_SUCESSIVOS#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_REM_ENDERECO" value="#arguments.REM_ENDERECO#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_REM_MUNICIPIO_ID" value="#arguments.REM_MUNICIPIO_ID#" null="#iif(len(trim(arguments.rem_municipio_id)), de('no'), de('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_REM_CIDADE" value="#arguments.REM_MUNICIPIO#">
				
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_REM_UF" value="#arguments.REM_UF#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_REM_PAIS" value="#arguments.REM_PAIS#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DEST_ENDERECO" value="#arguments.DEST_ENDERECO#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DEST_MUNICIPIO_ID" value="#arguments.DEST_MUNICIPIO_ID#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DEST_CIDADE" value="#arguments.DEST_MUNICIPIO#">

				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DEST_UF" value="#arguments.DEST_UF#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DEST_PAIS" value="#arguments.DEST_PAIS#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_CONS_ENDERECO" value="#arguments.CONS_ENDERECO#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_CONS_MUNICIPIO_ID" value="#arguments.CONS_MUNICIPIO_ID#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_CONS_CIDADE" value="#arguments.CONS_MUNICIPIO#">

				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_CONS_UF" value="#arguments.CONS_UF#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_CONS_PAIS" value="#arguments.CONS_PAIS#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_NOT_ENDERECO" value="#arguments.NOT_ENDERECO#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_NOT_MUNICIPIO_ID" value="#arguments.NOT_MUNICIPIO_ID#" null="#iif(len(trim(arguments.NOT_MUNICIPIO_ID)), de('no'), de('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_NOT_CIDADE" value="#arguments.NOT_MUNICIPIO#">

				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_NOT_UF" value="#arguments.NOT_UF#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_NOT_PAIS" value="#arguments.NOT_PAIS#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_MERCADORIAS" value="#v_MERCADORIAS#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_NUM_ESPECIE" value="#arguments.NUM_ESPECIE#"  null="#iif(len(trim(arguments.NUM_ESPECIE)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_QUANTIDADE_TOTAL" 			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.quantidade_total#" null="#iif(len(trim(arguments.quantidade_total)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_PESO_BRUTO" 					type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.peso_bruto#" null="#iif(len(trim(arguments.peso_bruto)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_PESO_LIQUIDO" 				type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.peso_liquido#" null="#iif(len(trim(arguments.peso_liquido)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_UNIDADE_ID" 					type="in"  cfsqltype="cf_sql_varchar" value="#arguments.unidade_id#">
				<cfprocparam dbvarname="P_M3" 							type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.m3#" null="#iif(len(trim(arguments.m3)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_VALOR_TOTAL" 					type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.valor_total#" null="#iif(len(trim(arguments.valor_total)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_VALOR_TOTAL_COD_MOEDA"		type="in"  cfsqltype="cf_sql_integer" value="#arguments.valor_total_cod_moeda#" null="#iif(len(trim(arguments.valor_total_cod_moeda)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_VALOR_TOTAL_INCOTERM_ID"		type="in"  cfsqltype="cf_sql_integer" value="#arguments.valor_total_incoterm_id#" null="#iif(len(trim(arguments.valor_total_incoterm_id)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_VALOR_REEMBOLSO" 				type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.valor_reembolso#"  null="#iif(len(trim(arguments.valor_reembolso)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_VALOR_REEMBOLSO_COD_MOEDA" 	type="in"  cfsqltype="cf_sql_integer" value="#arguments.valor_reembolso_cod_moeda#" null="#iif(len(trim(arguments.valor_reembolso_cod_moeda)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_VALOR_MERCADORIAS" 			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.valor_mercadorias#" null="#iif(len(trim(arguments.valor_mercadorias)), de('no'), de('yes'))#">
			
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_VALOR_MERCADORIAS_COD_MOEDA" value="#arguments.VALOR_MERCADORIAS_COD_MOEDA#" null="#iif(len(trim(arguments.VALOR_MERCADORIAS_COD_MOEDA)), de('no'), de('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_VALOR_MERCADORIAS_INCOTERM" value="#arguments.VALOR_MERCADORIAS_INCOTERM#" null="#iif(len(trim(arguments.VALOR_MERCADORIAS_INCOTERM)), de('no'), de('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_ALFANDEGA_ORIGEM_ID" value="#arguments.ALFANDEGA_ORIGEM_ID#"  null="#iif(len(trim(arguments.ALFANDEGA_ORIGEM_ID)), de('no'), de('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_ALFANDEGA_DESTINO_ID" value="#arguments.ALFANDEGA_DESTINO_ID#"  null="#iif(len(trim(arguments.ALFANDEGA_DESTINO_ID)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_PAIS_ID_ORIGEM" 				type="in"  cfsqltype="cf_sql_integer" value="#arguments.pais_id_origem#"  null="#iif(len(trim(arguments.pais_id_origem)), de('no'), de('yes'))#">

				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DECLARACAO_OBSERVACAO" value="#arguments.DECLARACAO_OBSERVACAO#">
				<cfprocparam dbvarname="P_QTDE_VEICULOS"				type="in"  cfsqltype="cf_sql_integer" value="#arguments.qtde_veiculos#" null="#iif(len(trim(arguments.qtde_veiculos)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="P_SEGURO_PAGO_EMPRESA"			type="in"  cfsqltype="cf_sql_integer" value="#arguments.seguro_pago_empresa#" null="#iif(len(trim(arguments.seguro_pago_empresa)), de('no'), de('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_EMISSAO_DATA_IMPRESSAO" value="#arguments.EMISSAO_DATA_IMPRESSAO#">
				<cfprocparam dbvarname="P_TAXA_MERCADORIA_SEGURO"		type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.TAXA_MERCADORIA_SEGURO#" null="#iif(len(trim(arguments.TAXA_MERCADORIA_SEGURO)), de('no'), de('yes'))#">
			</cfstoredproc>
			
			<cfset retorno.conhecimento_id = arguments.conhecimento_id>
			
			<!--- Alteraes das Mercadorias --->
			<cfscript>
				v_produto_id = this.ListaToArray (lista = arguments, variavel = "MERC_PRODUTO_ID_MERCADORIAS");
				v_num_especie = this.ListaToArray (lista = arguments, variavel = "MERC_NUM_ESPECIE_MERCADORIAS");
				v_quantidade = this.ListaToArray (lista = arguments, variavel = "MERC_QUANTIDADE_MERCADORIAS");
				v_peso_bruto = this.ListaToArray (lista = arguments, variavel = "MERC_PESO_BRUTO_MERCADORIAS");
				v_peso_liquido = this.ListaToArray (lista = arguments, variavel = "MERC_PESO_LIQUIDO_MERCADORIAS");
				v_m3 = this.ListaToArray (lista = arguments, variavel = "MERC_VOLUME_MERCADORIAS");
				v_unidade_id = this.ListaToArray (lista = arguments, variavel = "MERC_UNIDADE_ID_MERCADORIAS");
				v_descricao = this.ListaToArray (lista = arguments, variavel = "MERC_DESCRICAO_MERCADORIAS");
				v_item_id = this.ListaToArray (lista = arguments, variavel = "MERC_ITEM_ID_MERCADORIAS");
				v_merc_excluir = this.ListDiff(lista1 = arguments.lista_deleted_MERCADORIAS, lista2 = ArrayToList(v_item_id));
			</cfscript>

			<!--- Excluir os itens --->
			<cfloop list="#v_merc_excluir#" delimiters="," index="l_item_id">
				<cfscript>
					this.del_item_crt (	conhecimento_id = arguments.conhecimento_id,
					                	item_id   = l_item_id);
				</cfscript>
			</cfloop>
			<cfloop from="1" to="#ArrayLen(v_descricao)#" index="count">
				<cfscript>
				if(not len(trim(v_item_id[count]))) {
					//caso o item_id seja nulo insere
					this.ins_item_crt(	conhecimento_id = arguments.conhecimento_id,
					               		produto_id = v_produto_id[count],
								  		num_especie = v_num_especie[count],
								 		quantidade = v_quantidade[count],
								 		peso_bruto = v_peso_bruto[count],
										peso_liquido = v_peso_liquido[count],
										m3 = v_m3[count],
										descricao = v_descricao[count]);
				} else {
					//senao altera
					this.upd_item_crt(	conhecimento_id = arguments.conhecimento_id,
					               		produto_id = v_produto_id[count],
								  		num_especie = v_num_especie[count],
								 		quantidade = v_quantidade[count],
								 		peso_bruto = v_peso_bruto[count],
										peso_liquido = v_peso_liquido[count],
										m3 = v_m3[count],
										descricao = v_descricao[count],
										item_id = v_item_id[count]);
				}
				</cfscript>
			</cfloop>			

			<!--- Alteraes dos Anexos --->
			<cfscript>
				v_descricao = this.ListaToArray (lista = arguments, variavel = "ANEXO_DESCRICAO_ANEXOS");
				v_item_id = this.ListaToArray (lista = arguments, variavel = "ANEXO_ID_ANEXOS");
				v_anexos_excluir = this.ListDiff(lista1 = arguments.lista_deleted_ANEXOS, lista2 = ArrayToList(v_item_id));
			</cfscript>
			<!--- Excluir os itens --->
			<cfloop list="#v_anexos_excluir#" delimiters="," index="l_item_id">
				<cfscript>
					this.del_anexo_crt (conhecimento_id = arguments.conhecimento_id,
					                	anexo_id   = l_item_id);
				</cfscript>
			</cfloop>
			<cfloop from="1" to="#ArrayLen(v_descricao)#" index="count">
				<cfscript>
				if(not len(trim(v_item_id[count]))) {
					//caso o item_id seja nulo insere
					this.ins_anexo_crt(	conhecimento_id = arguments.conhecimento_id,
					               		descricao = v_descricao[count]);
				} else {
					//senao altera
					this.upd_anexo_crt(	conhecimento_id = arguments.conhecimento_id,
					               		descricao = v_descricao[count],
										anexo_id = v_item_id[count]);
				}
				</cfscript>
			</cfloop>		

            
			<!--- Insercao de FRONTEIRAS --->
			<cfscript>
				v_controle_id  = this.ListaToArray (lista = arguments, variavel = "CONTROLE_ID_FRONTEIRAS");
				v_fronteira_id = this.ListaToArray (lista = arguments, variavel = "FRONTEIRA_ID_FRONTEIRAS");
				v_fronteira_excluir = this.ListDiff(lista1 = arguments.lista_deleted_FRONTEIRAS, lista2 = ArrayToList(v_fronteira_id));
			</cfscript>
			<!--- Excluir os itens --->
			<cfloop list="#v_fronteira_excluir#" delimiters="," index="l_item_id">
				<cfscript>
					this.del_crt_fronteira (controle_id = l_item_id);
				</cfscript>
			</cfloop>
			<cfloop from="1" to="#ArrayLen(v_controle_id)#" index="count">
				<cfscript>
				if(not len(trim(v_controle_id[count]))) {
					//caso o item_id seja nulo insere
					this.ins_crt_fronteira(	conhecimento_id = arguments.conhecimento_id,
					               		    fronteira_id = v_fronteira_id[count]);
				} else {
					//senao altera
					this.upd_crt_fronteira(	conhecimento_id = arguments.conhecimento_id,
					               		    fronteira_id    = v_fronteira_id[count],
										    controle_id     = v_controle_id[count]);
				}
				</cfscript>
			</cfloop>
            
            <!--- Alterao de Embarques --->
            <!---<cfscript>
				v_programacao_id			 = this.ListaToArray(lista = arguments, variavel = 'PROGRAMACAO_ID_AGENDAMENTO');
				v_embarque_id				 = this.ListaToArray(lista = arguments, variavel = 'EMBARQUE_ID_AGENDAMENTO');
				v_viagem_id     			 = this.ListaToArray(lista = arguments, variavel = 'VIAGEM_ID_AGENDAMENTO');
				v_cod_motorista 			 = this.ListaToArray(lista = arguments, variavel = 'COD_MOTORISTA_AGENDAMENTO');
				v_placa_cavalo 				 = this.ListaToArray(lista = arguments, variavel = 'PLACA_CAVALO_AGENDAMENTO');
				v_placa_carreta 			 = this.ListaToArray(lista = arguments, variavel = 'PLACA_CARRETA_AGENDAMENTO');
				v_data_saida      			 = this.ListaToArray(lista = arguments, variavel = 'DATA_SAIDA_AGENDAMENTO');
				v_previsao_chegada_fronteira = this.ListaToArray(lista = arguments, variavel = 'PREVISAO_CHEGADA_FRONTEIRA_AGENDAMENTO');
				v_fronteira_transbordo_id 	 = this.ListaToArray(lista = arguments, variavel = 'FRONTEIRA_TRANSBORDO_ID_AGENDAMENTO');
				v_observacao			     = this.ListaToArray(lista = arguments, variavel = 'OBSERVACAO_AGENDAMENTO');
				v_excluir	    			 = this.ListDiff(lista1 = arguments.lista_deleted_AGENDAMENTO, lista2 = ArrayToList(v_embarque_id));
			</cfscript>
            <cfloop list="#v_excluir#" delimiters="," index="e_id">
				<cfscript>
                    ret = this.del_viagem_embarque(EMBARQUE_ID = e_id);
                </cfscript>
                <cfif ret.erro>
                    <cfthrow object="#ret.mensagem#">
                </cfif>
            </cfloop>
			<cfloop from="1" to="#ArrayLen(v_embarque_id)#" index="count">
				<cfscript>
					if(Not Len(Trim(v_embarque_id[count]))) {
						ret = this.ins_viagem_embarque(PROGRAMACAO_ID			  = v_programacao_id[count],
													   VIAGEM_ID				  = v_viagem_id[count],
													   CONHECIMENTO_ID 		      = retorno.conhecimento_id,
													   MANIFESTO_ID			      = '',
													   COD_MOTORISTA 			  = v_cod_motorista[count],
													   PLACA_CAVALO 			  = v_placa_cavalo[count],
													   PLACA_CARRETA 			  = v_placa_carreta[count],
													   DATA_SAIDA				  = v_data_saida[count],
													   PREVISAO_CHEGADA_FRONTEIRA = v_previsao_chegada_fronteira[count],
													   FRONTEIRA_TRANSBORDO_ID    = v_fronteira_transbordo_id[count],
													   OBSERVACAO           	  = v_observacao[count]);
					}
					else {
						ret = this.upd_viagem_embarque(PROGRAMACAO_ID			  = v_programacao_id[count],
													   EMBARQUE_ID			      = v_embarque_id[count],
													   VIAGEM_ID				  = v_viagem_id[count],
													   COD_MOTORISTA 			  = v_cod_motorista[count],
													   PLACA_CAVALO 			  = v_placa_cavalo[count],
													   PLACA_CARRETA 			  = v_placa_carreta[count],
													   DATA_SAIDA				  = v_data_saida[count],
													   PREVISAO_CHEGADA_FRONTEIRA = v_previsao_chegada_fronteira[count],
													   FRONTEIRA_TRANSBORDO_ID    = v_fronteira_transbordo_id[count],
													   OBSERVACAO           	  = v_observacao[count]);
					}
				</cfscript>
                <cfif ret.erro>
                    <cfthrow object="#ret.mensagem#">
                </cfif>
			</cfloop>--->
            
            <!--- Gera conhecimento FORM --->
			<cfscript>
                if(arguments.regerar_impressao eq 1) {
                    set_impressao = this.ins_intc_conhecimento_form(conhecimento_id = arguments.conhecimento_id);
                }
            </cfscript>
           
            <cfif IsDefined("set_impressao") and set_impressao.erro>
                <cfthrow object="#set_impressao.mensagem#">
            </cfif>
                		
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat("C.R.T. alterado com sucesso!")>
		</cftransaction>
		<cfcatch>
			<cftransaction action="rollback"/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

<!--- 
-- PROPSITO
-- Vincula fronteira ao CRT
-- guto 03/07/2007 15:56:08 - CRIADO
--->
<cffunction name='ins_crt_fronteira' displayname='Vincula fronteira ao CRT' access='remote' returntype='Struct' output='true'>
	<cfargument name='CONHECIMENTO_ID' required='yes'>
	<cfargument name='FRONTEIRA_ID' required='yes'>
			<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_ins_crt_fronteira' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FRONTEIRA_ID'  value='#arguments.FRONTEIRA_ID#'  null='#iif(len(trim(arguments.FRONTEIRA_ID)), de('no'), de('yes'))#'>
			</cfstoredproc>
	<cfreturn structnew() />
</cffunction>

<!--- 
-- PROPSITO
-- Altera vinculo fronteira ao CRT
-- guto 03/07/2007 15:59:04 - CRIADO
--->
<cffunction name='upd_crt_fronteira' displayname='Altera vinculo fronteira ao CRT' access='remote' returntype='Struct' output='true'>
	<cfargument name='CONTROLE_ID' required='yes'>
	<cfargument name='CONHECIMENTO_ID' required='yes'>
	<cfargument name='FRONTEIRA_ID' required='yes'>
			<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_alt_crt_fronteira' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FRONTEIRA_ID'  value='#arguments.FRONTEIRA_ID#'  null='#iif(len(trim(arguments.FRONTEIRA_ID)), de('no'), de('yes'))#'>
			</cfstoredproc>
	<cfreturn structnew() />
</cffunction>

<!--- 
-- PROPSITO
-- Exclui vinculo fronteira ao CRT
-- guto 03/07/2007 15:59:32 - CRIADO
--->
<cffunction name='del_crt_fronteira' displayname='Exclui vinculo fronteira ao CRT' access='remote' returntype='Struct' output='true'>
	<cfargument name='CONTROLE_ID' required='yes'>
			<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_del_crt_fronteira' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
			</cfstoredproc>
	<cfreturn structnew() />
</cffunction>

<!--- 
-- PROPSITO
-- Exclui um conhecimento internacional
-- 06/12/2005 - criado
--->
<cffunction name="del_intc_conhecimento" displayname="Exclui um conhecimento internacional" access="remote" returntype="Struct" output="true">
	<cfargument name="CONHECIMENTO_ID" required="yes">

	<cftry>
		<cftransaction action="begin">
			<cfstoredproc procedure="fiscal.pkg_transp_internacional.prc_del_conhecimento" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_CONHECIMENTO_ID" value="#arguments.CONHECIMENTO_ID#">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat("C.R.T. excluido com sucesso!")>
		</cftransaction>
		<cfcatch>
			<cftransaction action="rollback"/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

<!--- 
-- PROPSITO
-- Cancela um conhecimento internacional
-- 06/12/2005 - criado
--->
<cffunction name="can_intc_conhecimento" displayname="Cancela um conhecimento internacional" access="remote" returntype="Struct" output="true">
	<cfargument name="CONHECIMENTO_ID" required="yes">
	<cfargument name="MOTIVO_CANCELAMENTO" required="no" default="">
	<cftry>
		<cftransaction action="begin">
			<cfstoredproc procedure="fiscal.pkg_transp_internacional.PRC_CRT_CANCELADO" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_CONHECIMENTO_ID" value="#arguments.CONHECIMENTO_ID#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_MOTIVO_CANCELAMENTO" value="#arguments.MOTIVO_CANCELAMENTO#">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat("C.R.T. cancelado com sucesso!")>
		</cftransaction>
		<cfcatch>
			<cftransaction action="rollback"/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

<!--- 
-- PROPSITO
-- Marca um conhecimento internacional como FATURADO sem gerar fatura. BAIXA
-- 28/03/2006 - criado
--->
<cffunction name="fat_intc_conhecimento" displayname="Fatura um conhecimento internacional" access="remote" returntype="Struct" output="true">
	<cfargument name="CONHECIMENTO_ID" required="yes">
	<cftry>
		<cftransaction action="begin">
			<cfloop list="#arguments.CONHECIMENTO_ID#" index="i" delimiters=",">
				<cfstoredproc procedure="fiscal.pkg_transp_internacional.PRC_CRT_FATURADO" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_CONHECIMENTO_ID" value="#i#">
				</cfstoredproc>
			</cfloop>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat("Dado baixa no C.R.T. com sucesso!")>
		</cftransaction>
		<cfcatch>
			<cftransaction action="rollback"/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>


<!--- 
-- PROPSITO
-- Insere uma mercadoria ao CRT
-- 06/12/2005 - criado
--->
<cffunction name="ins_item_crt" displayname="Insere uma mercadoria ao CRT" access="remote" returntype="Struct" output="true">
	<cfargument name="CONHECIMENTO_ID" required="yes">
	<cfargument name="PRODUTO_ID" required="yes">
	<cfargument name="NUM_ESPECIE" required="yes">
	<cfargument name="QUANTIDADE" required="yes">
	<cfargument name="PESO_BRUTO" required="yes">
	<cfargument name="PESO_LIQUIDO" required="yes">
	<cfargument name="M3" required="yes">
	<cfargument name="DESCRICAO" required="yes">
	<cfstoredproc procedure="fiscal.pkg_transp_internacional.prc_ins_crt_item" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_CONHECIMENTO_ID" value="#arguments.CONHECIMENTO_ID#">
		<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_ITEM_ID" null="yes">
		<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_PRODUTO_ID" value="#arguments.PRODUTO_ID#" null="#iif(len(trim(arguments.produto_id)), de('no'), de('yes'))#">
		<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_NUM_ESPECIE" value="#arguments.NUM_ESPECIE#" null="#iif(len(trim(arguments.num_especie)), de('no'), de('yes'))#">
		<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="P_QUANTIDADE" value="#arguments.QUANTIDADE#" null="#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#">
		<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="P_PESO_BRUTO" value="#arguments.PESO_BRUTO#" null="#iif(len(trim(arguments.PESO_BRUTO)), de('no'), de('yes'))#">
		<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="P_PESO_LIQUIDO" value="#arguments.PESO_LIQUIDO#" null="#iif(len(trim(arguments.PESO_LIQUIDO)), de('no'), de('yes'))#">
		<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="P_M3" value="#arguments.M3#" null="#iif(len(trim(arguments.m3)), de('no'), de('yes'))#">
		<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_UNIDADE_ID" value="Kg">
		<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DESCRICAO" value="#arguments.DESCRICAO#">
	</cfstoredproc>
	<cfreturn StructNew() />
</cffunction>

<!--- 
-- PROPSITO
-- Altera uma mercadoria do CRT
-- 06/12/2005 - criado
--->
<cffunction name="upd_item_crt" displayname="Altera uma mercadoria do CRT" access="remote" returntype="Struct" output="true">
	<cfargument name="CONHECIMENTO_ID" required="yes">
	<cfargument name="ITEM_ID" required="yes">
	<cfargument name="PRODUTO_ID" required="yes">
	<cfargument name="NUM_ESPECIE" required="yes">
	<cfargument name="QUANTIDADE" required="yes">
	<cfargument name="PESO_BRUTO" required="yes">
	<cfargument name="PESO_LIQUIDO" required="yes">
	<cfargument name="M3" required="yes">
	<cfargument name="DESCRICAO" required="yes">
	<cfstoredproc procedure="fiscal.pkg_transp_internacional.prc_alt_crt_item" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_CONHECIMENTO_ID" value="#arguments.CONHECIMENTO_ID#">
		<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_ITEM_ID" value="#arguments.ITEM_ID#">
		<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_PRODUTO_ID" value="#arguments.PRODUTO_ID#" null="#iif(len(trim(arguments.produto_id)), de('no'), de('yes'))#">
		<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_NUM_ESPECIE" value="#arguments.NUM_ESPECIE#" null="#iif(len(trim(arguments.num_especie)), de('no'), de('yes'))#">
		<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="P_QUANTIDADE" value="#arguments.QUANTIDADE#" null="#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#">
		<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="P_PESO_BRUTO" value="#arguments.PESO_BRUTO#" null="#iif(len(trim(arguments.PESO_BRUTO)), de('no'), de('yes'))#">
		<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="P_PESO_LIQUIDO" value="#arguments.PESO_LIQUIDO#" null="#iif(len(trim(arguments.PESO_LIQUIDO)), de('no'), de('yes'))#">
		<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="P_M3" value="#arguments.M3#" null="#iif(len(trim(arguments.m3)), de('no'), de('yes'))#">
		<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_UNIDADE_ID" value="Kg">
		<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DESCRICAO" value="#arguments.DESCRICAO#">
	</cfstoredproc>
	<cfreturn StructNew() />
</cffunction>

<!--- 
-- PROPSITO
-- Exclui uma mercadoria do CRT
-- 06/12/2005 - criado
--->
<cffunction name="del_item_crt" displayname="Exclui uma mercadoria do CRT" access="remote" returntype="Struct" output="true">
	<cfargument name="CONHECIMENTO_ID" required="yes">
	<cfargument name="ITEM_ID" required="yes">
	<cfstoredproc procedure="fiscal.pkg_transp_internacional.prc_del_crt_item" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_CONHECIMENTO_ID" value="#arguments.CONHECIMENTO_ID#">
		<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_ITEM_ID" value="#arguments.ITEM_ID#">
	</cfstoredproc>
	<cfreturn StructNew() />
</cffunction>


<!--- 
-- PROPSITO
-- Insere um custo ao CRT
-- 06/12/2005 - criado
--->
<cffunction name="ins_custo_crt" displayname="Insere um custo ao CRT" access="remote" returntype="Struct" output="true">
	<cfargument name="CONHECIMENTO_ID" required="yes">
	<cfargument name="DESCRICAO" required="yes">
	<cfargument name="VALOR_ORIGEM" required="yes">
	<cfargument name="VALOR_ORIGEM_COD_MOEDA" required="yes">
	<cfargument name="VALOR_DESTINO" required="yes">
	<cfargument name="VALOR_DESTINO_COD_MOEDA" required="yes">
	<cfstoredproc procedure="fiscal.pkg_transp_internacional.prc_ins_crt_custo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_CONHECIMENTO_ID" value="#arguments.CONHECIMENTO_ID#">
		<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_ITEM_ID" null="yes">
		<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DESCRICAO" value="#arguments.DESCRICAO#">
		<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="P_VALOR_ORIGEM" value="#arguments.VALOR_ORIGEM#" null="#iif(len(trim(arguments.VALOR_ORIGEM)), de('no'), de('yes'))#">
		<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_VALOR_ORIGEM_COD_MOEDA" value="#arguments.VALOR_ORIGEM_COD_MOEDA#" null="#iif(len(trim(arguments.VALOR_ORIGEM_COD_MOEDA)), de('no'), de('yes'))#">
		<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="P_VALOR_DESTINO" value="#arguments.VALOR_DESTINO#" null="#iif(len(trim(arguments.VALOR_DESTINO)), de('no'), de('yes'))#">
		<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_VALOR_DESTINO_COD_MOEDA" value="#arguments.VALOR_DESTINO_COD_MOEDA#" null="#iif(len(trim(arguments.VALOR_DESTINO_COD_MOEDA)), de('no'), de('yes'))#">
	</cfstoredproc>
	<cfreturn StructNew() />
</cffunction>

<!--- 
-- PROPSITO
-- Altera um custo do CRT
-- 06/12/2005 - criado
--->
<cffunction name="upd_custo_crt" displayname="Altera um custo do CRT" access="remote" returntype="Struct" output="true">
	<cfargument name="CONHECIMENTO_ID" required="yes">
	<cfargument name="ITEM_ID" required="yes">
	<cfargument name="DESCRICAO" required="yes">
	<cfargument name="VALOR_ORIGEM" required="yes">
	<cfargument name="VALOR_ORIGEM_COD_MOEDA" required="yes">
	<cfargument name="VALOR_DESTINO" required="yes">
	<cfargument name="VALOR_DESTINO_COD_MOEDA" required="yes">
	<cfstoredproc procedure="fiscal.pkg_transp_internacional.prc_alt_crt_custo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_CONHECIMENTO_ID" value="#arguments.CONHECIMENTO_ID#">
		<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_ITEM_ID" value="#arguments.ITEM_ID#" null="#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#">
		<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DESCRICAO" value="#arguments.DESCRICAO#">
		<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="P_VALOR_ORIGEM" value="#arguments.VALOR_ORIGEM#" null="#iif(len(trim(arguments.VALOR_ORIGEM)), de('no'), de('yes'))#">
		<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_VALOR_ORIGEM_COD_MOEDA" value="#arguments.VALOR_ORIGEM_COD_MOEDA#" null="#iif(len(trim(arguments.VALOR_ORIGEM_COD_MOEDA)), de('no'), de('yes'))#">
		<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="P_VALOR_DESTINO" value="#arguments.VALOR_DESTINO#" null="#iif(len(trim(arguments.VALOR_DESTINO)), de('no'), de('yes'))#">
		<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_VALOR_DESTINO_COD_MOEDA" value="#arguments.VALOR_DESTINO_COD_MOEDA#" null="#iif(len(trim(arguments.VALOR_DESTINO_COD_MOEDA)), de('no'), de('yes'))#">
	</cfstoredproc>
	<cfreturn StructNew() />
</cffunction>

<!--- 
-- PROPSITO
-- Exclui um custo do CRT
-- 06/12/2005 - criado
--->
<cffunction name="del_custo_crt" displayname="Exclui um custo do CRT" access="remote" returntype="Struct" output="true">
	<cfargument name="CONHECIMENTO_ID" required="yes">
	<cfargument name="ITEM_ID" required="yes">
	<cfstoredproc procedure="fiscal.pkg_transp_internacional.prc_del_crt_custo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_CONHECIMENTO_ID" value="#arguments.CONHECIMENTO_ID#">
		<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_ITEM_ID" value="#arguments.ITEM_ID#">
	</cfstoredproc>
	<cfreturn StructNew() />
</cffunction>


<!--- 
-- PROPSITO
-- Insere um anexo ao CRT
-- 06/12/2005 - criado
--->
<cffunction name="ins_anexo_crt" displayname="Insere um anexo ao CRT" access="remote" returntype="Struct" output="true">
	<cfargument name="CONHECIMENTO_ID" required="yes">
	<cfargument name="DESCRICAO" required="yes">
	<cfstoredproc procedure="fiscal.pkg_transp_internacional.prc_ins_crt_anexo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_CONHECIMENTO_ID" value="#arguments.CONHECIMENTO_ID#">
		<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_ANEXO_ID" null="yes">
		<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DESCRICAO" value="#arguments.DESCRICAO#">
	</cfstoredproc>
	<cfreturn StructNew() />
</cffunction>

<!--- 
-- PROPSITO
-- Altera um anexo do CRT
-- 06/12/2005 - criado
--->
<cffunction name="upd_anexo_crt" displayname="Altera um anexo do CRT" access="remote" returntype="Struct" output="true">
	<cfargument name="CONHECIMENTO_ID" required="yes">
	<cfargument name="ANEXO_ID" required="yes">
	<cfargument name="DESCRICAO" required="yes">
	<cfstoredproc procedure="fiscal.pkg_transp_internacional.prc_alt_crt_anexo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_CONHECIMENTO_ID" value="#arguments.CONHECIMENTO_ID#">
		<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_ANEXO_ID" value="#arguments.ANEXO_ID#">
		<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DESCRICAO" value="#arguments.DESCRICAO#">
	</cfstoredproc>
	<cfreturn StructNew() />
</cffunction>


<!--- 
-- PROPSITO
-- Exclui um anexo do CRT
-- 06/12/2005 - criado
--->
<cffunction name="del_anexo_crt" displayname="Exclui um anexo do CRT" access="remote" returntype="Struct" output="true">
	<cfargument name="CONHECIMENTO_ID" required="yes">
	<cfargument name="ANEXO_ID" required="yes">
	<cfstoredproc procedure="fiscal.pkg_transp_internacional.prc_del_crt_anexo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_CONHECIMENTO_ID" value="#arguments.CONHECIMENTO_ID#">
		<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_ANEXO_ID" value="#arguments.ANEXO_ID#">
	</cfstoredproc>
	<cfreturn StructNew() />
</cffunction>


	<!--- 
	-- PROPSITO
	-- Insere novo INCOTERM
	-- FABIOG 30/09/2011 15:11:35 - CRIADO
	--->
	<cffunction name='ins_incoterm' displayname='Insere novo INCOTERM' access='remote' returntype='Struct' output='true'>
		<cfargument name='CODIGO' required='yes'>
		<cfargument name='SIGNIFICADO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_ins_incoterm' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CODIGO'  value='#arguments.CODIGO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SIGNIFICADO'  value='#arguments.SIGNIFICADO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Incoterm inserido com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
	<!--- 
	-- PROPSITO
	-- Altera dados do Incoterm
	-- FABIOG 30/09/2011 15:13:11 - CRIADO
	--->
	<cffunction name='upd_incoterm' displayname='Altera dados do Incoterm' access='remote' returntype='Struct' output='true'>
		<cfargument name='INCOTERM_ID' required='yes'>
		<cfargument name='CODIGO' required='yes'>
		<cfargument name='SIGNIFICADO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_upd_incoterm' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_INCOTERM_ID'  value='#arguments.INCOTERM_ID#'  null='#iif(len(trim(arguments.INCOTERM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CODIGO'  value='#arguments.CODIGO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SIGNIFICADO'  value='#arguments.SIGNIFICADO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Incoterm alterado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui incoterm
	-- FABIOG 30/09/2011 15:14:09 - CRIADO
	--->
	<cffunction name='del_incoterm' displayname='Exclui incoterm' access='remote' returntype='Struct' output='true'>
		<cfargument name='INCOTERM_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_del_incoterm' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_INCOTERM_ID'  value='#arguments.INCOTERM_ID#'  null='#iif(len(trim(arguments.INCOTERM_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Incoterm excludo com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Insere nova Rota
	-- FABIOG 30/09/2011 15:31:27 - CRIADO
	--->
	<cffunction name='ins_intc_manifesto_rota' displayname='Insere nova Rota' access='remote' returntype='Struct' output='true'>
		<cfargument name='NOME_ROTA' required='yes'>
		<cfargument name='ROTA' required='yes'>
		<cfargument name='PRAZO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_ins_intc_manifesto_rota' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME_ROTA'  value='#arguments.NOME_ROTA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROTA'  value='#arguments.ROTA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRAZO'  value='#arguments.PRAZO#'  null='#iif(len(trim(arguments.PRAZO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Rota inserida com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Altera dados da rota
	-- FABIOG 30/09/2011 15:32:55 - CRIADO
	--->
	<cffunction name='upd_intc_manifesto_rota' displayname='Altera dados da rota' access='remote' returntype='Struct' output='true'>
		<cfargument name='ROTA_ID' required='yes'>
		<cfargument name='NOME_ROTA' required='yes'>
		<cfargument name='ROTA' required='yes'>
		<cfargument name='PRAZO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_upd_intc_manifesto_rota' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ROTA_ID'  value='#arguments.ROTA_ID#'  null='#iif(len(trim(arguments.ROTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME_ROTA'  value='#arguments.NOME_ROTA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROTA'  value='#arguments.ROTA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRAZO'  value='#arguments.PRAZO#'  null='#iif(len(trim(arguments.PRAZO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Rota alterada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui rota
	-- FABIOG 30/09/2011 15:34:40 - CRIADO
	--->
	<cffunction name='del_intc_manifesto_rota' displayname='Exclui rota' access='remote' returntype='Struct' output='true'>
		<cfargument name='ROTA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_del_intc_manifesto_rota' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ROTA_ID'  value='#arguments.ROTA_ID#'  null='#iif(len(trim(arguments.ROTA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Rota excluda com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere um novo manifesto internacional (MIC/DTA)
	-- CRISTOFER 13/12/2005 - criado
	--->
	<cffunction name='ins_intc_manifesto' displayname='Insere um novo manifesto internacional (MIC/DTA)' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUMERO' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='TRANSITO_ADUANEIRO' required='no' default="0">
		<cfargument name='COD_TRANSPORTADOR' required='yes'>
		<cfargument name='TRANSP_NOME' required='yes'>
		<cfargument name='TRANSP_ENDERECO' required='yes'>
		<cfargument name='TRANSP_MUNICIPIO_ID' required='yes'>
		<cfargument name='TRANSP_DADOS_ADICIONAIS' required='yes'>
		<cfargument name='TRANSP_CNPJ_CPF' required='yes'>
		<cfargument name='ALFANDEGA_ORIGEM_ID' required='yes'>
		<cfargument name='ALFANDEGA_DESTINO_ID' required='yes'>		
		<cfargument name='DESTINO_LOCAL' required='yes'>
		<cfargument name='DESTINO_MUNICIPIO_ID' required='yes'>
		<cfargument name='VEIC_ORIG_PROP_COD_PESSOA' required='yes'>
		<cfargument name='VEIC_ORIG_PROP_NOME' required='yes'>
		<cfargument name='VEIC_ORIG_PROP_ENDERECO' required='yes'>
		<cfargument name='VEIC_ORIG_PROP_MUNICIPIO_ID' required='yes'>
		<cfargument name='VEIC_ORIG_PROP_CNPJ_CPF' required='yes'>
		<cfargument name='VEIC_ORIG_PLACA_CONTROLE' required='yes'>
		<cfargument name='VEIC_ORIG_MARCA' required='yes'>
		<cfargument name='VEIC_ORIG_CHASSIS' required='yes'>
		<cfargument name='VEIC_ORIG_CAPACIDADE' required='yes'>
		<cfargument name='VEIC_ORIG_ANO' required='yes'>
		<cfargument name='VEIC_ORIG_TIPO' required='yes'>
		<cfargument name='VEIC_ORIG_PLACA_REFERENCIA' required='no' default=""> 
		<cfargument name='VEIC_ORIG_MOT_COD_PESSOA' required='yes'>
        <cfargument name='VEIC_ORIG_PROP_DADOS_ADICIONAIS' required='no' default="">
		<cfargument name='VEIC_SUBST_PROP_COD_PESSOA' required='no' default="">
		<cfargument name='VEIC_SUBST_PROP_NOME' required='no' default="">
		<cfargument name='VEIC_SUBST_PROP_ENDERECO' required='no' default="">
		<cfargument name='VEIC_SUBST_PROP_MUNICIPIO_ID' required='no' default="">
		<cfargument name='VEIC_SUBST_PROP_CNPJ_CPF' required='no' default="">
		<cfargument name='VEIC_SUBST_PLACA_CONTROLE' required='no' default="">
		<cfargument name='VEIC_SUBST_MARCA' required='no' default="">
		<cfargument name='VEIC_SUBST_CHASSIS' required='no' default="">
		<cfargument name='VEIC_SUBST_CAPACIDADE' required='no' default="">
		<cfargument name='VEIC_SUBST_ANO' required='no' default="">
		<cfargument name='VEIC_SUBST_TIPO' required='no' default="">
		<cfargument name='VEIC_SUBST_PLACA_REFERENCIA' required='no' default="">
		<cfargument name='VEIC_SUBST_MOT_COD_PESSOA' required='no' default="">
		<cfargument name='NUM_DTA_ROTA' required='yes'>
		<cfargument name='ROTA_ID' required='yes'>
		<cfargument name='COMPLEMENTO' required='yes'>
		<cfargument name='MANIFESTO_ID' required='yes'>
		<cfargument name='NUM_ROMANEIO' required='no' default="">
		<cfargument name='ROMANEIO_ITEM_ID' required='no' default="">
        <cfargument name='EN_LASTRE' required='no' default="0">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_ins_manifesto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_NUMERO_COD_PAIS'  value='#listGetAt(arguments.NUMERO, 1, '.')#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_NUMERO_CERTIFICADO'  value='#listGetAt(arguments.NUMERO, 2, '.')#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_NUMERO_SEQUENCIAL'  value='#listGetAt(arguments.NUMERO, 3, '.')#'  null='#iif(len(trim(listGetAt(arguments.NUMERO, 3, '.'))), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_TRANSITO_ADUANEIRO'  value='#arguments.TRANSITO_ADUANEIRO#'  null='#iif(len(trim(arguments.TRANSITO_ADUANEIRO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_COD_TRANSPORTADOR'  value='#arguments.COD_TRANSPORTADOR#'  null='#iif(len(trim(arguments.COD_TRANSPORTADOR)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_TRANSP_NOME'  value='#arguments.TRANSP_NOME#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_TRANSP_ENDERECO'  value='#arguments.TRANSP_ENDERECO#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_TRANSP_MUNICIPIO_ID'  value='#arguments.TRANSP_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.TRANSP_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_TRANSP_DADOS_ADICIONAIS'  value='#arguments.TRANSP_DADOS_ADICIONAIS#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_TRANSP_CNPJ_CPF'  value='#arguments.TRANSP_CNPJ_CPF#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_ALFANDEGA_ORIGEM_ID'  value='#arguments.ALFANDEGA_ORIGEM_ID#'  null='#iif(len(trim(arguments.ALFANDEGA_ORIGEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_DESTINO_LOCAL'  value='#arguments.DESTINO_LOCAL#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_DESTINO_MUNICIPIO_ID'  value='#arguments.DESTINO_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.DESTINO_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_VEIC_ORIG_PROP_COD_PESSOA'  value='#arguments.VEIC_ORIG_PROP_COD_PESSOA#'  null='#iif(len(trim(arguments.VEIC_ORIG_PROP_COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_ORIG_PROP_NOME'  value='#arguments.VEIC_ORIG_PROP_NOME#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_ORIG_PROP_ENDERECO'  value='#arguments.VEIC_ORIG_PROP_ENDERECO#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_VEIC_ORIG_PROP_MUNICIPIO_ID'  value='#arguments.VEIC_ORIG_PROP_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.VEIC_ORIG_PROP_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_ORIG_PROP_CNPJ_CPF'  value='#arguments.VEIC_ORIG_PROP_CNPJ_CPF#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_ORIG_PLACA_CONTROLE'  value='#UCase(Replace(arguments.VEIC_ORIG_PLACA_CONTROLE,'-',''))#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_ORIG_MARCA'  value='#arguments.VEIC_ORIG_MARCA#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_ORIG_CHASSIS'  value='#arguments.VEIC_ORIG_CHASSIS#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_VEIC_ORIG_CAPACIDADE'  value='#arguments.VEIC_ORIG_CAPACIDADE#'  null='#iif(len(trim(arguments.VEIC_ORIG_CAPACIDADE)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_VEIC_ORIG_ANO'  value='#arguments.VEIC_ORIG_ANO#'  null='#iif(len(trim(arguments.VEIC_ORIG_ANO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_VEIC_ORIG_TIPO'  value='#arguments.VEIC_ORIG_TIPO#'  null='#iif(len(trim(arguments.VEIC_ORIG_TIPO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_ORIG_PLACA_REFERENCIA'  value='#arguments.VEIC_ORIG_PLACA_REFERENCIA#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_VEIC_ORIG_MOT_COD_PESSOA'  value='#arguments.VEIC_ORIG_MOT_COD_PESSOA#'  null='#iif(len(trim(arguments.VEIC_ORIG_MOT_COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_ORIG_PROP_DADOS_ADIC'  value='#arguments.VEIC_ORIG_PROP_DADOS_ADICIONAIS#' >
                    <cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_VEIC_SUBST_PROP_COD_PESSOA'  value='#arguments.VEIC_SUBST_PROP_COD_PESSOA#'  null='#iif(len(trim(arguments.VEIC_SUBST_PROP_COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_SUBST_PROP_NOME'  value='#arguments.VEIC_SUBST_PROP_NOME#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_SUBST_PROP_ENDERECO'  value='#arguments.VEIC_SUBST_PROP_ENDERECO#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_VEIC_SUBST_PROP_MUNICIPIO_ID'  value='#arguments.VEIC_SUBST_PROP_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.VEIC_SUBST_PROP_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_SUBST_PROP_CNPJ_CPF'  value='#arguments.VEIC_SUBST_PROP_CNPJ_CPF#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_SUBST_PLACA_CONTROLE'  value='#UCase(Replace(arguments.VEIC_SUBST_PLACA_CONTROLE,'-',''))#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_SUBST_MARCA'  value='#arguments.VEIC_SUBST_MARCA#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_SUBST_CHASSIS'  value='#arguments.VEIC_SUBST_CHASSIS#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_VEIC_SUBST_CAPACIDADE'  value='#arguments.VEIC_SUBST_CAPACIDADE#'  null='#iif(len(trim(arguments.VEIC_SUBST_CAPACIDADE)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_VEIC_SUBST_ANO'  value='#arguments.VEIC_SUBST_ANO#'  null='#iif(len(trim(arguments.VEIC_SUBST_ANO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_VEIC_SUBST_TIPO'  value='#arguments.VEIC_SUBST_TIPO#'  null='#iif(len(trim(arguments.VEIC_SUBST_TIPO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_SUBST_PLACA_REFERENCIA'  value='#arguments.VEIC_SUBST_PLACA_REFERENCIA#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_VEIC_SUBST_MOT_COD_PESSOA'  value='#arguments.VEIC_SUBST_MOT_COD_PESSOA#'  null='#iif(len(trim(arguments.VEIC_SUBST_MOT_COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_NUM_DTA_ROTA'  value='#arguments.NUM_DTA_ROTA#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_ROTA_ID'  value='#arguments.ROTA_ID#'  null='#iif(len(trim(arguments.ROTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_COMPLEMENTO'  value='#arguments.COMPLEMENTO#' >
					<cfprocparam type='inout' cfsqltype='cf_sql_integer' dbvarname='P_MANIFESTO_ID'  variable='retorno.MANIFESTO_ID'  null='yes'>
					<cfprocparam type='out' cfsqltype='cf_sql_varchar' dbvarname='P_ROWID' variable='retorno.ROWID' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_ITEM_ID'  value='#arguments.ROMANEIO_ITEM_ID#'  null='#iif(len(trim(arguments.ROMANEIO_ITEM_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_EN_LASTRE'  value='#arguments.EN_LASTRE#'  null='#iif(len(trim(arguments.EN_LASTRE)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset arguments.manifesto_id = retorno.manifesto_id>
				<!--- Inseres dos Items --->
				<cfscript>
					v_nro_crt = 		this.ListaToArray (lista = arguments, variavel = "ITEM_NUMERO_CRT_ITEMS");
					v_conhecimento_id = this.ListaToArray (lista = arguments, variavel = "ITEM_CONHECIMENTO_ID_ITEMS");
					v_id = 				this.ListaToArray (lista = arguments, variavel = "ITEM_ID_ITEMS");
					v_item_id =			this.ListaToArray (lista = arguments, variavel = "ITEM_IT_ID_ITEMS");
					v_quantidade = 		this.ListaToArray (lista = arguments, variavel = "ITEM_QUANTIDADE_ITEMS");
					v_peso_bruto = 		this.ListaToArray (lista = arguments, variavel = "ITEM_PESO_BRUTO_ITEMS");
					v_peso_liquido = 	this.ListaToArray (lista = arguments, variavel = "ITEM_PESO_LIQUIDO_ITEMS");
					v_valor_total = 	this.ListaToArray (lista = arguments, variavel = "ITEM_VALOR_TOTAL_ITEMS");
					v_seguro = 			this.ListaToArray (lista = arguments, variavel = "ITEM_SEGURO_ITEMS");
					v_num_especie = 	this.ListaToArray (lista = arguments, variavel = "ITEM_NUM_ESPECIE_ITEMS");
					v_descricao = 		this.ListaToArray (lista = arguments, variavel = "ITEM_DESCRICAO_ITEMS");
					v_ncm = 			this.ListaToArray (lista = arguments, variavel = "ITEM_NCM_ITEMS");
					v_valor_fot = 		this.ListaToArray (lista = arguments, variavel = "ITEM_VALOR_FOT_ITEMS");
					v_nro_lacres = 		this.ListaToArray (lista = arguments, variavel = "ITEM_NRO_LACRES_ITEMS");
					v_pais_id_origem =  this.ListaToArray (lista = arguments, variavel = "ITEM_PAIS_ID_ORIGEM");
					v_cod_remetente = 	this.ListaToArray (lista = arguments, variavel = "COD_REMETENTE_ITEMS");
					v_rem_nome =		this.ListaToArray (lista = arguments, variavel = "REM_NOME_ITEMS");
					v_rem_local =		this.ListaToArray (lista = arguments, variavel = "REM_MUNICIPIO_UF_PAIS_ITEMS");
					v_rem_municipio_id =this.ListaToArray (lista = arguments, variavel = "REM_MUNICIPIO_ID_ITEMS");
					v_anexos = 			this.ListaToArray (lista = arguments, variavel = "ITEM_ANEXOS_ITEMS");
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_descricao)#" index="count">
					<cfscript>
						this.ins_intc_manifesto_item(	manifesto_id 	= arguments.manifesto_id,
														conhecimento_id = v_conhecimento_id[count],
														item_id 		= v_id[count],
													    alfandega_destino_id  = arguments.alfandega_destino_id,
														quantidade		= v_quantidade[count],
														peso_bruto		= v_peso_bruto[count],
														peso_liquido	= v_peso_liquido[count],
														valor_total		= v_valor_total[count],
														valor_seguro	= v_seguro[count],
														num_especie		= v_num_especie[count],
														mercadorias		= v_descricao[count],
														numero_lacres	= v_nro_lacres[count],
														valor_fot		= v_valor_fot[count],
														ncm				= v_ncm[count],
														pais_id_origem  = v_pais_id_origem[count],
														anexo			= v_anexos[count],
														cod_remetente	= v_cod_remetente[count],
														rem_nome		= v_rem_nome[count],
														rem_local		= v_rem_local[count],
														rem_municipio_id= v_rem_municipio_id[count],
														en_lastre		= arguments.en_lastre);
					</cfscript>
				</cfloop>				
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('MIC/DTA inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
		
	<!--- 
	-- PROPSITO
	-- Altera os dados do manifesto internacional (MIC/DTA)
	-- CRISTOFER 13/12/2005 - criado
	--->
	<cffunction name='upd_intc_manifesto' displayname='Altera os dados do manifesto internacional (MIC/DTA)' access='remote' returntype='Struct' output='true'>
		<cfargument name='MANIFESTO_ID' required='yes'>
		<cfargument name='NUMERO' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='TRANSITO_ADUANEIRO' required='no' default="0">
		<cfargument name='COD_TRANSPORTADOR' required='yes'>
		<cfargument name='TRANSP_NOME' required='yes'>
		<cfargument name='TRANSP_ENDERECO' required='yes'>
		<cfargument name='TRANSP_MUNICIPIO_ID' required='yes'>
		<cfargument name='TRANSP_DADOS_ADICIONAIS' required='yes'>
		<cfargument name='TRANSP_CNPJ_CPF' required='yes'>
		<cfargument name='ALFANDEGA_ORIGEM_ID' required='yes'>
		<cfargument name='DESTINO_LOCAL' required='yes'>
		<cfargument name='DESTINO_MUNICIPIO_ID' required='yes'>
		<cfargument name='VEIC_ORIG_PROP_COD_PESSOA' required='yes'>
		<cfargument name='VEIC_ORIG_PROP_NOME' required='yes'>
		<cfargument name='VEIC_ORIG_PROP_ENDERECO' required='yes'>
		<cfargument name='VEIC_ORIG_PROP_MUNICIPIO_ID' required='yes'>
		<cfargument name='VEIC_ORIG_PROP_CNPJ_CPF' required='yes'>
		<cfargument name='VEIC_ORIG_PLACA_CONTROLE' required='yes'>
		<cfargument name='VEIC_ORIG_MARCA' required='yes'>
		<cfargument name='VEIC_ORIG_CHASSIS' required='yes'>
		<cfargument name='VEIC_ORIG_CAPACIDADE' required='yes'>
		<cfargument name='VEIC_ORIG_ANO' required='yes'>
		<cfargument name='VEIC_ORIG_TIPO' required='yes'>
		<cfargument name='VEIC_ORIG_PLACA_REFERENCIA' required='yes'>
		<cfargument name='VEIC_ORIG_MOT_COD_PESSOA' required='yes'>
        <cfargument name='VEIC_ORIG_PROP_DADOS_ADICIONAIS' required='no' default="">
		<cfargument name='VEIC_SUBST_PROP_COD_PESSOA' required='no' default="">
		<cfargument name='VEIC_SUBST_PROP_NOME' required='no' default="">
		<cfargument name='VEIC_SUBST_PROP_ENDERECO' required='no' default="">
		<cfargument name='VEIC_SUBST_PROP_MUNICIPIO_ID' required='no' default="">
		<cfargument name='VEIC_SUBST_PROP_CNPJ_CPF' required='no' default="">
		<cfargument name='VEIC_SUBST_PLACA_CONTROLE' required='no' default="">
		<cfargument name='VEIC_SUBST_MARCA' required='no' default="">
		<cfargument name='VEIC_SUBST_CHASSIS' required='no' default="">
		<cfargument name='VEIC_SUBST_CAPACIDADE' required='no' default="">
		<cfargument name='VEIC_SUBST_ANO' required='no' default="">
		<cfargument name='VEIC_SUBST_TIPO' required='no' default="">
		<cfargument name='VEIC_SUBST_PLACA_REFERENCIA' required='no' default="">
		<cfargument name='VEIC_SUBST_MOT_COD_PESSOA' required='no' default="">
		<cfargument name='NUM_DTA_ROTA' required='yes'>
		<cfargument name='ROTA_ID' required='yes'>
		<cfargument name='COMPLEMENTO' required='yes'>
		<cfargument name='NUM_ROMANEIO' required='no' default="">
		<cfargument name='ROMANEIO_ITEM_ID' required='no' default="">
        <cfargument name='EN_LASTRE' required='no' default="0">
        <cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_alt_manifesto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_MANIFESTO_ID'  value='#arguments.MANIFESTO_ID#'  null='#iif(len(trim(arguments.MANIFESTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_NUMERO_COD_PAIS'  value='#ListGetAt(arguments.NUMERO, 1, '.')#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_NUMERO_CERTIFICADO'  value='#ListGetAt(arguments.NUMERO, 2, '.')#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_NUMERO_SEQUENCIAL'  value='#ListGetAt(arguments.NUMERO, 3, '.')#'  null='#iif(len(trim(ListGetAt(arguments.NUMERO, 3, '.'))), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_TRANSITO_ADUANEIRO'  value='#arguments.TRANSITO_ADUANEIRO#'  null='#iif(len(trim(arguments.TRANSITO_ADUANEIRO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_COD_TRANSPORTADOR'  value='#arguments.COD_TRANSPORTADOR#'  null='#iif(len(trim(arguments.COD_TRANSPORTADOR)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_TRANSP_NOME'  value='#arguments.TRANSP_NOME#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_TRANSP_ENDERECO'  value='#arguments.TRANSP_ENDERECO#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_TRANSP_MUNICIPIO_ID'  value='#arguments.TRANSP_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.TRANSP_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_TRANSP_DADOS_ADICIONAIS'  value='#arguments.TRANSP_DADOS_ADICIONAIS#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_TRANSP_CNPJ_CPF'  value='#arguments.TRANSP_CNPJ_CPF#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_ALFANDEGA_ORIGEM_ID'  value='#arguments.ALFANDEGA_ORIGEM_ID#'  null='#iif(len(trim(arguments.ALFANDEGA_ORIGEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_DESTINO_LOCAL'  value='#arguments.DESTINO_LOCAL#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_DESTINO_MUNICIPIO_ID'  value='#arguments.DESTINO_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.DESTINO_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_VEIC_ORIG_PROP_COD_PESSOA'  value='#arguments.VEIC_ORIG_PROP_COD_PESSOA#'  null='#iif(len(trim(arguments.VEIC_ORIG_PROP_COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_ORIG_PROP_NOME'  value='#arguments.VEIC_ORIG_PROP_NOME#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_ORIG_PROP_ENDERECO'  value='#arguments.VEIC_ORIG_PROP_ENDERECO#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_VEIC_ORIG_PROP_MUNICIPIO_ID'  value='#arguments.VEIC_ORIG_PROP_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.VEIC_ORIG_PROP_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_ORIG_PROP_CNPJ_CPF'  value='#arguments.VEIC_ORIG_PROP_CNPJ_CPF#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_ORIG_PLACA_CONTROLE'  value='#UCase(Replace(arguments.VEIC_ORIG_PLACA_CONTROLE,'-',''))#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_ORIG_MARCA'  value='#arguments.VEIC_ORIG_MARCA#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_ORIG_CHASSIS'  value='#arguments.VEIC_ORIG_CHASSIS#' >
					<cfprocparam type='in' cfsqltype='cf_sql_double'  dbvarname='P_VEIC_ORIG_CAPACIDADE'  value='#arguments.VEIC_ORIG_CAPACIDADE#'  null='#iif(len(trim(arguments.VEIC_ORIG_CAPACIDADE)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_VEIC_ORIG_ANO'  value='#arguments.VEIC_ORIG_ANO#'  null='#iif(len(trim(arguments.VEIC_ORIG_ANO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_VEIC_ORIG_TIPO'  value='#arguments.VEIC_ORIG_TIPO#'  null='#iif(len(trim(arguments.VEIC_ORIG_TIPO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_ORIG_PLACA_REFERENCIA'  value='#arguments.VEIC_ORIG_PLACA_REFERENCIA#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_VEIC_ORIG_MOT_COD_PESSOA'  value='#arguments.VEIC_ORIG_MOT_COD_PESSOA#'  null='#iif(len(trim(arguments.VEIC_ORIG_MOT_COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_ORIG_PROP_DADOS_ADIC'  value='#arguments.VEIC_ORIG_PROP_DADOS_ADICIONAIS#' >
                    <cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_VEIC_SUBST_PROP_COD_PESSOA'  value='#arguments.VEIC_SUBST_PROP_COD_PESSOA#'  null='#iif(len(trim(arguments.VEIC_SUBST_PROP_COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_SUBST_PROP_NOME'  value='#arguments.VEIC_SUBST_PROP_NOME#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_SUBST_PROP_ENDERECO'  value='#arguments.VEIC_SUBST_PROP_ENDERECO#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_VEIC_SUBST_PROP_MUNICIPIO_ID'  value='#arguments.VEIC_SUBST_PROP_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.VEIC_SUBST_PROP_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_SUBST_PROP_CNPJ_CPF'  value='#arguments.VEIC_SUBST_PROP_CNPJ_CPF#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_SUBST_PLACA_CONTROLE'  value='#UCase(Replace(arguments.VEIC_SUBST_PLACA_CONTROLE,'-',''))#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_SUBST_MARCA'  value='#arguments.VEIC_SUBST_MARCA#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_SUBST_CHASSIS'  value='#arguments.VEIC_SUBST_CHASSIS#' >
					<cfprocparam type='in' cfsqltype='cf_sql_double'  dbvarname='P_VEIC_SUBST_CAPACIDADE'  value='#arguments.VEIC_SUBST_CAPACIDADE#'  null='#iif(len(trim(arguments.VEIC_SUBST_CAPACIDADE)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_VEIC_SUBST_ANO'  value='#arguments.VEIC_SUBST_ANO#'  null='#iif(len(trim(arguments.VEIC_SUBST_ANO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_VEIC_SUBST_TIPO'  value='#arguments.VEIC_SUBST_TIPO#'  null='#iif(len(trim(arguments.VEIC_SUBST_TIPO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_SUBST_PLACA_REFERENCIA'  value='#arguments.VEIC_SUBST_PLACA_REFERENCIA#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_VEIC_SUBST_MOT_COD_PESSOA'  value='#arguments.VEIC_SUBST_MOT_COD_PESSOA#'  null='#iif(len(trim(arguments.VEIC_SUBST_MOT_COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_NUM_DTA_ROTA'  value='#arguments.NUM_DTA_ROTA#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_ROTA_ID'  value='#arguments.ROTA_ID#' null='#iif(len(trim(arguments.ROTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_COMPLEMENTO'  value='#arguments.COMPLEMENTO#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_ITEM_ID'  value='#arguments.ROMANEIO_ITEM_ID#'  null='#iif(len(trim(arguments.ROMANEIO_ITEM_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_EN_LASTRE'  value='#arguments.EN_LASTRE#'  null='#iif(len(trim(arguments.EN_LASTRE)), de('no'), de('yes'))#'>
				</cfstoredproc>
                <cfset retorno.manifesto_id = arguments.manifesto_id>
				<!--- Alteraes dos Items --->
				<cfscript>
					v_nro_crt = 		this.ListaToArray (lista = arguments, variavel = "ITEM_NUMERO_CRT_ITEMS");
					v_conhecimento_id = this.ListaToArray (lista = arguments, variavel = "ITEM_CONHECIMENTO_ID_ITEMS");
					v_id = 				this.ListaToArray (lista = arguments, variavel = "ITEM_ID_ITEMS");
					v_item_id =			this.ListaToArray (lista = arguments, variavel = "ITEM_IT_ID_ITEMS");
					v_quantidade = 		this.ListaToArray (lista = arguments, variavel = "ITEM_QUANTIDADE_ITEMS");
					v_peso_bruto = 		this.ListaToArray (lista = arguments, variavel = "ITEM_PESO_BRUTO_ITEMS");
					v_peso_liquido = 	this.ListaToArray (lista = arguments, variavel = "ITEM_PESO_LIQUIDO_ITEMS");
					v_valor_total = 	this.ListaToArray (lista = arguments, variavel = "ITEM_VALOR_TOTAL_ITEMS");
					v_seguro = 			this.ListaToArray (lista = arguments, variavel = "ITEM_SEGURO_ITEMS");
					v_num_especie = 	this.ListaToArray (lista = arguments, variavel = "ITEM_NUM_ESPECIE_ITEMS");
					v_descricao = 		this.ListaToArray (lista = arguments, variavel = "ITEM_DESCRICAO_ITEMS");
					v_ncm = 			this.ListaToArray (lista = arguments, variavel = "ITEM_NCM_ITEMS");
					v_pais_id_origem  = this.ListaToArray (lista = arguments, variavel = "ITEM_PAIS_ID_ORIGEM");
					v_valor_fot = 		this.ListaToArray (lista = arguments, variavel = "ITEM_VALOR_FOT_ITEMS");
					v_nro_lacres = 		this.ListaToArray (lista = arguments, variavel = "ITEM_NRO_LACRES_ITEMS");
					v_anexos = 			this.ListaToArray (lista = arguments, variavel = "ITEM_ANEXOS_ITEMS");
					v_cod_remetente = 	this.ListaToArray (lista = arguments, variavel = "COD_REMETENTE_ITEMS");
					v_rem_nome =		this.ListaToArray (lista = arguments, variavel = "REM_NOME_ITEMS");
					v_rem_local =		this.ListaToArray (lista = arguments, variavel = "REM_MUNICIPIO_UF_PAIS_ITEMS");
					v_rem_municipio_id =this.ListaToArray (lista = arguments, variavel = "REM_MUNICIPIO_ID_ITEMS");
					v_item_excluir = 	this.ListDiff(lista1 = arguments.lista_deleted_ITEMS, lista2 = ArrayToList(v_id));
					
					// TOTAIS
					v_pagina              = this.ListaToArray (lista = arguments, variavel = "PAGINA");
					v_campo42             = this.ListaToArray (lista = arguments, variavel = "CAMPO42");
					v_campo43             = this.ListaToArray (lista = arguments, variavel = "CAMPO43");
					v_campo44             = this.ListaToArray (lista = arguments, variavel = "CAMPO44");
					v_campo45             = this.ListaToArray (lista = arguments, variavel = "CAMPO45");
					v_campo46             = this.ListaToArray (lista = arguments, variavel = "CAMPO46");
					v_campo47             = this.ListaToArray (lista = arguments, variavel = "CAMPO47");
				</cfscript>

				<cfloop from="1" to="#ArrayLen(v_pagina)#" index="count">
					<cfscript>
					//altera
					this.upd_intc_manifesto_pagina(	manifesto_id 		= arguments.manifesto_id,
													pagina			 	= v_pagina[count],
													campo42 		 	= v_campo42[count],
													campo43 		 	= v_campo43[count],
													campo44 		 	= v_campo44[count],
													campo45 		 	= v_campo45[count],
													campo46 		 	= v_campo46[count],
													campo47 		 	= v_campo47[count]);
					</cfscript>
				</cfloop>			
				
				<!--- Excluir os itens --->
				<cfloop list="#v_item_excluir#" delimiters="," index="l_item_id">
					<cfscript>
						this.del_intc_manifesto_item (manifesto_id = arguments.manifesto_id,
												      item_id   = l_item_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_descricao)#" index="count">
					<cfscript>
					if(not len(trim(v_item_id[count]))) {
						//caso o item_id seja nulo insere
						this.ins_intc_manifesto_item(	manifesto_id 		= arguments.manifesto_id,
													conhecimento_id 		= v_conhecimento_id[count],
													alfandega_destino_id    = arguments.alfandega_destino_id,
													item_id 				= v_id[count],
													quantidade				= v_quantidade[count],
													peso_bruto				= v_peso_bruto[count],
													peso_liquido			= v_peso_liquido[count],
													valor_total				= v_valor_total[count],
													valor_seguro			= v_seguro[count],
													num_especie				= v_num_especie[count],
													mercadorias				= v_descricao[count],
													numero_lacres			= v_nro_lacres[count],
													valor_fot				= v_valor_fot[count],
													ncm						= v_ncm[count],
													pais_id_origem			= v_pais_id_origem[count],
													anexo					= v_anexos[count],
													cod_remetente			= v_cod_remetente[count],
													rem_nome				= v_rem_nome[count],
													rem_local				= v_rem_local[count],
													rem_municipio_id		= v_rem_municipio_id[count],
													en_lastre				= arguments.en_lastre);
					} else {
						//senao altera
						this.upd_intc_manifesto_item(	manifesto_id 		= arguments.manifesto_id,
													conhecimento_id 		= v_conhecimento_id[count],
													item_id 				= v_id[count],
													alfandega_destino_id    = arguments.alfandega_destino_id,
													quantidade				= v_quantidade[count],
													peso_bruto				= v_peso_bruto[count],
													peso_liquido			= v_peso_liquido[count],
													valor_total				= v_valor_total[count],
													valor_seguro			= v_seguro[count],
													num_especie				= v_num_especie[count],
													mercadorias				= v_descricao[count],
													numero_lacres			= v_nro_lacres[count],
													valor_fot				= v_valor_fot[count],
													ncm						= v_ncm[count],
													pais_id_origem			= v_pais_id_origem[count],
													item_id					= v_item_id[count],
													anexo					= v_anexos[count],
													cod_remetente			= v_cod_remetente[count],
													rem_nome				= v_rem_nome[count],
													rem_local				= v_rem_local[count],
													rem_municipio_id		= v_rem_municipio_id[count],
													en_lastre				= arguments.en_lastre);
					}
					</cfscript>
				</cfloop>			
				
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('MIC/DTA alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera dados dos totais da pagina do MIC
	-- GUTO 30/01/2006 10:34:41 - CRIADO
	--->
	<cffunction name='upd_intc_manifesto_pagina' displayname='Altera dados dos totais da pagina do MIC' access='remote' returntype='Struct' output='true'>;
		<cfargument name='MANIFESTO_ID' required='yes'>
		<cfargument name='PAGINA' required='yes'>
		<cfargument name='CAMPO42' required='yes'>
		<cfargument name='CAMPO43' required='yes'>
		<cfargument name='CAMPO44' required='yes'>
		<cfargument name='CAMPO45' required='yes'>
		<cfargument name='CAMPO46' required='yes'>
		<cfargument name='CAMPO47' required='yes'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_alt_manifesto_pagina' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_MANIFESTO_ID'  value='#arguments.MANIFESTO_ID#'  null='#iif(len(trim(arguments.MANIFESTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_PAGINA'  value='#arguments.PAGINA#'  null='#iif(len(trim(arguments.PAGINA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CAMPO42'  value='#arguments.CAMPO42#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CAMPO43'  value='#arguments.CAMPO43#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CAMPO44'  value='#arguments.CAMPO44#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CAMPO45'  value='#arguments.CAMPO45#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CAMPO46'  value='#arguments.CAMPO46#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CAMPO47'  value='#arguments.CAMPO47#' >
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um manifesto internacional (MIC/DTA)
	-- CRISTOFER 13/12/2005 - criado
	--->
	<cffunction name='del_intc_manifesto' displayname='Exclui um manifesto internacional (MIC/DTA)' access='remote' returntype='Struct' output='true'>
		<cfargument name='MANIFESTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_del_manifesto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_MANIFESTO_ID'  value='#arguments.MANIFESTO_ID#'  null='#iif(len(trim(arguments.MANIFESTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('MIC/DTA excluido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Cancela um manifesto internacional (MIC/DTA)
	-- GUTO 03/03/2006 - criado
	--->
	<cffunction name='can_intc_manifesto' displayname='Cancela um manifesto internacional (MIC/DTA)' access='remote' returntype='Struct' output='true'>
		<cfargument name='MANIFESTO_ID' required='yes'>
		<cfargument name='MOTIVO_CANCELAMENTO' required='no' default="">
		
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_can_manifesto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_MANIFESTO_ID'  value='#arguments.MANIFESTO_ID#'  null='#iif(len(trim(arguments.MANIFESTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_MOTIVO_CANCELAMENTO" value="#arguments.MOTIVO_CANCELAMENTO#">
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('MIC/DTA cancelado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere um Item de CRT no MIC/DTA
	-- CRISTOFER 15/12/2005 - criado
	--->
	<cffunction name='ins_intc_manifesto_item' displayname='Insere um Item de CRT no MIC/DTA' access='remote' returntype='Struct' output='true'>
		<cfargument name='MANIFESTO_ID' required='yes'>
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cfargument name='ALFANDEGA_DESTINO_ID' required='no' default=''>
		<cfargument name='COD_MOEDA' required='no' default=''>
		<cfargument name='ORIGEM_LOCAL' required='no' default=''>
		<cfargument name='ORIGEM_MUNICIPIO_ID' required='no' default=''>
		<cfargument name='VALOR_FOT' required='yes'>
		<cfargument name='VALOR_TOTAL' required='yes'>
		<cfargument name='VALOR_SEGURO' required='yes'>
		<cfargument name='NUM_ESPECIE' required='yes'>
		<cfargument name='QUANTIDADE' required='yes'>
		<cfargument name='PESO_BRUTO' required='yes'>
		<cfargument name='PESO_LIQUIDO' required='yes'>
		<cfargument name='UNIDADE_ID' required='no' default='Kg'>
		<cfargument name='COD_REMETENTE' required='no' default=''>
		<cfargument name='REM_NOME' required='no' default=''>
		<cfargument name='REM_LOCAL' required='no' default=''>
		<cfargument name='REM_MUNICIPIO_ID' required='no' default=''>
		<cfargument name='COD_DESTINATARIO' required='no' default=''>
		<cfargument name='DEST_NOME' required='no' default=''>
		<cfargument name='DEST_LOCAL' required='no' default=''>
		<cfargument name='DEST_MUNICIPIO_ID' required='no' default=''>
		<cfargument name='COD_CONSIGNATARIO' required='no' default=''>
		<cfargument name='CONS_NOME' required='no' default=''>
		<cfargument name='CONS_LOCAL' required='no' default=''>
		<cfargument name='CONS_MUNICIPIO_ID' required='no' default=''>
		<cfargument name='NUMERO_LACRES' required='yes'>
		<cfargument name='MERCADORIAS' required='yes'>
		<cfargument name='NCM' required='yes'>
		<cfargument name='PAIS_ID_ORIGEM' required='yes'>
		<cfargument name='ANEXO' required='yes'>
		<cfscript>
			conn = CreateObject("component", "_transportes.consulta.cfc_transp_internacional");
			qrConhecimento = conn.get_intc_conhecimento_item_mic(argumentCollection = arguments);
		</cfscript>
		<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_ins_manifesto_crt_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
			<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_MANIFESTO_ID'  value='#arguments.MANIFESTO_ID#'  null='#iif(len(trim(arguments.MANIFESTO_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_ALFANDEGA_DESTINO_ID'  value='#arguments.ALFANDEGA_DESTINO_ID#'  null='#iif(len(trim(arguments.ALFANDEGA_DESTINO_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_COD_MOEDA'  value='#qrConhecimento.COD_MOEDA#'  null='#iif(len(trim(qrConhecimento.COD_MOEDA)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_ORIGEM_LOCAL'  value='#qrConhecimento.ORIGEM_LOCAL#' >
			<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_ORIGEM_MUNICIPIO_ID'  value='#qrConhecimento.ORIGEM_MUNICIPIO_ID#'  null='#iif(len(trim(qrConhecimento.ORIGEM_MUNICIPIO_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_numeric' scale='5' dbvarname='P_VALOR_FOT'  value='#arguments.VALOR_FOT#'  null='#iif(len(trim(arguments.VALOR_FOT)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_numeric' scale='5' dbvarname='P_VALOR_TOTAL'  value='#arguments.VALOR_TOTAL#'  null='#iif(len(trim(arguments.VALOR_TOTAL)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_numeric' scale='5' dbvarname='P_VALOR_SEGURO'  value='#arguments.VALOR_SEGURO#'  null='#iif(len(trim(arguments.VALOR_SEGURO)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_NUM_ESPECIE'  value='#arguments.NUM_ESPECIE#'  null='#iif(len(trim(arguments.NUM_ESPECIE)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_numeric' scale='5' dbvarname='P_QUANTIDADE'  value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_numeric' scale='5' dbvarname='P_PESO_BRUTO'  value='#arguments.PESO_BRUTO#'  null='#iif(len(trim(arguments.PESO_BRUTO)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_numeric' scale='5' dbvarname='P_PESO_LIQUIDO'  value='#arguments.PESO_LIQUIDO#'  null='#iif(len(trim(arguments.PESO_LIQUIDO)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_UNIDADE_ID'  value='#arguments.UNIDADE_ID#' >
			<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_COD_REMETENTE'  value='#arguments.COD_REMETENTE#'  null='#iif(len(trim(arguments.COD_REMETENTE)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_REM_NOME'  value='#arguments.REM_NOME#' >
			<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_REM_LOCAL'  value='#arguments.REM_LOCAL#' >
			<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_REM_MUNICIPIO_ID'  value='#arguments.REM_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.REM_MUNICIPIO_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_COD_DESTINATARIO'  value='#qrConhecimento.COD_DESTINATARIO#'  null='#iif(len(trim(qrConhecimento.COD_DESTINATARIO)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_DEST_NOME'  value='#qrConhecimento.DEST_NOME#' >
			<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_DEST_LOCAL'  value='#qrConhecimento.DEST_LOCAL#' >
			<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_DEST_MUNICIPIO_ID'  value='#qrConhecimento.DEST_MUNICIPIO_ID#'  null='#iif(len(trim(qrConhecimento.DEST_MUNICIPIO_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_COD_CONSIGNATARIO'  value='#qrConhecimento.COD_CONSIGNATARIO#'  null='#iif(len(trim(qrConhecimento.COD_CONSIGNATARIO)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_CONS_NOME'  value='#qrConhecimento.CONS_NOME#' >
			<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_CONS_LOCAL'  value='#qrConhecimento.CONS_LOCAL#' >
			<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_CONS_MUNICIPIO_ID'  value='#qrConhecimento.CONS_MUNICIPIO_ID#'  null='#iif(len(trim(qrConhecimento.CONS_MUNICIPIO_ID)), de('no'), de('yes'))#'>
			
			<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_NUMERO_LACRES'  value='#arguments.NUMERO_LACRES#' >
			<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_MERCADORIAS'  value='#arguments.MERCADORIAS#' >
			<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_NCM'  value='#arguments.NCM#' >
			<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_PAIS_ID_ORIGEM'  value='#arguments.pais_id_origem#' null='#iif(len(trim(arguments.pais_id_origem)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_ANEXO'  value='#arguments.ANEXO#' >
		</cfstoredproc>
		<cfreturn StructNew() />
	</cffunction>
	
	
	<!--- 
	-- PROPSITO
	-- Altera um item de CRT do MIC/DTA
	-- CRISTOFER 15/12/2005 - criado
	--->
	<cffunction name='upd_intc_manifesto_item' displayname='Altera um item de CRT do MIC/DTA' access='remote' returntype='Struct' output='true'>
		<cfargument name='MANIFESTO_ID' required='yes'>
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cfargument name='ALFANDEGA_DESTINO_ID' required='no' default=''>
		<cfargument name='COD_MOEDA' required='no' default=''>
		<cfargument name='ORIGEM_LOCAL' required='no' default=''>
		<cfargument name='ORIGEM_MUNICIPIO_ID' required='no' default=''>
		<cfargument name='VALOR_FOT' required='yes'>
		<cfargument name='VALOR_TOTAL' required='yes'>
		<cfargument name='VALOR_SEGURO' required='yes'>
		<cfargument name='NUM_ESPECIE' required='yes'>
		<cfargument name='QUANTIDADE' required='yes'>
		<cfargument name='PESO_BRUTO' required='yes'>
		<cfargument name='PESO_LIQUIDO' required='yes'>
		<cfargument name='UNIDADE_ID' required='no' default='Kg'>
		<cfargument name='COD_REMETENTE' required='no' default=''>
		<cfargument name='REM_NOME' required='no' default=''>
		<cfargument name='REM_LOCAL' required='no' default=''>
		<cfargument name='REM_MUNICIPIO_ID' required='no' default=''>
		<cfargument name='COD_DESTINATARIO' required='no' default=''>
		<cfargument name='DEST_NOME' required='no' default=''>
		<cfargument name='DEST_LOCAL' required='no' default=''>
		<cfargument name='DEST_MUNICIPIO_ID' required='no' default=''>
		<cfargument name='COD_CONSIGNATARIO' required='no' default=''>
		<cfargument name='CONS_NOME' required='no' default=''>
		<cfargument name='CONS_LOCAL' required='no' default=''>
		<cfargument name='CONS_MUNICIPIO_ID' required='no' default=''>
		<cfargument name='NUMERO_LACRES' required='yes'>
		<cfargument name='MERCADORIAS' required='yes'>
		<cfargument name='NCM' required='yes'>
		<cfargument name='PAIS_ID_ORIGEM' required='yes'>
		<cfargument name='ANEXO' required='yes'>
		<cfscript>
			conn = CreateObject("component", "_transportes.consulta.cfc_transp_internacional");
			qrConhecimento = conn.get_intc_conhecimento_item_mic(argumentCollection = arguments);
		</cfscript>	
		<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_alt_manifesto_crt_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
			<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_MANIFESTO_ID'  value='#arguments.MANIFESTO_ID#'  null='#iif(len(trim(arguments.MANIFESTO_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_ALFANDEGA_DESTINO_ID'  value='#arguments.ALFANDEGA_DESTINO_ID#'  null='#iif(len(trim(arguments.ALFANDEGA_DESTINO_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_COD_MOEDA'  value='#qrConhecimento.COD_MOEDA#'  null='#iif(len(trim(qrConhecimento.COD_MOEDA)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_ORIGEM_LOCAL'  value='#qrConhecimento.ORIGEM_LOCAL#' >
			<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_ORIGEM_MUNICIPIO_ID'  value='#qrConhecimento.ORIGEM_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.ORIGEM_MUNICIPIO_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_numeric' scale='5' dbvarname='P_VALOR_FOT'  value='#arguments.VALOR_FOT#'  null='#iif(len(trim(arguments.VALOR_FOT)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_numeric' scale='5' dbvarname='P_VALOR_TOTAL'  value='#arguments.VALOR_TOTAL#'  null='#iif(len(trim(arguments.VALOR_TOTAL)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_numeric' scale='5' dbvarname='P_VALOR_SEGURO'  value='#arguments.VALOR_SEGURO#'  null='#iif(len(trim(arguments.VALOR_SEGURO)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_NUM_ESPECIE'  value='#arguments.NUM_ESPECIE#'  null='#iif(len(trim(arguments.NUM_ESPECIE)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_numeric' scale='5' dbvarname='P_QUANTIDADE'  value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_numeric' scale='5' dbvarname='P_PESO_BRUTO'  value='#arguments.PESO_BRUTO#'  null='#iif(len(trim(arguments.PESO_BRUTO)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_numeric' scale='5' dbvarname='P_PESO_LIQUIDO'  value='#arguments.PESO_LIQUIDO#'  null='#iif(len(trim(arguments.PESO_LIQUIDO)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_UNIDADE_ID'  value='#arguments.UNIDADE_ID#' >
			<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_COD_REMETENTE'  value='#arguments.COD_REMETENTE#'  null='#iif(len(trim(arguments.COD_REMETENTE)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_REM_NOME'  value='#arguments.REM_NOME#' >
			<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_REM_LOCAL'  value='#arguments.REM_LOCAL#' >
			<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_REM_MUNICIPIO_ID'  value='#arguments.REM_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.REM_MUNICIPIO_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_COD_DESTINATARIO'  value='#qrConhecimento.COD_DESTINATARIO#'  null='#iif(len(trim(qrConhecimento.COD_DESTINATARIO)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_DEST_NOME'  value='#qrConhecimento.DEST_NOME#' >
			<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_DEST_LOCAL'  value='#qrConhecimento.DEST_LOCAL#' >
			<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_DEST_MUNICIPIO_ID'  value='#qrConhecimento.DEST_MUNICIPIO_ID#'  null='#iif(len(trim(qrConhecimento.DEST_MUNICIPIO_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_COD_CONSIGNATARIO'  value='#qrConhecimento.COD_CONSIGNATARIO#'  null='#iif(len(trim(qrConhecimento.COD_CONSIGNATARIO)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_CONS_NOME'  value='#qrConhecimento.CONS_NOME#' >
			<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_CONS_LOCAL'  value='#qrConhecimento.CONS_LOCAL#' >
			<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_CONS_MUNICIPIO_ID'  value='#qrConhecimento.CONS_MUNICIPIO_ID#'  null='#iif(len(trim(qrConhecimento.CONS_MUNICIPIO_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_NUMERO_LACRES'  value='#arguments.NUMERO_LACRES#' >
			<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_MERCADORIAS'  value='#arguments.MERCADORIAS#' >
			<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_NCM'  value='#arguments.NCM#' >
			<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_PAIS_ID_ORIGEM'  value='#arguments.pais_id_origem#' null='#iif(len(trim(arguments.pais_id_origem)), de('no'), de('yes'))#'>
			
			<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_ANEXO'  value='#arguments.ANEXO#' >
		</cfstoredproc>
		<cfreturn StructNew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um item de CRT do MIC/DTA
	-- CRISTOFER 13/12/2005 - criado
	--->
	<cffunction name='del_intc_manifesto_item' displayname='Exclui um item de CRT do MIC/DTA' access='remote' returntype='Struct' output='true'>
		<cfargument name='MANIFESTO_ID' required='yes'>
		<cfargument name='ITEM_ID' required='yes'>
		<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_del_manifesto_crt_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
			<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_MANIFESTO_ID'  value='#arguments.MANIFESTO_ID#'  null='#iif(len(trim(arguments.MANIFESTO_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
		</cfstoredproc>
		<cfreturn StructNew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- /* Insere um novo DTI */
	-- GUTO 16/12/2005 - criado
	--->
	<cffunction name='ins_intc_despacho' displayname='/* Insere um novo DTI */' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_DESPACHO' required='yes'>
		<cfargument name='COD_PESSOA_FILIAL' required='yes'>
		<cfargument name='COD_PESSOA_EMISSAO' required='yes'>
		<cfargument name='LOCAL_EMISSAO' required='yes'>
		<cfargument name='MUNICIPIO_ID' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='ORIGEM_LOCAL' required='yes'>
		<cfargument name='ORIGEM_MUNICIPIO_ID' required='yes'>
		<cfargument name='DESTINO_LOCAL' required='yes'>
		<cfargument name='DESTINO_MUNICIPIO_ID' required='yes'>
		<cfargument name='COD_REMETENTE' required='yes'>
		<cfargument name='REM_NOME' required='yes'>
		<cfargument name='REM_CNPJ' required='yes'>
		<cfargument name='REM_INSCRICAO_ESTADUAL' required='yes'>
		<cfargument name='REM_ENDERECO' required='yes'>
		<cfargument name='REM_MUNICIPIO_ID' required='yes'>
		<cfargument name='COD_DESTINATARIO' required='yes'>
		<cfargument name='DEST_NOME' required='yes'>
		<cfargument name='DEST_CNPJ' required='yes'>
		<cfargument name='DEST_INSCRICAO_ESTADUAL' required='yes'>
		<cfargument name='DEST_ENDERECO' required='yes'>
		<cfargument name='DEST_MUNICIPIO_ID' required='yes'>
		<cfargument name='NOTAS_FISCAIS' required='yes'>
		<cfargument name='VALOR_MERCADORIA' required='yes'>
		<cfargument name='VALOR_MERCADORIA_COD_MOEDA' required='no' default="">
		<cfargument name='PRODUTO_ID' required='yes'>
		<cfargument name='NUM_ESPECIE' required='yes'>
		<cfargument name='QUANTIDADE' required='yes'>
		<cfargument name='PESO_BRUTO' required='yes'>
		<cfargument name='COD_PROPRIETARIO' required='yes'>
		<cfargument name='PROP_NOME' required='yes'>
		<cfargument name='PROP_ENDERECO' required='yes'>
		<cfargument name='PROP_CNPJ_CPF' required='yes'>
		<cfargument name='PROP_MUNICIPIO_ID' required='yes'>
		<cfargument name='PROP_CERT_PROPRIEDADE' required='yes'>
		<cfargument name='PROP_RTB' required='yes'>
		<cfargument name='COD_MOTORISTA' required='yes'>
		<cfargument name='MOT_NOME' required='yes'>
		<cfargument name='MOT_CPF' required='yes'>
		<cfargument name='MOT_ENDERECO' required='yes'>
		<cfargument name='MOT_MUNICIPIO_ID' required='yes'>
		<cfargument name='MOT_CNH' required='yes'>
		<cfargument name='MOT_CNH_VALIDADE' required='yes'>
		<cfargument name='PLACA_TRACAO' required='yes'>
		<cfargument name='PLACA_REBOQUE' required='yes'>
		<cfargument name='PESO_A_PAGAR' required='yes'>
		<cfargument name='VALOR_POR_KG' required='yes'>
		<cfargument name='VALOR_SERVICO' required='yes'>
		<cfargument name='VALOR_CARGA_DESCARGA' required='yes'>
		<cfargument name='VALOR_FRONTEIRA' required='yes'>
		<cfargument name='VALOR_IRRF' required='yes'>
		<cfargument name='VALOR_ADIANTAMENTO' required='yes'>
		<cfargument name='VALOR_ICMS_RETIDO' required='yes'>
		<cfargument name='VALOR_LIQUIDO' required='yes'>
		<cfargument name='VALOR_FALTA_AVARIAS' required='yes'>
		<cfargument name='VALOR_ADICIONAL' required='yes'>
		<cfargument name='DESCRICAO_VALOR_ADICIONAL' required='yes'>
		<cfargument name='LIQUIDO_A_PAGAR' required='yes'>
		<cfargument name='COTACAO_DOLAR' required='yes'>
		<cfargument name='NUM_DEPENDENTES' required='yes'>
		<cfargument name='BASE_CALC_IRRF' required='yes'>
		<cfargument name='OUTRAS_DEDUCOES' required='yes'>
		<cfargument name='DESCARGA_POR_CONTA_ID' required='yes'>
		<cfargument name='OBSERVACOES' required='yes'>
		<cfargument name='AUTORIZAR_PAGTO_POR' required='no' default="0">
		<cfargument name='AUTORIZAR_PAGTO_DATA' required='yes'>
		<cfargument name='AUTORIZAR_ADTO_POR' required='no' default="0">
		<cfargument name='AUTORIZAR_ADTO_DATA' required='yes'>
		<cfargument name='DESPACHO_ID' required='yes'>
		<cfargument name='CONDICAO_PAGTO' required='no'>	
		<cfargument name="TIPO" required="no" default="1">
		<cfargument name='OPERACAO_VALOR_ADICIONAL' required='no' default="1">
        <cfargument name='SERIE' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_ins_intc_despacho' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_NUM_DESPACHO'  value='#arguments.NUM_DESPACHO#'  null='#iif(len(trim(arguments.NUM_DESPACHO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_COD_PESSOA_FILIAL'  value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_COD_PESSOA_EMISSAO'  value='#arguments.COD_PESSOA_EMISSAO#'  null='#iif(len(trim(arguments.COD_PESSOA_EMISSAO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_LOCAL_EMISSAO'  value='#arguments.LOCAL_EMISSAO#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_MUNICIPIO_ID'  value='#arguments.MUNICIPIO_ID#'  null='#iif(len(trim(arguments.MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_ORIGEM_LOCAL'  value='#arguments.ORIGEM_LOCAL#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_ORIGEM_MUNICIPIO_ID'  value='#arguments.ORIGEM_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.ORIGEM_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_DESTINO_LOCAL'  value='#arguments.DESTINO_LOCAL#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_DESTINO_MUNICIPIO_ID'  value='#arguments.DESTINO_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.DESTINO_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_COD_REMETENTE'  value='#arguments.COD_REMETENTE#'  null='#iif(len(trim(arguments.COD_REMETENTE)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_REM_NOME'  value='#arguments.REM_NOME#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_REM_CNPJ'  value='#arguments.REM_CNPJ#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_REM_INSCRICAO_ESTADUAL'  value='#arguments.REM_INSCRICAO_ESTADUAL#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_REM_ENDERECO'  value='#arguments.REM_ENDERECO#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_REM_MUNICIPIO_ID'  value='#arguments.REM_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.REM_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_COD_DESTINATARIO'  value='#arguments.COD_DESTINATARIO#'  null='#iif(len(trim(arguments.COD_DESTINATARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_DEST_NOME'  value='#arguments.DEST_NOME#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_DEST_CNPJ'  value='#arguments.DEST_CNPJ#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_DEST_INSCRICAO_ESTADUAL'  value='#arguments.DEST_INSCRICAO_ESTADUAL#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_DEST_ENDERECO'  value='#arguments.DEST_ENDERECO#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_DEST_MUNICIPIO_ID'  value='#arguments.DEST_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.DEST_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_NOTAS_FISCAIS'  value='#arguments.NOTAS_FISCAIS#' >
					<cfprocparam type='in' cfsqltype='cf_sql_float'   dbvarname='P_VALOR_MERCADORIA'  value='#arguments.VALOR_MERCADORIA#'  null='#iif(len(trim(arguments.VALOR_MERCADORIA)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_VALOR_MERCADORIA_COD_MOEDA'  value='#arguments.VALOR_MERCADORIA_COD_MOEDA#'  null='#iif(len(trim(arguments.VALOR_MERCADORIA_COD_MOEDA)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_PRODUTO_ID'  value='#arguments.PRODUTO_ID#'  null='#iif(len(trim(arguments.PRODUTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_NUM_ESPECIE'  value='#arguments.NUM_ESPECIE#'  null='#iif(len(trim(arguments.NUM_ESPECIE)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'   dbvarname='P_QUANTIDADE'  value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'   dbvarname='P_PESO_BRUTO'  value='#arguments.PESO_BRUTO#'  null='#iif(len(trim(arguments.PESO_BRUTO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_COD_PROPRIETARIO'  value='#arguments.COD_PROPRIETARIO#'  null='#iif(len(trim(arguments.COD_PROPRIETARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_PROP_NOME'  value='#arguments.PROP_NOME#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_PROP_ENDERECO'  value='#arguments.PROP_ENDERECO#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_PROP_CNPJ_CPF'  value='#arguments.PROP_CNPJ_CPF#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_PROP_MUNICIPIO_ID'  value='#arguments.PROP_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.PROP_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_PROP_CERT_PROPRIEDADE'  value='#arguments.PROP_CERT_PROPRIEDADE#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_PROP_RTB'  value='#arguments.PROP_RTB#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_COD_MOTORISTA'  value='#arguments.COD_MOTORISTA#'  null='#iif(len(trim(arguments.COD_MOTORISTA)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_MOT_NOME'  value='#arguments.MOT_NOME#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_MOT_CPF'  value='#arguments.MOT_CPF#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_MOT_ENDERECO'  value='#arguments.MOT_ENDERECO#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_MOT_MUNICIPIO_ID'  value='#arguments.MOT_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.MOT_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_MOT_CNH'  value='#arguments.MOT_CNH#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_MOT_CNH_VALIDADE'  value='#arguments.MOT_CNH_VALIDADE#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_PLACA_TRACAO'  value='#UCase(REReplace(arguments.PLACA_TRACAO,'-',''))#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_PLACA_REBOQUE'  value='#UCase(REReplace(arguments.PLACA_REBOQUE,'-',''))#' >
					<cfprocparam type='in' cfsqltype='cf_sql_float' dbvarname='P_PESO_A_PAGAR'  value='#arguments.PESO_A_PAGAR#'  null='#iif(len(trim(arguments.PESO_A_PAGAR)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'   dbvarname='P_VALOR_POR_KG'  value='#arguments.VALOR_POR_KG#'  null='#iif(len(trim(arguments.VALOR_POR_KG)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'   dbvarname='P_VALOR_SERVICO'  value='#arguments.VALOR_SERVICO#'  null='#iif(len(trim(arguments.VALOR_SERVICO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'   dbvarname='P_VALOR_CARGA_DESCARGA'  value='#arguments.VALOR_CARGA_DESCARGA#'  null='#iif(len(trim(arguments.VALOR_CARGA_DESCARGA)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'   dbvarname='P_VALOR_FRONTEIRA'  value='#arguments.VALOR_FRONTEIRA#'  null='#iif(len(trim(arguments.VALOR_FRONTEIRA)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'   dbvarname='P_VALOR_IRRF'  value='#arguments.VALOR_IRRF#'  null='#iif(len(trim(arguments.VALOR_IRRF)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'   dbvarname='P_VALOR_ADIANTAMENTO'  value='#arguments.VALOR_ADIANTAMENTO#'  null='#iif(len(trim(arguments.VALOR_ADIANTAMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'   dbvarname='P_VALOR_ICMS_RETIDO'  value='#arguments.VALOR_ICMS_RETIDO#'  null='#iif(len(trim(arguments.VALOR_ICMS_RETIDO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'   dbvarname='P_VALOR_LIQUIDO'  value='#arguments.VALOR_LIQUIDO#'  null='#iif(len(trim(arguments.VALOR_LIQUIDO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'   dbvarname='P_VALOR_FALTA_AVARIAS'  value='#arguments.VALOR_FALTA_AVARIAS#'  null='#iif(len(trim(arguments.VALOR_FALTA_AVARIAS)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'   dbvarname='P_VALOR_ADICIONAL'  value='#arguments.VALOR_ADICIONAL#'  null='#iif(len(trim(arguments.VALOR_ADICIONAL)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_DESCRICAO_VALOR_ADICIONAL'  value='#arguments.DESCRICAO_VALOR_ADICIONAL#' >
					<cfprocparam type='in' cfsqltype='cf_sql_float'   dbvarname='P_LIQUIDO_A_PAGAR'  value='#arguments.LIQUIDO_A_PAGAR#'  null='#iif(len(trim(arguments.LIQUIDO_A_PAGAR)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'   dbvarname='P_COTACAO_DOLAR'  value='#arguments.COTACAO_DOLAR#'  null='#iif(len(trim(arguments.COTACAO_DOLAR)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_NUM_DEPENDENTES'  value='#arguments.NUM_DEPENDENTES#'  null='#iif(len(trim(arguments.NUM_DEPENDENTES)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'   dbvarname='P_BASE_CALC_IRRF'  value='#arguments.BASE_CALC_IRRF#'  null='#iif(len(trim(arguments.BASE_CALC_IRRF)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'   dbvarname='P_OUTRAS_DEDUCOES'  value='#arguments.OUTRAS_DEDUCOES#'  null='#iif(len(trim(arguments.OUTRAS_DEDUCOES)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_DESCARGA_POR_CONTA_ID'  value='#arguments.DESCARGA_POR_CONTA_ID#'  null='#iif(len(trim(arguments.DESCARGA_POR_CONTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_OBSERVACOES'  value='#arguments.OBSERVACOES#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_AUTORIZAR_PAGTO_POR'  value='#arguments.AUTORIZAR_PAGTO_POR#'  null='#iif(len(trim(arguments.AUTORIZAR_PAGTO_POR)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_AUTORIZAR_PAGTO_DATA'  value='#arguments.AUTORIZAR_PAGTO_DATA#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_AUTORIZAR_ADTO_POR'  value='#arguments.AUTORIZAR_ADTO_POR#'  null='#iif(len(trim(arguments.AUTORIZAR_ADTO_POR)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_AUTORIZAR_ADTO_DATA'  value='#arguments.AUTORIZAR_ADTO_DATA#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_TIPO'  value='#arguments.TIPO#' >
					<cfprocparam type='inout' cfsqltype='cf_sql_integer' dbvarname='P_DESPACHO_ID' value='#arguments.DESPACHO_ID#' variable='retorno.DESPACHO_ID' null='#iif(len(trim(arguments.DESPACHO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='out' cfsqltype='cf_sql_varchar' dbvarname='P_ROWID' variable='retorno.ROWID' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_OPERADOR_VALOR_ADICIONAL'  value='#arguments.OPERACAO_VALOR_ADICIONAL#'   null='#iif(len(trim(arguments.OPERACAO_VALOR_ADICIONAL)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SERIE'  value='#arguments.SERIE#'  null='#iif(len(trim(arguments.SERIE)), de('no'), de('yes'))#'>
				</cfstoredproc>
	
				<cfset arguments.despacho_id = retorno.despacho_id>
	
				<cfif IsDefined("arguments.CONDICAO_PAGTO") and Len(Trim(arguments.CONDICAO_PAGTO))>
					<cfloop list="#arguments.CONDICAO_PAGTO#" index="i" delimiters=",">
						<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_ins_dti_doc' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
							<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_DESPACHO_ID'  value='#retorno.DESPACHO_ID#'>
							<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_DOCUMENTO_ID'  value='#i#'>
						</cfstoredproc>
					</cfloop>
				</cfif>
	
				<!--- Inseres dos Items --->
				<cfscript>
					v_manifesto_id        = this.ListaToArray (lista = arguments, variavel = "MANIFESTO_ID_MIC");
					v_mic_crt_mic         = this.ListaToArray (lista = arguments, variavel = "MIC_CRT_MIC");
					v_conhecimento_id     = this.ListaToArray (lista = arguments, variavel = "CONHECIMENTO_ID_CRT");
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_manifesto_id)#" index="count">
					<cfscript>
							ret = this.ins_intc_dti_item(	despacho_id 		= arguments.despacho_id,
													conhecimento_id     = v_mic_crt_mic[count],
													manifesto_id		= v_manifesto_id[count]);
					</cfscript>
					<cfif ret.erro>
						<cfthrow object="#ret.mensagem#">
					</cfif>
				</cfloop>				
	
				<cfloop from="1" to="#ArrayLen(v_conhecimento_id)#" index="count">
					<cfscript>
						ret = this.ins_intc_dti_item(	despacho_id 		= arguments.despacho_id,
												conhecimento_id     = v_conhecimento_id[count],
												manifesto_id		= '');
					</cfscript>
					<cfif ret.erro>
						<cfthrow object="#ret.mensagem#">
					</cfif>
					
				</cfloop>				
				
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('D.T.I. inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera dados do DTI cadastrado
	-- GUTO 16/12/2005 - criado
	--->
	<cffunction name='upd_intc_despacho' displayname='Altera dados do DTI cadastrado' access='remote' returntype='Struct' output='true'>
		<cfargument name='DESPACHO_ID' required='yes'>
		<cfargument name='NUM_DESPACHO' required='yes'>
		<cfargument name='COD_PESSOA_FILIAL' required='yes'>
		<cfargument name='COD_PESSOA_EMISSAO' required='yes'>
		<cfargument name='LOCAL_EMISSAO' required='yes'>
		<cfargument name='MUNICIPIO_ID' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='ORIGEM_LOCAL' required='yes'>
		<cfargument name='ORIGEM_MUNICIPIO_ID' required='yes'>
		<cfargument name='DESTINO_LOCAL' required='yes'>
		<cfargument name='DESTINO_MUNICIPIO_ID' required='yes'>
		<cfargument name='COD_REMETENTE' required='yes'>
		<cfargument name='REM_NOME' required='yes'>
		<cfargument name='REM_CNPJ' required='yes'>
		<cfargument name='REM_INSCRICAO_ESTADUAL' required='yes'>
		<cfargument name='REM_ENDERECO' required='yes'>
		<cfargument name='REM_MUNICIPIO_ID' required='yes'>
		<cfargument name='COD_DESTINATARIO' required='yes'>
		<cfargument name='DEST_NOME' required='yes'>
		<cfargument name='DEST_CNPJ' required='yes'>
		<cfargument name='DEST_INSCRICAO_ESTADUAL' required='yes'>
		<cfargument name='DEST_ENDERECO' required='yes'>
		<cfargument name='DEST_MUNICIPIO_ID' required='yes'>
		<cfargument name='NOTAS_FISCAIS' required='yes'>
		<cfargument name='VALOR_MERCADORIA' required='yes'>
		<cfargument name='VALOR_MERCADORIA_COD_MOEDA' required='no' default="">
		<cfargument name='PRODUTO_ID' required='yes'>
		<cfargument name='NUM_ESPECIE' required='yes'>
		<cfargument name='QUANTIDADE' required='yes'>
		<cfargument name='PESO_BRUTO' required='yes'>
		<cfargument name='COD_PROPRIETARIO' required='yes'>
		<cfargument name='PROP_NOME' required='yes'>
		<cfargument name='PROP_ENDERECO' required='yes'>
		<cfargument name='PROP_CNPJ_CPF' required='yes'>
		<cfargument name='PROP_MUNICIPIO_ID' required='yes'>
		<cfargument name='PROP_CERT_PROPRIEDADE' required='yes'>
		<cfargument name='PROP_RTB' required='yes'>
		<cfargument name='COD_MOTORISTA' required='yes'>
		<cfargument name='MOT_NOME' required='yes'>
		<cfargument name='MOT_CPF' required='yes'>
		<cfargument name='MOT_ENDERECO' required='yes'>
		<cfargument name='MOT_MUNICIPIO_ID' required='yes'>
		<cfargument name='MOT_CNH' required='yes'>
		<cfargument name='MOT_CNH_VALIDADE' required='yes'>
		<cfargument name='PLACA_TRACAO' required='yes'>
		<cfargument name='PLACA_REBOQUE' required='yes'>
		<cfargument name='PESO_A_PAGAR' required='yes'>
		<cfargument name='VALOR_POR_KG' required='yes'>
		<cfargument name='VALOR_SERVICO' required='yes'>
		<cfargument name='VALOR_CARGA_DESCARGA' required='yes'>
		<cfargument name='VALOR_FRONTEIRA' required='yes'>
		<cfargument name='VALOR_IRRF' required='yes'>
		<cfargument name='VALOR_ADIANTAMENTO' required='yes'>
		<cfargument name='VALOR_ICMS_RETIDO' required='yes'>
		<cfargument name='VALOR_LIQUIDO' required='yes'>
		<cfargument name='VALOR_FALTA_AVARIAS' required='yes'>
		<cfargument name='VALOR_ADICIONAL' required='yes'>
		<cfargument name='DESCRICAO_VALOR_ADICIONAL' required='yes'>
		<cfargument name='LIQUIDO_A_PAGAR' required='yes'>
		<cfargument name='COTACAO_DOLAR' required='yes'>
		<cfargument name='NUM_DEPENDENTES' required='yes'>
		<cfargument name='BASE_CALC_IRRF' required='yes'>
		<cfargument name='OUTRAS_DEDUCOES' required='yes'>
		<cfargument name='DESCARGA_POR_CONTA_ID' required='yes'>
		<cfargument name='OBSERVACOES' required='yes'>
		<cfargument name='AUTORIZAR_PAGTO_POR' required='yes' default="0">
		<cfargument name='AUTORIZAR_PAGTO_DATA' required='yes'>
		<cfargument name='AUTORIZAR_ADTO_POR' required='yes' default="0">
		<cfargument name='AUTORIZAR_ADTO_DATA' required='yes'>
		<cfargument name='TIPO' required='no' default="1">
		<cfargument name='OPERACAO_VALOR_ADICIONAL' required='no' default="1">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_alt_intc_despacho' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_DESPACHO_ID'  value='#arguments.DESPACHO_ID#'  null='#iif(len(trim(arguments.DESPACHO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_NUM_DESPACHO'  value='#arguments.NUM_DESPACHO#'  null='#iif(len(trim(arguments.NUM_DESPACHO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_COD_PESSOA_FILIAL'  value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_COD_PESSOA_EMISSAO'  value='#arguments.COD_PESSOA_EMISSAO#'  null='#iif(len(trim(arguments.COD_PESSOA_EMISSAO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_LOCAL_EMISSAO'  value='#arguments.LOCAL_EMISSAO#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_MUNICIPIO_ID'  value='#arguments.MUNICIPIO_ID#'  null='#iif(len(trim(arguments.MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_ORIGEM_LOCAL'  value='#arguments.ORIGEM_LOCAL#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_ORIGEM_MUNICIPIO_ID'  value='#arguments.ORIGEM_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.ORIGEM_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_DESTINO_LOCAL'  value='#arguments.DESTINO_LOCAL#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_DESTINO_MUNICIPIO_ID'  value='#arguments.DESTINO_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.DESTINO_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_COD_REMETENTE'  value='#arguments.COD_REMETENTE#'  null='#iif(len(trim(arguments.COD_REMETENTE)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_REM_NOME'  value='#arguments.REM_NOME#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_REM_CNPJ'  value='#arguments.REM_CNPJ#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_REM_INSCRICAO_ESTADUAL'  value='#arguments.REM_INSCRICAO_ESTADUAL#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_REM_ENDERECO'  value='#arguments.REM_ENDERECO#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_REM_MUNICIPIO_ID'  value='#arguments.REM_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.REM_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_COD_DESTINATARIO'  value='#arguments.COD_DESTINATARIO#'  null='#iif(len(trim(arguments.COD_DESTINATARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_DEST_NOME'  value='#arguments.DEST_NOME#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_DEST_CNPJ'  value='#arguments.DEST_CNPJ#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_DEST_INSCRICAO_ESTADUAL'  value='#arguments.DEST_INSCRICAO_ESTADUAL#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_DEST_ENDERECO'  value='#arguments.DEST_ENDERECO#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_DEST_MUNICIPIO_ID'  value='#arguments.DEST_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.DEST_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_NOTAS_FISCAIS'  value='#arguments.NOTAS_FISCAIS#' >
					<cfprocparam type='in' cfsqltype='cf_sql_float'   dbvarname='P_VALOR_MERCADORIA'  value='#arguments.VALOR_MERCADORIA#'  null='#iif(len(trim(arguments.VALOR_MERCADORIA)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer'   dbvarname='P_VALOR_MERCADORIA_COD_MOEDA'  value='#arguments.VALOR_MERCADORIA_COD_MOEDA#'  null='#iif(len(trim(arguments.VALOR_MERCADORIA_COD_MOEDA)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_PRODUTO_ID'  value='#arguments.PRODUTO_ID#'  null='#iif(len(trim(arguments.PRODUTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_NUM_ESPECIE'  value='#arguments.NUM_ESPECIE#'  null='#iif(len(trim(arguments.NUM_ESPECIE)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'   dbvarname='P_QUANTIDADE'  value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'   dbvarname='P_PESO_BRUTO'  value='#arguments.PESO_BRUTO#'  null='#iif(len(trim(arguments.PESO_BRUTO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_COD_PROPRIETARIO'  value='#arguments.COD_PROPRIETARIO#'  null='#iif(len(trim(arguments.COD_PROPRIETARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_PROP_NOME'  value='#arguments.PROP_NOME#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_PROP_ENDERECO'  value='#arguments.PROP_ENDERECO#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_PROP_CNPJ_CPF'  value='#arguments.PROP_CNPJ_CPF#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_PROP_MUNICIPIO_ID'  value='#arguments.PROP_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.PROP_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_PROP_CERT_PROPRIEDADE'  value='#arguments.PROP_CERT_PROPRIEDADE#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_PROP_RTB'  value='#arguments.PROP_RTB#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_COD_MOTORISTA'  value='#arguments.COD_MOTORISTA#'  null='#iif(len(trim(arguments.COD_MOTORISTA)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_MOT_NOME'  value='#arguments.MOT_NOME#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_MOT_CPF'  value='#arguments.MOT_CPF#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_MOT_ENDERECO'  value='#arguments.MOT_ENDERECO#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_MOT_MUNICIPIO_ID'  value='#arguments.MOT_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.MOT_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_MOT_CNH'  value='#arguments.MOT_CNH#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_MOT_CNH_VALIDADE'  value='#arguments.MOT_CNH_VALIDADE#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_PLACA_TRACAO'  value='#UCase(REReplace(arguments.PLACA_TRACAO,'-',''))#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_PLACA_REBOQUE'  value='#UCase(REReplace(arguments.PLACA_REBOQUE,'-',''))#' >
					<cfprocparam type='in' cfsqltype='cf_sql_float'   dbvarname='P_PESO_A_PAGAR'  value='#arguments.PESO_A_PAGAR#'  null='#iif(len(trim(arguments.PESO_A_PAGAR)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'   dbvarname='P_VALOR_POR_KG'  value='#arguments.VALOR_POR_KG#'  null='#iif(len(trim(arguments.VALOR_POR_KG)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'   dbvarname='P_VALOR_SERVICO'  value='#arguments.VALOR_SERVICO#'  null='#iif(len(trim(arguments.VALOR_SERVICO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'   dbvarname='P_VALOR_CARGA_DESCARGA'  value='#arguments.VALOR_CARGA_DESCARGA#'  null='#iif(len(trim(arguments.VALOR_CARGA_DESCARGA)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'   dbvarname='P_VALOR_FRONTEIRA'  value='#arguments.VALOR_FRONTEIRA#'  null='#iif(len(trim(arguments.VALOR_FRONTEIRA)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'   dbvarname='P_VALOR_IRRF'  value='#arguments.VALOR_IRRF#'  null='#iif(len(trim(arguments.VALOR_IRRF)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'   dbvarname='P_VALOR_ADIANTAMENTO'  value='#arguments.VALOR_ADIANTAMENTO#'  null='#iif(len(trim(arguments.VALOR_ADIANTAMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'   dbvarname='P_VALOR_ICMS_RETIDO'  value='#arguments.VALOR_ICMS_RETIDO#'  null='#iif(len(trim(arguments.VALOR_ICMS_RETIDO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'   dbvarname='P_VALOR_LIQUIDO'  value='#arguments.VALOR_LIQUIDO#'  null='#iif(len(trim(arguments.VALOR_LIQUIDO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'   dbvarname='P_VALOR_FALTA_AVARIAS'  value='#arguments.VALOR_FALTA_AVARIAS#'  null='#iif(len(trim(arguments.VALOR_FALTA_AVARIAS)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'   dbvarname='P_VALOR_ADICIONAL'  value='#arguments.VALOR_ADICIONAL#'  null='#iif(len(trim(arguments.VALOR_ADICIONAL)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar'   dbvarname='P_DESCRICAO_VALOR_ADICIONAL'  value='#arguments.DESCRICAO_VALOR_ADICIONAL#' >
					<cfprocparam type='in' cfsqltype='cf_sql_float'   dbvarname='P_LIQUIDO_A_PAGAR'  value='#arguments.LIQUIDO_A_PAGAR#'  null='#iif(len(trim(arguments.LIQUIDO_A_PAGAR)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'   dbvarname='P_COTACAO_DOLAR'  value='#arguments.COTACAO_DOLAR#'  null='#iif(len(trim(arguments.COTACAO_DOLAR)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_NUM_DEPENDENTES'  value='#arguments.NUM_DEPENDENTES#'  null='#iif(len(trim(arguments.NUM_DEPENDENTES)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'   dbvarname='P_BASE_CALC_IRRF'  value='#arguments.BASE_CALC_IRRF#'  null='#iif(len(trim(arguments.BASE_CALC_IRRF)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_float'   dbvarname='P_OUTRAS_DEDUCOES'  value='#arguments.OUTRAS_DEDUCOES#'  null='#iif(len(trim(arguments.OUTRAS_DEDUCOES)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_DESCARGA_POR_CONTA_ID'  value='#arguments.DESCARGA_POR_CONTA_ID#'  null='#iif(len(trim(arguments.DESCARGA_POR_CONTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_OBSERVACOES'  value='#arguments.OBSERVACOES#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_AUTORIZAR_PAGTO_POR'  value='#arguments.AUTORIZAR_PAGTO_POR#'  null='#iif(len(trim(arguments.AUTORIZAR_PAGTO_POR)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_AUTORIZAR_PAGTO_DATA'  value='#arguments.AUTORIZAR_PAGTO_DATA#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_AUTORIZAR_ADTO_POR'  value='#arguments.AUTORIZAR_ADTO_POR#'  null='#iif(len(trim(arguments.AUTORIZAR_ADTO_POR)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_AUTORIZAR_ADTO_DATA'  value='#arguments.AUTORIZAR_ADTO_DATA#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_TIPO'  value='#arguments.TIPO#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_OPERADOR_VALOR_ADICIONAL'  value='#arguments.OPERACAO_VALOR_ADICIONAL#'   null='#iif(len(trim(arguments.OPERACAO_VALOR_ADICIONAL)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.DESPACHO_ID = arguments.DESPACHO_ID>
				<cfscript>
					v_id_mic              = this.ListaToArray (lista = arguments, variavel = "MIC_ITEM_ID_MIC");
					v_id_crt              = this.ListaToArray (lista = arguments, variavel = "CRT_ITEM_ID_CRT");
					v_manifesto_id        = this.ListaToArray (lista = arguments, variavel = "MANIFESTO_ID_MIC");
					v_mic_crt_mic         = this.ListaToArray (lista = arguments, variavel = "MIC_CRT_MIC");
					v_conhecimento_id     = this.ListaToArray (lista = arguments, variavel = "CONHECIMENTO_ID_CRT");
					v_item_excluir_mic    = this.ListDiff(lista1 = arguments.lista_deleted_MIC, lista2 = ArrayToList(v_id_mic));
					v_item_excluir_crt    = this.ListDiff(lista1 = arguments.lista_deleted_CRT, lista2 = ArrayToList(v_id_crt));
				</cfscript>
				<!--- Excluir os itens --->
				<cfloop list="#v_item_excluir_mic#" delimiters="," index="l_item_id">
					<cfscript>
						this.del_intc_dti_item(item_id   = l_item_id);
					</cfscript>
				</cfloop>
	
				<cfloop list="#v_item_excluir_crt#" delimiters="," index="l_item_id">
					<cfscript>
						this.del_intc_dti_item(item_id   = l_item_id);
					</cfscript>
				</cfloop>
	
				
				<!--- Insere Itens --->
				<cfloop from="1" to="#ArrayLen(v_manifesto_id)#" index="count">
					<cfscript>
						if(not len(trim(v_id_mic[count]))) {
							//caso o item_id seja nulo insere
							ret = this.ins_intc_dti_item(	despacho_id 		= arguments.despacho_id,
													conhecimento_id     = v_mic_crt_mic[count],
													manifesto_id		= v_manifesto_id[count]);
						} else {
							//caso o item_id seja nulo insere
							ret = this.upd_intc_dti_item(	item_id 		= v_id_mic[count],
													conhecimento_id = v_mic_crt_mic[count],
													manifesto_id	= v_manifesto_id[count]);
						}
					</cfscript>
					<cfif ret.erro>
						<cfthrow object="#ret.mensagem#">
					</cfif>

				</cfloop>				
	
				<cfloop from="1" to="#ArrayLen(v_conhecimento_id)#" index="count">
					<cfscript>
						if(not len(trim(v_id_crt[count]))) {
							//caso o item_id seja nulo insere
							ret = this.ins_intc_dti_item(	despacho_id 	= arguments.despacho_id,
													conhecimento_id = v_conhecimento_id[count],
													manifesto_id	= '');
						} else {
							ret = this.upd_intc_dti_item(	item_id 		= v_id_crt[count],
													conhecimento_id = v_conhecimento_id[count],
													manifesto_id	= '');
						}							
					</cfscript>
					<cfif ret.erro>
						<cfthrow object="#ret.mensagem#">
					</cfif>
				</cfloop>				
				
	
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('D.T.I. alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um DTI
	-- GUTO 19/12/2005 - criado
	--->
	<cffunction name='del_intc_despacho' displayname='Exclui um DTI' access='remote' returntype='Struct' output='true'>
		<cfargument name='DESPACHO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_del_intc_despacho' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_DESPACHO_ID'  value='#arguments.DESPACHO_ID#'  null='#iif(len(trim(arguments.DESPACHO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('D.T.I. excludo com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Cancela um DTI
	-- GUTO 03/03/2006 - criado
	--->
	<cffunction name='can_intc_despacho' displayname='Exclui um DTI' access='remote' returntype='Struct' output='true'>
		<cfargument name='DESPACHO_ID' required='yes'>
		<cfargument name='MOTIVO_CANCELAMENTO' required='no' default="">
		<cfdump var="#arguments#">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_can_intc_despacho' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_DESPACHO_ID'  value='#arguments.DESPACHO_ID#'  null='#iif(len(trim(arguments.DESPACHO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_MOTIVO_CANCELAMENTO'  value='#arguments.MOTIVO_CANCELAMENTO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('D.T.I. cancelado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	
	<!--- 
	-- PROPSITO
	-- Insere item ao DTI
	-- GUTO 19/12/2005 - criado
	--->
	<cffunction name='ins_intc_dti_item' displayname='Insere item ao DTI' access='remote' returntype='Struct' output='true'>
		<cfargument name='DESPACHO_ID' required='yes'>
		<cfargument name='CONHECIMENTO_ID' required='no'>
		<cfargument name='MANIFESTO_ID' required='no'>
		<cftry>
			<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_ins_dti_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_DESPACHO_ID'  value='#arguments.DESPACHO_ID#'  null='#iif(len(trim(arguments.DESPACHO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_MANIFESTO_ID'  value='#arguments.MANIFESTO_ID#'  null='#iif(len(trim(arguments.MANIFESTO_ID)), de('no'), de('yes'))#'>
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Item inserido com sucesso!')>		
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera item do DTI
	-- GUTO 19/12/2005 - criado
	--->
	<cffunction name='upd_intc_dti_item' displayname='Altera item do DTI' access='remote' returntype='Struct' output='true'>
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='MANIFESTO_ID' required='yes'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cftry>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_alt_dti_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_MANIFESTO_ID'  value='#arguments.MANIFESTO_ID#'  null='#iif(len(trim(arguments.MANIFESTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Item do DTI alterado com sucesso!')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	
	<!--- 
	-- PROPSITO
	-- Exclui item do dti
	-- GUTO 19/12/2005 - criado
	--->
	<cffunction name='del_intc_dti_item' displayname='Exclui item do dti' access='remote' returntype='Struct' output='true'>
		<cfargument name='ITEM_ID' required='yes'>
		<cftry>
			<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_del_dti_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#'>
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Item excluido com sucesso!')>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Insere uma nova fatura de CRT no sistema
	-- guto 01/02/2006 16:49:06 - CRIADO
	--->
	<cffunction name='ins_intc_fatura' displayname='Insere uma nova fatura de CRT no sistema' access='remote' returntype='Struct' output='true'>;
		<cfargument name='NUM_FATURA' required='yes'>
		<cfargument name='NUM_DUPLICATA' required='yes'>
		<cfargument name='COD_PESSOA_CLIENTE' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='DATA_VENCIMENTO' required='no' default="">
		<cfargument name='CONDICAO_VENDA_ID' required='no' default="">
		<cfargument name='OBSERVACAO' required='no' default="">
		<cfargument name='COD_MOEDA_FATURA' required='no' default="">
		<cfargument name='VALOR_TOTAL_FATURA' required='no' default="">
		<cfargument name='COD_MOEDA2' required='no' default="">
		<cfargument name='COTACAO_MOEDA2' required='no' default="">
		<cfargument name='VALOR_MOEDA2' required='no' default="">		
		<cfargument name='TIPO_FATURA' required='no' default="1">		
		<cfargument name='FATURA_ID_PAI' required='no' default="">		
		<cfargument name='FATURA_ID' required='no' default="">	
		<cfargument name='COD_TIPO' required='no' default="A">
		<cfargument name='VALOR_IVA' required='no' default="0">
		<cfargument name='ALIQUOTA_IVA' required='no' default="0">
		<cftry>
			<cfif Len(Trim(arguments.FATURA_ID))>
				<cfset retorno.FATURA_ID = arguments.FATURA_ID>
			</cfif>
			<cfif arguments.aliquota_iva eq ''>
				<cfset arguments.aliquota_iva = 0>
			</cfif>
			<cftransaction action='begin'>
				<cfif Len(Trim(arguments.FATURA_ID_PAI))>				
					<cfloop index="fat_id_pai" list="#arguments.FATURA_ID_PAI#" delimiters=",">
						<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_ins_fatura' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
							<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_NUM_FATURA'  value='#arguments.NUM_FATURA#'  null='#iif(len(trim(arguments.NUM_FATURA)), de('no'), de('yes'))#'>
							<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_NUM_DUPLICATA'  value='#arguments.NUM_DUPLICATA#'  null='#iif(len(trim(arguments.NUM_DUPLICATA)), de('no'), de('yes'))#'>
							<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_COD_PESSOA_FILIAL'  value='#session.COD_PESSOA#'  null='#iif(len(trim(session.COD_PESSOA)), de('no'), de('yes'))#'>
							<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_COD_PESSOA_CLIENTE'  value='#arguments.COD_PESSOA_CLIENTE#'  null='#iif(len(trim(arguments.COD_PESSOA_CLIENTE)), de('no'), de('yes'))#'>
							<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' >
							<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_VENCIMENTO'  value='#arguments.DATA_VENCIMENTO#' >
							<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale="5" dbvarname='P_CONDICAO_VENDA_ID'  value='#arguments.CONDICAO_VENDA_ID#'  null='#iif(len(trim(arguments.CONDICAO_VENDA_ID)), de('no'), de('yes'))#'>
							<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
							<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale="5" dbvarname='P_COD_MOEDA'  value='#arguments.COD_MOEDA_FATURA#'  null='#iif(len(trim(arguments.COD_MOEDA_FATURA)), de('no'), de('yes'))#'>
							<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale="5" dbvarname='P_VALOR_TOTAL'  value='#arguments.VALOR_TOTAL_FATURA#'  null='#iif(len(trim(arguments.VALOR_TOTAL_FATURA)), de('no'), de('yes'))#'>
							<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale="5" dbvarname='P_COD_MOEDA2'  value='#arguments.COD_MOEDA2#'  null='#iif(len(trim(arguments.COD_MOEDA2)), de('no'), de('yes'))#'>
							<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale="5" dbvarname='P_COTACAO_MOEDA2'  value='#arguments.COTACAO_MOEDA2#'  null='#iif(len(trim(arguments.COTACAO_MOEDA2)), de('no'), de('yes'))#'>
							<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale="5" dbvarname='P_VALOR_MOEDA2'  value='#arguments.VALOR_MOEDA2#'  null='#iif(len(trim(arguments.VALOR_MOEDA2)), de('no'), de('yes'))#'>
							<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale="5" dbvarname='P_TIPO_FATURA'  value='#arguments.TIPO_FATURA#'  null='#iif(len(trim(arguments.TIPO_FATURA)), de('no'), de('yes'))#'>
							<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale="5" dbvarname='P_FATURA_ID_PAI' value='#fat_id_pai#'>
							<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_TIPO'  value='#arguments.COD_TIPO#' >
							<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_IVA'  value='#arguments.VALOR_IVA#'  null='#iif(len(trim(arguments.VALOR_IVA)), de('no'), de('yes'))#'>
							<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ALIQUOTA_IVA'  value='#arguments.ALIQUOTA_IVA#'  null='#iif(len(trim(arguments.ALIQUOTA_IVA)), de('no'), de('yes'))#'>
							<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale="5" dbvarname='P_FATURA_ID' value='#arguments.FATURA_ID#'  null='#iif(len(trim(arguments.FATURA_ID)), de('no'), de('yes'))#' variable='retorno.FATURA_ID'>
							<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
						</cfstoredproc>
					</cfloop>
				<cfelse>
					<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_ins_fatura' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_NUM_FATURA'  value='#arguments.NUM_FATURA#'  null='#iif(len(trim(arguments.NUM_FATURA)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_NUM_DUPLICATA'  value='#arguments.NUM_DUPLICATA#'  null='#iif(len(trim(arguments.NUM_DUPLICATA)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_COD_PESSOA_FILIAL'  value='#session.COD_PESSOA#'  null='#iif(len(trim(session.COD_PESSOA)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_COD_PESSOA_CLIENTE'  value='#arguments.COD_PESSOA_CLIENTE#'  null='#iif(len(trim(arguments.COD_PESSOA_CLIENTE)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_VENCIMENTO'  value='#arguments.DATA_VENCIMENTO#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale="5" dbvarname='P_CONDICAO_VENDA_ID'  value='#arguments.CONDICAO_VENDA_ID#'  null='#iif(len(trim(arguments.CONDICAO_VENDA_ID)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale="5" dbvarname='P_COD_MOEDA'  value='#arguments.COD_MOEDA_FATURA#'  null='#iif(len(trim(arguments.COD_MOEDA_FATURA)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale="5" dbvarname='P_VALOR_TOTAL'  value='#arguments.VALOR_TOTAL_FATURA#'  null='#iif(len(trim(arguments.VALOR_TOTAL_FATURA)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale="5" dbvarname='P_COD_MOEDA2'  value='#arguments.COD_MOEDA2#'  null='#iif(len(trim(arguments.COD_MOEDA2)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale="5" dbvarname='P_COTACAO_MOEDA2'  value='#arguments.COTACAO_MOEDA2#'  null='#iif(len(trim(arguments.COTACAO_MOEDA2)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale="5" dbvarname='P_VALOR_MOEDA2'  value='#arguments.VALOR_MOEDA2#'  null='#iif(len(trim(arguments.VALOR_MOEDA2)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale="5" dbvarname='P_TIPO_FATURA'  value='#arguments.TIPO_FATURA#'  null='#iif(len(trim(arguments.TIPO_FATURA)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale="5" dbvarname='P_FATURA_ID_PAI' value='#arguments.FATURA_ID_PAI#'  null='#iif(len(trim(arguments.FATURA_ID_PAI)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_TIPO'  value='#arguments.COD_TIPO#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_IVA'  value='#arguments.VALOR_IVA#'  null='#iif(len(trim(arguments.VALOR_IVA)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ALIQUOTA_IVA'  value='#arguments.ALIQUOTA_IVA#'  null='#iif(len(trim(arguments.ALIQUOTA_IVA)), de('no'), de('yes'))#'>
						<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale="5" dbvarname='P_FATURA_ID' value='#arguments.FATURA_ID#'  null='#iif(len(trim(arguments.FATURA_ID)), de('no'), de('yes'))#' variable='retorno.FATURA_ID'>
						<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
					</cfstoredproc>
				</cfif>

				<!--- Insercao dos itens da fatura --->
				<cfscript>
					v_item_id = this.ListaToArray (lista = arguments, variavel = "ITEM_ID_ITENS");
					v_conhecimento_id = this.ListaToArray (lista = arguments, variavel = "CONHECIMENTO_ID_ITENS");
					v_historico = this.ListaToArray (lista = arguments, variavel = "HISTORICO_ITENS");
					v_valor_total = this.ListaToArray (lista = arguments, variavel = "VALOR_TOTAL_ITENS");
					v_cod_moeda = this.ListaToArray (lista = arguments, variavel = "COD_MOEDA_ITENS");
					v_item_excluir = this.ListDiff(lista1 = arguments.lista_deleted_ITENS, lista2 = ArrayToList(v_item_id));
				</cfscript>
				<cfloop list="#v_item_excluir#" delimiters="," index="l_item_id">
					<cfscript>
						this.del_fatura_item_private (fatura_id = retorno.FATURA_ID,
													   ITEM_ID		 = l_item_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_item_id)#" index="count">
					<cfscript>
						if(not len(trim(v_item_id[count]))) {
							this.ins_intc_fatura_item(	fatura_id = retorno.fatura_id,
														conhecimento_id = v_conhecimento_id[count],
														historico = v_historico[count],
														cod_moeda = v_cod_moeda[count],
														valor_total = v_valor_total[count]);
						} else {
							this.upd_fatura_item_private(fatura_id = retorno.fatura_id,
														 conhecimento_id = v_conhecimento_id[count],
														 historico = v_historico[count],
														 cod_moeda = v_cod_moeda[count],
														 valor_total = v_valor_total[count],
														 item_id 		= v_item_id[count]);
						}
					</cfscript>
				</cfloop>				
				
                <cfif arguments.tipo_fatura eq 2>
					<!--- Insercao dos itens da fatura --->
                    <cfscript>
                        v_pagto_id = this.ListaToArray (lista = arguments, variavel = "CHEQUE_PAGTO_ID_CHEQUES");
                        v_item_excluir = this.ListDiff(lista1 = arguments.lista_deleted_CHEQUES, lista2 = ArrayToList(v_pagto_id));
                    </cfscript>
                    <cfloop list="#v_item_excluir#" delimiters="," index="l_item_id">
                        <cfscript>
                            ret = this.del_intc_fatura_cheque(	fatura_id 	= retorno.FATURA_ID,
                                                                pagto_id	= l_item_id);
                        </cfscript>
                        <cfif ret.erro>
                            <cfthrow object="#ret.mensagem#">
                        </cfif>
                    </cfloop>
                    <cfloop from="1" to="#ArrayLen(v_pagto_id)#" index="count">
                        <cfscript>
                            ret = this.ins_intc_fatura_cheque(	fatura_id 	= retorno.fatura_id,
                                                                pagto_id	= v_pagto_id[count]);
                        </cfscript>
                        <cfif ret.erro>
                            <cfthrow object="#ret.mensagem#">
                        </cfif>
                    </cfloop>				
				</cfif>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Fatura inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Insere um item a uma fatura
	-- guto 01/02/2006 16:50:51 - CRIADO
	--->
	<cffunction name='ins_intc_fatura_item' displayname='Insere um item a uma fatura' access='remote' returntype='Struct' output='true'>;
		<cfargument name='FATURA_ID' required='yes'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cfargument name='HISTORICO' required='yes'>
		<cfargument name='COD_MOEDA' required='yes'>
		<cfargument name='VALOR_TOTAL' required='yes'>
			<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_ins_fatura_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_FATURA_ID'  value='#arguments.FATURA_ID#'  null='#iif(len(trim(arguments.FATURA_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_HISTORICO'  value='#arguments.HISTORICO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_COD_MOEDA'  value='#arguments.COD_MOEDA#'  null='#iif(len(trim(arguments.COD_MOEDA)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale="5" dbvarname='P_VALOR_TOTAL'  value='#arguments.VALOR_TOTAL#'  null='#iif(len(trim(arguments.VALOR_TOTAL)), de('no'), de('yes'))#'>
			</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Muda a situao do CRT para cancelado.
	-- guto 01/02/2006 17:16:28 - CRIADO
	--->
	<cffunction name='crt_cancelar' displayname='Muda a situa??o do CRT para cancelado.' access='remote' returntype='Struct' output='true'>;
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_crt_cancelado' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('CRT cancelado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Muda a situao do CRT para liberado para fatura
	-- guto 01/02/2006 17:27:55 - CRIADO
	--->
	<cffunction name='crt_libera_fatura' displayname='Muda a situa??o do CRT para liberado para fatura' access='remote' returntype='Struct' output='true'>;
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfloop list="#arguments.CONHECIMENTO_ID#" index="i" delimiters=",">
					<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_crt_liberado_fatura' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_CONHECIMENTO_ID'  value='#i#' >
					</cfstoredproc>
				</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('CRT(s) liberado(s) para fatura!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Muda a situao do CRT para quitado
	-- guto 01/02/2006 17:31:53 - CRIADO
	--->
	<cffunction name='crt_quitado' displayname='Muda a situao do CRT para quitado' access='remote' returntype='Struct' output='true'>;
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_crt_quitado' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('CRT quitado!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Muda a situao do CRT para contabilizado
	-- guto 01/02/2006 17:44:43 - CRIADO
	--->
	<cffunction name='crt_contabilizado' displayname='Muda a situa??o do CRT para contabilizado' access='remote' returntype='Struct' output='true'>;
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_crt_contabilizado' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('CRT marcado como contabilizado!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Muda a situao do CRT para no contabilizado
	-- Wagner 15/11/2006 17:44:43 - CRIADO
	--->
	<cffunction name='crt_estorna_contabilizado' displayname='Muda a situa??o do CRT para no contabilizado' access='remote' returntype='Struct' output='true'>;
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_crt_estorna_contabilizado' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('CRT desmarcado como contabilizado!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Retorna proximo numero sequencial
	-- NOTAS EXPLICATIVAS
	-- RAFAEL  13/05/2009
	--->		
	<cffunction name="get_prox_num_sequencial" access="package" returntype="string" output="true">
		<cfargument name="cod_pais" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select fiscal.pkg_transp_internacional.fnc_prox_num_seq('#arguments.cod_pais#') as PERMISSO_PROX_SEQUENCA
              from dual
    	</cfquery>
		<cfreturn qr_result.PERMISSO_PROX_SEQUENCAL>		
	</cffunction>		

	<!--- 
	-- PROPSITO
	-- Insere um novo tipo de ocorrencia de viagem
	-- cristofer 23/02/2006 09:29:58 - CRIADO
	--->
	<cffunction name='ins_intc_ocorrencia' displayname='Insere um novo tipo de ocorrencia de viagem' access='remote' returntype='Struct' output='true'>;
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='TIPO_DADO' required='yes'>
		<cfargument name='RASTREABILIDADE' required='no' default="0">
		<cfargument name='POR_CRT' required='no' default="0">
		<cfargument name='ETAPAS' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_intc_viagem.prc_ins_intc_ocorrencia' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TIPO_DADO'  value='#arguments.TIPO_DADO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_RASTREABILIDADE'  value='#arguments.RASTREABILIDADE#'  null='#iif(len(trim(arguments.RASTREABILIDADE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_POR_CRT'  value='#arguments.POR_CRT#'  null='#iif(len(trim(arguments.POR_CRT)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_ETAPAS'  value='#this.get_binario_etapas(etapas = arguments.ETAPAS)#'  null='#iif(len(trim(arguments.ETAPAS)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_OCORRENCIA_ID' variable='retorno.OCORRENCIA_ID'  null='#iif(len(trim(arguments.OCORRENCIA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfscript>
					arguments.ocorrencia_id = retorno.ocorrencia_id;
					v_valor = this.ListaToArray (lista = arguments, variavel = "VALOR_LISTA");
					v_item_id = this.ListaToArray (lista = arguments, variavel = "ITEM_ID_LISTA");
					v_item_excluir = this.ListDiff(lista1 = arguments.lista_deleted_LISTA, lista2 = ArrayToList(v_item_id));
				</cfscript>
				<cfloop list="#v_item_excluir#" delimiters="," index="l_item_id">
					<cfscript>
						this.del_intc_ocorrencia_item_private (OCORRENCIA_ID = arguments.ocorrencia_id,
															   ITEM_ID		 = l_item_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_item_id)#" index="count">
					<cfscript>
						if(not len(trim(v_item_id[count]))) {
							this.ins_intc_ocorrencia_item_private(	valor 			= v_valor[count],
																	ocorrencia_id 	= arguments.ocorrencia_id);
						} else {
							this.upd_intc_ocorrencia_item_private(	ocorrencia_id 	= arguments.ocorrencia_id,
																	valor 			= v_valor[count],
																	item_id 		= v_item_id[count]);
						}
					</cfscript>
				</cfloop>				
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Ocorrncia inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Altera um tipo de ocorrencia de viagem
	-- cristofer 23/02/2006 09:31:19 - CRIADO
	--->
	<cffunction name='upd_intc_ocorrencia' displayname='Altera um tipo de ocorrencia de viagem' access='remote' returntype='Struct' output='true'>;
		<cfargument name='OCORRENCIA_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='TIPO_DADO' required='yes'>
		<cfargument name='RASTREABILIDADE' required='no' default="0">
		<cfargument name='POR_CRT' required='no' default="0">
		<cfargument name='ETAPAS' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_intc_viagem.prc_alt_intc_ocorrencia' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_OCORRENCIA_ID'  value='#arguments.OCORRENCIA_ID#'  null='#iif(len(trim(arguments.OCORRENCIA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TIPO_DADO'  value='#arguments.TIPO_DADO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_RASTREABILIDADE'  value='#arguments.RASTREABILIDADE#'  null='#iif(len(trim(arguments.RASTREABILIDADE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_POR_CRT'  value='#arguments.POR_CRT#'  null='#iif(len(trim(arguments.POR_CRT)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_ETAPAS'  value='#this.get_binario_etapas(etapas = arguments.ETAPAS)#'  null='#iif(len(trim(arguments.ETAPAS)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfscript>
					v_valor = this.ListaToArray (lista = arguments, variavel = "VALOR_LISTA");
					v_item_id = this.ListaToArray (lista = arguments, variavel = "ITEM_ID_LISTA");
					v_item_excluir = this.ListDiff(lista1 = arguments.lista_deleted_LISTA, lista2 = ArrayToList(v_item_id));
				</cfscript>
				<cfloop list="#v_item_excluir#" delimiters="," index="l_item_id">
					<cfscript>
						this.del_intc_ocorrencia_item_private (OCORRENCIA_ID = arguments.ocorrencia_id,
															   ITEM_ID		 = l_item_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_item_id)#" index="count">
					<cfscript>
						if(not len(trim(v_item_id[count]))) {
							this.ins_intc_ocorrencia_item_private(	valor 			= v_valor[count],
																	ocorrencia_id 	= arguments.ocorrencia_id);
						} else {
							this.upd_intc_ocorrencia_item_private(	ocorrencia_id 	= arguments.ocorrencia_id,
																	valor 			= v_valor[count],
																	item_id 		= v_item_id[count]);
						}
					</cfscript>
				</cfloop>				
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Ocorrncia alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um tipo de ocorrencia de viagem
	-- cristofer 23/02/2006 09:32:11 - CRIADO
	--->
	<cffunction name='del_intc_ocorrencia' displayname='Exclui um tipo de ocorrencia de viagem' access='remote' returntype='Struct' output='true'>;
		<cfargument name='OCORRENCIA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_intc_viagem.prc_del_intc_ocorrencia' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_OCORRENCIA_ID'  value='#arguments.OCORRENCIA_ID#'  null='#iif(len(trim(arguments.OCORRENCIA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Ocorrncia excluida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Insere um item para um ocorrencia de lista
	-- cristofer 23/02/2006 10:04:22 - CRIADO
	--->
	<cffunction name='ins_intc_ocorrencia_item_private' displayname='Insere um item para um ocorrencia de lista' access='remote' returntype='Struct' output='true'>;
		<cfargument name='VALOR' required='yes'>
		<cfargument name='OCORRENCIA_ID' required='yes'>
				<cfstoredproc procedure='oper.pkg_intc_viagem.prc_ins_intc_ocorrencia_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_VALOR'  value='#arguments.VALOR#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_OCORRENCIA_ID'  value='#arguments.OCORRENCIA_ID#'  null='#iif(len(trim(arguments.OCORRENCIA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_ITEM_ID' variable='retorno.ITEM_ID'>
				</cfstoredproc>
		<cfset retorno = structNew()>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Altera um item para um ocorrencia de lista
	-- cristofer 23/02/2006 10:05:12 - CRIADO
	--->
	<cffunction name='upd_intc_ocorrencia_item_private' displayname='Altera um item para um ocorrencia de lista' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='VALOR' required='yes'>
		<cfargument name='OCORRENCIA_ID' required='yes'>
				<cfstoredproc procedure='oper.pkg_intc_viagem.prc_alt_intc_ocorrencia_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_VALOR'  value='#arguments.VALOR#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_OCORRENCIA_ID'  value='#arguments.OCORRENCIA_ID#'  null='#iif(len(trim(arguments.OCORRENCIA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfset retorno = structNew()>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um item para um ocorrencia de lista
	-- cristofer 23/02/2006 10:05:47 - CRIADO
	--->
	<cffunction name='del_intc_ocorrencia_item_private' displayname='Exclui um item para um ocorrencia de lista' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='OCORRENCIA_ID' required='yes'>
				<cfstoredproc procedure='oper.pkg_intc_viagem.prc_del_intc_ocorrencia_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_OCORRENCIA_ID'  value='#arguments.OCORRENCIA_ID#'  null='#iif(len(trim(arguments.OCORRENCIA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfset retorno = structNew()>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Insere um pagamento de fatura
	-- cristofer 09/03/2006 09:45:50 - CRIADO
	--->
	<cffunction name='ins_pagamento' displayname='Insere um pagamento de fatura' access='remote' returntype='Struct' output='true'>
		<cfargument name='FATURA_ID' required='yes'>
		<cfargument name='FORMA_PAGTO_ID' required='yes'>
		<cfargument name='DATA_LANCAMENTO' required='yes'>
		<cfargument name='COD_MOEDA' required='yes'>
		<cfargument name='VALOR' required='yes'>
		<cfargument name='COD_MOEDA2' required='yes'>
		<cfargument name='COTACAO_MOEDA2' required='yes'>
		<cfargument name='VALOR_MOEDA2' required='yes'>
		<cfargument name='NUM_RECIBO' required='yes'>
		<cfargument name='PAGTO_ID' required='no' default="">
	    <cfargument name='LISTA_ATRIBUTOS' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_ins_pagamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_FATURA_ID'  value='#arguments.FATURA_ID#'  null='#iif(len(trim(arguments.FATURA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_FORMA_PAGTO_ID'  value='#arguments.FORMA_PAGTO_ID#'  null='#iif(len(trim(arguments.FORMA_PAGTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_LANCAMENTO'  value='#arguments.DATA_LANCAMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_COD_MOEDA'  value='#arguments.COD_MOEDA#'  null='#iif(len(trim(arguments.COD_MOEDA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale="5" dbvarname='P_VALOR'  value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_COD_MOEDA2'  value='#arguments.COD_MOEDA2#'  null='#iif(len(trim(arguments.COD_MOEDA2)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale="5" dbvarname='P_COTACAO_MOEDA2'  value='#arguments.COTACAO_MOEDA2#'  null='#iif(len(trim(arguments.COTACAO_MOEDA2)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale="5" dbvarname='P_VALOR_MOEDA2'  value='#arguments.VALOR_MOEDA2#'  null='#iif(len(trim(arguments.VALOR_MOEDA2)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_NUM_RECIBO'  value='#arguments.NUM_RECIBO#'  null='#iif(len(trim(arguments.NUM_RECIBO)), de('no'), de('yes'))#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_PAGTO_ID'  value='#arguments.PAGTO_ID#' variable='retorno.PAGTO_ID'  null='#iif(len(trim(arguments.PAGTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<!--- Caso seja cheque --->
				<cfscript>
					conn = CreateObject("component", "_transportes.consulta.cfc_transp_internacional");
					qrAtributo = conn.get_atributos_forma_pagto();
				</cfscript>
				<cfoutput query="qrAtributo">
					<cfif ListFind(arguments.LISTA_ATRIBUTOS,qrAtributo.COD_ATRIBUTO,',')>
						<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_set_pagto_atributo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
							<cfprocparam type='IN' cfsqltype='CF_SQL_INTEGER' dbvarname='P_PAGTO_ID'  value='#retorno.pagto_id#'  null='#iif(len(trim(retorno.pagto_id)), de('no'), de('yes'))#'>
							<cfprocparam type='IN' cfsqltype='CF_SQL_INTEGER' dbvarname='P_ATRIBUTO_ID'  value='#qrAtributo.ATRIBUTO_ID#'  null='#iif(len(trim(qrAtributo.ATRIBUTO_ID)), de('no'), de('yes'))#'>
							<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_VALOR'  value='#arguments[qrAtributo.COD_ATRIBUTO]#' >
						</cfstoredproc>
					</cfif>
				</cfoutput>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Pagamento efetuado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	


	<!--- 
	-- PROPSITO
	-- Altera os dados do pagamento
	-- cristofer 09/03/2006 09:45:50 - CRIADO
	--->
	<cffunction name='upd_pagamento_atributos' displayname='Insere um pagamento de fatura' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PAGTO_ID' required='no' default="">
		<cfargument name='LISTA_ATRIBUTOS' required='no' default="">
		<cftry>
            <cftransaction action='begin'>
                <cfif arguments.OPERACAO neq 3 and arguments.CONFIRCAO_CHEQUE eq 1>
                	<cfloop list="#arguments.pagto_id#" index="v_pagto_id" delimiters=",">
						<cfscript>
                            this.ins_deposito_cheque(num_cheque            = arguments.num_cheque,
                                                     banco	               = arguments.banco,
                                                     num_controle_deposito = arguments.num_controle_deposito,
                                                     data_lancamento 	   = arguments.data_deposito,
                                                     caixa_id_debito       = arguments.caixa_id_debito,
                                                     cod_centro_custo      = session.cod_centro_custo,
                                                     caixa_id_credito      = arguments.caixa_id_credito,
                                                     pagto_id			   = v_pagto_id);
                        </cfscript>
                    </cfloop>
                <cfelseif arguments.OPERACAO neq 3 and arguments.CONFIRCAO_CHEQUE eq 0> 
                	<cfloop list="#arguments.pagto_id#" index="v_pagto_id" delimiters=",">
						<cfscript>
                            this.ins_cheque_rechazado(num_cheque      = arguments.num_cheque,
                                                      banco	          = arguments.banco,
                                                      data_lancamento = arguments.data_rechazado,
                                                      pagto_id		  = v_pagto_id);
                        </cfscript>
                    </cfloop>
                </cfif>

				<cfscript>
					conn = CreateObject("component", "_transportes.consulta.cfc_transp_internacional");
					qrAtributo = conn.get_atributos_forma_pagto();
				</cfscript>
				<cfloop list="#arguments.pagto_id#" index="v_pagto_id" delimiters=",">
					<cfoutput query="qrAtributo">
						<cfif ListFind(arguments.LISTA_ATRIBUTOS,qrAtributo.COD_ATRIBUTO,',')>
							<cfif qrAtributo.COD_ATRIBUTO neq 'VALOR_CHEQUE'>
								<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_set_pagto_atributo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
									<cfprocparam type='IN' cfsqltype='CF_SQL_INTEGER' dbvarname='P_PAGTO_ID'  value='#v_pagto_id#'  null='#iif(len(trim(v_pagto_id)), de('no'), de('yes'))#'>
									<cfprocparam type='IN' cfsqltype='CF_SQL_INTEGER' dbvarname='P_ATRIBUTO_ID'  value='#qrAtributo.ATRIBUTO_ID#'  null='#iif(len(trim(qrAtributo.ATRIBUTO_ID)), de('no'), de('yes'))#'>
									<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_VALOR'  value='#arguments[qrAtributo.COD_ATRIBUTO]#' >
								</cfstoredproc>
							</cfif>
						</cfif>
					</cfoutput>
				</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Cheque alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>

		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
    -- PROPSITO
    -- Insere lanamentos no caixa do cheque rechazado
    -- guto 28/06/2007 15:16:55 - CRIADO
    --->
    <cffunction name='ins_cheque_rechazado' displayname='Insere lanamentos no caixa do cheque rechazado' access='remote' returntype='Struct' output='true'>
        <cfargument name='NUM_CHEQUE' required='yes'>
        <cfargument name='BANCO' required='yes'>
        <cfargument name='DATA_LANCAMENTO' required='yes'>
        <cfargument name='PAGTO_ID' required='yes'>
                <cfstoredproc procedure='finan.pkg_cxa_intc.prc_cheque_rechazado' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUM_CHEQUE'  value='#arguments.NUM_CHEQUE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_BANCO'  value='#arguments.BANCO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_LANCAMENTO'  value='#arguments.DATA_LANCAMENTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PAGTO_ID'  value='#arguments.PAGTO_ID#'  null='#iif(len(trim(arguments.PAGTO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
        <cfreturn structnew() />
    </cffunction>

	<!--- 
    -- PROPSITO
    -- Insere lanamento do cheque relacionado ao depsito
    -- guto 28/06/2007 15:12:46 - CRIADO
    --->
    <cffunction name='ins_deposito_cheque' displayname='Insere lanamento do cheque relacionado ao depsito' access='remote' returntype='Struct' output='true'>
        <cfargument name='NUM_CHEQUE' required='yes'>
        <cfargument name='BANCO' required='yes'>
        <cfargument name='NUM_CONTROLE_DEPOSITO' required='yes'>
        <cfargument name='CAIXA_ID_DEBITO' required='yes'>
        <cfargument name='COD_CENTRO_CUSTO' required='yes'>
        <cfargument name='CAIXA_ID_CREDITO' required='yes'>
        <cfargument name='PAGTO_ID' required='yes'>
                <cfstoredproc procedure='finan.pkg_cxa_intc.prc_ins_deposito_cheque' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUM_CHEQUE'  value='#arguments.NUM_CHEQUE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_BANCO'  value='#arguments.BANCO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUM_CONTROLE_DEPOSITO'  value='#arguments.NUM_CONTROLE_DEPOSITO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_LANCAMENTO'  value='#arguments.DATA_LANCAMENTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CAIXA_ID_DEBITO'  value='#arguments.CAIXA_ID_DEBITO#'  null='#iif(len(trim(arguments.CAIXA_ID_DEBITO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CAIXA_ID_CREDITO'  value='#arguments.CAIXA_ID_CREDITO#'  null='#iif(len(trim(arguments.CAIXA_ID_CREDITO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PAGTO_ID'  value='#arguments.PAGTO_ID#'  null='#iif(len(trim(arguments.PAGTO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
        <cfreturn structnew() />
    </cffunction>    

	<!--- 
	-- PROPSITO
	-- Vincula notas de crdito ou dbito a uma fatura
	-- guto 10/03/2006 16:46:51 - CRIADO
	--->
	<cffunction name='vincula_nota_cred_deb_fatura' displayname='Vincula notas de cr?dito ou d?bito a uma fatura' access='remote' returntype='Struct' output='true'>;
		<cfargument name='FATURA_NOTA_ID' required='yes'>
		<cfargument name='FATURA_ID' required='yes'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_vincula_fatura_notas' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_FATURA_NOTA_ID'  value='#arguments.FATURA_NOTA_ID#'  null='#iif(len(trim(arguments.FATURA_NOTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_FATURA_ID'  value='#arguments.FATURA_ID#'  null='#iif(len(trim(arguments.FATURA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Marca fatura como EMITIDA
	-- guto 10/03/2006 16:46:51 - CRIADO
	--->
	<cffunction name='set_intc_fatura_emitida' displayname='Vincula notas de cr?dito ou d?bito a uma fatura' access='remote' returntype='Struct' output='true'>;
		<cfargument name='FATURA_ID' required='yes'>
		<cfargument name='EMITIDA' required='yes'>
      
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_fatura_emitida' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_FATURA_ID'  value='#arguments.FATURA_ID#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_SETADO'  value='#arguments.EMITIDA#'>
                </cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Cancela ou descancela uma fatura
	-- cristofer 13/03/2006 16:46:51 - CRIADO
	--->
	<cffunction name='set_intc_cancela_fatura' displayname='' access='remote' returntype='Struct' output='true'>;
		<cfargument name='FATURA_ID' required='yes'>
		<cfargument name='SETADO' required='yes'>
		<cftry>
			<cftransaction action='begin'>		
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_cancela_fatura' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_FATURA_ID'  value='#arguments.FATURA_ID#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_SETADO'  value='#arguments.setado#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Fatura alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>		
		</cftry>		
		<cfreturn retorno />
	</cffunction>				
	
	<!--- 
	-- PROPSITO
	-- Altera os dados da fatura
	-- cristofer 14/03/2006 09:45:33 - CRIADO
	--->
	<cffunction name='upd_fatura' displayname='Altera os dados da fatura' access='remote' returntype='Struct' output='true'>;
		<cfargument name='FATURA_ID' required='yes'>
		<cfargument name='NUM_FATURA' required='yes'>
		<cfargument name='COD_PESSOA_FILIAL' required='yes'>
		<cfargument name='COD_PESSOA_CLIENTE' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='DATA_VENCIMENTO' required='yes'>
		<cfargument name='CONDICAO_VENDA_ID' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
		<cfargument name='COD_MOEDA' required='yes'>
		<cfargument name='VALOR_TOTAL' required='yes'>
		<cfargument name='COD_MOEDA2' required='yes'>
		<cfargument name='COTACAO_MOEDA2' required='yes'>
		<cfargument name='VALOR_MOEDA2' required='yes'>
		<cfargument name='TIPO_FATURA' required='yes'>
		<cfargument name='FATURA_ID_PAI' required='yes'>
		<cfargument name='COD_TIPO' required='no' default="A">
		<cfargument name='VALOR_IVA' required='no' default="0">
		<cfargument name='ALIQUOTA_IVA' required='no' default="0">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_alt_fatura' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_FATURA_ID'  value='#arguments.FATURA_ID#'  null='#iif(len(trim(arguments.FATURA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_NUM_FATURA'  value='#arguments.NUM_FATURA#'  null='#iif(len(trim(arguments.NUM_FATURA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_COD_PESSOA_FILIAL'  value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_COD_PESSOA_CLIENTE'  value='#arguments.COD_PESSOA_CLIENTE#'  null='#iif(len(trim(arguments.COD_PESSOA_CLIENTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_VENCIMENTO'  value='#arguments.DATA_VENCIMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_CONDICAO_VENDA_ID'  value='#arguments.CONDICAO_VENDA_ID#'  null='#iif(len(trim(arguments.CONDICAO_VENDA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_COD_MOEDA'  value='#arguments.COD_MOEDA#'  null='#iif(len(trim(arguments.COD_MOEDA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale="5" dbvarname='P_VALOR_TOTAL'  value='#arguments.VALOR_TOTAL#'  null='#iif(len(trim(arguments.VALOR_TOTAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_COD_MOEDA2'  value='#arguments.COD_MOEDA2#'  null='#iif(len(trim(arguments.COD_MOEDA2)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale="5" dbvarname='P_COTACAO_MOEDA2'  value='#arguments.COTACAO_MOEDA2#'  null='#iif(len(trim(arguments.COTACAO_MOEDA2)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale="5" dbvarname='P_VALOR_MOEDA2'  value='#arguments.VALOR_MOEDA2#'  null='#iif(len(trim(arguments.VALOR_MOEDA2)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_TIPO_FATURA'  value='#arguments.TIPO_FATURA#'  null='#iif(len(trim(arguments.TIPO_FATURA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_FATURA_ID_PAI'  value='#arguments.FATURA_ID_PAI#'  null='#iif(len(trim(arguments.FATURA_ID_PAI)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_TIPO'  value='#arguments.COD_TIPO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_IVA'  value='#arguments.VALOR_IVA#'  null='#iif(len(trim(arguments.VALOR_IVA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ALIQUOTA_IVA'  value='#arguments.ALIQUOTA_IVA#'  null='#iif(len(trim(arguments.ALIQUOTA_IVA)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfscript>
					v_item_id = this.ListaToArray (lista = arguments, variavel = "ITEM_ID_ITENS");
					v_conhecimento_id = this.ListaToArray (lista = arguments, variavel = "CONHECIMENTO_ID_ITENS");
					v_historico = this.ListaToArray (lista = arguments, variavel = "HISTORICO_ITENS");
					v_valor_total = this.ListaToArray (lista = arguments, variavel = "VALOR_TOTAL_ITENS");
					v_cod_moeda = this.ListaToArray (lista = arguments, variavel = "COD_MOEDA_ITENS");
					v_item_excluir = this.ListDiff(lista1 = arguments.lista_deleted_ITENS, lista2 = ArrayToList(v_item_id));
				</cfscript>
				<cfloop list="#v_item_excluir#" delimiters="," index="l_item_id">
					<cfscript>
						this.del_fatura_item_private (fatura_id = arguments.fatura_id,
													   ITEM_ID		 = l_item_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_item_id)#" index="count">
					<cfscript>
						if(not len(trim(v_item_id[count]))) {
							this.ins_intc_fatura_item(	fatura_id = arguments.fatura_id,
														conhecimento_id = v_conhecimento_id[count],
														historico = v_historico[count],
														cod_moeda = v_cod_moeda[count],
														valor_total = v_valor_total[count]);
						} else {
							this.upd_fatura_item_private(fatura_id = arguments.fatura_id,
														 conhecimento_id = v_conhecimento_id[count],
														 historico = v_historico[count],
														 cod_moeda = v_cod_moeda[count],
														 valor_total = v_valor_total[count],
														 item_id 		= v_item_id[count]);
						}
					</cfscript>
				</cfloop>				
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Fatura alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Altera os dados de um item da fatura
	-- cristofer 14/03/2006 09:47:22 - CRIADO
	--->
	<cffunction name='upd_fatura_item_private' displayname='Altera os dados de um item da fatura' access='remote' returntype='Struct' output='true'>;
		<cfargument name='FATURA_ID' required='yes'>
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cfargument name='HISTORICO' required='yes'>
		<cfargument name='COD_MOEDA' required='yes'>
		<cfargument name='VALOR_TOTAL' required='yes'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_alt_fatura_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_FATURA_ID'  value='#arguments.FATURA_ID#'  null='#iif(len(trim(arguments.FATURA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_HISTORICO'  value='#arguments.HISTORICO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_COD_MOEDA'  value='#arguments.COD_MOEDA#'  null='#iif(len(trim(arguments.COD_MOEDA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale="5" dbvarname='P_VALOR_TOTAL'  value='#arguments.VALOR_TOTAL#'  null='#iif(len(trim(arguments.VALOR_TOTAL)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Exclui os dados de um item da fatura
	-- cristofer 14/03/2006 09:49:07 - CRIADO
	--->
	<cffunction name='del_fatura_item_private' displayname='Exclui os dados de um item da fatura' access='remote' returntype='Struct' output='true'>;
		<cfargument name='FATURA_ID' required='yes'>
		<cfargument name='ITEM_ID' required='yes'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_del_fatura_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_FATURA_ID'  value='#arguments.FATURA_ID#'  null='#iif(len(trim(arguments.FATURA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>		

	<!--- 
	-- PROPSITO
	-- Insere ou atualiza taxa de seguro para origem/destino
	-- guto 14/03/2006 09:48:30 - CRIADO
	--->
	<cffunction name='ins_upd_seguro_uf_taxa' displayname='Insere ou atualiza taxa de seguro para origem/destino' access='remote' returntype='Struct' output='true'>;
		<cfargument name='UF_ORIGEM' required='yes'>
		<cfargument name='UF_DESTINO' required='yes'>
		<cfargument name='TAXA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_ins_seguro_uf_taxa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_UF_ORIGEM'  value='#arguments.UF_ORIGEM#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_UF_DESTINO'  value='#arguments.UF_DESTINO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale="5" dbvarname='P_TAXA'  value='#arguments.TAXA#'  null='#iif(len(trim(arguments.TAXA)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Taxa atualizada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Exclui um pagamento de uma conta
	-- CRISTOFER 28/03/2006 09:48:30 - CRIADO
	--->
	<cffunction name='del_pagamento' displayname='Exclui um pagamento de uma conta' access='remote' returntype='Struct' output='true'>;
		<cfargument name='pagto_id' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_del_pagamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale="5" dbvarname='P_PAGTO_ID'  value='#arguments.PAGTO_ID#'  null='#iif(len(trim(arguments.PAGTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Pagamento excluido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>		
    
    <!--- 
	-- PROPSITO
	-- Inserir um novo local de transbordo.
	-- FABIOG 01/04/2011 18:36:50 - CRIADO
	--->
	<cffunction name='ins_intc_local_transbordo' displayname='Inserir um local de transbordo.' access='remote' returntype='Struct' output='true'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='MUNICIPIO_ID' required='no'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_ins_intc_local_transbordo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#'  null='#iif(len(trim(arguments.DESCRICAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MUNICIPIO_ID'  value='#arguments.MUNICIPIO_ID#'  null='#iif(len(trim(arguments.MUNICIPIO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Local de Transbordo inserido com sucesso')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
    
    <!--- 
	-- PROPSITO
	-- Altera um local de transbordo.
	-- FABIOG 01/04/2011 18:39:51 - CRIADO
	--->
	<cffunction name='upd_intc_local_transbordo' displayname='Altera um local de transbordo.' access='remote' returntype='Struct' output='true'>
		<cfargument name='LOCAL_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='MUNICIPIO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_upd_intc_local_transbordo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LOCAL_ID'  value='#arguments.LOCAL_ID#'  null='#iif(len(trim(arguments.LOCAL_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MUNICIPIO_ID'  value='#arguments.MUNICIPIO_ID#'  null='#iif(len(trim(arguments.MUNICIPIO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Local de Transbordo alterado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Exclui um local de transbordo.
	-- FABIOG 01/04/2011 18:41:09 - CRIADO
	--->
	<cffunction name='del_intc_local_transbordo' displayname='Exclui um local de transbordo.' access='remote' returntype='Struct' output='true'>
		<cfargument name='LOCAL_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_del_intc_local_transbordo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LOCAL_ID'  value='#arguments.LOCAL_ID#'  null='#iif(len(trim(arguments.LOCAL_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Local de Transbordo excludo com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	
	<!--- 
	-- PROPSITO
	-- Altera os dados de um pagamento
	-- cristofer 28/03/2006 14:02:59 - CRIADO
	--->
	<cffunction name='upd_pagamento' displayname='Altera os dados de um pagamento' access='remote' returntype='Struct' output='true'>
		<cfargument name='PAGTO_ID' required='yes'>
		<cfargument name='FATURA_ID' required='yes'>
		<cfargument name='FORMA_PAGTO_ID' required='yes'>
		<cfargument name='DATA_LANCAMENTO' required='yes'>
		<cfargument name='COD_MOEDA' required='yes'>
		<cfargument name='VALOR' required='yes'>
		<cfargument name='COD_MOEDA2' required='yes'>
		<cfargument name='COTACAO_MOEDA2' required='yes'>
		<cfargument name='VALOR_MOEDA2' required='yes'>
		<cfargument name='NUM_RECIBO' required='yes'>
		<cfargument name='LISTA_ATRIBUTOS' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_alt_pagamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PAGTO_ID'  value='#arguments.PAGTO_ID#' variable='retorno.PAGTO_ID'  null='#iif(len(trim(arguments.PAGTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FATURA_ID'  value='#arguments.FATURA_ID#'  null='#iif(len(trim(arguments.FATURA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FORMA_PAGTO_ID'  value='#arguments.FORMA_PAGTO_ID#'  null='#iif(len(trim(arguments.FORMA_PAGTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_LANCAMENTO'  value='#arguments.DATA_LANCAMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_MOEDA'  value='#arguments.COD_MOEDA#'  null='#iif(len(trim(arguments.COD_MOEDA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR'  value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_MOEDA2'  value='#arguments.COD_MOEDA2#'  null='#iif(len(trim(arguments.COD_MOEDA2)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COTACAO_MOEDA2'  value='#arguments.COTACAO_MOEDA2#'  null='#iif(len(trim(arguments.COTACAO_MOEDA2)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_MOEDA2'  value='#arguments.VALOR_MOEDA2#'  null='#iif(len(trim(arguments.VALOR_MOEDA2)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_RECIBO'  value='#arguments.NUM_RECIBO#'  null='#iif(len(trim(arguments.NUM_RECIBO)), de('no'), de('yes'))#'>
				</cfstoredproc>
					<cfscript>
						conn = CreateObject("component", "_transportes.consulta.cfc_transp_internacional");
						qrAtributo = conn.get_atributos_forma_pagto();
					</cfscript>
					<cfoutput query="qrAtributo">
						<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_set_pagto_atributo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
							<cfprocparam type='IN' cfsqltype='CF_SQL_INTEGER' dbvarname='P_PAGTO_ID'  value='#retorno.pagto_id#'  null='#iif(len(trim(retorno.pagto_id)), de('no'), de('yes'))#'>
							<cfprocparam type='IN' cfsqltype='CF_SQL_INTEGER' dbvarname='P_ATRIBUTO_ID'  value='#qrAtributo.ATRIBUTO_ID#'  null='#iif(len(trim(qrAtributo.ATRIBUTO_ID)), de('no'), de('yes'))#'>
							<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_VALOR'  value='#arguments[qrAtributo.cod_atributo]#' >
						</cfstoredproc>
					</cfoutput>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Pagamento alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Exclui uma fatura
	-- cristofer 29/03/2006 17:34:07 - CRIADO
	--->
	<cffunction name='del_fatura' displayname='Exclui uma fatura' access='remote' returntype='Struct' output='true'>;
		<cfargument name='FATURA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_del_fatura' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FATURA_ID'  value='#arguments.FATURA_ID#'  null='#iif(len(trim(arguments.FATURA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Fatura excluida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Reagenda uma programa??o de viagem
	-- cristofer 04/04/2006 09:43:43 - CRIADO
	--->
	<cffunction name='reagendar_programacao' displayname='Reagenda uma programa??o de viagem' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PROGRAMACAO_ID' required='yes'>
		<cfargument name='DATA' required='yes'>
		<cfargument name='MOTIVO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_intc_viagem.prc_reagendar_programacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PROGRAMACAO_ID'  value='#arguments.PROGRAMACAO_ID#'  null='#iif(len(trim(arguments.PROGRAMACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' scale='5' dbvarname='P_DATA'  value='#arguments.DATA#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MOTIVO'  value='#arguments.MOTIVO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Programao reagendada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Estorna a liberao de fatura, para que o CRT possa ser alterado
	-- guto 02/05/2006 17:36:53 - CRIADO
	--->
	<cffunction name='estorna_crt_liberacao_fatura' displayname='Estorna a liberao de fatura, para que o CRT possa ser alterado' access='remote' returntype='Struct' output='true'>;
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_estorna_liberacao_fatura' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Liberao para fatura estornada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Altera o organograma do CRT
	-- guto 13/12/2006 15:31:05 - CRIADO
	--->
	<cffunction name='crt_altera_organograma' displayname='Altera o organograma do CRT' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cfargument name='COD_ORGANOGRAMA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_alt_organograma_crt' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_ORGANOGRAMA'  value='#arguments.COD_ORGANOGRAMA#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Centro de Custo alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
		
	<!--- 
	-- PROPSITO
	-- Baixar CRTs entregues
	-- wagner 15/02/2007 15:35:45 - CRIADO
	--->
	<cffunction name='baixa_crt_entregue' displayname='Baixar CRTs entregues' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cfargument name='DATA_ENTREGA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_baixar_crt_entregue' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_ENTREGA'  value='#arguments.DATA_ENTREGA#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('CRT alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera a data de emissao de impressao
	-- wagner 15/02/2007 15:35:45 - CRIADO
	--->
	<cffunction name='imprimir_crt' displayname='Baixar CRTs entregues' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cfargument name='EMISSAO_DATA_IMPRESSAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_imprimir_crt' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMISSAO_DATA_IMPRESSAO'  value='#arguments.EMISSAO_DATA_IMPRESSAO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('CRT alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere uma cotao
	-- louis 26/04/2007 10:25:42 - CRIADO
	--->
	<cffunction name='ins_cotacao' displayname='Insere uma cotao' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_MOEDA' required='yes'>
		<cfargument name='DATA_COTACAO' required='yes'>
		<cfargument name='TAXA_COMPRA' required='yes'>
		<cfargument name='TAXA_VENDA' required='yes'>
		<cfargument name='COD_MOEDA_CONVERSAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
			<cfscript>
				v_cod_moeda = this.ListaToArray (lista = arguments, variavel = "COD_MOEDA_COTACOES");
				v_cod_moeda_conversao = this.ListaToArray (lista = arguments, variavel = "COD_MOEDA_CONVERSAO_COTACOES");
				v_data_cotacao = this.ListaToArray (lista = arguments, variavel = "DATA_COTACAO_COTACOES");
				v_taxa_compra = this.ListaToArray (lista = arguments, variavel = "TAXA_COMPRA_COTACOES");
				v_taxa_venda = this.ListaToArray (lista = arguments, variavel = "TAXA_VENDA_COTACOES");
				conn = CreateObject("component", "_transportes.consulta.cfc_transp_internacional");
				qrListaCotacao = conn.get_lista_cotacao(argumentCollection = arguments);
			</cfscript>
			<cfloop list="#arguments.LISTA_DELETED_COTACOES#" index="i" delimiters=","> 
				<cfscript>
				    if (ListLen(i,'_') gt 0){
					ret = this.del_lista_cotacao(cod_moeda = ListGetAt(i,1,'_') 
												,cod_moeda_conversao = ListGetAt(i,2,'_') 
												,data_cotacao = ListGetAt(i,3,'_')  );
					}
				</cfscript>
				<cfif ret.erro>
					<cfthrow object="#ret.mensagem#">
				</cfif>					
			 </cfloop>
				<cfloop from="1" to="#ArrayLen(v_cod_moeda)#" index="count"> 
						<cfscript>
							ret = this.ins_lista_cotacao(cod_moeda = v_cod_moeda[count] 
														,data_cotacao = v_data_cotacao[count] 	
														,taxa_compra = v_taxa_compra[count] 
														,taxa_venda = v_taxa_venda[count] 
														,cod_moeda_conversao = v_cod_moeda_conversao[count] );
						
						</cfscript>
						<cfif ret.erro>
							<cfthrow object="#ret.mensagem#">
						</cfif>
					
					</cfloop> 	
					<cfset retorno.erro = false>
					<cfset retorno.mensagem = JSStringFormat('Cotaes alteradas com sucesso!')>
				</cftransaction>
				<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	 <!--- 
	-- PROPSITO
	-- LOUIS 27/04/2007 - CRIADO
	--->
	<cffunction name='ins_lista_cotacao' displayname='Inclui uma cotao' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_MOEDA' required='yes'>
		<cfargument name='DATA_COTACAO' required='yes'>
		<cfargument name='TAXA_COMPRA' required='yes'>
		<cfargument name='TAXA_VENDA' required='yes'>
		<cfargument name='COD_MOEDA_CONVERSAO' required='yes'>
		<cfdump var="#arguments#">
		<cftry>
				<cfstoredproc procedure='finan.pkg_cotacao.prc_ins_cotacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_MOEDA'  value='#arguments.COD_MOEDA#'  null='#iif(len(trim(arguments.COD_MOEDA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_COTACAO'  value='#arguments.DATA_COTACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TAXA_COMPRA'  value='#arguments.TAXA_COMPRA#'  null='#iif(len(trim(arguments.TAXA_COMPRA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TAXA_VENDA'  value='#arguments.TAXA_VENDA#'  null='#iif(len(trim(arguments.TAXA_VENDA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_MOEDA_CONVERSAO'  value='#arguments.COD_MOEDA_CONVERSAO#'  null='#iif(len(trim(arguments.COD_MOEDA_CONVERSAO)), de('no'), de('yes'))#'>
			
				</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Imagem inserida com sucesso!')>
		<cfcatch>
   			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- LOUIS 27/04/2007 - CRIADO
	--->
	<cffunction name='del_lista_cotacao' displayname='Exclui uma cotao' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_MOEDA' required='yes'>
		<cfargument name='DATA_COTACAO' required='yes'>
		<cfargument name='COD_MOEDA_CONVERSAO' required='yes'>
		<cfdump var="#arguments#">
	<cftry>
			<cfstoredproc procedure='finan.pkg_cotacao.prc_del_cotacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_MOEDA'  value='#arguments.COD_MOEDA#'  null='#iif(len(trim(arguments.COD_MOEDA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_COTACAO'  value='#arguments.DATA_COTACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_MOEDA_CONVERSAO'  value='#arguments.COD_MOEDA_CONVERSAO#'  null='#iif(len(trim(arguments.COD_MOEDA_CONVERSAO)), de('no'), de('yes'))#'>
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Imagem excluda com sucesso!')>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Vincula um conhecimento de complemento
	-- cristofer 24/05/2007 10:14:43 - CRIADO
	--->
	<cffunction name='ins_conhecimento_complemento' displayname='Vincula um conhecimento de complemento' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cfargument name='CONHECIMENTO_ID_COMPLEMENTO' required='yes'>
		<cfargument name='TIPO_ID' required='yes'>
		<cftry>
				<cfloop list="#arguments.CONHECIMENTO_ID_COMPLEMENTO#" index="crt_id">
                    <cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_ins_conhecimento_complemen' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONHECIMENTO_ID_COMPLEMENTO'  value='#crt_id#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID_COMPLEMENTO)), de('no'), de('yes'))#'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TIPO_ID'  value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
                    </cfstoredproc>
                </cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('CRT vinculado com sucesso!')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Desvincula um conhecimento de complemento
	-- cristofer 24/05/2007 10:15:16 - CRIADO
	--->
	<cffunction name='del_conhecimento_complemento' displayname='Desvincula um conhecimento de complemento' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cfargument name='CONHECIMENTO_ID_COMPLEMENTO' required='yes'>
		<cftry>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_del_conhecimento_complemen' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONHECIMENTO_ID_COMPLEMENTO'  value='#arguments.CONHECIMENTO_ID_COMPLEMENTO#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID_COMPLEMENTO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('CRT desvinculado com sucesso!')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
 
	<!--- 
	-- PROPSITO
	-- Insere recibo
	-- guto 19/06/2007 16:00:12 - CRIADO
	--->
	<cffunction name='ins_recibo' displayname='Insere recibo' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_RECIBO' required='yes'>
		<cfargument name='COD_POSTO_VENDA' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='COD_PESSOA_CLIENTE' required='yes'>
		<cfargument name='RECIBO_COD_MOEDA' required='yes'>
		<cfargument name='RECIBO_COD_MOEDA_2' required='yes'>
		<cfargument name='COTACAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_ins_recibo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_RECIBO'  value='#arguments.NUM_RECIBO#'  null='#iif(len(trim(arguments.NUM_RECIBO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_POSTO_VENDA'  value='#arguments.COD_POSTO_VENDA#'  null='#iif(len(trim(arguments.COD_POSTO_VENDA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_PESSOA_CLIENTE'  value='#arguments.COD_PESSOA_CLIENTE#'  null='#iif(len(trim(arguments.COD_PESSOA_CLIENTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_MOEDA'  value='#arguments.RECIBO_COD_MOEDA#'  null='#iif(len(trim(arguments.RECIBO_COD_MOEDA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_MOEDA_2'  value='#arguments.RECIBO_COD_MOEDA_2#'  null='#iif(len(trim(arguments.RECIBO_COD_MOEDA_2)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COTACAO'  value='#arguments.COTACAO#'  null='#iif(len(trim(arguments.COTACAO)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_RECIBO_ID' variable='retorno.RECIBO_ID' >
				</cfstoredproc>

				<!---Insere Faturas--->
				<cfscript>
					v_fatura_id  = this.ListaToArray (lista = arguments, variavel = "FATURA_ID_FACTURAS");					
					v_conhecimento_id = this.ListaToArray (lista = arguments, variavel = "CONHECIMENTO_ID_FACTURAS");					
					v_tipo_pagto  = this.ListaToArray (lista = arguments, variavel = "TIPO_PAGTO_FACTURAS");					
					v_observacao = this.ListaToArray (lista = arguments, variavel = "OBSERVACAO_FACTURAS");					
					v_valor 	 = this.ListaToArray (lista = arguments, variavel = "VALOR_FACTURAS");					
					v_cotacao 	 = this.ListaToArray (lista = arguments, variavel = "COTACAO_FACTURA_FACTURAS");					
					v_valor_moeda_2     = this.ListaToArray (lista = arguments, variavel = "VALOR_MOEDA_2_FACTURAS");					
					v_caixa_controle_id = this.ListaToArray (lista = arguments, variavel = "CAIXA_CONTROLE_ID_FACTURAS");					
					v_cod_historico     = this.ListaToArray (lista = arguments, variavel = "COD_HISTORICO_ARG_FACTURAS");					
					v_cod_centro_custo  = this.ListaToArray (lista = arguments, variavel = "COD_CENTRO_CUSTO_FACTURAS");					
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_fatura_id)#" index="count"> 
					<cfscript>
						this.ins_recibo_fatura(recibo_id         = retorno.recibo_id,
											   fatura_id         = v_fatura_id[count], 
											   conhecimento_id	 = v_conhecimento_id[count],
						             		   tipo_pagto        = v_tipo_pagto[count],
											   observacao        = v_observacao[count],
											   valor             = v_valor[count],
											   cotacao           = v_cotacao[count],
											   valor_moeda_2     = v_valor_moeda_2[count],
											   caixa_controle_id = v_caixa_controle_id[count],
											   cod_historico_arg = v_cod_historico[count],
											   cod_centro_custo  = v_cod_centro_custo[count]);
					
					</cfscript>
				</cfloop> 		

				<!---Insere Pagamentos--->	
				<cfscript>
					v_forma_pagto_id   = this.ListaToArray (lista = arguments, variavel = "FORMA_PAGTO_ID_PAGTOS");					
					v_cod_moeda 	   = this.ListaToArray (lista = arguments, variavel = "PAGTO_COD_MOEDA_PAGTOS");
					v_valor_fatura 	       = this.ListaToArray (lista = arguments, variavel = "PAGTO_VALOR_USS_PAGTOS");					
					v_cod_moeda2       = this.ListaToArray (lista = arguments, variavel = "PAGTO_COD_MOEDA2_PAGTOS");
					v_cotacao_moeda2   = this.ListaToArray (lista = arguments, variavel = "PAGTO_COTACAO_PAGTOS");					
					v_valor_moeda2     = this.ListaToArray (lista = arguments, variavel = "PAGTO_VALOR_PESOS_PAGTOS");
					v_pagto_atributo   = this.ListaToArray (lista = arguments, variavel = "PAGTO_ATRIBUTO_CODIGO_PAGTOS");					
					v_pagto_atributo_valor = this.ListaToArray (lista = arguments, variavel = "PAGTO_ATRIBUTO_VALOR_PAGTOS");
				</cfscript>

				<cfloop from="1" to="#ArrayLen(v_forma_pagto_id)#" index="count">
					<cfscript>
						ins_pagto = this.ins_recibo_pagto(recibo_id      = retorno.recibo_id,
									 		  			  forma_pagto_id = v_forma_pagto_id[count],
											  			  cod_moeda	     = v_cod_moeda[count],
											  			  valor          = v_valor_fatura[count],
											  			  cod_moeda2	 = v_cod_moeda2[count],
											  			  cotacao_moeda2 = v_cotacao_moeda2[count],
											  			  valor_moeda2   = v_valor_moeda2[count]);
					</cfscript>
					<cfif ListLen(#v_pagto_atributo[count]#,'||')>
						<cfloop list="#v_pagto_atributo[count]#" delimiters="||" index="idx">
							<cfscript>
								this.ins_recibo_pagto_atributo(pagto_id    = ins_pagto.pagto_id,
															   atributo_id = idx,
															   valor	   = ListGetAt(v_pagto_atributo_valor[count],ListFind(v_pagto_atributo[count],idx,'||'),'||'));
							</cfscript>
						</cfloop>
					</cfif>
                    
                    <!---Se for Nota de Crdito, faz uma lanamento utilizando o Histrico(Rodomar - 67 / BBM - 160)--->
                    <cfif v_forma_pagto_id[count] eq 7>
                    	<cfif session.site eq 'rodomar/'>
                        	<cfscript>
                            	v_historico_lancto = 67;
							</cfscript>
                        <cfelse>
                        	<cfscript>
                            	v_historico_lancto = 160;
							</cfscript>
                        </cfif>	   
                        
                        <cfscript>
							conn = Createcomponent("_transportes.manipulacao.cfc_caixa_internacional");
							
							lancto_caixa = conn.ins_lancamento_caixa(DATA_LANCAMENTO		= arguments.DATA_EMISSAO
															   		,CONTROLE_ID			= arguments.CAIXA_CONTROLE_ID
															   		,COD_HISTORICO_ARG		= v_historico_lancto
															   		,COMPLEMENTO				= 'Lanamento gerado pela Emisso de Recibo n ' & arguments.NUM_RECIBO
															   		,COD_CENTRO_CUSTO		= arguments.COD_CENTRO_CUSTO
															   		,RECEITA				= 0
															   		,LANCAMENTO_ID_VINCULO	= ''
															   		,PAGAMENTO_ID			= ''
															   		,COD_PESSOA_FORNECEDOR	= arguments.COD_PESSOA_CLIENTE
															   		,VALOR_TOTAL			= v_valor_moeda2[count]
																	,VALOR_NETO				= v_valor_moeda2[count]
															   		,VALOR_IVA				= 0
															   		,VALOR_NO_GRAVADO		= 0
															   		,VALOR_EXENTOS			= 0
															   		,VALOR_RET_IR			= 0
															   		,DATA_COMPROVANTE		= arguments.DATA_EMISSAO
															   		,COD_COMPROVANTE		= ''
															   		,PRECEP_IVA				= ''
															   		,JURISDICAO_IB			= ''
															   		,COD_TIPO_COMPROVANTE	= ''
															   		,TIPO_FORMULARIO		= ''
															   		,AGRUPAMENTO_ID			= ''
															   		,DOCTO_PAGAMENTO		= '');
						</cfscript>
                        <cfif lancto_caixa.erro>
                            <cfthrow object="#lancto_caixa.mensagem#">
                        </cfif>
                    </cfif>
                    
                    
				</cfloop>
				
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Recibo inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Altera recibo
	-- guto 19/06/2007 16:01:29 - CRIADO
	--->
	<cffunction name='upd_recibo' displayname='Altera recibo' access='remote' returntype='Struct' output='true'>
		<cfargument name='RECIBO_ID' required='yes'>
		<cfargument name='NUM_RECIBO' required='yes'>
		<cfargument name='COD_POSTO_VENDA' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='COD_PESSOA_CLIENTE' required='yes'>
		<cfargument name='RECIBO_COD_MOEDA' required='yes'>
		<cfargument name='RECIBO_COD_MOEDA_2' required='yes'>
		<cfargument name='COTACAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_alt_recibo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_RECIBO_ID'  value='#arguments.RECIBO_ID#'  null='#iif(len(trim(arguments.RECIBO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_RECIBO'  value='#arguments.NUM_RECIBO#'  null='#iif(len(trim(arguments.NUM_RECIBO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_POSTO_VENDA'  value='#arguments.COD_POSTO_VENDA#'  null='#iif(len(trim(arguments.COD_POSTO_VENDA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_PESSOA_CLIENTE'  value='#arguments.COD_PESSOA_CLIENTE#'  null='#iif(len(trim(arguments.COD_PESSOA_CLIENTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_MOEDA'  value='#arguments.RECIBO_COD_MOEDA#'  null='#iif(len(trim(arguments.RECIBO_COD_MOEDA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_MOEDA_2'  value='#arguments.RECIBO_COD_MOEDA_2#'  null='#iif(len(trim(arguments.RECIBO_COD_MOEDA_2)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COTACAO'  value='#arguments.COTACAO#'  null='#iif(len(trim(arguments.COTACAO)), de('no'), de('yes'))#'>
				</cfstoredproc>

				<!---Insere Faturas--->
				<cfscript>
					v_controle_id  = this.ListaToArray (lista = arguments, variavel = "CONTROLE_ID_FACTURAS");					
					v_fatura_id    = this.ListaToArray (lista = arguments, variavel = "FATURA_ID_FACTURAS");					
					v_conhecimento_id = this.ListaToArray (lista = arguments, variavel = "CONHECIMENTO_ID_FACTURAS");					
					v_tipo_pagto   = this.ListaToArray (lista = arguments, variavel = "TIPO_PAGTO_FACTURAS");					
					v_observacao = this.ListaToArray (lista = arguments, variavel = "OBSERVACAO_FACTURAS");					
					v_valor_fatura 	 = this.ListaToArray (lista = arguments, variavel = "VALOR_FACTURAS");					
					v_cotacao 	 = this.ListaToArray (lista = arguments, variavel = "COTACAO_FACTURA_FACTURAS");					
					v_valor_moeda_2     = this.ListaToArray (lista = arguments, variavel = "VALOR_MOEDA_2_FACTURAS");					
					v_caixa_controle_id = this.ListaToArray (lista = arguments, variavel = "CAIXA_CONTROLE_ID_FACTURAS");					
					v_cod_historico     = this.ListaToArray (lista = arguments, variavel = "COD_HISTORICO_ARG_FACTURAS");					
					v_cod_centro_custo  = this.ListaToArray (lista = arguments, variavel = "COD_CENTRO_CUSTO_FACTURAS");					
					v_item_excluir 		= this.ListDiff(lista1 = arguments.lista_deleted_FACTURAS, lista2 = ArrayToList(v_controle_id));
				</cfscript>
				<cfloop list="#v_item_excluir#" index="v_item">
					<cfscript>
						this.del_recibo_fatura(controle_id = v_item);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_fatura_id)#" index="count"> 
					<cfif Len(Trim(v_controle_id[count]))>
						<cfscript>
							this.upd_recibo_fatura(controle_id       = v_controle_id[count],
												   fatura_id         = v_fatura_id[count], 
											   	   conhecimento_id	 = v_conhecimento_id[count],
												   tipo_pagto        = v_tipo_pagto[count],
												   observacao        = v_observacao[count],
												   valor             = v_valor_fatura[count],
												   cotacao           = v_cotacao[count],
												   valor_moeda_2     = v_valor_moeda_2[count],
												   caixa_controle_id = v_caixa_controle_id[count],
												   cod_historico_arg = v_cod_historico[count],
												   cod_centro_custo  = v_cod_centro_custo[count]);
						
						</cfscript>
					<cfelse>
						<cfscript>
							this.ins_recibo_fatura(recibo_id         = arguments.recibo_id,
												   fatura_id         = v_fatura_id[count], 
											       conhecimento_id	 = v_conhecimento_id[count],
												   tipo_pagto        = v_tipo_pagto[count],
												   observacao        = v_observacao[count],
												   valor             = v_valor_fatura[count],
												   cotacao           = v_cotacao[count],
												   valor_moeda_2     = v_valor_moeda_2[count],
												   caixa_controle_id = v_caixa_controle_id[count],
												   cod_historico_arg = v_cod_historico[count],
												   cod_centro_custo  = v_cod_centro_custo[count]);
						
						</cfscript>
					</cfif>
				</cfloop> 		

				<!---Insere Pagamentos--->	
				<cfscript>
					v_pagto_id   	   = this.ListaToArray (lista = arguments, variavel = "PAGTO_ID_PAGTOS");					
					v_forma_pagto_id   = this.ListaToArray (lista = arguments, variavel = "FORMA_PAGTO_ID_PAGTOS");					
					v_cod_moeda 	   = this.ListaToArray (lista = arguments, variavel = "PAGTO_COD_MOEDA_PAGTOS");
					v_valor_uss	       = this.ListaToArray (lista = arguments, variavel = "PAGTO_VALOR_USS_PAGTOS");					
					v_cod_moeda2       = this.ListaToArray (lista = arguments, variavel = "PAGTO_COD_MOEDA2_PAGTOS");
					v_cotacao_moeda2   = this.ListaToArray (lista = arguments, variavel = "PAGTO_COTACAO_PAGTOS");					
					v_valor_moeda2     = this.ListaToArray (lista = arguments, variavel = "PAGTO_VALOR_PESOS_PAGTOS");
					v_pagto_atributo   = this.ListaToArray (lista = arguments, variavel = "PAGTO_ATRIBUTO_CODIGO_PAGTOS");					
					v_pagto_atributo_valor = this.ListaToArray (lista = arguments, variavel = "PAGTO_ATRIBUTO_VALOR_PAGTOS");
					v_pagto_id_excluir     = this.ListDiff(lista1 = arguments.lista_deleted_PAGTOS, lista2 = ArrayToList(v_pagto_id));
				</cfscript>
				<cfloop list="#v_pagto_id_excluir#" index="v_item">
					<cfscript>
						this.del_recibo_pagto(PAGTO_ID = v_item);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_forma_pagto_id)#" index="count">
					<cfif Len(Trim(v_pagto_id[count]))>
						<cfscript>
							this.upd_recibo_pagto(pagto_id       = v_pagto_id[count],
												  forma_pagto_id = v_forma_pagto_id[count],
												  cod_moeda	     = v_cod_moeda[count],
												  valor          = v_valor_uss[count],
												  cod_moeda2	 = v_cod_moeda2[count],
												  cotacao_moeda2 = v_cotacao_moeda2[count],
												  valor_moeda2   = v_valor_moeda2[count]);
						</cfscript>
						<cfif ListLen(#v_pagto_atributo[count]#,'||')>
							<cfloop list="#v_pagto_atributo[count]#" delimiters="||" index="idx">
								<cfscript>
									this.ins_recibo_pagto_atributo(pagto_id    = v_pagto_id[count],
																   atributo_id = idx,
																   valor	   = ListGetAt(v_pagto_atributo_valor[count],ListFind(v_pagto_atributo[count],idx,'||'),'||'));
								</cfscript>
							</cfloop>
						</cfif>
					<cfelse>
						<cfscript>
							ins_pagto = this.ins_recibo_pagto(recibo_id      = arguments.recibo_id,
															  forma_pagto_id = v_forma_pagto_id[count],
															  cod_moeda	     = v_cod_moeda[count],
															  valor          = v_valor_uss[count],
															  cod_moeda2	 = v_cod_moeda2[count],
															  cotacao_moeda2 = v_cotacao_moeda2[count],
															  valor_moeda2   = v_valor_moeda2[count]);
						</cfscript>
						<cfif ListLen(#v_pagto_atributo[count]#,'||')>
							<cfloop list="#v_pagto_atributo[count]#" delimiters="||" index="idx">
								<cfscript>
									this.ins_recibo_pagto_atributo(pagto_id    = ins_pagto.pagto_id,
																   atributo_id = idx,
																   valor	   = ListGetAt(v_pagto_atributo_valor[count],ListFind(v_pagto_atributo[count],idx,'||'),'||'));
								</cfscript>
							</cfloop>
						</cfif>
					</cfif>
				</cfloop>
								
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Recibo alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Exclui recibo
	-- guto 19/06/2007 16:02:18 - CRIADO
	--->
	<cffunction name='del_recibo' displayname='Exclui recibo' access='remote' returntype='Struct' output='true'>
		<cfargument name='RECIBO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_del_recibo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_RECIBO_ID'  value='#arguments.RECIBO_ID#'  null='#iif(len(trim(arguments.RECIBO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Recibo excludo com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Insere fatura a um recibo
	-- guto 19/06/2007 16:03:06 - CRIADO
	--->
	<cffunction name='ins_recibo_fatura' displayname='Insere fatura a um recibo' access='remote' returntype='Struct' output='true'>
		<cfargument name='RECIBO_ID' required='yes'>
		<cfargument name='FATURA_ID' required='yes'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cfargument name='TIPO_PAGTO' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
		<cfargument name='VALOR' required='yes'>
		<cfargument name='COTACAO' required='yes'>
		<cfargument name='VALOR_MOEDA_2' required='yes'>
		<cfargument name='CAIXA_CONTROLE_ID' required='yes'>
		<cfargument name='COD_HISTORICO_ARG' required='yes'>
		<cfargument name='COD_CENTRO_CUSTO' required='yes'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_ins_recibo_fatura' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_RECIBO_ID'  value='#arguments.RECIBO_ID#'  null='#iif(len(trim(arguments.RECIBO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FATURA_ID'  value='#arguments.FATURA_ID#'  null='#iif(len(trim(arguments.FATURA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TIPO_PAGTO'  value='#arguments.TIPO_PAGTO#'  null='#iif(len(trim(arguments.TIPO_PAGTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR'  value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COTACAO'  value='#arguments.COTACAO#'  null='#iif(len(trim(arguments.COTACAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_MOEDA_2'  value='#arguments.VALOR_MOEDA_2#'  null='#iif(len(trim(arguments.VALOR_MOEDA_2)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CAIXA_CONTROLE_ID'  value='#arguments.CAIXA_CONTROLE_ID#'  null='#iif(len(trim(arguments.CAIXA_CONTROLE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_HISTORICO_ARG'  value='#arguments.COD_HISTORICO_ARG#'  null='#iif(len(trim(arguments.COD_HISTORICO_ARG)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONTROLE_ID' variable='retorno.CONTROLE_ID' >
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Altera dados da fatura vinculada ao recibo
	-- guto 19/06/2007 16:04:06 - CRIADO
	--->
	<cffunction name='upd_recibo_fatura' displayname='Altera dados da fatura vinculada ao recibo' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTROLE_ID' required='yes'>
		<cfargument name='FATURA_ID' required='yes'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cfargument name='TIPO_PAGTO' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
		<cfargument name='VALOR' required='yes'>
		<cfargument name='COTACAO' required='yes'>
		<cfargument name='VALOR_MOEDA_2' required='yes'>
		<cfargument name='CAIXA_CONTROLE_ID' required='yes'>
		<cfargument name='COD_HISTORICO_ARG' required='yes'>
		<cfargument name='COD_CENTRO_CUSTO' required='yes'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_alt_recibo_fatura' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FATURA_ID'  value='#arguments.FATURA_ID#'  null='#iif(len(trim(arguments.FATURA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TIPO_PAGTO'  value='#arguments.TIPO_PAGTO#'  null='#iif(len(trim(arguments.TIPO_PAGTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR'  value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COTACAO'  value='#arguments.COTACAO#'  null='#iif(len(trim(arguments.COTACAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_MOEDA_2'  value='#arguments.VALOR_MOEDA_2#'  null='#iif(len(trim(arguments.VALOR_MOEDA_2)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CAIXA_CONTROLE_ID'  value='#arguments.CAIXA_CONTROLE_ID#'  null='#iif(len(trim(arguments.CAIXA_CONTROLE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_HISTORICO_ARG'  value='#arguments.COD_HISTORICO_ARG#'  null='#iif(len(trim(arguments.COD_HISTORICO_ARG)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Exclui fatura de recibo
	-- guto 19/06/2007 16:04:37 - CRIADO
	--->
	<cffunction name='del_recibo_fatura' displayname='Exclui fatura de recibo' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTROLE_ID' required='yes'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_del_recibo_fatura' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Exclui pagamento
	-- guto 19/06/2007 16:43:27 - CRIADO
	--->
	<cffunction name='ins_recibo_pagto' displayname='Exclui pagamento' access='remote' returntype='Struct' output='true'>
		<cfargument name='RECIBO_ID' required='yes'>
		<cfargument name='FORMA_PAGTO_ID' required='yes'>
		<cfargument name='COD_MOEDA' required='yes'>
		<cfargument name='VALOR' required='yes'>
		<cfargument name='COD_MOEDA2' required='yes'>
		<cfargument name='COTACAO_MOEDA2' required='yes'>
		<cfargument name='VALOR_MOEDA2' required='yes'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_ins_recibo_pagto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_RECIBO_ID'  value='#arguments.RECIBO_ID#'  null='#iif(len(trim(arguments.RECIBO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FORMA_PAGTO_ID'  value='#arguments.FORMA_PAGTO_ID#'  null='#iif(len(trim(arguments.FORMA_PAGTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_MOEDA'  value='#arguments.COD_MOEDA#'  null='#iif(len(trim(arguments.COD_MOEDA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR'  value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_MOEDA2'  value='#arguments.COD_MOEDA2#'  null='#iif(len(trim(arguments.COD_MOEDA2)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COTACAO_MOEDA2'  value='#arguments.COTACAO_MOEDA2#'  null='#iif(len(trim(arguments.COTACAO_MOEDA2)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_MOEDA2'  value='#arguments.VALOR_MOEDA2#'  null='#iif(len(trim(arguments.VALOR_MOEDA2)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PAGTO_ID' variable='retorno.PAGTO_ID' >
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Insere atributo ao pagamento
	-- guto 19/06/2007 17:09:11 - CRIADO
	--->
	<cffunction name='ins_recibo_pagto_atributo' displayname='Insere atributo ao pagamento' access='remote' returntype='Struct' output='true'>
		<cfargument name='PAGTO_ID' required='yes'>
		<cfargument name='ATRIBUTO_ID' required='yes'>
		<cfargument name='VALOR' required='yes'>
		<cfif arguments.VALOR eq -1> 
		  <cfset arguments.VALOR = ''>
		</cfif>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_set_pagto_atributo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PAGTO_ID'  value='#arguments.PAGTO_ID#'  null='#iif(len(trim(arguments.PAGTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ATRIBUTO_ID'  value='#arguments.ATRIBUTO_ID#'  null='#iif(len(trim(arguments.ATRIBUTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_VALOR'  value='#arguments.VALOR#' >
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Altera dados de um pagto vinculado ao recibo
	-- guto 20/06/2007 14:11:27 - CRIADO
	--->
	<cffunction name='upd_recibo_pagto' displayname='Altera dados de um pagto vinculado ao recibo' access='remote' returntype='Struct' output='true'>
		<cfargument name='PAGTO_ID' required='yes'>
		<cfargument name='FORMA_PAGTO_ID' required='yes'>
		<cfargument name='COD_MOEDA' required='yes'>
		<cfargument name='VALOR' required='yes'>
		<cfargument name='COD_MOEDA2' required='yes'>
		<cfargument name='COTACAO_MOEDA2' required='yes'>
		<cfargument name='VALOR_MOEDA2' required='yes'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_alt_recibo_pagto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PAGTO_ID'  value='#arguments.PAGTO_ID#'  null='#iif(len(trim(arguments.PAGTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FORMA_PAGTO_ID'  value='#arguments.FORMA_PAGTO_ID#'  null='#iif(len(trim(arguments.FORMA_PAGTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_MOEDA'  value='#arguments.COD_MOEDA#'  null='#iif(len(trim(arguments.COD_MOEDA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR'  value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_MOEDA2'  value='#arguments.COD_MOEDA2#'  null='#iif(len(trim(arguments.COD_MOEDA2)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COTACAO_MOEDA2'  value='#arguments.COTACAO_MOEDA2#'  null='#iif(len(trim(arguments.COTACAO_MOEDA2)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_MOEDA2'  value='#arguments.VALOR_MOEDA2#'  null='#iif(len(trim(arguments.VALOR_MOEDA2)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Exclui pagto vinculado ao recibo
	-- guto 20/06/2007 14:12:05 - CRIADO
	--->
	<cffunction name='del_recibo_pagto' displayname='Exclui pagto vinculado ao recibo' access='remote' returntype='Struct' output='true'>
		<cfargument name='PAGTO_ID' required='yes'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_del_recibo_pagto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PAGTO_ID'  value='#arguments.PAGTO_ID#'  null='#iif(len(trim(arguments.PAGTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Vincula o cheque a fatura
	-- Cristofer 
	--->
	<cffunction name='ins_intc_fatura_cheque' displayname='Exclui recibo' access='remote' returntype='Struct' output='true'>
		<cfargument name='FATURA_ID' required='yes'>
		<cfargument name='PAGTO_ID' required='yes'>
		<cftry>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_ins_intc_fatura_cheque' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FATURA_ID'  value='#arguments.FATURA_ID#'  null='#iif(len(trim(arguments.FATURA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PAGTO_ID'  value='#arguments.PAGTO_ID#'  null='#iif(len(trim(arguments.PAGTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Recibo inserido com sucesso!')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
    
	<!--- 
	-- PROPSITO
	-- Desvincula o cheque a fatura
	-- Cristofer 
	--->
	<cffunction name='del_intc_fatura_cheque' displayname='Exclui recibo' access='remote' returntype='Struct' output='true'>
		<cfargument name='FATURA_ID' required='yes'>
		<cfargument name='PAGTO_ID' required='yes'>
		<cftry>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_del_intc_fatura_cheque' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FATURA_ID'  value='#arguments.FATURA_ID#'  null='#iif(len(trim(arguments.FATURA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PAGTO_ID'  value='#arguments.PAGTO_ID#'  null='#iif(len(trim(arguments.PAGTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Recibo excluido com sucesso!')>
			<cfcatch>
				<cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
                
    <!--- 
	-- PROPSITO
	-- Inserir Permisso
	-- rafael 12/05/2009 16:43:35 - CRIADO
	--->
	<cffunction name='ins_permisso' displayname='Inserir Permisso' access='remote' returntype='Struct' output='true'>
		<cfargument name='PERMISSO_ID' required='no' default="">
		<cfargument name='COD_PAIS' required='yes'>
		<cfargument name='NUM_PERMISSO' required='yes'>
		<cfargument name='NUM_SEQUENCIAL_INICIAL' required='yes'>
        <cfargument name='TIPO_DOCUMENTO' required='yes'>
        <cfargument name='SERIE' required='yes'>
		<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_ins_permisso' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PERMISSO_ID'  value='#arguments.PERMISSO_ID#' variable='retorno.PERMISSO_ID'  null='#iif(len(trim(arguments.PERMISSO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_PAIS'  value='#arguments.COD_PAIS#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUM_PERMISSO'  value='#arguments.NUM_PERMISSO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_SEQUENCIAL_INICIAL'  value='#arguments.NUM_SEQUENCIAL_INICIAL#'  null='#iif(len(trim(arguments.NUM_SEQUENCIAL_INICIAL)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_DOCUMENTO'  value='#arguments.TIPO_DOCUMENTO#'  null='#iif(len(trim(arguments.TIPO_DOCUMENTO)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SERIE'  value='#arguments.SERIE#'  null='#iif(len(trim(arguments.SERIE)), de('no'), de('yes'))#'>
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Permisso inserido com sucesso.')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Editar Permisso
	-- rafael 12/05/2009 16:46:41 - CRIADO	
	--->
	<cffunction name='upd_permisso' displayname='Editar Permisso' access='remote' returntype='Struct' output='true'>
		<cfargument name='PERMISSO_ID' required='yes'>
		<cfargument name='COD_PAIS' required='yes'>
		<cfargument name='NUM_PERMISSO' required='yes'>
		<cfargument name='NUM_SEQUENCIAL_INICIAL' required='yes'>
        <cfargument name='TIPO_DOCUMENTO' required='yes'>
        <cfargument name='SERIE' required='yes'>
			<cftry>
			<cftransaction action='begin'>
			<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_alt_permisso' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PERMISSO_ID'  value='#arguments.PERMISSO_ID#'  null='#iif(len(trim(arguments.PERMISSO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_PAIS'  value='#arguments.COD_PAIS#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUM_PERMISSO'  value='#arguments.NUM_PERMISSO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_SEQUENCIAL_INICIAL'  value='#arguments.NUM_SEQUENCIAL_INICIAL#'  null='#iif(len(trim(arguments.NUM_SEQUENCIAL_INICIAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_DOCUMENTO'  value='#arguments.TIPO_DOCUMENTO#'  null='#iif(len(trim(arguments.TIPO_DOCUMENTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SERIE'  value='#arguments.SERIE#'  null='#iif(len(trim(arguments.SERIE)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Permisso alterado com sucesso.')>
			</cftransaction>
			<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Exluir Permisso
	-- rafael 12/05/2009 16:50:00 - CRIADO
	--->
	<cffunction name='del_permisso' displayname='Exluir Permisso' access='remote' returntype='Struct' output='true'>
		<cfargument name='PERMISSO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
			<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_del_permisso' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PERMISSO_ID'  value='#arguments.PERMISSO_ID#'  null='#iif(len(trim(arguments.PERMISSO_ID)), de('no'), de('yes'))#'>
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Permisso excluido com sucesso.')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

    
    <!--- 
	-- PROPSITO
	-- Altera dados do Pas
	-- NOTAS EXPLICATIVAS
	--  
	-- RAFAEL 10/06/2009 - criado
	--->
	<cffunction name="upd_pais" displayname="Altera dados do Pas" access="remote" returntype="struct" output="true">
		<cfargument name="verifica_documentos" required="yes">
		<cfargument name="pais_id" required="yes">
		<cftry>
			<cfquery datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
				update cep.pais
                   set verifica_documentos = '#arguments.verifica_documentos#' 
				 where pais_id = '#arguments.pais_id#'
			</cfquery>

			<cfset retorno.mensagem = 'Pas alterado com sucesso.'>				
			<cfset retorno.erro = false>						
 	  <cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
	   </cfcatch>
	   </cftry>
	   <cfreturn retorno>	   
	</cffunction>
    
	<!--- 
	-- PROPSITO
	-- Insere os itens do CRT a serem impressos
	-- ANDERSONC 01/07/2009 10:52:46 - CRIADO
	--->
	<cffunction name='ins_intc_conhecimento_form' displayname='Insere os itens do CRT a serem impressos' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_ins_intc_conhecimento_form' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Impresso inserida com sucesso.')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Atualiza os itens do CRT a serem impressos
	-- ANDERSONC 17/06/2009 15:05:22 - CRIADO
	--->
	<cffunction name='upd_intc_conhecimento_form' displayname='Atualiza os itens do CRT a serem impressos' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cfargument name='CAMPO01' required='yes'>
		<cfargument name='CAMPO04' required='yes'>
        <cfargument name='CAMPO05' required='yes'>
		<cfargument name='CAMPO06' required='yes'>
		<cfargument name='CAMPO07' required='yes'>
		<cfargument name='CAMPO08' required='yes'>
		<cfargument name='CAMPO09' required='yes'>
		<cfargument name='CAMPO10' required='yes'>
		<cfargument name='CAMPO12' required='yes'>
		<cfargument name='CAMPO13' required='yes'>
		<cfargument name='CAMPO19_0' required='yes'>
		<cfargument name='CAMPO20_1' required='yes'>
		<cfargument name='CAMPO20_2' required='yes'>
		<cfargument name='CAMPO21_1' required='yes'>
		<cfargument name='CAMPO21_2' required='yes'>
		<cfargument name='CAMPO23' required='yes'>
		<cfargument name='CAMPO23_1' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_alt_intc_conhecimento_form' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CAMPO01'  value='#REReplace(arguments.CAMPO01, '\r', '', 'all')#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CAMPO04'  value='#REReplace(arguments.CAMPO04, '\r', '', 'all')#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CAMPO05'  value='#arguments.CAMPO05#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CAMPO06'  value='#REReplace(arguments.CAMPO06, '\r', '', 'all')#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CAMPO07'  value='#arguments.CAMPO07#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CAMPO08'  value='#arguments.CAMPO08#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CAMPO09'  value='#REReplace(arguments.CAMPO09, '\r', '', 'all')#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CAMPO10'  value='#arguments.CAMPO10#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CAMPO12'  value='#REReplace(arguments.CAMPO12, '\r', '', 'all')#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CAMPO13'  value='#REReplace(arguments.CAMPO13, '\r', '', 'all')#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CAMPO19_0'  value='#arguments.CAMPO19_0#'  null='#iif(len(trim(arguments.CAMPO19_0)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CAMPO20_1'  value='#arguments.CAMPO20_1#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CAMPO20_2'  value='#arguments.CAMPO20_2#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CAMPO21_1'  value='#REReplace(arguments.CAMPO21_1, '\r', '', 'all')#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CAMPO21_2'  value='#arguments.CAMPO21_2#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CAMPO23'  value='#REReplace(arguments.CAMPO23, '\r', '', 'all')#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CAMPO23_1'  value='#arguments.CAMPO23_1#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Impresso alterada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
   
    <!--- 
	-- PROPSITO
	-- Insere vnculo de crt e romaneio
	-- jonas 29/06/2009 15:59:11 - CRIADO
	--->
	<cffunction name='ins_romaneio_intc_conhec' displayname='Insere vnculo de crt e romaneio' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_ROMANEIO' required='yes'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_ins_romaneio_intc_conhec' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Vnculo inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
   
   <!--- 
	-- PROPSITO
	-- Exclui vnculo entre CRT e romaneio
	-- jonas 29/06/2009 18:15:32 - CRIADO
	--->
	<cffunction name='del_romaneio_intc_conhec' displayname='Exclui vnculo entre CRT e romaneio' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_ROMANEIO' required='yes'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_del_romaneio_intc_conhec' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Vnculo excludo com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
   
   <!--- 
	-- PROPSITO
	-- Baixa formulrio de manifesto
	-- publico 15/07/2009 16:55:35 - CRIADO
	--->
	<cffunction name='ins_mic_baixa_formulario' displayname='Baixa formulrio de manifesto' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUMERO_COD_PAIS' required='yes'>
		<cfargument name='NUMERO_CERTIFICADO' required='yes'>
		<cfargument name='NUMERO_SEQUENCIAL' required='yes'>
		<cfargument name='MANIFESTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_ins_mic_baixa_formulario' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUMERO_COD_PAIS'  value='#arguments.NUMERO_COD_PAIS#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUMERO_CERTIFICADO'  value='#arguments.NUMERO_CERTIFICADO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUMERO_SEQUENCIAL'  value='#arguments.NUMERO_SEQUENCIAL#'  null='#iif(len(trim(arguments.NUMERO_SEQUENCIAL)), de('no'), de('yes'))#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MANIFESTO_ID'  value='#arguments.MANIFESTO_ID#' variable='retorno.MANIFESTO_ID'  null='#iif(len(trim(arguments.MANIFESTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Baixa de formulrio de manifesto efetuada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Inserir Tipo de Ocorrncia para Fatura
	-- rafael 21/07/2009 17:42:18 - CRIADO
	--->
	<cffunction name='ins_fatura_tipo_ocorrencia' displayname='Inserir Tipo de Ocorrncia para Fatura' access='remote' returntype='Struct' output='true'>
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_ins_fatura_tipo_ocorrencia' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tipo de Ocorrncia de Fatura inserido com sucesso')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Alterar Tipo de Ocorrncia para Fatura
	-- rafael 21/07/2009 17:47:30 - CRIADO
	--->
	<cffunction name='upd_fatura_tipo_ocorrencia' displayname='Alterar Tipo de Ocorrncia para Fatura' access='remote' returntype='Struct' output='true'>
		<cfargument name='TIPO_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_alt_fatura_tipo_ocorrencia' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_ID'  value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tipo de Ocorrncia de Fatura alterado com sucesso')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Excluir Tipo de Ocorrncia para Fatura
	-- rafael 21/07/2009 17:49:17 - CRIADO
	--->
	<cffunction name='del_fatura_tipo_ocorrencia' displayname='Excluir Tipo de Ocorrncia para Fatura' access='remote' returntype='Struct' output='true'>
		<cfargument name='TIPO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_del_fatura_tipo_ocorrencia' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_ID'  value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tipo de Ocorrncia de Fatura excludo com sucesso')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Inserir Ocorrncia para Fatura
	-- publico 21/07/2009 17:50:53 - CRIADO
	--->
	<cffunction name='ins_fatura_ocorrencia' displayname='Inserir Ocorrncia para Fatura' access='remote' returntype='Struct' output='true'>
		<cfargument name='FATURA_ID' required='yes'>
		<cfargument name='TIPO_OCORRENCIA_ID' required='yes'>
		<cfargument name='DATA_OCORRENCIA' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_ins_fatura_ocorrencia' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FATURA_ID'  value='#arguments.FATURA_ID#'  null='#iif(len(trim(arguments.FATURA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_OCORRENCIA_ID'  value='#arguments.TIPO_OCORRENCIA_ID#'  null='#iif(len(trim(arguments.TIPO_OCORRENCIA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_OCORRENCIA'  value='#arguments.DATA_OCORRENCIA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Ocorrncia inserida com sucesso')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Alterar Ocorrncia para Fatura
	-- publico 21/07/2009 17:53:30 - CRIADO
	--->
	<cffunction name='upd_fatura_ocorrencia' displayname='Alterar Ocorrncia para Fatura' access='remote' returntype='Struct' output='true'>
		<cfargument name='OCORRENCIA_ID' required='yes'>
		<cfargument name='FATURA_ID' required='yes'>
		<cfargument name='TIPO_OCORRENCIA_ID' required='yes'>
		<cfargument name='DATA_OCORRENCIA' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_alt_fatura_ocorrencia' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OCORRENCIA_ID'  value='#arguments.OCORRENCIA_ID#'  null='#iif(len(trim(arguments.OCORRENCIA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FATURA_ID'  value='#arguments.FATURA_ID#'  null='#iif(len(trim(arguments.FATURA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_OCORRENCIA_ID'  value='#arguments.TIPO_OCORRENCIA_ID#'  null='#iif(len(trim(arguments.TIPO_OCORRENCIA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_OCORRENCIA'  value='#arguments.DATA_OCORRENCIA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Ocorrncia alterada com sucesso')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Excluir Ocorrncia para Fatura
	-- publico 21/07/2009 17:54:25 - CRIADO
	--->
	<cffunction name='del_fatura_ocorrencia' displayname='Excluir Ocorrncia para Fatura' access='remote' returntype='Struct' output='true'>
		<cfargument name='OCORRENCIA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_del_fatura_ocorrencia' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OCORRENCIA_ID'  value='#arguments.OCORRENCIA_ID#'  null='#iif(len(trim(arguments.OCORRENCIA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Ocorrncia excluda com sucesso')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
	<!--- 
    -- PROPSITO
    -- Insere uma programao de carga
    -- ANDERSONC 05/11/2009 16:06:01 - CRIADO
    --->
    <cffunction name='ins_programacao' displayname='Insere uma programao de carga' access='remote' returntype='Struct' output='true'>
        <cfargument name='TIPO_ID' required='yes'>
        <cfargument name='DATA' required='yes'>
        <cfargument name='COD_REMETENTE' required='yes'>
        <cfargument name='COLETA_MUNICIPIO_ID' required='yes'>
        <cfargument name='COD_DESTINATARIO' required='yes'>
        <cfargument name='ENTREGA_MUNICIPIO_ID' required='yes'>
        <cfargument name='FRONTEIRA_ID' required='yes'>
        <cfargument name='QUANTIDADE_VEICULOS' required='yes'>
        <cfargument name='CONSOLIDADA' required='yes'>
        <cfargument name='PROGRAMACAO_ID_VINCULO' required='yes'>
        <cfargument name='OBSERVACAO' required='yes'>
        <cfargument name='LISTA_EMAIL' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_intc_viagem.prc_ins_programacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROGRAMACAO_ID' variable='retorno.PROGRAMACAO_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_ID'  value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA'  value='#arguments.DATA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_REMETENTE'  value='#arguments.COD_REMETENTE#'  null='#iif(len(trim(arguments.COD_REMETENTE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COLETA_MUNICIPIO_ID'  value='#arguments.COLETA_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.COLETA_MUNICIPIO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_DESTINATARIO'  value='#arguments.COD_DESTINATARIO#'  null='#iif(len(trim(arguments.COD_DESTINATARIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENTREGA_MUNICIPIO_ID'  value='#arguments.ENTREGA_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.ENTREGA_MUNICIPIO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FRONTEIRA_ID'  value='#arguments.FRONTEIRA_ID#'  null='#iif(len(trim(arguments.FRONTEIRA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QUANTIDADE_VEICULOS'  value='#arguments.QUANTIDADE_VEICULOS#'  null='#iif(len(trim(arguments.QUANTIDADE_VEICULOS)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONSOLIDADA'  value='#arguments.CONSOLIDADA#'  null='#iif(len(trim(arguments.CONSOLIDADA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROGRAMACAO_ID_VINCULO'  value='#arguments.PROGRAMACAO_ID_VINCULO#'  null='#iif(len(trim(arguments.PROGRAMACAO_ID_VINCULO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_LISTA_EMAIL'  value='#arguments.LISTA_EMAIL#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Programao inserida com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Altera uma programao de carga
    -- ANDERSONC 05/11/2009 16:07:02 - CRIADO
    --->
    <cffunction name='upd_programacao' displayname='Altera uma programao de carga' access='remote' returntype='Struct' output='true'>
        <cfargument name='PROGRAMACAO_ID' required='yes'>
        <cfargument name='TIPO_ID' required='yes'>
        <cfargument name='COD_REMETENTE' required='yes'>
        <cfargument name='COLETA_MUNICIPIO_ID' required='yes'>
        <cfargument name='COD_DESTINATARIO' required='yes'>
        <cfargument name='ENTREGA_MUNICIPIO_ID' required='yes'>
        <cfargument name='FRONTEIRA_ID' required='yes'>
        <cfargument name='CONSOLIDADA' required='yes'>
        <cfargument name='PROGRAMACAO_ID_VINCULO' required='yes'>
        <cfargument name='OBSERVACAO' required='yes'>
        <cfargument name='LISTA_EMAIL' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_intc_viagem.prc_alt_programacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROGRAMACAO_ID'  value='#arguments.PROGRAMACAO_ID#'  null='#iif(len(trim(arguments.PROGRAMACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_ID'  value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_REMETENTE'  value='#arguments.COD_REMETENTE#'  null='#iif(len(trim(arguments.COD_REMETENTE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COLETA_MUNICIPIO_ID'  value='#arguments.COLETA_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.COLETA_MUNICIPIO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_DESTINATARIO'  value='#arguments.COD_DESTINATARIO#'  null='#iif(len(trim(arguments.COD_DESTINATARIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENTREGA_MUNICIPIO_ID'  value='#arguments.ENTREGA_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.ENTREGA_MUNICIPIO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FRONTEIRA_ID'  value='#arguments.FRONTEIRA_ID#'  null='#iif(len(trim(arguments.FRONTEIRA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONSOLIDADA'  value='#arguments.CONSOLIDADA#'  null='#iif(len(trim(arguments.CONSOLIDADA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROGRAMACAO_ID_VINCULO'  value='#arguments.PROGRAMACAO_ID_VINCULO#'  null='#iif(len(trim(arguments.PROGRAMACAO_ID_VINCULO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_LISTA_EMAIL'  value='#arguments.LISTA_EMAIL#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Programao alterada com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Reagenda uma programao de carga
    -- ANDERSONC 05/11/2009 16:08:24 - CRIADO
    --->
    <cffunction name='reagenda_programacao' displayname='Reagenda uma programao de carga' access='remote' returntype='Struct' output='true'>
        <cfargument name='PROGRAMACAO_ID' required='yes'>
        <cfargument name='DATA' required='yes'>
        <cfargument name='QUANTIDADE_VEICULOS' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_intc_viagem.prc_reagenda_programacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROGRAMACAO_ID'  value='#arguments.PROGRAMACAO_ID#'  null='#iif(len(trim(arguments.PROGRAMACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA'  value='#arguments.DATA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QUANTIDADE_VEICULOS'  value='#arguments.QUANTIDADE_VEICULOS#'  null='#iif(len(trim(arguments.QUANTIDADE_VEICULOS)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_LISTA_EMAIL'  value='#arguments.LISTA_EMAIL#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Programao reagendada com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Cancela uma programao de carga
    -- ANDERSONC 05/11/2009 16:08:55 - CRIADO
    --->
    <cffunction name='cancela_programacao' displayname='Cancela uma programao de carga' access='remote' returntype='Struct' output='true'>
        <cfargument name='PROGRAMACAO_ID' required='yes'>
        <cfargument name='MOTIVO_CANCELAMENTO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_intc_viagem.prc_cancela_programacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROGRAMACAO_ID'  value='#arguments.PROGRAMACAO_ID#'  null='#iif(len(trim(arguments.PROGRAMACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MOTIVO_CANCELAMENTO'  value='#arguments.MOTIVO_CANCELAMENTO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Programao cancelada com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Exclui uma viagem
	-- ANDERSONC 02/10/2009 09:42:10 - CRIADO
	--->
	<cffunction name='del_viagem' displayname='Exclui uma viagem' access='remote' returntype='Struct' output='true'>
		<cfargument name='VIAGEM_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_intc_viagem.prc_del_viagem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VIAGEM_ID'  value='#arguments.VIAGEM_ID#'  null='#iif(len(trim(arguments.VIAGEM_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Viagem excluda com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
	<!--- 
    -- PROPSITO
    -- Registra um embarque
    -- ANDERSONC 11/01/2010 15:54:10 - CRIADO
    --->
    <cffunction name='ins_viagem_embarque' displayname='Registra um embarque' access='remote' returntype='Struct' output='true'>
        <cfargument name='PROGRAMACAO_ID' required='yes'>
        <cfargument name='VIAGEM_ID' required='yes'>
        <cfargument name='CONHECIMENTO_ID' required='yes'>
        <cfargument name='MANIFESTO_ID' required='yes'>
        <cfargument name='COD_MOTORISTA' required='yes'>
        <cfargument name='PLACA_CAVALO' required='yes'>
        <cfargument name='PLACA_CARRETA' required='yes'>
        <cfargument name='DATA_SAIDA' required='yes'>
        <cfargument name='PREVISAO_CHEGADA_FRONTEIRA' required='yes'>
        <cfargument name='FRONTEIRA_ID' required='yes'>
        <cfargument name='COD_DESPACHANTE_ORIGEM' required='yes'>
        <cfargument name='COD_DESPACHANTE_DESTINO' required='yes'>
        <cfargument name='FACTURA' required='yes'>
        <cfargument name='SD' required='yes'>
        <cfargument name='TRAS' required='yes'>
        <cfargument name='PE' required='yes'>
        <cfargument name='DI' required='yes'>
        <cfargument name='DTA' required='yes'>
        <cfargument name='TRANSBORDO' required='yes'>
        <cfargument name='LOCAL_TRANSBORDO_ID' required='yes'>
        <cfargument name='DATA_DESCARGA_TRANSBORDO' required='yes'>
        <cfargument name='DATA_CARGA_TRANSBORDO' required='yes'>
        <cfargument name='PLACA_CAVALO_TRANSBORDO' required='yes'>
        <cfargument name='PLACA_CARRETA_TRANSBORDO' required='yes'>
        <cfargument name='OBSERVACAO' required='yes'>
        <cfargument name='LISTA_EMAIL' required='yes'>
        <cfargument name='PROGRAMADO_PARA' required='no'>
        <cfargument name='NUM_PEDIDO' required='no'>
        <cfargument name='SOLICITACAO_CRUZE' required='no'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_intc_viagem.prc_ins_viagem_embarque' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROGRAMACAO_ID'  value='#arguments.PROGRAMACAO_ID#'  null='#iif(len(trim(arguments.PROGRAMACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_VIAGEM' variable='retorno.NUM_VIAGEM' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EMBARQUE_ID' variable='retorno.EMBARQUE_ID' >
                    <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VIAGEM_ID'  value='#arguments.VIAGEM_ID#' variable='retorno.VIAGEM_ID'  null='#iif(len(trim(arguments.VIAGEM_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MANIFESTO_ID'  value='#arguments.MANIFESTO_ID#'  null='#iif(len(trim(arguments.MANIFESTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_MOTORISTA'  value='#arguments.COD_MOTORISTA#'  null='#iif(len(trim(arguments.COD_MOTORISTA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA_CAVALO'  value='#arguments.PLACA_CAVALO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA_CARRETA'  value='#arguments.PLACA_CARRETA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_SAIDA'  value='#arguments.DATA_SAIDA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PREVISAO_CHEGADA_FRONTEIRA'  value='#arguments.PREVISAO_CHEGADA_FRONTEIRA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FRONTEIRA_ID'  value='#arguments.FRONTEIRA_ID#'  null='#iif(len(trim(arguments.FRONTEIRA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_DESPACHANTE_ORIGEM'  value='#arguments.COD_DESPACHANTE_ORIGEM#'  null='#iif(len(trim(arguments.COD_DESPACHANTE_ORIGEM)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_DESPACHANTE_DESTINO'  value='#arguments.COD_DESPACHANTE_DESTINO#'  null='#iif(len(trim(arguments.COD_DESPACHANTE_DESTINO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_FACTURA'  value='#arguments.FACTURA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SD'  value='#arguments.SD#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRAS'  value='#arguments.TRAS#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PE'  value='#arguments.PE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DI'  value='#arguments.DI#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DTA'  value='#arguments.DTA#'  null='#iif(len(trim(arguments.DTA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TRANSBORDO'  value='#arguments.TRANSBORDO#'  null='#iif(len(trim(arguments.TRANSBORDO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LOCAL_TRANSBORDO_ID'  value='#arguments.LOCAL_TRANSBORDO_ID#'  null='#iif(len(trim(arguments.LOCAL_TRANSBORDO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_DESCARGA_TRANSBORDO'  value='#arguments.DATA_DESCARGA_TRANSBORDO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_CARGA_TRANSBORDO'  value='#arguments.DATA_CARGA_TRANSBORDO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA_CAVALO_TRANSBORDO'  value='#arguments.PLACA_CAVALO_TRANSBORDO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA_CARRETA_TRANSBORDO'  value='#arguments.PLACA_CARRETA_TRANSBORDO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_LISTA_EMAIL'  value='#arguments.LISTA_EMAIL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PROGRAMADO_PARA'  value='#arguments.PROGRAMADO_PARA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_PEDIDO'  value='#arguments.NUM_PEDIDO#'  null='#iif(len(trim(arguments.NUM_PEDIDO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SOLICITACAO_CRUZE'  value='#arguments.SOLICITACAO_CRUZE#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Embarque registrado com sucesso  viagem N ' & retorno.NUM_VIAGEM & '.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
	
	<!--- 
    -- PROPSITO
    -- Altera um embarque
    -- ANDERSONC 14/01/2010 14:47:17 - CRIADO
    --->
    <cffunction name='upd_viagem_embarque' displayname='Altera um embarque' access='remote' returntype='Struct' output='true'>
        <cfargument name='EMBARQUE_ID' required='yes'>
        <cfargument name='CONHECIMENTO_ID' required='yes'>
        <cfargument name='MANIFESTO_ID' required='yes'>
        <cfargument name='COD_MOTORISTA' required='yes'>
        <cfargument name='PLACA_CAVALO' required='yes'>
        <cfargument name='PLACA_CARRETA' required='yes'>
        <cfargument name='DATA_SAIDA' required='yes'>
        <cfargument name='PREVISAO_CHEGADA_FRONTEIRA' required='yes'>
        <cfargument name='FRONTEIRA_ID' required='yes'>
        <cfargument name='COD_DESPACHANTE_ORIGEM' required='yes'>
        <cfargument name='COD_DESPACHANTE_DESTINO' required='yes'>
        <cfargument name='FACTURA' required='yes'>
        <cfargument name='SD' required='yes'>
        <cfargument name='TRAS' required='yes'>
        <cfargument name='PE' required='yes'>
        <cfargument name='DI' required='yes'>
        <cfargument name='DTA' required='yes'>
        <cfargument name='TRANSBORDO' required='yes'>
        <cfargument name='LOCAL_TRANSBORDO_ID' required='yes'>
        <cfargument name='DATA_DESCARGA_TRANSBORDO' required='yes'>
        <cfargument name='DATA_CARGA_TRANSBORDO' required='yes'>
        <cfargument name='PLACA_CAVALO_TRANSBORDO' required='yes'>
        <cfargument name='PLACA_CARRETA_TRANSBORDO' required='yes'>
        <cfargument name='OBSERVACAO' required='yes'>
        <cfargument name='PROGRAMADO_PARA' required='yes'>
        <cfargument name='NUM_PEDIDO' required='yes'>
        <cfargument name='SOLICITACAO_CRUZE' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_intc_viagem.prc_alt_viagem_embarque' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EMBARQUE_ID'  value='#arguments.EMBARQUE_ID#'  null='#iif(len(trim(arguments.EMBARQUE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MANIFESTO_ID'  value='#arguments.MANIFESTO_ID#'  null='#iif(len(trim(arguments.MANIFESTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_MOTORISTA'  value='#arguments.COD_MOTORISTA#'  null='#iif(len(trim(arguments.COD_MOTORISTA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA_CAVALO'  value='#arguments.PLACA_CAVALO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA_CARRETA'  value='#arguments.PLACA_CARRETA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_SAIDA'  value='#arguments.DATA_SAIDA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PREVISAO_CHEGADA_FRONTEIRA'  value='#arguments.PREVISAO_CHEGADA_FRONTEIRA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FRONTEIRA_ID'  value='#arguments.FRONTEIRA_ID#'  null='#iif(len(trim(arguments.FRONTEIRA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_DESPACHANTE_ORIGEM'  value='#arguments.COD_DESPACHANTE_ORIGEM#'  null='#iif(len(trim(arguments.COD_DESPACHANTE_ORIGEM)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_DESPACHANTE_DESTINO'  value='#arguments.COD_DESPACHANTE_DESTINO#'  null='#iif(len(trim(arguments.COD_DESPACHANTE_DESTINO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_FACTURA'  value='#arguments.FACTURA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SD'  value='#arguments.SD#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRAS'  value='#arguments.TRAS#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PE'  value='#arguments.PE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DI'  value='#arguments.DI#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DTA'  value='#arguments.DTA#'  null='#iif(len(trim(arguments.DTA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TRANSBORDO'  value='#arguments.TRANSBORDO#'  null='#iif(len(trim(arguments.TRANSBORDO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LOCAL_TRANSBORDO_ID'  value='#arguments.LOCAL_TRANSBORDO_ID#'  null='#iif(len(trim(arguments.LOCAL_TRANSBORDO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_DESCARGA_TRANSBORDO'  value='#arguments.DATA_DESCARGA_TRANSBORDO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_CARGA_TRANSBORDO'  value='#arguments.DATA_CARGA_TRANSBORDO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA_CAVALO_TRANSBORDO'  value='#arguments.PLACA_CAVALO_TRANSBORDO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA_CARRETA_TRANSBORDO'  value='#arguments.PLACA_CARRETA_TRANSBORDO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PROGRAMADO_PARA'  value='#arguments.PROGRAMADO_PARA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_PEDIDO'  value='#arguments.NUM_PEDIDO#'  null='#iif(len(trim(arguments.NUM_PEDIDO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SOLICITACAO_CRUZE'  value='#arguments.SOLICITACAO_CRUZE#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Embarque alterado com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um embarque
	-- ANDERSONC 08/09/2009 15:47:54 - CRIADO
	--->
	<cffunction name='del_viagem_embarque' displayname='Exclui um embarque' access='remote' returntype='Struct' output='true'>
		<cfargument name='EMBARQUE_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='oper.pkg_intc_viagem.prc_del_viagem_embarque' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EMBARQUE_ID'  value='#arguments.EMBARQUE_ID#'  null='#iif(len(trim(arguments.EMBARQUE_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Embarque excludo com sucesso.')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Vincula um CRT a um embarque
	-- ANDERSONC 08/09/2009 15:37:21 - CRIADO
	--->
	<cffunction name='viagem_embarque_crt' displayname='Vincula um CRT a um embarque' access='remote' returntype='Struct' output='true'>
		<cfargument name='EMBARQUE_ID' required='yes'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
        <cfargument name='MANIFESTO_ID' required='no' default=''>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_intc_viagem.prc_viagem_embarque_crt' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EMBARQUE_ID'  value='#arguments.EMBARQUE_ID#'  null='#iif(len(trim(arguments.EMBARQUE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
                
                <cfif Len(Trim(arguments.MANIFESTO_ID))>
                	<cfscript>
						ret = this.viagem_embarque_mic(EMBARQUE_ID  = arguments.EMBARQUE_ID,
													   MANIFESTO_ID = arguments.MANIFESTO_ID);
					</cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfif>
                
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('CRT vinculado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Vincula um MIC/DTA a um embarque
	-- ANDERSONC 08/09/2009 15:41:25 - CRIADO
	--->
	<cffunction name='viagem_embarque_mic' displayname='Vincula um MIC/DTA a um embarque' access='remote' returntype='Struct' output='true'>
		<cfargument name='EMBARQUE_ID' required='yes'>
		<cfargument name='MANIFESTO_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='oper.pkg_intc_viagem.prc_viagem_embarque_mic' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EMBARQUE_ID'  value='#arguments.EMBARQUE_ID#'  null='#iif(len(trim(arguments.EMBARQUE_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MANIFESTO_ID'  value='#arguments.MANIFESTO_ID#'  null='#iif(len(trim(arguments.MANIFESTO_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('MIC/DTA vinculado com sucesso.')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
	<!--- 
    -- PROPSITO
    -- Vincula um valor a um embarque
    -- ERICG 20/10/2010 15:30 - CRIADO
    --->
    <cffunction name='viagem_embarque_valor' displayname='Vincula um valor a um embarque' access='remote' returntype='Struct' output='true'>
        <cfargument name='EMBARQUE_ID' required='yes'>
        <cfargument name='CAMPO' required='yes'>
        <cfargument name='VALOR' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_intc_viagem.prc_viagem_embarque_valor' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EMBARQUE_ID'  value='#arguments.EMBARQUE_ID#'  null='#iif(len(trim(arguments.EMBARQUE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CAMPO'  value='#arguments.CAMPO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_VALOR'  value='#arguments.VALOR#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Campo vinculado com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Finaliza um embarque
	-- ANDERSONC 15/01/2010 14:23:16 - CRIADO
	--->
	<cffunction name='finaliza_viagem_embarque' displayname='Finaliza um embarque' access='remote' returntype='Struct' output='true'>
		<cfargument name='EMBARQUE_ID' required='yes'>
		<cfargument name='DATA_TERMINO' required='yes'>
		<cfargument name='CONDICOES_ENTREGA_MERCADORIA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_intc_viagem.prc_finaliza_viagem_embarque' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EMBARQUE_ID'  value='#arguments.EMBARQUE_ID#'  null='#iif(len(trim(arguments.EMBARQUE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_TERMINO'  value='#arguments.DATA_TERMINO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONDICOES_ENTREGA_MERCADORIA'  value='#arguments.CONDICOES_ENTREGA_MERCADORIA#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Embarque finalizado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
	<!--- 
    -- PROPSITO
    -- Insere um anexo
    -- ANDERSONC 14/01/2010 14:57:28 - CRIADO
    --->
    <cffunction name='ins_anexo' displayname='Insere um anexo' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTEUDO' required='yes'>
        <cfargument name='NOME' required='yes'>
        <cfargument name='EXTENSAO' required='yes'>
        <cftry>
            <cfstoredproc procedure='oper.pkg_intc_viagem.prc_ins_anexo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ANEXO_ID' variable='retorno.ANEXO_ID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_BLOB' dbvarname='P_CONTEUDO'  value='#arguments.CONTEUDO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EXTENSAO'  value='#arguments.EXTENSAO#' >
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Anexo inserido com sucesso.')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Exclui um anexo
    -- ANDERSONC 14/01/2010 14:58:43 - CRIADO
    --->
    <cffunction name='del_anexo' displayname='Exclui um anexo' access='remote' returntype='Struct' output='true'>
        <cfargument name='ANEXO_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='oper.pkg_intc_viagem.prc_del_anexo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ANEXO_ID'  value='#arguments.ANEXO_ID#'  null='#iif(len(trim(arguments.ANEXO_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Anexo excludo com sucesso.')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Insere um anexo a uma programao
	-- ANDERSONC 14/01/2010 15:00:10 - CRIADO
	--->
	<cffunction name='ins_programacao_anexo' displayname='Insere um anexo a uma programao' access='remote' returntype='Struct' output='true'>
		<cfargument name='ANEXO_ID' required='yes'>
		<cfargument name='PROGRAMACAO_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='oper.pkg_intc_viagem.prc_ins_programacao_anexo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID' variable='retorno.CONTROLE_ID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ANEXO_ID'  value='#arguments.ANEXO_ID#'  null='#iif(len(trim(arguments.ANEXO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROGRAMACAO_ID'  value='#arguments.PROGRAMACAO_ID#'  null='#iif(len(trim(arguments.PROGRAMACAO_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Anexo inserido com sucesso.')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Exclui um anexo de uma programao
	-- ANDERSONC 14/01/2010 15:06:05 - CRIADO
	--->
	<cffunction name='del_programacao_anexo' displayname='Exclui um anexo de uma programao' access='remote' returntype='Struct' output='true'>
		<cfargument name='ANEXO_ID' required='yes'>
		<cfargument name='PROGRAMACAO_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='oper.pkg_intc_viagem.prc_del_programacao_anexo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ANEXO_ID'  value='#arguments.ANEXO_ID#'  null='#iif(len(trim(arguments.ANEXO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROGRAMACAO_ID'  value='#arguments.PROGRAMACAO_ID#'  null='#iif(len(trim(arguments.PROGRAMACAO_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Anexo excludo com sucesso.')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Insere um anexo a um embarque
	-- ANDERSONC 14/01/2010 15:08:04 - CRIADO
	--->
	<cffunction name='ins_embarque_anexo' displayname='Insere um anexo a um embarque' access='remote' returntype='Struct' output='true'>
		<cfargument name='ANEXO_ID' required='yes'>
		<cfargument name='EMBARQUE_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='oper.pkg_intc_viagem.prc_ins_embarque_anexo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID' variable='retorno.CONTROLE_ID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ANEXO_ID'  value='#arguments.ANEXO_ID#'  null='#iif(len(trim(arguments.ANEXO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EMBARQUE_ID'  value='#arguments.EMBARQUE_ID#'  null='#iif(len(trim(arguments.EMBARQUE_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Anexo inserido com sucesso.')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Exclui um anexo de um embarque
	-- ANDERSONC 14/01/2010 15:08:55 - CRIADO
	--->
	<cffunction name='del_embarque_anexo' displayname='Exclui um anexo de um embarque' access='remote' returntype='Struct' output='true'>
		<cfargument name='ANEXO_ID' required='yes'>
		<cfargument name='EMBARQUE_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='oper.pkg_intc_viagem.prc_del_embarque_anexo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ANEXO_ID'  value='#arguments.ANEXO_ID#'  null='#iif(len(trim(arguments.ANEXO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EMBARQUE_ID'  value='#arguments.EMBARQUE_ID#'  null='#iif(len(trim(arguments.EMBARQUE_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Anexo excludo com sucesso.')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Insere um anexo a uma programao ou a um embarque
	-- ANDERSONC 14/01/2010 15:08:55 - CRIADO
	--->
	<cffunction name='insere_anexo' displayname='Insere um anexo a uma programao ou a um embarque' access='remote' returntype='Struct' output='true'>

        <cfargument name='EMBARQUE_ID' required='no' default=''>
        <cfargument name='PROGRAMACAO_ID' required='no' default=''>
		<cftry><cfdump var="#arguments#">
			<cftransaction action='begin'>
	
                <!---Anexos---->
                 <cfscript>
					 v_nome_anexo   = this.ListaToArray(lista = arguments, variavel = 'NOME_ANEXO_ANEXOS');
					 v_nome_arquivo = this.ListaToArray(lista = arguments, variavel = 'NOME_ARQUIVO_ANEXOS');
				</cfscript>	 
                
                 <cfloop from="1" to="#ArrayLen(v_nome_arquivo)#" index="count_an">
                 	   <!--- Busca arquivo --->
					   <cfif Len(Trim(v_nome_arquivo[count_an]))>
                           <cffile action="readbinary" file="#expandPath("/")#temp/#v_nome_arquivo[count_an]#" variable="VARQUIVO">
                           <cfscript>
                           	  v_extensao = ListToArray(v_nome_arquivo[count_an], '.');
						   </cfscript>
                       <cfelse>
                           <cfset VARQUIVO = ''>
                           <cfset v_extensao = ''>
                       </cfif>
					   <cfscript>
						ret_ane = this.ins_anexo(CONTEUDO = VARQUIVO,
										         NOME 	  = v_nome_anexo[count_an],
						   				         EXTENSAO = v_extensao[ArrayLen(v_extensao)]
												);
					   </cfscript>
                    
                    <cfif ret_ane.erro >
                	   <cfthrow object="#ret_ane.mensagem#">
                    </cfif>   
                       
                
					<!--- Vincula o anexo a uma programao --->
                    <cfif Len(Trim(arguments.PROGRAMACAO_ID))>
                        <cfscript>
                            ret = this.ins_programacao_anexo(ANEXO_ID       = ret_ane.ANEXO_ID,
                                                             PROGRAMACAO_ID = arguments.PROGRAMACAO_ID);
                        </cfscript>
                        <cfif ret.erro>
                            <cfthrow object="#ret.mensagem#">
                        </cfif>
                    </cfif>
                    
                    <!--- Vincula o anexo a um embarque --->
                    <cfif Len(Trim(arguments.EMBARQUE_ID))>
                        <cfscript>
                            ret = this.ins_embarque_anexo(ANEXO_ID    = ret_ane.ANEXO_ID,
                                                          EMBARQUE_ID = arguments.EMBARQUE_ID);
                        </cfscript>
                        <cfif ret.erro>
                            <cfthrow object="#ret.mensagem#">
                        </cfif>
                    </cfif>
                </cfloop>
                
                <cfif Len(Trim(arguments.EMBARQUE_ID))>
					<cfscript>
                        ret = this.envia_email_anexo_reg_emb(EMBARQUE_ID = arguments.EMBARQUE_ID);
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfif>
                
                <cfif Len(Trim(arguments.PROGRAMACAO_ID))>
					<cfscript>
                        ret = this.envia_email_ane_prog_car(PROGRAMACAO_ID = arguments.PROGRAMACAO_ID);
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfif>
                
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Anexo(s) inserido(s) com sucesso.')>
			</cftransaction>
            <cfcatch>
            	<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Exclui um anexo de uma programao ou de um embarque
	-- ANDERSONC 14/01/2010 15:08:55 - CRIADO
	--->
	<cffunction name='exclui_anexo' displayname='Exclui um anexo de uma programao ou de um embarque' access='remote' returntype='Struct' output='true'>
		<cfargument name='ANEXO_ID' required='yes'>
		<cfargument name='EMBARQUE_ID' required='no' default=''>
        <cfargument name='PROGRAMACAO_ID' required='no' default=''>
		<cftry>
        	<cftransaction action='begin'>
            	<!--- Desvincula o anexo de uma programao --->
                <cfif Len(Trim(arguments.PROGRAMACAO_ID))>
					<cfscript>
                        ret = this.del_programacao_anexo(ANEXO_ID       = arguments.ANEXO_ID,
                                                         PROGRAMACAO_ID = arguments.PROGRAMACAO_ID);
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfif>
                
                <!--- Desvincula o anexo de um embarque --->
                <cfif Len(Trim(arguments.EMBARQUE_ID))>
					<cfscript>
                        ret = this.del_embarque_anexo(ANEXO_ID    = arguments.ANEXO_ID,
                                                      EMBARQUE_ID = arguments.EMBARQUE_ID);
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfif>
                
				<!--- Exclui o anexo --->
                <cfscript>
					ret = this.del_anexo(ANEXO_ID = arguments.ANEXO_ID);
                </cfscript>
                <cfif ret.erro>
                    <cfthrow object="#ret.mensagem#">
                </cfif>
                
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Anexo excludo com sucesso.')>
			</cftransaction>
            <cfcatch>
            	<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Executa o clculo da tabela de frete para o CRT
	-- ANDERSONC 04/10/2010 17:20:45 - CRIADO
	--->
	<cffunction name='calcula_crt_tabela_frete' displayname='Executa o clculo da tabela de frete para o CRT' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cfargument name='CLASSIFICACAO_NATUREZA_ID' required='yes'>
		<cfargument name='CLASSIFICACAO_COMERCIAL_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_calcula_crt_tabela_frete' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CLASSIFICACAO_NATUREZA_ID'  value='#arguments.CLASSIFICACAO_NATUREZA_ID#'  null='#iif(len(trim(arguments.CLASSIFICACAO_NATUREZA_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CLASSIFICACAO_COMERCIAL_ID'  value='#arguments.CLASSIFICACAO_COMERCIAL_ID#'  null='#iif(len(trim(arguments.CLASSIFICACAO_COMERCIAL_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Valida a negociao comercial de um CRT
	-- ANDERSONC 07/10/2010 11:03:23 - CRIADO
	--->
	<cffunction name='valida_crt_tabela_frete' displayname='Valida a negociao comercial de um CRT' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_valida_crt_tabela_frete' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Atualizar a lista de e-mails
	-- FABIOG 03/02/2011 15:50 - CRIADO
	--->
	<cffunction name='upd_lista_email' displayname='Atualiza lista de e-mails' access='remote' returntype='Struct' output='true'>
    	<cfargument name='EMAIL_INCLUSAO' required='yes'>
        <cfargument name='EMAIL_EDICAO' required='yes'>
        <cfargument name='EMAIL_REGISTRO_EMBARQUE' required='yes'>
		<cftry>
            <cfstoredproc procedure='oper.pkg_intc_viagem.prc_alt_lista_email' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
            	 <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMAIL_INCLUSAO'  value='#arguments.EMAIL_INCLUSAO#'  null='#iif(len(trim(arguments.EMAIL_INCLUSAO)), de('no'), de('yes'))#'>
                 <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMAIL_EDICAO'    value='#arguments.EMAIL_EDICAO#'  null='#iif(len(trim(arguments.EMAIL_EDICAO)), de('no'), de('yes'))#'>
                 <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMAIL_REGISTRO_EMBARQUE'  value='#arguments.EMAIL_REGISTRO_EMBARQUE#'  null='#iif(len(trim(arguments.EMAIL_REGISTRO_EMBARQUE)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Listas de e-mails alteradas com sucesso.')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>   
    
    <!--- 
	-- PROPSITO
	-- Insere o arquivo temporariamento no servidor
	-- FABIOG 25/07/2011 17:47:40 - CRIADO
	--->
	<cffunction name='ins_anexo_temp' displayname='Insere o arquivo temporariamento no servidor' access='remote' returntype='Struct' output='true'>
		<cfargument name='ANEXO' required='yes'>
        <cftry>
            
			<!---Envia o Arquivo para o Servidor--->
            <cffile action="upload" destination="#expandPath("/")#temp" file="#arguments.ANEXO#" nameconflict="makeunique" result="VANEXO" filefield="ANEXO">
            
            <cfset retorno.nome_arquivo = VANEXO.serverfile>
            <cfset retorno.erro = false>
        <cfcatch>
        	<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
            <cfset request.erro = cfcatch>
        </cfcatch>
        </cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Enviar um e-mail quando insere um anexo no embarque
	-- FABIOG 02/08/2011 13:59:38 - CRIADO
	--->
	<cffunction name='envia_email_anexo_reg_emb' displayname='Enviar um e-mail quando insere um anexo no embarque' access='remote' returntype='Struct' output='true'>
		<cfargument name='EMBARQUE_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='oper.pkg_intc_viagem.prc_envia_email_anexo_reg_emb' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EMBARQUE_ID'  value='#arguments.EMBARQUE_ID#'  null='#iif(len(trim(arguments.EMBARQUE_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
        <cfcatch>
            <cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
            <cfset request.erro = cfcatch>
        </cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Envia email no momento em que  anexado um ou mais arquivos a programao de carga
	-- FABIOG 09/08/2011 15:19:40 - CRIADO
	--->
	<cffunction name='envia_email_ane_prog_car' displayname='Envia email no momento em que  anexado um ou mais arquivos a programao de carga' access='remote' returntype='Struct' output='true'>
		<cfargument name='PROGRAMACAO_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='oper.pkg_intc_viagem.prc_envia_email_ane_prog_car' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROGRAMACAO_ID'  value='#arguments.PROGRAMACAO_ID#'  null='#iif(len(trim(arguments.PROGRAMACAO_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
        <cfcatch>
            <cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
            <cfset request.erro = cfcatch>
        </cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Inserir Assinatura Digital
	-- RAFAEL 20/11/2012 22:21:08 - CRIADO
	--->
	<cffunction name='ins_assinatura' displayname='Inserir Assinatura Digital' access='remote' returntype='Struct' output='true'>
		<cfargument name='USUARIO' required='yes'>
		<cfargument name='NOME_ARQUIVO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<!--- Busca arquivo --->
               <cffile action="readbinary" file="#expandPath("/")#temp/#arguments.NOME_ARQUIVO#" variable="VARQUIVO">
               <cfscript>
                  v_extensao = ListToArray(arguments.NOME_ARQUIVO, '.');
               </cfscript>               
                
                <cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_ins_pessoa_assinatura' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ASSINATURA_ID' variable='retorno.ASSINATURA_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_USUARIO'  value='#arguments.USUARIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_BLOB' dbvarname='P_IMAGEM'  value='#VARQUIVO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EXTENSAO'  value='#v_extensao[ArrayLen(v_extensao)]#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Assinatura Digital inserida com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Atualizar Assinatura Digital
	-- RAFAEL 20/11/2012 22:23:54 - CRIADO
	--->
	<cffunction name='upd_assinatura' displayname='Atualizar Assinatura Digital' access='remote' returntype='Struct' output='true'>
		<cfargument name='ASSINATURA_ID' required='yes'>
		<cfargument name='USUARIO' required='yes'>
		<cfargument name='NOME_ARQUIVO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<!--- Busca arquivo --->
               <cffile action="readbinary" file="#expandPath("/")#temp/#arguments.NOME_ARQUIVO#" variable="VARQUIVO">
               <cfscript>
                  v_extensao = ListToArray(arguments.NOME_ARQUIVO, '.');
               </cfscript>
                
                <cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_alt_pessoa_assinatura' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ASSINATURA_ID'  value='#arguments.ASSINATURA_ID#'  null='#iif(len(trim(arguments.ASSINATURA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_USUARIO'  value='#arguments.USUARIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_BLOB' dbvarname='P_IMAGEM'  value='#VARQUIVO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EXTENSAO'  value='#v_extensao[ArrayLen(v_extensao)]#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Assinatura Digital atualizada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Excluir Assinatura Digital
	-- RAFAEL 20/11/2012 22:24:47 - CRIADO
	--->
	<cffunction name='del_assinatura' displayname='Excluir Assinatura Digital' access='remote' returntype='Struct' output='true'>
		<cfargument name='ASSINATURA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_del_pessoa_assinatura' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ASSINATURA_ID'  value='#arguments.ASSINATURA_ID#'  null='#iif(len(trim(arguments.ASSINATURA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Assinatura Digital excluda com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>    
    
</cfcomponent>