<cfcomponent  displayname="KM&M Gerenciador de Arquivos"
			  hint="<b>Site de Suporte da KM&M  de Engenharia de Sistemas</b><br>
				   <b>Autor					: Luciana <br>
				   <b>Data Criao</b> 		: 04/03/2005<br> 
				   <b>Atualizador			: </b><br>
				   <b>Data Atualizao</b> 	: <br> 
				   <b>Descrio				: </b><br> <div align='justify'>Esse Componente  repons' & chr( 225 )  & 'vel por reunir mtodos do Gerenciador de Arquivos.</div>"
			  extends="_componentes.cfc_erros">

<cffunction name="altera_senha" displayname="Inicia execucao da tarefa" access="remote" returntype="Struct" output="true">
   <!--- 
   	-- PROPSITO
	-- Inicia a execucao da tarefa
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 22/07/2005 - criado
	--->			
	<cfargument name="usuario" required="yes">
	<cfargument name="senha" required="yes">
	<cfargument name="antiga" required="yes">
	<cftry>
		<cfstoredproc procedure="acesso.prc_altera_senha_corrente" datasource="#session.dsn#" username="#session.usuario#" password="#arguments.antiga#">
			<cfprocparam dbvarname="p_senha" type="in" value="#arguments.senha#" cfsqltype="cf_sql_varchar">
		</cfstoredproc>							

		<cfset retorno.erro = false>
		<cfset retorno.mensagem = JSStringFormat("Senha alterada com sucesso!")>
		<cfset session.senha = arguments.senha>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />		
</cffunction>



<cffunction name="iniciar_execucao" displayname="Inicia execucao da tarefa" access="remote" returntype="Struct" output="true">
   <!--- 
   	-- PROPSITO
	-- Inicia a execucao da tarefa
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 22/07/2005 - criado
	--->			
	<cfargument name="tarefa_id" required="yes">
	<cfargument name="observacao" required="yes">
	<cftry>
		<cfstoredproc procedure="internet.pkg_tarefas.prc_tarefa_executar" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_tarefa_id" type="in" value="#val(arguments.tarefa_id)#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_descricao_ocorrencia" type="in" value="#arguments.observacao#" cfsqltype="cf_sql_varchar">
		</cfstoredproc>							

		<cfset retorno.erro = false>
		<cfset retorno.mensagem = JSStringFormat("Execuo iniciada com sucesso!")>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />		
</cffunction>

<cffunction name="parar_execucao" displayname="Inicia execucao da tarefa" access="remote" returntype="Struct" output="true">
   <!--- 
   	-- PROPSITO
	-- Inicia a execucao da tarefa
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 22/07/2005 - criado
	--->			
	<cfargument name="tarefa_id" required="yes">
	<cfargument name="observacao" required="yes">
	<cftry>
		<cfstoredproc procedure="internet.pkg_tarefas.prc_tarefa_parar" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_tarefa_id" type="in" value="#val(arguments.tarefa_id)#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_descricao_ocorrencia" type="in" value="#arguments.observacao#" cfsqltype="cf_sql_varchar">
		</cfstoredproc>							

		<cfset retorno.erro = false>
		<cfset retorno.mensagem = JSStringFormat("Execuo parada com sucesso!")>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />		
</cffunction>

<cffunction name="insere_ocorrencia" displayname="Insere ocorrencia na tarefa" access="remote" returntype="Struct" output="true">
   <!--- 
   	-- PROPSITO
	-- insere ocorrencia na tarefa
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 22/07/2005 - criado
	--->			
	<cfargument name="tipo_ocorrencia_id" required="yes">
	<cfargument name="tarefa_id" required="yes">
	<cfargument name="observacao" required="yes">
	<cftry>
		<cfstoredproc procedure="internet.pkg_tarefas.prc_tarefa_ocorrencia" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_tipo_ocorrencia_id" type="in" value="#val(arguments.tipo_ocorrencia_id)#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_tarefa_id" type="in" value="#val(arguments.tarefa_id)#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_descricao_ocorrencia" type="in" value="#arguments.observacao#" cfsqltype="cf_sql_varchar">
		</cfstoredproc>							

		<cfset retorno.erro = false>
		<cfset retorno.mensagem = JSStringFormat("Ocorrencia inserida com sucesso!")>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />		
</cffunction>

<cffunction name="aguardar_definicao" displayname="Aguardar definicao" access="remote" returntype="Struct" output="true">
   <!--- 
   	-- PROPSITO
	-- aguarda definicao da tarefa
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 22/07/2005 - criado
	--->			
	<cfargument name="tarefa_id" required="yes">
	<cfargument name="observacao" required="yes">
	<cftry>
		<cfstoredproc procedure="internet.pkg_tarefas.prc_tarefa_aguardar" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_tarefa_id" type="in" value="#val(arguments.tarefa_id)#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_descricao_ocorrencia" type="in" value="#arguments.observacao#" cfsqltype="cf_sql_varchar">
		</cfstoredproc>							

		<cfset retorno.erro = false>
		<cfset retorno.mensagem = JSStringFormat("Operao realizada com sucesso!")>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />		
</cffunction>
 

<cffunction name="libera_teste" displayname="Aguardar definicao" access="remote" returntype="Struct" output="true">
   <!--- 
   	-- PROPSITO
	-- aguarda definicao da tarefa
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 22/07/2005 - criado
	--->			
	<cfargument name="tarefa_id" required="yes">
	<cfargument name="tarefa_atribuicao_id" required="yes">
	<cfargument name="observacao" required="yes">
	
	<cfargument name="pergunta_id" required="no" default="">
	<cfargument name="comentario" required="no">
	<cfargument name="verificado" required="no">	
	<cfargument name="atualizar_em" required="no" default="DateFormat(now(), 'DD/MM/YYYY')">
	<cfargument name="comentario_atualizacao" required="no" default="">

	<cfargument name="dias" required="yes">
	<cfargument name="horas" required="yes">
	<cftry>
		<cftransaction action="begin">
		<cfstoredproc procedure="internet.pkg_tarefas.prc_tarefa_liberar_teste" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_tarefa_atribuicao_id" type="in" value="#val(arguments.tarefa_atribuicao_id)#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_tarefa_id" type="in" value="#val(arguments.tarefa_id)#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_data_baixa" type="in" value="#Now()#" cfsqltype="cf_sql_timestamp">			

			<cfprocparam dbvarname="p_tecnico_testador" type="in" value="#arguments.testador#" cfsqltype="cf_sql_varchar">
			<cfprocparam dbvarname="p_tempo_estimado" type="in" value="#NumberFormat(arguments.dias, '00')# #arguments.horas#" cfsqltype="cf_sql_varchar">

			<cfprocparam dbvarname="p_descricao_ocorrencia" type="in" value="#arguments.observacao#" cfsqltype="cf_sql_varchar">
		</cfstoredproc>	
		<cfif len(trim(arguments.pergunta_id))>
			<cfset arguments.verificado = ''>
			<cfloop list="arguments.pergunta_id" index="idx">
				<cfset arguments.verificado = ListAppend(arguments.verificado,"1",",")>
			</cfloop>
			<cfscript>				
				this.resolver_checklist(argumentCollection = arguments);
			</cfscript>
		</cfif>
		<cfset retorno.erro = false>
		<cfset retorno.mensagem = JSStringFormat("Operao realizada com sucesso!")>
		</cftransaction>
		<cfcatch>
			<cftransaction action="rollback" />
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
			<cfdump var="#retorno#">
		</cfcatch>
	</cftry>
	<cfreturn retorno />		
</cffunction>

<cffunction name="recusa_execucao" displayname="Recusar a execucao" access="remote" returntype="Struct" output="true">
   <!--- 
   	-- PROPSITO
	-- Recusa a execuo das tarefas
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 25/07/2005 - criado
	--->			
	<cfargument name="tarefa_id" required="yes">
	<cfargument name="observacao" required="yes">
	<cftry>
		<cfstoredproc procedure="internet.pkg_tarefas.prc_tarefa_recusar" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_tarefa_id" type="in" value="#val(arguments.tarefa_id)#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_tecnico_responsavel" type="in" value="#arguments.tecnico_responsavel#" cfsqltype="cf_sql_varchar">
			<cfprocparam dbvarname="p_descricao_ocorrencia" type="in" value="#arguments.observacao#" cfsqltype="cf_sql_varchar">
		</cfstoredproc>							

		<cfset retorno.erro = false>
		<cfset retorno.mensagem = JSStringFormat("Execuo recusada com sucesso!")>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />		
</cffunction>

<cffunction name="libera_atualizacao" displayname="Libera para Atualizao" access="remote" returntype="Struct" output="true">
   <!--- 
   	-- PROPSITO
	-- Disponibiliza para atualizao
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 25/07/2005 - criado
	--->			
	<cfargument name="tarefa_id" required="yes">
	<cfargument name="observacao" required="yes">
	<cftry>
		<cfstoredproc procedure="internet.pkg_tarefas.prc_tarefa_disponibilizar" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_tarefa_id" type="in" value="#val(arguments.tarefa_id)#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_descricao_ocorrencia" type="in" value="#arguments.observacao#" cfsqltype="cf_sql_varchar">
		</cfstoredproc>							

		<cfset retorno.erro = false>
		<cfset retorno.mensagem = JSStringFormat("Tarefa liberada para atualizao com sucesso!")>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />		
</cffunction>

<cffunction name="finalizar" displayname="Finalizar Tarefa" access="remote" returntype="Struct" output="true">
   <!--- 
   	-- PROPSITO
	-- Finaliza a tarefa
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 27/07/2005 - criado
	--->			
	<cfargument name="tarefa_id" required="yes">
	<cfargument name="observacao" required="yes">
	<cftry>
		<cfstoredproc procedure="internet.pkg_tarefas.prc_tarefa_finalizar" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_tarefa_id" type="in" value="#val(arguments.tarefa_id)#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_descricao_ocorrencia" type="in" value="#arguments.observacao#" cfsqltype="cf_sql_varchar">
		</cfstoredproc>							

		<cfset retorno.erro = false>
		<cfset retorno.mensagem = JSStringFormat("Tarefa finalizada com sucesso!")>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />		
</cffunction>

<cffunction name="rejeita" displayname="Rejeita a Tarefa" access="remote" returntype="Struct" output="true">
   <!--- 
   	-- PROPSITO
	-- Rejeita a tarefa
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 27/07/2005 - criado
	--->			
	<cfargument name="tarefa_id" required="yes">
	<cfargument name="observacao" required="yes">
	<cftry>
		<cfstoredproc procedure="internet.pkg_tarefas.prc_tarefa_rejeitar" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_tarefa_id" type="in" value="#val(arguments.tarefa_id)#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_descricao_ocorrencia" type="in" value="#arguments.observacao#" cfsqltype="cf_sql_varchar">
		</cfstoredproc>							

		<cfset retorno.erro = false>
		<cfset retorno.mensagem = JSStringFormat("Tarefa rejeitada com sucesso!")>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />		
</cffunction>


<cffunction name="insere" displayname="Insere uma nova tarefa" access="remote" returntype="Struct" output="true">
   <!--- 
   	-- PROPSITO
	-- Insere uma tarefa no sistema
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 27/07/2005 - criado
	--->			
	<cfargument name="aplicacao" required="yes">
	<cfargument name="tipo_aplicacao" required="yes">
	<cfargument name="cliente" required="yes">
	<cfargument name="filial" required="yes">
	<cfargument name="contato" required="yes">
	<cfargument name="tarefa_tipo_id" required="yes">
	<cfargument name="urgencia_id" required="yes">
	<cfargument name="sd" required="yes">
	<cfargument name="data_limite" required="yes">
	<cfargument name="tarefa" required="yes">
	<cfargument name="dias" required="yes">
	<cfargument name="horas" required="yes">

	<cfargument name="pergunta_id" required="no" default="">
	<cfargument name="pergunta_descricao" required="no" default="">
	<cfargument name="comentario_pergunta" required="no" default="">
	<cfargument name="verificado" required="no" default="">
	<cftry>
		<cftransaction action="begin">
			<cfstoredproc procedure="internet.pkg_tarefas.prc_tarefa_inserir" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				<cfprocparam dbvarname="p_tarefa_id" type="out" variable="retorno.tarefa_id" cfsqltype="cf_sql_integer">
				<cfprocparam dbvarname="p_aplicacao" type="in" value="#arguments.aplicacao#" cfsqltype="cf_sql_varchar">
				<cfprocparam dbvarname="p_tipo_aplicacao_id" type="in" value="#arguments.tipo_aplicacao#" cfsqltype="cf_sql_integer">
				<cfprocparam dbvarname="p_cliente" type="in" value="#arguments.cliente#" cfsqltype="cf_sql_varchar">
				<cfprocparam dbvarname="p_filial" type="in" value="#arguments.filial#" cfsqltype="cf_sql_varchar">
				<cfprocparam dbvarname="p_contato" type="in" value="#UCase(arguments.contato)#" cfsqltype="cf_sql_varchar">
				<cfprocparam dbvarname="p_tipo_id" type="in" value="#arguments.tarefa_tipo_id#" cfsqltype="cf_sql_integer">
				<cfprocparam dbvarname="p_urgencia_id" type="in" value="#arguments.urgencia_id#" cfsqltype="cf_sql_integer">
				<cfprocparam dbvarname="p_programa_id" type="in" cfsqltype="cf_sql_varchar" null="yes">
				<cfprocparam dbvarname="p_sd_id" type="in" value="#arguments.sd#" cfsqltype="cf_sql_integer" null="#IIf(len(trim(arguments.sd)), DE('no'), DE('yes'))#">
				<cfprocparam dbvarname="p_data_emissao" type="in" value="#now()#" cfsqltype="cf_sql_date" >
				<cfprocparam dbvarname="p_data_limite" type="in" value="#arguments.data_limite#" cfsqltype="cf_sql_varchar">
				<cfprocparam dbvarname="p_status_id" type="in" value="1" cfsqltype="cf_sql_integer">
				<cfprocparam dbvarname="p_descricao_tarefa" type="in" value="#arguments.tarefa#" cfsqltype="cf_sql_varchar">
				<cfprocparam dbvarname="p_tempo_estimado" type="in" value="#NumberFormat(arguments.dias, '00')# #arguments.horas#" cfsqltype="cf_sql_varchar">
				<cfprocparam dbvarname="p_rowid" type="out" variable="retorno.rowid" cfsqltype="cf_sql_varchar">
			</cfstoredproc>		
			<cfset posicao = 1>
			<cfset v_tarefa_id = retorno.tarefa_id>
			<cfif len(trim(arguments.pergunta_id))>
				<cfloop list=",#arguments.pergunta_id#" delimiters=",|" index="v_item">
					<cfscript>
						this.ins_pergunta_tarefa(tarefa_id = v_tarefa_id, pergunta_descricao = ListGetAt(",#arguments.pergunta_descricao#", posicao, ",|"), comentario_pergunta = ListGetAt(",#arguments.comentario_pergunta#", posicao, ",|"), verificado = ListGetAt(","&arguments.verificado, posicao, ","), pergunta_id = ListGetAt(","&arguments.pergunta_id, posicao, ","));
					</cfscript>
					<cfset posicao = posicao + 1>
				</cfloop>
			</cfif>
		</cftransaction>
		<cfset retorno.erro = false>
		<cfset retorno.mensagem = JSStringFormat("Tarefa inserida com sucesso!")>
		<cfcatch>
			<cftransaction action="rollback" />
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />		
</cffunction>

<cffunction name="ins_pergunta_tarefa" displayname="Insere uma nova tarefa" access="package" returntype="Struct" output="true">
   <!--- 
   	-- PROPSITO
	-- Insere ou altera uma pergunta na tarefa
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 08/08/2005 - criado
	--->			
	<cfargument name="tarefa_id" required="yes">
	<cfargument name="pergunta_id" required="yes">
	<cfargument name="pergunta_descricao" required="yes">
	<cfargument name="comentario_pergunta" required="yes">
	<cfargument name="verificado" required="yes">
		<cfstoredproc procedure="internet.pkg_tarefas.prc_checklist_insere_altera" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_tarefa_id" type="in" value="#arguments.tarefa_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_pergunta_id" type="in" value="#arguments.pergunta_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_pergunta" type="in" value="#trim(arguments.pergunta_descricao)#" cfsqltype="cf_sql_varchar">
			<cfprocparam dbvarname="p_comentario" type="in" value="#trim(arguments.comentario_pergunta)#" cfsqltype="cf_sql_varchar">
			<cfprocparam dbvarname="p_verificado" type="in" value="#arguments.verificado#" cfsqltype="cf_sql_integer">
		</cfstoredproc>		
		<cfset retorno = StructNew()>
	<cfreturn retorno />		
</cffunction>

<cffunction name="del_perguntas_tarefa" displayname="Insere uma nova tarefa" access="package" returntype="Struct" output="true">
   <!--- 
   	-- PROPSITO
	-- Exclui as perguntas de uma tarefa q nao estiverem na lista perguntas_id
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 09/08/2005 - criado
	--->			
	<cfargument name="tarefa_id" required="yes">
	<cfargument name="perguntas_id" required="yes">
	<cfscript>
		conn_tarefas_consult = CreateObject("component", "_componentes.consulta.cfc_tarefas");
		qrPerguntasExcluidas = conn_tarefas_consult.getPerguntasTarefa(tarefa_id = arguments.tarefa_id, lista_pergunta_id = perguntas_id, invalidas = "1");
	</cfscript>
	<cfloop query="qrPerguntasExcluidas">
		<cfstoredproc procedure="internet.pkg_tarefas.prc_checklist_excluir" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_tarefa_id" type="in" value="#qrPerguntasExcluidas.tarefa_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_pergunta_id" type="in" value="#qrPerguntasExcluidas.pergunta_id#" cfsqltype="cf_sql_integer">
		</cfstoredproc>		
	</cfloop>
	<cfset retorno = StructNew()>
	<cfreturn retorno />		
</cffunction>

<cffunction name="del_pergunta_tarefa" displayname="Insere uma nova tarefa" access="remote" returntype="Struct" output="true">
   <!--- 
   	-- PROPSITO
	-- Exclui uma pergunta na tarefa
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 09/08/2005 - criado
	--->			
	<cfargument name="tarefa_id" required="yes">
	<cfargument name="pergunta_id" required="yes">
		<cfstoredproc procedure="internet.pkg_tarefas.prc_checklist_excluir" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_tarefa_id" type="in" value="#arguments.tarefa_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_pergunta_id" type="in" value="#arguments.pergunta_id#" cfsqltype="cf_sql_integer">
		</cfstoredproc>		
		<cfset retorno = StructNew()>
	<cfreturn retorno />		
</cffunction>

<cffunction name="resolver_checklist" displayname="Resolve o checklist da tarefa" access="remote" returntype="Struct" output="true">
   <!--- 
   	-- PROPSITO
	-- Resolve as checklists da tarefa
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 10/08/2005 - criado
	--->			
	<cfargument name="tarefa_id" required="yes">
	<cfargument name="pergunta_id" required="yes">
	<cfargument name="comentario" required="yes">
	<cfargument name="verificado" required="yes">
	<cfset posicao = 1>
	<cftry>
		<cfset posicao = 1>
		<cfloop list="#arguments.pergunta_id#" delimiters="," index="v_item">
			<cfstoredproc procedure="internet.pkg_tarefas.prc_checklist_editar" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				<cfprocparam dbvarname="p_tarefa_id" type="in" value="#arguments.tarefa_id#" cfsqltype="cf_sql_integer">
				<cfprocparam dbvarname="p_pergunta_id" type="in" value="#v_item#" cfsqltype="cf_sql_integer">
				<cfprocparam dbvarname="p_comentario" type="in" value="#trim(ListGetAt(',#arguments.comentario#', posicao, ',|'))#" cfsqltype="cf_sql_varchar">
				<cfprocparam dbvarname="p_verificado_executor" type="in" value="#ListGetAt('#arguments.verificado#', posicao, ',')#" cfsqltype="cf_sql_integer">
				<cfprocparam dbvarname="p_verificado_testador" type="in" null="yes" cfsqltype="cf_sql_integer">
			</cfstoredproc>		
			<cfset posicao = posicao+1>
		</cfloop>
		<cfset retorno.erro = false>
		<cfset retorno.mensagem = JSStringFormat("Operacao realizada com sucesso!")>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />		
</cffunction>

<cffunction name="altera" displayname="Altera uma tarefa" access="remote" returntype="Struct" output="true">
   <!--- 
   	-- PROPSITO
	-- Altera uma tarefa no sistema
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 27/07/2005 - criado
	--->			
	<cfargument name="aplicacao" required="yes">
	<cfargument name="tipo_aplicacao" required="yes">
	<cfargument name="cliente" required="yes">
	<cfargument name="filial" required="yes">
	<cfargument name="contato" required="yes">
	<cfargument name="tarefa_tipo_id" required="yes">
	<cfargument name="urgencia_id" required="yes">
	<cfargument name="sd" required="yes">
	<cfargument name="data_limite" required="yes">
	<cfargument name="tarefa" required="yes">
	<cfargument name="status_id" required="yes">
	<cfargument name="data_emissao" required="yes">
	<cfargument name="tarefa_id" required="yes">

	<cfargument name="dias" required="yes">
	<cfargument name="horas" required="yes">
	
	<cfargument name="pergunta_id" required="no" default="">
	<cfargument name="pergunta_descricao" required="no" default="">
	<cfargument name="comentario_pergunta" required="no" default="">
	<cfargument name="verificado" required="no" default="">
	<cftry>
		<cftransaction action="begin">
			<cfstoredproc procedure="internet.pkg_tarefas.prc_tarefa_atualizar" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				<cfprocparam dbvarname="p_tarefa_id" type="in" value="#arguments.tarefa_id#" cfsqltype="cf_sql_integer">
				<cfprocparam dbvarname="p_aplicacao" type="in" value="#arguments.aplicacao#" cfsqltype="cf_sql_varchar">
				<cfprocparam dbvarname="p_tipo_aplicacao_id" type="in" value="#arguments.tipo_aplicacao#" cfsqltype="cf_sql_integer">
				<cfprocparam dbvarname="p_cliente" type="in" value="#arguments.cliente#" cfsqltype="cf_sql_varchar">
				<cfprocparam dbvarname="p_filial" type="in" value="#arguments.filial#" cfsqltype="cf_sql_varchar">
				<cfprocparam dbvarname="p_contato" type="in" value="#UCase(arguments.contato)#" cfsqltype="cf_sql_varchar">
				<cfprocparam dbvarname="p_tipo_id" type="in" value="#arguments.tarefa_tipo_id#" cfsqltype="cf_sql_integer">
				<cfprocparam dbvarname="p_urgencia_id" type="in" value="#arguments.urgencia_id#" cfsqltype="cf_sql_integer">
				<cfprocparam dbvarname="p_programa_id" type="in" cfsqltype="cf_sql_varchar" null="yes">
				<cfprocparam dbvarname="p_sd_id" type="in" value="#arguments.sd#" cfsqltype="cf_sql_integer" null="#IIf(len(trim(arguments.sd)), DE('no'), DE('yes'))#">
				<cfprocparam dbvarname="p_data_emissao" type="in" value="#arguments.data_emissao#" cfsqltype="cf_sql_date" >
				<cfprocparam dbvarname="p_data_limite" type="in" value="#arguments.data_limite#" cfsqltype="cf_sql_varchar">
				<cfprocparam dbvarname="p_data_conclusao" type="in" null="yes" cfsqltype="cf_sql_varchar">
				<cfprocparam dbvarname="p_status_id" type="in" value="#arguments.status_id#" cfsqltype="cf_sql_integer">
				<cfprocparam dbvarname="p_descricao_tarefa" type="in" value="#arguments.tarefa#" cfsqltype="cf_sql_varchar">
				<cfprocparam dbvarname="p_tempo_estimado" type="in" value="#NumberFormat(arguments.dias, '00')# #arguments.horas#" cfsqltype="cf_sql_varchar">
				<cfprocparam dbvarname="p_comentario" type="in" null="yes" cfsqltype="cf_sql_varchar">
			</cfstoredproc>							
			<cfset posicao = 1>
			<cfscript>
				this.del_perguntas_tarefa(tarefa_id = arguments.tarefa_id, perguntas_id = arguments.pergunta_id);
			</cfscript>
			<cfif len(trim(arguments.pergunta_id))>
				<cfloop list=",#arguments.pergunta_id#" delimiters=",|" index="v_item">
					<cfscript>					
						this.ins_pergunta_tarefa(tarefa_id = arguments.tarefa_id, pergunta_descricao = ListGetAt(",#arguments.pergunta_descricao#", posicao, ",|"), comentario_pergunta = ListGetAt(",#arguments.comentario_pergunta#", posicao, ",|"), verificado = ListGetAt(","&arguments.verificado, posicao, ","), pergunta_id = ListGetAt(","&arguments.pergunta_id, posicao, ","));
					</cfscript>
					<cfset posicao = posicao + 1>
				</cfloop>
			</cfif>
		</cftransaction>
		<cfset retorno.erro = false>
		<cfset retorno.mensagem = JSStringFormat("Tarefa alterada com sucesso!")>
		<cfcatch>
			<cftransaction action="rollback" />
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />		
</cffunction>

<cffunction name="atribuir" displayname="Insere uma nova tarefa" access="remote" returntype="Struct" output="true">
   <!--- 
   	-- PROPSITO
	-- Atribui a tarefa para um tecnico
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 27/07/2005 - criado
	--->			
	<cfargument name="tarefa_id" required="yes">
	<cfargument name="atribuido_para" required="yes">
	<cfargument name="data_fim" required="yes">
	<cfargument name="data_inicio" required="yes">
	<cfargument name="comentario" required="yes">
	<cftry>
		<cfstoredproc procedure="internet.pkg_tarefas.prc_tarefa_atribuir" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_tarefa_atribuicao_id" type="out" variable="retorno.tarefa_atribuicao_id" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_tarefa_id" type="in" value="#arguments.tarefa_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_atribuido_para" type="in" value="#arguments.atribuido_para#" cfsqltype="cf_sql_varhcar">
			<cfprocparam dbvarname="p_data_atribuicao" type="in" value="#now()#" cfsqltype="cf_sql_date">
			<cfprocparam dbvarname="p_data_inicio" type="in" value="#arguments.data_inicio#" cfsqltype="cf_sql_varchar">
			<cfprocparam dbvarname="p_data_fim" type="in" value="#arguments.data_fim#" cfsqltype="cf_sql_varchar">
			<cfprocparam dbvarname="p_comentario" type="in" value="#arguments.comentario#" cfsqltype="cf_sql_varchar">
			<cfprocparam dbvarname="p_rowid" type="out" value="retorno.rowid" cfsqltype="cf_sql_varchar">
		</cfstoredproc>							

		<cfset retorno.erro = false>
		<cfset retorno.mensagem = JSStringFormat("Tarefa atribuda com sucesso!")>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />		
</cffunction>

<cffunction name="ajustar" displayname="Insere uma nova tarefa" access="remote" returntype="Struct" output="true">
   <!--- 
   	-- PROPSITO
	-- Atribui a tarefa para um tecnico
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 27/07/2005 - criado
	--->			
	<cfargument name="tarefa_id" required="yes">
	<cfargument name="data_fim" required="yes">
	<cfargument name="data_inicio" required="yes">
	<cfargument name="data_limite" required="yes">
	<cfargument name="comentario" required="yes">
	<cftry>
		<cfstoredproc procedure="internet.pkg_tarefas.prc_tarefa_adiar" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_tarefa_id" type="in" value="#arguments.tarefa_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_data_inicio" type="in" value="#arguments.data_inicio#" cfsqltype="cf_sql_varchar">
			<cfprocparam dbvarname="p_data_fim" type="in" value="#arguments.data_fim#" cfsqltype="cf_sql_varchar">
			<cfprocparam dbvarname="p_data_limite" type="in" value="#arguments.data_limite#" cfsqltype="cf_sql_varchar">
			<cfprocparam dbvarname="p_comentario" type="in" value="#arguments.comentario#" cfsqltype="cf_sql_varchar">
		</cfstoredproc>							

		<cfset retorno.erro = false>
		<cfset retorno.mensagem = JSStringFormat("Periodo Ajustado com sucesso!")>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />		
</cffunction>

<cffunction name="transferir" displayname="Transfere a tarefa para outro tecnico" access="remote" returntype="Struct" output="true">
   <!--- 
   	-- PROPSITO
	-- Atribui a tarefa para um novo tecnico
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 27/07/2005 - criado
	--->			
	<cfargument name="tarefa_id" required="yes">
	<cfargument name="tecnico_atual" required="yes">
	<cfargument name="novo_tecnico" required="yes">
	<cfargument name="descricao" required="yes">
	<cftry>
		<cfstoredproc procedure="internet.pkg_tarefas.prc_tarefa_transferir" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_tarefa_id" type="in" value="#arguments.tarefa_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_tecnico_atual" type="in" value="#arguments.tecnico_atual#" cfsqltype="cf_sql_varchar">
			<cfprocparam dbvarname="p_novo_tecnico" type="in" value="#arguments.novo_tecnico#" cfsqltype="cf_sql_varchar">
			<cfprocparam dbvarname="p_descricao" type="in" value="#arguments.descricao#" cfsqltype="cf_sql_varchar">
		</cfstoredproc>							

		<cfset retorno.erro = false>
		<cfset retorno.mensagem = JSStringFormat("Tarefa transferida com sucesso!")>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />		
</cffunction>
<!---Pergunta--->
<cffunction name="ins_pergunta" displayname="Insere uma nova pergunta" access="remote" returntype="Struct" output="true">
   <!--- 
   	-- PROPSITO
	-- Insere uma nova pergunta para as checklists das tarefas
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 08/08/2005 - criado
	--->			
	<cfargument name="pergunta_descricao" required="yes">
	<cftry>
		<cfstoredproc procedure="internet.pkg_tarefas.prc_checklist_pergunta" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_pergunta_id" type="inout" null="yes" cfsqltype="cf_sql_integer" variable="retorno.pergunta_id">
			<cfprocparam dbvarname="p_pergunta_descricao" type="in" value="#arguments.pergunta_descricao#" cfsqltype="cf_sql_varchar">
			<cfprocparam dbvarname="p_action" type="in" value="I" cfsqltype="cf_sql_char">
		</cfstoredproc>							

		<cfset retorno.erro = false>
		<cfset retorno.mensagem = JSStringFormat("Pergunta inserida com sucesso!")>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />		
</cffunction>
<cffunction name="upd_pergunta" displayname="Altera uma pergunta" access="remote" returntype="Struct" output="true">
   <!--- 
   	-- PROPSITO
	-- Altera uma pergunta das checklists das tarefas
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 08/08/2005 - criado
	--->			
	<cfargument name="pergunta_id" required="yes">
	<cfargument name="pergunta_descricao" required="yes">
	<cftry>
		<cfstoredproc procedure="internet.pkg_tarefas.prc_checklist_pergunta" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_pergunta_id" type="inout" value="#arguments.pergunta_id#" cfsqltype="cf_sql_integer" variable="retorno.pergunta_id">
			<cfprocparam dbvarname="p_pergunta_descricao" type="in" value="#arguments.pergunta_descricao#" cfsqltype="cf_sql_varchar">
			<cfprocparam dbvarname="p_action" type="in" value="U" cfsqltype="cf_sql_char">
		</cfstoredproc>							

		<cfset retorno.erro = false>
		<cfset retorno.mensagem = JSStringFormat("Pergunta alterada com sucesso!")>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />		
</cffunction>
<cffunction name="del_pergunta" displayname="Exclui uma pergunta" access="remote" returntype="Struct" output="true">
   <!--- 
   	-- PROPSITO
	-- Exclui uma nova pergunta das checklists das tarefas
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 08/08/2005 - criado
	--->			
	<cfargument name="pergunta_id" required="yes">
	<cfargument name="pergunta_descricao" required="yes">
	<cftry>
		<cfstoredproc procedure="internet.pkg_tarefas.prc_checklist_pergunta" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_pergunta_id" type="inout" value="#arguments.pergunta_id#" cfsqltype="cf_sql_integer">
			<cfprocparam dbvarname="p_pergunta_descricao" type="in" value="" cfsqltype="cf_sql_varchar">
			<cfprocparam dbvarname="p_action" type="in" value="D" cfsqltype="cf_sql_char">
		</cfstoredproc>							

		<cfset retorno.erro = false>
		<cfset retorno.mensagem = JSStringFormat("Pergunta excluda com sucesso!")>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />		
</cffunction>

<!---Modelo--->
<cffunction name="ins_modelo" displayname="Insere modelo" access="remote" returntype="Struct" output="true">
   <!--- 
   	-- PROPSITO
	-- cria um novo modelo de checklist
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 09/08/2005 - criado
	--->			
	<cfargument name="modelo_descricao" required="yes">
	<cfargument name="pergunta_id" required="yes">
	<cftry>
		<cftransaction action="begin">
			<cfstoredproc procedure="internet.pkg_tarefas.prc_checklist_modelo_completo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				<cfprocparam dbvarname="p_modelo_id" type="inout" null="yes" cfsqltype="cf_sql_integer" variable="retorno.modelo_id">
				<cfprocparam dbvarname="p_modelo_descricao" type="in" value="#arguments.modelo_descricao#" cfsqltype="cf_sql_varchar">
				<cfprocparam dbvarname="p_lista_pergunta_id" type="in" value="#arguments.pergunta_id#" cfsqltype="cf_sql_varchar">
				<cfprocparam dbvarname="p_action" type="in" value="I" cfsqltype="cf_sql_char">
			</cfstoredproc>							
		</cftransaction>
		<cfset retorno.erro = false>
		<cfset retorno.mensagem = JSStringFormat("Modelo inserido com sucesso!")>
		<cfcatch>
			<cftransaction action="rollback" />
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />		
</cffunction>
<cffunction name="upd_modelo" displayname="Insere modelo" access="remote" returntype="Struct" output="true">
   <!--- 
   	-- PROPSITO
	-- altera um modelo de checklist
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 09/08/2005 - criado
	--->			
	<cfargument name="modelo_id" required="yes">
	<cfargument name="modelo_descricao" required="yes">
	<cfargument name="pergunta_id" required="yes">
	<cftry>
		<cftransaction action="begin">
			<cfstoredproc procedure="internet.pkg_tarefas.prc_checklist_modelo_completo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				<cfprocparam dbvarname="p_modelo_id" type="inout" value="#arguments.modelo_id#" cfsqltype="cf_sql_integer" variable="retorno.modelo_id">
				<cfprocparam dbvarname="p_modelo_descricao" type="in" value="#arguments.modelo_descricao#" cfsqltype="cf_sql_varchar">
				<cfprocparam dbvarname="p_lista_pergunta_id" type="in" value="#arguments.pergunta_id#" cfsqltype="cf_sql_varchar">
				<cfprocparam dbvarname="p_action" type="in" value="U" cfsqltype="cf_sql_char">
			</cfstoredproc>							
		</cftransaction>
		<cfset retorno.erro = false>
		<cfset retorno.mensagem = JSStringFormat("Modelo alterado com sucesso!")>
		<cfcatch>
			<cftransaction action="rollback" />
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />		
</cffunction>
<cffunction name="del_modelo" displayname="Insere modelo" access="remote" returntype="Struct" output="true">
   <!--- 
   	-- PROPSITO
	-- exclui um modelo de checklist
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 09/08/2005 - criado
	--->			
	<cfargument name="modelo_id" required="yes">
	<cftry>
		<cftransaction action="begin">
			<cfstoredproc procedure="internet.pkg_tarefas.prc_checklist_modelo_completo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				<cfprocparam dbvarname="p_modelo_id" type="inout" value="#arguments.modelo_id#" cfsqltype="cf_sql_integer" variable="retorno.modelo_id">
				<cfprocparam dbvarname="p_modelo_descricao" type="in" null="yes" cfsqltype="cf_sql_varchar">
				<cfprocparam dbvarname="p_lista_pergunta_id" type="in" null="yes" cfsqltype="cf_sql_varchar">
				<cfprocparam dbvarname="p_action" type="in" value="D" cfsqltype="cf_sql_char">
			</cfstoredproc>							
		</cftransaction>
		<cfset retorno.erro = false>
		<cfset retorno.mensagem = JSStringFormat("Modelo excluido com sucesso!")>
		<cfcatch>
			<cftransaction action="rollback" />
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />		
</cffunction>


</cfcomponent>