<cfcomponent>
	<!--- 
	-- PROPSITO
	-- Insere mensagem enviada pelo site ou sistema no banco de dados
	-- guto 03/02/2006 10:48:22 - CRIADO
	--->
	<cffunction name='ins_mensagem_erro' displayname='Insere mensagem enviada pelo site ou sistema no banco de dados' access='remote' returntype='Struct' output='true'>;
		<cfargument name='APLICACAO' required='yes'>
		<cfargument name='CLIENTE' required='yes'>
		<cfargument name='TIPO_ID' required='yes'>
		<cfargument name='DATA_RECEBIMENTO' required='yes'>
		<cfargument name='USUARIO' required='yes'>
		<cfargument name='MENSAGEM' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='programacao.pkg_suporte.prc_ins_mensagem_erro' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_APLICACAO'  value='#arguments.APLICACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CLIENTE'  value='#arguments.CLIENTE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_TIPO_ID'  value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='cf_sql_timestamp' dbvarname='P_DATA_RECEBIMENTO'  value='#arguments.DATA_RECEBIMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_USUARIO'  value='#arguments.USUARIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_BLOB'    dbvarname='P_MENSAGEM' value="#CharsetDecode(arguments.MENSAGEM,'utf-8')#">
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Mensagem inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere um email de suporte na tabela de controle
	-- guto 23/08/2006 15:38:27 - CRIADO
	--->
	<cffunction name='ins_suporte_mensagem' displayname='Insere um email de suporte na tabela de controle' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ASSUNTO' required='yes'>
		<cfargument name='CORPO' required='yes'>
		<cfargument name='PASTA_ID' required='yes'>
		<cfargument name='ENVIADO_POR' required='yes'>
		<cfargument name='DATA_ENVIO' required='yes'>
		<cfargument name='EMAILID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm.pkg_suporte_mensagem.prc_ins_suporte_mensagem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ASSUNTO'  value='#arguments.ASSUNTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_CLOB' dbvarname='P_CORPO'  value='#arguments.CORPO#'  null='#iif(len(trim(arguments.CORPO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PASTA_ID'  value='#arguments.PASTA_ID#'  null='#iif(len(trim(arguments.PASTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENVIADO_POR'  value='#arguments.ENVIADO_POR#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_ENVIO'  value='#arguments.DATA_ENVIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMAILID'  value='#arguments.EMAILID#' >
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MENSAGEM_ID' null="yes" variable="retorno.MENSAGEM_ID">
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Mensagem inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cfdump var="#cfcatch#">
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Insere um anexo de email de suporte na tabela de controle
	-- guto 23/08/2006 15:41:10 - CRIADO
	--->
	<cffunction name='ins_suporte_mensagem_anexo' displayname='Insere um anexo de email de suporte na tabela de controle' access='remote' returntype='Struct' output='true'>;
		<cfargument name='MENSAGEM_ID' required='yes'>
		<cfargument name='NOME' required='yes'>
		<cfargument name='OBJETO' required='yes'>
			<cfstoredproc procedure='kmm.pkg_suporte_mensagem.prc_ins_mensagem_suporte_anexo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MENSAGEM_ID'  value='#arguments.MENSAGEM_ID#'  null='#iif(len(trim(arguments.MENSAGEM_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_BLOB' dbvarname='P_OBJETO'  value='#arguments.OBJETO#'>
				<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ANEXO_ID'  variable='retorno.ANEXO_ID' null="yes">
			</cfstoredproc>
		<cfreturn retorno />
	</cffunction>	
</cfcomponent>