<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO
	-- Insere um novo cliente
	-- cristofer 16/05/2006 09:21:38 - CRIADO
	--->
	<cffunction name='ins_cliente' displayname='Insere um novo cliente' access='remote' returntype='Struct' output='true'>;
		<cfargument name='NOME' required='yes'>
		<cfargument name='PASTA' required='yes'>
		<cfargument name='DSN' required='yes'>
		<cfargument name='LOGO' required='yes'>
		<cfargument name='URL' required='yes'>
		<cfargument name='SINCRONIZADOR' required='no' default="0">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='site.pkg_site.prc_ins_cliente' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PASTA'  value='#arguments.PASTA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DSN'  value='#arguments.DSN#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_LOGO'  value='#arguments.LOGO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_URL'  value='#arguments.URL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SINCRONIZADOR'  value='#arguments.SINCRONIZADOR#'  null='#iif(len(trim(arguments.SINCRONIZADOR)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CLIENTE_ID' variable='retorno.CLIENTE_ID'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Cliente inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera um cliente
	-- cristofer 16/05/2006 09:22:22 - CRIADO
	--->
	<cffunction name='upd_cliente' displayname='Altera um cliente' access='remote' returntype='Struct' output='true'>;
		<cfargument name='CLIENTE_ID' required='yes'>
		<cfargument name='NOME' required='yes'>
		<cfargument name='PASTA' required='yes'>
		<cfargument name='DSN' required='yes'>
		<cfargument name='LOGO' required='yes'>
		<cfargument name='URL' required='yes'>
		<cfargument name='SINCRONIZADOR' required='no' default="0">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='site.pkg_site.prc_alt_cliente' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CLIENTE_ID'  value='#arguments.CLIENTE_ID#'  null='#iif(len(trim(arguments.CLIENTE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PASTA'  value='#arguments.PASTA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DSN'  value='#arguments.DSN#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_LOGO'  value='#arguments.LOGO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_URL'  value='#arguments.URL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SINCRONIZADOR'  value='#arguments.SINCRONIZADOR#'  null='#iif(len(trim(arguments.SINCRONIZADOR)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Cliente alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um cliente
	-- cristofer 16/05/2006 09:22:52 - CRIADO
	--->
	<cffunction name='del_cliente' displayname='Exclui um cliente' access='remote' returntype='Struct' output='true'>;
		<cfargument name='CLIENTE_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='site.pkg_site.prc_del_cliente' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CLIENTE_ID'  value='#arguments.CLIENTE_ID#'  null='#iif(len(trim(arguments.CLIENTE_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Cliente excluido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere um layout
	-- cristofer 17/05/2006 09:26:30 - CRIADO
	--->
	<cffunction name='ins_layout' displayname='Insere um layout' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ANEXO_ID' required='yes'>
		<cfargument name='SITUACAO_ID' required='yes'>
		<cfargument name='COMENTARIO' required='yes'>
		<cfargument name='CLIENTE_ID' required='yes'>
		<cfargument name='DIMENSAO_ID' required='yes'>
		<cfargument name='TIPO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='site.pkg_site.prc_ins_layout' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ANEXO_ID'  value='#arguments.ANEXO_ID#'  null='#iif(len(trim(arguments.ANEXO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SITUACAO_ID'  value='#arguments.SITUACAO_ID#'  null='#iif(len(trim(arguments.SITUACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMENTARIO'  value='#arguments.COMENTARIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CLIENTE_ID'  value='#arguments.CLIENTE_ID#'  null='#iif(len(trim(arguments.CLIENTE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DIMENSAO_ID'  value='#arguments.DIMENSAO_ID#'  null='#iif(len(trim(arguments.DIMENSAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TIPO'  value='#arguments.TIPO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LAYOUT_ID' variable='retorno.LAYOUT_ID'  null='#iif(len(trim(arguments.LAYOUT_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Layout inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera um layout
	-- cristofer 17/05/2006 09:27:48 - CRIADO
	--->
	<cffunction name='upd_layout' displayname='Altera um layout' access='remote' returntype='Struct' output='true'>;
		<cfargument name='LAYOUT_ID' required='yes'>
		<cfargument name='ANEXO_ID' required='yes'>
		<cfargument name='SITUACAO_ID' required='yes'>
		<cfargument name='COMENTARIO' required='yes'>
		<cfargument name='CLIENTE_ID' required='yes'>
		<cfargument name='DIMENSAO_ID' required='yes'>
		<cfargument name='TIPO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='site.pkg_site.prc_alt_layout' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LAYOUT_ID'  value='#arguments.LAYOUT_ID#'  null='#iif(len(trim(arguments.LAYOUT_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ANEXO_ID'  value='#arguments.ANEXO_ID#'  null='#iif(len(trim(arguments.ANEXO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SITUACAO_ID'  value='#arguments.SITUACAO_ID#'  null='#iif(len(trim(arguments.SITUACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMENTARIO'  value='#arguments.COMENTARIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CLIENTE_ID'  value='#arguments.CLIENTE_ID#'  null='#iif(len(trim(arguments.CLIENTE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DIMENSAO_ID'  value='#arguments.DIMENSAO_ID#'  null='#iif(len(trim(arguments.DIMENSAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TIPO'  value='#arguments.TIPO#' >
				</cfstoredproc>
				<cfif isdefined("arguments.arquivo") and len(trim(arguments.arquivo))>
					<cfscript>
						conn = CreateObject("component", "_transportes.consulta.cfc_desenvolvimento");
						qrAnexo = conn.get_anexo(anexo_id = arguments.anexo_id);
					</cfscript>
					<cfif not qrAnexo.recordcount>
						<cfthrow detail="No foi possvel localizar o anexo!"
								 message="No foi possvel localizar o anexo!">
					</cfif>
					<cffile action="upload"
							filefield="arquivo" 
							nameconflict="overwrite" 
							destination="#Replace(qrAnexo.url,'http://portal.kmm.com.br/documentos/','/var/www/html/portal/documentos/','one')#"
							result="retorno.arquivo">
					<cfdump var="#retorno.arquivo#">
				</cfif>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Layout alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um layout
	-- cristofer 17/05/2006 09:28:18 - CRIADO
	--->
	<cffunction name='del_layout' displayname='Exclui um layout' access='remote' returntype='Struct' output='true'>;
		<cfargument name='LAYOUT_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='site.pkg_site.prc_del_layout' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LAYOUT_ID'  value='#arguments.LAYOUT_ID#'  null='#iif(len(trim(arguments.LAYOUT_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Layout excluido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
    
    <!--- 
	-- PROPSITO
	-- Insere uma atualizacao do arquivo
	-- cristofer 02/01/2008 17:00:18 - CRIADO
	--->
    <cffunction name="ins_site_arquivo" displayname="Insere um arquivo no sincronizador" access="remote" returntype="Struct" output="true">
        <cfargument name="path" required="yes">
        <cfargument name="atualizacao_id" required="yes">
        <cfargument name="servidor_origem" required="yes">
        <cftry>
                <cfscript>
                    conn = CreateObject("webservice", "http://#arguments.servidor_origem#/_transportes/consulta/cfc_sincronizador.cfc?wsdl");
                    v_dir = ListDeleteAt(arguments.path,ListLen(arguments.path,'/'),'/');
                    v_file = ListLast(arguments.path,'/');
                </cfscript>
                <cfset vArquivoBIN = conn.get_conteudo_arquivo_remoto(path = arguments.path)>
                <cfscript>
                    ret = this.gera_arquivo_versao(	diretorio 		= v_dir,
                                                    nome			= v_file,
                                                    conteudo 		= vArquivoBIN,
                                                    assinatura 		= conn.md5_file(expand=1,file = arguments.path),
                                                    atualizacao_id	= arguments.atualizacao_id);
                </cfscript>	
                <cfif ret.erro>
                    <cfthrow object="#ret.mensagem#">
                </cfif>
				<cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat("Arquivo inserido com sucesso!")>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />		
    </cffunction>    
        
    <!--- 
    -- PROPSITO
    -- Gera uma atualizacao
    -- cristofer 30/08/2007 10:31:27 - CRIADO
    --->
    <cffunction name='ins_atualizacao' displayname='Gera uma atualizacao' access='remote' returntype='Struct' output='true'>
        <cfargument name='TITULO' required='yes'>
        <cfargument name='DESCRICAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='site.pkg_atualizacao.prc_ins_atualizacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATUALIZACAO_ID' variable='retorno.ATUALIZACAO_ID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Atualizao inserida com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Insere uma versao do arquivo
    -- cristofer 30/08/2007 10:47:47 - CRIADO
    --->
    <cffunction name='gera_arquivo_versao' displayname='Insere uma versao do arquivo' access='remote' returntype='Struct' output='true'>
        <cfargument name='DIRETORIO' required='yes'>
        <cfargument name='NOME' required='yes'>
        <cfargument name='CONTEUDO' required='yes'>
        <cfargument name='ASSINATURA' required='yes'>
        <cfargument name='ATUALIZACAO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='site.pkg_atualizacao.prc_gera_arquivo_versao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DIRETORIO'  value='#arguments.DIRETORIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_BLOB' dbvarname='P_CONTEUDO'  value='#arguments.CONTEUDO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ASSINATURA'  value='#arguments.ASSINATURA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATUALIZACAO_ID'  value='#arguments.ATUALIZACAO_ID#'  null='#iif(len(trim(arguments.ATUALIZACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ARQUIVO_ID' variable='retorno.ARQUIVO_ID' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VERSAO' variable='retorno.VERSAO' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Arquivo sincronizado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
</cfcomponent>