<cfcomponent extends="_transportes.funcoes.cfc_init">

	<!--- 	
    -- PROPSITO
    -- Exclui setor
    -- guto 06/12/2008 14:49:36 - CRIADO
    --->
    <cffunction name='ins_setor' displayname='Exclui setor' access='remote' returntype='Struct' output='true'>
        <cfargument name='DESCRICAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='sgq.pkg_sgq.prc_ins_setor' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SETOR_ID' variable='retorno.SETOR_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Setor inserido com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Altera setor
    -- guto 06/12/2008 14:51:21 - CRIADO
    --->
    <cffunction name='upd_setor' displayname='Altera setor' access='remote' returntype='Struct' output='true'>
        <cfargument name='SETOR_ID' required='yes'>
        <cfargument name='DESCRICAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='sgq.pkg_sgq.prc_alt_setor' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SETOR_ID'  value='#arguments.SETOR_ID#'  null='#iif(len(trim(arguments.SETOR_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Setor alterado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Exclui setor
    -- guto 06/12/2008 14:53:50 - CRIADO
    --->
    <cffunction name='del_setor' displayname='Exclui setor' access='remote' returntype='Struct' output='true'>
        <cfargument name='SETOR_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='sgq.pkg_sgq.prc_del_setor' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SETOR_ID'  value='#arguments.SETOR_ID#'  null='#iif(len(trim(arguments.SETOR_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Setor excludo com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
    
	<!--- 
    -- PROPSITO
    -- Insere nao confirmadade
    -- guto 06/12/2008 14:08:09 - CRIADO
    --->
    <cffunction name='ins_nao_conformidade' displayname='Insere nao confirmadade' access='remote' returntype='Struct' output='true'>
        <cfargument name='DATA_ABERTURA' required='yes'>
        <cfargument name='SETOR_ID' required='yes'>
        <cfargument name='TIPO' required='yes'>
        <cfargument name='REGISTRO' required='yes'>
        <cfargument name='ELABORADO_POR' required='yes'>
        <cfargument name='ELABORADO_POR_SETOR_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='sgq.pkg_sgq.prc_ins_nao_conformidade' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NAO_CONFORMIDADE' variable='retorno.NUM_NAO_CONFORMIDADE' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_ABERTURA'  value='#arguments.DATA_ABERTURA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SETOR_ID'  value='#arguments.SETOR_ID#'  null='#iif(len(trim(arguments.SETOR_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO'  value='#arguments.TIPO#'  null='#iif(len(trim(arguments.TIPO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REGISTRO'  value='#arguments.REGISTRO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ELABORADO_POR'  value='#arguments.ELABORADO_POR#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ELABORADO_POR_SETOR_ID'  value='#arguments.ELABORADO_POR_SETOR_ID#'  null='#iif(len(trim(arguments.ELABORADO_POR_SETOR_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Nao conformidade inserida com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    <!--- 
    -- PROPSITO
    -- Altera nao confirmadade
    -- guto 06/12/2008 14:14:55 - CRIADO
    --->
    <cffunction name='upd_nao_conformidade' displayname='Altera nao confirmadade' access='remote' returntype='Struct' output='true'>
        <cfargument name='NUM_NAO_CONFORMIDADE' required='yes'>
        <cfargument name='DATA_ABERTURA' required='yes'>
        <cfargument name='SETOR_ID' required='yes'>
        <cfargument name='TIPO' required='yes'>
        <cfargument name='REGISTRO' required='yes'>
        <cfargument name='ELABORADO_POR' required='yes'>
        <cfargument name='ELABORADO_POR_SETOR_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='sgq.pkg_sgq.prc_alt_nao_conformidade' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NAO_CONFORMIDADE'  value='#arguments.NUM_NAO_CONFORMIDADE#'  null='#iif(len(trim(arguments.NUM_NAO_CONFORMIDADE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_ABERTURA'  value='#arguments.DATA_ABERTURA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SETOR_ID'  value='#arguments.SETOR_ID#'  null='#iif(len(trim(arguments.SETOR_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO'  value='#arguments.TIPO#'  null='#iif(len(trim(arguments.TIPO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REGISTRO'  value='#arguments.REGISTRO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ELABORADO_POR'  value='#arguments.ELABORADO_POR#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ELABORADO_POR_SETOR_ID'  value='#arguments.ELABORADO_POR_SETOR_ID#'  null='#iif(len(trim(arguments.ELABORADO_POR_SETOR_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Nao conformidade alterada com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    <!--- 
    -- PROPSITO
    -- Excluir nao confirmadade
    -- guto 06/12/2008 14:16:18 - CRIADO
    --->
    <cffunction name='del_nao_conformidade' displayname='Excluir nao confirmadade' access='remote' returntype='Struct' output='true'>
        <cfargument name='NUM_NAO_CONFORMIDADE' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='sgq.pkg_sgq.prc_del_nao_conformidade' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NAO_CONFORMIDADE'  value='#arguments.NUM_NAO_CONFORMIDADE#'  null='#iif(len(trim(arguments.NUM_NAO_CONFORMIDADE)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Nao conformidade excluir com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Incluir aao nao confirmadade
    -- guto 06/12/2008 14:30:38 - CRIADO
    --->
    <cffunction name='ins_nao_conformidade_acao' displayname='Incluir aao nao confirmadade' access='remote' returntype='Struct' output='true'>
        <cfargument name='NUM_NAO_CONFORMIDADE' required='yes'>
        <cfargument name='DESCRICAO' required='yes'>
        <cfargument name='RESPONSAVEL' required='yes'>
        <cfargument name='DATA_IMPLEMENTACAO' required='no' default="">
        <cftry>
            <cfstoredproc procedure='sgq.pkg_sgq.prc_ins_nao_conformidade_acao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ACAO_ID' variable='retorno.ACAO_ID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NAO_CONFORMIDADE'  value='#arguments.NUM_NAO_CONFORMIDADE#'  null='#iif(len(trim(arguments.NUM_NAO_CONFORMIDADE)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RESPONSAVEL'  value='#arguments.RESPONSAVEL#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_IMPLEMENTACAO'  value='#arguments.DATA_IMPLEMENTACAO#' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Aao corretiva para nao conformidade com sucesso!')>
        <cfcatch>
            <cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
            <cfset request.erro = cfcatch>
        </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Altera aao da nao conformidade
    -- guto 06/12/2008 14:36:49 - CRIADO
    --->
    <cffunction name='upd_nao_conformidade_acao' displayname='Altera aao da nao conformidade' access='remote' returntype='Struct' output='true'>
        <cfargument name='ACAO_ID' required='yes'>
        <cfargument name='NUM_NAO_CONFORMIDADE' required='yes'>
        <cfargument name='DESCRICAO' required='yes'>
        <cfargument name='RESPONSAVEL' required='yes'>
        <cftry>
                <cfstoredproc procedure='sgq.pkg_sgq.prc_alt_nao_conformidade_acao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ACAO_ID'  value='#arguments.ACAO_ID#'  null='#iif(len(trim(arguments.ACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NAO_CONFORMIDADE'  value='#arguments.NUM_NAO_CONFORMIDADE#'  null='#iif(len(trim(arguments.NUM_NAO_CONFORMIDADE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RESPONSAVEL'  value='#arguments.RESPONSAVEL#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Aao corretiva para nao conformidade alterada com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Exclui aao da nao conformidade
    -- guto 06/12/2008 14:38:04 - CRIADO
    --->
    <cffunction name='del_nao_conformidade_acao' displayname='Exclui aao da nao conformidade' access='remote' returntype='Struct' output='true'>
        <cfargument name='ACAO_ID' required='yes'>
        <cftry>
                <cfstoredproc procedure='sgq.pkg_sgq.prc_del_nao_conformidade_acao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ACAO_ID'  value='#arguments.ACAO_ID#'  null='#iif(len(trim(arguments.ACAO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Aao corretiva para nao conformidade excluda com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Insere analise a RNC
    -- guto 08/12/2008 11:03:49 - CRIADO
    --->
    <cffunction name='ins_rnc_analise' displayname='Insere analise a RNC' access='remote' returntype='Struct' output='true'>
        <cfargument name='NUM_NAO_CONFORMIDADE' required='yes'>
        <cfargument name='CAUSA' required='yes'>
        <cfargument name='CAUSA_OBSERVACAO' required='yes'>
        <cfargument name='ANALISE_DATA' required='yes'>
        <cfargument name='ANALISADO_POR' required='yes'>
        <cfargument name='RESPONSAVEL_GERAL' required='yes'>
        <cfargument name='DISPOSICAO_OUTRAS' required='no' default="">
        <cfargument name='DISPOSICAO' required='no' default="0">
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='sgq.pkg_sgq.prc_ins_analise_rnc' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NAO_CONFORMIDADE'  value='#arguments.NUM_NAO_CONFORMIDADE#'  null='#iif(len(trim(arguments.NUM_NAO_CONFORMIDADE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CAUSA'  value='#arguments.CAUSA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CAUSA_OBSERVACAO'  value='#arguments.CAUSA_OBSERVACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ANALISE_DATA'  value='#arguments.ANALISE_DATA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ANALISADO_POR'  value='#arguments.ANALISADO_POR#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RESPONSAVEL_GERAL'  value='#arguments.RESPONSAVEL_GERAL#' >
                </cfstoredproc>
                
                <!---Seta Disposiao--->
                <cfloop from="1" to="4" index="i">
                	<cfscript>
					   set_disposicao = this.rnc_set_disposicao(num_nao_conformidade = arguments.num_nao_conformidade,
										                 	    posicao_flag = #i#,
																disposicao_outras = arguments.DISPOSICAO_OUTRAS,
											                    setado = iif (ListFind(arguments.DISPOSICAO,i),de('1'),de('0'))
																);
					</cfscript>
                    <cfif set_disposicao.erro>
	                    <cfthrow object="#set_disposicao.mensagem#">
                    </cfif>
                </cfloop>
                <cfscript>
					v_acao_id     = this.ListaToArray (lista = arguments, variavel = "ACAO_ID_ACAO");					
					v_descricao   = this.ListaToArray (lista = arguments, variavel = "DESCRICAO_ACAO");					
					v_responsavel = this.ListaToArray (lista = arguments, variavel = "RESPONSAVEL_ACAO");				
					v_acao_excluir = this.ListDiff(lista1 = arguments.lista_deleted_ACAO, lista2 = ArrayToList(v_acao_id));
				</cfscript>
                <cfloop list="#v_acao_excluir#" index="id">
                	<cfscript>
						set_acao = this.del_nao_conformidade_acao(acao_id = #id#);
					</cfscript>
                    <cfif set_acao.erro>
                    	<cfthrow object="#set_acao.mensagem#">
                    </cfif>
                </cfloop>
  				<cfloop from="1" to="#ArrayLen(v_acao_id)#" index="count">
                	<cfscript>
					    if (not Len(Trim(v_acao_id[count]))) {
							set_acao = this.ins_nao_conformidade_acao(num_nao_conformidade = arguments.num_nao_conformidade
																	 ,responsavel = v_responsavel[count]
																	 ,descricao = v_descricao[count]);
						} else {
							set_acao = this.upd_nao_conformidade_acao(acao_id = v_acao_id[count]
																	 ,num_nao_conformidade = arguments.num_nao_conformidade
																	 ,responsavel = v_responsavel[count]
																	 ,descricao = v_descricao[count]);
							
						}
					</cfscript>
                    <cfif set_acao.erro>
                    	<cfthrow object="#set_acao.mensagem#">
                    </cfif>
                </cfloop>

                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Analise inserida com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Marca/Desmarca flag 
    -- guto 08/12/2008 12:44:16 - CRIADO
    --->
    <cffunction name='rnc_set_disposicao' displayname='Marca/Desmarca flag ' access='remote' returntype='Struct' output='true'>
        <cfargument name='NUM_NAO_CONFORMIDADE' required='yes'>
        <cfargument name='POSICAO_FLAG' required='yes'>
        <cfargument name='SETADO' required='yes'>
        <cfargument name='DISPOSICAO_OUTRAS' required='no' default="">
        <cftry>
                <cfstoredproc procedure='sgq.pkg_sgq.prc_set_disposicao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NAO_CONFORMIDADE'  value='#arguments.NUM_NAO_CONFORMIDADE#'  null='#iif(len(trim(arguments.NUM_NAO_CONFORMIDADE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_POSICAO_FLAG'  value='#arguments.POSICAO_FLAG#'  null='#iif(len(trim(arguments.POSICAO_FLAG)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SETADO'  value='#arguments.SETADO#'  null='#iif(len(trim(arguments.SETADO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DISPOSICAO_OUTRAS'  value='#arguments.DISPOSICAO_OUTRAS#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Ok')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Insere data de implementaao
    -- guto 08/12/2008 16:27:06 - CRIADO
    --->
    <cffunction name='ins_acao_implementacao' displayname='Insere data de implementaao' access='remote' returntype='Struct' output='true'>
        <cfargument name='ACAO_ID' required='yes'>
        <cfargument name='DATA_IMPLEMENTACAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='sgq.pkg_sgq.prc_ins_acao_implementacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ACAO_ID'  value='#arguments.ACAO_ID#'  null='#iif(len(trim(arguments.ACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_IMPLEMENTACAO'  value='#arguments.DATA_IMPLEMENTACAO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Data de implementaao atualizada com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Fecha nao conformidade
    -- GUTO 15/12/2008 13:46:16 - CRIADO
    --->
    <cffunction name='fecha_nao_conformidade' displayname='Fecha nao conformidade' access='remote' returntype='Struct' output='true'>
        <cfargument name='NUM_NAO_CONFORMIDADE' required='yes'>
        <cfargument name='EFICAZ' required='yes'>
        <cfargument name='VERIFICACAO_EFICACIA' required='yes'>
        <cfargument name='DATA_FECHAMENTO' required='yes'>
        <cfargument name='RESPONSAVEL_FINAL' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='sgq.pkg_sgq.prc_fecha_nao_conformidade' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NAO_CONFORMIDADE'  value='#arguments.NUM_NAO_CONFORMIDADE#'  null='#iif(len(trim(arguments.NUM_NAO_CONFORMIDADE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EFICAZ'  value='#arguments.EFICAZ#'  null='#iif(len(trim(arguments.EFICAZ)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_VERIFICACAO_EFICACIA'  value='#arguments.VERIFICACAO_EFICACIA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_FECHAMENTO'  value='#arguments.DATA_FECHAMENTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RESPONSAVEL_FINAL'  value='#arguments.RESPONSAVEL_FINAL#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('RNC fechada com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
</cfcomponent>