<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPSITO
    -- Insere uma Ficha Preliminar de Ocorrncia
    -- ANDERSONC 25/05/2009 09:06:09 - CRIADO
    --->
    <cffunction name='ins_seg_ficha' displayname='Insere uma Ficha Preliminar de Ocorrncia' access='remote' returntype='Struct' output='true'>
        <cfargument name='SINISTRO_ID' required='yes'>
        <cfargument name='DATA_HORA' required='yes'>
        <cfargument name='COD_GRUPO' required='yes'>
        <cfargument name='TIPO_FRETE' required='yes'>
        <cfargument name='TIPO_AVARIA' required='yes'>
        <cfargument name='NUM_ROMANEIO' required='yes'>
        <cfargument name='NOME_ATENDENTE' required='yes'>
        <cfargument name='DATA_HORA_ATENDIMENTO' required='yes'>
        <cfargument name='MUNICIPIO_ID_ORIGEM' required='yes'>
        <cfargument name='MUNICIPIO_ID_DESTINO' required='yes'>
        <cfargument name='MUNICIPIO_ID_LOCAL' required='yes'>
        <cfargument name='DESCRICAO_LOCAL' required='yes'>
        <cfargument name='NUM_NATUREZA' required='yes'>
        <cfargument name='VALOR_CARGA' required='yes'>
        <cfargument name='INFORMANTE' required='yes'>
        <cfargument name='INFORMANTE_TELEFONE' required='yes'>
        <cfargument name='COD_PESSOA_CLIENTE' required='yes'>
        <cfargument name='COD_PESSOA_CORRETORA' required='yes'>
        <cfargument name='COD_PESSOA_SEGURADORA' required='yes'>
        <cfargument name='COD_PESSOA_MOTORISTA' required='yes'>
        <cfargument name='MOT_COD_CARGO' required='yes'>
        <cfargument name='MOT_MODALIDADE' required='yes'>
        <cfargument name='MOT_SITUACAO' required='yes'>
        <cfargument name='MOT_HOSPITAL' required='yes'>
        <cfargument name='MOT_HOSPITAL_TELEFONE' required='yes'>
        <cfargument name='MOT_MEDICO' required='yes'>
        <cfargument name='MOT_SOLIC_BO' required='yes'>
        <cfargument name='MOT_SOLIC_DISCO' required='yes'>
        <cfargument name='MOT_SOLIC_FOTO' required='yes'>
        <cfargument name='OCORRENCIA_DESC' required='yes'>
        <cfargument name='VEIC_RODAR' required='yes'>
        <cfargument name='VEIC_GUINCHO' required='yes'>
        <cfargument name='VEIC_CARRETA_DANOS' required='yes'>
        <cfargument name='VEIC_CARRETA_RODAR' required='yes'>
        <cfargument name='VEIC_REMOCAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_seg_sinistro.prc_ins_seg_ficha' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SINISTRO_ID'  value='#arguments.SINISTRO_ID#' variable='retorno.SINISTRO_ID'  null='#iif(len(trim(arguments.SINISTRO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_HORA'  value='#arguments.DATA_HORA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_GRUPO'  value='#arguments.COD_GRUPO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_FRETE'  value='#arguments.TIPO_FRETE#'  null='#iif(len(trim(arguments.TIPO_FRETE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_AVARIA'  value='#arguments.TIPO_AVARIA#'  null='#iif(len(trim(arguments.TIPO_AVARIA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME_ATENDENTE'  value='#arguments.NOME_ATENDENTE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_HORA_ATENDIMENTO'  value='#arguments.DATA_HORA_ATENDIMENTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MUNICIPIO_ID_ORIGEM'  value='#arguments.MUNICIPIO_ID_ORIGEM#'  null='#iif(len(trim(arguments.MUNICIPIO_ID_ORIGEM)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MUNICIPIO_ID_DESTINO'  value='#arguments.MUNICIPIO_ID_DESTINO#'  null='#iif(len(trim(arguments.MUNICIPIO_ID_DESTINO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MUNICIPIO_ID_LOCAL'  value='#arguments.MUNICIPIO_ID_LOCAL#'  null='#iif(len(trim(arguments.MUNICIPIO_ID_LOCAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO_LOCAL'  value='#arguments.DESCRICAO_LOCAL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NATUREZA'  value='#arguments.NUM_NATUREZA#'  null='#iif(len(trim(arguments.NUM_NATUREZA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_CARGA'  value='#arguments.VALOR_CARGA#'  null='#iif(len(trim(arguments.VALOR_CARGA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_INFORMANTE'  value='#arguments.INFORMANTE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_INFORMANTE_TELEFONE'  value='#arguments.INFORMANTE_TELEFONE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_CLIENTE'  value='#arguments.COD_PESSOA_CLIENTE#'  null='#iif(len(trim(arguments.COD_PESSOA_CLIENTE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_CORRETORA'  value='#arguments.COD_PESSOA_CORRETORA#'  null='#iif(len(trim(arguments.COD_PESSOA_CORRETORA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_SEGURADORA'  value='#arguments.COD_PESSOA_SEGURADORA#'  null='#iif(len(trim(arguments.COD_PESSOA_SEGURADORA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_MOTORISTA'  value='#arguments.COD_PESSOA_MOTORISTA#'  null='#iif(len(trim(arguments.COD_PESSOA_MOTORISTA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOT_COD_CARGO'  value='#arguments.MOT_COD_CARGO#'  null='#iif(len(trim(arguments.MOT_COD_CARGO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MOT_MODALIDADE'  value='#arguments.MOT_MODALIDADE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MOT_SITUACAO'  value='#arguments.MOT_SITUACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MOT_HOSPITAL'  value='#arguments.MOT_HOSPITAL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MOT_HOSPITAL_TELEFONE'  value='#arguments.MOT_HOSPITAL_TELEFONE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MOT_MEDICO'  value='#arguments.MOT_MEDICO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOT_SOLIC_BO'  value='#arguments.MOT_SOLIC_BO#'  null='#iif(len(trim(arguments.MOT_SOLIC_BO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOT_SOLIC_DISCO'  value='#arguments.MOT_SOLIC_DISCO#'  null='#iif(len(trim(arguments.MOT_SOLIC_DISCO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOT_SOLIC_FOTO'  value='#arguments.MOT_SOLIC_FOTO#'  null='#iif(len(trim(arguments.MOT_SOLIC_FOTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OCORRENCIA_DESC'  value='#arguments.OCORRENCIA_DESC#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VEIC_RODAR'  value='#arguments.VEIC_RODAR#'  null='#iif(len(trim(arguments.VEIC_RODAR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VEIC_GUINCHO'  value='#arguments.VEIC_GUINCHO#'  null='#iif(len(trim(arguments.VEIC_GUINCHO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VEIC_CARRETA_DANOS'  value='#arguments.VEIC_CARRETA_DANOS#'  null='#iif(len(trim(arguments.VEIC_CARRETA_DANOS)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VEIC_CARRETA_RODAR'  value='#arguments.VEIC_CARRETA_RODAR#'  null='#iif(len(trim(arguments.VEIC_CARRETA_RODAR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VEIC_REMOCAO'  value='#arguments.VEIC_REMOCAO#'  null='#iif(len(trim(arguments.VEIC_REMOCAO)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
                
                <!--- Vinculo com o(s) veculo(s) --->
                <cfscript>
					v_veiculo_placa = this.ListaToArray(lista = arguments, variavel = 'PLACA_VEICULO');
					v_veiculo_modalidade = this.ListaToArray(lista = arguments, variavel = 'MODALIDADE_VEICULO');
					v_veiculo_cod_pessoa_proprietario = this.ListaToArray(lista = arguments, variavel = 'COD_PESSOA_PROPRIETARIO_VEICULO');
					v_veiculo_marca_id = this.ListaToArray(lista = arguments, variavel = 'MARCA_ID_VEICULO');
					v_veiculo_modelo_id = this.ListaToArray(lista = arguments, variavel = 'MODELO_ID_VEICULO');
					v_veiculo_ano = this.ListaToArray(lista = arguments, variavel = 'ANO_VEICULO');
					v_veiculo_tipo = this.ListaToArray(lista = arguments, variavel = 'TIPO_VEICULO');
					v_veiculo_situacao_veiculo_id = this.ListaToArray(lista = arguments, variavel = 'SITUACAO_VEICULO_ID_VEICULO');
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_veiculo_placa)#" index="count">
					<cfscript>
						ret = this.ins_seg_veiculo(SINISTRO_ID             = retorno.SINISTRO_ID,
												   PLACA	               = v_veiculo_placa[count],
												   MODALIDADE              = v_veiculo_modalidade[count],
												   COD_PESSOA_PROPRIETARIO = v_veiculo_cod_pessoa_proprietario[count],
												   MARCA_ID                = v_veiculo_marca_id[count],
												   MODELO_ID               = v_veiculo_modelo_id[count],
												   ANO                     = v_veiculo_ano[count],
												   TIPO                    = v_veiculo_tipo[count],
												   SITUACAO_VEICULO_ID     = v_veiculo_situacao_veiculo_id[count]);
					</cfscript>
                </cfloop>				
                <!--- Fim --->
                
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Ficha Preliminar de Ocorrncia inserida com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Altera uma Ficha Preliminar de Ocorrncia
	-- ANDERSONC 25/05/2009 09:07:46 - CRIADO
	--->
	<cffunction name='upd_seg_ficha' displayname='Altera uma Ficha Preliminar de Ocorrncia' access='remote' returntype='Struct' output='true'>
		<cfargument name='SINISTRO_ID' required='yes'>
		<cfargument name='DATA_HORA' required='yes'>
		<cfargument name='COD_GRUPO' required='yes'>
		<cfargument name='TIPO_FRETE' required='yes'>
		<cfargument name='TIPO_AVARIA' required='yes'>
		<cfargument name='NUM_ROMANEIO' required='yes'>
		<cfargument name='NOME_ATENDENTE' required='yes'>
		<cfargument name='DATA_HORA_ATENDIMENTO' required='yes'>
		<cfargument name='MUNICIPIO_ID_ORIGEM' required='yes'>
		<cfargument name='MUNICIPIO_ID_DESTINO' required='yes'>
		<cfargument name='MUNICIPIO_ID_LOCAL' required='yes'>
		<cfargument name='DESCRICAO_LOCAL' required='yes'>
		<cfargument name='NUM_NATUREZA' required='yes'>
		<cfargument name='VALOR_CARGA' required='yes'>
		<cfargument name='INFORMANTE' required='yes'>
		<cfargument name='INFORMANTE_TELEFONE' required='yes'>
		<cfargument name='COD_PESSOA_CLIENTE' required='yes'>
        <cfargument name='COD_PESSOA_CORRETORA' required='yes'>
        <cfargument name='COD_PESSOA_SEGURADORA' required='yes'>
        <cfargument name='COD_PESSOA_MOTORISTA' required='yes'>
		<cfargument name='MOT_COD_CARGO' required='yes'>
		<cfargument name='MOT_MODALIDADE' required='yes'>
		<cfargument name='MOT_SITUACAO' required='yes'>
		<cfargument name='MOT_HOSPITAL' required='yes'>
		<cfargument name='MOT_HOSPITAL_TELEFONE' required='yes'>
		<cfargument name='MOT_MEDICO' required='yes'>
		<cfargument name='MOT_SOLIC_BO' required='yes'>
		<cfargument name='MOT_SOLIC_DISCO' required='yes'>
		<cfargument name='MOT_SOLIC_FOTO' required='yes'>
		<cfargument name='OCORRENCIA_DESC' required='yes'>
		<cfargument name='VEIC_RODAR' required='yes'>
		<cfargument name='VEIC_GUINCHO' required='yes'>
		<cfargument name='VEIC_CARRETA_DANOS' required='yes'>
		<cfargument name='VEIC_CARRETA_RODAR' required='yes'>
		<cfargument name='VEIC_REMOCAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_seg_sinistro.prc_alt_seg_ficha' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SINISTRO_ID'  value='#arguments.SINISTRO_ID#'  null='#iif(len(trim(arguments.SINISTRO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_HORA'  value='#arguments.DATA_HORA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_GRUPO'  value='#arguments.COD_GRUPO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_FRETE'  value='#arguments.TIPO_FRETE#'  null='#iif(len(trim(arguments.TIPO_FRETE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_AVARIA'  value='#arguments.TIPO_AVARIA#'  null='#iif(len(trim(arguments.TIPO_AVARIA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME_ATENDENTE'  value='#arguments.NOME_ATENDENTE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_HORA_ATENDIMENTO'  value='#arguments.DATA_HORA_ATENDIMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MUNICIPIO_ID_ORIGEM'  value='#arguments.MUNICIPIO_ID_ORIGEM#'  null='#iif(len(trim(arguments.MUNICIPIO_ID_ORIGEM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MUNICIPIO_ID_DESTINO'  value='#arguments.MUNICIPIO_ID_DESTINO#'  null='#iif(len(trim(arguments.MUNICIPIO_ID_DESTINO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MUNICIPIO_ID_LOCAL'  value='#arguments.MUNICIPIO_ID_LOCAL#'  null='#iif(len(trim(arguments.MUNICIPIO_ID_LOCAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO_LOCAL'  value='#arguments.DESCRICAO_LOCAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NATUREZA'  value='#arguments.NUM_NATUREZA#'  null='#iif(len(trim(arguments.NUM_NATUREZA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_CARGA'  value='#arguments.VALOR_CARGA#'  null='#iif(len(trim(arguments.VALOR_CARGA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_INFORMANTE'  value='#arguments.INFORMANTE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_INFORMANTE_TELEFONE'  value='#arguments.INFORMANTE_TELEFONE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_CLIENTE'  value='#arguments.COD_PESSOA_CLIENTE#'  null='#iif(len(trim(arguments.COD_PESSOA_CLIENTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_CORRETORA'  value='#arguments.COD_PESSOA_CORRETORA#'  null='#iif(len(trim(arguments.COD_PESSOA_CORRETORA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_SEGURADORA'  value='#arguments.COD_PESSOA_SEGURADORA#'  null='#iif(len(trim(arguments.COD_PESSOA_SEGURADORA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_MOTORISTA'  value='#arguments.COD_PESSOA_MOTORISTA#'  null='#iif(len(trim(arguments.COD_PESSOA_MOTORISTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOT_COD_CARGO'  value='#arguments.MOT_COD_CARGO#'  null='#iif(len(trim(arguments.MOT_COD_CARGO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MOT_MODALIDADE'  value='#arguments.MOT_MODALIDADE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MOT_SITUACAO'  value='#arguments.MOT_SITUACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MOT_HOSPITAL'  value='#arguments.MOT_HOSPITAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MOT_HOSPITAL_TELEFONE'  value='#arguments.MOT_HOSPITAL_TELEFONE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MOT_MEDICO'  value='#arguments.MOT_MEDICO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOT_SOLIC_BO'  value='#arguments.MOT_SOLIC_BO#'  null='#iif(len(trim(arguments.MOT_SOLIC_BO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOT_SOLIC_DISCO'  value='#arguments.MOT_SOLIC_DISCO#'  null='#iif(len(trim(arguments.MOT_SOLIC_DISCO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOT_SOLIC_FOTO'  value='#arguments.MOT_SOLIC_FOTO#'  null='#iif(len(trim(arguments.MOT_SOLIC_FOTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OCORRENCIA_DESC'  value='#arguments.OCORRENCIA_DESC#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VEIC_RODAR'  value='#arguments.VEIC_RODAR#'  null='#iif(len(trim(arguments.VEIC_RODAR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VEIC_GUINCHO'  value='#arguments.VEIC_GUINCHO#'  null='#iif(len(trim(arguments.VEIC_GUINCHO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VEIC_CARRETA_DANOS'  value='#arguments.VEIC_CARRETA_DANOS#'  null='#iif(len(trim(arguments.VEIC_CARRETA_DANOS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VEIC_CARRETA_RODAR'  value='#arguments.VEIC_CARRETA_RODAR#'  null='#iif(len(trim(arguments.VEIC_CARRETA_RODAR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VEIC_REMOCAO'  value='#arguments.VEIC_REMOCAO#'  null='#iif(len(trim(arguments.VEIC_REMOCAO)), de('no'), de('yes'))#'>
				</cfstoredproc>
                
                <!--- Vinculo com o(s) veculo(s) --->
                <cfscript>
					v_veiculo_flag = this.ListaToArray(lista = arguments, variavel = 'VEICULO_FLAG_VEICULO');
					v_veiculo_placa = this.ListaToArray(lista = arguments, variavel = 'PLACA_VEICULO');
					v_veiculo_modalidade = this.ListaToArray(lista = arguments, variavel = 'MODALIDADE_VEICULO');
					v_veiculo_cod_pessoa_proprietario = this.ListaToArray(lista = arguments, variavel = 'COD_PESSOA_PROPRIETARIO_VEICULO');
					v_veiculo_marca_id = this.ListaToArray(lista = arguments, variavel = 'MARCA_ID_VEICULO');
					v_veiculo_modelo_id = this.ListaToArray(lista = arguments, variavel = 'MODELO_ID_VEICULO');
					v_veiculo_ano = this.ListaToArray(lista = arguments, variavel = 'ANO_VEICULO');
					v_veiculo_tipo = this.ListaToArray(lista = arguments, variavel = 'TIPO_VEICULO');
					v_veiculo_situacao_veiculo_id = this.ListaToArray(lista = arguments, variavel = 'SITUACAO_VEICULO_ID_VEICULO');
					
					conn = CreateComponent("_transportes.consulta.cfc_seguro");
					qrVeiculo = conn.get_seg_veiculo(sinistro_id = arguments.SINISTRO_ID);
				</cfscript>
                <cfloop query="qrVeiculo">
                	<cfscript>
						v_flag = 0;
					</cfscript>
                    
                    <cfloop from="1" to="#ArrayLen(v_veiculo_placa)#" index="count">
                    	<cfscript>
							if(qrVeiculo.PLACA eq v_veiculo_placa[count]) {
								v_flag = 1;
								break;
							}
						</cfscript>
                    </cfloop>
                    
                    <cfscript>
						if(v_flag eq 0) {
							ret = this.del_seg_veiculo(SINISTRO_ID = qrVeiculo.SINISTRO_ID,
													   PLACA       = qrVeiculo.PLACA);
						}
					</cfscript>
                </cfloop>
                
				<cfloop from="1" to="#ArrayLen(v_veiculo_placa)#" index="count">
					<cfscript>
						if(Not Len(Trim(v_veiculo_flag[count]))) {
							ret = this.ins_seg_veiculo(SINISTRO_ID             = arguments.SINISTRO_ID,
													   PLACA	               = v_veiculo_placa[count],
													   MODALIDADE              = v_veiculo_modalidade[count],
													   COD_PESSOA_PROPRIETARIO = v_veiculo_cod_pessoa_proprietario[count],
													   MARCA_ID                = v_veiculo_marca_id[count],
													   MODELO_ID               = v_veiculo_modelo_id[count],
													   ANO                     = v_veiculo_ano[count],
													   TIPO                    = v_veiculo_tipo[count],
													   SITUACAO_VEICULO_ID     = v_veiculo_situacao_veiculo_id[count]);
						}
						else {
							ret = this.upd_seg_veiculo(SINISTRO_ID             = arguments.SINISTRO_ID,
													   PLACA	               = v_veiculo_placa[count],
													   MODALIDADE              = v_veiculo_modalidade[count],
													   COD_PESSOA_PROPRIETARIO = v_veiculo_cod_pessoa_proprietario[count],
													   MARCA_ID                = v_veiculo_marca_id[count],
													   MODELO_ID               = v_veiculo_modelo_id[count],
													   ANO                     = v_veiculo_ano[count],
													   TIPO                    = v_veiculo_tipo[count],
													   SITUACAO_VEICULO_ID     = v_veiculo_situacao_veiculo_id[count]);
						}
					</cfscript>
                </cfloop>				
                <!--- Fim --->
                
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Ficha Preliminar de Ocorrncia alterada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Exclui uma Ficha Preliminar de Ocorrncia
	-- ANDERSONC 25/05/2009 09:09:23 - CRIADO
	--->
	<cffunction name='del_seg_ficha' displayname='Exclui uma Ficha Preliminar de Ocorrncia' access='remote' returntype='Struct' output='true'>
		<cfargument name='SINISTRO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_seg_sinistro.prc_del_seg_sinistro' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SINISTRO_ID'  value='#arguments.SINISTRO_ID#'  null='#iif(len(trim(arguments.SINISTRO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Ficha Preliminar de Ocorrncia excluda com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Vincula um veculo a um sinistro
	-- ANDERSONC 25/05/2009 14:35:19 - CRIADO
	--->
	<cffunction name='ins_seg_veiculo' displayname='Vincula um veculo a um sinistro' access='remote' returntype='Struct' output='true'>
		<cfargument name='SINISTRO_ID' required='yes'>
		<cfargument name='PLACA' required='yes'>
		<cfargument name='MODALIDADE' required='yes'>
		<cfargument name='COD_PESSOA_PROPRIETARIO' required='yes'>
		<cfargument name='MARCA_ID' required='yes'>
		<cfargument name='MODELO_ID' required='yes'>
		<cfargument name='ANO' required='yes'>
		<cfargument name='TIPO' required='yes'>
		<cfargument name='SITUACAO_VEICULO_ID' required='yes'>
		<cfargument name='SEGURO_ID' required='no' default=''>
				<cfstoredproc procedure='oper.pkg_seg_sinistro.prc_ins_seg_veiculo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SINISTRO_ID'  value='#arguments.SINISTRO_ID#'  null='#iif(len(trim(arguments.SINISTRO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MODALIDADE'  value='#arguments.MODALIDADE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_PROPRIETARIO'  value='#arguments.COD_PESSOA_PROPRIETARIO#'  null='#iif(len(trim(arguments.COD_PESSOA_PROPRIETARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MARCA_ID'  value='#arguments.MARCA_ID#'  null='#iif(len(trim(arguments.MARCA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MODELO_ID'  value='#arguments.MODELO_ID#'  null='#iif(len(trim(arguments.MODELO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ANO'  value='#arguments.ANO#'  null='#iif(len(trim(arguments.ANO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO'  value='#arguments.TIPO#'  null='#iif(len(trim(arguments.TIPO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SITUACAO_VEICULO_ID'  value='#arguments.SITUACAO_VEICULO_ID#'  null='#iif(len(trim(arguments.SITUACAO_VEICULO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SEGURO_ID'  value='#arguments.SEGURO_ID#'  null='#iif(len(trim(arguments.SEGURO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Vincula um veculo a um sinistro
	-- ANDERSONC 25/05/2009 14:37:50 - CRIADO
	--->
	<cffunction name='upd_seg_veiculo' displayname='Vincula um veculo a um sinistro' access='remote' returntype='Struct' output='true'>
		<cfargument name='SINISTRO_ID' required='yes'>
		<cfargument name='PLACA' required='yes'>
		<cfargument name='MODALIDADE' required='yes'>
		<cfargument name='COD_PESSOA_PROPRIETARIO' required='yes'>
		<cfargument name='MARCA_ID' required='yes'>
		<cfargument name='MODELO_ID' required='yes'>
		<cfargument name='ANO' required='yes'>
		<cfargument name='TIPO' required='yes'>
		<cfargument name='SITUACAO_VEICULO_ID' required='yes'>
		<cfargument name='SEGURO_ID' required='no' default=''>
				<cfstoredproc procedure='oper.pkg_seg_sinistro.prc_alt_seg_veiculo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SINISTRO_ID'  value='#arguments.SINISTRO_ID#'  null='#iif(len(trim(arguments.SINISTRO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MODALIDADE'  value='#arguments.MODALIDADE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_PROPRIETARIO'  value='#arguments.COD_PESSOA_PROPRIETARIO#'  null='#iif(len(trim(arguments.COD_PESSOA_PROPRIETARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MARCA_ID'  value='#arguments.MARCA_ID#'  null='#iif(len(trim(arguments.MARCA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MODELO_ID'  value='#arguments.MODELO_ID#'  null='#iif(len(trim(arguments.MODELO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ANO'  value='#arguments.ANO#'  null='#iif(len(trim(arguments.ANO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO'  value='#arguments.TIPO#'  null='#iif(len(trim(arguments.TIPO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SITUACAO_VEICULO_ID'  value='#arguments.SITUACAO_VEICULO_ID#'  null='#iif(len(trim(arguments.SITUACAO_VEICULO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SEGURO_ID'  value='#arguments.SEGURO_ID#'  null='#iif(len(trim(arguments.SEGURO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Exclui um veculo de um sinistro
	-- ANDERSONC 25/05/2009 14:39:04 - CRIADO
	--->
	<cffunction name='del_seg_veiculo' displayname='Exclui um veculo de um sinistro' access='remote' returntype='Struct' output='true'>
		<cfargument name='SINISTRO_ID' required='yes'>
		<cfargument name='PLACA' required='yes'>
				<cfstoredproc procedure='oper.pkg_seg_sinistro.prc_del_seg_veiculo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SINISTRO_ID'  value='#arguments.SINISTRO_ID#'  null='#iif(len(trim(arguments.SINISTRO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
</cfcomponent>