<!-- KM&M Componentes -->
<cfcomponent displayname="Manipulao das rotas na base kmm" extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO
	-- Limpa todos os pontos da rota
	-- cristofer 31/03/2006 13:37:31 - CRIADO
	--->
	<cffunction name='clean_caminho' displayname='Limpa todos os pontos da rota' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ROTA_ID' required='yes'>
		<cfargument name='CAMINHO_ID' required='yes'>
				<cfstoredproc procedure='pkg_rota.prc_clean_rota_caminho' datasource='KMM.KMM.COM.BR' username='rota' password='!kr_|_04'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ROTA_ID'  value='#arguments.ROTA_ID#'  null='#iif(len(trim(arguments.ROTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CAMINHO_ID'  value='#arguments.CAMINHO_ID#'  null='#iif(len(trim(arguments.CAMINHO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Insere os totais da rota
	-- cristofer 31/03/2006 13:38:52 - CRIADO
	--->
	<cffunction name='ins_caminho_tipo_estrada' displayname='Insere os totais da rota' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ROTA_ID' required='yes'>
		<cfargument name='CAMINHO_ID' required='yes'>
		<cfargument name='COD_TIPO_ESTRADA' required='yes'>
		<cfargument name='TOTAL' required='yes'>
				<cfstoredproc procedure='pkg_rota.prc_ins_caminho_tipo_estrada' datasource='KMM.KMM.COM.BR' username='rota' password='!kr_|_04'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ROTA_ID'  value='#arguments.ROTA_ID#'  null='#iif(len(trim(arguments.ROTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CAMINHO_ID'  value='#arguments.CAMINHO_ID#'  null='#iif(len(trim(arguments.CAMINHO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_TIPO_ESTRADA'  value='#arguments.COD_TIPO_ESTRADA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TOTAL'  value='#arguments.TOTAL#'  null='#iif(len(trim(arguments.TOTAL)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Insere um novo posto de pedagio, caso j? exista, retorna apenas o ID
	-- cristofer 31/03/2006 13:35:50 - CRIADO
	--->
	<cffunction name='ins_pedagio' displayname='Insere um novo posto de pedagio, caso j? exista, retorna apenas o ID' access='remote' returntype='Struct' output='true'>;
		<cfargument name='NOME' required='yes'>
		<cfargument name='LATITUDE' required='yes'>
		<cfargument name='LONGITUDE' required='yes'>
		<cfargument name='CONCESSAO' required='yes'>
		<cfargument name='DIRECAO' required='yes'>
		<cfargument name='PRECO_POR_EIXO' required='yes'>
		<cfargument name='TELEFONE' required='yes'>
		<cfargument name='ENDERECO' required='yes'>
		<cfstoredproc procedure='pkg_rota.prc_ins_rota_pedagio' datasource='KMM.KMM.COM.BR' username='rota' password='!kr_|_04'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LATITUDE'  value='#arguments.LATITUDE#'  null='#iif(len(trim(arguments.LATITUDE)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LONGITUDE'  value='#arguments.LONGITUDE#'  null='#iif(len(trim(arguments.LONGITUDE)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONCESSAO'  value='#arguments.CONCESSAO#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DIRECAO'  value='#arguments.DIRECAO#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRECO_POR_EIXO'  value='#arguments.PRECO_POR_EIXO#'  null='#iif(len(trim(arguments.PRECO_POR_EIXO)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TELEFONE'  value='#arguments.TELEFONE#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENDERECO'  value='#arguments.ENDERECO#' >
			<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PEDAGIO_ID' variable='retorno.PEDAGIO_ID'>
		</cfstoredproc>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Insere uma nova rota
	-- cristofer 28/03/2006 08:56:46 - CRIADO
	--->
	<cffunction name='ins_rota' displayname='Insere uma nova rota' access='remote' returntype='Struct' output='true'>;
		<cfargument name='DESCRICAO_ORIGEM' required='yes'>
		<cfargument name='LATITUDE_ORIGEM' required='yes'>
		<cfargument name='LONGITUDE_ORIGEM' required='yes'>
		<cfargument name='MUNICIPIO_ID_ORIGEM' required='yes'>
		<cfargument name='DESCRICAO_DESTINO' required='yes'>
		<cfargument name='LATITUDE_DESTINO' required='yes'>
		<cfargument name='LONGITUDE_DESTINO' required='yes'>
		<cfargument name='MUNICIPIO_ID_DESTINO' required='yes'>
		<cfstoredproc procedure='pkg_rota.prc_ins_rota' datasource='KMM.KMM.COM.BR' username='rota' password='!kr_|_04'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO_ORIGEM'  value='#arguments.DESCRICAO_ORIGEM#' >
			<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LATITUDE_ORIGEM'  value='#arguments.LATITUDE_ORIGEM#' variable='retorno.LATITUDE_ORIGEM'  null='#iif(len(trim(arguments.LATITUDE_ORIGEM)), de('no'), de('yes'))#'>
			<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LONGITUDE_ORIGEM'  value='#arguments.LONGITUDE_ORIGEM#' variable='retorno.LONGITUDE_ORIGEM'  null='#iif(len(trim(arguments.LONGITUDE_ORIGEM)), de('no'), de('yes'))#'>
			<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MUNICIPIO_ID_ORIGEM'  value='#arguments.MUNICIPIO_ID_ORIGEM#' variable='retorno.MUNICIPIO_ID_ORIGEM'  null='#iif(len(trim(arguments.MUNICIPIO_ID_ORIGEM)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO_DESTINO'  value='#arguments.DESCRICAO_DESTINO#' >
			<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LATITUDE_DESTINO'  value='#arguments.LATITUDE_DESTINO#' variable='retorno.LATITUDE_DESTINO'  null='#iif(len(trim(arguments.LATITUDE_DESTINO)), de('no'), de('yes'))#'>
			<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LONGITUDE_DESTINO'  value='#arguments.LONGITUDE_DESTINO#' variable='retorno.LONGITUDE_DESTINO'  null='#iif(len(trim(arguments.LONGITUDE_DESTINO)), de('no'), de('yes'))#'>
			<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MUNICIPIO_ID_DESTINO'  value='#arguments.MUNICIPIO_ID_DESTINO#' variable='retorno.MUNICIPIO_ID_DESTINO'  null='#iif(len(trim(arguments.MUNICIPIO_ID_DESTINO)), de('no'), de('yes'))#'>
			<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ROTA_ID' variable='retorno.ROTA_ID'>
		</cfstoredproc>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Insere um caminho da rota
	-- guto 28/03/2006 09:35:03 - CRIADO
	--->
	<cffunction name='ins_rota_caminho' displayname='Insere um caminho da rota' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ROTA_ID' required='yes'>
		<cfargument name='TIPO_ID' required='yes'>
		<cfargument name='DESCRICAO' required='no' default="">
		<cfargument name='ROUTE_ID' required='no' default="">
		<cfargument name='MAPA_ID' required='no' default="">
		<cfstoredproc procedure='pkg_rota.prc_ins_rota_caminho' datasource='KMM.KMM.COM.BR' username='rota' password='!kr_|_04'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ROTA_ID'  value='#arguments.ROTA_ID#'  null='#iif(len(trim(arguments.ROTA_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_ID'  value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_BLOB' dbvarname='P_MAPA'  null="yes">
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROUTE_ID'  value='#arguments.ROUTE_ID#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MAPA_ID'  value='#arguments.MAPA_ID#' null='#iif(len(trim(arguments.MAPA_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CAMINHO_ID' variable='retorno.CAMINHO_ID'>
		</cfstoredproc>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Insere um ponto de passagem da rota
	-- cristofer 28/03/2006 10:26:41 - CRIADO
	--->
	<cffunction name='ins_rota_caminho_node' displayname='Insere um ponto de passagem da rota' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ROTA_ID' required='yes'>
		<cfargument name='CAMINHO_ID' required='yes'>
		<cfargument name='LATITUDE' required='yes'>
		<cfargument name='LONGITUDE' required='yes'>
		<cfargument name='DISTANCIA' required='yes'>
		<cfargument name='TEMPO' required='yes'>
		<cfargument name='NODE_ID_PAI' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='CIDADE' required='yes'>
		<cfargument name='COD_TIPO_ESTRADA' required='yes'>
		<cfargument name='DISTANCIA_CUMULATIVA' required='yes'>
		<cfargument name='PEDAGIO_ID' required='yes'>
		<cfargument name='PARADA' required='yes'>
		<cfstoredproc procedure='pkg_rota.prc_ins_rota_caminho_node' datasource='KMM.KMM.COM.BR' username='rota' password='!kr_|_04'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ROTA_ID'  value='#arguments.ROTA_ID#'  null='#iif(len(trim(arguments.ROTA_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CAMINHO_ID'  value='#arguments.CAMINHO_ID#'  null='#iif(len(trim(arguments.CAMINHO_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LATITUDE'  value='#arguments.LATITUDE#'  null='#iif(len(trim(arguments.LATITUDE)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LONGITUDE'  value='#arguments.LONGITUDE#'  null='#iif(len(trim(arguments.LONGITUDE)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DISTANCIA'  value='#arguments.DISTANCIA#'  null='#iif(len(trim(arguments.DISTANCIA)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TEMPO'  value='#arguments.TEMPO#'  null='#iif(len(trim(arguments.TEMPO)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NODE_ID_PAI'  value='#arguments.NODE_ID_PAI#'  null='#iif(len(trim(arguments.NODE_ID_PAI)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CIDADE'  value='#arguments.CIDADE#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_TIPO_ESTRADA'  value='#arguments.COD_TIPO_ESTRADA#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DISTANCIA_CUMULATIVA'  value='#arguments.DISTANCIA_CUMULATIVA#'  null='#iif(len(trim(arguments.DISTANCIA_CUMULATIVA)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PEDAGIO_ID'  value='#arguments.PEDAGIO_ID#'  null='#iif(len(trim(arguments.PEDAGIO_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PARADA'  value='#arguments.PARADA#'  null='#iif(len(trim(arguments.PARADA)), de('no'), de('yes'))#'>
			<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NODE_ID' variable='retorno.NODE_ID'>
			<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PARADA_ANTERIOR' variable='retorno.PARADA_ANTERIOR'>
		</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROP?SITO
	-- Insere um novo mapa na base de dados
	-- cristofer 03/04/2006 13:36:57 - CRIADO
	--->
	<cffunction name='ins_mapa' displayname='Insere um novo mapa na base de dados' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ROTA_ID' required='yes'>
		<cfargument name='CAMINHO_ID' required='yes'>
		<cfargument name='LATITUDE_MINIMA' required='yes'>
		<cfargument name='LONGITUDE_MINIMA' required='yes'>
		<cfargument name='LATITUDE_MAXIMA' required='yes'>
		<cfargument name='LONGITUDE_MAXIMA' required='yes'>
		<cfargument name='MAPA' required='yes'>
				<cfstoredproc procedure='pkg_rota.prc_ins_rota_mapa' datasource='KMM.KMM.COM.BR' username='rota' password='!kr_|_04'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ROTA_ID'  value='#arguments.ROTA_ID#'  null='#iif(len(trim(arguments.ROTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CAMINHO_ID'  value='#arguments.CAMINHO_ID#'  null='#iif(len(trim(arguments.CAMINHO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LATITUDE_MINIMA'  value='#arguments.LATITUDE_MINIMA#'  null='#iif(len(trim(arguments.LATITUDE_MINIMA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LONGITUDE_MINIMA'  value='#arguments.LONGITUDE_MINIMA#'  null='#iif(len(trim(arguments.LONGITUDE_MINIMA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LATITUDE_MAXIMA'  value='#arguments.LATITUDE_MAXIMA#'  null='#iif(len(trim(arguments.LATITUDE_MAXIMA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LONGITUDE_MAXIMA'  value='#arguments.LONGITUDE_MAXIMA#'  null='#iif(len(trim(arguments.LONGITUDE_MAXIMA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_BLOB' dbvarname='P_MAPA'  value='#arguments.MAPA#' null="#iif(IsBinary(arguments.mapa), de('no'), de('yes'))#">
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MAPA_ID' variable='retorno.MAPA_ID'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>	
</cfcomponent>