<!-- KM&M Componentes -->
<cfcomponent displayname="Manipulao das rotas" extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO
	-- Exclui uma rota
	-- cristofer 16/03/2006 08:55:06 - CRIADO
	--->
	<cffunction name='del_rota' displayname='Exclui uma rota' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ROTA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_rota.prc_excluir_rota' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ROTA_ID'  value='#arguments.ROTA_ID#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Rota excluida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>  
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um caminho de uma rota
	-- cristofer 16/03/2006 08:59:10 - CRIADO
	--->
	<cffunction name='del_rota_caminho' displayname='Exclui um caminho de uma rota' access='package' returntype='Struct' output='true'>;
		<cfargument name='ROTA_ID' required='yes'>
		<cfargument name='CAMINHO_ID' required='yes'>
		<cfstoredproc procedure='oper.pkg_rota.prc_excluir_caminho' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ROTA_ID'  value='#arguments.ROTA_ID#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CAMINHO_ID'  value='#arguments.CAMINHO_ID#' >
		</cfstoredproc>
		<cfreturn StructNew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere uma nova rota
	-- cristofer 16/03/2006 08:52:53 - CRIADO
	--->
	<cffunction name='ins_rota' displayname='Insere uma nova rota' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ROTA_ID' required='no' default="">
		<cfargument name='MUNICIPIO_ID_ORIGEM' required='yes'>
		<cfargument name='LATITUDE_ORIGEM' required='yes'>
		<cfargument name='LONGITUDE_ORIGEM' required='yes'>
		<cfargument name='MUNICIPIO_ID_DESTINO' required='yes'>
		<cfargument name='LATITUDE_DESTINO' required='yes'>
		<cfargument name='LONGITUDE_DESTINO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_rota.prc_insere_rota' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ROTA_ID'  value='#arguments.ROTA_ID#' variable='retorno.ROTA_ID' null="#iif(len(trim(arguments.rota_id)), de('no'), de('yes'))#" >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MUNICIPIO_ID_ORIGEM'  value='#arguments.MUNICIPIO_ID_ORIGEM#' null="#iif(len(trim(arguments.MUNICIPIO_ID_ORIGEM)), de('no'), de('yes'))#" >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LATITUDE_ORIGEM'  value='#arguments.LATITUDE_ORIGEM#' null="#iif(len(trim(arguments.LATITUDE_ORIGEM)), de('no'), de('yes'))#" >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LONGITUDE_ORIGEM'  value='#arguments.LONGITUDE_ORIGEM#' null="#iif(len(trim(arguments.LONGITUDE_ORIGEM)), de('no'), de('yes'))#" >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MUNICIPIO_ID_DESTINO'  value='#arguments.MUNICIPIO_ID_DESTINO#' null="#iif(len(trim(arguments.MUNICIPIO_ID_DESTINO)), de('no'), de('yes'))#" >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LATITUDE_DESTINO'  value='#arguments.LATITUDE_DESTINO#' null="#iif(len(trim(arguments.LATITUDE_DESTINO)), de('no'), de('yes'))#" >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LONGITUDE_DESTINO'  value='#arguments.LONGITUDE_DESTINO#' null="#iif(len(trim(arguments.LONGITUDE_DESTINO)), de('no'), de('yes'))#" >
				</cfstoredproc>
				<!--- Caminhos da rota --->
				<cfscript>
					v_caminho_id = this.ListaToArray (lista = arguments, variavel = "CAMINHO_ID_CAMINHOS");
					v_descricao_caminho = this.ListaToArray (lista = arguments, variavel = "DESCRICAO_CAMINHO_CAMINHOS");
					v_caminho_consolidado = this.ListaToArray (lista = arguments, variavel = "CAMINHO_CONSOLIDADO_CAMINHOS");
					v_media_km_hodometro = this.ListaToArray (lista = arguments, variavel = "MEDIA_KM_HODOMETRO_CAMINHOS");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_CAMINHOS, lista2 = ArrayToList(v_caminho_id, ','));
				</cfscript>
				<cfloop list="#v_excluir#" delimiters="," index="l_excluir">
					<cfscript>
						this.del_rota_caminho (rota_id    = retorno.rota_id,
										       caminho_id = l_excluir);
					</cfscript>
				</cfloop>	
				<cfloop from="1" to="#ArrayLen(v_caminho_id)#" index="count">
					<cfscript>
						if(not len(trim(v_caminho_id[count]))) {
							this.ins_rota_caminho (	rota_id  			= retorno.rota_id,
													descricao_caminho 	= v_descricao_caminho[count],
													media_km_hodometro	= v_media_km_hodometro[count],
													caminho_consolidado	= v_caminho_consolidado[count]);
						} else {
							this.ins_rota_caminho (	rota_id  			= retorno.rota_id,
													caminho_id 			= v_caminho_id[count],
													descricao_caminho 	= v_descricao_caminho[count],
													media_km_hodometro	= v_media_km_hodometro[count],
													caminho_consolidado	= v_caminho_consolidado[count]);
						}
					</cfscript>
				</cfloop>				
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Rota inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere um caminho de uma rota
	-- cristofer 16/03/2006 08:56:41 - CRIADO
	--->
	<cffunction name='ins_rota_caminho' displayname='Insere um caminho de uma rota' access='package' returntype='Struct' output='true'>;
		<cfargument name='ROTA_ID' required='yes'>
		<cfargument name='CAMINHO_ID' required='no' default=''>
		<cfargument name='DESCRICAO_CAMINHO' required='yes'>
		<cfargument name='CAMINHO_CONSOLIDADO' required='yes'>
		<cfargument name='MEDIA_KM_HODOMETRO' required='yes'>
		<cfstoredproc procedure='oper.pkg_rota.prc_insere_caminho' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ROTA_ID'  value='#arguments.ROTA_ID#' >
			<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CAMINHO_ID'  value='#arguments.CAMINHO_ID#' variable='retorno.CAMINHO_ID' null="#iif(len(trim(arguments.CAMINHO_ID)), de('no'), de('yes'))#" >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO_CAMINHO'  value='#arguments.DESCRICAO_CAMINHO#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CAMINHO_CONSOLIDADO'  value='#arguments.CAMINHO_CONSOLIDADO#' null="#iif(len(trim(arguments.CAMINHO_CONSOLIDADO)), de('no'), de('yes'))#" >
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MEDIA_KM_HODOMETRO'  value='#arguments.MEDIA_KM_HODOMETRO#' null="#iif(len(trim(arguments.MEDIA_KM_HODOMETRO)), de('no'), de('yes'))#" >
		</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera uma rota
	-- cristofer 16/03/2006 08:53:48 - CRIADO
	--->
	<cffunction name='upd_rota' displayname='Altera uma rota' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ROTA_ID' required='yes'>
		<cfargument name='MUNICIPIO_ID_ORIGEM' required='yes'>
		<cfargument name='LATITUDE_ORIGEM' required='yes'>
		<cfargument name='LONGITUDE_ORIGEM' required='yes'>
		<cfargument name='MUNICIPIO_ID_DESTINO' required='yes'>
		<cfargument name='LATITUDE_DESTINO' required='yes'>
		<cfargument name='LONGITUDE_DESTINO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_rota.prc_atualiza_rota' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ROTA_ID'  value='#arguments.ROTA_ID#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MUNICIPIO_ID_ORIGEM'  value='#arguments.MUNICIPIO_ID_ORIGEM#' null="#iif(len(trim(arguments.MUNICIPIO_ID_ORIGEM)), de('no'), de('yes'))#" >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LATITUDE_ORIGEM'  value='#arguments.LATITUDE_ORIGEM#' null="#iif(len(trim(arguments.LATITUDE_ORIGEM)), de('no'), de('yes'))#" >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LONGITUDE_ORIGEM'  value='#arguments.LONGITUDE_ORIGEM#' null="#iif(len(trim(arguments.LONGITUDE_ORIGEM)), de('no'), de('yes'))#" >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MUNICIPIO_ID_DESTINO'  value='#arguments.MUNICIPIO_ID_DESTINO#' null="#iif(len(trim(arguments.MUNICIPIO_ID_DESTINO)), de('no'), de('yes'))#" >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LATITUDE_DESTINO'  value='#arguments.LATITUDE_DESTINO#' null="#iif(len(trim(arguments.LATITUDE_DESTINO)), de('no'), de('yes'))#" >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LONGITUDE_DESTINO'  value='#arguments.LONGITUDE_DESTINO#' null="#iif(len(trim(arguments.LONGITUDE_DESTINO)), de('no'), de('yes'))#" >
				</cfstoredproc>
				<!--- Caminhos da rota --->
				<cfscript>
					retorno.rota_id = arguments.rota_id;
					v_caminho_id = this.ListaToArray (lista = arguments, variavel = "CAMINHO_ID_CAMINHOS");
					v_descricao_caminho = this.ListaToArray (lista = arguments, variavel = "DESCRICAO_CAMINHO_CAMINHOS");
					v_caminho_consolidado = this.ListaToArray (lista = arguments, variavel = "CAMINHO_CONSOLIDADO_CAMINHOS");
					v_media_km_hodometro = this.ListaToArray (lista = arguments, variavel = "MEDIA_KM_HODOMETRO_CAMINHOS");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_CAMINHOS, lista2 = ArrayToList(v_caminho_id, ','));
				</cfscript>

				<cfloop list="#v_excluir#" delimiters="," index="l_excluir">
					<cfscript>
						this.del_rota_caminho (rota_id    = retorno.rota_id,
										       caminho_id = l_excluir);
					</cfscript>
				</cfloop>	
				<cfloop from="1" to="#ArrayLen(v_caminho_id)#" index="count">
					<cfscript>
						if(not len(trim(v_caminho_id[count]))) {
							this.ins_rota_caminho (	rota_id  			= retorno.rota_id,
													descricao_caminho 	= v_descricao_caminho[count],
													media_km_hodometro	= v_media_km_hodometro[count],
													caminho_consolidado	= v_caminho_consolidado[count]);
						} else {
							this.upd_rota_caminho (	rota_id  			= retorno.rota_id,
													caminho_id 			= v_caminho_id[count],
													descricao_caminho 	= v_descricao_caminho[count],
													media_km_hodometro	= v_media_km_hodometro[count],
													caminho_consolidado	= v_caminho_consolidado[count]);
						}
					</cfscript>
				</cfloop>				
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Rota alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera um caminho de uma rota
	-- cristofer 16/03/2006 08:58:17 - CRIADO
	--->
	<cffunction name='upd_rota_caminho' displayname='Altera um caminho de uma rota' access='package' returntype='Struct' output='true'>;
		<cfargument name='ROTA_ID' required='yes'>
		<cfargument name='CAMINHO_ID' required='yes'>
		<cfargument name='DESCRICAO_CAMINHO' required='yes'>
		<cfargument name='CAMINHO_CONSOLIDADO' required='yes'>
		<cfargument name='MEDIA_KM_HODOMETRO' required='yes'>
		<cfstoredproc procedure='oper.pkg_rota.prc_atualiza_caminho' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ROTA_ID'  value='#arguments.ROTA_ID#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CAMINHO_ID'  value='#arguments.CAMINHO_ID#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO_CAMINHO'  value='#arguments.DESCRICAO_CAMINHO#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CAMINHO_CONSOLIDADO'  value='#arguments.CAMINHO_CONSOLIDADO#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MEDIA_KM_HODOMETRO'  value='#arguments.MEDIA_KM_HODOMETRO#' >
		</cfstoredproc>
		<cfreturn structNew() />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- teste de consulta
	-- cristofer 16/03/2006 08:58:17 - CRIADO
	--->
	<cffunction name='teste_maplink' displayname='Altera um caminho de uma rota' access='public' returntype='Struct' output='true'>;
		<cfobject type="java" name="iu" class="com.maplink.webservices.route.Teste2" action="create">
		<cfscript>
			teste = iu.teste();
		</cfscript>
		<cfdump var="#teste#">
		<cfdump var="#teste.getLanguage()#">
		<cfreturn structNew()>
	</cffunction>	
</cfcomponent>