<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPSITO
    -- Insere um modelo de Rastreador
    -- cristofer 23/02/2008 11:56:51 - CRIADO
    --->
    <cffunction name='ins_rastreador_modelo' displayname='Insere um modelo de Rastreador' access='remote' returntype='Struct' output='true'>
        <cfargument name='DESCRICAO' required='yes'>
        <cfargument name='DRIVER' required='yes'>
        <cfargument name='PARAMETROS_DRIVER' required='yes'>
        <cfargument name='ORDEM_INTEGRACAO' required='yes'>
        <cfargument name='MODELO_INICIO_1' required='no' default="">
        <cfargument name='MODELO_INICIO_2' required='no' default="">
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='integracao.pkg_rastreador.prc_ins_modelo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DRIVER'  value='#arguments.DRIVER#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PARAMETROS_DRIVER'  value='#arguments.PARAMETROS_DRIVER#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ORDEM_INTEGRACAO'  value='#arguments.ORDEM_INTEGRACAO#'  null='#iif(len(trim(arguments.ORDEM_INTEGRACAO)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MODELO_ID' variable='retorno.MODELO_ID' >
                </cfstoredproc>
                <cfif len(trim(arguments.modelo_inicio_1))>
                	<cfscript>
						ret = this.upd_rastreador_modelo_inicio(modelo_id = retorno.modelo_id,
																tipo_id   = 1,
																num_mensagem = arguments.modelo_inicio_1);
					</cfscript>
                    <cfif ret.erro>
                    	<cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfif>
                <cfif len(trim(arguments.modelo_inicio_2))>
                	<cfscript>
						ret = this.upd_rastreador_modelo_inicio(modelo_id = retorno.modelo_id,
																tipo_id   = 2,
																num_mensagem = arguments.modelo_inicio_2);
					</cfscript>
                    <cfif ret.erro>
                    	<cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfif>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Modelo inserido com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Altera um modelo de Rastreador
    -- cristofer 23/02/2008 11:57:55 - CRIADO
    --->
    <cffunction name='upd_rastreador_modelo' displayname='Altera um modelo de Rastreador' access='remote' returntype='Struct' output='true'>
        <cfargument name='MODELO_ID' required='yes'>
        <cfargument name='DESCRICAO' required='yes'>
        <cfargument name='DRIVER' required='yes'>
        <cfargument name='PARAMETROS_DRIVER' required='yes'>
        <cfargument name='ORDEM_INTEGRACAO' required='yes'>
        <cfargument name='MODELO_INICIO_1' required='no' default="">
        <cfargument name='MODELO_INICIO_2' required='no' default="">
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='integracao.pkg_rastreador.prc_alt_modelo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MODELO_ID'  value='#arguments.MODELO_ID#'  null='#iif(len(trim(arguments.MODELO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DRIVER'  value='#arguments.DRIVER#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PARAMETROS_DRIVER'  value='#arguments.PARAMETROS_DRIVER#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ORDEM_INTEGRACAO'  value='#arguments.ORDEM_INTEGRACAO#'  null='#iif(len(trim(arguments.ORDEM_INTEGRACAO)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfif len(trim(arguments.modelo_inicio_1))>
                	<cfscript>
						ret = this.upd_rastreador_modelo_inicio(modelo_id = arguments.modelo_id,
																tipo_id   = 1,
																num_mensagem = arguments.modelo_inicio_1);
					</cfscript>
                    <cfif ret.erro>
                    	<cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfif>
                <cfif len(trim(arguments.modelo_inicio_2))>
                	<cfscript>
						ret = this.upd_rastreador_modelo_inicio(modelo_id = arguments.modelo_id,
																tipo_id   = 2,
																num_mensagem = arguments.modelo_inicio_2);
					</cfscript>
                    <cfif ret.erro>
                    	<cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfif>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Modelo alterado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Exclui um modelo de Rastreador
    -- cristofer 23/02/2008 11:58:30 - CRIADO
    --->
    <cffunction name='del_rastreador_modelo' displayname='Exclui um modelo de Rastreador' access='remote' returntype='Struct' output='true'>
        <cfargument name='MODELO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='integracao.pkg_rastreador.prc_del_modelo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MODELO_ID'  value='#arguments.MODELO_ID#'  null='#iif(len(trim(arguments.MODELO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Modelo excluido com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!--- 
    -- PROPSITO
    -- Altera o inicio de integrao para o tipo de mensagem e modelo de rastreador
    -- cristofer 23/02/2008 11:59:51 - CRIADO
    --->
    <cffunction name='upd_rastreador_modelo_inicio' displayname='Altera o inicio de integrao para o tipo de mensagem e modelo de rastreador' access='remote' returntype='Struct' output='true'>
        <cfargument name='MODELO_ID' required='yes'>
        <cfargument name='TIPO_ID' required='yes'>
        <cfargument name='NUM_MENSAGEM' required='yes'>
        <cftry>
                <cfstoredproc procedure='integracao.pkg_rastreador.prc_alt_modelo_inicio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MODELO_ID'  value='#arguments.MODELO_ID#'  null='#iif(len(trim(arguments.MODELO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_ID'  value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_MENSAGEM'  value='#arguments.NUM_MENSAGEM#'  null='#iif(len(trim(arguments.NUM_MENSAGEM)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Modelo alterado com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Altera o Job de integracao
	-- cristofer 23/02/2008 15:02:49 - CRIADO
	--->
	<cffunction name='upd_integracao_job' displayname='Altera o Job de integracao' access='remote' returntype='Struct' output='true'>
		<cfargument name='INTERVALO_MINUTOS' required='yes'>
		<cfargument name='BROKEN' required='yes'>
		<cfargument name='NEXT_DATE' required='no' default="">
		<cfargument name='NEXT_DATE_ATUAL' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='integracao.pkg_rastreador.prc_alt_integracao_job' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_INTERVALO_MINUTOS'  value='#arguments.INTERVALO_MINUTOS#'  null='#iif(len(trim(arguments.INTERVALO_MINUTOS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_BROKEN'  value='#arguments.BROKEN#'  null='#iif(len(trim(arguments.BROKEN)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NEXT_DATE'  value='#arguments.NEXT_DATE#' null="#iif(arguments.next_date_atual eq 1,de('yes'),de('no'))#" >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_JOB' variable='retorno.JOB' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Job configurado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
    -- PROPSITO
    -- Reintegra uma mensagem desde a primeira etapa
    -- cristofer 25/02/2008 11:58:30 - CRIADO
    --->
    <cffunction name='reintegra_mensagem' displayname='' access='remote' returntype='Struct' output='true'>
        <cfargument name='MENSAGEM_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='integracao.pkg_mensagem.prc_reintegra_mensagem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MODELO_ID'  value='#arguments.MENSAGEM_ID#'  null='#iif(len(trim(arguments.MENSAGEM_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Mensagem reintegrada com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

    <!--- 
    -- PROPSITO
    -- Confere uma mensagem
    -- cristofer 25/02/2008 11:58:30 - CRIADO
    --->
    <cffunction name='conferir_mensagem' displayname='' access='remote' returntype='Struct' output='true'>
        <cfargument name='MENSAGEM_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='integracao.pkg_mensagem.prc_conferir_mensagem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MODELO_ID'  value='#arguments.MENSAGEM_ID#'  null='#iif(len(trim(arguments.MENSAGEM_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Mensagem conferida com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
    
    <!--- 
	-- PROPSITO
	-- Envia um comando para teste
	-- cristofer 16/09/2008 12:01:47 - CRIADO
	--->
	<cffunction name='envia_comando_teste' displayname='Envia um comando para teste' access='remote' returntype='Struct' output='true'>
		<cfargument name='MCT' required='yes'>
		<cfargument name='NUM_MENSAGEM' required='yes'>
		<cfargument name='SUBTYPE' required='yes'>
		<cfargument name='BYNARY_DATATYPE' required='yes'>
		<cfargument name='NUM_COMANDO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='integracao.prc_envia_comando_teste' datasource='DELP02.DELPOZO.COM.BR' username='integracao' password='>>as-20'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MCT'  value='#arguments.MCT#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUM_MENSAGEM'  value='#arguments.NUM_MENSAGEM#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SUBTYPE'  value='#arguments.SUBTYPE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_BYNARY_DATATYPE'  value='#arguments.BYNARY_DATATYPE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUM_COMANDO'  value='#arguments.NUM_COMANDO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Comando enviado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
</cfcomponent>