<cfcomponent displayname="Qualidade" extends="_transportes.funcoes.cfc_init">
	
	<!--- 
    -- PROPSITO
    -- Inserir Ocorrncia para um funcionrio 
    -- RAFAEL 06/10/2009 15:44:49 - CRIADO
    --->
    <cffunction name='ins_ocorrencia' displayname='Inserir Ocorrncia para um funcionrio ' access='remote' returntype='Struct' output='true'>
        <cfargument name='COD_PESSOA' required='yes'>
        <cfargument name='OCORRENCIA_TIPO_ID' required='yes'>
        <cfargument name='DATA_OCORRENCIA' required='yes'>
        <cfargument name='OBSERVACAO' required='yes'>
        <cfargument name='OCORRENCIA_ID' required='yes'>
        <cfargument name='NUM_ROMANEIO' required='no' default="">
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_ocorrencia.prc_ins_ocorrencia' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OCORRENCIA_TIPO_ID'  value='#arguments.OCORRENCIA_TIPO_ID#'  null='#iif(len(trim(arguments.OCORRENCIA_TIPO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_OCORRENCIA'  value='#arguments.DATA_OCORRENCIA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
                    <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OCORRENCIA_ID'  value='#arguments.OCORRENCIA_ID#' variable='retorno.OCORRENCIA_ID'  null='#iif(len(trim(arguments.OCORRENCIA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_NUM_ROMANEIO' value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Ocorrncia inserida com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Alterar Ocorrncia para um funcionrio 
	-- RAFAEL 06/10/2009 15:46:51 - CRIADO
	--->
	<cffunction name='upd_ocorrencia' displayname='Alterar Ocorrncia para um funcionrio ' access='remote' returntype='Struct' output='true'>
		<cfargument name='OCORRENCIA_ID' required='yes'>
		<cfargument name='COD_PESSOA' required='yes'>
		<cfargument name='OCORRENCIA_TIPO_ID' required='yes'>
		<cfargument name='DATA_OCORRENCIA' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
        <cfargument name='NUM_ROMANEIO' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_ocorrencia.prc_alt_ocorrencia' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OCORRENCIA_ID'  value='#arguments.OCORRENCIA_ID#'  null='#iif(len(trim(arguments.OCORRENCIA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OCORRENCIA_TIPO_ID'  value='#arguments.OCORRENCIA_TIPO_ID#'  null='#iif(len(trim(arguments.OCORRENCIA_TIPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_OCORRENCIA'  value='#arguments.DATA_OCORRENCIA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_NUM_ROMANEIO' value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Ocorrncia alterada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Excluir Ocorrncia para um funcionrio 
	-- RAFAEL 06/10/2009 15:47:47 - CRIADO
	--->
	<cffunction name='del_ocorrencia' displayname='Excluir Ocorrncia para um funcionrio ' access='remote' returntype='Struct' output='true'>
		<cfargument name='OCORRENCIA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_ocorrencia.prc_del_ocorrencia' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OCORRENCIA_ID'  value='#arguments.OCORRENCIA_ID#'  null='#iif(len(trim(arguments.OCORRENCIA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Ocorrncia excluda com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
</cfcomponent>	