<cfcomponent  displayname="KM&M Gerenciador de Arquivos"
>
<!---SD--->
<cfparam name="session.dsn_menu" default="KMM.KMM.COM.BR">
<cffunction name="ins_tipo_objeto" displayname="Insere um tipo de objeto" access="remote" returntype="Struct" output="true">
	<cfargument name="descricao" required="yes">
	<cfargument name="tag" required="yes">
	<cftry>
		<cftransaction action="begin">
			<cfstoredproc procedure="programacao.pkg_programacao.prc_ins_tipo_objeto" datasource="#session.dsn_menu#" username="programacao" password="!kp_|_11">
				<cfprocparam dbvarname="p_descricao" 	type="in" value="#arguments.descricao#"	cfsqltype="cf_sql_varchar">
				<cfprocparam dbvarname="p_tag" 			type="in" value="#arguments.tag#" 		cfsqltype="cf_sql_varchar">
				<cfprocparam dbvarname="p_tipo_id" 		type="out" variable="retorno.tipo_id" 	cfsqltype="cf_sql_integer">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat("Tipo de objeto inserido com sucesso!")>
		</cftransaction>
		<cfcatch>
			<cftransaction action="rollback"/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />		
</cffunction>

<cffunction name="upd_tipo_objeto" displayname="Altera um tipo de objeto" access="remote" returntype="Struct" output="true">
	<cfargument name="tipo_id"		required="yes">
	<cfargument name="descricao" 	required="yes">
	<cfargument name="tag" 			required="yes">
	<cftry>
		<cftransaction action="begin">
			<cfstoredproc procedure="programacao.pkg_programacao.prc_alt_tipo_objeto" datasource="#session.dsn_menu#" username="programacao" password="!kp_|_11">
				<cfprocparam dbvarname="p_tipo_id" 		type="in" value="#arguments.tipo_id#" 	cfsqltype="cf_sql_integer">
				<cfprocparam dbvarname="p_descricao" 	type="in" value="#arguments.descricao#"	cfsqltype="cf_sql_varchar">
				<cfprocparam dbvarname="p_tag" 			type="in" value="#arguments.tag#" 		cfsqltype="cf_sql_varchar">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat("Tipo de objeto alterado com sucesso!")>
		</cftransaction>
		<cfcatch>
			<cftransaction action="rollback"/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />		
</cffunction>

<cffunction name="del_tipo_objeto" displayname="Exclui um tipo de objeto" access="remote" returntype="Struct" output="true">
	<cfargument name="tipo_id"		required="yes">
	<cftry>
		<cftransaction action="begin">
			<cfstoredproc procedure="programacao.pkg_programacao.prc_del_tipo_objeto" datasource="#session.dsn_menu#" username="programacao" password="!kp_|_11">
				<cfprocparam dbvarname="p_tipo_id" 		type="in" value="#arguments.tipo_id#" 	cfsqltype="cf_sql_integer">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat("Tipo de objeto excluido com sucesso!")>
		</cftransaction>
		<cfcatch>
			<cftransaction action="rollback"/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />		
</cffunction>

<cffunction name="ins_categoria_objeto" displayname="Exclui um tipo de objeto" access="remote" returntype="Struct" output="true">
	<cfargument name="tipo_id"		required="yes">
	<cfargument name="descricao"		required="yes">
	<cfargument name="categoria_pai"	required="yes">
	<cftry>
		<cftransaction action="begin">
			<cfstoredproc procedure="programacao.pkg_programacao.prc_ins_categoria_objeto" datasource="#session.dsn_menu#" username="programacao" password="!kp_|_11">
				<cfprocparam dbvarname="p_tipo_id" 		type="in" value="#arguments.tipo_id#" 	cfsqltype="cf_sql_integer">
				<cfprocparam dbvarname="p_descricao" 		type="in" value="#arguments.descricao#" 	cfsqltype="cf_sql_varchar">
				<cfprocparam dbvarname="p_categoria_pai"	type="in" value="#arguments.categoria_pai#"	cfsqltype="cf_sql_integer" null="#iif(len(trim(arguments.categoria_pai)), de('no'), de('yes'))#">
				<cfprocparam dbvarname="p_categoria_id"		type="out" variable="retorno.categoria_id" 	cfsqltype="cf_sql_integer">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat("Categoria de objeto inserida com sucesso!")>
		</cftransaction>
		<cfcatch>
			<cftransaction action="rollback"/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />		
</cffunction>
<cffunction name="upd_categoria_objeto" displayname="Exclui um tipo de objeto" access="remote" returntype="Struct" output="true">
	<cfargument name="tipo_id"		required="yes">
	<cfargument name="categoria_id"		required="yes">
	<cfargument name="descricao"		required="yes">
	<cfargument name="categoria_pai"	required="yes">
	<cftry>
		<cftransaction action="begin">
			<cfstoredproc procedure="programacao.pkg_programacao.prc_alt_categoria_objeto" datasource="#session.dsn_menu#" username="programacao" password="!kp_|_11">
				<cfprocparam dbvarname="p_categoria_id"		type="in" value="#arguments.categoria_id#" 	cfsqltype="cf_sql_integer">
				<cfprocparam dbvarname="p_tipo_id" 		type="in" value="#arguments.tipo_id#" 	cfsqltype="cf_sql_integer">
				<cfprocparam dbvarname="p_descricao" 		type="in" value="#arguments.descricao#" 	cfsqltype="cf_sql_varchar">
				<cfprocparam dbvarname="p_categoria_pai"	type="in" value="#arguments.categoria_pai#"	cfsqltype="cf_sql_integer" null="#iif(len(trim(arguments.categoria_pai)), de('no'), de('yes'))#">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat("Categoria de objeto alterada com sucesso!")>
		</cftransaction>
		<cfcatch>
			<cftransaction action="rollback"/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />		
</cffunction>
<cffunction name="del_categoria_objeto" displayname="Exclui um tipo de objeto" access="remote" returntype="Struct" output="true">
	<cfargument name="categoria_id"		required="yes">
	<cftry>
		<cftransaction action="begin">
			<cfstoredproc procedure="programacao.pkg_programacao.prc_del_categoria_objeto" datasource="#session.dsn_menu#" username="programacao" password="!kp_|_11">
				<cfprocparam dbvarname="p_categoria_id"		type="in" value="#arguments.categoria_id#" 	cfsqltype="cf_sql_integer">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat("Categoria de objeto excluida com sucesso!")>
		</cftransaction>
		<cfcatch>
			<cftransaction action="rollback"/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />		
</cffunction>

<cffunction name="ins_objeto" displayname="Exclui um tipo de objeto" access="remote" returntype="Struct" output="true">
	<cfargument name="tipo_id"		required="yes">
	<cfargument name="categoria_id"	required="yes">
	<cfargument name="nome" required="yes">
	<cfargument name="nome_implementacao" required="yes">
	<cfargument name="proposito" required="yes">
	<cfargument name="corpo" required="yes">
	<cftry>
		<cftransaction action="begin">
			<cfstoredproc procedure="programacao.pkg_programacao.prc_ins_objeto" datasource="KMM.KMM.COM.BR" username="programacao" password="!kp_|_11">
				<cfprocparam dbvarname="p_tipo_id" 		type="in" value="#arguments.tipo_id#" 	cfsqltype="cf_sql_integer">
				<cfprocparam dbvarname="p_categoria_id"	type="in" value="#arguments.categoria_id#" 	cfsqltype="cf_sql_integer">
				<cfprocparam dbvarname="p_nome" 		type="in" value="#arguments.nome#" 	cfsqltype="cf_sql_varchar">
				<cfprocparam dbvarname="p_nome_implementacao" 		type="in" value="#arguments.nome_implementacao#" 	cfsqltype="cf_sql_varchar">
				<cfprocparam dbvarname="p_proposito" 	type="in" value="#arguments.proposito#" 	cfsqltype="cf_sql_varchar">
				<cfprocparam dbvarname="p_corpo" 		type="in" value="#arguments.corpo#" 	cfsqltype="cf_sql_varchar">
				<cfprocparam dbvarname="p_objeto_id"	type="out" variable="retorno.objeto_id" 	cfsqltype="cf_sql_integer">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat("Objeto inserido com sucesso!")>
		</cftransaction>
		<cfcatch>
			<cftransaction action="rollback"/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />		
</cffunction>
<cffunction name="upd_objeto" displayname="Exclui um tipo de objeto" access="remote" returntype="Struct" output="true">
	<cfargument name="tipo_id"		required="yes">
	<cfargument name="objeto_id"		required="yes">
	<cfargument name="categoria_id"	required="yes">
	<cfargument name="nome" required="yes">
	<cfargument name="nome_implementacao" required="yes">
	<cfargument name="proposito" required="yes">
	<cfargument name="corpo" required="yes">
	<cftry>
		<cftransaction action="begin">
			<cfstoredproc procedure="programacao.pkg_programacao.prc_alt_objeto" datasource="KMM.KMM.COM.BR" username="programacao" password="!kp_|_11">
				<cfprocparam dbvarname="p_tipo_id" 		type="in" value="#arguments.tipo_id#" 	cfsqltype="cf_sql_integer">
				<cfprocparam dbvarname="p_categoria_id"	type="in" value="#arguments.categoria_id#" 	cfsqltype="cf_sql_integer">
				<cfprocparam dbvarname="p_objeto_id"	type="in" value="#arguments.objeto_id#" 	cfsqltype="cf_sql_integer">
				<cfprocparam dbvarname="p_nome" 		type="in" value="#arguments.nome#" 	cfsqltype="cf_sql_varchar">
				<cfprocparam dbvarname="p_nome_implementacao" 		type="in" value="#arguments.nome_implementacao#" 	cfsqltype="cf_sql_varchar">
				<cfprocparam dbvarname="p_proposito" 	type="in" value="#arguments.proposito#" 	cfsqltype="cf_sql_varchar">
				<cfprocparam dbvarname="p_corpo" 		type="in" value="#arguments.corpo#" 	cfsqltype="cf_sql_varchar">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat("Objeto alterado com sucesso!")>
		</cftransaction>
		<cfcatch>
			<cftransaction action="rollback"/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />		
</cffunction>

<cffunction name="del_objeto" displayname="Exclui um tipo de objeto" access="remote" returntype="Struct" output="true">
	<cfargument name="objeto_id"		required="yes">
	<cftry>
		<cftransaction action="begin">
			<cfstoredproc procedure="programacao.pkg_programacao.prc_del_objeto" datasource="KMM.KMM.COM.BR" username="programacao" password="!kp_|_11">
				<cfprocparam dbvarname="p_objeto_id"	type="in" value="#arguments.objeto_id#" 	cfsqltype="cf_sql_integer">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat("Objeto excluido com sucesso!")>
		</cftransaction>
		<cfcatch>
			<cftransaction action="rollback"/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />		
</cffunction>

<cffunction name="ins_linguagem" displayname="Exclui um tipo de objeto" access="remote" returntype="Struct" output="true">
	<cfargument name="nome" required="yes">
	<cfargument name="sigla" required="yes">
	<cftry>
		<cftransaction action="begin">
			<cfstoredproc procedure="programacao.pkg_programacao.prc_ins_linguagem" datasource="#session.dsn_menu#" username="programacao" password="!kp_|_11">
				<cfprocparam dbvarname="p_nome" 		type="in" value="#arguments.nome#" 	cfsqltype="cf_sql_varchar">
				<cfprocparam dbvarname="p_sigla" 		type="in" value="#arguments.sigla#" 	cfsqltype="cf_sql_varchar">
				<cfprocparam dbvarname="p_linguagem_id"	type="out" variable="retorno.linguagem_id" 	cfsqltype="cf_sql_integer">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat("Linguagem inserida com sucesso!")>
		</cftransaction>
		<cfcatch>
			<cftransaction action="rollback"/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />		
</cffunction>

<cffunction name="upd_linguagem" displayname="Exclui um tipo de objeto" access="remote" returntype="Struct" output="true">
	<cfargument name="linguagem_id" required="yes">
	<cfargument name="nome" required="yes">
	<cfargument name="sigla" required="yes">
	<cftry>
		<cftransaction action="begin">
			<cfstoredproc procedure="programacao.pkg_programacao.prc_alt_linguagem" datasource="#session.dsn_menu#" username="programacao" password="!kp_|_11">
				<cfprocparam dbvarname="p_linguagem_id"	type="in" value="#arguments.linguagem_id#" 	cfsqltype="cf_sql_integer">
				<cfprocparam dbvarname="p_nome" 		type="in" value="#arguments.nome#" 	cfsqltype="cf_sql_varchar">
				<cfprocparam dbvarname="p_sigla" 		type="in" value="#arguments.sigla#" 	cfsqltype="cf_sql_varchar">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat("Linguagem alterada com sucesso!")>
		</cftransaction>
		<cfcatch>
			<cftransaction action="rollback"/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />		
</cffunction>

<cffunction name="del_linguagem" displayname="Exclui um tipo de objeto" access="remote" returntype="Struct" output="true">
	<cfargument name="linguagem_id" required="yes">
	<cftry>
		<cftransaction action="begin">
			<cfstoredproc procedure="programacao.pkg_programacao.prc_del_linguagem" datasource="#session.dsn_menu#" username="programacao" password="!kp_|_11">
				<cfprocparam dbvarname="p_linguagem_id"	type="in" value="#arguments.linguagem_id#" 	cfsqltype="cf_sql_integer">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat("Linguagem excluida com sucesso!")>
		</cftransaction>
		<cfcatch>
			<cftransaction action="rollback"/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />		
</cffunction>

<cffunction name="ins_linguagem_termo" displayname="Exclui um tipo de objeto" access="remote" returntype="Struct" output="false">
	<cfargument name="termo_cod" required="yes">
	<cfargument name="traducao" required="yes">
	<cftry>
		<cftransaction action="begin">
			<cfstoredproc procedure="programacao.pkg_programacao.prc_ins_linguagem_termo" datasource="#session.dsn_menu#" username="programacao" password="!kp_|_11">
				<cfprocparam dbvarname="p_termo_cod" 		type="in" value="#arguments.termo_cod#" 	cfsqltype="cf_sql_varchar">
				<cfprocparam dbvarname="p_traducao" 		type="in" value="#arguments.traducao#" 	cfsqltype="cf_sql_varchar">
				<cfprocparam dbvarname="p_termo_id"		type="out" variable="retorno.termo_id" 	cfsqltype="cf_sql_integer">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat("Termo inserida com sucesso!")>
		</cftransaction>
		<cfcatch>
			<cftransaction action="rollback"/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />		
</cffunction>


<cffunction name="ins_site_arquivo" displayname="Insere um arquivo no sincronizador" access="remote" returntype="Struct" output="true">
	<cfargument name="path" required="yes">
	<cfargument name="atualizacao_id" required="yes">
	<cftry>
			<cfscript>
                conn = CreateObject("component", "_transportes.funcoes.cfc_file");
                v_dir = ListDeleteAt(arguments.path,ListLen(arguments.path,'/'),'/');
				v_file = ListLast(arguments.path,'/');
            </cfscript>
            <cffile action="readbinary"
                    file="#arguments.path#"
                    variable="vArquivoBIN">	
            <cfscript>
				ret = this.gera_arquivo_versao(	diretorio 		= v_dir,
												nome			= v_file,
												conteudo 		= vArquivoBIN,
												assinatura 		= conn.md5_file(file = arguments.path),
												atualizacao_id	= arguments.atualizacao_id);
			</cfscript>	
            <cfif ret.erro>
            	<cfthrow object="#ret.mensagem#">
            </cfif>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat("Arquivo inserido com sucesso!")>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />		
</cffunction>

<cffunction name="del_site_arquivo" displayname="Exclui um arquivo no sincronizador" access="remote" returntype="Struct" output="true">
	<cfargument name="path" required="yes">
	<cfargument name="site" required="yes">
	<cftry>
		<cfscript>
			v_dir = Left(arguments.path, Len(arguments.path)-Len(ListLast(arguments.path, '/'))-1);
		</cfscript>
		<cfstoredproc procedure="site.pkg_site.prc_del_arquivo_path" datasource="KMM.KMM.COM.BR" username="#session.usuario#" password="#session.senha#">
			<cfprocparam dbvarname="p_site_id" type="in" value="#arguments.site#" cfsqltype="cf_sql_integer" />
			<cfprocparam dbvarname="p_diretorio" type="in" value="#v_dir#" cfsqltype="cf_sql_varchar" />
			<cfprocparam dbvarname="p_url" type="in" value="#ListLast(arguments.path, '/')#" cfsqltype="cf_sql_varchar" />
		</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat("Arquivo excluido com sucesso!")>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />		
</cffunction>

<cffunction name="gerar_arquivo" displayname="Gera um arquivo do banco de dados no servidor atual" access="remote" returntype="Struct" output="true">
	<cfargument name="path" required="yes">
	<cftry>
			<cfscript>
				conn = CreateObject('component', "_transportes.consulta.cfc_programacao");
				qrArquivo = conn.getArquivosBanco(	conteudo = 1,
													arquivo = arguments.path);
			</cfscript>
			<cfscript>
				this.cria_diretorio_arquivo(diretorio = Replace(path, '/var/www/html/sincronizador/', expandPath('/')));
			</cfscript>
			<cffile action="write" 
					file="#Replace(path, '/var/www/html/sincronizador/', expandPath('/'))#" 
					output="#qrArquivo.conteudo#" 
					nameconflict="overwrite" 
					mode="757"
					>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat("Arquivo gerado com sucesso!")>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />			
</cffunction>

<cffunction name="cria_diretorio_arquivo" displayname="Gera a arvore de diretorios do arquivo, caso nao exista" access="remote" returntype="boolean" output="true">
	<cfargument name="diretorio" required="yes">
	<cfargument name="arquivo" required="no" default="1">
	<cfset v_dir_ant = Left(arguments.diretorio, Len(arguments.diretorio)-1-Len(ListLast(arguments.diretorio, '/')))>
	<cfif arguments.arquivo eq 1 or (not DirectoryExists(arguments.diretorio))>
		<cfscript>
			this.cria_diretorio_arquivo(diretorio = v_dir_ant, arquivo = 0);
		</cfscript>
		<cfif arguments.arquivo neq 1>
			<cfif not DirectoryExists(arguments.diretorio)>
				<cfdirectory action="create" directory="#arguments.diretorio#" mode="757" >
			</cfif>
		</cfif>
	</cfif>
	<cfreturn true>
</cffunction>

<cffunction name="excluir_arquivo" displayname="Gera um arquivo do banco de dados no servidor atual" access="remote" returntype="Struct" output="true">
	<cfargument name="path" required="yes">
	<cftry>
			<cffile action="delete" 
					file="#Replace(path, '/var/www/html/sincronizador/', expandPath('/'))#" >
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat("Arquivo excluido com sucesso!")>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />			
</cffunction>



<cffunction name="gera_procedure" displayname="Tarefas" access="remote" returntype="struct" output="true">	  
	<cfargument name="nome_procedimento" required="yes">
	<cfargument name="nome_funcao" required="yes">
	<cfargument name="proposito" required="yes">
	<cfargument name="mensagem_ok" required="yes">
	<cfargument name="interna" required="no" default="0">
	<cfargument name="description" required="yes">
	<cfset v_saida = false>
	<cfscript>
		arguments.description = replace(trim(arguments.description), "-- ", "", "ALL")&" ";
		linhas = ListToArray(arguments.description, chr(10));
	    vars.nome = arguments.nome_procedimento;
	    vars.mensagem_ok = arguments.mensagem_ok;
	</cfscript>	
	<cfset access = iif(arguments.interna eq 1, de('package'), de('remote'))>
<!--- Proposito e inicio da Funo --->
		<cfset retorno.corpo = chr(60)&"!--- 
-- PROPSITO
-- #arguments.proposito#
-- #session.usuario# #DateFormat(now(), 'DD/MM/YYYY')# #TimeFormat(now(), 'HH:MM:SS')# - CRIADO
---"&chr(62)&"
"&chr(60)&"cffunction name='#trim(arguments.nome_funcao)#' displayname='#arguments.proposito#' access='remote' returntype='Struct' output='true'"&chr(62)&"
">
<!--- Lista de argumentos --->
<cfloop from="1" to="#ArrayLen(linhas)#" index="v_index"><cfif Find("IN", ListGetAt(linhas[v_index], 3, ' '))>	
	<cfset retorno.corpo = retorno.corpo&"	"&chr(60)&"cfargument name='#ListGetAt(Mid(linhas[v_index], 3, 200), 1, ' ')#' required='yes'"&chr(62)&"
">
</cfif></cfloop>
<!--- Declaracao dos blocos try e transaction, quando necessario --->
<cfif arguments.interna eq 0>
<cfset retorno.corpo = retorno.corpo&"	"&chr(60)&"cftry"&chr(62)&"
		"&chr(60)&"cftransaction action='begin'"&chr(62)&"
">
</cfif>
<!--- abertura do procedimento --->
<cfset retorno.corpo = retorno.corpo&"			"&chr(60)&"cfstoredproc procedure='#vars.nome#' datasource='##session.dsn##' username='##session.usuario##' password='##session.senha##'"&chr(62)&"
">
<!--- Lista de Parametros do procedimento --->
<cfloop from="1" to="#ArrayLen(linhas)#" index="v_index">
<!--- Busca o tipo e direcao do parametro --->
<cfscript>
	linhas[v_index] = replace(linhas[v_index], " IN OUT ", " INOUT ");
	if(Find("CHAR", ListGetAt(UCase(linhas[v_index]), 2, ' '))) {
		tipo = "cf_sql_varchar";
	} else if (Find("DATE", ListGetAt(UCase(linhas[v_index]), 2, ' '))) {
		tipo = "cf_sql_varchar";
	} else if (Find("NUMBER", ListGetAt(UCase(linhas[v_index]), 2, ' '))) {
		tipo = "cf_sql_numeric' scale='5";
	} else if (Find("CLOB", ListGetAt(UCase(linhas[v_index]), 2, ' '))) {
		tipo = "cf_sql_longvarchar";
	} else if (Find("BLOB", ListGetAt(UCase(linhas[v_index]), 2, ' '))) {
		tipo = "cf_sql_blob";
	} else {
		tipo = "cf_sql_integer";
	}
	direcao = LCase(Replace(ListGetAt(linhas[v_index], 3, ' '), ' ', '', "ALL"));
</cfscript>
<!--- Insere o Parametro --->
<cfset retorno.corpo = retorno.corpo&"				"&chr(60)&"cfprocparam type='#UCase(direcao)#' cfsqltype='#UCase(tipo)#' dbvarname='#UCase(ListGetAt(linhas[v_index], 1, ' '))#' ">
<!--- Caso seja de entrada, seta o value --->
<cfif find("in", direcao)>
<cfset retorno.corpo = retorno.corpo&" value='##arguments.#ListGetAt(Mid(linhas[v_index], 3, 200), 1, ' ')###' ">
</cfif> 
<!--- Caso seja de saida, seta o variable --->
<cfif find("out", direcao)>
<cfset retorno.corpo = retorno.corpo&"variable='retorno.#ListGetAt(Mid(linhas[v_index], 3, 200), 1, ' ')#' ">
<cfset v_saida = true>
</cfif> 
<!--- Caso seja numerico, seta o null --->
<cfif (tipo eq "cf_sql_integer" or tipo eq "cf_sql_numeric' scale='5") and  find("in", direcao) >
<cfset retorno.corpo = retorno.corpo&" null='##iif(len(trim(arguments.#ListGetAt(Mid(linhas[v_index], 3, 200), 1, ' ')#)), de('no'), de('yes'))##'">
</cfif> 
<cfset retorno.corpo = retorno.corpo&""&chr(62)&"
">
</cfloop>
<!--- Fecha o corpo de procedimento --->
<cfset retorno.corpo = retorno.corpo&"			"&chr(60)&"/cfstoredproc"&chr(62)&"
">
<!--- Fecha os Blocos try e transaction e declara o catch --->
<cfif arguments.interna eq 0>
<cfset retorno.corpo = retorno.corpo&"			"&chr(60)&"cfset retorno.erro = false"&chr(62)&"
			"&chr(60)&"cfset retorno.mensagem = JSStringFormat('#vars.mensagem_ok#')"&chr(62)&"
		"&chr(60)&"/cftransaction"&chr(62)&"
		"&chr(60)&"cfcatch"&chr(62)&"
			"&chr(60)&"cftransaction action='rollback'/"&chr(62)&"
			"&chr(60)&"cfset retorno.erro = true"&chr(62)&"
			"&chr(60)&"cfset retorno.mensagem = cfcatch"&chr(62)&"
			"&chr(60)&"cfset request.erro = cfcatch"&chr(62)&"
		"&chr(60)&"/cfcatch"&chr(62)&"
	"&chr(60)&"/cftry"&chr(62)&"
">
</cfif>
<!--- Finaliza a funo --->
<cfif (arguments.interna eq 1 and v_saida) or arguments.interna eq 0>
<cfset retorno.corpo = retorno.corpo&"	"&chr(60)&"cfreturn retorno /"&chr(62)&"
"&chr(60)&"/cffunction"&chr(62)&"">
<cfelse>
<cfset retorno.corpo = retorno.corpo&"	"&chr(60)&"cfreturn structnew() /"&chr(62)&"
"&chr(60)&"/cffunction"&chr(62)&"">
</cfif>
	<cfreturn retorno />
</cffunction>

<cffunction name="restaurar_versao" displayname="Restaura uma verso anterior para o sincronizador" access="remote" returntype="Struct" output="true">
	<cfargument name="url" required="yes">
	<cfargument name="diretorio" required="yes">
	<cfargument name="versao" required="yes">
	<cfargument name="raiz" required="no" default="/var/www/html/sincronizador/">
	<cftry>
			<cfscript>
				arguments.path = replace(diretorio&'/'&url,'//','/','all');
				conn = CreateObject('component', "_transportes.consulta.cfc_programacao");
				qrArquivo = conn.get_site_arquivos_log(	url = arguments.url,
														diretorio = arguments.diretorio,
														versao = arguments.versao,
														com_conteudo = 1);													
			</cfscript>
            <cfif qrArquivo.recordcount eq 1>
				<cfscript>
                    this.cria_diretorio_arquivo(diretorio = Replace(arguments.path, '/var/www/html/sincronizador/', arguments.raiz));
                </cfscript>
                <cfif fileExists(Replace(arguments.path, '/var/www/html/sincronizador/', arguments.raiz)&'.LCK')>
                	<cffile action="read"
        		            file="#Replace(arguments.path, '/var/www/html/sincronizador/', arguments.raiz)&'.LCK'#"
					   	    variable="vLock"> 
                    <cfthrow detail="O arquivo esta reservado e no pode ser sobreescrito. Usuario: #ListGetAt(vLock,1,'|')# (#ListGetAt(vLock,2,'|')#)">
                </cfif>
                <cfhttp url="http://sincronizador.kmm.com.br/KMM/chmod.php?TYPE=-p&ARQUIVO=#Replace(arguments.path, '/var/www/html/sincronizador/', arguments.raiz)#" method="get"></cfhttp>
                <cffile action="write" 
                        file="#Replace(arguments.path, '/var/www/html/sincronizador/', arguments.raiz)#" 
                        output="#qrArquivo.conteudo#" 
                        nameconflict="overwrite" 
                        mode="646"
                        >
                <cfhttp url="http://sincronizador.kmm.com.br/KMM/chmod.php?TYPE=-u&ARQUIVO=#Replace(arguments.path, '/var/www/html/sincronizador/', arguments.raiz)#" method="get"></cfhttp>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat("Arquivo restaurado com sucesso!")>
            <cfelse>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat("No foi possvel restaurar o arquivo: A verso no foi encontrada!")>
            </cfif>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />			
</cffunction>

<cffunction name="del_arquivo" displayname="Restaura uma verso anterior para o sincronizador" access="remote" returntype="Struct" output="true">
	<cfargument name="url" required="yes">
	<cfargument name="diretorio" required="yes">
	<cfargument name="raiz" required="no" default="/var/www/html/sincronizador/">
	<cftry>
    	<cftransaction action="begin">
			<cfscript>
				arguments.path = replace(diretorio&'/'&url,'//','/','all');
				ret = this.ins_site_arquivo(path = arguments.path, site = 1);
			</cfscript>
            <cfif ret.erro>
            	<cfthrow object="#ret.mensagem#">
            </cfif>
            <cfhttp url="http://sincronizador.kmm.com.br/KMM/chmod.php?TYPE=-p&ARQUIVO=#Replace(arguments.path, '/var/www/html/sincronizador/', arguments.raiz)#" method="get"></cfhttp>
			<cfscript>
				ret = this.del_site_arquivo(path = arguments.path, site = 1);
			</cfscript>
            <cfif ret.erro>
            	<cfthrow object="#ret.mensagem#">
            </cfif>
            <cfscript>
				ret = this.excluir_arquivo(path = arguments.path);
			</cfscript>
            <cfif ret.erro>
            	<cfthrow object="#ret.mensagem#">
            </cfif>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat("Arquivo excluido com sucesso!")>
        </cftransaction>
		<cfcatch>
        	<cftransaction action="rollback" />
            <cfhttp url="http://sincronizador.kmm.com.br/KMM/chmod.php?TYPE=-u&ARQUIVO=#Replace(arguments.path, '/var/www/html/sincronizador/', arguments.raiz)#" method="get"></cfhttp>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />			
</cffunction>

<!--- 
-- PROPSITO
-- Gera uma atualizacao
-- cristofer 30/08/2007 10:31:27 - CRIADO
--->
<cffunction name='ins_atualizacao' displayname='Gera uma atualizacao' access='remote' returntype='Struct' output='true'>
	<cfargument name='TITULO' required='yes'>
	<cfargument name='DESCRICAO' required='yes'>
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='site.pkg_atualizacao.prc_ins_atualizacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATUALIZACAO_ID' variable='retorno.ATUALIZACAO_ID' >
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Atualizao inserida com sucesso!')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

<!--- 
-- PROPSITO
-- Insere uma versao do arquivo
-- cristofer 30/08/2007 10:47:47 - CRIADO
--->
<cffunction name='gera_arquivo_versao' displayname='Insere uma versao do arquivo' access='remote' returntype='Struct' output='true'>
	<cfargument name='DIRETORIO' required='yes'>
	<cfargument name='NOME' required='yes'>
	<cfargument name='CONTEUDO' required='yes'>
	<cfargument name='ASSINATURA' required='yes'>
	<cfargument name='ATUALIZACAO_ID' required='yes'>
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='site.pkg_atualizacao.prc_gera_arquivo_versao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DIRETORIO'  value='#arguments.DIRETORIO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_BLOB' dbvarname='P_CONTEUDO'  value='#arguments.CONTEUDO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ASSINATURA'  value='#arguments.ASSINATURA#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATUALIZACAO_ID'  value='#arguments.ATUALIZACAO_ID#'  null='#iif(len(trim(arguments.ATUALIZACAO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ARQUIVO_ID' variable='retorno.ARQUIVO_ID' >
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VERSAO' variable='retorno.VERSAO' >
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Arquivo sincronizado com sucesso!')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

</cfcomponent>