<!-- KM&M Componentes -->
<cfcomponent displayname="Manipulao da rea de postos" extends="_transportes.funcoes.cfc_init">
<!--- 
-- PROPSITO 
-- Insere cupom fiscal
-- CRISTOFER  13/01/2006
--->
<cffunction name="ins_cupons" displayname="Insere cupom fiscal" access="remote" returntype="struct">
	<cfargument name="num_cupom_fiscal" required="yes">
	<cfargument name="produto" required="yes">
	<cfargument name="placa" required="yes">
	<cfargument name="km_veiculo" required="yes">
	<cfargument name="data_hora" required="yes">
	<cfargument name="quantidade" required="yes">
	<cfargument name="valor_total" required="yes">
	<cfargument name="cod_pessoa" required="yes">
	<cfargument name="controle_id" required="yes">
	<cftry>
		<cfstoredproc procedure='oper.pkg_abastecimento.prc_confirma_abastecimento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_CONTROLE_ID'  			value='#arguments.CONTROLE_ID#' variable='retorno.CONTROLE_ID'  null="#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#">
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_COD_PESSOA_POSTO'  	value='#session.COD_PESSOA_USUARIO#'  null="#iif(len(trim(session.COD_PESSOA_USUARIO)), de('no'), de('yes'))#">
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_COD_PESSOA_MOTORISTA'  null='yes'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' 				dbvarname='P_DATA_HORA'  			value='#arguments.DATA_HORA#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_NUM_CUPOM_FISCAL'  	value='#arguments.NUM_CUPOM_FISCAL#'  null="#iif(len(trim(arguments.NUM_CUPOM_FISCAL)), de('no'), de('yes'))#">
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_NUM_NOTA_ID'  			null='yes'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' 				dbvarname='P_PLACA'  				value='#UCase(replace(arguments.placa, '-', '', 'ALL'))#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_KM'  					value="#arguments.km_veiculo#" null="#iif(len(trim(arguments.km_veiculo)), de('no'), de('yes'))#">
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_PRODUTO_ID'  			value='#arguments.PRODUTO#'  null="#iif(len(trim(arguments.PRODUTO)), de('no'), de('yes'))#">
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_QUANTIDADE'  			value='#arguments.QUANTIDADE#'  null="#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#">
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_LANCTO_CRT_ID'  		null='yes'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_VALOR_UNITARIO'  		value='#arguments.VALOR_UNITARIO#'  null="#iif(len(trim(arguments.VALOR_UNITARIO)), de('no'), de('yes'))#">
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_VALOR_TOTAL'  			value='#arguments.VALOR_TOTAL#'  null="#iif(len(trim(arguments.VALOR_TOTAL)), de('no'), de('yes'))#">
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_ALIQUOTA_ICMS'  		null='yes'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_NUM_REQUISICAO'  		null='yes'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_ESTOQUE_ID'  			null='yes'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_CONFERIDO'  			null='yes'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_BOMBA_ID'  			null='yes'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_ENCHEU'  				null='yes'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_SUPLEMENTAR'  			value='0'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_TIPO_ENTRADA'  		value='1'>
		</cfstoredproc>
	
		<!---Antigo
		<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_abastecimento.prc_ins_posto_lancto" username="#session.usuario#" password="#session.senha#">
			<cfprocparam type="in" 		dbvarname="p_cod_pessoa" 		cfsqltype="cf_sql_integer" value="#arguments.cod_pessoa#">
			<cfprocparam type="in" 		dbvarname="p_num_cupom_fiscal" 	cfsqltype="cf_sql_integer" value="#arguments..num_cupom_fiscal#">
			<cfprocparam type="in" 		dbvarname="p_produto_id" 		cfsqltype="cf_sql_integer" value="#arguments.produto#">
			<cfprocparam type="in" 		dbvarname="p_placa" 			cfsqltype="cf_sql_varchar" value="#UCase(replace(arguments.placa, '-', '', 'ALL'))#">
			<cfprocparam type="inout" 	dbvarname="p_km" 				cfsqltype="cf_sql_integer" value="#arguments.km_veiculo#" variable="retorno.km">
			<cfprocparam type="in" 		dbvarname="p_data_envio" 		cfsqltype="cf_sql_varchar" value="#DateFormat(Now(),'dd/mm/yyyy')#">
			<cfprocparam type="in" 		dbvarname="p_data_hora" 		cfsqltype="cf_sql_varchar" value="#arguments.data_hora#">
			<cfprocparam type="in" 		dbvarname="p_num_nota_remessa" 	cfsqltype="cf_sql_integer" null="yes">
			<cfprocparam type="in" 		dbvarname="p_quantidade" 		cfsqltype="cf_sql_numeric" scale="5" value="#arguments.quantidade#">
			<cfprocparam type="in" 		dbvarname="p_valor_unitario" 	cfsqltype="cf_sql_numeric" scale="5" value="#arguments.valor_total / arguments.quantidade#">
			<cfprocparam type="in" 		dbvarname="p_valor_total" 		cfsqltype="cf_sql_numeric" scale="5" value="#arguments.valor_total#">
			<cfprocparam type="in" 		dbvarname="p_aliquota_icms" 	cfsqltype="cf_sql_integer" value="0">
			<cfprocparam type="in" 		dbvarname="p_situacao" 			cfsqltype="cf_sql_integer" value="0">
			<cfprocparam type="in" 		dbvarname="p_encheu" 			cfsqltype="cf_sql_integer" value="0">
			<cfprocparam type="in" 		dbvarname="p_suplementar" 		cfsqltype="cf_sql_integer" value="0">
			<cfprocparam type="out" 	dbvarname="p_lancto_id" 		cfsqltype="cf_sql_integer" variable="retorno.p_lancto_id">
			<cfprocparam type="out" 	dbvarname="p_rowid" 			cfsqltype="cf_sql_varchar" variable="retorno.rowid">					
		</cfstoredproc>--->
		<cfset retorno.erro = false>
		<cfset retorno.mensagem = 'Lanamento feito com sucesso.'>
	<cfcatch>
		<cftransaction action="rollback"/>
		<cfset retorno.erro = true>
		<cfset retorno.mensagem = cfcatch>
		<cfset request.erro = cfcatch>
	</cfcatch>
	</cftry>
	<cfreturn retorno>
</cffunction>

<!--- 
-- PROPSITO 
-- Exclui cupom fiscal
-- CRISTOFER  13/01/2006
--->
<cffunction name="del_cupons" displayname="Exclui cupom fiscal" access="remote" returntype="struct">
	<cfargument name="controle_id" required="yes">
	<cftry>
		<cfstoredproc procedure="oper.pkg_abastecimento.prc_del_abastecimento" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_CONTROLE_ID" value="#arguments.CONTROLE_ID#" null="#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#" >
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_MOTIVO_ID" value="Excludo pelo posto">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_TIPO_ENTRADA_ID" value="1">
		</cfstoredproc>
		<!---<cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			delete oper.v$posto_lancto
			 where lancto_id = #arguments.lancto_id#
		</cfquery>--->
		<cfset retorno.erro = false>
		<cfset retorno.mensagem = 'Lanamento excluido com sucesso.'>
	<cfcatch>
		<cftransaction action="rollback"/>
		<cfset retorno.erro = true>
		<cfset retorno.mensagem = cfcatch>
		<cfset request.erro = cfcatch>
	</cfcatch>
	</cftry>
	<cfreturn retorno>
</cffunction>

<!--- 
-- PROPSITO 
-- Insere um aporte de caixa
-- CRISTOFER  30/12/2005
--->
<cffunction name="ins_lancto_caixa" displayname="Altera a gesto da modalidade passada" access="remote" returntype="struct" output="true">
	<cfargument name="data"				required="yes">
	<cfargument name="hora"				required="yes">
	<cfargument name="controle_id" 		required="yes">
	<cfargument name="cod_historico" 	required="yes">
	<cfargument name="complemento" 		required="no">
	<cfargument name="cod_pessoa" 		required="yes">
	<cfargument name="cod_departamento" required="no" default="2">
	<cfargument name="cod_setor" 		required="yes">
	<cfargument name="cod_centro_custo" required="no" default="1">
	<cfargument name="unidade_id" 		required="yes">
	<cfargument name="valor" 			required="yes">
	<cfargument name="receita" 			required="no" default="0">
	<cftry>
		<cftransaction action="begin">
		<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_caixa.prc_incluir_lancto_caixa" username="#session.usuario#" password="#session.senha#">
			<cfprocparam type="inout" dbvarname="p_lancamento_id" 	cfsqltype="cf_sql_integer" null="yes" variable="retorno.lancamento_id">
			<cfprocparam type="in" dbvarname="p_data_lancamento" 	cfsqltype="cf_sql_varchar" value="#arguments.data# #arguments.hora#:00">
			<cfprocparam type="in" dbvarname="p_controle_id" 		cfsqltype="cf_sql_integer" value="#arguments.controle_id#">
			<cfprocparam type="in" dbvarname="p_num_docto" 			cfsqltype="cf_sql_integer" value="#arguments.num_docto#">
			<cfprocparam type="in" dbvarname="p_cod_historico" 		cfsqltype="cf_sql_integer" value="#arguments.cod_historico#">
			<cfprocparam type="in" dbvarname="p_complemento" 		cfsqltype="cf_sql_varchar" value="#arguments.complemento#">
			<cfprocparam type="in" dbvarname="p_cod_pessoa" 		cfsqltype="cf_sql_integer" value="#arguments.cod_pessoa#">
			<cfprocparam type="in" dbvarname="p_cod_departamento" 	cfsqltype="cf_sql_integer" value="#arguments.cod_departamento#">
			<cfprocparam type="in" dbvarname="p_cod_setor" 			cfsqltype="cf_sql_integer" value="#arguments.cod_setor#">
			<cfprocparam type="in" dbvarname="p_cod_centro_custo" 	cfsqltype="cf_sql_integer" value="#arguments.cod_centro_custo#">
			<cfprocparam type="in" dbvarname="p_unidade_id" 		cfsqltype="cf_sql_integer" value="#arguments.unidade_id#">
			<cfprocparam type="in" dbvarname="p_valor" 				cfsqltype="cf_sql_numeric" scale="5"   value="#arguments.valor#">
			<cfprocparam type="in" dbvarname="p_receita" 			cfsqltype="cf_sql_integer" value="#arguments.receita#">
			<cfprocparam type="in" dbvarname="p_transferencia" 		cfsqltype="cf_sql_integer" value="1">
			<cfprocparam type="inout" dbvarname="p_rowid" 			cfsqltype="cf_sql_varchar" variable="retorno.rowid" null="yes">					
		</cfstoredproc>
		<cfset retorno.mensagem = 'Aporte feito com sucesso!'>
		<cfset retorno.erro = false>						
		</cftransaction>
  <cfcatch>
		<cfset retorno.erro = true>
		<cfset retorno.mensagem = cfcatch>
		<cftransaction action="rollback" />
		<cfset request.erro = cfcatch>
   </cfcatch>
	</cftry>
	<cfreturn retorno>
</cffunction>

<!--- 
-- PROPSITO
-- Insere uma nota fiscal
-- 12/01/2006 - criado
--->
<cffunction name="ins_nota_fiscal" displayname="Insere uma nota fiscal" access="remote" returntype="Struct" output="true">
	<cfargument name="COD_PESSOA" required="yes">
	<cfargument name="NUM_NOTA_FISCAL" required="yes">
	<cfargument name="SERIE" required="yes">
	<cfargument name="DATA_EMISSAO" required="yes">
	<cfargument name="BASE_ICMS" required="yes">
	<cfargument name="VALOR_ICMS" required="no" default="0">
	<cfargument name="BASE_ICMS_SUBST" required="no" default="0">
	<cfargument name="VALOR_ICMS_SUBST" required="no" default="0">
	<cfargument name="VALOR_TOTAL_PRODUTOS" required="no" default="0">
	<cfargument name="VALOR_FRETE" required="no" default="0">
	<cfargument name="VALOR_SEGURO" required="no" default="0">
	<cfargument name="OUTRAS_DESPESAS" required="no" default="0">
	<cfargument name="VALOR_TOTAL_IPI" required="no" default="0">
	<cfargument name="VALOR_TOTAL_NOTA" required="yes">
	<cfargument name="NOTA_SEM_CUPOM" required="no" default="0">
	<cfset arguments.valor_total_nota = 0>
	<cftry>
		<cftransaction action="begin">
			<cfstoredproc procedure="oper.pkg_posto.prc_ins_nota_fiscal" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_COD_PESSOA_POSTO" value="#arguments.COD_PESSOA#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_NUM_NOTA_FISCAL" value="#arguments.NUM_NOTA_FISCAL#" null="#iif(len(trim(arguments.NUM_NOTA_FISCAL)), de('no'), de('yes'))#" >
				<cfprocparam type="out" cfsqltype="cf_sql_varchar" dbvarname="P_NUM_NOTA_ID" variable="retorno.NUM_NOTA_REMESSA"  >
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_SERIE" value="#arguments.SERIE#"  >
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DATA_EMISSAO" value="#arguments.DATA_EMISSAO#"  >
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DATA_ENTRADA" value="#arguments.DATA_EMISSAO#"  >
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_BASE_CALC_ICMS" value="0" null="#iif(len(trim(arguments.BASE_ICMS)), de('no'), de('yes'))#" >
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_VALOR_ICMS" value="0" null="#iif(len(trim(arguments.VALOR_ICMS)), de('no'), de('yes'))#" >
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_BASE_ICMS_SUBST" value="0" null="#iif(len(trim(arguments.BASE_ICMS_SUBST)), de('no'), de('yes'))#" >
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_VALOR_ICMS_SUBST" value="0" null="#iif(len(trim(arguments.VALOR_ICMS_SUBST)), de('no'), de('yes'))#" >
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_VALOR_TOTAL_PRODUTOS" value="0" null="#iif(len(trim(arguments.VALOR_TOTAL_PRODUTOS)), de('no'), de('yes'))#" >
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_VALOR_FRETE" value="0" null="#iif(len(trim(arguments.VALOR_FRETE)), de('no'), de('yes'))#" >
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_VALOR_SEGURO" value="0" null="#iif(len(trim(arguments.VALOR_SEGURO)), de('no'), de('yes'))#" >
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_OUTRAS_DESPESAS" value="0" null="#iif(len(trim(arguments.OUTRAS_DESPESAS)), de('no'), de('yes'))#" >
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_VALOR_TOTAL_IPI" value="0" null="#iif(len(trim(arguments.VALOR_TOTAL_IPI)), de('no'), de('yes'))#" >
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_VALOR_TOTAL_NOTA" value="0" null="#iif(len(trim(arguments.VALOR_TOTAL_NOTA)), de('no'), de('yes'))#" >
				<cfprocparam type="out" cfsqltype="cf_sql_varchar" dbvarname="P_ROWID" variable="retorno.ROWID"  >
			</cfstoredproc>
         <cfdump var="#retorno.NUM_NOTA_REMESSA#">
			<cfscript>
				v_quantidade = this.ListaToArray (lista = arguments, variavel = "QUANTIDADE_PRODUTOS");
				v_valor_unitario = this.ListaToArray (lista = arguments, variavel = "VALOR_UNITARIO_PRODUTOS");
				v_valor_total = this.ListaToArray (lista = arguments, variavel = "VALOR_TOTAL_PRODUTOS");
				v_produto_id = this.ListaToArray (lista = arguments, variavel = "PRODUTO_ID_PRODUTOS");
				v_cod_unidade = this.ListaToArray (lista = arguments, variavel = "COD_UNIDADE_PRODUTOS");
			</cfscript>
			<cfloop from="1" to="#ArrayLen(v_valor_unitario)#" index="item">
				<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_posto.prc_ins_nota_fiscal_itens" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" 		dbvarname="p_num_nota_remessa" 	cfsqltype="cf_sql_integer" 	value="#retorno.num_nota_remessa#">
					<cfprocparam type="in" 		dbvarname="p_data_hora" 		cfsqltype="cf_sql_varchar" 	value="#arguments.data_emissao#">
					<cfprocparam type="in" 		dbvarname="p_cod_pessoa_posto" 	cfsqltype="cf_sql_integer" 	value="#arguments.cod_pessoa#">
					<cfprocparam type="in" 		dbvarname="p_quantidade" 		cfsqltype="cf_sql_numeric" scale="5" 	value="#v_quantidade[item]#">
					<cfprocparam type="in" 		dbvarname="p_valor_unitario" 	cfsqltype="cf_sql_numeric" scale="5" 	value="#v_valor_unitario[item]#">
					<cfprocparam type="in" 		dbvarname="p_valor_total" 		cfsqltype="cf_sql_numeric" scale="5" 	value="#v_valor_total[item]#">
					<cfprocparam type="in" 		dbvarname="p_desconto_percentual" cfsqltype="cf_sql_numeric" scale="5" 	value="0">

					<cfprocparam type="in" 		dbvarname="p_produto_id" 		cfsqltype="cf_sql_integer" 	value="#v_produto_id[item]#">
					<cfprocparam type="in" 		dbvarname="p_cod_unidade" 		cfsqltype="cf_sql_varchar" 	value="#v_cod_unidade[item]#">
					<cfprocparam type="in" 		dbvarname="p_nota_sem_cupom" 	cfsqltype="cf_sql_integer" 	value="#arguments.nota_sem_cupom#">
					<cfprocparam type="in" 		dbvarname="p_placa" 			cfsqltype="cf_sql_varchar" 	value="#UCase(Replace(arguments.placa, '-', '', 'ALL'))#">
					<cfprocparam type="inout" 	dbvarname="p_km" 				cfsqltype="cf_sql_integer" 	value="#arguments.km#" variable="retorno.km">
					<cfprocparam type="out" 	cfsqltype="cf_sql_varchar" dbvarname="P_ROWID" variable="retorno.ROWID"  >
				</cfstoredproc>
			</cfloop>
         <cfdump var="#retorno.NUM_NOTA_REMESSA#">
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat("Nota inserida com sucesso")>
		</cftransaction>
		<cfcatch>
			<cftransaction action="rollback"/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>


<!--- 
-- PROPSITO 
-- Autentica a troca do vale
-- CRISTOFER  30/12/2005
--->
<cffunction name="troca_vale" displayname="Autentica a troca do vale" access="remote" returntype="struct">
	<cfargument name="num_vale" required="yes">
	<cfargument name="cod_pessoa" required="yes">
	<cftry>
		<cftransaction action="begin">
		<cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			update oper.v$vale 
			   set situacao_id = 4
			 where num_vale = #arguments.num_vale#
			   and cod_pessoa_troca = #arguments.cod_pessoa# 
		</cfquery>
		<cfset retorno.mensagem = 'Vale confirmado com sucesso!'>
		<cfset retorno.erro = false>						
		</cftransaction>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cftransaction action="rollback" />
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno>
</cffunction>

<!--- 
-- PROPSITO 
-- Reajusta o valor do produto
-- CRISTOFER  10/01/2006
--->
<cffunction name="reajusta_produto" displayname="Reajusta o valor do produto" access="remote" returntype="struct">
	<cfargument name="produto_id" 	required="yes">
	<cfargument name="cod_pessoa" 	required="yes">
	<cfargument name="preco"		required="yes">
	<cfargument name="icms"			required="yes">
	<cftry>
		<cftransaction action="begin">
		<cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			update oper.posto_produto_autorizado 
			   set preco = #Replace(arguments.PRECO, ',', '.')#, 
			   	   icms = #Replace(arguments.ICMS, ',','.')#, 
				   permite_reajuste = 0 
		     where cod_pessoa = '#arguments.cod_pessoa#'
			   and produto_id = #arguments.PRODUTO_ID#
		</cfquery>
		<cfset retorno.mensagem = 'Produto reajustado com sucesso!'>
		<cfset retorno.erro = false>						
		</cftransaction>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cftransaction action="rollback" />
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno>
</cffunction>			   

<!--- 
-- PROPSITO 
-- Vincula os cupons do periodo a nota fiscal
-- CRISTOFER  13/01/2006
--->
<cffunction name="vincula_cupons_nota" returntype="struct" access="remote">
	<cfargument name="num_nota_remessa" required="yes">
	<cfargument name="data_inicial" required="yes">
	<cfargument name="data_final" required="yes">
	<cftry>
		<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_posto.prc_vincula_nota_cupons" username="#session.usuario#" password="#session.senha#">
			<cfprocparam type="in" dbvarname="p_num_nota_remessa" cfsqltype="cf_sql_integer" value="#arguments.num_nota_remessa#">
			<cfprocparam type="in" dbvarname="p_cod_pessoa_posto" cfsqltype="cf_sql_integer" value="#session.cod_pessoa_usuario#">
			<cfprocparam type="in" dbvarname="p_data_inicio" cfsqltype="cf_sql_varchar" value="#arguments.data_inicial#">
			<cfprocparam type="in" dbvarname="p_data_fim" cfsqltype="cf_sql_varchar" value="#arguments.data_final#">
		</cfstoredproc>
	<cfcatch>
		<cftransaction action="rollback"/>
		<cfset retorno.erro = true>
		<cfset retorno.mensagem = cfcatch>
		<cfset request.erro = cfcatch>
	</cfcatch>
	</cftry>
	<cfreturn retorno>	
</cffunction>	

</cfcomponent>