<!-- KM&M Componentes -->
<cfcomponent displayname="Manipulao da rea de pertences" extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO
	-- Efetua a baixa do material no veiculo
	-- CRISTOFER 17/02/2006
	--->	
	<cffunction name="baixa_material" returntype="struct" access="remote">
		<cfargument name="material_veiculo_id" required="yes">
		<cfargument name="cod_pessoa" required="yes">
		<cfargument name="status_id" required="yes">
		<cfargument name="observacao" required="yes">
		<cfargument name="lancar" required="no" default="0">
		<cftry>
			<cftransaction action="begin">
				<cfif arguments.lancar eq 1>
					<cfquery datasource="#session.dsn#" name="qr_material" username="#session.usuario#" password="#session.senha#">
						select m.descricao as material, mv.placa
						  from oper.v$material_acessorio m
						 inner join oper.v$material_veiculo mv
								 on mv.material_id = m.material_id
						 where material_veiculo_id = #listGetAt(arguments.material_veiculo_id, 1, ',')#
					</cfquery>					
				</cfif>
				<cfset retorno.num_lancamento = "">
				<cfif arguments.lancar eq 1>
					<!---Seleciona em qual das modalidades de conta corrente deve ser lanado o dbito, conforme o limite estipulado no parametro--->
					<cfquery datasource="#session.dsn#" name="qr_ccorrente_modalidade" username="#session.usuario#" password="#session.senha#">
						   select case 
						     when oper.pkg_ccorrente.fnc_saldo_ccorrente_dia(cc.cod_conta, sysdate) > to_number(oper.pkg_global.FNC_GET_PARAMETRO(236,'LOGISTICA')) then 9
							 else 4 end modalidade_id
						  	 from oper.v$ccorrente cc 
						 	where cc.cod_pessoa = #arguments.cod_pessoa_funcionario#
						   	  and cc.modalidade_id = 9 
						      and cc.ativo = 1 
					</cfquery>
					
					<cfquery datasource="#session.dsn#" name="qr_ccorrente" username="#session.usuario#" password="#session.senha#">
						select /*+ORDERED */ cc.cod_conta
						  from oper.v$ccorrente cc 
						 where cc.cod_pessoa = #arguments.cod_pessoa_funcionario#
						   and cc.modalidade_id = #qr_ccorrente_modalidade.modalidade_id# 
						   and cc.ativo = 1 
					</cfquery>
					
					<cfif not qr_ccorrente.RecordCount>
						<cfthrow 
							detail="Impossvel fazer o lanamento, conta corrente no encontrada!"
							message="Impossvel fazer o lanamento, conta corrente no encontrada!">
					</cfif>
					<cfset v_debito_credito = 0>
					<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_ccorrente.prc_insere_lancto_ccorrente" username="#session.usuario#" password="#session.senha#">
						<cfprocparam type="inout" dbvarname="p_num_lancamento" cfsqltype="cf_sql_integer" null="yes" variable="retorno.num_lancamento">
						<cfprocparam type="in" dbvarname="p_cod_conta" 		   cfsqltype="cf_sql_integer" value="#qr_ccorrente.cod_conta#">
						<cfprocparam type="in" dbvarname="p_cod_pessoa_un" 	   cfsqltype="cf_sql_integer" value="1">
						<cfprocparam type="in" dbvarname="p_cod_documento" 	   cfsqltype="cf_sql_integer" value="93">
						<cfprocparam type="in" dbvarname="p_num_documento" 	   cfsqltype="cf_sql_integer" value="#DateFormat(Now(),'yyyy')##DateFormat(Now(),'mm')#">
						<cfprocparam type="in" dbvarname="p_data_lancamento"   cfsqltype="cf_sql_varchar" value="#DateFormat(Now(),'dd/mm/yyyy')#">
						<cfprocparam type="in" dbvarname="p_data_vencto" 	   cfsqltype="cf_sql_varchar" value="#DateFormat(Now(),'dd/mm/yyyy')#">
						<cfprocparam type="in" dbvarname="p_historico" 		   cfsqltype="cf_sql_varchar" value="Controle de Pertences : #qr_material.material# - #qr_material.placa#">
						<cfprocparam type="in" dbvarname="p_valor_lancamento"  cfsqltype="cf_sql_float"   value="#arguments.valor#">
						<cfprocparam type="in" dbvarname="p_deb_cred" 		   cfsqltype="cf_sql_integer" value="#v_debito_credito#">
						<cfprocparam type="in" dbvarname="p_favorecido" 	   cfsqltype="cf_sql_varchar" value="#arguments.nome_funcionario#">
						<cfprocparam type="inout" dbvarname="p_rowid" 		   cfsqltype="cf_sql_varchar" variable="retorno.rowid" null="yes">					
					</cfstoredproc>
					
				
				</cfif>
					<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_controle_materiais.PRC_BAIXA_MATERIAL_VEICULO" username="#session.usuario#" password="#session.senha#">
						<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_material_veiculo_id" value="#listGetAt(arguments.material_veiculo_id, 1, ',')#" null="no">
						<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_status_id" value="#arguments.status_id#" null="no">
						<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_data_verificacao" value="#LSDateFormat(now())# #TimeFormat(now(),'HH:MM:SS')#" null="no">
						<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_pessoa_verificador" value="#arguments.cod_pessoa#" null="no">
						<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_observacao" value="#arguments.observacao#" null="no">
						<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_num_lancamento" value="#retorno.num_lancamento#" null="#iif(len(trim(retorno.num_lancamento)), de('no'), de('yes'))#">
					</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = "Item desvinculado com sucesso!">
			</cftransaction>
		<cfcatch>
			<cftransaction action="rollback" />
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Exclui o Material de um veiculo
	-- CRISTOFER 17/02/2006
	--->	
	<cffunction name="exclui_material_veiculo" returntype="struct" access="remote">
		<cfargument name="material_veiculo_id" required="yes">
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_controle_materiais.prc_del_veiculo_material" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_material_veiculo_id" value="#arguments.material_veiculo_id#" null="no">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Item excluido com sucesso!">
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>	
	
	<!--- 
    -- PROPSITO
    -- Insere um inventario de acessorio
    -- guto 09/03/2009 10:40:32 - CRIADO
    --->
    <cffunction name='ins_inventario' displayname='Insere um inventario de acessorio' access='remote' returntype='Struct' output='true'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='MATERIAL_ID' required='yes'>
        <cfargument name='DATA_INVENTARIO' required='yes'>
        <cfargument name='STATUS_ID' required='yes'>
        <cfargument name='COD_PESSOA_VERIFICADOR' required='yes'>
        <cfargument name='OBSERVACAO' required='yes'>
        <cfargument name='EQUIPAMENTO_ID' required='no' default="">
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_controle_materiais.prc_ins_mat_inventario' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MATERIAL_ID'  value='#arguments.MATERIAL_ID#'  null='#iif(len(trim(arguments.MATERIAL_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INVENTARIO'  value='#arguments.DATA_INVENTARIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_STATUS_ID'  value='#arguments.STATUS_ID#'  null='#iif(len(trim(arguments.STATUS_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_VERIFICADOR'  value='#arguments.COD_PESSOA_VERIFICADOR#'  null='#iif(len(trim(arguments.COD_PESSOA_VERIFICADOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EQUIPAMENTO_ID'  value='#arguments.EQUIPAMENTO_ID#'  null='#iif(len(trim(arguments.EQUIPAMENTO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Item inventariado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!--- 
	-- PROPSITO
	-- Insere um inventario de acessorio
	-- CRISTOFER 17/02/2006
	--->
	<cffunction name="ins_verificacao_material" returntype="struct" access="remote">
		<cfargument name="placa" required="yes">
		<cfargument name="cod_pessoa" required="yes">
		<cftry>
			<cftransaction action="begin">
			<cfset exclusao = false>
			<cfif isdefined("arguments.lancar") and arguments.lancar eq 1>
				<!---Seleciona em qual das modalidades de conta corrente deve ser lanado o dbito, conforme o limite estipulado no parametro--->
				<cfquery datasource="#session.dsn#" name="qr_ccorrente_modalidade" username="#session.usuario#" password="#session.senha#">
					select case 
							 when oper.pkg_ccorrente.fnc_saldo_ccorrente_dia(cc.cod_conta, sysdate) > to_number(oper.pkg_global.FNC_GET_PARAMETRO(236,'LOGISTICA')) then 9
						   else 4 end modalidade_id
					  from oper.v$ccorrente cc 
					 where cc.cod_pessoa = #arguments.cod_pessoa_funcionario#
					   and cc.modalidade_id = 9 
					   and cc.ativo = 1 
				</cfquery>
					
				<cfquery datasource="#session.dsn#" name="qr_ccorrente" username="#session.usuario#" password="#session.senha#">
					select /*+ORDERED */ cc.cod_conta
					  from oper.v$ccorrente cc 
					 where cc.cod_pessoa = #arguments.cod_pessoa_funcionario#
					   and cc.modalidade_id = #qr_ccorrente_modalidade.modalidade_id#  
					   and cc.ativo = 1 
				</cfquery>
				
				<cfif not qr_ccorrente.RecordCount>
					<cfthrow 
						detail="Impossvel fazer o lanamento, conta corrente no encontrada!"
						message="Impossvel fazer o lanamento, conta corrente no encontrada!">
				</cfif>
				<cfset v_debito_credito = 0>
			</cfif>
			<cfloop list="#arguments.status_material#" delimiters="," index="v_item">
				<cfif ListGetAt(v_item, 2, '_') eq 5>
					<cfset exclusao = true>
					<!--- busca a descricao do material --->
					<cfquery datasource="#session.dsn#" name="qr_material" username="#session.usuario#" password="#session.senha#">
						select m.descricao as material, mv.placa
						  from oper.v$material_acessorio m
						 inner join oper.v$material_veiculo mv
								 on mv.material_id = m.material_id
						 where material_veiculo_id = #ListGetAt(v_item, 1, '_')#
					</cfquery>
					<cfif (qr_material.recordcount eq 0) or (not len(trim(qr_material.material)))>
						<cfthrow detail="No foi encontrado o material para ser efetuada a baixa!">
					</cfif>
					<cfset retorno.num_lancamento = "">
					<cfif isdefined("arguments.lancar") and arguments.lancar eq 1>
						<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_ccorrente.prc_insere_lancto_ccorrente" username="#session.usuario#" password="#session.senha#">
							<cfprocparam type="inout" dbvarname="p_num_lancamento" cfsqltype="cf_sql_integer" null="yes" variable="retorno.num_lancamento">
							<cfprocparam type="in" dbvarname="p_cod_conta" 		   cfsqltype="cf_sql_integer" value="#qr_ccorrente.cod_conta#">
							<cfprocparam type="in" dbvarname="p_cod_pessoa_un" 	   cfsqltype="cf_sql_integer" value="1">
							<cfprocparam type="in" dbvarname="p_cod_documento" 	   cfsqltype="cf_sql_integer" value="93">
							<cfprocparam type="in" dbvarname="p_num_documento" 	   cfsqltype="cf_sql_integer" value="#DateFormat(Now(),'yyyy')##DateFormat(Now(),'mm')#">
							<cfprocparam type="in" dbvarname="p_data_lancamento"   cfsqltype="cf_sql_varchar" value="#DateFormat(Now(),'dd/mm/yyyy')#">
							<cfprocparam type="in" dbvarname="p_data_vencto" 	   cfsqltype="cf_sql_varchar" value="#DateFormat(Now(),'dd/mm/yyyy')#">
							<cfprocparam type="in" dbvarname="p_historico" 		   cfsqltype="cf_sql_varchar" value="Controle de Pertences: #qr_material.material# - #qr_material.placa#">
							<cfprocparam type="in" dbvarname="p_valor_lancamento"  cfsqltype="cf_sql_float"   value="#arguments["VALOR_"&ListGetAt(v_item, 1, '_')]#">
							<cfprocparam type="in" dbvarname="p_deb_cred" 		   cfsqltype="cf_sql_integer" value="#v_debito_credito#">
							<cfprocparam type="in" dbvarname="p_favorecido" 	   cfsqltype="cf_sql_varchar" value="#arguments.nome_funcionario_cc#">
							<cfprocparam type="inout" dbvarname="p_rowid" 		   cfsqltype="cf_sql_varchar" variable="retorno.rowid" null="yes">					
						</cfstoredproc>
					</cfif>
					<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_controle_materiais.PRC_BAIXA_MATERIAL_VEICULO" username="#session.usuario#" password="#session.senha#">
						<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_material_veiculo_id" value="#ListGetAt(v_item, 1, '_')#" null="no">
						<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_status_id" value="#ListGetAt(v_item, 2, '_')#" null="yes">
						<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_data_verificacao" value="#DateFormat(now(),'dd/mm/yyyy')# #TimeFormat(now(),'HH:MM')#" null="no">
						<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_pessoa_verificador" value="#arguments.cod_pessoa#" null="no">
						<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_observacao" value="#arguments["OBS_MATERIAL_"&ListGetAt(v_item, 1, '_')]#" null="no">
						<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_num_lancamento" value="#retorno.num_lancamento#" null="#iif(len(trim(retorno.num_lancamento)), de('no'), de('yes'))#">
					</cfstoredproc>
				<cfelse>
					<cfif not isdefined("arguments.OBS_MATERIAL_#ListGetAt(v_item, 1, '_')#")>
						<cfthrow detail="No foi possivel inserir a verificao do material: #ListGetAt(v_item, 1, '_')#">
					</cfif>
					<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_controle_materiais.prc_ins_verificacao" username="#session.usuario#" password="#session.senha#">
						<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_material_veiculo_id" value="#ListGetAt(v_item, 1, '_')#" null="no">
						<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_status_id" value="#ListGetAt(v_item, 2, '_')#" null="no">
						<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_data_verificacao" value="#DateFormat(now(),'dd/mm/yyyy')# #TimeFormat(now(),'HH:MM')#" null="no">
						<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_pessoa_verificador" value="#arguments.cod_pessoa#" null="no">
						<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_observacao" value="#arguments["OBS_MATERIAL_"&ListGetAt(v_item, 1, '_')]#" null="no">
					</cfstoredproc>
				</cfif>
			</cfloop>

			</cftransaction>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Items verificados com sucesso.">
		<cfcatch>
			<cftransaction action="rollback" />
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Insere registro de leitura da macro de falta de pertences
	-- guto 09/05/2006 14:47:55 - CRIADO
	--->
	<cffunction name='ins_leitura_macro_falta' displayname='Insere registro de leitura da macro de falta de pertences' access='remote' returntype='Struct' output='true'>;
		<cfargument name='CONTROLE_EVO_ID' required='yes'>
		<cfargument name='COD_PESSOA_RESPONSAVEL' required='yes'>
		<cfargument name='COMENTARIO' required='yes'>
		<cfargument name='DATA_LIMITE' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_controle_materiais.prc_leitura_macro_falta' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_EVO_ID'  value='#arguments.CONTROLE_EVO_ID#'  null='#iif(len(trim(arguments.CONTROLE_EVO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_RESPONSAVEL'  value='#arguments.COD_PESSOA_RESPONSAVEL#'  null='#iif(len(trim(arguments.COD_PESSOA_RESPONSAVEL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMENTARIO'  value='#arguments.COMENTARIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_LIMITE'  value='#arguments.DATA_LIMITE#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Macro marcada como lida!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Insere uma nova obsevao ao evento
	-- guto 09/05/2006 16:32:13 - CRIADO
	--->
	<cffunction name='ins_evento_observacao' displayname='Insere uma nova obsevao ao evento' access='remote' returntype='Struct' output='true'>;
		<cfargument name='CONTROLE_EVO_ID' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_controle_materiais.prc_ins_observacao_evento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_EVO_ID'  value='#arguments.CONTROLE_EVO_ID#'  null='#iif(len(trim(arguments.CONTROLE_EVO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Observao inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Exclui o evento de falta de pertence
	-- guto 09/05/2006 17:27:54 - CRIADO
	--->
	<cffunction name='del_evento_controle' displayname='Exclui o evento de falta de pertence' access='remote' returntype='Struct' output='true'>;
		<cfargument name='CONTROLE_EVO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_evento_controle.prc_del_evento_operacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_EVO_ID'  value='#arguments.CONTROLE_EVO_ID#'  null='#iif(len(trim(arguments.CONTROLE_EVO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Evento excludo com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Reagenda a verificao do material
	-- guto 09/05/2006 17:36:32 - CRIADO
	--->
	<cffunction name='reagenda_verificacao' displayname='Reagenda a verificao do material' access='remote' returntype='Struct' output='true'>;
		<cfargument name='CONTROLE_EVO_ID' required='yes'>
		<cfargument name='DATA_LIMITE_ATUAL' required='yes'>
		<cfargument name='DATA_LIMITE' required='yes'>
		<cfargument name='MOTIVO_REAGENDAMENTO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_controle_materiais.prc_reagenda_verificacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_EVO_ID'  value='#arguments.CONTROLE_EVO_ID#'  null='#iif(len(trim(arguments.CONTROLE_EVO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_LIMITE_ATUAL'  value='#arguments.DATA_LIMITE_ATUAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_LIMITE'  value='#arguments.DATA_LIMITE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MOTIVO_REAGENDAMENTO'  value='#arguments.MOTIVO_REAGENDAMENTO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Verificao reagendada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Marca a macro de falta como solucionada
	-- guto 10/05/2006 10:42:47 - CRIADO
	--->
	<cffunction name='evento_solucionado' displayname='Marca a macro de falta como solucionada' access='remote' returntype='Struct' output='true'>;
		<cfargument name='CONTROLE_EVO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_controle_materiais.prc_evento_solucionado' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_EVO_ID'  value='#arguments.CONTROLE_EVO_ID#'  null='#iif(len(trim(arguments.CONTROLE_EVO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Macro finalizada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
    <!--- 
	-- PROPSITO
	-- Alterar o autorizador do check list com itens no-conforme.
	-- LEOPOLDOS 22/06/2010 09:25:42 - CRIADO
	--->
	<cffunction name='upd_romaneio_check_list' displayname='Alterar o autorizador do check list com itens no-conforme.' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_ROMANEIO' required='yes'>
		<cfargument name='COD_PESSOA_AUTORIZADOR' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_controle_materiais.prc_alt_romaneio_check_list' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_AUTORIZADOR'  value='#arguments.COD_PESSOA_AUTORIZADOR#'  null='#iif(len(trim(arguments.COD_PESSOA_AUTORIZADOR)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Atualizado com sucesso')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    <!--- 
    -- PROPSITO
    -- Insere x inventario de acessorio
    -- LEOPOLDOS 29/06/2010 - CRIADO
    --->
    <cffunction name='ins_inventario_qtd' displayname='Insere um inventario de acessorio' access='remote' returntype='Struct' output='true'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='MATERIAL_ID' required='yes'>
        <cfargument name='DATA_INVENTARIO' required='yes'>
        <cfargument name='STATUS_ID' required='yes'>
        <cfargument name='COD_PESSOA_VERIFICADOR' required='yes'>
        <cfargument name='OBSERVACAO' required='yes'>
        <cfargument name='EQUIPAMENTO_ID' required='no' default="">
        <cfargument name='QUANTIDADE' required='no' default="">
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_controle_materiais.prc_ins_mat_inventario_qtd' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MATERIAL_ID'  value='#arguments.MATERIAL_ID#'  null='#iif(len(trim(arguments.MATERIAL_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INVENTARIO'  value='#arguments.DATA_INVENTARIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_STATUS_ID'  value='#arguments.STATUS_ID#'  null='#iif(len(trim(arguments.STATUS_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_VERIFICADOR'  value='#arguments.COD_PESSOA_VERIFICADOR#'  null='#iif(len(trim(arguments.COD_PESSOA_VERIFICADOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EQUIPAMENTO_ID'  value='#arguments.EQUIPAMENTO_ID#'  null='#iif(len(trim(arguments.EQUIPAMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QUANTIDADE'  value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Item(s) inventariado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
</cfcomponent>