<cfcomponent>
	<!--- 
	-- PROPSITO
	-- Insere uma nova tarefa do wbs
	-- guto 13/07/2006 07:59:28 - CRIADO
	--->
	<cffunction name='ins_wbs_tarefa' displayname='Insere uma nova tarefa do wbs' access='remote' returntype='Struct' output='true'>;
		<cfargument name='TITULO' required='no' default="Nova tarefa">
		<cfargument name='PERCENTUAL_COMPLETO' required='no' default="0">
		<cfargument name='DURACAO_DIAS' required='no' default="00">
		<cfargument name='DURACAO_HORAS' required='no' default="00:00">
		<cfargument name='CUSTO_HORA' required='no' default="0">
		<cfargument name='HORAS_TRABALHADAS_DIAS' required='no' default="00">
		<cfargument name='HORAS_TRABALHADAS_HORAS' required='no' default="00:00">
		<cfargument name='DATA_HORA_INICIO' required='no' default="01/01/1900">
		<cfargument name='DATA_HORA_FIM' required='no' default="01/01/1900">
		<cfargument name='SOLUCAO_ID' required='no' default="1">
		<cfargument name='DATA_PREVISTA' required='no' default="01/01/1900">
		<cfargument name='OBJETO_ID' required='yes'>
		<cfargument name='DIAGRAMA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='desenvolvimento.pkg_mpsbr.prc_ins_wbs_tarefa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
					<cfprocparam type='IN' cfsqltype='cf_sql_varchar' dbvarname='P_DURACAO' value="+#Trim(arguments.DURACAO_DIAS)# #Trim(arguments.DURACAO_HORAS)#:00">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PERCENTUAL_COMPLETO'  value='#arguments.PERCENTUAL_COMPLETO#'  null='#iif(len(trim(arguments.PERCENTUAL_COMPLETO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='cf_sql_varchar' dbvarname='P_HORAS_TRABALHADAS' value="+#Trim(arguments.HORAS_TRABALHADAS_DIAS)# #Trim(arguments.HORAS_TRABALHADAS_HORAS)#:00">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CUSTO_HORA'  value='#arguments.CUSTO_HORA#'  null='#iif(len(trim(arguments.CUSTO_HORA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_HORA_INICIO'  value='#arguments.DATA_HORA_INICIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_HORA_FIM'  value='#arguments.DATA_HORA_FIM#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SOLUCAO_ID'  value='#arguments.SOLUCAO_ID#'  null='#iif(len(trim(arguments.SOLUCAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_PREVISTA'  value='#arguments.DATA_PREVISTA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DIAGRAMA_ID'  value='#arguments.DIAGRAMA_ID#'  null='#iif(len(trim(arguments.DIAGRAMA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OBJETO_ID'  value='#arguments.OBJETO_ID#' variable='retorno.OBJETO_ID'  null='#iif(len(trim(arguments.OBJETO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TAREFA_ID'  variable='retorno.TAREFA_ID'  null='yes'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Atividade inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Altera tarefa do WBS
	-- guto 13/07/2006 08:01:37 - CRIADO
	--->
	<cffunction name='alt_wbs_tarefa' displayname='Altera tarefa do WBS' access='remote' returntype='Struct' output='true'>;
		<cfargument name='TAREFA_ID' required='yes'>
		<cfargument name='TITULO' required='yes'>
		<cfargument name='PERCENTUAL_COMPLETO' required='yes'>
		<cfargument name='CUSTO_HORA' required='yes'>
		<cfargument name='DATA_HORA_INICIO' required='yes'>
		<cfargument name='DATA_HORA_FIM' required='yes'>
		<cfargument name='SOLUCAO_ID' required='yes'>
		<cfargument name='DATA_PREVISTA' required='yes'>
		<cfargument name='OBJETO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='desenvolvimento.pkg_mpsbr.prc_alt_wbs_tarefa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TAREFA_ID'  value='#arguments.TAREFA_ID#'  null='#iif(len(trim(arguments.TAREFA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TITULO'  value='#arguments.TITULO#' >
					<cfprocparam type='IN' cfsqltype='cf_sql_varchar' dbvarname='P_DURACAO' value="+#Trim(arguments.DURACAO_DIAS)# #Trim(arguments.DURACAO_HORAS)#:00">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PERCENTUAL_COMPLETO'  value='#arguments.PERCENTUAL_COMPLETO#'  null='#iif(len(trim(arguments.PERCENTUAL_COMPLETO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='cf_sql_varchar' dbvarname='P_HORAS_TRABALHADAS' value="+#Trim(arguments.HORAS_TRABALHADAS_DIAS)# #Trim(arguments.HORAS_TRABALHADAS_HORAS)#:00">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CUSTO_HORA'  value='#arguments.CUSTO_HORA#'  null='#iif(len(trim(arguments.CUSTO_HORA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_HORA_INICIO'  value='#arguments.DATA_HORA_INICIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_HORA_FIM'  value='#arguments.DATA_HORA_FIM#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SOLUCAO_ID'  value='#arguments.SOLUCAO_ID#'  null='#iif(len(trim(arguments.SOLUCAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_PREVISTA'  value='#arguments.DATA_PREVISTA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OBJETO_ID'  value='#arguments.OBJETO_ID#'  null='#iif(len(trim(arguments.OBJETO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Atividade alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Exclui tarefa do WBS
	-- guto 13/07/2006 08:03:16 - CRIADO
	--->
	<cffunction name='del_wbs_tarefa' displayname='Exclui tarefa do WBS' access='remote' returntype='Struct' output='true'>;
		<cfargument name='TAREFA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='desenvolvimento.pkg_mpsbr.prc_del_wbs_tarefa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TAREFA_ID'  value='#arguments.TAREFA_ID#'  null='#iif(len(trim(arguments.TAREFA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Atividade excluida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
</cfcomponent>