<cfcomponent>
	<!--- 
	-- PROPSITO
	-- Inserir uma Plataforma
	-- LEOPOLDOS 28/04/2010 17:23:07 - CRIADO
	--->
	<cffunction name='ins_plataforma' displayname='Inserir uma Plataforma' access='remote' returntype='Struct' output='true'>
		<cfargument name='NOME' required='yes'>
		<cfargument name='EXTENSAO_INSTALADOR' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='movel.pkg_plataforma.prc_ins_plataforma' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PLATAFORMA_ID' variable='retorno.PLATAFORMA_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EXTENSAO_INSTALADOR'  value='#arguments.EXTENSAO_INSTALADOR#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Plataforma inserida com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Alterar uma Plataforma
	-- LEOPOLDOS 28/04/2010 17:24:50 - CRIADO
	--->
	<cffunction name='upd_plataforma' displayname='Alterar uma Plataforma' access='remote' returntype='Struct' output='true'>
		<cfargument name='PLATAFORMA_ID' required='yes'>
		<cfargument name='NOME' required='yes'>
		<cfargument name='EXTENSAO_INSTALADOR' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='movel.pkg_plataforma.prc_alt_plataforma' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PLATAFORMA_ID'  value='#arguments.PLATAFORMA_ID#'  null='#iif(len(trim(arguments.PLATAFORMA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EXTENSAO_INSTALADOR'  value='#arguments.EXTENSAO_INSTALADOR#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Plataforma alterada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Deleta uma Plataforma
	-- LEOPOLDOS 28/04/2010 17:25:57 - CRIADO
	--->
	<cffunction name='del_plataforma' displayname='Deleta uma Plataforma' access='remote' returntype='Struct' output='true'>
		<cfargument name='PLATAFORMA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='movel.pkg_plataforma.prc_del_plataforma' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PLATAFORMA_ID'  value='#arguments.PLATAFORMA_ID#'  null='#iif(len(trim(arguments.PLATAFORMA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Plataforma apagada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Inserir um aplicativo
	-- LEOPOLDOS 29/04/2010 09:13:06 - CRIADO
	--->
	<cffunction name='ins_aplicativo' displayname='Inserir um aplicativo' access='remote' returntype='Struct' output='true'>
		<cfargument name='NOME' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='movel.pkg_aplicativo.prc_ins_aplicativo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_APLICATIVO_ID' variable='retorno.APLICATIVO_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Aplicativo inserido com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Alterar Aplicativo
	-- LEOPOLDOS 29/04/2010 09:45:29 - CRIADO
	--->
	<cffunction name='upd_aplicativo' displayname='Alterar Aplicativo' access='remote' returntype='Struct' output='true'>
		<cfargument name='APLICATIVO_ID' required='yes'>
		<cfargument name='NOME' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='movel.pkg_aplicativo.prc_alt_aplicativo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_APLICATIVO_ID'  value='#arguments.APLICATIVO_ID#'  null='#iif(len(trim(arguments.APLICATIVO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Aplicativo alterado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Deletar um Aplicativo
	-- LEOPOLDOS 29/04/2010 09:46:26 - CRIADO
	--->
	<cffunction name='del_aplicativo' displayname='Deletar um Aplicativo' access='remote' returntype='Struct' output='true'>
		<cfargument name='APLICATIVO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='movel.pkg_aplicativo.prc_del_aplicativo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_APLICATIVO_ID'  value='#arguments.APLICATIVO_ID#'  null='#iif(len(trim(arguments.APLICATIVO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Aplicativo deletado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Insere uma verso de aplicativo
	-- LEOPOLDOS 29/04/2010 11:15:53 - CRIADO
	--->
	<cffunction name='ins_aplicativo_versao' displayname='Insere uma verso de aplicativo' access='remote' returntype='Struct' output='true'>
		<cfargument name='VERSAO' required='yes'>
		<cfargument name='PLATAFORMA_ID' required='yes'>
		<cfargument name='APLICATIVO_ID' required='yes'>
		<cfargument name='ARQ_INSTALADOR' required='yes'>
		<cftry>
        
            <cffile action="readbinary" file="#arguments.ARQ_INSTALADOR#" variable="VINSTALADOR">
        
			<cftransaction action='begin'>
				<cfstoredproc procedure=' movel.pkg_aplicativo_versao.prc_ins_aplicativo_versao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VERSAO_ID' variable='retorno.VERSAO_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_VERSAO'  value='#arguments.VERSAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PLATAFORMA_ID'  value='#arguments.PLATAFORMA_ID#'  null='#iif(len(trim(arguments.PLATAFORMA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_APLICATIVO_ID'  value='#arguments.APLICATIVO_ID#'  null='#iif(len(trim(arguments.APLICATIVO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_BLOB' dbvarname='P_ARQ_INSTALADOR'  value='#VINSTALADOR#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Verso inserida com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
    <!--- 
	-- PROPSITO
	-- Altera uma verso de aplicativo
	-- LEOPOLDOS 29/04/2010 11:17:49 - CRIADO
	--->
	<cffunction name='upd_aplicativo_versao' displayname='Altera uma verso de aplicativo' access='remote' returntype='Struct' output='true'>
		<cfargument name='VERSAO_ID' required='yes'>
		<cfargument name='VERSAO' required='yes'>
		<cfargument name='PLATAFORMA_ID' required='yes'>
		<cfargument name='APLICATIVO_ID' required='yes'>
		<cfargument name='ARQ_INSTALADOR' required='yes'>
		<cftry>
        	
            <cffile action="readbinary" file="#arguments.ARQ_INSTALADOR#" variable="VINSTALADOR">
            
			<cftransaction action='begin'>
				<cfstoredproc procedure='movel.pkg_aplicativo_versao.prc_alt_aplicativo_versao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VERSAO_ID'  value='#arguments.VERSAO_ID#'  null='#iif(len(trim(arguments.VERSAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_VERSAO'  value='#arguments.VERSAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PLATAFORMA_ID'  value='#arguments.PLATAFORMA_ID#'  null='#iif(len(trim(arguments.PLATAFORMA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_APLICATIVO_ID'  value='#arguments.APLICATIVO_ID#'  null='#iif(len(trim(arguments.APLICATIVO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_BLOB' dbvarname='P_ARQ_INSTALADOR'  value='#VINSTALADOR#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Verso alterada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
    
    <!--- 
	-- PROPSITO
	-- Deleta uma verso de aplicativo
	-- LEOPOLDOS 29/04/2010 11:18:40 - CRIADO
	--->
	<cffunction name='del_aplicativo_versao' displayname='Deleta uma verso de aplicativo' access='remote' returntype='Struct' output='true'>
		<cfargument name='VERSAO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='movel.pkg_aplicativo_versao.prc_del_aplicativo_versao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VERSAO_ID'  value='#arguments.VERSAO_ID#'  null='#iif(len(trim(arguments.VERSAO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Verso apagada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
    -- PROPSITO
    -- inserir configurao do cliente
    -- GUSTAVOC 29/04/2010 17:37:20 - CRIADO
    --->
    <cffunction name='ins_configuracao_cliente' displayname='inserir configurao do cliente' access='remote' returntype='Struct' output='true'>
        <cfargument name='URL_REQUISICAO' required='yes'>
        <cfargument name='CLIENTE_ID' required='yes'>
        <cfargument name='DB_NAME' required='yes'>
        <cfargument name='DB_USUARIO' required='yes'>
        <cfargument name='DB_SENHA' required='yes'>
        <cfargument name='DB_HOST' required='yes'>
        <cfargument name='DB_PORT' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='movel.pkg_configuracao_cliente.prc_ins_configuracao_cliente' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONFIG_ID' variable='retorno.CONFIG_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_URL_REQUISICAO'  value='#arguments.URL_REQUISICAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CLIENTE_ID'  value='#arguments.CLIENTE_ID#'  null='#iif(len(trim(arguments.CLIENTE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DB_NAME'  value='#arguments.DB_NAME#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DB_USUARIO'  value='#arguments.DB_USUARIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DB_SENHA'  value='#arguments.DB_SENHA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DB_HOST'  value='#arguments.DB_HOST#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DB_PORT'  value='#arguments.DB_PORT#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Configurao do cliente inserida com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- alterar configurao do cliente
	-- GUSTAVOC 29/04/2010 17:42:25 - CRIADO
	--->
	<cffunction name='upd_configuracao_cliente' displayname='alterar configurao do cliente' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONFIG_ID' required='yes'>
		<cfargument name='URL_REQUISICAO' required='yes'>
		<cfargument name='CLIENTE_ID' required='yes'>
		<cfargument name='DB_NAME' required='yes'>
		<cfargument name='DB_USUARIO' required='yes'>
		<cfargument name='DB_SENHA' required='yes'>
		<cfargument name='DB_HOST' required='yes'>
		<cfargument name='DB_PORT' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='movel.pkg_configuracao_cliente.prc_alt_configuracao_cliente' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONFIG_ID'  value='#arguments.CONFIG_ID#'  null='#iif(len(trim(arguments.CONFIG_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_URL_REQUISICAO'  value='#arguments.URL_REQUISICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CLIENTE_ID'  value='#arguments.CLIENTE_ID#'  null='#iif(len(trim(arguments.CLIENTE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DB_NAME'  value='#arguments.DB_NAME#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DB_USUARIO'  value='#arguments.DB_USUARIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DB_SENHA'  value='#arguments.DB_SENHA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DB_HOST'  value='#arguments.DB_HOST#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DB_PORT'  value='#arguments.DB_PORT#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Configurao do cliente alterada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- remover configurao do cliente
	-- GUSTAVOC 29/04/2010 17:45:02 - CRIADO
	--->
	<cffunction name='del_configuracao_cliente' displayname='remover configurao do cliente' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONFIG_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='movel.pkg_configuracao_cliente.prc_del_configuracao_cliente' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='MODE' cfsqltype='CF_SQL_INTEGER' dbvarname='PARAMETER' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONFIG_ID'  value='#arguments.CONFIG_ID#'  null='#iif(len(trim(arguments.CONFIG_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Configurao do cliente removida com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Inserir aparelho
	-- LEOPOLDOS 30/04/2010 16:41:50 - CRIADO
	--->
	<cffunction name='ins_aparelho' displayname='Inserir aparelho' access='remote' returntype='Struct' output='true'>
		<cfargument name='VERSAO_ID' required='yes'>
        <cfargument name='CONFIG_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='COD_IDENTIFICADOR' required='yes'>
		<cfargument name='DATA_ATIVACAO' required='yes'>
		<cfargument name='DATA_ULTIMA_ATUALIZACAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='movel.pkg_aparelho.prc_ins_aparelho' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_APARELHO_ID'  variable='retorno.ROWID'  null='#iif(len(trim(arguments.APARELHO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VERSAO_ID'  value='#arguments.VERSAO_ID#'  null='#iif(len(trim(arguments.VERSAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONFIG_ID'  value='#arguments.VERSAO_ID#'  null='#iif(len(trim(arguments.CONFIG_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_IDENTIFICADOR'  value='#arguments.COD_IDENTIFICADOR#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_ATIVACAO'  value='#arguments.DATA_ATIVACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_ULTIMA_ATUALIZACAO'  value='#arguments.DATA_ULTIMA_ATUALIZACAO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Aparelho inserido com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
            
	<!--- 
    -- PROPSITO
    -- Alterar um aparelho
    -- LEOPOLDOS 30/04/2010 08:21:09 - CRIADO
    --->
    <cffunction name='upd_aparelho' displayname='Alterar um aparelho' access='remote' returntype='Struct' output='true'>
        <cfargument name='APARELHO_ID' required='yes'>
        <cfargument name='CONFIG_ID' required='yes'>
        <cfargument name='VERSAO_ID' required='yes'>
        <cfargument name='TOKEN' required='yes'>
        <cfargument name='DESCRICAO' required='yes'>
        <cfargument name='COD_IDENTIFICADOR' required='yes'>
        <cfargument name='DATA_ATIVACAO' required='yes'>
        <cfargument name='DATA_ULTIMA_ATUALIZACAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='movel.pkg_aparelho.prc_alt_aparelho' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_APARELHO_ID'  value='#arguments.APARELHO_ID#'  null='#iif(len(trim(arguments.APARELHO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONFIG_ID'  value='#arguments.CONFIG_ID#'  null='#iif(len(trim(arguments.CONFIG_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VERSAO_ID'  value='#arguments.VERSAO_ID#'  null='#iif(len(trim(arguments.VERSAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TOKEN'  value='#arguments.TOKEN#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_IDENTIFICADOR'  value='#arguments.COD_IDENTIFICADOR#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_ATIVACAO'  value='#arguments.DATA_ATIVACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_ULTIMA_ATUALIZACAO'  value='#arguments.DATA_ULTIMA_ATUALIZACAO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Aparelho alterado com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
		
    <!--- 
	-- PROPSITO
	-- Alterar o aparelho vinculado (Cd Identificador)
	-- LEOPOLDOS 30/04/2010 11:19:25 - CRIADO
	--->
	<cffunction name='alt_aparelho_id' displayname='Alterar o aparelho vinculado (Cd Identificador)' access='remote' returntype='Struct' output='true'>
		<cfargument name='TOKEN' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='movel.pkg_aparelho.prc_alt_aparelho_id' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TOKEN'  value="#arguments.TOKEN#" >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Aparelho liberado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
   
   <!--- 
	-- PROPSITO
	-- Atualizar verso do aparelho
	-- LEOPOLDOS 21/07/2010 16:43:47 - CRIADO
	--->
	<cffunction name='atualiza_versao' displayname='Atualizar verso do aparelho' access='remote' returntype='Struct' output='true'>
		<cfargument name='TOKEN' required='yes'>
		<cfargument name='VERSAO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='movel.pkg_aparelho.prc_atualiza_versao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TOKEN'  value='#arguments.TOKEN#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VERSAO_ID'  value='#arguments.VERSAO_ID#'  null='#iif(len(trim(arguments.VERSAO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Atualizado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Deletar um aparelho
	-- LEOPOLDOS 30/04/2010 13:09:58 - CRIADO
	--->
	<cffunction name='del_aparelho' displayname='Deletar um aparelho' access='remote' returntype='Struct' output='true'>
		<cfargument name='APARELHO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='movel.pkg_aparelho.prc_del_aparelho' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_APARELHO_ID'  value='#arguments.APARELHO_ID#'  null='#iif(len(trim(arguments.APARELHO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Aparelho apagado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
	<!--- 
    -- PROPSITO
    -- Vincula um aparelho ao token
    -- LEOPOLDOS 01/05/2010 10:46:52 - CRIADO
    --->
    <cffunction name='alt_aparelho_vincula' displayname='Vincula um aparelho ao token' access='remote' returntype='struct' output='true'>
        <cfargument name='TOKEN' required='yes'>
        <cfargument name='COD_IDENTIFICADOR' required='yes'>
        <cftry>
        <!---trim('#arguments.TOKEN#')--->
            <cftransaction action='begin'>
                <cfstoredproc procedure='movel.pkg_aparelho.prc_aparelho_vincula' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TOKEN'  value="#arguments.TOKEN#" >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_IDENTIFICADOR'  value="#arguments.COD_IDENTIFICADOR#" >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RESULTADO' variable='retorno.RESULTADO' >
                </cfstoredproc>
                <cfset retorno.erro = false>
		   <!---<cfset retorno.mensagem = JSStringFormat('Aparelho vinculado com sucesso.')>--->
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    
        
</cfcomponent>