<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO
	-- Insere uma camada de mapas
	-- CRISTOFER 24/10/2007 - criado
	--->
	<cffunction name="ins_shape" displayname="" access="remote" returntype="struct" output="true">
		<cfargument name="DESCRICAO" required="yes">
		<cfargument name="COLUMN" required="yes">
		<cfargument name="QUERY" required="yes">
		<cfargument name="NOME" required="yes">
	    <cftry>
			<cfquery name="qr_result" datasource="#session.dsn#.MAPSERVER">
            	select * 
                  from spatial.prc_ins_shape(
                        '#arguments.descricao#',
                        '#arguments.column#',
                        '#arguments.query#',
                        '#arguments.nome#')
            </cfquery>
            <cfset retorno.shape_id = qr_result.p_shape_id>
			<cfset retorno.mensagem = 'Camada inserida com sucesso!'>
			<cfset retorno.erro = false>						
 	  <cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
	   </cfcatch>
	   </cftry>
	   <cfreturn retorno>	   
	</cffunction>
    
	<!--- 
	-- PROPSITO
	-- Altera uma camada de mapas
	-- CRISTOFER 24/10/2007 - criado
	--->
	<cffunction name="upd_shape" displayname="" access="remote" returntype="struct" output="true">
		<cfargument name="SHAPE_ID" required="yes">
		<cfargument name="DESCRICAO" required="yes">
		<cfargument name="COLUMN" required="yes">
		<cfargument name="QUERY" required="yes">
		<cfargument name="NOME" required="yes">
	    <cftry>
			<cfquery name="qr_result" datasource="#session.dsn#.MAPSERVER">
            	select * 
                  from spatial.prc_alt_shape(
                  		#arguments.shape_id#,
                        '#arguments.descricao#',
                        '#arguments.column#',
                        '#arguments.query#',
                        '#arguments.nome#')
            </cfquery>
            <cfset retorno.shape_id = qr_result.p_shape_id>
			<cfset retorno.mensagem = 'Camada alterada com sucesso!'>
			<cfset retorno.erro = false>						
 	  <cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
	   </cfcatch>
	   </cftry>
	   <cfreturn retorno>	   
	</cffunction>
    
	<!--- 
	-- PROPSITO
	-- Exclui uma camada de mapas
	-- CRISTOFER 24/10/2007 - criado
	--->
	<cffunction name="del_shape" displayname="" access="remote" returntype="struct" output="true">
		<cfargument name="SHAPE_ID" required="yes">
	    <cftry>
			<cfquery name="qr_result" datasource="#session.dsn#.MAPSERVER">
            	select * 
                  from spatial.prc_del_shape(
                  		#arguments.shape_id#)
            </cfquery>
            <cfset retorno.shape_id = qr_result.p_shape_id>
			<cfset retorno.mensagem = 'Camada excluida com sucesso!'>
			<cfset retorno.erro = false>						
 	  <cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
	   </cfcatch>
	   </cftry>
	   <cfreturn retorno>	   
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Insere um otimizador
	-- CRISTOFER 25/10/2007 - criado
	--->
	<cffunction name="ins_otimizacao" displayname="" access="remote" returntype="struct" output="true">
		<cfargument name="DESCRICAO" required="yes">
	    <cftry>
        	<cftransaction action="begin">
			<cfquery name="qr_result" datasource="#session.dsn#.MAPSERVER">
            	select * 
                  from spatial.prc_ins_otimizacao(
                        '#arguments.descricao#')
            </cfquery>
            <cfset retorno.otimizacao_id = qr_result.p_otimizacao_id>
            
            <cfscript>
				v_parametro_id 		= this.ListaToArray (lista = arguments, variavel = "PARAMETRO_ID_PARAMETROS");
				v_parametro_campo 	= this.ListaToArray (lista = arguments, variavel = "PARAMETRO_CAMPO_PARAMETROS");
				v_parametro_valor 	= this.ListaToArray (lista = arguments, variavel = "PARAMETRO_VALOR_PARAMETROS");
				v_parametro_fator 	= this.ListaToArray (lista = arguments, variavel = "PARAMETRO_FATOR_PARAMETROS");
				v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_PARAMETROS, lista2 = ArrayToList(v_parametro_id));
			</cfscript>
			<cfloop list="#v_excluir#" delimiters="," index="l_id">
				<cfscript>
					ret = this.del_otimizacao_parametro(parametro_id = l_id);
				</cfscript>
                <cfif ret.erro>
                	<cfthrow object="#ret.mensagem#">
                </cfif>
			</cfloop>
			<cfloop from="1" to="#ArrayLen(v_parametro_id)#" index="count">
				<cfscript>
					if(Len(Trim(v_parametro_id[count]))){					
						ret = this.upd_otimizacao_parametro(parametro_id 	= v_parametro_id[count],
															campo			= v_parametro_campo[count],
															valor			= v_parametro_valor[count],
															fator			= v_parametro_fator[count],
															otimizacao_id	= retorno.otimizacao_id);
					}else{
						ret = this.ins_otimizacao_parametro(campo			= v_parametro_campo[count],
															valor			= v_parametro_valor[count],
															fator			= v_parametro_fator[count],
															otimizacao_id	= retorno.otimizacao_id);
					} 
				</cfscript>
                <cfif ret.erro>
	                <cfthrow object="#ret.mensagem#">
                </cfif>
			</cfloop>
			<cfset retorno.mensagem = 'Otimizador inserido com sucesso!'>
			<cfset retorno.erro = false>	
            </cftransaction>					
 	  <cfcatch>
      		<cftransaction action="rollback" />
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
	   </cfcatch>
	   </cftry>
	   <cfreturn retorno>	   
	</cffunction>
    
	<!--- 
	-- PROPSITO
	-- Altera um otimizador
	-- CRISTOFER 25/10/2007 - criado
	--->
	<cffunction name="upd_otimizacao" displayname="" access="remote" returntype="struct" output="true">
		<cfargument name="OTIMIZACAO_ID" required="yes">
		<cfargument name="DESCRICAO" required="yes">
	    <cftry>
        	<cftransaction action="begin">
			<cfquery name="qr_result" datasource="#session.dsn#.MAPSERVER">
            	select * 
                  from spatial.prc_alt_otimizacao(
                  		#arguments.otimizacao_id#,
                        '#arguments.descricao#')
            </cfquery>
            <cfset retorno.otimizacao_id = qr_result.p_otimizacao_id>
            <cfscript>
				v_parametro_id 		= this.ListaToArray (lista = arguments, variavel = "PARAMETRO_ID_PARAMETROS");
				v_parametro_campo 	= this.ListaToArray (lista = arguments, variavel = "PARAMETRO_CAMPO_PARAMETROS");
				v_parametro_valor 	= this.ListaToArray (lista = arguments, variavel = "PARAMETRO_VALOR_PARAMETROS");
				v_parametro_fator 	= this.ListaToArray (lista = arguments, variavel = "PARAMETRO_FATOR_PARAMETROS");
				v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_PARAMETROS, lista2 = ArrayToList(v_parametro_id));
			</cfscript>
			<cfloop list="#v_excluir#" delimiters="," index="l_id">
				<cfscript>
					ret = this.del_otimizacao_parametro(parametro_id = l_id);
				</cfscript>
                <cfif ret.erro>
                	<cfthrow object="#ret.mensagem#">
                </cfif>
			</cfloop>
			<cfloop from="1" to="#ArrayLen(v_parametro_id)#" index="count">
				<cfscript>
					if(Len(Trim(v_parametro_id[count]))){					
						ret = this.upd_otimizacao_parametro(parametro_id 	= v_parametro_id[count],
															campo			= v_parametro_campo[count],
															valor			= v_parametro_valor[count],
															fator			= v_parametro_fator[count],
															otimizacao_id	= retorno.otimizacao_id);
					}else{
						ret = this.ins_otimizacao_parametro(campo			= v_parametro_campo[count],
															valor			= v_parametro_valor[count],
															fator			= v_parametro_fator[count],
															otimizacao_id	= retorno.otimizacao_id);
					} 
				</cfscript>
                <cfif ret.erro>
	                <cfthrow object="#ret.mensagem#">
                </cfif>
			</cfloop>
			<cfset retorno.mensagem = 'Otimizador alterado com sucesso!'>
			<cfset retorno.erro = false>	
            					
            </cftransaction>
 	  <cfcatch>
      		<cftransaction action="rollback" />
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
	   </cfcatch>
	   </cftry>
	   <cfreturn retorno>	   
	</cffunction>
    
	<!--- 
	-- PROPSITO
	-- Exclui um otimizador
	-- CRISTOFER 25/10/2007 - criado
	--->
	<cffunction name="del_otimizacao" displayname="" access="remote" returntype="struct" output="true">
		<cfargument name="OTIMIZACAO_ID" required="yes">
	    <cftry>
        	<cftransaction action="begin">
			<cfquery name="qr_result" datasource="#session.dsn#.MAPSERVER">
            	select * 
                  from spatial.prc_del_otimizacao(
                  		#arguments.otimizacao_id#)
            </cfquery>
            <cfset retorno.otimizacao_id = qr_result.p_otimizacao_id>
			<cfset retorno.mensagem = 'Otimizador excluido com sucesso!'>
			<cfset retorno.erro = false>	
            </cftransaction>					
 	  <cfcatch>
      		<cftransaction action="rollback" />
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
	   </cfcatch>
	   </cftry>
	   <cfreturn retorno>	   
	</cffunction>
    
    
	<!--- 
	-- PROPSITO
	-- Insere um parametro de otimizacao
	-- CRISTOFER 25/10/2007 - criado
	--->
	<cffunction name="ins_otimizacao_parametro" displayname="" access="remote" returntype="struct" output="true">
		<cfargument name="OTIMIZACAO_ID" required="yes">
		<cfargument name="CAMPO" required="yes">
		<cfargument name="VALOR" required="yes">
		<cfargument name="FATOR" required="yes">
	    <cftry>
			<cfquery name="qr_result" datasource="#session.dsn#.MAPSERVER">
            	select * 
                  from spatial.prc_ins_otimizacao_parametro(
                  		#arguments.otimizacao_id#,
                        '#arguments.campo#',
                        '#arguments.valor#',
                        #arguments.fator#)
            </cfquery>
            <cfset retorno.parametro_id = qr_result.p_parametro_id>
			<cfset retorno.mensagem = 'Parametro inserido com sucesso!'>
			<cfset retorno.erro = false>						
 	  <cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
	   </cfcatch>
	   </cftry>
	   <cfreturn retorno>	   
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Altera um parametro de otimizacao
	-- CRISTOFER 25/10/2007 - criado
	--->
	<cffunction name="upd_otimizacao_parametro" displayname="" access="remote" returntype="struct" output="true">
		<cfargument name="PARAMETRO_ID" required="yes">
		<cfargument name="OTIMIZACAO_ID" required="yes">
		<cfargument name="CAMPO" required="yes">
		<cfargument name="VALOR" required="yes">
		<cfargument name="FATOR" required="yes">
	    <cftry>
			<cfquery name="qr_result" datasource="#session.dsn#.MAPSERVER">
            	select * 
                  from spatial.prc_alt_otimizacao_parametro(
                        #arguments.parametro_id#,
                  		#arguments.otimizacao_id#,
                        '#arguments.campo#',
                        '#arguments.valor#',
                        #arguments.fator#)
            </cfquery>
            <cfset retorno.parametro_id = qr_result.p_parametro_id>
			<cfset retorno.mensagem = 'Parametro alterado com sucesso!'>
			<cfset retorno.erro = false>						
 	  <cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
	   </cfcatch>
	   </cftry>
	   <cfreturn retorno>	   
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Exclui um parametro de otimizacao
	-- CRISTOFER 25/10/2007 - criado
	--->
	<cffunction name="del_otimizacao_parametro" displayname="" access="remote" returntype="struct" output="true">
		<cfargument name="PARAMETRO_ID" required="yes">
	    <cftry>
			<cfquery name="qr_result" datasource="#session.dsn#.MAPSERVER">
            	select * 
                  from spatial.prc_del_otimizacao_parametro(
                        #arguments.parametro_id#)
            </cfquery>
            <cfset retorno.parametro_id = qr_result.p_parametro_id>
			<cfset retorno.mensagem = 'Parametro excluido com sucesso!'>
			<cfset retorno.erro = false>						
 	  <cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
	   </cfcatch>
	   </cftry>
	   <cfreturn retorno>	   
	</cffunction>
    
</cfcomponent>