<!-- KM&M Componentes -->
<cfcomponent displayname="Manipulao da rea de pertences" extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO
	-- Insere solicitao de coleta.
	-- wagner 18/10/2006 20:42:36 - CRIADO
	--->
	<cffunction name='ins_coleta' displayname='Insere solicitao de coleta.' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_COLETA' required='yes'>
		<cfargument name='SERIE' required='yes'>
		<cfargument name='SUBSERIE' required='yes'>
		<cfargument name='COD_FILIAL' required='yes'>
		<cfargument name='COD_RESPONSAVEL' required='yes'>
		<cfargument name='DATA_CONFIRMACAO' required='yes'>
		<cfargument name='COD_EMPRESA' required='yes'>
		<cfargument name='COD_SOLICITANTE' required='yes'>
		<cfargument name='NUM_PEDIDO' required='yes'>
		<cfargument name='DATA_PEDIDO' required='yes'>
		<cfargument name='PRAZO_RETIRADA' required='yes'>
		<cfargument name='REM_COD_PESSOA' required='yes'>
		<cfargument name='REM_LOGRADOURO' required='yes'>
		<cfargument name='REM_COMPLEMENTO' required='yes'>
		<cfargument name='REM_BAIRRO' required='yes'>
		<cfargument name='REM_CEP' required='yes'>
		<cfargument name='REM_MUNICIPIO_ID' required='yes'>
		<cfargument name='DEST_COD_PESSOA' required='yes'>
		<cfargument name='DEST_LOGRADOURO' required='yes'>
		<cfargument name='DEST_COMPLEMENTO' required='yes'>
		<cfargument name='DEST_BAIRRO' required='yes'>
		<cfargument name='DEST_CEP' required='yes'>
		<cfargument name='DEST_MUNICIPIO_ID' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
		<cfargument name='GERA_COLETA' required='no' default="0">
		<cfargument name='COLETA_COD_PESSOA' required='yes'>
		<cfargument name='ENTREGA_COD_PESSOA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_ctrl_carga.prc_ins_coleta' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_COLETA'  value='#arguments.NUM_COLETA#'  null='#iif(len(trim(arguments.NUM_COLETA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SERIE'  value='#arguments.SERIE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SUBSERIE'  value='#arguments.SUBSERIE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_FILIAL'  value='#arguments.COD_FILIAL#'  null='#iif(len(trim(arguments.COD_FILIAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_RESPONSAVEL'  value='#arguments.COD_RESPONSAVEL#'  null='#iif(len(trim(arguments.COD_RESPONSAVEL)), de('no'), de('yes'))#'>
					
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_CONFIRMACAO'  value='#arguments.DATA_CONFIRMACAO#' null='#iif(len(trim(arguments.DATA_CONFIRMACAO)), de('no'), de('yes'))#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_EMPRESA'  value='#arguments.COD_EMPRESA#'  null='#iif(len(trim(arguments.COD_EMPRESA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_SOLICITANTE'  value='#arguments.COD_SOLICITANTE#'  null='#iif(len(trim(arguments.COD_SOLICITANTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUM_PEDIDO'  value='#arguments.NUM_PEDIDO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_PEDIDO'  value="#DateFormat(Now(),'dd/mm/yyyy')# #TimeFormat(Now(),'HH:MM:SS')#" >
					
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PRAZO_RETIRADA'  value='#arguments.PRAZO_RETIRADA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REM_COD_PESSOA'  value='#arguments.REM_COD_PESSOA#'  null='#iif(len(trim(arguments.REM_COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_LOGRADOURO'  value='#arguments.REM_LOGRADOURO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_COMPLEMENTO'  value='#arguments.REM_COMPLEMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_BAIRRO'  value='#arguments.REM_BAIRRO#' >
					
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_CEP'  value='#arguments.REM_CEP#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REM_MUNICIPIO_ID'  value='#arguments.REM_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.REM_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DEST_COD_PESSOA'  value='#arguments.DEST_COD_PESSOA#'  null='#iif(len(trim(arguments.DEST_COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_LOGRADOURO'  value='#arguments.DEST_LOGRADOURO#' >
					
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_COMPLEMENTO'  value='#arguments.DEST_COMPLEMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_BAIRRO'  value='#arguments.DEST_BAIRRO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_CEP'  value='#arguments.DEST_CEP#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DEST_MUNICIPIO_ID'  value='#arguments.DEST_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.DEST_MUNICIPIO_ID)), de('no'), de('yes'))#'>

					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_LOGRADOURO'  value='#arguments.COLETA_LOGRADOURO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_COMPLEMENTO'  value='#arguments.COLETA_COMPLEMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_BAIRRO'  value='#arguments.COLETA_BAIRRO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_CEP'  value='#arguments.COLETA_CEP#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COLETA_MUNICIPIO_ID'  value='#arguments.COLETA_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.COLETA_MUNICIPIO_ID)), de('no'), de('yes'))#'>

					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_LOGRADOURO'  value='#arguments.ENTREGA_LOGRADOURO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_COMPLEMENTO'  value='#arguments.ENTREGA_COMPLEMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_BAIRRO'  value='#arguments.ENTREGA_BAIRRO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_CEP'  value='#arguments.ENTREGA_CEP#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENTREGA_MUNICIPIO_ID'  value='#arguments.ENTREGA_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.ENTREGA_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COLETA_ID' variable='retorno.COLETA_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COLETA_COD_PESSOA'  value='#arguments.COLETA_COD_PESSOA#'  null='#iif(len(trim(arguments.COLETA_COD_PESSOA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENTREGA_COD_PESSOA'  value='#arguments.ENTREGA_COD_PESSOA#'  null='#iif(len(trim(arguments.ENTREGA_COD_PESSOA)), de('no'), de('yes'))#'>
				</cfstoredproc>
				
                <!---Verifica o Tipo de Documento que vai ser vinculado--->
                <cfswitch expression="#arguments.tipo_documento_id#">
                    <cfcase value="0">
                        <!--- Insere Notas fiscais --->
                        <cfscript>
                            v_numero 	         = this.ListaToArray(lista = arguments, variavel = "NOTA_NUMERO_NOTAS_FISCAIS");
                            v_data_emissao       = this.ListaToArray(lista = arguments, variavel = "NOTA_DATA_EMISSAO_NOTAS_FISCAIS");
                            v_serie 	         = this.ListaToArray(lista = arguments, variavel = "NOTA_SERIE_NOTAS_FISCAIS");
                            v_sub_serie          = this.ListaToArray(lista = arguments, variavel = "NOTA_SUB_SERIE_NOTAS_FISCAIS");
                            v_modelo             = this.ListaToArray(lista = arguments, variavel = "NOTA_MODELO_NOTAS_FISCAIS");
                            v_valor		         = this.ListaToArray(lista = arguments, variavel = "NOTA_VALOR_NOTAS_FISCAIS");
                            v_valor_segurado     = this.ListaToArray(lista = arguments, variavel = "NOTA_VALOR_SEGURADO_NOTAS_FISCAIS");
                            v_peso               = this.ListaToArray(lista = arguments, variavel = "NOTA_PESO_NOTAS_FISCAIS");
                            v_peso_cobrado       = this.ListaToArray(lista = arguments, variavel = 'NOTA_PESO_COBRADO_NOTAS_FISCAIS');
                            v_ordem_compra       = this.ListaToArray(lista = arguments, variavel = "NOTA_ORDEM_COMPRA_NOTAS_FISCAIS");
                            v_qtde_volume        = this.ListaToArray(lista = arguments, variavel = 'NOTA_QTDE_VOLUME_NOTAS_FISCAIS');
                            v_cod_unidade        = this.ListaToArray(lista = arguments, variavel = 'NOTA_COD_UNIDADE_NOTAS_FISCAIS');
                            v_m3                 = this.ListaToArray(lista = arguments, variavel = 'NOTA_M3_NOTAS_FISCAIS');
                            v_peso_cubado        = this.ListaToArray(lista = arguments, variavel = 'NOTA_PESO_CUBADO_NOTAS_FISCAIS');
                            v_num_natureza       = this.ListaToArray(lista = arguments, variavel = 'NOTA_NUM_NATUREZA_NOTAS_FISCAIS');
                            v_complemento        = this.ListaToArray(lista = arguments, variavel = 'NOTA_COMPLEMENTO_NOTAS_FISCAIS');
                            v_num_especie        = this.ListaToArray(lista = arguments, variavel = 'NOTA_NUM_ESPECIE_NOTAS_FISCAIS');
                            v_altura             = this.ListaToArray(lista = arguments, variavel = 'NOTA_ALTURA_NOTAS_FISCAIS');
                            v_largura            = this.ListaToArray(lista = arguments, variavel = 'NOTA_LARGURA_NOTAS_FISCAIS');
                            v_comprimento        = this.ListaToArray(lista = arguments, variavel = 'NOTA_COMPRIMENTO_NOTAS_FISCAIS');
                            v_cubagem            = this.ListaToArray(lista = arguments, variavel = 'NOTA_CUBAGEM_NOTAS_FISCAIS');
                            v_cfop				 = this.ListaToArray(lista = arguments, variavel = 'NOTA_CFOP_NOTAS_FISCAIS');
                        </cfscript>
                        
                        <cfloop from="1" to="#ArrayLen(v_numero)#" index="count">
                            <cfscript>
                               ret_nf =  this.ins_coleta_item(coleta_id		 = retorno.COLETA_ID,
															 num_natureza	 = v_num_natureza[count],
															 complemento	 = v_complemento[count],
															 nf_numero 		 = v_numero[count],
															 nf_modelo 		 = v_modelo[count],
															 nf_serie 		 = v_serie[count],
															 nf_sub_serie 	 = v_sub_serie[count],
															 nf_data_emissao = v_data_emissao[count],
															 nf_valor	 	 = v_valor[count],
															 valor_segurado  = v_valor_segurado[count],
															 peso_kg	 	 = v_peso[count],
															 peso_cubado_kg	 = v_peso_cubado[count],
															 peso_cobrado_kg = v_peso_cobrado[count],
															 qtde_volume	 = v_qtde_volume[count],
															 altura			 = v_altura[count],
															 comprimento	 = v_comprimento[count],
															 largura		 = v_largura[count],
															 m3		 		 = v_m3[count],
															 cubagem		 = v_cubagem[count],
															 ordem_compra	 = v_ordem_compra[count],
															 cod_unidade	 = v_cod_unidade[count],
															 num_especie	 = v_num_especie[count],
															 cfop		     = v_cfop[count],
															 chave_acesso_nfe  = '',
															 nfe_xml		   = '',
															 tipo_documento_id = arguments.tipo_documento_id);
								
                            </cfscript>
                            <cfif ret_nf.erro>
                                <cfthrow object="#ret_nf.mensagem#">
                            </cfif>
                        </cfloop>
                    </cfcase>
                    
                    <cfcase value="1">
                        <!--- Insere NFE --->
                        <cfscript>
                            v_chave_acesso_nfe		= this.ListaToArray (lista = arguments, variavel = "CHAVE_ACESSO_NFE_NFE");
                            v_nfe_valor				= this.ListaToArray (lista = arguments, variavel = "NFE_VALOR_NFE");
                            v_nome_arquivo			= this.ListaToArray (lista = arguments, variavel = "NOME_ARQUIVO_NFE");
                            v_data_emissao			= this.ListaToArray (lista = arguments, variavel = "DATA_EMISSAO_NFE");
                            v_numero				= this.ListaToArray (lista = arguments, variavel = "NUMERO_NFE");
                            v_modelo				= this.ListaToArray (lista = arguments, variavel = "MODELO_NFE");
                            v_serie					= this.ListaToArray (lista = arguments, variavel = "SERIE_NFE");
                            v_documento_id			= this.ListaToArray (lista = arguments, variavel = "NFE_DOCUMENTO_ID_NFE");
							v_peso                  = this.ListaToArray (lista = arguments, variavel = "NFE_PESO_NFE");
                            v_peso_cobrado          = this.ListaToArray (lista = arguments, variavel = 'NFE_PESO_COBRADO_NFE');
                            v_ordem_compra          = this.ListaToArray (lista = arguments, variavel = "NFE_ORDEM_COMPRA_NFE");
                            v_qtde_volume           = this.ListaToArray (lista = arguments, variavel = 'NFE_QTDE_VOLUME_NFE');
                            v_cod_unidade           = this.ListaToArray (lista = arguments, variavel = 'NFE_COD_UNIDADE_NFE');
                            v_m3                    = this.ListaToArray (lista = arguments, variavel = 'NFE_M3_NFE');
                            v_peso_cubado           = this.ListaToArray (lista = arguments, variavel = 'NFE_PESO_CUBADO_NFE');
                            v_num_natureza          = this.ListaToArray (lista = arguments, variavel = 'NFE_NUM_NATUREZA_NFE');
                            v_complemento           = this.ListaToArray (lista = arguments, variavel = 'NFE_COMPLEMENTO_NFE');
                            v_num_especie           = this.ListaToArray (lista = arguments, variavel = 'NFE_NUM_ESPECIE_NFE');
                            v_altura                = this.ListaToArray (lista = arguments, variavel = 'NFE_ALTURA_NFE');
                            v_largura               = this.ListaToArray (lista = arguments, variavel = 'NFE_LARGURA_NFE');
                            v_comprimento           = this.ListaToArray (lista = arguments, variavel = 'NFE_COMPRIMENTO_NFE');
                            v_cubagem               = this.ListaToArray (lista = arguments, variavel = 'NFE_CUBAGEM_NFE');
                            
                        </cfscript>
                        
                        <cfloop from="1" to="#ArrayLen(v_chave_acesso_nfe)#" index="count">
                            <!--- Busca arquivo --->
                            <cfif Len(Trim(v_nome_arquivo[count]))>
                                <cffile action="read" file="#expandPath("/")#temp/#v_nome_arquivo[count]#" variable="VARQUIVO">
                            <cfelse>
                                <cfset VARQUIVO = ''>
                            </cfif>
                            
                            <cfscript>
                                ret_nfe =  this.ins_coleta_item(coleta_id		= retorno.COLETA_ID,
															   num_natureza	 	= v_num_natureza[count],
															   complemento	 	= v_complemento[count],
															   nf_numero 		= v_numero[count],
															   nf_modelo 		= v_modelo[count],
															   nf_serie 		= v_serie[count],
															   nf_sub_serie 	= '1',
															   nf_data_emissao 	= v_data_emissao[count],
															   nf_valor	 	 	= v_nfe_valor[count],
															   valor_segurado  	= v_nfe_valor[count],
															   peso_kg	 	 	= v_peso[count],
															   peso_cubado_kg	= v_peso_cubado[count],
															   peso_cobrado_kg 	= v_peso_cobrado[count],
															   qtde_volume	 	= v_qtde_volume[count],
															   altura			= v_altura[count],
															   comprimento	 	= v_comprimento[count],
															   largura		 	= v_largura[count],
															   m3		 		= v_m3[count],
															   cubagem		 	= v_cubagem[count],
															   ordem_compra	 	= v_ordem_compra[count],
															   cod_unidade	 	= v_cod_unidade[count],
															   num_especie	 	= v_num_especie[count],
															   cfop		     	= '',
															   chave_acesso_nfe = v_chave_acesso_nfe[count],
															   nfe_xml		   	= VARQUIVO,
															   tipo_documento_id = arguments.tipo_documento_id);							
								
                            </cfscript>
                            <cfif ret_nfe.erro>
                                <cfthrow object="#ret_nfe.mensagem#">
                            </cfif>
                        </cfloop>
                    </cfcase>
                    
                    <cfcase value="2">
                        <!--- Insere Outros Documentos--->
                        <cfscript>
                            v_outros_numero			= this.ListaToArray (lista = arguments, variavel = "OUTROS_NUMERO_OUTROS");
                            v_outros_data_emissao	= this.ListaToArray (lista = arguments, variavel = "OUTROS_DATA_EMISSAO_OUTROS");
                            v_outros_descricao		= this.ListaToArray (lista = arguments, variavel = "OUTROS_DESCRICAO_OUTROS");
                            v_outros_valor			= this.ListaToArray (lista = arguments, variavel = "OUTROS_VALOR_OUTROS");
                            v_peso                  = this.ListaToArray (lista = arguments, variavel = "OUTROS_PESO_OUTROS");
                            v_peso_cobrado          = this.ListaToArray (lista = arguments, variavel = 'OUTROS_PESO_COBRADO_OUTROS');
                            v_qtde_volume           = this.ListaToArray (lista = arguments, variavel = 'OUTROS_QTDE_VOLUME_OUTROS');
                            v_cod_unidade           = this.ListaToArray (lista = arguments, variavel = 'OUTROS_COD_UNIDADE_OUTROS');
                            v_m3                    = this.ListaToArray (lista = arguments, variavel = 'OUTROS_M3_OUTROS');
                            v_peso_cubado           = this.ListaToArray (lista = arguments, variavel = 'OUTROS_PESO_CUBADO_OUTROS');
                            v_num_natureza          = this.ListaToArray (lista = arguments, variavel = 'OUTROS_NUM_NATUREZA_OUTROS');
                            v_complemento           = this.ListaToArray (lista = arguments, variavel = 'OUTROS_COMPLEMENTO_OUTROS');
                            v_num_especie           = this.ListaToArray (lista = arguments, variavel = 'OUTROS_NUM_ESPECIE_OUTROS');
                            v_altura                = this.ListaToArray (lista = arguments, variavel = 'OUTROS_ALTURA_OUTROS');
                            v_largura               = this.ListaToArray (lista = arguments, variavel = 'OUTROS_LARGURA_OUTROS');
                            v_comprimento           = this.ListaToArray (lista = arguments, variavel = 'OUTROS_COMPRIMENTO_OUTROS');
                            v_cubagem               = this.ListaToArray (lista = arguments, variavel = 'OUTROS_CUBAGEM_OUTROS');
                        </cfscript>
                        
                        <cfloop from="1" to="#ArrayLen(v_outros_numero)#" index="count">
                            <cfscript>
                                outros =  this.ins_coleta_item(coleta_id		= retorno.COLETA_ID,
															   num_natureza	 	= v_num_natureza[count],
															   complemento	 	= v_complemento[count],
															   nf_numero 		= v_outros_numero[count],
															   nf_modelo 		= '01',
															   nf_serie 		= 'U',
															   nf_sub_serie 	= '1',
															   nf_data_emissao 	= v_outros_data_emissao[count],
															   nf_valor	 	 	= v_outros_valor[count],
															   valor_segurado  	= v_outros_valor[count],
															   peso_kg	 	 	= v_peso[count],
															   peso_cubado_kg	= v_peso_cubado[count],
															   peso_cobrado_kg 	= v_peso_cobrado[count],
															   qtde_volume	 	= v_qtde_volume[count],
															   altura			= v_altura[count],
															   comprimento	 	= v_comprimento[count],
															   largura		 	= v_largura[count],
															   m3		 		= v_m3[count],
															   cubagem		 	= v_cubagem[count],
															   ordem_compra	 	= '',
															   cod_unidade	 	= v_cod_unidade[count],
															   num_especie	 	= v_num_especie[count],
															   cfop		     	= '',
															   chave_acesso_nfe = '',
															   nfe_xml		   	= '',
															   tipo_documento_id = arguments.tipo_documento_id,
															   descricao_docto	 = v_outros_descricao[count]);
								
                            </cfscript>
                            <cfif outros.erro>
                                <cfthrow object="#outros.mensagem#">
                            </cfif>
                        </cfloop>
                    </cfcase>                
                </cfswitch>
                
				<cfif arguments.GERA_COLETA eq 1>
						<cfstoredproc procedure='oper.pkg_ctrl_carga.prc_gerar_ordem_coleta' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
							<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COLETA_ID'  value='#retorno.COLETA_ID#'  null='#iif(len(trim(retorno.COLETA_ID)), de('no'), de('yes'))#'>
							<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_COLETA'  value='#arguments.NUM_COLETA#'  null='#iif(len(trim(arguments.NUM_COLETA)), de('no'), de('yes'))#'>
							<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SERIE'  value='#arguments.SERIE#' >
							<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SUBSERIE'  value='#arguments.SUBSERIE#' >
							<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
						</cfstoredproc>

						<cfscript>
						/*ret_ag = this.ins_agendamento(coleta_id 		   = retorno.coleta_id
													 ,cod_agendamento   = session.COD_PESSOA_USUARIO
													 ,data_agendamento  = LSDateFormat(Now(),'dd/mm/yyyy') & " " & LSTimeFormat(Now(),'HH:MM')
													 ,placa			   = Replace(arguments.placa,"-","","ALL")
													 ,cod_motorista	   = arguments.cod_motorista
													 ,data_coleta	   = arguments.data_coleta
													 ,situacao_id	   = 2
													 ,num_coleta		   = arguments.num_coleta
													 ,serie			   = arguments.serie
													 ,subserie		   = arguments.subserie
													 );*/
						 if(Len(Trim(arguments.placa))){
							ret_sit = this.ins_agendamento(coleta_id 	    = retorno.coleta_id
														  ,cod_agendamento  = session.COD_PESSOA_USUARIO
														  ,data_agendamento = LSDateFormat(Now(),'dd/mm/yyyy') & " " & LSTimeFormat(Now(),'HH:MM')
														  ,placa			= Replace(arguments.placa,"-","","ALL")
														  ,cod_motorista	= arguments.cod_motorista
														  ,data_coleta	    = arguments.data_coleta
														  ,situacao_id	    = 2
														  ,num_coleta	    = arguments.num_coleta
														  ,serie			= arguments.serie
														  ,subserie		    = arguments.subserie
														  );
						 }else{
							ret_sit = this.cancela_agendamento(coleta_id 		 = retorno.coleta_id
															  ,cod_cancelamento  = session.COD_PESSOA_USUARIO
															  ,data_cancelamento = LSDateFormat(Now(),'dd/mm/yyyy') & " " & LSTimeFormat(Now(),'HH:MM')
															  );
						 }									
						</cfscript>	
                        <cfif ret_sit.erro>
                            <cfthrow object="#ret_sit.mensagem#">
                        </cfif>					
				</cfif>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Coleta inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera solicitao de coleta.
	-- wagner 18/10/2006 20:45:25 - CRIADO
	--->
	<cffunction name='upd_coleta' displayname='Altera solicitao de coleta.' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_COLETA' required='yes'>
		<cfargument name='SERIE' required='yes'>
		<cfargument name='SUBSERIE' required='yes'>
		<cfargument name='COD_FILIAL' required='yes'>
		<cfargument name='COD_RESPONSAVEL' required='yes'>
		<cfargument name='DATA_CONFIRMACAO' required='yes'>
		<cfargument name='COD_EMPRESA' required='yes'>
		<cfargument name='COD_SOLICITANTE' required='yes'>
		<cfargument name='NUM_PEDIDO' required='yes'>
		<cfargument name='PRAZO_RETIRADA' required='yes'>
		<cfargument name='REM_COD_PESSOA' required='yes'>
		<cfargument name='REM_LOGRADOURO' required='yes'>
		<cfargument name='REM_COMPLEMENTO' required='yes'>
		<cfargument name='REM_BAIRRO' required='yes'>
		<cfargument name='REM_CEP' required='yes'>
		<cfargument name='REM_MUNICIPIO_ID' required='yes'>
		<cfargument name='DEST_COD_PESSOA' required='yes'>
		<cfargument name='DEST_LOGRADOURO' required='yes'>
		<cfargument name='DEST_COMPLEMENTO' required='yes'>
		<cfargument name='DEST_BAIRRO' required='yes'>
		<cfargument name='DEST_CEP' required='yes'>
		<cfargument name='DEST_MUNICIPIO_ID' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_ctrl_carga.prc_alt_coleta' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_COLETA'  value='#arguments.NUM_COLETA#'  null='#iif(len(trim(arguments.NUM_COLETA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SERIE'  value='#arguments.SERIE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SUBSERIE'  value='#arguments.SUBSERIE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_FILIAL'  value='#arguments.COD_FILIAL#'  null='#iif(len(trim(arguments.COD_FILIAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_RESPONSAVEL'  value='#arguments.COD_RESPONSAVEL#'  null='#iif(len(trim(arguments.COD_RESPONSAVEL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_CONFIRMACAO'  value='#arguments.DATA_CONFIRMACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_EMPRESA'  value='#arguments.COD_EMPRESA#'  null='#iif(len(trim(arguments.COD_EMPRESA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_SOLICITANTE'  value='#arguments.COD_SOLICITANTE#'  null='#iif(len(trim(arguments.COD_SOLICITANTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUM_PEDIDO'  value='#arguments.NUM_PEDIDO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PRAZO_RETIRADA'  value='#arguments.PRAZO_RETIRADA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REM_COD_PESSOA'  value='#arguments.REM_COD_PESSOA#'  null='#iif(len(trim(arguments.REM_COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_LOGRADOURO'  value='#arguments.REM_LOGRADOURO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_COMPLEMENTO'  value='#arguments.REM_COMPLEMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_BAIRRO'  value='#arguments.REM_BAIRRO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_CEP'  value='#arguments.REM_CEP#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REM_MUNICIPIO_ID'  value='#arguments.REM_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.REM_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DEST_COD_PESSOA'  value='#arguments.DEST_COD_PESSOA#'  null='#iif(len(trim(arguments.DEST_COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_LOGRADOURO'  value='#arguments.DEST_LOGRADOURO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_COMPLEMENTO'  value='#arguments.DEST_COMPLEMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_BAIRRO'  value='#arguments.DEST_BAIRRO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_CEP'  value='#arguments.DEST_CEP#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DEST_MUNICIPIO_ID'  value='#arguments.DEST_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.DEST_MUNICIPIO_ID)), de('no'), de('yes'))#'>


					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_LOGRADOURO'  value='#arguments.COLETA_LOGRADOURO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_COMPLEMENTO'  value='#arguments.COLETA_COMPLEMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_BAIRRO'  value='#arguments.COLETA_BAIRRO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_CEP'  value='#arguments.COLETA_CEP#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COLETA_MUNICIPIO_ID'  value='#arguments.COLETA_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.COLETA_MUNICIPIO_ID)), de('no'), de('yes'))#'>

					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_LOGRADOURO'  value='#arguments.ENTREGA_LOGRADOURO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_COMPLEMENTO'  value='#arguments.ENTREGA_COMPLEMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_BAIRRO'  value='#arguments.ENTREGA_BAIRRO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_CEP'  value='#arguments.ENTREGA_CEP#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENTREGA_MUNICIPIO_ID'  value='#arguments.ENTREGA_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.ENTREGA_MUNICIPIO_ID)), de('no'), de('yes'))#'>

					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COLETA_ID'  value='#arguments.COLETA_ID#' variable='retorno.COLETA_ID'  null='#iif(len(trim(arguments.COLETA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COLETA_COD_PESSOA'  value='#arguments.COLETA_COD_PESSOA#'  null='#iif(len(trim(arguments.COLETA_COD_PESSOA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENTREGA_COD_PESSOA'  value='#arguments.ENTREGA_COD_PESSOA#'  null='#iif(len(trim(arguments.ENTREGA_COD_PESSOA)), de('no'), de('yes'))#'>
				 </cfstoredproc>
				 
                 <!---Verifica o Tipo de Documento que vai ser vinculado--->
                <cfswitch expression="#arguments.tipo_documento_id#">
                    <cfcase value="0">
                        <!--- Insere Notas fiscais --->
                        <cfscript>
						v_coleta_item_id   	= this.ListaToArray (lista = arguments, variavel = "NOTA_COLETA_ITEM_ID_NOTAS_FISCAIS");
						v_numero 	         = this.ListaToArray(lista = arguments, variavel = "NOTA_NUMERO_NOTAS_FISCAIS");
						v_data_emissao       = this.ListaToArray(lista = arguments, variavel = "NOTA_DATA_EMISSAO_NOTAS_FISCAIS");
						v_serie 	         = this.ListaToArray(lista = arguments, variavel = "NOTA_SERIE_NOTAS_FISCAIS");
						v_sub_serie          = this.ListaToArray(lista = arguments, variavel = "NOTA_SUB_SERIE_NOTAS_FISCAIS");
						v_modelo             = this.ListaToArray(lista = arguments, variavel = "NOTA_MODELO_NOTAS_FISCAIS");
						v_nf_valor			 = this.ListaToArray(lista = arguments, variavel = "NOTA_VALOR_NOTAS_FISCAIS");
						v_valor_segurado     = this.ListaToArray(lista = arguments, variavel = "NOTA_VALOR_SEGURADO_NOTAS_FISCAIS");
						v_peso               = this.ListaToArray(lista = arguments, variavel = "NOTA_PESO_NOTAS_FISCAIS");
						v_peso_cobrado       = this.ListaToArray(lista = arguments, variavel = 'NOTA_PESO_COBRADO_NOTAS_FISCAIS');
						v_ordem_compra       = this.ListaToArray(lista = arguments, variavel = "NOTA_ORDEM_COMPRA_NOTAS_FISCAIS");
						v_qtde_volume        = this.ListaToArray(lista = arguments, variavel = 'NOTA_QTDE_VOLUME_NOTAS_FISCAIS');
						v_cod_unidade        = this.ListaToArray(lista = arguments, variavel = 'NOTA_COD_UNIDADE_NOTAS_FISCAIS');
						v_m3                 = this.ListaToArray(lista = arguments, variavel = 'NOTA_M3_NOTAS_FISCAIS');
						v_peso_cubado        = this.ListaToArray(lista = arguments, variavel = 'NOTA_PESO_CUBADO_NOTAS_FISCAIS');
						v_num_natureza       = this.ListaToArray(lista = arguments, variavel = 'NOTA_NUM_NATUREZA_NOTAS_FISCAIS');
						v_complemento        = this.ListaToArray(lista = arguments, variavel = 'NOTA_COMPLEMENTO_NOTAS_FISCAIS');
						v_num_especie        = this.ListaToArray(lista = arguments, variavel = 'NOTA_NUM_ESPECIE_NOTAS_FISCAIS');
						v_altura             = this.ListaToArray(lista = arguments, variavel = 'NOTA_ALTURA_NOTAS_FISCAIS');
						v_largura            = this.ListaToArray(lista = arguments, variavel = 'NOTA_LARGURA_NOTAS_FISCAIS');
						v_comprimento        = this.ListaToArray(lista = arguments, variavel = 'NOTA_COMPRIMENTO_NOTAS_FISCAIS');
						v_cubagem            = this.ListaToArray(lista = arguments, variavel = 'NOTA_CUBAGEM_NOTAS_FISCAIS');
						v_cfop				 = this.ListaToArray(lista = arguments, variavel = 'NOTA_CFOP_NOTAS_FISCAIS');
						v_excluir			 = this.ListDiff(lista1 = arguments.lista_deleted_NOTAS_FISCAIS, lista2 = ArrayToList(v_coleta_item_id));
                        </cfscript>
						
                        <cfloop list="#v_excluir#" delimiters="," index="l_id">
							<cfscript>
								this.del_coleta_item(coleta_item_id = l_id);
							</cfscript>
						</cfloop>
						<cfloop from="1" to="#ArrayLen(v_num_natureza)#" index="count">
							
							<cfscript>
								if(Len(Trim(v_coleta_item_id[count]))){					
									ret_nf =    this.upd_coleta_item(coleta_item_id = v_coleta_item_id[count],
																	 coleta_id = retorno.COLETA_ID,
																	 num_natureza	 = v_num_natureza[count],
																	 complemento	 = v_complemento[count],
																	 nf_numero 		 = v_numero[count],
																	 nf_modelo 		 = v_modelo[count],
																	 nf_serie 		 = v_serie[count],
																	 nf_sub_serie 	 = v_sub_serie[count],
																	 nf_data_emissao = v_data_emissao[count],
																	 nf_valor	 	 = v_nf_valor[count],
																	 valor_segurado  = v_valor_segurado[count],
																	 peso_kg	 	 = v_peso[count],
																	 peso_cubado_kg	 = v_peso_cubado[count],
																	 peso_cobrado_kg = v_peso_cobrado[count],
																	 qtde_volume	 = v_qtde_volume[count],
																	 altura			 = v_altura[count],
																	 comprimento	 = v_comprimento[count],
																	 largura		 = v_largura[count],
																	 m3		 		 = v_M3[count],
																	 cubagem		 = v_cubagem[count],
																	 cod_unidade	 = v_cod_unidade[count],
																	 ordem_compra	 = v_ordem_compra[count],
																	 num_especie	 = v_num_especie[count],
																	 cfop		     = v_cfop[count],
																	 chave_acesso_nfe  = '',
																	 nfe_xml		   = '',
																	 tipo_documento_id = arguments.tipo_documento_id);
								}else{
									ret_nf =    this.ins_coleta_item(coleta_id = retorno.COLETA_ID,
																	 num_natureza	 = v_num_natureza[count],
																	 complemento	 = v_complemento[count],
																	 nf_numero 		 = v_numero[count],
																	 nf_modelo 		 = v_modelo[count],
																	 nf_serie 		 = v_serie[count],
																	 nf_sub_serie 	 = v_sub_serie[count],
																	 nf_data_emissao = v_data_emissao[count],
																	 nf_valor	 	 = v_nf_valor[count],
																	 valor_segurado  = v_valor_segurado[count],
																	 peso_kg	 	 = v_peso[count],
																	 peso_cubado_kg	 = v_peso_cubado[count],
																	 peso_cobrado_kg = v_peso_cobrado[count],
																	 qtde_volume	 = v_qtde_volume[count],
																	 altura			 = v_altura[count],
																	 comprimento	 = v_comprimento[count],
																	 largura		 = v_largura[count],
																	 M3		 		 = v_M3[count],
																	 cubagem		 = v_cubagem[count],
																	 coleta_item_id = v_coleta_item_id[count],
																	 cod_unidade	 = v_cod_unidade[count],
																	 ordem_compra	 = v_ordem_compra[count],
																	 num_especie	 = v_num_especie[count],
																	 cfop		     = v_cfop[count],
																	 chave_acesso_nfe  = '',
																	 nfe_xml		   = '',
																	 tipo_documento_id = arguments.tipo_documento_id);
								
								} 
							</cfscript>
							<cfif ret_nf.erro>
								<cfthrow object="#ret_nf.mensagem#">
							</cfif>
						</cfloop>						
                    </cfcase>
                    
                    <cfcase value="1">
                        <!--- Insere NFE --->
                        <cfscript>
                            v_coleta_item_id   		= this.ListaToArray (lista = arguments, variavel = "NFE_COLETA_ITEM_ID_NFE");
							v_chave_acesso_nfe		= this.ListaToArray (lista = arguments, variavel = "CHAVE_ACESSO_NFE_NFE");
                            v_nfe_valor				= this.ListaToArray (lista = arguments, variavel = "NFE_VALOR_NFE");
                            v_nome_arquivo			= this.ListaToArray (lista = arguments, variavel = "NOME_ARQUIVO_NFE");
                            v_data_emissao			= this.ListaToArray (lista = arguments, variavel = "DATA_EMISSAO_NFE");
                            v_numero				= this.ListaToArray (lista = arguments, variavel = "NUMERO_NFE");
                            v_modelo				= this.ListaToArray (lista = arguments, variavel = "MODELO_NFE");
                            v_serie					= this.ListaToArray (lista = arguments, variavel = "SERIE_NFE");
                            v_documento_id			= this.ListaToArray (lista = arguments, variavel = "NFE_DOCUMENTO_ID_NFE");
							v_peso                  = this.ListaToArray (lista = arguments, variavel = "NFE_PESO_NFE");
                            v_peso_cobrado          = this.ListaToArray (lista = arguments, variavel = 'NFE_PESO_COBRADO_NFE');
                            v_ordem_compra          = this.ListaToArray (lista = arguments, variavel = "NFE_ORDEM_COMPRA_NFE");
                            v_qtde_volume           = this.ListaToArray (lista = arguments, variavel = 'NFE_QTDE_VOLUME_NFE');
                            v_cod_unidade           = this.ListaToArray (lista = arguments, variavel = 'NFE_COD_UNIDADE_NFE');
                            v_m3                    = this.ListaToArray (lista = arguments, variavel = 'NFE_M3_NFE');
                            v_peso_cubado           = this.ListaToArray (lista = arguments, variavel = 'NFE_PESO_CUBADO_NFE');
                            v_num_natureza          = this.ListaToArray (lista = arguments, variavel = 'NFE_NUM_NATUREZA_NFE');
                            v_complemento           = this.ListaToArray (lista = arguments, variavel = 'NFE_COMPLEMENTO_NFE');
                            v_num_especie           = this.ListaToArray (lista = arguments, variavel = 'NFE_NUM_ESPECIE_NFE');
                            v_altura                = this.ListaToArray (lista = arguments, variavel = 'NFE_ALTURA_NFE');
                            v_largura               = this.ListaToArray (lista = arguments, variavel = 'NFE_LARGURA_NFE');
                            v_comprimento           = this.ListaToArray (lista = arguments, variavel = 'NFE_COMPRIMENTO_NFE');
                            v_cubagem               = this.ListaToArray (lista = arguments, variavel = 'NFE_CUBAGEM_NFE');
                            v_excluir				= this.ListDiff(lista1 = arguments.lista_deleted_NFE, lista2 = ArrayToList(v_coleta_item_id));
                        </cfscript>
						
                        <cfloop list="#v_excluir#" delimiters="," index="l_id">
							<cfscript>
								this.del_coleta_item(coleta_item_id = l_id);
							</cfscript>
						</cfloop>
                        
                        <cfloop from="1" to="#ArrayLen(v_chave_acesso_nfe)#" index="count">
                            <!--- Busca arquivo --->
                            <cfif Len(Trim(v_nome_arquivo[count])) and not Len(Trim(v_coleta_item_id[count]))>
                                <cffile action="read" file="#expandPath("/")#temp/#v_nome_arquivo[count]#" variable="VARQUIVO">
                            <cfelse>
                                <cfset VARQUIVO = ''>
                            </cfif>
                            
                            <cfscript>
                                if(Len(Trim(v_coleta_item_id[count]))){					
									ret_nfe =  this.upd_coleta_item(coleta_item_id = v_coleta_item_id[count],
																	coleta_id		= retorno.COLETA_ID,
																	num_natureza	= v_num_natureza[count],
																	complemento	 	= v_complemento[count],
																	nf_numero 		= v_numero[count],
																	nf_modelo 		= v_modelo[count],
																	nf_serie 		= v_serie[count],
																	nf_sub_serie 	= 1,
																	nf_data_emissao = v_data_emissao[count],
																	nf_valor	 	= v_nfe_valor[count],
																	valor_segurado  = v_nfe_valor[count],
																	peso_kg	 	 	= v_peso[count],
																	peso_cubado_kg	= v_peso_cubado[count],
																	peso_cobrado_kg = v_peso_cobrado[count],
																	qtde_volume	 	= v_qtde_volume[count],
																	altura			= v_altura[count],
																	comprimento	 	= v_comprimento[count],
																	largura		 	= v_largura[count],
																	M3		 		= v_M3[count],
																	cubagem		 	= v_cubagem[count],
																	ordem_compra	= v_ordem_compra[count],
																	cod_unidade	 	= v_cod_unidade[count],
																	num_especie	 	= v_num_especie[count],
																	cfop		    = '',
																	chave_acesso_nfe = v_chave_acesso_nfe[count],
																	tipo_documento_id = arguments.tipo_documento_id);
								}else{
									ret_nfe =  this.ins_coleta_item(coleta_id		= retorno.COLETA_ID,
																	num_natureza	= v_num_natureza[count],
																	complemento	 	= v_complemento[count],
																	nf_numero 		= v_numero[count],
																	nf_modelo 		= v_modelo[count],
																	nf_serie 		= v_serie[count],
																	nf_sub_serie 	= 1,
																	nf_data_emissao = v_data_emissao[count],
																	nf_valor	 	= v_nfe_valor[count],
																	valor_segurado  = v_nfe_valor[count],
																	peso_kg	 	 	= v_peso[count],
																	peso_cubado_kg	= v_peso_cubado[count],
																	peso_cobrado_kg = v_peso_cobrado[count],
																	qtde_volume	 	= v_qtde_volume[count],
																	altura			= v_altura[count],
																	comprimento	 	= v_comprimento[count],
																	largura		 	= v_largura[count],
																	M3		 		= v_M3[count],
																	cubagem		 	= v_cubagem[count],
																	ordem_compra	= v_ordem_compra[count],
																	cod_unidade	 	= v_cod_unidade[count],
																	num_especie	 	= v_num_especie[count],
																	cfop		    = '',
																	chave_acesso_nfe = v_chave_acesso_nfe[count],
																	nfe_xml		   	= VARQUIVO,
																	tipo_documento_id = arguments.tipo_documento_id);
								
								} 					
								
                            </cfscript>
                            <cfif ret_nfe.erro>
                                <cfthrow object="#ret_nfe.mensagem#">
                            </cfif>
                        </cfloop>
                    </cfcase>
                    
                    <cfcase value="2">
                        <!--- Insere Outros Documentos--->
                        <cfscript>
                            v_coleta_item_id   		= this.ListaToArray (lista = arguments, variavel = "OUTROS_COLETA_ITEM_ID_OUTROS");
							v_outros_numero			= this.ListaToArray (lista = arguments, variavel = "OUTROS_NUMERO_OUTROS");
                            v_outros_data_emissao	= this.ListaToArray (lista = arguments, variavel = "OUTROS_DATA_EMISSAO_OUTROS");
                            v_outros_descricao		= this.ListaToArray (lista = arguments, variavel = "OUTROS_DESCRICAO_OUTROS");
                            v_outros_valor			= this.ListaToArray (lista = arguments, variavel = "OUTROS_VALOR_OUTROS");
                            v_peso                  = this.ListaToArray (lista = arguments, variavel = "OUTROS_PESO_OUTROS");
                            v_peso_cobrado          = this.ListaToArray (lista = arguments, variavel = 'OUTROS_PESO_COBRADO_OUTROS');
                            v_qtde_volume           = this.ListaToArray (lista = arguments, variavel = 'OUTROS_QTDE_VOLUME_OUTROS');
                            v_cod_unidade           = this.ListaToArray (lista = arguments, variavel = 'OUTROS_COD_UNIDADE_OUTROS');
                            v_m3                    = this.ListaToArray (lista = arguments, variavel = 'OUTROS_M3_OUTROS');
                            v_peso_cubado           = this.ListaToArray (lista = arguments, variavel = 'OUTROS_PESO_CUBADO_OUTROS');
                            v_num_natureza          = this.ListaToArray (lista = arguments, variavel = 'OUTROS_NUM_NATUREZA_OUTROS');
                            v_complemento           = this.ListaToArray (lista = arguments, variavel = 'OUTROS_COMPLEMENTO_OUTROS');
                            v_num_especie           = this.ListaToArray (lista = arguments, variavel = 'OUTROS_NUM_ESPECIE_OUTROS');
                            v_altura                = this.ListaToArray (lista = arguments, variavel = 'OUTROS_ALTURA_OUTROS');
                            v_largura               = this.ListaToArray (lista = arguments, variavel = 'OUTROS_LARGURA_OUTROS');
                            v_comprimento           = this.ListaToArray (lista = arguments, variavel = 'OUTROS_COMPRIMENTO_OUTROS');
                            v_cubagem               = this.ListaToArray (lista = arguments, variavel = 'OUTROS_CUBAGEM_OUTROS');
                        	v_excluir				= this.ListDiff(lista1 = arguments.lista_deleted_OUTROS, lista2 = ArrayToList(v_coleta_item_id));
                        </cfscript>
						
                        <cfloop list="#v_excluir#" delimiters="," index="l_id">
							<cfscript>
								this.del_coleta_item(coleta_item_id = l_id);
							</cfscript>
						</cfloop>
                        
                        <cfloop from="1" to="#ArrayLen(v_outros_numero)#" index="count">
                            <cfscript>
                                if(Len(Trim(v_coleta_item_id[count]))){
									outros =  this.upd_coleta_item(coleta_item_id   = v_coleta_item_id[count],
																   coleta_id		= retorno.COLETA_ID,
																   num_natureza	 	= v_num_natureza[count],
																   complemento	 	= v_complemento[count],
																   nf_numero 		= v_outros_numero[count],
																   nf_modelo 		= '01',
																   nf_serie 		= 'U',
																   nf_sub_serie 	= '1',
																   nf_data_emissao 	= v_outros_data_emissao[count],
																   nf_valor	 	 	= v_outros_valor[count],
																   valor_segurado  	= v_outros_valor[count],
																   peso_kg	 	 	= v_peso[count],
																   peso_cubado_kg	= v_peso_cubado[count],
																   peso_cobrado_kg 	= v_peso_cobrado[count],
																   qtde_volume	 	= v_qtde_volume[count],
																   altura			= v_altura[count],
																   comprimento	 	= v_comprimento[count],
																   largura		 	= v_largura[count],
																   m3		 		= v_m3[count],
																   cubagem		 	= v_cubagem[count],
																   ordem_compra	 	= '',
																   cod_unidade	 	= v_cod_unidade[count],
																   num_especie	 	= v_num_especie[count],
																   cfop		     	= '',
																   chave_acesso_nfe = '',
																   nfe_xml		   	= '',
																   tipo_documento_id = arguments.tipo_documento_id,
																   descricao_docto	 = v_outros_descricao[count]);
								}else{
									outros =  this.ins_coleta_item(coleta_id		= retorno.COLETA_ID,
																   num_natureza	 	= v_num_natureza[count],
																   complemento	 	= v_complemento[count],
																   nf_numero 		= v_outros_numero[count],
																   nf_modelo 		= '01',
																   nf_serie 		= 'U',
																   nf_sub_serie 	= '1',
																   nf_data_emissao 	= v_outros_data_emissao[count],
																   nf_valor	 	 	= v_outros_valor[count],
																   valor_segurado  	= v_outros_valor[count],
																   peso_kg	 	 	= v_peso[count],
																   peso_cubado_kg	= v_peso_cubado[count],
																   peso_cobrado_kg 	= v_peso_cobrado[count],
																   qtde_volume	 	= v_qtde_volume[count],
																   altura			= v_altura[count],
																   comprimento	 	= v_comprimento[count],
																   largura		 	= v_largura[count],
																   m3		 		= v_m3[count],
																   cubagem		 	= v_cubagem[count],
																   ordem_compra	 	= '',
																   cod_unidade	 	= v_cod_unidade[count],
																   num_especie	 	= v_num_especie[count],
																   cfop		     	= '',
																   chave_acesso_nfe = '',
																   nfe_xml		   	= '',
																   tipo_documento_id = arguments.tipo_documento_id,
																   descricao_docto	 = v_outros_descricao[count]);
								}
								
                            </cfscript>
                            <cfif outros.erro>
                                <cfthrow object="#outros.mensagem#">
                            </cfif>
                        </cfloop>
                    </cfcase>                
                </cfswitch>
				
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Coleta alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere solicitao de coleta.
	-- wagner 18/10/2006 20:47:18 - CRIADO
	--->
	<cffunction name='ins_coleta_item' displayname='Insere solicitao de coleta.' access='remote' returntype='Struct' output='true'>
		<cfargument name='COLETA_ID' required='yes'>
		<cfargument name='NUM_NATUREZA' required='yes'>
		<cfargument name='COMPLEMENTO' required='yes'>
		<cfargument name='NF_NUMERO' required='yes'>
		<cfargument name='NF_MODELO' required='yes'>
		<cfargument name='NF_SERIE' required='yes'>
		<cfargument name='NF_SUB_SERIE' required='yes'>
		<cfargument name='NF_DATA_EMISSAO' required='yes'>
		<cfargument name='NF_VALOR' required='yes'>
		<cfargument name='VALOR_SEGURADO' required='yes'>
		<cfargument name='PESO_KG' required='yes'>
		<cfargument name='PESO_CUBADO_KG' required='yes'>
		<cfargument name='PESO_COBRADO_KG' required='yes'>
		<cfargument name='QTDE_VOLUME' required='yes'>
		<cfargument name='ALTURA' required='yes'>
		<cfargument name='COMPRIMENTO' required='yes'>
		<cfargument name='LARGURA' required='yes'>
		<cfargument name='M3' required='yes'>
		<cfargument name='CUBAGEM' required='yes'>
		<cfargument name='COD_UNIDADE' required='yes'>
		<cfargument name='NUM_ESPECIE' required='yes'>
		<cfargument name='ORDEM_COMPRA' required='yes'>
        <cfargument name='CFOP' required='yes'>
        <cfargument name='CHAVE_ACESSO_NFE' required='yes'>
        <cfargument name='NFE_XML' required='yes'>
        <cfargument name='TIPO_DOCUMENTO_ID' required='yes'>
		<cfargument name='DESCRICAO_DOCTO' required='no' default=''>	
			<cftry>
				<cfstoredproc procedure='oper.pkg_ctrl_carga.prc_ins_coleta_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COLETA_ID'  value='#arguments.COLETA_ID#'  null='#iif(len(trim(arguments.COLETA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NATUREZA'  value='#arguments.NUM_NATUREZA#'  null='#iif(len(trim(arguments.NUM_NATUREZA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMPLEMENTO'  value='#arguments.COMPLEMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NF_NUMERO'  value='#arguments.NF_NUMERO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NF_MODELO'  value='#arguments.NF_MODELO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NF_SERIE'  value='#arguments.NF_SERIE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NF_SUB_SERIE'  value='#arguments.NF_SUB_SERIE#' >
					
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NF_DATA_EMISSAO'  value='#arguments.NF_DATA_EMISSAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NF_VALOR'  value='#arguments.NF_VALOR#'  null='#iif(len(trim(arguments.NF_VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_SEGURADO'  value='#arguments.VALOR_SEGURADO#'  null='#iif(len(trim(arguments.VALOR_SEGURADO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PESO_KG'  value='#arguments.PESO_KG#'  null='#iif(len(trim(arguments.PESO_KG)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PESO_CUBADO_KG'  value='#arguments.PESO_CUBADO_KG#'  null='#iif(len(trim(arguments.PESO_CUBADO_KG)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PESO_COBRADO_KG'  value='#arguments.PESO_COBRADO_KG#'  null='#iif(len(trim(arguments.PESO_COBRADO_KG)), de('no'), de('yes'))#'>
					
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QTDE_VOLUME'  value='#arguments.QTDE_VOLUME#'  null='#iif(len(trim(arguments.QTDE_VOLUME)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ALTURA'  value='#arguments.ALTURA#'  null='#iif(len(trim(arguments.ALTURA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COMPRIMENTO'  value='#arguments.COMPRIMENTO#'  null='#iif(len(trim(arguments.COMPRIMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LARGURA'  value='#arguments.LARGURA#'  null='#iif(len(trim(arguments.LARGURA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_M3'  value='#arguments.M3#'  null='#iif(len(trim(arguments.M3)), de('no'), de('yes'))#'>
					
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CUBAGEM'  value='#arguments.CUBAGEM#'  null='#iif(len(trim(arguments.CUBAGEM)), de('no'), de('yes'))#'>

					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ESPECIE'  value='#arguments.NUM_ESPECIE#'  null='#iif(len(trim(arguments.NUM_ESPECIE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5' dbvarname='P_COD_UNIDADE'  value='#arguments.COD_UNIDADE#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5' dbvarname='P_ORDEM_COMPRA'  value='#arguments.ORDEM_COMPRA#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ITEM_ID' variable='retorno.ITEM_ID' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CFOP'  value='#arguments.CFOP#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CHAVE_ACESSO_NFE'  value='#arguments.CHAVE_ACESSO_NFE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_NFE_XML'  value='#arguments.NFE_XML#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_DOCUMENTO_ID'  value='#arguments.TIPO_DOCUMENTO_ID#'  null='#iif(len(trim(arguments.TIPO_DOCUMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO_DOCTO'  value='#arguments.DESCRICAO_DOCTO#' >
				</cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
        	</cftry>   
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera solicitao de coleta.
	-- wagner 18/10/2006 20:52:47 - CRIADO
	--->
	<cffunction name='upd_coleta_item' displayname='Altera solicitao de coleta.' access='remote' returntype='Struct' output='true'>
		<cfargument name='COLETA_ID' required='yes'>
		<cfargument name='NUM_NATUREZA' required='yes'>
		<cfargument name='COMPLEMENTO' required='yes'>
		<cfargument name='NF_NUMERO' required='yes'>
		<cfargument name='NF_MODELO' required='yes'>
		<cfargument name='NF_SERIE' required='yes'>
		<cfargument name='NF_SUB_SERIE' required='yes'>
		<cfargument name='NF_DATA_EMISSAO' required='yes'>
		<cfargument name='NF_VALOR' required='yes'>
		<cfargument name='VALOR_SEGURADO' required='yes'>
		<cfargument name='PESO_KG' required='yes'>
		<cfargument name='PESO_CUBADO_KG' required='yes'>
		<cfargument name='PESO_COBRADO_KG' required='yes'>
		<cfargument name='QTDE_VOLUME' required='yes'>
		<cfargument name='ALTURA' required='yes'>
		<cfargument name='COMPRIMENTO' required='yes'>
		<cfargument name='LARGURA' required='yes'>
		<cfargument name='M3' required='yes'>
		<cfargument name='CUBAGEM' required='yes'>
		<cfargument name='COLETA_ITEM_ID' required='yes'>
		<cfargument name='COD_UNIDADE' required='yes'>
		<cfargument name='NUM_ESPECIE' required='yes'>
		<cfargument name='ORDEM_COMPRA' required='yes'>
        <cfargument name='CFOP' required='yes'>
        <cfargument name='CHAVE_ACESSO_NFE' required='yes'>
        <cfargument name='TIPO_DOCUMENTO_ID' required='yes'>
		<cfargument name='DESCRICAO_DOCTO' required='no' default=''>
        	<cftry>
				<cfstoredproc procedure='oper.pkg_ctrl_carga.prc_alt_coleta_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COLETA_ITEM_ID' value='#arguments.COLETA_ITEM_ID#'  null='#iif(len(trim(arguments.COLETA_ITEM_ID)), de('no'), de('yes'))#'> 
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COLETA_ID'  value='#arguments.COLETA_ID#'  null='#iif(len(trim(arguments.COLETA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NATUREZA'  value='#arguments.NUM_NATUREZA#'  null='#iif(len(trim(arguments.NUM_NATUREZA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMPLEMENTO'  value='#arguments.COMPLEMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NF_NUMERO'  value='#arguments.NF_NUMERO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NF_MODELO'  value='#arguments.NF_MODELO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NF_SERIE'  value='#arguments.NF_SERIE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NF_SUB_SERIE'  value='#arguments.NF_SUB_SERIE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NF_DATA_EMISSAO'  value='#arguments.NF_DATA_EMISSAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NF_VALOR'  value='#arguments.NF_VALOR#'  null='#iif(len(trim(arguments.NF_VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_SEGURADO'  value='#arguments.VALOR_SEGURADO#'  null='#iif(len(trim(arguments.VALOR_SEGURADO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PESO_KG'  value='#arguments.PESO_KG#'  null='#iif(len(trim(arguments.PESO_KG)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PESO_CUBADO_KG'  value='#arguments.PESO_CUBADO_KG#'  null='#iif(len(trim(arguments.PESO_CUBADO_KG)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PESO_COBRADO_KG'  value='#arguments.PESO_COBRADO_KG#'  null='#iif(len(trim(arguments.PESO_COBRADO_KG)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QTDE_VOLUME'  value='#arguments.QTDE_VOLUME#'  null='#iif(len(trim(arguments.QTDE_VOLUME)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ALTURA'  value='#arguments.ALTURA#'  null='#iif(len(trim(arguments.ALTURA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COMPRIMENTO'  value='#arguments.COMPRIMENTO#'  null='#iif(len(trim(arguments.COMPRIMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LARGURA'  value='#arguments.LARGURA#'  null='#iif(len(trim(arguments.LARGURA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_M3'  value='#arguments.M3#'  null='#iif(len(trim(arguments.M3)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CUBAGEM'  value='#arguments.CUBAGEM#'  null='#iif(len(trim(arguments.CUBAGEM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ESPECIE'  value='#arguments.NUM_ESPECIE#'  null='#iif(len(trim(arguments.NUM_ESPECIE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5' dbvarname='P_COD_UNIDADE'  value='#arguments.COD_UNIDADE#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5' dbvarname='P_ORDEM_COMPRA'  value='#arguments.ORDEM_COMPRA#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CFOP'  value='#arguments.CFOP#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CHAVE_ACESSO_NFE'  value='#arguments.CHAVE_ACESSO_NFE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_DOCUMENTO_ID'  value='#arguments.TIPO_DOCUMENTO_ID#'  null='#iif(len(trim(arguments.TIPO_DOCUMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO_DOCTO'  value='#arguments.DESCRICAO_DOCTO#' >
				</cfstoredproc>
                <cfset retorno.erro = false>
                <cfcatch>
                    <cfset retorno.erro = true>
                    <cfset retorno.mensagem = cfcatch>
                    <cfset request.erro = cfcatch>
                </cfcatch>
            </cftry>   
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Deleta itens da coleta
	-- wagner 20/10/2006 15:28:53 - CRIADO
	--->
	<cffunction name='del_coleta_item' displayname='Deleta itens da coleta' access='remote' returntype='Struct' output='true'>
		<cfargument name='COLETA_ITEM_ID' required='yes'>
				<cfstoredproc procedure='oper.pkg_ctrl_carga.prc_del_coleta_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COLETA_ITEM_ID'  value='#arguments.COLETA_ITEM_ID#'  null='#iif(len(trim(arguments.COLETA_ITEM_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Gerar Ordem de Coleta
	-- wagner 22/10/2006 17:40:32 - CRIADO
	--->
	<cffunction name='gerar_ordem_coleta' displayname='Gerar Ordem de Coleta' access='remote' returntype='Struct' output='true'>
		<cfargument name='COLETA_ID' required='yes'>
		<cfargument name='NUM_COLETA' required='yes'>
		<cfargument name='SERIE' required='yes'>
		<cfargument name='SUBSERIE' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
		<cfargument name='COD_AGENDAMENTO' required='yes'>
		<cfargument name='DATA_AGENDAMENTO' required='yes'>
		<cfargument name='DATA_EMISSAO' required='no' default="#LSDateFormat(now())#">
		<cfargument name='PLACA' required='yes'>
		<cfargument name='COD_MOTORISTA' required='yes'>
		<cfargument name='DATA_COLETA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_ctrl_carga.prc_gerar_ordem_coleta' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COLETA_ID'  value='#arguments.COLETA_ID#'  null='#iif(len(trim(arguments.COLETA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_COLETA'  value='#arguments.NUM_COLETA#'  null='#iif(len(trim(arguments.NUM_COLETA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SERIE'  value='#arguments.SERIE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SUBSERIE'  value='#arguments.SUBSERIE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
				</cfstoredproc>
				
				<!---Verifica o Tipo de Documento que vai ser vinculado--->
                <cfswitch expression="#arguments.tipo_documento_id#">
                    <cfcase value="0">
                        <!--- Insere Notas fiscais --->
                        <cfscript>
						v_coleta_item_id   	= this.ListaToArray (lista = arguments, variavel = "NOTA_COLETA_ITEM_ID_NOTAS_FISCAIS");
						v_numero 	         = this.ListaToArray(lista = arguments, variavel = "NOTA_NUMERO_NOTAS_FISCAIS");
						v_data_emissao       = this.ListaToArray(lista = arguments, variavel = "NOTA_DATA_EMISSAO_NOTAS_FISCAIS");
						v_serie 	         = this.ListaToArray(lista = arguments, variavel = "NOTA_SERIE_NOTAS_FISCAIS");
						v_sub_serie          = this.ListaToArray(lista = arguments, variavel = "NOTA_SUB_SERIE_NOTAS_FISCAIS");
						v_modelo             = this.ListaToArray(lista = arguments, variavel = "NOTA_MODELO_NOTAS_FISCAIS");
						v_valor		         = this.ListaToArray(lista = arguments, variavel = "NOTA_VALOR_NOTAS_FISCAIS");
						v_valor_segurado     = this.ListaToArray(lista = arguments, variavel = "NOTA_VALOR_SEGURADO_NOTAS_FISCAIS");
						v_peso               = this.ListaToArray(lista = arguments, variavel = "NOTA_PESO_NOTAS_FISCAIS");
						v_peso_cobrado       = this.ListaToArray(lista = arguments, variavel = 'NOTA_PESO_COBRADO_NOTAS_FISCAIS');
						v_ordem_compra       = this.ListaToArray(lista = arguments, variavel = "NOTA_ORDEM_COMPRA_NOTAS_FISCAIS");
						v_qtde_volume        = this.ListaToArray(lista = arguments, variavel = 'NOTA_QTDE_VOLUME_NOTAS_FISCAIS');
						v_cod_unidade        = this.ListaToArray(lista = arguments, variavel = 'NOTA_COD_UNIDADE_NOTAS_FISCAIS');
						v_m3                 = this.ListaToArray(lista = arguments, variavel = 'NOTA_M3_NOTAS_FISCAIS');
						v_peso_cubado        = this.ListaToArray(lista = arguments, variavel = 'NOTA_PESO_CUBADO_NOTAS_FISCAIS');
						v_num_natureza       = this.ListaToArray(lista = arguments, variavel = 'NOTA_NUM_NATUREZA_NOTAS_FISCAIS');
						v_complemento        = this.ListaToArray(lista = arguments, variavel = 'NOTA_COMPLEMENTO_NOTAS_FISCAIS');
						v_num_especie        = this.ListaToArray(lista = arguments, variavel = 'NOTA_NUM_ESPECIE_NOTAS_FISCAIS');
						v_altura             = this.ListaToArray(lista = arguments, variavel = 'NOTA_ALTURA_NOTAS_FISCAIS');
						v_largura            = this.ListaToArray(lista = arguments, variavel = 'NOTA_LARGURA_NOTAS_FISCAIS');
						v_comprimento        = this.ListaToArray(lista = arguments, variavel = 'NOTA_COMPRIMENTO_NOTAS_FISCAIS');
						v_cubagem            = this.ListaToArray(lista = arguments, variavel = 'NOTA_CUBAGEM_NOTAS_FISCAIS');
						v_cfop				 = this.ListaToArray(lista = arguments, variavel = 'NOTA_CFOP_NOTAS_FISCAIS');
						v_excluir			 = this.ListDiff(lista1 = arguments.lista_deleted_NOTAS_FISCAIS, lista2 = ArrayToList(v_coleta_item_id));
                        </cfscript>
						
                        <cfloop list="#v_excluir#" delimiters="," index="l_id">
							<cfscript>
								this.del_coleta_item(coleta_item_id = l_id);
							</cfscript>
						</cfloop>
						<cfloop from="1" to="#ArrayLen(v_num_natureza)#" index="count">
							
							<cfscript>
								if(Len(Trim(v_coleta_item_id[count]))){					
									ret_nf =    this.upd_coleta_item(coleta_item_id  = v_coleta_item_id[count],
																	 coleta_id       = arguments.COLETA_ID,
																	 num_natureza	 = v_num_natureza[count],
																	 complemento	 = v_complemento[count],
																	 nf_numero 		 = v_numero[count],
																	 nf_modelo 		 = v_modelo[count],
																	 nf_serie 		 = v_serie[count],
																	 nf_sub_serie 	 = v_sub_serie[count],
																	 nf_data_emissao = v_data_emissao[count],
																	 nf_valor	 	 = v_valor[count],
																	 valor_segurado  = v_valor_segurado[count],
																	 peso_kg	 	 = v_peso[count],
																	 peso_cubado_kg	 = v_peso_cubado[count],
																	 peso_cobrado_kg = v_peso_cobrado[count],
																	 qtde_volume	 = v_qtde_volume[count],
																	 altura			 = v_altura[count],
																	 comprimento	 = v_comprimento[count],
																	 largura		 = v_largura[count],
																	 m3		 		 = v_M3[count],
																	 cubagem		 = v_cubagem[count],
																	 cod_unidade	 = v_cod_unidade[count],
																	 ordem_compra	 = v_ordem_compra[count],
																	 num_especie	 = v_num_especie[count],
																	 cfop		     = v_cfop[count],
																	 chave_acesso_nfe  = '',
																	 nfe_xml		   = '',
																	 tipo_documento_id = arguments.tipo_documento_id);
								}else{
									ret_nf =    this.ins_coleta_item(coleta_id       = arguments.COLETA_ID,
																	 num_natureza	 = v_num_natureza[count],
																	 complemento	 = v_complemento[count],
																	 nf_numero 		 = v_numero[count],
																	 nf_modelo 		 = v_modelo[count],
																	 nf_serie 		 = v_serie[count],
																	 nf_sub_serie 	 = v_sub_serie[count],
																	 nf_data_emissao = v_data_emissao[count],
																	 nf_valor	 	 = v_valor[count],
																	 valor_segurado  = v_valor_segurado[count],
																	 peso_kg	 	 = v_peso[count],
																	 peso_cubado_kg	 = v_peso_cubado[count],
																	 peso_cobrado_kg = v_peso_cobrado[count],
																	 qtde_volume	 = v_qtde_volume[count],
																	 altura			 = v_altura[count],
																	 comprimento	 = v_comprimento[count],
																	 largura		 = v_largura[count],
																	 M3		 		 = v_M3[count],
																	 cubagem		 = v_cubagem[count],
																	 coleta_item_id = v_coleta_item_id[count],
																	 cod_unidade	 = v_cod_unidade[count],
																	 ordem_compra	 = v_ordem_compra[count],
																	 num_especie	 = v_num_especie[count],
																	 cfop		     = v_cfop[count],
																	 chave_acesso_nfe  = '',
																	 nfe_xml		   = '',
																	 tipo_documento_id = arguments.tipo_documento_id);
								
								} 
							</cfscript>
							<cfif ret_nf.erro>
								<cfthrow object="#ret_nf.mensagem#">
							</cfif>
						</cfloop>						
                    </cfcase>
                    
                    <cfcase value="1">
                        <!--- Insere NFE --->
                        <cfscript>
                            v_coleta_item_id   		= this.ListaToArray (lista = arguments, variavel = "NFE_COLETA_ITEM_ID_NFE");
							v_chave_acesso_nfe		= this.ListaToArray (lista = arguments, variavel = "CHAVE_ACESSO_NFE_NFE");
                            v_nfe_valor				= this.ListaToArray (lista = arguments, variavel = "NFE_VALOR_NFE");
                            v_nome_arquivo			= this.ListaToArray (lista = arguments, variavel = "NOME_ARQUIVO_NFE");
                            v_data_emissao			= this.ListaToArray (lista = arguments, variavel = "DATA_EMISSAO_NFE");
                            v_numero				= this.ListaToArray (lista = arguments, variavel = "NUMERO_NFE");
                            v_modelo				= this.ListaToArray (lista = arguments, variavel = "MODELO_NFE");
                            v_serie					= this.ListaToArray (lista = arguments, variavel = "SERIE_NFE");
                            v_documento_id			= this.ListaToArray (lista = arguments, variavel = "NFE_DOCUMENTO_ID_NFE");
							v_peso                  = this.ListaToArray (lista = arguments, variavel = "NFE_PESO_NFE");
                            v_peso_cobrado          = this.ListaToArray (lista = arguments, variavel = 'NFE_PESO_COBRADO_NFE');
                            v_ordem_compra          = this.ListaToArray (lista = arguments, variavel = "NFE_ORDEM_COMPRA_NFE");
                            v_qtde_volume           = this.ListaToArray (lista = arguments, variavel = 'NFE_QTDE_VOLUME_NFE');
                            v_cod_unidade           = this.ListaToArray (lista = arguments, variavel = 'NFE_COD_UNIDADE_NFE');
                            v_m3                    = this.ListaToArray (lista = arguments, variavel = 'NFE_M3_NFE');
                            v_peso_cubado           = this.ListaToArray (lista = arguments, variavel = 'NFE_PESO_CUBADO_NFE');
                            v_num_natureza          = this.ListaToArray (lista = arguments, variavel = 'NFE_NUM_NATUREZA_NFE');
                            v_complemento           = this.ListaToArray (lista = arguments, variavel = 'NFE_COMPLEMENTO_NFE');
                            v_num_especie           = this.ListaToArray (lista = arguments, variavel = 'NFE_NUM_ESPECIE_NFE');
                            v_altura                = this.ListaToArray (lista = arguments, variavel = 'NFE_ALTURA_NFE');
                            v_largura               = this.ListaToArray (lista = arguments, variavel = 'NFE_LARGURA_NFE');
                            v_comprimento           = this.ListaToArray (lista = arguments, variavel = 'NFE_COMPRIMENTO_NFE');
                            v_cubagem               = this.ListaToArray (lista = arguments, variavel = 'NFE_CUBAGEM_NFE');
                            v_excluir				= this.ListDiff(lista1 = arguments.lista_deleted_NFE, lista2 = ArrayToList(v_coleta_item_id));
                        </cfscript>
						
                        <cfloop list="#v_excluir#" delimiters="," index="l_id">
							<cfscript>
								this.del_coleta_item(coleta_item_id = l_id);
							</cfscript>
						</cfloop>
                        
                        <cfloop from="1" to="#ArrayLen(v_chave_acesso_nfe)#" index="count">
                            <!--- Busca arquivo --->
                            <cfif Len(Trim(v_nome_arquivo[count])) and not Len(Trim(v_coleta_item_id[count]))>
                                <cffile action="read" file="#expandPath("/")#temp/#v_nome_arquivo[count]#" variable="VARQUIVO">
                            <cfelse>
                                <cfset VARQUIVO = ''>
                            </cfif>
                            
                            <cfscript>
                                if(Len(Trim(v_coleta_item_id[count]))){					
									ret_nfe =  this.upd_coleta_item(coleta_item_id  = v_coleta_item_id[count],
																	coleta_id		= arguments.COLETA_ID,
																	num_natureza	= v_num_natureza[count],
																	complemento	 	= v_complemento[count],
																	nf_numero 		= v_numero[count],
																	nf_modelo 		= v_modelo[count],
																	nf_serie 		= v_serie[count],
																	nf_sub_serie 	= 1,
																	nf_data_emissao = v_data_emissao[count],
																	nf_valor	 	= v_nfe_valor[count],
																	valor_segurado  = v_nfe_valor[count],
																	peso_kg	 	 	= v_peso[count],
																	peso_cubado_kg	= v_peso_cubado[count],
																	peso_cobrado_kg = v_peso_cobrado[count],
																	qtde_volume	 	= v_qtde_volume[count],
																	altura			= v_altura[count],
																	comprimento	 	= v_comprimento[count],
																	largura		 	= v_largura[count],
																	M3		 		= v_M3[count],
																	cubagem		 	= v_cubagem[count],
																	ordem_compra	= v_ordem_compra[count],
																	cod_unidade	 	= v_cod_unidade[count],
																	num_especie	 	= v_num_especie[count],
																	cfop		    = '',
																	chave_acesso_nfe = v_chave_acesso_nfe[count],
																	tipo_documento_id = arguments.tipo_documento_id);
								}else{
									ret_nfe =  this.ins_coleta_item(coleta_id		= arguments.COLETA_ID,
																	num_natureza	= v_num_natureza[count],
																	complemento	 	= v_complemento[count],
																	nf_numero 		= v_numero[count],
																	nf_modelo 		= v_modelo[count],
																	nf_serie 		= v_serie[count],
																	nf_sub_serie 	= 1,
																	nf_data_emissao = v_data_emissao[count],
																	nf_valor	 	= v_nfe_valor[count],
																	valor_segurado  = v_nfe_valor[count],
																	peso_kg	 	 	= v_peso[count],
																	peso_cubado_kg	= v_peso_cubado[count],
																	peso_cobrado_kg = v_peso_cobrado[count],
																	qtde_volume	 	= v_qtde_volume[count],
																	altura			= v_altura[count],
																	comprimento	 	= v_comprimento[count],
																	largura		 	= v_largura[count],
																	M3		 		= v_M3[count],
																	cubagem		 	= v_cubagem[count],
																	ordem_compra	= v_ordem_compra[count],
																	cod_unidade	 	= v_cod_unidade[count],
																	num_especie	 	= v_num_especie[count],
																	cfop		    = '',
																	chave_acesso_nfe = v_chave_acesso_nfe[count],
																	nfe_xml		   	= VARQUIVO,
																	tipo_documento_id = arguments.tipo_documento_id);
								
								} 					
								
                            </cfscript>
                            <cfif ret_nfe.erro>
                                <cfthrow object="#ret_nfe.mensagem#">
                            </cfif>
                        </cfloop>
                    </cfcase>
                    
                    <cfcase value="2">
                        <!--- Insere Outros Documentos--->
                        <cfscript>
                            v_coleta_item_id   		= this.ListaToArray (lista = arguments, variavel = "OUTROS_COLETA_ITEM_ID_OUTROS");
							v_outros_numero			= this.ListaToArray (lista = arguments, variavel = "OUTROS_NUMERO_OUTROS");
                            v_outros_data_emissao	= this.ListaToArray (lista = arguments, variavel = "OUTROS_DATA_EMISSAO_OUTROS");
                            v_outros_descricao		= this.ListaToArray (lista = arguments, variavel = "OUTROS_DESCRICAO_OUTROS");
                            v_outros_valor			= this.ListaToArray (lista = arguments, variavel = "OUTROS_VALOR_OUTROS");
                            v_peso                  = this.ListaToArray (lista = arguments, variavel = "OUTROS_PESO_OUTROS");
                            v_peso_cobrado          = this.ListaToArray (lista = arguments, variavel = 'OUTROS_PESO_COBRADO_OUTROS');
                            v_qtde_volume           = this.ListaToArray (lista = arguments, variavel = 'OUTROS_QTDE_VOLUME_OUTROS');
                            v_cod_unidade           = this.ListaToArray (lista = arguments, variavel = 'OUTROS_COD_UNIDADE_OUTROS');
                            v_m3                    = this.ListaToArray (lista = arguments, variavel = 'OUTROS_M3_OUTROS');
                            v_peso_cubado           = this.ListaToArray (lista = arguments, variavel = 'OUTROS_PESO_CUBADO_OUTROS');
                            v_num_natureza          = this.ListaToArray (lista = arguments, variavel = 'OUTROS_NUM_NATUREZA_OUTROS');
                            v_complemento           = this.ListaToArray (lista = arguments, variavel = 'OUTROS_COMPLEMENTO_OUTROS');
                            v_num_especie           = this.ListaToArray (lista = arguments, variavel = 'OUTROS_NUM_ESPECIE_OUTROS');
                            v_altura                = this.ListaToArray (lista = arguments, variavel = 'OUTROS_ALTURA_OUTROS');
                            v_largura               = this.ListaToArray (lista = arguments, variavel = 'OUTROS_LARGURA_OUTROS');
                            v_comprimento           = this.ListaToArray (lista = arguments, variavel = 'OUTROS_COMPRIMENTO_OUTROS');
                            v_cubagem               = this.ListaToArray (lista = arguments, variavel = 'OUTROS_CUBAGEM_OUTROS');
							v_excluir				= this.ListDiff(lista1 = arguments.lista_deleted_OUTROS, lista2 = ArrayToList(v_coleta_item_id));
                        </cfscript>
						
                        <cfloop list="#v_excluir#" delimiters="," index="l_id">
							<cfscript>
								this.del_coleta_item(coleta_item_id = l_id);
							</cfscript>
						</cfloop>
                        
                        <cfloop from="1" to="#ArrayLen(v_outros_numero)#" index="count">
                            <cfscript>
                                if(Len(Trim(v_coleta_item_id[count]))){
									outros =  this.upd_coleta_item(coleta_item_id   = v_coleta_item_id[count],
																   coleta_id		= arguments.COLETA_ID,
																   num_natureza	 	= v_num_natureza[count],
																   complemento	 	= v_complemento[count],
																   nf_numero 		= v_outros_numero[count],
																   nf_modelo 		= '01',
																   nf_serie 		= 'U',
																   nf_sub_serie 	= '1',
																   nf_data_emissao 	= v_outros_data_emissao[count],
																   nf_valor	 	 	= v_outros_valor[count],
																   valor_segurado  	= v_outros_valor[count],
																   peso_kg	 	 	= v_peso[count],
																   peso_cubado_kg	= v_peso_cubado[count],
																   peso_cobrado_kg 	= v_peso_cobrado[count],
																   qtde_volume	 	= v_qtde_volume[count],
																   altura			= v_altura[count],
																   comprimento	 	= v_comprimento[count],
																   largura		 	= v_largura[count],
																   m3		 		= v_m3[count],
																   cubagem		 	= v_cubagem[count],
																   ordem_compra	 	= '',
																   cod_unidade	 	= v_cod_unidade[count],
																   num_especie	 	= v_num_especie[count],
																   cfop		     	= '',
																   chave_acesso_nfe = '',
																   nfe_xml		   	= '',
																   tipo_documento_id = arguments.tipo_documento_id,
																   descricao_docto	 = v_outros_descricao[count]);
								}else{
									outros =  this.ins_coleta_item(coleta_id		= arguments.COLETA_ID,
																   num_natureza	 	= v_num_natureza[count],
																   complemento	 	= v_complemento[count],
																   nf_numero 		= v_outros_numero[count],
																   nf_modelo 		= '01',
																   nf_serie 		= 'U',
																   nf_sub_serie 	= '1',
																   nf_data_emissao 	= v_outros_data_emissao[count],
																   nf_valor	 	 	= v_outros_valor[count],
																   valor_segurado  	= v_outros_valor[count],
																   peso_kg	 	 	= v_peso[count],
																   peso_cubado_kg	= v_peso_cubado[count],
																   peso_cobrado_kg 	= v_peso_cobrado[count],
																   qtde_volume	 	= v_qtde_volume[count],
																   altura			= v_altura[count],
																   comprimento	 	= v_comprimento[count],
																   largura		 	= v_largura[count],
																   m3		 		= v_m3[count],
																   cubagem		 	= v_cubagem[count],
																   ordem_compra	 	= '',
																   cod_unidade	 	= v_cod_unidade[count],
																   num_especie	 	= v_num_especie[count],
																   cfop		     	= '',
																   chave_acesso_nfe = '',
																   nfe_xml		   	= '',
																   tipo_documento_id = arguments.tipo_documento_id,
																   descricao_docto	 = v_outros_descricao[count]);
								}
								
                            </cfscript>
                            <cfif outros.erro>
                                <cfthrow object="#outros.mensagem#">
                            </cfif>
                        </cfloop>
                    </cfcase>                
                </cfswitch>
                
                <cfscript>
					if(Len(Trim(arguments.PLACA))){
						ret_sit = this.ins_agendamento(coleta_id 	    = arguments.coleta_id
													  ,cod_agendamento  = arguments.cod_agendamento 
													  ,data_agendamento = arguments.data_emissao
													  ,placa			= Replace(arguments.placa,"-","","ALL")
													  ,cod_motorista	= arguments.cod_motorista
													  ,data_coleta	    = arguments.data_coleta
													  ,situacao_id	    = 2
													  ,num_coleta	    = arguments.num_coleta
													  ,serie			= arguments.serie
													  ,subserie		    = arguments.subserie);
					}else{
						ret_sit = this.cancela_agendamento(coleta_id 		 = arguments.coleta_id
														  ,cod_cancelamento  = arguments.cod_agendamento 
														  ,data_cancelamento = arguments.data_emissao
														  );
					}													
				</cfscript>
				<cfif ret_sit.erro>
                    <cfthrow object="#ret_sit.mensagem#">
                </cfif>
                
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Ordem de Coleta Gerada com sucesso!')>
			</cftransaction>
		<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere agendamento de Coleta
	-- wagner 22/10/2006 17:43:32 - CRIADO
	--->
	<cffunction name='ins_agendamento' displayname='Insere agendamento de Coleta' access='remote' returntype='Struct' output='true'>
		<cfargument name='COLETA_ID' required='yes'>
		<cfargument name='COD_AGENDAMENTO' required='yes'>
		<cfargument name='DATA_AGENDAMENTO' required='yes'>
		<cfargument name='PLACA' required='yes'>
		<cfargument name='COD_MOTORISTA' required='yes'>
		<cfargument name='DATA_COLETA' required='yes'>
		<cfargument name='COD_CONFIRMACAO' required='no' default="">
		<cfargument name='DATA_CONFIRMACAO' required='no' default="">
		<cfargument name='COD_CANCELAMENTO' required='no' default="">
		<cfargument name='DATA_CANCELAMENTO' required='no' default="">
		<cfargument name='SITUACAO_ID' required='yes'>
		<cfargument name='NUM_COLETA' required='yes'>
		<cfargument name='SERIE' required='yes'>
		<cfargument name='SUBSERIE' required='yes'>
		<cfargument name='COLETA_VEI_ID' required='no' default="0">
        <cftry>
             <cfstoredproc procedure='oper.pkg_ctrl_carga.prc_ins_agendamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                 <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COLETA_ID'  value='#arguments.COLETA_ID#'  null='#iif(len(trim(arguments.COLETA_ID)), de('no'), de('yes'))#'>
                 <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_AGENDAMENTO'  value='#arguments.COD_AGENDAMENTO#'  null='#iif(len(trim(arguments.COD_AGENDAMENTO)), de('no'), de('yes'))#'>
                 <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_AGENDAMENTO'  value='#arguments.DATA_AGENDAMENTO#' >
                 <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#Replace(arguments.PLACA,"-","","ALL")#' >
                 <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_MOTORISTA'  value='#arguments.COD_MOTORISTA#'  null='#iif(len(trim(arguments.COD_MOTORISTA)), de('no'), de('yes'))#'>
                 <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_COLETA'  value='#arguments.DATA_COLETA#' >
                 <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CONFIRMACAO'  value='#arguments.COD_CONFIRMACAO#'  null='#iif(len(trim(arguments.COD_CONFIRMACAO)), de('no'), de('yes'))#'>
                 <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_CONFIRMACAO'  value='#arguments.DATA_CONFIRMACAO#' >
                 <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CANCELAMENTO'  value='#arguments.COD_CANCELAMENTO#'  null='#iif(len(trim(arguments.COD_CANCELAMENTO)), de('no'), de('yes'))#'>
                 <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_CANCELAMENTO'  value='#arguments.DATA_CANCELAMENTO#' >
                 <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SITUACAO_ID'  value='#arguments.SITUACAO_ID#'  null='#iif(len(trim(arguments.SITUACAO_ID)), de('no'), de('yes'))#'>
                 <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_COLETA'  value='#arguments.NUM_COLETA#'  null='#iif(len(trim(arguments.NUM_COLETA)), de('no'), de('yes'))#'>
                 <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SERIE'  value='#arguments.SERIE#' >
                 <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SUBSERIE'  value='#arguments.SUBSERIE#' >
                 <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COLETA_VEI_ID'  value='#arguments.COLETA_VEI_ID#' variable='retorno.COLETA_VEI_ID'  null='#iif(len(trim(arguments.COLETA_VEI_ID)), de('no'), de('yes'))#'>
             </cfstoredproc>
              <cfset retorno.erro = false>
              <cfcatch>
                  <cfset retorno.erro = true>
                  <cfset retorno.mensagem = cfcatch>
                  <cfset request.erro = cfcatch>
              </cfcatch>
         </cftry>
        <cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROP?SITO
	-- Confirma Coleta
	-- wagner 22/10/2006 18:16:26 - CRIADO
	--->
	<cffunction name='confirma_coleta' displayname='Confirma Coleta' access='remote' returntype='Struct' output='true'>
		<cfargument name='COLETA_ID' required='yes'>
		<cfargument name='DATA_CONFIRMACAO' required='yes'>
		<cfargument name='COD_CONFIRMACAO' required='yes'>
		<cfargument name='SITUACAO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_ctrl_carga.prc_confirma_coleta' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COLETA_ID'  value='#arguments.COLETA_ID#'  null='#iif(len(trim(arguments.COLETA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_CONFIRMACAO'  value='#arguments.DATA_CONFIRMACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CONFIRMACAO'  value='#arguments.COD_CONFIRMACAO#'  null='#iif(len(trim(arguments.COD_CONFIRMACAO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				
				<!---Verifica o Tipo de Documento que vai ser vinculado--->
                <cfswitch expression="#arguments.tipo_documento_id#">
                    <cfcase value="0">
                        <!--- Insere Notas fiscais --->
                        <cfscript>
						v_coleta_item_id   	= this.ListaToArray (lista = arguments, variavel = "NOTA_COLETA_ITEM_ID_NOTAS_FISCAIS");
						v_numero 	         = this.ListaToArray(lista = arguments, variavel = "NOTA_NUMERO_NOTAS_FISCAIS");
						v_data_emissao       = this.ListaToArray(lista = arguments, variavel = "NOTA_DATA_EMISSAO_NOTAS_FISCAIS");
						v_serie 	         = this.ListaToArray(lista = arguments, variavel = "NOTA_SERIE_NOTAS_FISCAIS");
						v_sub_serie          = this.ListaToArray(lista = arguments, variavel = "NOTA_SUB_SERIE_NOTAS_FISCAIS");
						v_modelo             = this.ListaToArray(lista = arguments, variavel = "NOTA_MODELO_NOTAS_FISCAIS");
						v_valor		         = this.ListaToArray(lista = arguments, variavel = "NOTA_VALOR_NOTAS_FISCAIS");
						v_valor_segurado     = this.ListaToArray(lista = arguments, variavel = "NOTA_VALOR_SEGURADO_NOTAS_FISCAIS");
						v_peso               = this.ListaToArray(lista = arguments, variavel = "NOTA_PESO_NOTAS_FISCAIS");
						v_peso_cobrado       = this.ListaToArray(lista = arguments, variavel = 'NOTA_PESO_COBRADO_NOTAS_FISCAIS');
						v_ordem_compra       = this.ListaToArray(lista = arguments, variavel = "NOTA_ORDEM_COMPRA_NOTAS_FISCAIS");
						v_qtde_volume        = this.ListaToArray(lista = arguments, variavel = 'NOTA_QTDE_VOLUME_NOTAS_FISCAIS');
						v_cod_unidade        = this.ListaToArray(lista = arguments, variavel = 'NOTA_COD_UNIDADE_NOTAS_FISCAIS');
						v_m3                 = this.ListaToArray(lista = arguments, variavel = 'NOTA_M3_NOTAS_FISCAIS');
						v_peso_cubado        = this.ListaToArray(lista = arguments, variavel = 'NOTA_PESO_CUBADO_NOTAS_FISCAIS');
						v_num_natureza       = this.ListaToArray(lista = arguments, variavel = 'NOTA_NUM_NATUREZA_NOTAS_FISCAIS');
						v_complemento        = this.ListaToArray(lista = arguments, variavel = 'NOTA_COMPLEMENTO_NOTAS_FISCAIS');
						v_num_especie        = this.ListaToArray(lista = arguments, variavel = 'NOTA_NUM_ESPECIE_NOTAS_FISCAIS');
						v_altura             = this.ListaToArray(lista = arguments, variavel = 'NOTA_ALTURA_NOTAS_FISCAIS');
						v_largura            = this.ListaToArray(lista = arguments, variavel = 'NOTA_LARGURA_NOTAS_FISCAIS');
						v_comprimento        = this.ListaToArray(lista = arguments, variavel = 'NOTA_COMPRIMENTO_NOTAS_FISCAIS');
						v_cubagem            = this.ListaToArray(lista = arguments, variavel = 'NOTA_CUBAGEM_NOTAS_FISCAIS');
						v_cfop				 = this.ListaToArray(lista = arguments, variavel = 'NOTA_CFOP_NOTAS_FISCAIS');
						v_excluir			 = this.ListDiff(lista1 = arguments.lista_deleted_NOTAS_FISCAIS, lista2 = ArrayToList(v_coleta_item_id));
                        </cfscript>
						
                        <cfloop list="#v_excluir#" delimiters="," index="l_id">
							<cfscript>
								this.del_coleta_item(coleta_item_id = l_id);
							</cfscript>
						</cfloop>
						<cfloop from="1" to="#ArrayLen(v_num_natureza)#" index="count">
							
							<cfscript>
								if(Len(Trim(v_coleta_item_id[count]))){					
									ret_nf =    this.upd_coleta_item(coleta_item_id  = v_coleta_item_id[count],
																	 coleta_id       = arguments.COLETA_ID,
																	 num_natureza	 = v_num_natureza[count],
																	 complemento	 = v_complemento[count],
																	 nf_numero 		 = v_numero[count],
																	 nf_modelo 		 = v_modelo[count],
																	 nf_serie 		 = v_serie[count],
																	 nf_sub_serie 	 = v_sub_serie[count],
																	 nf_data_emissao = v_data_emissao[count],
																	 nf_valor	 	 = v_valor[count],
																	 valor_segurado  = v_valor_segurado[count],
																	 peso_kg	 	 = v_peso[count],
																	 peso_cubado_kg	 = v_peso_cubado[count],
																	 peso_cobrado_kg = v_peso_cobrado[count],
																	 qtde_volume	 = v_qtde_volume[count],
																	 altura			 = v_altura[count],
																	 comprimento	 = v_comprimento[count],
																	 largura		 = v_largura[count],
																	 m3		 		 = v_M3[count],
																	 cubagem		 = v_cubagem[count],
																	 cod_unidade	 = v_cod_unidade[count],
																	 ordem_compra	 = v_ordem_compra[count],
																	 num_especie	 = v_num_especie[count],
																	 cfop		     = v_cfop[count],
																	 chave_acesso_nfe  = '',
																	 nfe_xml		   = '',
																	 tipo_documento_id = arguments.tipo_documento_id);
								}else{
									ret_nf =    this.ins_coleta_item(coleta_id       = arguments.COLETA_ID,
																	 num_natureza	 = v_num_natureza[count],
																	 complemento	 = v_complemento[count],
																	 nf_numero 		 = v_numero[count],
																	 nf_modelo 		 = v_modelo[count],
																	 nf_serie 		 = v_serie[count],
																	 nf_sub_serie 	 = v_sub_serie[count],
																	 nf_data_emissao = v_data_emissao[count],
																	 nf_valor	 	 = v_valor[count],
																	 valor_segurado  = v_valor_segurado[count],
																	 peso_kg	 	 = v_peso[count],
																	 peso_cubado_kg	 = v_peso_cubado[count],
																	 peso_cobrado_kg = v_peso_cobrado[count],
																	 qtde_volume	 = v_qtde_volume[count],
																	 altura			 = v_altura[count],
																	 comprimento	 = v_comprimento[count],
																	 largura		 = v_largura[count],
																	 M3		 		 = v_M3[count],
																	 cubagem		 = v_cubagem[count],
																	 coleta_item_id = v_coleta_item_id[count],
																	 cod_unidade	 = v_cod_unidade[count],
																	 ordem_compra	 = v_ordem_compra[count],
																	 num_especie	 = v_num_especie[count],
																	 cfop		     = v_cfop[count],
																	 chave_acesso_nfe  = '',
																	 nfe_xml		   = '',
																	 tipo_documento_id = arguments.tipo_documento_id);
								
								} 
							</cfscript>
							<cfif ret_nf.erro>
								<cfthrow object="#ret_nf.mensagem#">
							</cfif>
						</cfloop>						
                    </cfcase>
                    
                    <cfcase value="1">
                        <!--- Insere NFE --->
                        <cfscript>
                            v_coleta_item_id   		= this.ListaToArray (lista = arguments, variavel = "NFE_COLETA_ITEM_ID_NFE");
							v_chave_acesso_nfe		= this.ListaToArray (lista = arguments, variavel = "CHAVE_ACESSO_NFE_NFE");
                            v_nfe_valor				= this.ListaToArray (lista = arguments, variavel = "NFE_VALOR_NFE");
                            v_nome_arquivo			= this.ListaToArray (lista = arguments, variavel = "NOME_ARQUIVO_NFE");
                            v_data_emissao			= this.ListaToArray (lista = arguments, variavel = "DATA_EMISSAO_NFE");
                            v_numero				= this.ListaToArray (lista = arguments, variavel = "NUMERO_NFE");
                            v_modelo				= this.ListaToArray (lista = arguments, variavel = "MODELO_NFE");
                            v_serie					= this.ListaToArray (lista = arguments, variavel = "SERIE_NFE");
                            v_documento_id			= this.ListaToArray (lista = arguments, variavel = "NFE_DOCUMENTO_ID_NFE");
							v_peso                  = this.ListaToArray (lista = arguments, variavel = "NFE_PESO_NFE");
                            v_peso_cobrado          = this.ListaToArray (lista = arguments, variavel = 'NFE_PESO_COBRADO_NFE');
                            v_ordem_compra          = this.ListaToArray (lista = arguments, variavel = "NFE_ORDEM_COMPRA_NFE");
                            v_qtde_volume           = this.ListaToArray (lista = arguments, variavel = 'NFE_QTDE_VOLUME_NFE');
                            v_cod_unidade           = this.ListaToArray (lista = arguments, variavel = 'NFE_COD_UNIDADE_NFE');
                            v_m3                    = this.ListaToArray (lista = arguments, variavel = 'NFE_M3_NFE');
                            v_peso_cubado           = this.ListaToArray (lista = arguments, variavel = 'NFE_PESO_CUBADO_NFE');
                            v_num_natureza          = this.ListaToArray (lista = arguments, variavel = 'NFE_NUM_NATUREZA_NFE');
                            v_complemento           = this.ListaToArray (lista = arguments, variavel = 'NFE_COMPLEMENTO_NFE');
                            v_num_especie           = this.ListaToArray (lista = arguments, variavel = 'NFE_NUM_ESPECIE_NFE');
                            v_altura                = this.ListaToArray (lista = arguments, variavel = 'NFE_ALTURA_NFE');
                            v_largura               = this.ListaToArray (lista = arguments, variavel = 'NFE_LARGURA_NFE');
                            v_comprimento           = this.ListaToArray (lista = arguments, variavel = 'NFE_COMPRIMENTO_NFE');
                            v_cubagem               = this.ListaToArray (lista = arguments, variavel = 'NFE_CUBAGEM_NFE');
                            v_excluir				= this.ListDiff(lista1 = arguments.lista_deleted_NFE, lista2 = ArrayToList(v_coleta_item_id));
                        </cfscript>
						
                        <cfloop list="#v_excluir#" delimiters="," index="l_id">
							<cfscript>
								this.del_coleta_item(coleta_item_id = l_id);
							</cfscript>
						</cfloop>
                        
                        <cfloop from="1" to="#ArrayLen(v_chave_acesso_nfe)#" index="count">
                            <!--- Busca arquivo --->
                            <cfif Len(Trim(v_nome_arquivo[count])) and not Len(Trim(v_coleta_item_id[count]))>
                                <cffile action="read" file="#expandPath("/")#temp/#v_nome_arquivo[count]#" variable="VARQUIVO">
                            <cfelse>
                                <cfset VARQUIVO = ''>
                            </cfif>
                            
                            <cfscript>
                                if(Len(Trim(v_coleta_item_id[count]))){					
									ret_nfe =  this.upd_coleta_item(coleta_item_id  = v_coleta_item_id[count],
																	coleta_id		= arguments.COLETA_ID,
																	num_natureza	= v_num_natureza[count],
																	complemento	 	= v_complemento[count],
																	nf_numero 		= v_numero[count],
																	nf_modelo 		= v_modelo[count],
																	nf_serie 		= v_serie[count],
																	nf_sub_serie 	= 1,
																	nf_data_emissao = v_data_emissao[count],
																	nf_valor	 	= v_nfe_valor[count],
																	valor_segurado  = v_nfe_valor[count],
																	peso_kg	 	 	= v_peso[count],
																	peso_cubado_kg	= v_peso_cubado[count],
																	peso_cobrado_kg = v_peso_cobrado[count],
																	qtde_volume	 	= v_qtde_volume[count],
																	altura			= v_altura[count],
																	comprimento	 	= v_comprimento[count],
																	largura		 	= v_largura[count],
																	M3		 		= v_M3[count],
																	cubagem		 	= v_cubagem[count],
																	ordem_compra	= v_ordem_compra[count],
																	cod_unidade	 	= v_cod_unidade[count],
																	num_especie	 	= v_num_especie[count],
																	cfop		    = '',
																	chave_acesso_nfe = v_chave_acesso_nfe[count],
																	tipo_documento_id = arguments.tipo_documento_id);
								}else{
									ret_nfe =  this.ins_coleta_item(coleta_id		= arguments.COLETA_ID,
																	num_natureza	= v_num_natureza[count],
																	complemento	 	= v_complemento[count],
																	nf_numero 		= v_numero[count],
																	nf_modelo 		= v_modelo[count],
																	nf_serie 		= v_serie[count],
																	nf_sub_serie 	= 1,
																	nf_data_emissao = v_data_emissao[count],
																	nf_valor	 	= v_nfe_valor[count],
																	valor_segurado  = v_nfe_valor[count],
																	peso_kg	 	 	= v_peso[count],
																	peso_cubado_kg	= v_peso_cubado[count],
																	peso_cobrado_kg = v_peso_cobrado[count],
																	qtde_volume	 	= v_qtde_volume[count],
																	altura			= v_altura[count],
																	comprimento	 	= v_comprimento[count],
																	largura		 	= v_largura[count],
																	M3		 		= v_M3[count],
																	cubagem		 	= v_cubagem[count],
																	ordem_compra	= v_ordem_compra[count],
																	cod_unidade	 	= v_cod_unidade[count],
																	num_especie	 	= v_num_especie[count],
																	cfop		    = '',
																	chave_acesso_nfe = v_chave_acesso_nfe[count],
																	nfe_xml		   	= VARQUIVO,
																	tipo_documento_id = arguments.tipo_documento_id);
								
								} 					
								
                            </cfscript>
                            <cfif ret_nfe.erro>
                                <cfthrow object="#ret_nfe.mensagem#">
                            </cfif>
                        </cfloop>
                    </cfcase>
                    
                    <cfcase value="2">
                        <!--- Insere Outros Documentos--->
                        <cfscript>
                            v_coleta_item_id   		= this.ListaToArray (lista = arguments, variavel = "OUTROS_COLETA_ITEM_ID_OUTROS");
							v_outros_numero			= this.ListaToArray (lista = arguments, variavel = "OUTROS_NUMERO_OUTROS");
                            v_outros_data_emissao	= this.ListaToArray (lista = arguments, variavel = "OUTROS_DATA_EMISSAO_OUTROS");
                            v_outros_descricao		= this.ListaToArray (lista = arguments, variavel = "OUTROS_DESCRICAO_OUTROS");
                            v_outros_valor			= this.ListaToArray (lista = arguments, variavel = "OUTROS_VALOR_OUTROS");
                            v_peso                  = this.ListaToArray (lista = arguments, variavel = "OUTROS_PESO_OUTROS");
                            v_peso_cobrado          = this.ListaToArray (lista = arguments, variavel = 'OUTROS_PESO_COBRADO_OUTROS');
                            v_qtde_volume           = this.ListaToArray (lista = arguments, variavel = 'OUTROS_QTDE_VOLUME_OUTROS');
                            v_cod_unidade           = this.ListaToArray (lista = arguments, variavel = 'OUTROS_COD_UNIDADE_OUTROS');
                            v_m3                    = this.ListaToArray (lista = arguments, variavel = 'OUTROS_M3_OUTROS');
                            v_peso_cubado           = this.ListaToArray (lista = arguments, variavel = 'OUTROS_PESO_CUBADO_OUTROS');
                            v_num_natureza          = this.ListaToArray (lista = arguments, variavel = 'OUTROS_NUM_NATUREZA_OUTROS');
                            v_complemento           = this.ListaToArray (lista = arguments, variavel = 'OUTROS_COMPLEMENTO_OUTROS');
                            v_num_especie           = this.ListaToArray (lista = arguments, variavel = 'OUTROS_NUM_ESPECIE_OUTROS');
                            v_altura                = this.ListaToArray (lista = arguments, variavel = 'OUTROS_ALTURA_OUTROS');
                            v_largura               = this.ListaToArray (lista = arguments, variavel = 'OUTROS_LARGURA_OUTROS');
                            v_comprimento           = this.ListaToArray (lista = arguments, variavel = 'OUTROS_COMPRIMENTO_OUTROS');
                            v_cubagem               = this.ListaToArray (lista = arguments, variavel = 'OUTROS_CUBAGEM_OUTROS');
							v_excluir				= this.ListDiff(lista1 = arguments.lista_deleted_OUTROS, lista2 = ArrayToList(v_coleta_item_id));
                        </cfscript>
						
                        <cfloop list="#v_excluir#" delimiters="," index="l_id">
							<cfscript>
								this.del_coleta_item(coleta_item_id = l_id);
							</cfscript>
						</cfloop>
                        
                        <cfloop from="1" to="#ArrayLen(v_outros_numero)#" index="count">
                            <cfscript>
                                if(Len(Trim(v_coleta_item_id[count]))){
									outros =  this.upd_coleta_item(coleta_item_id   = v_coleta_item_id[count],
																   coleta_id		= arguments.COLETA_ID,
																   num_natureza	 	= v_num_natureza[count],
																   complemento	 	= v_complemento[count],
																   nf_numero 		= v_outros_numero[count],
																   nf_modelo 		= '01',
																   nf_serie 		= 'U',
																   nf_sub_serie 	= '1',
																   nf_data_emissao 	= v_outros_data_emissao[count],
																   nf_valor	 	 	= v_outros_valor[count],
																   valor_segurado  	= v_outros_valor[count],
																   peso_kg	 	 	= v_peso[count],
																   peso_cubado_kg	= v_peso_cubado[count],
																   peso_cobrado_kg 	= v_peso_cobrado[count],
																   qtde_volume	 	= v_qtde_volume[count],
																   altura			= v_altura[count],
																   comprimento	 	= v_comprimento[count],
																   largura		 	= v_largura[count],
																   m3		 		= v_m3[count],
																   cubagem		 	= v_cubagem[count],
																   ordem_compra	 	= '',
																   cod_unidade	 	= v_cod_unidade[count],
																   num_especie	 	= v_num_especie[count],
																   cfop		     	= '',
																   chave_acesso_nfe = '',
																   nfe_xml		   	= '',
																   tipo_documento_id = arguments.tipo_documento_id,
																   descricao_docto	 = v_outros_descricao[count]);
								}else{
									outros =  this.ins_coleta_item(coleta_id		= arguments.COLETA_ID,
																   num_natureza	 	= v_num_natureza[count],
																   complemento	 	= v_complemento[count],
																   nf_numero 		= v_outros_numero[count],
																   nf_modelo 		= '01',
																   nf_serie 		= 'U',
																   nf_sub_serie 	= '1',
																   nf_data_emissao 	= v_outros_data_emissao[count],
																   nf_valor	 	 	= v_outros_valor[count],
																   valor_segurado  	= v_outros_valor[count],
																   peso_kg	 	 	= v_peso[count],
																   peso_cubado_kg	= v_peso_cubado[count],
																   peso_cobrado_kg 	= v_peso_cobrado[count],
																   qtde_volume	 	= v_qtde_volume[count],
																   altura			= v_altura[count],
																   comprimento	 	= v_comprimento[count],
																   largura		 	= v_largura[count],
																   m3		 		= v_m3[count],
																   cubagem		 	= v_cubagem[count],
																   ordem_compra	 	= '',
																   cod_unidade	 	= v_cod_unidade[count],
																   num_especie	 	= v_num_especie[count],
																   cfop		     	= '',
																   chave_acesso_nfe = '',
																   nfe_xml		   	= '',
																   tipo_documento_id = arguments.tipo_documento_id,
																   descricao_docto	 = v_outros_descricao[count]);
								}
								
                            </cfscript>
                            <cfif outros.erro>
                                <cfthrow object="#outros.mensagem#">
                            </cfif>
                        </cfloop>
                    </cfcase>                
                </cfswitch>
                
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Coleta confirmada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROP?SITO
	-- Cancela Agendamento
	-- wagner 22/10/2006 18:18:11 - CRIADO
	--->
	<cffunction name='cancela_agendamento' displayname='Cancela Agendamento' access='remote' returntype='Struct' output='true'>
		<cfargument name='COLETA_ID' required='yes'>
		<cfargument name='COD_CANCELAMENTO' required='yes'>
		<cfargument name='DATA_CANCELAMENTO' required='yes'>
		<cfargument name='MOTIVO_CANCELAMENTO' required='no' default="">
		<cftry>
            <cfstoredproc procedure='oper.pkg_ctrl_carga.prc_cancela_agendamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COLETA_ID'  value='#arguments.COLETA_ID#'  null='#iif(len(trim(arguments.COLETA_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CANCELAMENTO'  value='#arguments.COD_CANCELAMENTO#'  null='#iif(len(trim(arguments.COD_CANCELAMENTO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_CANCELAMENTO'  value='#arguments.DATA_CANCELAMENTO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MOTIVO_CANCELAMENTO'  value='#arguments.MOTIVO_CANCELAMENTO#' >
            </cfstoredproc>
			<cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Agendamento cancelado com sucesso!')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROP?SITO
	-- Cancela a Coleta
	-- wagner 22/10/2006 18:18:11 - CRIADO
	--->
	<cffunction name='cancela_coleta' displayname='Cancela a Coleta' access='remote' returntype='Struct' output='true'>
		<cfargument name='COLETA_ID' required='yes'>
		<cfargument name='COD_CANCELAMENTO' required='yes'>
		<cfargument name='DATA_CANCELAMENTO' required='yes'>
		<cfargument name='MOTIVO_CANCELAMENTO' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_ctrl_carga.prc_cancela_coleta' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COLETA_ID'  value='#arguments.COLETA_ID#'  null='#iif(len(trim(arguments.COLETA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CANCELAMENTO'  value='#arguments.COD_CANCELAMENTO#'  null='#iif(len(trim(arguments.COD_CANCELAMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_CANCELAMENTO'  value='#arguments.DATA_CANCELAMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MOTIVO_CANCELAMENTO'  value='#arguments.MOTIVO_CANCELAMENTO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Coleta cancelada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere uma entrega
	-- wagner 25/10/2006 14:17:24 - CRIADO
	--->
	<cffunction name='ins_entrega' displayname='Insere uma entrega' access='remote' returntype='Struct' output='true'>
		<cfargument name='DATA_ENTREGA' required='yes'>
		<cfargument name='REM_COD_PESSOA' required='yes'>
		<cfargument name='REM_LOGRADOURO' required='yes'>
		<cfargument name='REM_COMPLEMENTO' required='yes'>
		<cfargument name='REM_BAIRRO' required='yes'>
		<cfargument name='REM_CEP' required='yes'>
		<cfargument name='REM_MUNICIPIO_ID' required='yes'>
		<cfargument name='LOCAL_CARGA' required='yes'>
		<cfargument name='DEST_COD_PESSOA' required='yes'>
		<cfargument name='DEST_LOGRADOURO' required='yes'>
		<cfargument name='DEST_COMPLEMENTO' required='yes'>
		<cfargument name='DEST_BAIRRO' required='yes'>
		<cfargument name='DEST_CEP' required='yes'>
		<cfargument name='DEST_MUNICIPIO_ID' required='yes'>
		<cfargument name='LOCAL_DESCARGA' required='yes'>
		<cfargument name='CARGA_NF_ID' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
		<cfargument name='PLACA' required='yes'>
		<cfargument name='COD_MOTORISTA' required='yes'>
		<cfargument name='COD_PESSOA_FILIAL' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_ctrl_carga.prc_ins_entrega' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_ENTREGA'  value='#arguments.DATA_ENTREGA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REM_COD_PESSOA'  value='#arguments.REM_COD_PESSOA#'  null='#iif(len(trim(arguments.REM_COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_LOGRADOURO'  value='#arguments.REM_LOGRADOURO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_COMPLEMENTO'  value='#arguments.REM_COMPLEMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_BAIRRO'  value='#arguments.REM_BAIRRO#' >
					
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_CEP'  value='#arguments.REM_CEP#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REM_MUNICIPIO_ID'  value='#arguments.REM_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.REM_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_LOCAL_CARGA'  value='#arguments.LOCAL_CARGA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DEST_COD_PESSOA'  value='#arguments.DEST_COD_PESSOA#'  null='#iif(len(trim(arguments.DEST_COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_LOGRADOURO'  value='#arguments.DEST_LOGRADOURO#' >
					
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_COMPLEMENTO'  value='#arguments.DEST_COMPLEMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_BAIRRO'  value='#arguments.DEST_BAIRRO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_CEP'  value='#arguments.DEST_CEP#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DEST_MUNICIPIO_ID'  value='#arguments.DEST_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.DEST_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_LOCAL_DESCARGA'  value='#arguments.LOCAL_DESCARGA#' >
					
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_FILIAL'  value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENTREGA_ID' variable='retorno.ENTREGA_ID' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				
				<cfscript>
						v_num_natureza 	   	= this.ListaToArray (lista = arguments, variavel = "NUM_NATUREZA_ENTREGA_ITENS");
						v_complemento 		= this.ListaToArray (lista = arguments, variavel = "COMPLEMENTO_ENTREGA_ITENS");
						v_nf_numero 	   	= this.ListaToArray (lista = arguments, variavel = "NF_NUMERO_ENTREGA_ITENS");
						v_nf_serie    		= this.ListaToArray (lista = arguments, variavel = "NF_SERIE_ENTREGA_ITENS");
						v_nf_data_emissao	= this.ListaToArray (lista = arguments, variavel = "NF_DATA_EMISSAO_ENTREGA_ITENS");
						v_nf_valor    		= this.ListaToArray (lista = arguments, variavel = "NF_VALOR_ENTREGA_ITENS");
						v_peso_kg       	= this.ListaToArray (lista = arguments, variavel = "PESO_KG_ENTREGA_ITENS");
						v_peso_cubado_kg	= this.ListaToArray (lista = arguments, variavel = "PESO_CUBADO_KG_ENTREGA_ITENS");
						v_peso_cobrado_kg	= this.ListaToArray (lista = arguments, variavel = "PESO_COBRADO_KG_ENTREGA_ITENS");
						v_qtde_volume		= this.ListaToArray (lista = arguments, variavel = "QTDE_VOLUME_ENTREGA_ITENS");
						v_altura			= this.ListaToArray (lista = arguments, variavel = "ALTURA_ENTREGA_ITENS");
						v_comprimento		= this.ListaToArray (lista = arguments, variavel = "COMPRIMENTO_ENTREGA_ITENS");
						v_largura			= this.ListaToArray (lista = arguments, variavel = "LARGURA_ENTREGA_ITENS");
						v_m3				= this.ListaToArray (lista = arguments, variavel = "M3_ENTREGA_ITENS");
						v_cubagem			= this.ListaToArray (lista = arguments, variavel = "CUBAGEM_ENTREGA_ITENS");
						v_carga_nf_id		= this.ListaToArray (lista = arguments, variavel = "CARGA_NF_ID_ENTREGA_ITENS");
				</cfscript>
   				
				<cfloop from="1" to="#ArrayLen(v_num_natureza)#" index="count">
					<cfscript>
						this.ins_entrega_item(entrega_id = retorno.ENTREGA_ID,
												 num_natureza	 = v_num_natureza[count],
												 complemento	 = v_complemento[count],
												 nf_numero 		 = v_nf_numero[count],
												 nf_serie 		 = v_nf_serie[count],
												 nf_data_emissao = v_nf_data_emissao[count],
												 nf_valor	 	 = v_nf_valor[count],
												 peso_kg	 	 = v_peso_kg[count],
												 peso_cubado_kg	 = v_peso_cubado_kg[count],
												 peso_cobrado_kg = v_peso_cobrado_kg[count],
												 qtde_volume	 = v_qtde_volume[count],
												 altura			 = v_altura[count],
												 comprimento	 = v_comprimento[count],
												 largura		 = v_largura[count],
												 m3		 		 = v_m3[count],
												 cubagem		 = v_cubagem[count],
												 carga_nf_id	 = v_carga_nf_id[count]);
					</cfscript>
				</cfloop>
				<cfscript>
						this.ins_entrega_veiculo( entrega_id 		= retorno.ENTREGA_ID
												, cod_agendamento	= session.cod_pessoa_usuario
												, data_agendamento	= LSDateFormat(Now(),'dd/mm/yyyy') &' - '& LSTimeFormat(Now(),'HH:MM')
												, placa				= Replace(arguments.placa,"-","","ALL")
												, cod_motorista		= arguments.cod_motorista
												, data_entrega		= arguments.data_entrega
												, situacao_id		= 4);
													
					
					
				</cfscript>
				
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Entrega inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere uma item na entrega
	-- wagner 25/10/2006 14:23:25 - CRIADO
	--->
	<cffunction name='ins_entrega_item' displayname='Insere uma item na entrega' access='remote' returntype='Struct' output='true'>
		<cfargument name='ENTREGA_ID' required='yes'>
		<cfargument name='NUM_NATUREZA' required='yes'>
		<cfargument name='COMPLEMENTO' required='yes'>
		<cfargument name='NF_NUMERO' required='yes'>
		<cfargument name='NF_SERIE' required='yes'>
		<cfargument name='NF_DATA_EMISSAO' required='yes'>
		<cfargument name='NF_VALOR' required='yes'>
		<cfargument name='PESO_KG' required='yes'>
		<cfargument name='PESO_CUBADO_KG' required='yes'>
		<cfargument name='PESO_COBRADO_KG' required='yes'>
		<cfargument name='QTDE_VOLUME' required='yes'>
		<cfargument name='ALTURA' required='yes'>
		<cfargument name='COMPRIMENTO' required='yes'>
		<cfargument name='LARGURA' required='yes'>
		<cfargument name='M3' required='yes'>
		<cfargument name='CUBAGEM' required='yes'>
		<cfargument name='CARGA_NF_ID' required='yes'>
				<cfstoredproc procedure='oper.pkg_ctrl_carga.prc_ins_entrega_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENTREGA_ID'  value='#arguments.ENTREGA_ID#'  null='#iif(len(trim(arguments.ENTREGA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NATUREZA'  value='#arguments.NUM_NATUREZA#'  null='#iif(len(trim(arguments.NUM_NATUREZA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMPLEMENTO'  value='#arguments.COMPLEMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NF_NUMERO'  value='#arguments.NF_NUMERO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NF_SERIE'  value='#arguments.NF_SERIE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NF_DATA_EMISSAO'  value='#arguments.NF_DATA_EMISSAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NF_VALOR'  value='#arguments.NF_VALOR#'  null='#iif(len(trim(arguments.NF_VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PESO_KG'  value='#arguments.PESO_KG#'  null='#iif(len(trim(arguments.PESO_KG)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PESO_CUBADO_KG'  value='#arguments.PESO_CUBADO_KG#'  null='#iif(len(trim(arguments.PESO_CUBADO_KG)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PESO_COBRADO_KG'  value='#arguments.PESO_COBRADO_KG#'  null='#iif(len(trim(arguments.PESO_COBRADO_KG)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QTDE_VOLUME'  value='#arguments.QTDE_VOLUME#'  null='#iif(len(trim(arguments.QTDE_VOLUME)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ALTURA'  value='#arguments.ALTURA#'  null='#iif(len(trim(arguments.ALTURA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COMPRIMENTO'  value='#arguments.COMPRIMENTO#'  null='#iif(len(trim(arguments.COMPRIMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LARGURA'  value='#arguments.LARGURA#'  null='#iif(len(trim(arguments.LARGURA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_M3'  value='#arguments.M3#'  null='#iif(len(trim(arguments.M3)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CUBAGEM'  value='#arguments.CUBAGEM#'  null='#iif(len(trim(arguments.CUBAGEM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CARGA_NF_ID'  value='#arguments.CARGA_NF_ID#'  null='#iif(len(trim(arguments.CARGA_NF_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENTREGA_ITEM_ID' variable='retorno.ENTREGA_ITEM_ID' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Inserir uma ocorrncia de uma veculo para uma entrega
	 
	-- wagner 25/10/2006 16:40:36 - CRIADO
	--->
	<cffunction name='ins_entrega_veiculo' displayname='Inserir uma ocorrncia de uma veculo para uma entrega' access='remote' returntype='Struct' output='true'>
		<cfargument name='ENTREGA_ID' required='yes'>
		<cfargument name='COD_AGENDAMENTO' required='yes'>
		<cfargument name='DATA_AGENDAMENTO' required='yes'>
		<cfargument name='PLACA' required='yes'>
		<cfargument name='COD_MOTORISTA' required='yes'>
		<cfargument name='DATA_ENTREGA' required='yes'>
		<cfargument name='COD_CONFIRMACAO' required='no' default="">
		<cfargument name='DATA_CONFIRMACAO' required='no' default="">
		<cfargument name='COD_CANCELAMENTO' required='no' default="">
		<cfargument name='DATA_CANCELAMENTO' required='no' default="">
		<cfargument name='SITUACAO_ID' required='yes'>
		<cfargument name='ENTREGA_VEI_ID' required='no' default="0">
				<cfstoredproc procedure='oper.pkg_ctrl_carga.prc_ins_entrega_veiculo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENTREGA_ID'  value='#arguments.ENTREGA_ID#'  null='#iif(len(trim(arguments.ENTREGA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_AGENDAMENTO'  value='#arguments.COD_AGENDAMENTO#'  null='#iif(len(trim(arguments.COD_AGENDAMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_AGENDAMENTO'  value='#arguments.DATA_AGENDAMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_MOTORISTA'  value='#arguments.COD_MOTORISTA#'  null='#iif(len(trim(arguments.COD_MOTORISTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_ENTREGA'  value='#arguments.DATA_ENTREGA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CONFIRMACAO'  value='#arguments.COD_CONFIRMACAO#'  null='#iif(len(trim(arguments.COD_CONFIRMACAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_CONFIRMACAO'  value='#arguments.DATA_CONFIRMACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CANCELAMENTO'  value='#arguments.COD_CANCELAMENTO#'  null='#iif(len(trim(arguments.COD_CANCELAMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_CANCELAMENTO'  value='#arguments.DATA_CANCELAMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SITUACAO_ID'  value='#arguments.SITUACAO_ID#' >
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENTREGA_VEI_ID'  value='#arguments.ENTREGA_VEI_ID#' variable='retorno.ENTREGA_VEI_ID'  null='#iif(len(trim(arguments.ENTREGA_VEI_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
	
	
	<!--- 
	-- PROPSITO
	-- Alterar uma ocorrncia de uma veculo para uma entrega
	 
	-- wagner 25/10/2006 16:42:41 - CRIADO
	--->
	<cffunction name='upd_entrega_veiculo' displayname='Alterar uma ocorrncia de uma veculo para uma entrega' access='remote' returntype='Struct' output='true'>
		<cfargument name='ENTREGA_VEI_ID' required='yes'>
		<cfargument name='ENTREGA_ID' required='yes'>
		<cfargument name='COD_AGENDAMENTO' required='yes'>
		<cfargument name='DATA_AGENDAMENTO' required='yes'>
		<cfargument name='PLACA' required='yes'>
		<cfargument name='COD_MOTORISTA' required='yes'>
		<cfargument name='DATA_ENTREGA' required='yes'>
		<cfargument name='COD_CONFIRMACAO' required='yes'>
		<cfargument name='DATA_CONFIRMACAO' required='yes'>
		<cfargument name='COD_CANCELAMENTO' required='yes'>
		<cfargument name='DATA_CANCELAMENTO' required='yes'>
		<cfargument name='SITUACAO_ID' required='yes'>
				<cfstoredproc procedure='oper.pkg_ctrl_carga.prc_alt_entrega_veiculo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENTREGA_VEI_ID'  value='#arguments.ENTREGA_VEI_ID#'  null='#iif(len(trim(arguments.ENTREGA_VEI_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENTREGA_ID'  value='#arguments.ENTREGA_ID#'  null='#iif(len(trim(arguments.ENTREGA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_AGENDAMENTO'  value='#arguments.COD_AGENDAMENTO#'  null='#iif(len(trim(arguments.COD_AGENDAMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_AGENDAMENTO'  value='#arguments.DATA_AGENDAMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_MOTORISTA'  value='#arguments.COD_MOTORISTA#'  null='#iif(len(trim(arguments.COD_MOTORISTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_ENTREGA'  value='#arguments.DATA_ENTREGA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CONFIRMACAO'  value='#arguments.COD_CONFIRMACAO#'  null='#iif(len(trim(arguments.COD_CONFIRMACAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_CONFIRMACAO'  value='#arguments.DATA_CONFIRMACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CANCELAMENTO'  value='#arguments.COD_CANCELAMENTO#'  null='#iif(len(trim(arguments.COD_CANCELAMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_CANCELAMENTO'  value='#arguments.DATA_CANCELAMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SITUACAO_ID'  value='#arguments.SITUACAO_ID#' >
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Insere um CTRC na carga
	-- Cristofer 30/10/2006 16:42:41 - CRIADO
	--->
	<cffunction name='ins_carga_ctrc' displayname='Insere um CTRC na carga' access='remote' returntype='Struct' output='true'>
		<cfargument name='CARGA_ID' required='yes'>
		<cfargument name='CONHECIMENTO_ID' required='no' default="">
		<cfargument name='NUM_NOTA_ID' required='no' default="">
		<cfargument name='MANIFESTO_ID' required='no' default="">
				<cfstoredproc procedure='oper.pkg_ctrl_carga.prc_ins_carga_ctrc' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CARGA_ID'  value='#arguments.CARGA_ID#'  null='#iif(len(trim(arguments.CARGA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MANIFESTO_ID'  value='#arguments.MANIFESTO_ID#'  null='#iif(len(trim(arguments.MANIFESTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CARGA_CTRC_ID'  variable='retorno.CARGA_CTRC_ID'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>

	
	<!--- 
	-- PROPSITO
	-- Gerar uma entrega apartir de uma Carga
	-- wagner 01/11/2006 17:29:14 - CRIADO
	--->
	<cffunction name='gerar_entrega' displayname='Gerar uma entrega apartir de uma Carga' access='remote' returntype='Struct' output='true'>
		<cfargument name='CARGA_ID' required='yes'>
		<cfargument name='DATA_ENTREGA' required='yes'>
		<cfargument name='COD_AGENDAMENTO' required='yes'>
		<cfargument name='DATA_AGENDAMENTO' required='yes'>
		<cfargument name='PLACA' required='yes'>
		<cfargument name='COD_MOTORISTA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_ctrl_carga.prc_gerar_entrega' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CARGA_ID'  value='#arguments.CARGA_ID#'  null='#iif(len(trim(arguments.CARGA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_ENTREGA'  value='#arguments.DATA_ENTREGA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_AGENDAMENTO'  value='#arguments.COD_AGENDAMENTO#'  null='#iif(len(trim(arguments.COD_AGENDAMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_AGENDAMENTO'  value='#arguments.DATA_AGENDAMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_MOTORISTA'  value='#arguments.COD_MOTORISTA#'  null='#iif(len(trim(arguments.COD_MOTORISTA)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Entrega gerada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Insere um manifesto
	-- cristofer 23/10/2006 10:01:59 - CRIADO
	--->
	<cffunction name='ins_manifesto' displayname='Insere um manifesto' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_PESSOA_FILIAL' required='no' default="#session.cod_pessoa#">
		<cfargument name='CD_ORIGEM' required='yes'>
		<cfargument name='ORG_MUNICIPIO_ID' required='yes'>
		<cfargument name='CD_DESTINO' required='yes'>
		<cfargument name='DEST_MUNICIPIO_ID' required='yes'>
		<cfargument name='PLACA_TRACAO' required='yes'>
		<cfargument name='PLACA_REBOQUE' required='yes'>
		<cfargument name='DATA_INICIO' required='yes'>
		<cfargument name='DATA_TERMINO' required='yes'>
		<cfargument name='KM_INICIO' required='yes'>
		<cfargument name='KM_TERMINO' required='no' default="">
		<cfargument name='SITUACAO_ID' required='no' default="0">
		<cfargument name='LIBERACAO_SEGURADORA' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
		<cfargument name='ENTREGA_DIRETA' required='no' default="0">
		<cfargument name='NUM_LOTE' required='no' default="">
		<cfargument name='NUM_ROMANEIO' required='no' default="0">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_manifesto_dml.prc_ins_manifesto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_PESSOA_FILIAL'  value='#arguments.COD_PESSOA_FILIAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CD_ORIGEM'  value='#arguments.CD_ORIGEM#'  null='#iif(len(trim(arguments.CD_ORIGEM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ORG_MUNICIPIO_ID'  value='#arguments.ORG_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.ORG_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CD_DESTINO'  value='#arguments.CD_DESTINO#'  null='#iif(len(trim(arguments.CD_DESTINO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DEST_MUNICIPIO_ID'  value='#arguments.DEST_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.DEST_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA_TRACAO'  value='#arguments.PLACA_TRACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA_REBOQUE'  value='#arguments.PLACA_REBOQUE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO'  value='#arguments.DATA_INICIO#' null='#iif(len(trim(arguments.DATA_INICIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_TERMINO'  value='#arguments.DATA_TERMINO#' null='#iif(len(trim(arguments.DATA_TERMINO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_KM_INICIO'  value='#arguments.KM_INICIO#'  null='#iif(len(trim(arguments.KM_INICIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_KM_TERMINO'  value='#arguments.KM_TERMINO#'  null='#iif(len(trim(arguments.KM_TERMINO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SITUACAO_ID'  value='#arguments.SITUACAO_ID#'  null='#iif(len(trim(arguments.SITUACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_LIBERACAO_SEGURADORA'  value='#arguments.LIBERACAO_SEGURADORA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENTREGA_DIRETA'  value='#arguments.ENTREGA_DIRETA#'  null='#iif(len(trim(arguments.ENTREGA_DIRETA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_LOTE'  value='#arguments.NUM_LOTE#'  null='#iif(len(trim(arguments.NUM_LOTE)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MANIFESTO_ID' variable='retorno.MANIFESTO_ID' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUM_MANIFESTO' variable='retorno.NUM_MANIFESTO' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<!--- Lacres --->
				<cfscript>
					v_num_lacre = this.ListaToArray (lista = arguments, variavel = "LACRE_NUM_LACRE_LACRES");
					v_email_excluir = this.ListDiff(lista1 = arguments.lista_deleted_LACRES, lista2 = ArrayToList(v_num_lacre));
				</cfscript>
				<cfloop list="#v_email_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_manifesto_lacre (manifesto_id = retorno.manifesto_id,
												  num_lacre   = l_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_num_lacre)#" index="count">
					<cfscript>
						this.ins_manifesto_lacre(manifesto_id = retorno.manifesto_id,
												num_lacre = v_num_lacre[count]);
					</cfscript>
				</cfloop>
				
				<!--- Motoristas --->
				<cfscript>
					v_cod_pessoa = this.ListaToArray (lista = arguments, variavel = "MOTORISTA_COD_PESSOA_MOTORISTAS");
					v_cod_pessoa_old = this.ListaToArray (lista = arguments, variavel = "MOTORISTA_COD_PESSOA_OLD_MOTORISTAS");
					v_data_inicio = this.ListaToArray (lista = arguments, variavel = "MOTORISTA_DATA_INICIO_MOTORISTAS");
					v_data_termino = this.ListaToArray (lista = arguments, variavel = "MOTORISTA_DATA_TERMINO_MOTORISTAS");
					v_org_municipio_id = this.ListaToArray (lista = arguments, variavel = "MOTORISTA_MUNICIPIO_ID_MOTORISTAS");
					v_email_excluir = this.ListDiff(lista1 = arguments.lista_deleted_MOTORISTAS, lista2 = ArrayToList(v_cod_pessoa));
				</cfscript>
				<cfloop list="#v_email_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_manifesto_motorista (manifesto_id = retorno.manifesto_id,
												  		cod_pessoa   = l_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_cod_pessoa_old)#" index="count">
					<cfscript>
						if(not len(trim(v_cod_pessoa_old[count]))) {
							this.ins_manifesto_motorista(manifesto_id = retorno.manifesto_id,
														cod_pessoa = v_cod_pessoa[count],
														data_inicio = v_data_inicio[count],
														data_termino = v_data_termino[count],
														org_municipio_id = v_org_municipio_id[count]);
						} else {
							this.upd_manifesto_motorista(manifesto_id = retorno.manifesto_id,
														cod_pessoa = v_cod_pessoa[count],
														data_inicio = v_data_inicio[count],
														data_termino = v_data_termino[count],
														org_municipio_id = v_org_municipio_id[count]);
						}
					</cfscript>
				</cfloop>
				<!--- Conhecimentos --->
				<cfscript>
//					retorno.manifesto_id = arguments.manifesto_id;
					v_conhecimento_id = this.ListaToArray (lista = arguments, variavel = "CTRC_CONHECIMENTO_ID_CTRCS");
					v_email_excluir = this.ListDiff(lista1 = arguments.lista_deleted_CTRCS, lista2 = ArrayToList(v_conhecimento_id));
				</cfscript>
				<cfloop list="#v_email_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_manifesto_ctrc (manifesto_id = retorno.manifesto_id,
												conhecimento_id   = l_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_conhecimento_id)#" index="count">
					<cfscript>
						this.ins_manifesto_ctrc(manifesto_id = retorno.manifesto_id,
												conhecimento_id = v_conhecimento_id[count]);
					</cfscript>
				</cfloop>
				
				<!--- Vincula ao romaneio se for frota --->
				<cfif arguments.num_romaneio gt 0>
					<cfscript>
						conn = CreateObject("component","_transportes.manipulacao.cfc_controle_trafego");
						set_item = conn.ins_romaneio_item	(num_romaneio		= arguments.num_romaneio
															,num_lote			= arguments.num_lote
															,volume				= arguments.total_volume
															,cod_unidade		= 'Kg'
															,peso				= arguments.total_peso
															,m3					= arguments.total_cubagem
															,valor_frete		= arguments.total_conhecimentos
															,cod_remetente		= arguments.cod_remetente
															,redespacho			= 0
															,rem_cod_uf			= ''
															,rem_cod_municipio	= ''
															,rem_cod_distrito	= ''
															,rem_cod_dv			= ''
															,rem_municipio_id	= arguments.org_municipio_id
															,cod_destinatario	= arguments.cod_destinatario
															,dest_cod_uf		= ''
															,dest_cod_municipio	= ''
															,dest_cod_distrito	= ''
															,dest_cod_dv		= ''
															,dest_municipio_id	= arguments.dest_municipio_id
															,valor_frete_liquido= 0
															,despacho			= 0
															,observacao			= ''
															,manifesto_id		= ''
															,ordem				= 1
															,data_previsao		= ''
															);
						
					</cfscript>
					<cfset arguments.item_id = set_item.item_id>

					<!---Gera Rota--->
					<cfscript>
						ins_rota = conn.ins_itinerario_item_romaneio(num_romaneio = arguments.num_romaneio,
																	 item_id	  = arguments.item_id,
																	 municipio_origem_id = arguments.org_municipio_id,
																	 municipio_destino_id = arguments.dest_municipio_id);
					</cfscript>

					<cfif ins_rota.erro>
						<cfthrow object="#ins_rota.mensagem#">
					</cfif>
					
					<!--- Vincula Manifesto ao romaneio --->
					<cfscript>
						conn.vincula_roo_item(manifesto_id = retorno.MANIFESTO_ID, 
						                      roo_item_id  = arguments.item_id);
					</cfscript>
				</cfif>
                
                <!--- Valida o manifesto --->
				<cfscript>
					val_mani = this.validar_manifesto(manifesto_id = retorno.manifesto_id); 
				</cfscript>	
                
                <cfif val_mani.erro>
                    <cfthrow object="#val_mani.mensagem#">
                </cfif>		
                
                <!--- Valida o manifesto --->
				<cfscript>
					val_mani = this.validar_manifesto(manifesto_id = retorno.manifesto_id); 
				</cfscript>	
                
                <cfif val_mani.erro>
                    <cfthrow object="#val_mani.mensagem#">
                </cfif>
                		
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Manifesto n #NumberFormat(retorno.num_manifesto,'0')# inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera um manifesto
	-- cristofer 23/10/2006 10:06:20 - CRIADO
	--->
	<cffunction name='upd_manifesto' displayname='Altera um manifesto' access='remote' returntype='Struct' output='true'>
		<cfargument name='MANIFESTO_ID' required='yes'>
		<cfargument name='CD_ORIGEM' required='yes'>
		<cfargument name='ORG_MUNICIPIO_ID' required='yes'>
		<cfargument name='CD_DESTINO' required='yes'>
		<cfargument name='DEST_MUNICIPIO_ID' required='yes'>
		<cfargument name='PLACA_TRACAO' required='yes'>
		<cfargument name='PLACA_REBOQUE' required='yes'>
		<cfargument name='DATA_INICIO' required='yes'>
		<cfargument name='DATA_TERMINO' required='yes'>
		<cfargument name='KM_INICIO' required='yes'>
		<cfargument name='KM_TERMINO' required='no' default="">
		<cfargument name='SITUACAO_ID' required='no' default="0">
		<cfargument name='ENTREGA_DIRETA' required='no' default="0">
		<cfargument name='NUM_LOTE' required='no' default="">
		<cfargument name='LIBERACAO_SEGURADORA' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
		<cfargument name='NUM_ROMANEIO' required='no' default="0">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_manifesto_dml.prc_alt_manifesto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MANIFESTO_ID'  value='#arguments.MANIFESTO_ID#'  null='#iif(len(trim(arguments.MANIFESTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CD_ORIGEM'  value='#arguments.CD_ORIGEM#'  null='#iif(len(trim(arguments.CD_ORIGEM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ORG_MUNICIPIO_ID'  value='#arguments.ORG_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.ORG_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CD_DESTINO'  value='#arguments.CD_DESTINO#'  null='#iif(len(trim(arguments.CD_DESTINO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DEST_MUNICIPIO_ID'  value='#arguments.DEST_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.DEST_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA_TRACAO'  value='#arguments.PLACA_TRACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA_REBOQUE'  value='#arguments.PLACA_REBOQUE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO'  value='#arguments.DATA_INICIO#' null='#iif(len(trim(arguments.DATA_INICIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_TERMINO'  value='#arguments.DATA_TERMINO#' null='#iif(len(trim(arguments.DATA_TERMINO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_KM_INICIO'  value='#arguments.KM_INICIO#'  null='#iif(len(trim(arguments.KM_INICIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_KM_TERMINO'  value='#arguments.KM_TERMINO#'  null='#iif(len(trim(arguments.KM_TERMINO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SITUACAO_ID'  value='#arguments.SITUACAO_ID#'  null='#iif(len(trim(arguments.SITUACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_LIBERACAO_SEGURADORA'  value='#arguments.LIBERACAO_SEGURADORA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENTREGA_DIRETA'  value='#arguments.ENTREGA_DIRETA#'  null='#iif(len(trim(arguments.ENTREGA_DIRETA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_LOTE'  value='#arguments.NUM_LOTE#'  null='#iif(len(trim(arguments.NUM_LOTE)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<!--- Conhecimentos --->
				<cfscript>
					retorno.manifesto_id = arguments.manifesto_id;
					v_conhecimento_id = this.ListaToArray (lista = arguments, variavel = "CTRC_CONHECIMENTO_ID_CTRCS");
					v_email_excluir = this.ListDiff(lista1 = arguments.lista_deleted_CTRCS, lista2 = ArrayToList(v_conhecimento_id));
				</cfscript>
				<cfloop list="#v_email_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_manifesto_ctrc (manifesto_id = retorno.manifesto_id,
												conhecimento_id   = l_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_conhecimento_id)#" index="count">
					<cfscript>
						this.ins_manifesto_ctrc(manifesto_id = retorno.manifesto_id,
												conhecimento_id = v_conhecimento_id[count]);
					</cfscript>
				</cfloop>
				<!--- Lacres --->
				<cfscript>
					v_num_lacre = this.ListaToArray (lista = arguments, variavel = "LACRE_NUM_LACRE_LACRES");
					v_email_excluir = this.ListDiff(lista1 = arguments.lista_deleted_LACRES, lista2 = ArrayToList(v_num_lacre));
				</cfscript>
				<cfloop list="#v_email_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_manifesto_lacre (manifesto_id = retorno.manifesto_id,
												  num_lacre   = l_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_num_lacre)#" index="count">
					<cfscript>
						this.ins_manifesto_lacre(manifesto_id = retorno.manifesto_id,
												num_lacre = v_num_lacre[count]);
					</cfscript>
				</cfloop>
				
				<!--- Motoristas --->
				<cfscript>
					v_cod_pessoa = this.ListaToArray (lista = arguments, variavel = "MOTORISTA_COD_PESSOA_MOTORISTAS");
					v_cod_pessoa_old = this.ListaToArray (lista = arguments, variavel = "MOTORISTA_COD_PESSOA_OLD_MOTORISTAS");
					v_data_inicio = this.ListaToArray (lista = arguments, variavel = "MOTORISTA_DATA_INICIO_MOTORISTAS");
					v_data_termino = this.ListaToArray (lista = arguments, variavel = "MOTORISTA_DATA_TERMINO_MOTORISTAS");
					v_org_municipio_id = this.ListaToArray (lista = arguments, variavel = "MOTORISTA_MUNICIPIO_ID_MOTORISTAS");
					v_org_cod_municipio = this.ListaToArray (lista = arguments, variavel = "MOTORISTA_COD_MUNICIPIO_MOTORISTAS");
					v_org_cod_distrito = this.ListaToArray (lista = arguments, variavel = "MOTORISTA_COD_DISTRITO_MOTORISTAS");
					v_org_cod_dv = this.ListaToArray (lista = arguments, variavel = "MOTORISTA_COD_DV_MOTORISTAS");
					v_email_excluir = this.ListDiff(lista1 = arguments.lista_deleted_MOTORISTAS, lista2 = ArrayToList(v_cod_pessoa));
				</cfscript>
				<cfloop list="#v_email_excluir#" delimiters="," index="l_id">
					<cfscript>
						this.del_manifesto_motorista (manifesto_id = retorno.manifesto_id,
												  		cod_pessoa   = l_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_cod_pessoa_old)#" index="count">
					<cfscript>
						if(not len(trim(v_cod_pessoa_old[count]))) {
							this.ins_manifesto_motorista(manifesto_id = retorno.manifesto_id,
														cod_pessoa = v_cod_pessoa[count],
														data_inicio = v_data_inicio[count],
														data_termino = v_data_termino[count],
														org_municipio_id = v_org_municipio_id[count]);
						} else {
							this.upd_manifesto_motorista(manifesto_id = retorno.manifesto_id,
														cod_pessoa = v_cod_pessoa[count],
														data_inicio = v_data_inicio[count],
														data_termino = v_data_termino[count],
														org_municipio_id = v_org_municipio_id[count]);
						}
					</cfscript>
				</cfloop>

				<!--- Vincula ao romaneio se for frota --->
				<cfif arguments.num_romaneio gt 0>
					<cfscript>
						conn = CreateObject("component","_transportes.manipulacao.cfc_controle_trafego");
						set_item = conn.ins_romaneio_item	(num_romaneio		= arguments.num_romaneio
															,num_lote			= arguments.num_lote
															,volume				= arguments.total_volume
															,cod_unidade		= 'Kg'
															,peso				= arguments.total_peso
															,m3					= arguments.total_cubagem
															,valor_frete		= arguments.total_conhecimentos
															,cod_remetente		= arguments.cod_remetente
															,redespacho			= 0
															,rem_cod_uf			= ''
															,rem_cod_municipio	= ''
															,rem_cod_distrito	= ''
															,rem_cod_dv			= ''
															,rem_municipio_id	= arguments.org_municipio_id
															,cod_destinatario	= arguments.cod_destinatario
															,dest_cod_uf		= ''
															,dest_cod_municipio	= ''
															,dest_cod_distrito	= ''
															,dest_cod_dv		= ''
															,dest_municipio_id	= arguments.dest_municipio_id
															,valor_frete_liquido= 0
															,despacho			= 0
															,observacao			= ''
															,manifesto_id		= ''
															,ordem				= 1
															,data_previsao		= ''
															);
						
					</cfscript>
					<cfset arguments.item_id = set_item.item_id>

					<!---Gera Rota--->
					<cfscript>
						ins_rota = conn.ins_itinerario_item_romaneio(num_romaneio = arguments.num_romaneio,
																	 item_id	  = arguments.item_id,
																	 municipio_origem_id = arguments.org_municipio_id,
																	 municipio_destino_id = arguments.dest_municipio_id);
					</cfscript>

					<cfif ins_rota.erro>
						<cfthrow object="#ins_rota.mensagem#">
					</cfif>
					
					<!--- Vincula Manifesto ao romaneio --->
					<cfscript>
						conn.vincula_roo_item(manifesto_id = retorno.MANIFESTO_ID, 
						                      roo_item_id  = arguments.item_id);
					</cfscript>
				</cfif>						
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Manifesto alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere um ctrc no manifesto
	-- cristofer 23/10/2006 10:07:15 - CRIADO
	--->
	<cffunction name='ins_manifesto_ctrc' displayname='Insere um ctrc no manifesto' access='remote' returntype='Struct' output='true'>
		<cfargument name='MANIFESTO_ID' required='yes'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cfargument name='MANIFESTO_ID_REDESPACHO' required='no' default="">
		<cfstoredproc procedure='oper.pkg_manifesto_dml.prc_ins_manifesto_ctrc' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MANIFESTO_ID'  value='#arguments.MANIFESTO_ID#'  null='#iif(len(trim(arguments.MANIFESTO_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MANIFESTO_ID_REDESPACHO'  value='#arguments.MANIFESTO_ID_REDESPACHO#' >
			<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
		</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um ctrc do manifesto
	-- cristofer 23/10/2006 10:10:18 - CRIADO
	--->
	<cffunction name='del_manifesto_ctrc' displayname='Exclui um ctrc do manifesto' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cfargument name='MANIFESTO_ID' required='yes'>
		<cfstoredproc procedure='oper.pkg_manifesto_dml.prc_del_manifesto_ctrc' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MANIFESTO_ID'  value='#arguments.MANIFESTO_ID#'  null='#iif(len(trim(arguments.MANIFESTO_ID)), de('no'), de('yes'))#'>
		</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere um lacre no manifesto
	-- cristofer 23/10/2006 10:15:19 - CRIADO
	--->
	<cffunction name='ins_manifesto_lacre' displayname='Insere um lacre no manifesto' access='remote' returntype='Struct' output='true'>
		<cfargument name='MANIFESTO_ID' required='yes'>
		<cfargument name='NUM_LACRE' required='yes'>
				<cfstoredproc procedure='oper.pkg_manifesto_dml.prc_ins_manifesto_lacre' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MANIFESTO_ID'  value='#arguments.MANIFESTO_ID#'  null='#iif(len(trim(arguments.MANIFESTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUM_LACRE'  value='#arguments.NUM_LACRE#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um lacre do manifesto
	-- cristofer 23/10/2006 10:16:22 - CRIADO
	--->
	<cffunction name='del_manifesto_lacre' displayname='Exclui um lacre do manifesto' access='remote' returntype='Struct' output='true'>
		<cfargument name='MANIFESTO_ID' required='yes'>
		<cfargument name='NUM_LACRE' required='yes'>
				<cfstoredproc procedure='oper.pkg_manifesto_dml.prc_del_manifesto_lacre' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MANIFESTO_ID'  value='#arguments.MANIFESTO_ID#'  null='#iif(len(trim(arguments.MANIFESTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUM_LACRE'  value='#arguments.NUM_LACRE#' >
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere um motorista no manifesto
	-- cristofer 23/10/2006 10:17:10 - CRIADO
	--->
	<cffunction name='ins_manifesto_motorista' displayname='Insere um motorista no manifesto' access='remote' returntype='Struct' output='true'>
		<cfargument name='MANIFESTO_ID' required='yes'>
		<cfargument name='COD_PESSOA' required='yes'>
		<cfargument name='DATA_INICIO' required='yes'>
		<cfargument name='DATA_TERMINO' required='yes'>
		<cfargument name='ORG_MUNICIPIO_ID' required='yes'>
				<cfstoredproc procedure='oper.pkg_manifesto_dml.prc_ins_manifesto_motorista' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MANIFESTO_ID'  value='#arguments.MANIFESTO_ID#'  null='#iif(len(trim(arguments.MANIFESTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO'  value="#arguments.DATA_INICIO##iif(not len(trim(arguments.DATA_INICIO)),de(''),de(':00'))#" >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_TERMINO'  value="#arguments.DATA_TERMINO##iif(not len(trim(arguments.DATA_TERMINO)),de(''),de(':00'))#"  null='#iif(len(trim(arguments.DATA_TERMINO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ORG_MUNICIPIO_ID'  value='#arguments.ORG_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.ORG_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera um motorista no manifesto
	-- cristofer 23/10/2006 10:18:02 - CRIADO
	--->
	<cffunction name='upd_manifesto_motorista' displayname='Altera um motorista no manifesto' access='remote' returntype='Struct' output='true'>
		<cfargument name='MANIFESTO_ID' required='yes'>
		<cfargument name='COD_PESSOA' required='yes'>
		<cfargument name='DATA_INICIO' required='yes'>
		<cfargument name='DATA_TERMINO' required='yes'>
		<cfargument name='ORG_MUNICIPIO_ID' required='yes'>
				<cfstoredproc procedure='oper.pkg_manifesto_dml.prc_alt_manifesto_motorista' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MANIFESTO_ID'  value='#arguments.MANIFESTO_ID#'  null='#iif(len(trim(arguments.MANIFESTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO'  value="#arguments.DATA_INICIO##iif(not len(trim(arguments.DATA_INICIO)),de(''),de(':00'))#" >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_TERMINO'  value="#arguments.DATA_TERMINO##iif(not len(trim(arguments.DATA_TERMINO)),de(''),de(':00'))#" null='#iif(len(trim(arguments.DATA_TERMINO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ORG_MUNICIPIO_ID'  value='#arguments.ORG_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.ORG_MUNICIPIO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um motorista do manifesto
	-- cristofer 23/10/2006 10:20:04 - CRIADO
	--->
	<cffunction name='del_manifesto_motorista' displayname='Exclui um motorista do manifesto' access='remote' returntype='Struct' output='true'>
		<cfargument name='MANIFESTO_ID' required='yes'>
		<cfargument name='COD_PESSOA' required='yes'>
				<cfstoredproc procedure='oper.pkg_manifesto_dml.prc_del_manifesto_motorista' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MANIFESTO_ID'  value='#arguments.MANIFESTO_ID#'  null='#iif(len(trim(arguments.MANIFESTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Encerra um manifesto
	-- cristofer 23/10/2006 10:06:20 - CRIADO
	--->
	<cffunction name='encerra_manifesto' displayname='Altera um manifesto' access='remote' returntype='Struct' output='true'>
		<cfargument name='MANIFESTO_ID' required='yes'>
		<cfargument name='data_termino' required='yes'>
		<cfargument name='km_termino' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_manifesto_dml.prc_encerra_manifesto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MANIFESTO_ID'  value='#arguments.MANIFESTO_ID#'  null='#iif(len(trim(arguments.MANIFESTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_TERMINO'  value='#arguments.DATA_TERMINO#' null='#iif(len(trim(arguments.DATA_TERMINO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_KM_TERMINO'  value='#arguments.KM_TERMINO#'  null='#iif(len(trim(arguments.KM_TERMINO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Manifesto encerrado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Encerra um manifesto
	-- cristofer 23/10/2006 10:06:20 - CRIADO
	--->
	<cffunction name='cancela_manifesto' displayname='Altera um manifesto' access='remote' returntype='Struct' output='true'>
		<cfargument name='MANIFESTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_manifesto_dml.prc_cancela_manifesto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MANIFESTO_ID'  value='#arguments.MANIFESTO_ID#'  null='#iif(len(trim(arguments.MANIFESTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Manifesto cancelado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Gera as entregas das cargas
	-- cristofer 03/11/2006 15:19:03 - CRIADO
	--->
	<cffunction name='gerar_entregas' displayname='Gera as entregas das cargas' access='remote' returntype='Struct' output='true'>
		<cfargument name='CARGA_ID' required='no' default="">
		<cfargument name='DATA_ENTREGA' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
		<cfargument name='COD_AGENDAMENTO' required='yes'>
		<cfargument name='DATA_AGENDAMENTO' required='yes'>
		<cfargument name='PLACA' required='yes'>
		<cfargument name='COD_MOTORISTA' required='yes'>
		<cfargument name='COD_PESSOA_FILIAL' required='no' default="#session.cod_pessoa#">
		<cftry>
			<cftransaction action='begin'>
				<cfloop list="#arguments.carga_id#" delimiters="," index="v_carga_id">
					<cfstoredproc procedure='oper.pkg_ctrl_carga.prc_gera_carga_entrega' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CARGA_ID'  value='#v_CARGA_ID#'  null='#iif(len(trim(v_CARGA_ID)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_ENTREGA'  value='#arguments.DATA_ENTREGA#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_AGENDAMENTO'  value='#arguments.COD_AGENDAMENTO#'  null='#iif(len(trim(arguments.COD_AGENDAMENTO)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_AGENDAMENTO'  value='#arguments.DATA_AGENDAMENTO#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_MOTORISTA'  value='#arguments.COD_MOTORISTA#'  null='#iif(len(trim(arguments.COD_MOTORISTA)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_FILIAL'  value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
						<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENTREGA_ID' variable='retorno.ENTREGA_ID' >
						<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENTREGA_VEI_ID' variable='retorno.ENTREGA_VEI_ID' >
					</cfstoredproc>
				</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Entregas geradas com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Confirma uma entrega
	-- cristofer 03/11/2006 15:19:03 - CRIADO
	--->
	<cffunction name='confirma_entrega' displayname='Gera as entregas das cargas' access='remote' returntype='Struct' output='true'>
		<cfargument name='ENTREGA_VEI_ID' required='no' default="">
		<cfargument name='DATA_CONFIRMACAO' required='yes'>
		<cfargument name='COD_CONFIRMACAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_ctrl_carga.prc_confirma_entrega_veiculo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENTREGA_VEI_ID'  value='#arguments.ENTREGA_VEI_ID#'  null='#iif(len(trim(arguments.ENTREGA_VEI_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CONFIRMACAO'  value='#arguments.COD_CONFIRMACAO#'  null='#iif(len(trim(arguments.COD_CONFIRMACAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_CONFIRMACAO'  value='#arguments.DATA_CONFIRMACAO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Entrega confirmada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Confirma uma entrega
	-- cristofer 03/11/2006 15:19:03 - CRIADO
	--->
	<cffunction name='cancela_entrega' displayname='Gera as entregas das cargas' access='remote' returntype='Struct' output='true'>
		<cfargument name='ENTREGA_VEI_ID' required='no' default="">
		<cfargument name='DATA_CANCELAMENTO' required='yes'>
		<cfargument name='COD_CANCELAMENTO' required='yes'>
		<cfargument name='MOTIVO_CANCELAMENTO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_ctrl_carga.prc_cancela_entrega_veiculo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENTREGA_VEI_ID'  value='#arguments.ENTREGA_VEI_ID#'  null='#iif(len(trim(arguments.ENTREGA_VEI_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CANCELAMENTO'  value='#arguments.COD_CANCELAMENTO#'  null='#iif(len(trim(arguments.COD_CANCELAMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_CANCELAMENTO'  value='#arguments.DATA_CANCELAMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MOTIVO_CANCELAMENTO'  value='#arguments.MOTIVO_CANCELAMENTO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Agendamento cancelado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	
	<!--- 
	-- PROPSITO
	-- Confirma uma entrega
	-- cristofer 03/11/2006 15:19:03 - CRIADO
	--->
	<cffunction name='entrega_carga' displayname='Gera as entregas das cargas' access='remote' returntype='Struct' output='true'>
		<cfargument name='CARGA_ID' required='no' default="">
		<cfargument name='COD_PESSOA' required='no' default="">
		<cfargument name='DATA_ENTREGA' required='yes'>
		<cfargument name='MOTIVO_DEVOLUCAO' required='yes'>
		<cfargument name='TIPO_ENTREGA_ID' required='yes'>
		<cfargument name='INICIO_DESCARGA' required='no' default="">
        <cfargument name='CONHECIMENTO_ID' required='yes' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_ctrl_carga.prc_entrega_carga' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CARGA_ID'  value='#arguments.CARGA_ID#'  null='#iif(len(trim(arguments.CARGA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CONFIRMACAO'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA'  value='#arguments.DATA_ENTREGA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_ENTREGA_ID'  value='#arguments.TIPO_ENTREGA_ID#'  null='#iif(len(trim(arguments.TIPO_ENTREGA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MOTIVO'  value='#arguments.MOTIVO_DEVOLUCAO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CARGA_ID_DEVOLUCAO'  variable='retorno.carga_id_devolucao' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_CHEGADA'  null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_INICIO_DESCARGA' value='#arguments.INICIO_DESCARGA#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONHECIMENTO_ID' value='#arguments.CONHECIMENTO_ID#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Entrega confirmada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Confirma uma entrega
	-- cristofer 03/11/2006 15:19:03 - CRIADO
	--->
	<cffunction name='gera_conhecimento' displayname='Gera as entregas das cargas' access='remote' returntype='Struct' output='true'>
		<cfargument name='XML_ID' required='no' default="">
		<cftry>
				<cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					delete from kss.pessoa_usuario_acesso_cur c
					 where c.usuario = user
				</cfquery>
	
				<cfif IsDefined("session.cod_pessoa_gestao") and Len(Trim(session.cod_pessoa_gestao))>
					<cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
						insert into kss.pessoa_usuario_acesso_cur
						  (cod_pessoa, usuario)
						values
						  (#session.cod_pessoa_gestao#, user)
					</cfquery>			
				<cfelse>
					<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		                   select cod_pessoa, user 
							 from kss.pessoa_unidade_negocio
							where cod_gestao = 1
                    </cfquery>
                    <cfloop query="qr_result">
                        <cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                          insert into kss.pessoa_usuario_acesso_cur
                             (cod_pessoa, usuario)
                          values
                             (#qr_result.cod_pessoa#,user)
                        </cfquery>
                    </cfloop>
				</cfif>
				<cfquery name="session.qrAcessoCur" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					  select * from 
					  kss.pessoa_usuario_acesso_cur
				</cfquery>
				<cfstoredproc procedure='rodomar.pkg_klabin.prc_gera_conhecimento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_Numeric' SCALE='5' dbvarname='P_XML'  value='#arguments.xml_id#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_INTEGER' SCALE='5' dbvarname='P_ID'  variable="retorno.conhecimento_id">
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Conhecimento integrado com sucesso!')>
			<cfcatch>
				<cfset retorno.erro = true>
				<!--- Gera o erro de Gerao --->
				<cfstoredproc procedure='rodomar.pkg_klabin.prc_erro_conhecimento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_Numeric' SCALE='5' dbvarname='P_XML'  value='#arguments.xml_id#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_ERRO'  value='#cfcatch.Detail#'>
				</cfstoredproc>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
				<cfset retorno.detail = cfcatch.Detail>
				<cfset retorno.erro = true>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
				
	<!--- 
	-- PROPSITO
	-- Insere uma carga no sistema
	-- cristofer 13/11/2006 11:07:18 - CRIADO
	--->
	<cffunction name='ins_carga' displayname='Insere uma carga no sistema' access='remote' returntype='Struct' output='true'>
		<cfargument name='REM_COD_PESSOA' required='yes'>
		<cfargument name='DEST_COD_PESSOA' required='yes'>
		<cfargument name='COD_EMPRESA' required='no' default="#session.cod_pessoa#">
		<cfargument name='NUM_PEDIDO' required='yes'>
		<cfargument name='REM_LOGRADOURO' required='yes'>
		<cfargument name='REM_COMPLEMENTO' required='yes'>
		<cfargument name='REM_BAIRRO' required='yes'>
		<cfargument name='REM_CEP' required='yes'>
		<cfargument name='REM_MUNICIPIO_ID' required='yes'>
		<cfargument name='DEST_LOGRADOURO' required='yes'>
		<cfargument name='DEST_COMPLEMENTO' required='yes'>
		<cfargument name='DEST_BAIRRO' required='yes'>
		<cfargument name='DEST_CEP' required='yes'>
		<cfargument name='DEST_MUNICIPIO_ID' required='yes'>
		<cfargument name='MUNICIPIO_ID' required='no' default="">
		<cfargument name='COD_FILIAL_ATUAL' required='no' default="">
		<cfargument name='OBSERVACAO' required='yes'>
        <cfargument name='COLETA_COD_PESSOA' required='yes'>
		<cfargument name='ENTREGA_COD_PESSOA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_ctrl_carga.prc_ins_carga' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REM_COD_PESSOA'  value='#arguments.REM_COD_PESSOA#'  null='#iif(len(trim(arguments.REM_COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DEST_COD_PESSOA'  value='#arguments.DEST_COD_PESSOA#'  null='#iif(len(trim(arguments.DEST_COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_EMPRESA'  value='#arguments.COD_EMPRESA#'  null='#iif(len(trim(arguments.COD_EMPRESA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUM_PEDIDO'  value='#arguments.NUM_PEDIDO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_LOGRADOURO'  value='#arguments.REM_LOGRADOURO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_COMPLEMENTO'  value='#arguments.REM_COMPLEMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_BAIRRO'  value='#arguments.REM_BAIRRO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_CEP'  value='#arguments.REM_CEP#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REM_MUNICIPIO_ID'  value='#arguments.REM_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.REM_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_LOGRADOURO'  value='#arguments.DEST_LOGRADOURO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_COMPLEMENTO'  value='#arguments.DEST_COMPLEMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_BAIRRO'  value='#arguments.DEST_BAIRRO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_CEP'  value='#arguments.DEST_CEP#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DEST_MUNICIPIO_ID'  value='#arguments.DEST_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.DEST_MUNICIPIO_ID)), de('no'), de('yes'))#'>

					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_LOGRADOURO'  value='#arguments.COLETA_LOGRADOURO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_COMPLEMENTO'  value='#arguments.COLETA_COMPLEMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_BAIRRO'  value='#arguments.COLETA_BAIRRO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_CEP'  value='#arguments.COLETA_CEP#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COLETA_MUNICIPIO_ID'  value='#arguments.COLETA_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.COLETA_MUNICIPIO_ID)), de('no'), de('yes'))#'>

					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_LOGRADOURO'  value='#arguments.ENTREGA_LOGRADOURO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_COMPLEMENTO'  value='#arguments.ENTREGA_COMPLEMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_BAIRRO'  value='#arguments.ENTREGA_BAIRRO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_CEP'  value='#arguments.ENTREGA_CEP#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENTREGA_MUNICIPIO_ID'  value='#arguments.ENTREGA_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.ENTREGA_MUNICIPIO_ID)), de('no'), de('yes'))#'>


					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >

					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MUNICIPIO_ID'  value='#arguments.MUNICIPIO_ID#'  null='#iif(len(trim(arguments.MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_FILIAL_ATUAL'  value='#arguments.COD_FILIAL_ATUAL#'  null='#iif(len(trim(arguments.COD_FILIAL_ATUAL)), de('no'), de('yes'))#'>

					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CARGA_ID' variable='retorno.CARGA_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COLETA_COD_PESSOA'  value='#arguments.COLETA_COD_PESSOA#'  null='#iif(len(trim(arguments.COLETA_COD_PESSOA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENTREGA_COD_PESSOA'  value='#arguments.ENTREGA_COD_PESSOA#'  null='#iif(len(trim(arguments.ENTREGA_COD_PESSOA)), de('no'), de('yes'))#'>
				</cfstoredproc>
				
				<!---Verifica o Tipo de Documento que vai ser vinculado--->
                <cfswitch expression="#arguments.tipo_documento_id#">
                    <cfcase value="0">
                        <!--- Insere Notas fiscais --->
                        <cfscript>
							v_numero 	         = this.ListaToArray(lista = arguments, variavel = "NOTA_NUMERO_NOTAS_FISCAIS");
							v_data_emissao       = this.ListaToArray(lista = arguments, variavel = "NOTA_DATA_EMISSAO_NOTAS_FISCAIS");
							v_serie 	         = this.ListaToArray(lista = arguments, variavel = "NOTA_SERIE_NOTAS_FISCAIS");
							v_sub_serie          = this.ListaToArray(lista = arguments, variavel = "NOTA_SUB_SERIE_NOTAS_FISCAIS");
							v_modelo             = this.ListaToArray(lista = arguments, variavel = "NOTA_MODELO_NOTAS_FISCAIS");
							v_nf_valor		     = this.ListaToArray(lista = arguments, variavel = "NOTA_VALOR_NOTAS_FISCAIS");
							v_valor_segurado     = this.ListaToArray(lista = arguments, variavel = "NOTA_VALOR_SEGURADO_NOTAS_FISCAIS");
							v_peso               = this.ListaToArray(lista = arguments, variavel = "NOTA_PESO_NOTAS_FISCAIS");
							v_peso_cobrado       = this.ListaToArray(lista = arguments, variavel = 'NOTA_PESO_COBRADO_NOTAS_FISCAIS');
							v_ordem_compra       = this.ListaToArray(lista = arguments, variavel = "NOTA_ORDEM_COMPRA_NOTAS_FISCAIS");
							v_qtde_volume        = this.ListaToArray(lista = arguments, variavel = 'NOTA_QTDE_VOLUME_NOTAS_FISCAIS');
							v_cod_unidade        = this.ListaToArray(lista = arguments, variavel = 'NOTA_COD_UNIDADE_NOTAS_FISCAIS');
							v_m3                 = this.ListaToArray(lista = arguments, variavel = 'NOTA_M3_NOTAS_FISCAIS');
							v_peso_cubado        = this.ListaToArray(lista = arguments, variavel = 'NOTA_PESO_CUBADO_NOTAS_FISCAIS');
							v_num_natureza       = this.ListaToArray(lista = arguments, variavel = 'NOTA_NUM_NATUREZA_NOTAS_FISCAIS');
							v_complemento        = this.ListaToArray(lista = arguments, variavel = 'NOTA_COMPLEMENTO_NOTAS_FISCAIS');
							v_num_especie        = this.ListaToArray(lista = arguments, variavel = 'NOTA_NUM_ESPECIE_NOTAS_FISCAIS');
							v_altura             = this.ListaToArray(lista = arguments, variavel = 'NOTA_ALTURA_NOTAS_FISCAIS');
							v_largura            = this.ListaToArray(lista = arguments, variavel = 'NOTA_LARGURA_NOTAS_FISCAIS');
							v_comprimento        = this.ListaToArray(lista = arguments, variavel = 'NOTA_COMPRIMENTO_NOTAS_FISCAIS');
							v_cubagem            = this.ListaToArray(lista = arguments, variavel = 'NOTA_CUBAGEM_NOTAS_FISCAIS');
							v_cfop				 = this.ListaToArray(lista = arguments, variavel = 'NOTA_CFOP_NOTAS_FISCAIS');
						</cfscript>
                        
                        <cfloop from="1" to="#ArrayLen(v_num_natureza)#" index="count">
							
							<cfscript>
								ret_nf =    this.ins_carga_nf(carga_id		 = retorno.CARGA_ID,
															 num_natureza	 = v_num_natureza[count],
															 complemento	 = v_complemento[count],
															 nf_numero 		 = v_numero[count],
															 nf_modelo 		 = v_modelo[count],
															 nf_serie 		 = v_serie[count],
															 nf_sub_serie 	 = v_sub_serie[count],
															 nf_data_emissao = v_data_emissao[count],
															 nf_valor	 	 = v_nf_valor[count],
															 valor_segurado  = v_valor_segurado[count],
															 peso_kg	 	 = v_peso[count],
															 peso_cubado_kg	 = v_peso_cubado[count],
															 peso_cobrado_kg = v_peso_cobrado[count],
															 qtde_volume	 = v_qtde_volume[count],
															 altura			 = v_altura[count],
															 comprimento	 = v_comprimento[count],
															 largura		 = v_largura[count],
															 M3		 		 = v_M3[count],
															 cubagem		 = v_cubagem[count],
															 cod_unidade	 = v_cod_unidade[count],
															 ordem_compra	 = v_ordem_compra[count],
															 num_especie	 = v_num_especie[count],
															 cfop		     = v_cfop[count],
															 chave_acesso_nfe  = '',
															 nfe_xml		   = '',
															 tipo_documento_id = arguments.tipo_documento_id);
								
								
							</cfscript>
							<cfif ret_nf.erro>
								<cfthrow object="#ret_nf.mensagem#">
							</cfif>
						</cfloop>						
                    </cfcase>
                    
                    <cfcase value="1">
                        <!--- Insere NFE --->
                        <cfscript>
                            v_chave_acesso_nfe		= this.ListaToArray (lista = arguments, variavel = "CHAVE_ACESSO_NFE_NFE");
                            v_nfe_valor				= this.ListaToArray (lista = arguments, variavel = "NFE_VALOR_NFE");
                            v_nome_arquivo			= this.ListaToArray (lista = arguments, variavel = "NOME_ARQUIVO_NFE");
                            v_data_emissao			= this.ListaToArray (lista = arguments, variavel = "DATA_EMISSAO_NFE");
                            v_numero				= this.ListaToArray (lista = arguments, variavel = "NUMERO_NFE");
                            v_modelo				= this.ListaToArray (lista = arguments, variavel = "MODELO_NFE");
                            v_serie					= this.ListaToArray (lista = arguments, variavel = "SERIE_NFE");
                            v_documento_id			= this.ListaToArray (lista = arguments, variavel = "NFE_DOCUMENTO_ID_NFE");
							v_peso                  = this.ListaToArray (lista = arguments, variavel = "NFE_PESO_NFE");
                            v_peso_cobrado          = this.ListaToArray (lista = arguments, variavel = 'NFE_PESO_COBRADO_NFE');
                            v_ordem_compra          = this.ListaToArray (lista = arguments, variavel = "NFE_ORDEM_COMPRA_NFE");
                            v_qtde_volume           = this.ListaToArray (lista = arguments, variavel = 'NFE_QTDE_VOLUME_NFE');
                            v_cod_unidade           = this.ListaToArray (lista = arguments, variavel = 'NFE_COD_UNIDADE_NFE');
                            v_m3                    = this.ListaToArray (lista = arguments, variavel = 'NFE_M3_NFE');
                            v_peso_cubado           = this.ListaToArray (lista = arguments, variavel = 'NFE_PESO_CUBADO_NFE');
                            v_num_natureza          = this.ListaToArray (lista = arguments, variavel = 'NFE_NUM_NATUREZA_NFE');
                            v_complemento           = this.ListaToArray (lista = arguments, variavel = 'NFE_COMPLEMENTO_NFE');
                            v_num_especie           = this.ListaToArray (lista = arguments, variavel = 'NFE_NUM_ESPECIE_NFE');
                            v_altura                = this.ListaToArray (lista = arguments, variavel = 'NFE_ALTURA_NFE');
                            v_largura               = this.ListaToArray (lista = arguments, variavel = 'NFE_LARGURA_NFE');
                            v_comprimento           = this.ListaToArray (lista = arguments, variavel = 'NFE_COMPRIMENTO_NFE');
                            v_cubagem               = this.ListaToArray (lista = arguments, variavel = 'NFE_CUBAGEM_NFE');                            
                        </cfscript>
						
                        <cfloop from="1" to="#ArrayLen(v_chave_acesso_nfe)#" index="count">
                            <!--- Busca arquivo --->
                            <cfif Len(Trim(v_nome_arquivo[count]))>
                                <cffile action="read" file="#expandPath("/")#temp/#v_nome_arquivo[count]#" variable="VARQUIVO">
                            <cfelse>
                                <cfset VARQUIVO = ''>
                            </cfif>
                            
                            <cfscript>
								ret_nfe =  this.ins_carga_nf(carga_id		= retorno.CARGA_ID,
															num_natureza	= v_num_natureza[count],
															complemento	 	= v_complemento[count],
															nf_numero 		= v_numero[count],
															nf_modelo 		= v_modelo[count],
															nf_serie 		= v_serie[count],
															nf_sub_serie 	= 1,
															nf_data_emissao = v_data_emissao[count],
															nf_valor	 	= v_nfe_valor[count],
															valor_segurado  = v_nfe_valor[count],
															peso_kg	 	 	= v_peso[count],
															peso_cubado_kg	= v_peso_cubado[count],
															peso_cobrado_kg = v_peso_cobrado[count],
															qtde_volume	 	= v_qtde_volume[count],
															altura			= v_altura[count],
															comprimento	 	= v_comprimento[count],
															largura		 	= v_largura[count],
															M3		 		= v_M3[count],
															cubagem		 	= v_cubagem[count],
															ordem_compra	= v_ordem_compra[count],
															cod_unidade	 	= v_cod_unidade[count],
															num_especie	 	= v_num_especie[count],
															cfop		    = '',
															chave_acesso_nfe = v_chave_acesso_nfe[count],
															nfe_xml		   	= VARQUIVO,
															tipo_documento_id = arguments.tipo_documento_id);								
								
                            </cfscript>
                            <cfif ret_nfe.erro>
                                <cfthrow object="#ret_nfe.mensagem#">
                            </cfif>
                        </cfloop>
                    </cfcase>
                    
                    <cfcase value="2">
                        <!--- Insere Outros Documentos--->
                        <cfscript>
                            v_outros_numero			= this.ListaToArray (lista = arguments, variavel = "OUTROS_NUMERO_OUTROS");
                            v_outros_data_emissao	= this.ListaToArray (lista = arguments, variavel = "OUTROS_DATA_EMISSAO_OUTROS");
                            v_outros_descricao		= this.ListaToArray (lista = arguments, variavel = "OUTROS_DESCRICAO_OUTROS");
                            v_outros_valor			= this.ListaToArray (lista = arguments, variavel = "OUTROS_VALOR_OUTROS");
                            v_peso                  = this.ListaToArray (lista = arguments, variavel = "OUTROS_PESO_OUTROS");
                            v_peso_cobrado          = this.ListaToArray (lista = arguments, variavel = 'OUTROS_PESO_COBRADO_OUTROS');
                            v_qtde_volume           = this.ListaToArray (lista = arguments, variavel = 'OUTROS_QTDE_VOLUME_OUTROS');
                            v_cod_unidade           = this.ListaToArray (lista = arguments, variavel = 'OUTROS_COD_UNIDADE_OUTROS');
                            v_m3                    = this.ListaToArray (lista = arguments, variavel = 'OUTROS_M3_OUTROS');
                            v_peso_cubado           = this.ListaToArray (lista = arguments, variavel = 'OUTROS_PESO_CUBADO_OUTROS');
                            v_num_natureza          = this.ListaToArray (lista = arguments, variavel = 'OUTROS_NUM_NATUREZA_OUTROS');
                            v_complemento           = this.ListaToArray (lista = arguments, variavel = 'OUTROS_COMPLEMENTO_OUTROS');
                            v_num_especie           = this.ListaToArray (lista = arguments, variavel = 'OUTROS_NUM_ESPECIE_OUTROS');
                            v_altura                = this.ListaToArray (lista = arguments, variavel = 'OUTROS_ALTURA_OUTROS');
                            v_largura               = this.ListaToArray (lista = arguments, variavel = 'OUTROS_LARGURA_OUTROS');
                            v_comprimento           = this.ListaToArray (lista = arguments, variavel = 'OUTROS_COMPRIMENTO_OUTROS');
                            v_cubagem               = this.ListaToArray (lista = arguments, variavel = 'OUTROS_CUBAGEM_OUTROS');                        	
                        </cfscript>
						
                        <cfloop from="1" to="#ArrayLen(v_outros_numero)#" index="count">
                            <cfscript>
								outros =  this.ins_carga_nf(carga_id		= retorno.CARGA_ID,
														   num_natureza	 	= v_num_natureza[count],
														   complemento	 	= v_complemento[count],
														   nf_numero 		= v_outros_numero[count],
														   nf_modelo 		= '01',
														   nf_serie 		= 'U',
														   nf_sub_serie 	= '1',
														   nf_data_emissao 	= v_outros_data_emissao[count],
														   nf_valor	 	 	= v_outros_valor[count],
														   valor_segurado  	= v_outros_valor[count],
														   peso_kg	 	 	= v_peso[count],
														   peso_cubado_kg	= v_peso_cubado[count],
														   peso_cobrado_kg 	= v_peso_cobrado[count],
														   qtde_volume	 	= v_qtde_volume[count],
														   altura			= v_altura[count],
														   comprimento	 	= v_comprimento[count],
														   largura		 	= v_largura[count],
														   m3		 		= v_m3[count],
														   cubagem		 	= v_cubagem[count],
														   ordem_compra	 	= v_ordem_compra[count],
														   cod_unidade	 	= v_cod_unidade[count],
														   num_especie	 	= v_num_especie[count],
														   cfop		     	= '',
														   chave_acesso_nfe = '',
														   nfe_xml		   	= '',
														   tipo_documento_id = arguments.tipo_documento_id,
														   descricao_docto	 = v_outros_descricao[count]);							
								
                            </cfscript>
                            <cfif outros.erro>
                                <cfthrow object="#outros.mensagem#">
                            </cfif>
                        </cfloop>
                    </cfcase>                
                </cfswitch>
				
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Carga n #retorno.carga_id# inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera uma carga no sistema
	-- cristofer 13/11/2006 11:08:01 - CRIADO
	--->
	<cffunction name='upd_carga' displayname='Altera uma carga no sistema' access='remote' returntype='Struct' output='true'>
		<cfargument name='CARGA_ID' required='yes'>
		<cfargument name='REM_COD_PESSOA' required='yes'>
		<cfargument name='DEST_COD_PESSOA' required='yes'>
		<cfargument name='NUM_PEDIDO' required='yes'>
		<cfargument name='REM_LOGRADOURO' required='yes'>
		<cfargument name='REM_COMPLEMENTO' required='yes'>
		<cfargument name='REM_BAIRRO' required='yes'>
		<cfargument name='REM_CEP' required='yes'>
		<cfargument name='REM_MUNICIPIO_ID' required='yes'>
		<cfargument name='DEST_LOGRADOURO' required='yes'>
		<cfargument name='DEST_COMPLEMENTO' required='yes'>
		<cfargument name='DEST_BAIRRO' required='yes'>
		<cfargument name='DEST_CEP' required='yes'>
		<cfargument name='DEST_MUNICIPIO_ID' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
        <cfargument name='COLETA_COD_PESSOA' required='yes'>
		<cfargument name='ENTREGA_COD_PESSOA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_ctrl_carga.prc_alt_carga' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CARGA_ID'  value='#arguments.CARGA_ID#'  null='#iif(len(trim(arguments.CARGA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REM_COD_PESSOA'  value='#arguments.REM_COD_PESSOA#'  null='#iif(len(trim(arguments.REM_COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DEST_COD_PESSOA'  value='#arguments.DEST_COD_PESSOA#'  null='#iif(len(trim(arguments.DEST_COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUM_PEDIDO'  value='#arguments.NUM_PEDIDO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_LOGRADOURO'  value='#arguments.REM_LOGRADOURO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_COMPLEMENTO'  value='#arguments.REM_COMPLEMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_BAIRRO'  value='#arguments.REM_BAIRRO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_CEP'  value='#arguments.REM_CEP#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REM_MUNICIPIO_ID'  value='#arguments.REM_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.REM_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_LOGRADOURO'  value='#arguments.DEST_LOGRADOURO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_COMPLEMENTO'  value='#arguments.DEST_COMPLEMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_BAIRRO'  value='#arguments.DEST_BAIRRO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_CEP'  value='#arguments.DEST_CEP#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DEST_MUNICIPIO_ID'  value='#arguments.DEST_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.DEST_MUNICIPIO_ID)), de('no'), de('yes'))#'>

					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_LOGRADOURO'  value='#arguments.COLETA_LOGRADOURO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_COMPLEMENTO'  value='#arguments.COLETA_COMPLEMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_BAIRRO'  value='#arguments.COLETA_BAIRRO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_CEP'  value='#arguments.COLETA_CEP#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COLETA_MUNICIPIO_ID'  value='#arguments.COLETA_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.COLETA_MUNICIPIO_ID)), de('no'), de('yes'))#'>

					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_LOGRADOURO'  value='#arguments.ENTREGA_LOGRADOURO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_COMPLEMENTO'  value='#arguments.ENTREGA_COMPLEMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_BAIRRO'  value='#arguments.ENTREGA_BAIRRO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_CEP'  value='#arguments.ENTREGA_CEP#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENTREGA_MUNICIPIO_ID'  value='#arguments.ENTREGA_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.ENTREGA_MUNICIPIO_ID)), de('no'), de('yes'))#'>

					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COLETA_COD_PESSOA'  value='#arguments.COLETA_COD_PESSOA#'  null='#iif(len(trim(arguments.COLETA_COD_PESSOA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENTREGA_COD_PESSOA'  value='#arguments.ENTREGA_COD_PESSOA#'  null='#iif(len(trim(arguments.ENTREGA_COD_PESSOA)), de('no'), de('yes'))#'>
				</cfstoredproc>
				
				<!---Verifica o Tipo de Documento que vai ser vinculado--->
                <cfswitch expression="#arguments.tipo_documento_id#">
                    <cfcase value="0">
                        <!--- Insere Notas fiscais --->
                        <cfscript>
						retorno.carga_id 	 = arguments.carga_id;
						v_carga_nf_id   	 = this.ListaToArray (lista = arguments, variavel = "NOTA_COLETA_ITEM_ID_NOTAS_FISCAIS");
						v_numero 	         = this.ListaToArray(lista = arguments, variavel = "NOTA_NUMERO_NOTAS_FISCAIS");
						v_data_emissao       = this.ListaToArray(lista = arguments, variavel = "NOTA_DATA_EMISSAO_NOTAS_FISCAIS");
						v_serie 	         = this.ListaToArray(lista = arguments, variavel = "NOTA_SERIE_NOTAS_FISCAIS");
						v_sub_serie          = this.ListaToArray(lista = arguments, variavel = "NOTA_SUB_SERIE_NOTAS_FISCAIS");
						v_modelo             = this.ListaToArray(lista = arguments, variavel = "NOTA_MODELO_NOTAS_FISCAIS");
						v_nf_valor		     = this.ListaToArray(lista = arguments, variavel = "NOTA_VALOR_NOTAS_FISCAIS");
						v_valor_segurado     = this.ListaToArray(lista = arguments, variavel = "NOTA_VALOR_SEGURADO_NOTAS_FISCAIS");
						v_peso               = this.ListaToArray(lista = arguments, variavel = "NOTA_PESO_NOTAS_FISCAIS");
						v_peso_cobrado       = this.ListaToArray(lista = arguments, variavel = 'NOTA_PESO_COBRADO_NOTAS_FISCAIS');
						v_ordem_compra       = this.ListaToArray(lista = arguments, variavel = "NOTA_ORDEM_COMPRA_NOTAS_FISCAIS");
						v_qtde_volume        = this.ListaToArray(lista = arguments, variavel = 'NOTA_QTDE_VOLUME_NOTAS_FISCAIS');
						v_cod_unidade        = this.ListaToArray(lista = arguments, variavel = 'NOTA_COD_UNIDADE_NOTAS_FISCAIS');
						v_m3                 = this.ListaToArray(lista = arguments, variavel = 'NOTA_M3_NOTAS_FISCAIS');
						v_peso_cubado        = this.ListaToArray(lista = arguments, variavel = 'NOTA_PESO_CUBADO_NOTAS_FISCAIS');
						v_num_natureza       = this.ListaToArray(lista = arguments, variavel = 'NOTA_NUM_NATUREZA_NOTAS_FISCAIS');
						v_complemento        = this.ListaToArray(lista = arguments, variavel = 'NOTA_COMPLEMENTO_NOTAS_FISCAIS');
						v_num_especie        = this.ListaToArray(lista = arguments, variavel = 'NOTA_NUM_ESPECIE_NOTAS_FISCAIS');
						v_altura             = this.ListaToArray(lista = arguments, variavel = 'NOTA_ALTURA_NOTAS_FISCAIS');
						v_largura            = this.ListaToArray(lista = arguments, variavel = 'NOTA_LARGURA_NOTAS_FISCAIS');
						v_comprimento        = this.ListaToArray(lista = arguments, variavel = 'NOTA_COMPRIMENTO_NOTAS_FISCAIS');
						v_cubagem            = this.ListaToArray(lista = arguments, variavel = 'NOTA_CUBAGEM_NOTAS_FISCAIS');
						v_cfop				 = this.ListaToArray(lista = arguments, variavel = 'NOTA_CFOP_NOTAS_FISCAIS');
						v_excluir			 = this.ListDiff(lista1 = arguments.lista_deleted_NOTAS_FISCAIS, lista2 = ArrayToList(v_carga_nf_id));
                        </cfscript>
                        
                        <cfloop list="#v_excluir#" delimiters="," index="l_id">
							<cfscript>
								this.del_carga_nf(carga_nf_id = l_id);
							</cfscript>
						</cfloop>
                        
                        <cfloop from="1" to="#ArrayLen(v_num_natureza)#" index="count">
							
							<cfscript>
								if(Len(Trim(v_carga_nf_id[count]))){					
									ret_nf =    this.upd_carga_nf(carga_id		 = retorno.CARGA_ID,
																  carga_nf_id	 = v_carga_nf_id[count],
																  num_natureza	 = v_num_natureza[count],
																  complemento	 = v_complemento[count],
																  nf_numero 	 = v_numero[count],
																  nf_modelo 	 = v_modelo[count],
																  nf_serie 		 = v_serie[count],
																  nf_sub_serie 	 = v_sub_serie[count],
																  nf_data_emissao = v_data_emissao[count],
																  nf_valor	 	 = v_nf_valor[count],
																  valor_segurado = v_valor_segurado[count],
																  peso_kg	 	 = v_peso[count],
																  peso_cubado_kg = v_peso_cubado[count],
																  peso_cobrado_kg = v_peso_cobrado[count],
																  qtde_volume	 = v_qtde_volume[count],
																  altura		 = v_altura[count],
																  comprimento	 = v_comprimento[count],
																  largura		 = v_largura[count],
																  m3		 	 = v_M3[count],
																  cubagem		 = v_cubagem[count],
																  cod_unidade	 = v_cod_unidade[count],
																  ordem_compra	 = v_ordem_compra[count],
																  num_especie	 = v_num_especie[count],
																  cfop		     = v_cfop[count],
																  chave_acesso_nfe  = '',
																  nfe_xml		   = '',
																  tipo_documento_id = arguments.tipo_documento_id);
								}else{
									ret_nf =    this.ins_carga_nf(carga_id			= retorno.CARGA_ID,
																 num_natureza	 = v_num_natureza[count],
																 complemento	 = v_complemento[count],
																 nf_numero 		 = v_numero[count],
																 nf_modelo 		 = v_modelo[count],
																 nf_serie 		 = v_serie[count],
																 nf_sub_serie 	 = v_sub_serie[count],
																 nf_data_emissao = v_data_emissao[count],
																 nf_valor	 	 = v_nf_valor[count],
																 valor_segurado  = v_valor_segurado[count],
																 peso_kg	 	 = v_peso[count],
																 peso_cubado_kg	 = v_peso_cubado[count],
																 peso_cobrado_kg = v_peso_cobrado[count],
																 qtde_volume	 = v_qtde_volume[count],
																 altura			 = v_altura[count],
																 comprimento	 = v_comprimento[count],
																 largura		 = v_largura[count],
																 M3		 		 = v_M3[count],
																 cubagem		 = v_cubagem[count],
																 cod_unidade	 = v_cod_unidade[count],
																 ordem_compra	 = v_ordem_compra[count],
																 num_especie	 = v_num_especie[count],
																 cfop		     = v_cfop[count],
																 chave_acesso_nfe  = '',
																 nfe_xml		   = '',
																 tipo_documento_id = arguments.tipo_documento_id);
								
								} 
							</cfscript>
							<cfif ret_nf.erro>
								<cfthrow object="#ret_nf.mensagem#">
							</cfif>
						</cfloop>						
                    </cfcase>
                    
                    <cfcase value="1">
                        <!--- Insere NFE --->
                        <cfscript>
                            retorno.carga_id		= arguments.carga_id;
							v_carga_nf_id   		= this.ListaToArray (lista = arguments, variavel = "NFE_COLETA_ITEM_ID_NFE");
							v_chave_acesso_nfe		= this.ListaToArray (lista = arguments, variavel = "CHAVE_ACESSO_NFE_NFE");
                            v_nfe_valor				= this.ListaToArray (lista = arguments, variavel = "NFE_VALOR_NFE");
                            v_nome_arquivo			= this.ListaToArray (lista = arguments, variavel = "NOME_ARQUIVO_NFE");
                            v_data_emissao			= this.ListaToArray (lista = arguments, variavel = "DATA_EMISSAO_NFE");
                            v_numero				= this.ListaToArray (lista = arguments, variavel = "NUMERO_NFE");
                            v_modelo				= this.ListaToArray (lista = arguments, variavel = "MODELO_NFE");
                            v_serie					= this.ListaToArray (lista = arguments, variavel = "SERIE_NFE");
                            v_documento_id			= this.ListaToArray (lista = arguments, variavel = "NFE_DOCUMENTO_ID_NFE");
							v_peso                  = this.ListaToArray (lista = arguments, variavel = "NFE_PESO_NFE");
                            v_peso_cobrado          = this.ListaToArray (lista = arguments, variavel = 'NFE_PESO_COBRADO_NFE');
                            v_ordem_compra          = this.ListaToArray (lista = arguments, variavel = "NFE_ORDEM_COMPRA_NFE");
                            v_qtde_volume           = this.ListaToArray (lista = arguments, variavel = 'NFE_QTDE_VOLUME_NFE');
                            v_cod_unidade           = this.ListaToArray (lista = arguments, variavel = 'NFE_COD_UNIDADE_NFE');
                            v_m3                    = this.ListaToArray (lista = arguments, variavel = 'NFE_M3_NFE');
                            v_peso_cubado           = this.ListaToArray (lista = arguments, variavel = 'NFE_PESO_CUBADO_NFE');
                            v_num_natureza          = this.ListaToArray (lista = arguments, variavel = 'NFE_NUM_NATUREZA_NFE');
                            v_complemento           = this.ListaToArray (lista = arguments, variavel = 'NFE_COMPLEMENTO_NFE');
                            v_num_especie           = this.ListaToArray (lista = arguments, variavel = 'NFE_NUM_ESPECIE_NFE');
                            v_altura                = this.ListaToArray (lista = arguments, variavel = 'NFE_ALTURA_NFE');
                            v_largura               = this.ListaToArray (lista = arguments, variavel = 'NFE_LARGURA_NFE');
                            v_comprimento           = this.ListaToArray (lista = arguments, variavel = 'NFE_COMPRIMENTO_NFE');
                            v_cubagem               = this.ListaToArray (lista = arguments, variavel = 'NFE_CUBAGEM_NFE');
                            v_excluir				= this.ListDiff(lista1 = arguments.lista_deleted_NFE, lista2 = ArrayToList(v_carga_nf_id));
                        </cfscript>
						
                        <cfloop list="#v_excluir#" delimiters="," index="l_id">
							<cfscript>
								this.del_carga_nf(carga_nf_id = l_id);
							</cfscript>
						</cfloop>
                        
                        <cfloop from="1" to="#ArrayLen(v_chave_acesso_nfe)#" index="count">
                            <!--- Busca arquivo --->
                            <cfif Len(Trim(v_nome_arquivo[count])) and not Len(Trim(v_coleta_item_id[count]))>
                                <cffile action="read" file="#expandPath("/")#temp/#v_nome_arquivo[count]#" variable="VARQUIVO">
                            <cfelse>
                                <cfset VARQUIVO = ''>
                            </cfif>
                            
                            <cfscript>
                                if(Len(Trim(v_carga_nf_id[count]))){					
									ret_nfe =  this.upd_carga_nf(carga_id			= retorno.CARGA_ID,
																carga_nf_id		= v_carga_nf_id[count],
																num_natureza	= v_num_natureza[count],
																complemento	 	= v_complemento[count],
																nf_numero 		= v_numero[count],
																nf_modelo 		= v_modelo[count],
																nf_serie 		= v_serie[count],
																nf_sub_serie 	= 1,
																nf_data_emissao = v_data_emissao[count],
																nf_valor	 	= v_nfe_valor[count],
																valor_segurado  = v_nfe_valor[count],
																peso_kg	 	 	= v_peso[count],
																peso_cubado_kg	= v_peso_cubado[count],
																peso_cobrado_kg = v_peso_cobrado[count],
																qtde_volume	 	= v_qtde_volume[count],
																altura			= v_altura[count],
																comprimento	 	= v_comprimento[count],
																largura		 	= v_largura[count],
																M3		 		= v_M3[count],
																cubagem		 	= v_cubagem[count],
																ordem_compra	= v_ordem_compra[count],
																cod_unidade	 	= v_cod_unidade[count],
																num_especie	 	= v_num_especie[count],
																cfop		    = '',
																chave_acesso_nfe = v_chave_acesso_nfe[count],
																tipo_documento_id = arguments.tipo_documento_id);
								}else{
									ret_nfe =  this.ins_carga_nf(carga_id			= retorno.CARGA_ID,
																num_natureza	= v_num_natureza[count],
																complemento	 	= v_complemento[count],
																nf_numero 		= v_numero[count],
																nf_modelo 		= v_modelo[count],
																nf_serie 		= v_serie[count],
																nf_sub_serie 	= 1,
																nf_data_emissao = v_data_emissao[count],
																nf_valor	 	= v_nfe_valor[count],
																valor_segurado  = v_nfe_valor[count],
																peso_kg	 	 	= v_peso[count],
																peso_cubado_kg	= v_peso_cubado[count],
																peso_cobrado_kg = v_peso_cobrado[count],
																qtde_volume	 	= v_qtde_volume[count],
																altura			= v_altura[count],
																comprimento	 	= v_comprimento[count],
																largura		 	= v_largura[count],
																M3		 		= v_M3[count],
																cubagem		 	= v_cubagem[count],
																ordem_compra	= v_ordem_compra[count],
																cod_unidade	 	= v_cod_unidade[count],
																num_especie	 	= v_num_especie[count],
																cfop		    = '',
																chave_acesso_nfe = v_chave_acesso_nfe[count],
																nfe_xml		   	= VARQUIVO,
																tipo_documento_id = arguments.tipo_documento_id);
								
								} 					
								
                            </cfscript>
                            <cfif ret_nfe.erro>
                                <cfthrow object="#ret_nfe.mensagem#">
                            </cfif>
                        </cfloop>
                    </cfcase>
                    
                    <cfcase value="2">
                        <!--- Insere Outros Documentos--->
                        <cfscript>
                            retorno.carga_id		= arguments.carga_id;
							v_carga_nf_id   		= this.ListaToArray (lista = arguments, variavel = "OUTROS_COLETA_ITEM_ID_OUTROS");
							v_outros_numero			= this.ListaToArray (lista = arguments, variavel = "OUTROS_NUMERO_OUTROS");
                            v_outros_data_emissao	= this.ListaToArray (lista = arguments, variavel = "OUTROS_DATA_EMISSAO_OUTROS");
                            v_outros_descricao		= this.ListaToArray (lista = arguments, variavel = "OUTROS_DESCRICAO_OUTROS");
                            v_outros_valor			= this.ListaToArray (lista = arguments, variavel = "OUTROS_VALOR_OUTROS");
                            v_peso                  = this.ListaToArray (lista = arguments, variavel = "OUTROS_PESO_OUTROS");
                            v_peso_cobrado          = this.ListaToArray (lista = arguments, variavel = 'OUTROS_PESO_COBRADO_OUTROS');
                            v_qtde_volume           = this.ListaToArray (lista = arguments, variavel = 'OUTROS_QTDE_VOLUME_OUTROS');
                            v_cod_unidade           = this.ListaToArray (lista = arguments, variavel = 'OUTROS_COD_UNIDADE_OUTROS');
                            v_m3                    = this.ListaToArray (lista = arguments, variavel = 'OUTROS_M3_OUTROS');
                            v_peso_cubado           = this.ListaToArray (lista = arguments, variavel = 'OUTROS_PESO_CUBADO_OUTROS');
                            v_num_natureza          = this.ListaToArray (lista = arguments, variavel = 'OUTROS_NUM_NATUREZA_OUTROS');
                            v_complemento           = this.ListaToArray (lista = arguments, variavel = 'OUTROS_COMPLEMENTO_OUTROS');
                            v_num_especie           = this.ListaToArray (lista = arguments, variavel = 'OUTROS_NUM_ESPECIE_OUTROS');
                            v_altura                = this.ListaToArray (lista = arguments, variavel = 'OUTROS_ALTURA_OUTROS');
                            v_largura               = this.ListaToArray (lista = arguments, variavel = 'OUTROS_LARGURA_OUTROS');
                            v_comprimento           = this.ListaToArray (lista = arguments, variavel = 'OUTROS_COMPRIMENTO_OUTROS');
                            v_cubagem               = this.ListaToArray (lista = arguments, variavel = 'OUTROS_CUBAGEM_OUTROS');
                        	v_excluir				= this.ListDiff(lista1 = arguments.lista_deleted_OUTROS, lista2 = ArrayToList(v_carga_nf_id));
                        </cfscript>
						
                        <cfloop list="#v_excluir#" delimiters="," index="l_id">
							<cfscript>
								this.del_carga_nf(carga_nf_id = l_id);
							</cfscript>
						</cfloop>
                        
                        <cfloop from="1" to="#ArrayLen(v_outros_numero)#" index="count">
                            <cfscript>
                                if(Len(Trim(v_carga_nf_id[count]))){
									outros =  this.upd_carga_nf(carga_id			= retorno.CARGA_ID,
															   carga_nf_id		= v_carga_nf_id[count],
															   num_natureza	 	= v_num_natureza[count],
															   complemento	 	= v_complemento[count],
															   nf_numero 		= v_outros_numero[count],
															   nf_modelo 		= '01',
															   nf_serie 		= 'U',
															   nf_sub_serie 	= '1',
															   nf_data_emissao 	= v_outros_data_emissao[count],
															   nf_valor	 	 	= v_outros_valor[count],
															   valor_segurado  	= v_outros_valor[count],
															   peso_kg	 	 	= v_peso[count],
															   peso_cubado_kg	= v_peso_cubado[count],
															   peso_cobrado_kg 	= v_peso_cobrado[count],
															   qtde_volume	 	= v_qtde_volume[count],
															   altura			= v_altura[count],
															   comprimento	 	= v_comprimento[count],
															   largura		 	= v_largura[count],
															   m3		 		= v_m3[count],
															   cubagem		 	= v_cubagem[count],
															   ordem_compra	 	= '',
															   cod_unidade	 	= v_cod_unidade[count],
															   num_especie	 	= v_num_especie[count],
															   cfop		     	= '',
															   chave_acesso_nfe = '',
															   nfe_xml		   	= '',
															   tipo_documento_id = arguments.tipo_documento_id,
															   descricao_docto	 = v_outros_descricao[count]);
								}else{
									outros =  this.ins_carga_nf(carga_id			= retorno.CARGA_ID,
															   num_natureza	 	= v_num_natureza[count],
															   complemento	 	= v_complemento[count],
															   nf_numero 		= v_outros_numero[count],
															   nf_modelo 		= '01',
															   nf_serie 		= 'U',
															   nf_sub_serie 	= '1',
															   nf_data_emissao 	= v_outros_data_emissao[count],
															   nf_valor	 	 	= v_outros_valor[count],
															   valor_segurado  	= v_outros_valor[count],
															   peso_kg	 	 	= v_peso[count],
															   peso_cubado_kg	= v_peso_cubado[count],
															   peso_cobrado_kg 	= v_peso_cobrado[count],
															   qtde_volume	 	= v_qtde_volume[count],
															   altura			= v_altura[count],
															   comprimento	 	= v_comprimento[count],
															   largura		 	= v_largura[count],
															   m3		 		= v_m3[count],
															   cubagem		 	= v_cubagem[count],
															   ordem_compra	 	= '',
															   cod_unidade	 	= v_cod_unidade[count],
															   num_especie	 	= v_num_especie[count],
															   cfop		     	= '',
															   chave_acesso_nfe = '',
															   nfe_xml		   	= '',
															   tipo_documento_id = arguments.tipo_documento_id,
															   descricao_docto	 = v_outros_descricao[count]);
								}
								
                            </cfscript>
                            <cfif outros.erro>
                                <cfthrow object="#outros.mensagem#">
                            </cfif>
                        </cfloop>
                    </cfcase>                
                </cfswitch>
				
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Carga alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
			
	<!--- 
	-- PROPSITO
	-- Insere uma nf na carga
	-- cristofer 14/11/2006 15:49:23 - CRIADO
	--->
	<cffunction name='ins_carga_nf' displayname='Insere uma nf na carga' access='remote' returntype='Struct' output='true'>
		<cfargument name='CARGA_ID' required='yes'>
		<cfargument name='NUM_NATUREZA' required='yes'>
		<cfargument name='NF_NUMERO' required='yes'>
		<cfargument name='NF_MODELO' required='yes'>
		<cfargument name='NF_SERIE' required='yes'>
		<cfargument name='NF_SUB_SERIE' required='yes'>
		<cfargument name='NF_DATA_EMISSAO' required='yes'>
		<cfargument name='NF_VALOR' required='yes'>
		<cfargument name='VALOR_SEGURADO' required='yes'>
		<cfargument name='PESO_KG' required='yes'>
		<cfargument name='PESO_CUBADO_KG' required='yes'>
		<cfargument name='PESO_COBRADO_KG' required='yes'>
		<cfargument name='QTDE_VOLUME' required='yes'>
		<cfargument name='ALTURA' required='yes'>
		<cfargument name='COMPRIMENTO' required='yes'>
		<cfargument name='LARGURA' required='yes'>
		<cfargument name='M3' required='yes'>
		<cfargument name='CUBAGEM' required='yes'>
		<cfargument name='ORDEM_COMPRA' required='yes'>
		<cfargument name='NUM_ESPECIE' required='yes'>
		<cfargument name='COD_UNIDADE' required='yes'>
		<cfargument name='COMPLEMENTO' required='yes'>
        <cfargument name='CFOP' required='yes'>
        <cfargument name='CHAVE_ACESSO_NFE' required='yes'>
        <cfargument name='NFE_XML' required='yes'>
        <cfargument name='TIPO_DOCUMENTO_ID' required='yes'>
		<cfargument name='DESCRICAO_DOCTO' required='no' default=''>	
        	<cftry>
				<cfstoredproc procedure='oper.pkg_ctrl_carga.prc_ins_carga_nf' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CARGA_ID'  value='#arguments.CARGA_ID#'  null='#iif(len(trim(arguments.CARGA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NATUREZA'  value='#arguments.NUM_NATUREZA#'  null='#iif(len(trim(arguments.NUM_NATUREZA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NF_NUMERO'  value='#arguments.NF_NUMERO#'  null='#iif(len(trim(arguments.NF_NUMERO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NF_MODELO'  value='#arguments.NF_MODELO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NF_SERIE'  value='#arguments.NF_SERIE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NF_SUB_SERIE'  value='#arguments.NF_SUB_SERIE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NF_DATA_EMISSAO'  value='#arguments.NF_DATA_EMISSAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NF_VALOR'  value='#arguments.NF_VALOR#'  null='#iif(len(trim(arguments.NF_VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_SEGURADO'  value='#arguments.VALOR_SEGURADO#'  null='#iif(len(trim(arguments.VALOR_SEGURADO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PESO_KG'  value='#arguments.PESO_KG#'  null='#iif(len(trim(arguments.PESO_KG)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PESO_CUBADO_KG'  value='#arguments.PESO_CUBADO_KG#'  null='#iif(len(trim(arguments.PESO_CUBADO_KG)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PESO_COBRADO_KG'  value='#arguments.PESO_COBRADO_KG#'  null='#iif(len(trim(arguments.PESO_COBRADO_KG)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QTDE_VOLUME'  value='#arguments.QTDE_VOLUME#'  null='#iif(len(trim(arguments.QTDE_VOLUME)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ALTURA'  value='#arguments.ALTURA#'  null='#iif(len(trim(arguments.ALTURA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COMPRIMENTO'  value='#arguments.COMPRIMENTO#'  null='#iif(len(trim(arguments.COMPRIMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LARGURA'  value='#arguments.LARGURA#'  null='#iif(len(trim(arguments.LARGURA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_M3'  value='#arguments.M3#'  null='#iif(len(trim(arguments.M3)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CUBAGEM'  value='#arguments.CUBAGEM#'  null='#iif(len(trim(arguments.CUBAGEM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ORDEM_COMPRA'  value='#arguments.ORDEM_COMPRA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ESPECIE'  value='#arguments.NUM_ESPECIE#'  null='#iif(len(trim(arguments.NUM_ESPECIE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_UNIDADE'  value='#arguments.COD_UNIDADE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMPLEMENTO'  value='#arguments.COMPLEMENTO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CARGA_NF_ID' variable='retorno.CARGA_NF_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CFOP'  value='#arguments.CFOP#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CHAVE_ACESSO_NFE'  value='#arguments.CHAVE_ACESSO_NFE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_NFE_XML'  value='#arguments.NFE_XML#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_DOCUMENTO_ID'  value='#arguments.TIPO_DOCUMENTO_ID#'  null='#iif(len(trim(arguments.TIPO_DOCUMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO_DOCTO'  value='#arguments.DESCRICAO_DOCTO#' >
				</cfstoredproc>
                <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
        	</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera uma nf na carga
	-- cristofer 14/11/2006 15:50:04 - CRIADO
	--->
	<cffunction name='upd_carga_nf' displayname='Altera uma nf na carga' access='remote' returntype='Struct' output='true'>
		<cfargument name='CARGA_NF_ID' required='yes'>
		<cfargument name='CARGA_ID' required='yes'>
		<cfargument name='NUM_NATUREZA' required='yes'>
		<cfargument name='NF_NUMERO' required='yes'>
		<cfargument name='NF_MODELO' required='yes'>
		<cfargument name='NF_SERIE' required='yes'>
		<cfargument name='NF_SUB_SERIE' required='yes'>
		<cfargument name='NF_DATA_EMISSAO' required='yes'>
		<cfargument name='NF_VALOR' required='yes'>
		<cfargument name='VALOR_SEGURADO' required='yes'>
		<cfargument name='PESO_KG' required='yes'>
		<cfargument name='PESO_CUBADO_KG' required='yes'>
		<cfargument name='PESO_COBRADO_KG' required='yes'>
		<cfargument name='QTDE_VOLUME' required='yes'>
		<cfargument name='ALTURA' required='yes'>
		<cfargument name='COMPRIMENTO' required='yes'>
		<cfargument name='LARGURA' required='yes'>
		<cfargument name='M3' required='yes'>
		<cfargument name='CUBAGEM' required='yes'>
		<cfargument name='ORDEM_COMPRA' required='yes'>
		<cfargument name='NUM_ESPECIE' required='yes'>
		<cfargument name='COD_UNIDADE' required='yes'>
		<cfargument name='COMPLEMENTO' required='yes'>
        <cfargument name='CFOP' required='yes'>
        <cfargument name='CHAVE_ACESSO_NFE' required='yes'>
        <cfargument name='TIPO_DOCUMENTO_ID' required='yes'>
		<cfargument name='DESCRICAO_DOCTO' required='no' default=''>
        	<cftry>
				<cfstoredproc procedure='oper.pkg_ctrl_carga.prc_alt_carga_nf' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CARGA_NF_ID'  value='#arguments.CARGA_NF_ID#'  null='#iif(len(trim(arguments.CARGA_NF_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CARGA_ID'  value='#arguments.CARGA_ID#'  null='#iif(len(trim(arguments.CARGA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NATUREZA'  value='#arguments.NUM_NATUREZA#'  null='#iif(len(trim(arguments.NUM_NATUREZA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NF_NUMERO'  value='#arguments.NF_NUMERO#'  null='#iif(len(trim(arguments.NF_NUMERO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NF_MODELO'  value='#arguments.NF_MODELO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NF_SERIE'  value='#arguments.NF_SERIE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NF_SUB_SERIE'  value='#arguments.NF_SUB_SERIE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NF_DATA_EMISSAO'  value='#arguments.NF_DATA_EMISSAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NF_VALOR'  value='#arguments.NF_VALOR#'  null='#iif(len(trim(arguments.NF_VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_SEGURADO'  value='#arguments.VALOR_SEGURADO#'  null='#iif(len(trim(arguments.VALOR_SEGURADO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PESO_KG'  value='#arguments.PESO_KG#'  null='#iif(len(trim(arguments.PESO_KG)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PESO_CUBADO_KG'  value='#arguments.PESO_CUBADO_KG#'  null='#iif(len(trim(arguments.PESO_CUBADO_KG)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PESO_COBRADO_KG'  value='#arguments.PESO_COBRADO_KG#'  null='#iif(len(trim(arguments.PESO_COBRADO_KG)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QTDE_VOLUME'  value='#arguments.QTDE_VOLUME#'  null='#iif(len(trim(arguments.QTDE_VOLUME)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ALTURA'  value='#arguments.ALTURA#'  null='#iif(len(trim(arguments.ALTURA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COMPRIMENTO'  value='#arguments.COMPRIMENTO#'  null='#iif(len(trim(arguments.COMPRIMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LARGURA'  value='#arguments.LARGURA#'  null='#iif(len(trim(arguments.LARGURA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_M3'  value='#arguments.M3#'  null='#iif(len(trim(arguments.M3)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CUBAGEM'  value='#arguments.CUBAGEM#'  null='#iif(len(trim(arguments.CUBAGEM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ORDEM_COMPRA'  value='#arguments.ORDEM_COMPRA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ESPECIE'  value='#arguments.NUM_ESPECIE#'  null='#iif(len(trim(arguments.NUM_ESPECIE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_UNIDADE'  value='#arguments.COD_UNIDADE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMPLEMENTO'  value='#arguments.COMPLEMENTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CFOP'  value='#arguments.CFOP#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CHAVE_ACESSO_NFE'  value='#arguments.CHAVE_ACESSO_NFE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_DOCUMENTO_ID'  value='#arguments.TIPO_DOCUMENTO_ID#'  null='#iif(len(trim(arguments.TIPO_DOCUMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO_DOCTO'  value='#arguments.DESCRICAO_DOCTO#' >
				</cfstoredproc>
                <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
        	</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui uma nf para a carga
	-- cristofer 13/11/2006 11:13:55 - CRIADO
	--->
	<cffunction name='del_carga_nf' displayname='Exclui uma nf para a carga' access='remote' returntype='Struct' output='true'>
		<cfargument name='CARGA_NF_ID' required='yes'>
				<cfstoredproc procedure='oper.pkg_ctrl_carga.prc_del_carga_nf' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CARGA_NF_ID'  value='#arguments.CARGA_NF_ID#'  null='#iif(len(trim(arguments.CARGA_NF_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Gera uma devoluo de cargas
	-- cristofer 20/11/2006 10:14:26 - CRIADO
	--->
	<cffunction name='ins_carga_devolucao' displayname='Gera uma devoluo de cargas' access='remote' returntype='Struct' output='true'>
		<cfargument name='CARGA_ID' required='yes'>
		<cfargument name='COD_PESSOA_DEVOLUCAO' required='yes'>
		<cfargument name='DATA_DEVOLUCAO' required='yes'>
		<cfargument name='MOTIVO' required='yes'>
		<cfargument name='PARCIAL' required='no' default="0">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_ctrl_carga.prc_ins_carga_devolucao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CARGA_ID'  value='#arguments.CARGA_ID#'  null='#iif(len(trim(arguments.CARGA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_DEVOLUCAO'  value='#arguments.COD_PESSOA_DEVOLUCAO#'  null='#iif(len(trim(arguments.COD_PESSOA_DEVOLUCAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_DEVOLUCAO'  value='#arguments.DATA_DEVOLUCAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_MOTIVO'  value='#arguments.MOTIVO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PARCIAL'  value='#arguments.PARCIAL#'  null='#iif(len(trim(arguments.PARCIAL)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CARGA_ID_DEVOLUCAO' variable='retorno.CARGA_ID_DEVOLUCAO' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Devoluo gerada com sucesso! N da Carga gerada: #NumberFormat(retorno.carga_id_devolucao)#')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
		
	<!--- 
	-- PROPSITO
	-- Cancela uma carga
	-- cristofer 28/11/2006 15:38:25 - CRIADO
	--->
	<cffunction name='cancela_carga' displayname='Cancela uma carga' access='remote' returntype='Struct' output='true'>
		<cfargument name='CARGA_ID' required='yes'>
		<cfargument name='COD_CANCELAMENTO' required='yes'>
		<cfargument name='DATA_CANCELAMENTO' required='yes'>
		<cfargument name='MOTIVO_CANCELAMENTO' required='yes'>
		<cftry>
            <cfstoredproc procedure='oper.pkg_ctrl_carga.prc_cancela_carga' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CARGA_ID'  value='#arguments.CARGA_ID#'  null='#iif(len(trim(arguments.CARGA_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CANCELAMENTO'  value='#arguments.COD_CANCELAMENTO#'  null='#iif(len(trim(arguments.COD_CANCELAMENTO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_CANCELAMENTO'  value='#arguments.DATA_CANCELAMENTO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MOTIVO_CANCELAMENTO'  value='#arguments.MOTIVO_CANCELAMENTO#' >
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Carga cancelada com sucesso!')>
        <cfcatch>
            <cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
            <cfset request.erro = cfcatch>
        </cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Gera um reagendamento de entrega
	-- cristofer 29/11/2006 10:05:42 - CRIADO
	--->
	<cffunction name='reagendar_entrega' displayname='Gera um reagendamento de entrega' access='remote' returntype='Struct' output='true'>
		<cfargument name='ENTREGA_ID' required='yes'>
		<cfargument name='ENTREGA_VEI_ID' required='yes'>
		<cfargument name='DATA_ENTREGA' required='yes'>
		<cfargument name='COD_AGENDAMENTO' required='yes'>
		<cfargument name='DATA_AGENDAMENTO' required='yes'>
		<cfargument name='PLACA' required='yes'>
		<cfargument name='COD_MOTORISTA' required='yes'>
		<cfargument name='MOTIVO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_ctrl_carga.prc_reagenda_entrega' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENTREGA_ID'  value='#arguments.ENTREGA_ID#'  null='#iif(len(trim(arguments.ENTREGA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENTREGA_VEI_ID'  value='#arguments.ENTREGA_VEI_ID#' variable='retorno.ENTREGA_VEI_ID'  null='#iif(len(trim(arguments.ENTREGA_VEI_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_ENTREGA'  value='#arguments.DATA_ENTREGA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_AGENDAMENTO'  value='#arguments.COD_AGENDAMENTO#'  null='#iif(len(trim(arguments.COD_AGENDAMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_AGENDAMENTO'  value='#arguments.DATA_AGENDAMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_MOTORISTA'  value='#arguments.COD_MOTORISTA#'  null='#iif(len(trim(arguments.COD_MOTORISTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MOTIVO'  value='#arguments.MOTIVO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Entrega reagendada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Cancela a integrao de um arquivo da klabin
	-- cristofer 29/11/2006 10:05:42 - CRIADO
	--->
	<cffunction name='cancela_integracao_klabin' displayname='Gera um reagendamento de entrega' access='remote' returntype='Struct' output='true'>
		<cfargument name='XML_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='rodomar.pkg_klabin.prc_cancela_integracao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_XML_ID'  value='#arguments.XML_ID#'  null='#iif(len(trim(arguments.XML_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Integrao cancelada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere ou altera uma filial belgo
	-- cristofer 21/12/2006 09:40:53 - CRIADO
	--->
	<cffunction name='ins_belgo' displayname='Insere ou altera uma filial belgo' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_PESSOA' required='yes'>
		<cfargument name='COD_EMPRESA' required='yes'>
		<cfargument name='REGIAO' required='yes'>
		<cfargument name='FORNECEDOR' required='yes'>
		<cfargument name='REGIAO_TRA' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_belgo.prc_ins_belgo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_EMPRESA'  value='#arguments.COD_EMPRESA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REGIAO'  value='#arguments.REGIAO#'  null='#iif(len(trim(arguments.REGIAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FORNECEDOR'  value='#arguments.FORNECEDOR#'  null='#iif(len(trim(arguments.FORNECEDOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REGIAO_TRA'  value='#arguments.REGIAO_TRA#'  null='#iif(len(trim(arguments.REGIAO_TRA)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Dados salvos com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui uma filial belgo
	-- cristofer 21/12/2006 09:41:40 - CRIADO
	--->
	<cffunction name='del_belgo' displayname='Exclui uma filial belgo' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_PESSOA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_belgo.prc_del_belgo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Filial excluida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Altera o codigo de municipio da belgo
	-- cristofer 21/12/2006 09:41:40 - CRIADO
	--->
	<cffunction name='upd_municipio_cod_belgo' displayname='Altera o codigo de municipio da belgo' access='remote' returntype='Struct' output='true'>
		<cfargument name='MUNICIPIO_ID' required='yes'>
		<cfargument name='COD_UF_BELGO' required='yes'>
		<cfargument name='COD_MUNICIPIO_BELGO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfquery name="qr_result" datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					update cep.municipio
					   set cod_uf_belgo = '#arguments.cod_uf_belgo#',
					   	   cod_municipio_belgo = '#arguments.cod_municipio_belgo#'
				     where municipio_id = #arguments.municipio_id#
				</cfquery>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Municipio alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Insere o codigo da rodomar para a belgo
	-- cristofer 26/01/2007 09:43:07 - CRIADO
	--->
	<cffunction name='ins_belgo_rodomar' displayname='Insere o codigo da rodomar para a belgo' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_PESSOA' required='yes'>
		<cfargument name='COD_BELGO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_belgo.prc_ins_belgo_rodomar' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_BELGO'  value='#arguments.COD_BELGO#'  null='#iif(len(trim(arguments.COD_BELGO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Filial atualizada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Insere novo itinerario no romaneio
	-- guto 26/03/2007 09:37:15 - CRIADO
	--->
	<cffunction name='ins_romaneio_itinerario' displayname='Insere novo itinerario no romaneio' access='remote' returntype='Struct' output='true'>
		<cfargument name='PLACA_REFERENCIA' required='yes'>
		<cfargument name='NUM_ROMANEIO' required='yes'>
		<cfargument name='ROTA_ID' required='yes'>
		<cfargument name='DATA_PREVISAO' required='yes'>
		<cfargument name='DATA_CHEGADA' required='yes'>
		<cfargument name='VAZIO_CARREGADO' required='yes'>
		<cfargument name='ITINERARIO_ID_ANTERIOR' required='yes'>
		<cfargument name='ITINERARIO_ID_POSTERIOR' required='yes'>
		<cfargument name='ORDEM' required='yes'>
		<cfargument name='ORIGEM_MUNICIPIO_ID' required='yes'>
		<cfargument name='DESTINO_MUNICIPIO_ID' required='yes'>
		<cfargument name='ITEM_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_itinerario.prc_ins_romaneio_itinerario' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA_REFERENCIA'  value='#arguments.PLACA_REFERENCIA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ROTA_ID'  value='#arguments.ROTA_ID#'  null='#iif(len(trim(arguments.ROTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_PREVISAO'  value='#arguments.DATA_PREVISAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_CHEGADA'  value='#arguments.DATA_CHEGADA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VAZIO_CARREGADO'  value='#arguments.VAZIO_CARREGADO#'  null='#iif(len(trim(arguments.VAZIO_CARREGADO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ITINERARIO_ID_ANTERIOR'  value='#arguments.ITINERARIO_ID_ANTERIOR#'  null='#iif(len(trim(arguments.ITINERARIO_ID_ANTERIOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ITINERARIO_ID_POSTERIOR'  value='#arguments.ITINERARIO_ID_POSTERIOR#'  null='#iif(len(trim(arguments.ITINERARIO_ID_POSTERIOR)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ITINERARIO_ID' variable='retorno.ITINERARIO_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ORDEM'  value='#arguments.ORDEM#'  null='#iif(len(trim(arguments.ORDEM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ORIGEM_MUNICIPIO_ID'  value='#arguments.ORIGEM_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.ORIGEM_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DESTINO_MUNICIPIO_ID'  value='#arguments.DESTINO_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.DESTINO_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Itinerario inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Altera itinerario
	-- guto 22/03/2007 18:22:03 - CRIADO
	--->
	<cffunction name='alt_romaneio_itinerario' displayname='Altera itinerario' access='remote' returntype='Struct' output='true'>
		<cfargument name='ITINERARIO_ID' required='yes'>
		<cfargument name='NUM_ROMANEIO' required='yes'>
		<cfargument name='PLACA_REFERENCIA' required='yes'>
		<cfargument name='ROTA_ID' required='yes'>
		<cfargument name='DATA_PREVISAO' required='yes'>
		<cfargument name='DATA_CHEGADA' required='yes'>
		<cfargument name='VAZIO_CARREGADO' required='yes'>
		<cfargument name='ITINERARIO_ID_ANTERIOR' required='yes'>
		<cfargument name='ITINERARIO_ID_POSTERIOR' required='yes'>
		<cfargument name='ORDEM' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_itinerario.prc_alt_romaneio_itinerario' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ITINERARIO_ID'  value='#arguments.ITINERARIO_ID#'  null='#iif(len(trim(arguments.ITINERARIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA_REFERENCIA'  value='#arguments.PLACA_REFERENCIA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ROTA_ID'  value='#arguments.ROTA_ID#'  null='#iif(len(trim(arguments.ROTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_PREVISAO'  value='#arguments.DATA_PREVISAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_CHEGADA'  value='#arguments.DATA_CHEGADA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VAZIO_CARREGADO'  value='#arguments.VAZIO_CARREGADO#'  null='#iif(len(trim(arguments.VAZIO_CARREGADO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ITINERARIO_ID_ANTERIOR'  value='#arguments.ITINERARIO_ID_ANTERIOR#'  null='#iif(len(trim(arguments.ITINERARIO_ID_ANTERIOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ITINERARIO_ID_POSTERIOR'  value='#arguments.ITINERARIO_ID_POSTERIOR#'  null='#iif(len(trim(arguments.ITINERARIO_ID_POSTERIOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ORDEM'  value='#arguments.ORDEM#'  null='#iif(len(trim(arguments.ORDEM)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Itinerario alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Exclui itinerario do romaneio
	-- guto 26/03/2007 09:20:05 - CRIADO
	--->
	<cffunction name='del_romaneio_itinerario' displayname='Exclui itinerario do romaneio' access='remote' returntype='Struct' output='true'>
		<cfargument name='ITINERARIO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_itinerario.prc_del_romaneio_itinerario' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ITINERARIO_ID'  value='#arguments.ITINERARIO_ID#'  null='#iif(len(trim(arguments.ITINERARIO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Itinerario excludo com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Recalcula o KM do romaneio
	-- guto 26/01/2007 09:43:07 - CRIADO
	--->
	<cffunction name='recalculado_km_romameio' displayname='' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_ROMANEIO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_romaneio.prc_ajusta_km_romaneio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Recalculado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
   
   <!--- 
	-- PROPSITO
	-- Insere evento
	-- jonas 12/06/2009 10:43:15 - CRIADO
	--->
	<cffunction name='ins_evento_operacao' displayname='Insere evento' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTROLE_EVO_ID' required='yes'>
		<cfargument name='NUM_EVENTO' required='yes'>
		<cfargument name='COD_PESSOA' required='yes'>
		<cfargument name='PLACA_CONTROLE' required='yes'>
		<cfargument name='PLACA_REFERENCIA' required='yes'>
		<cfargument name='DATA' required='yes'>
		<cfargument name='KM' required='yes'>
		<cfargument name='ORIGEM' required='yes'>
		<cfargument name='LATITUDE' required='yes'>
		<cfargument name='LONGITUDE' required='yes'>
		<cfargument name='DEBITAR_MOTORISTA' required='yes'>
		<cfargument name='REFERENCIA_ID' required='yes'>
		<cfargument name='LOCAL' required='yes'>
		<cfargument name='ENVIA_MSG_DESTINO' required='yes'>
		<cfargument name='ENVIA_MSG_PREVISAO_CARREGADO' required='yes'>
		<cfargument name='ENVIA_MSG_PREVISAO_VAZIO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
         	
            <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					insert into oper.evento_dado_temp (dado_id,valor) values ('1',#arguments.KM#)
            </cfquery>
            
            <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            	insert into oper.evento_dado_temp (dado_id,valor) values ('7',oper.pkg_global.FNC_GET_COD_FUNCIONARIO(#arguments.COD_PESSOA#))
            </cfquery>
				
				<cfstoredproc procedure='oper.pkg_evento_controle.prc_ins_evento_operacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_EVO_ID'  value='#arguments.CONTROLE_EVO_ID#' variable='retorno.CONTROLE_EVO_ID'  null='#iif(len(trim(arguments.CONTROLE_EVO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_EVENTO'  value='#arguments.NUM_EVENTO#'  null='#iif(len(trim(arguments.NUM_EVENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#' variable='retorno.COD_PESSOA'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA_CONTROLE'  value='#arguments.PLACA_CONTROLE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA_REFERENCIA'  value='#arguments.PLACA_REFERENCIA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA'  value='#arguments.DATA#' >
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_KM'  value='#arguments.KM#' variable='retorno.KM'  null='#iif(len(trim(arguments.KM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ORIGEM'  value='#arguments.ORIGEM#'  null='#iif(len(trim(arguments.ORIGEM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LATITUDE'  value='#arguments.LATITUDE#'  null='#iif(len(trim(arguments.LATITUDE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LONGITUDE'  value='#arguments.LONGITUDE#'  null='#iif(len(trim(arguments.LONGITUDE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DEBITAR_MOTORISTA'  value='#arguments.DEBITAR_MOTORISTA#'  null='#iif(len(trim(arguments.DEBITAR_MOTORISTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REFERENCIA_ID'  value='#arguments.REFERENCIA_ID#'  null='#iif(len(trim(arguments.REFERENCIA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_LOCAL'  value='#arguments.LOCAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENVIA_MSG_DESTINO'  value='#arguments.ENVIA_MSG_DESTINO#'  null='#iif(len(trim(arguments.ENVIA_MSG_DESTINO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENVIA_MSG_PREVISAO_CARREGADO'  value='#arguments.ENVIA_MSG_PREVISAO_CARREGADO#'  null='#iif(len(trim(arguments.ENVIA_MSG_PREVISAO_CARREGADO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENVIA_MSG_PREVISAO_VAZIO'  value='#arguments.ENVIA_MSG_PREVISAO_VAZIO#'  null='#iif(len(trim(arguments.ENVIA_MSG_PREVISAO_VAZIO)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Evento inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
   
   <!--- 
	-- PROPSITO
	-- Altera evento
	-- jonas 12/06/2009 10:47:51 - CRIADO
	--->
	<cffunction name='upd_evento_operacao' displayname='Altera evento' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTROLE_EVO_ID' required='yes'>
		<cfargument name='PLACA' required='yes'>
		<cfargument name='COD_PESSOA' required='yes'>
		<cfargument name='DATA' required='yes'>
		<cfargument name='KM' required='yes'>
		<cfargument name='LATITUDE' required='yes'>
		<cfargument name='LONGITUDE' required='yes'>
		<cfargument name='LOCAL' required='yes'>
		<cfargument name='DEBITAR_MOTORISTA' required='yes'>
		<cfargument name='REFERENCIA_ID' required='yes'>
		<cfargument name='ENVIA_MSG_DESTINO' required='yes'>
		<cfargument name='ENVIA_MSG_PREVISAO_CARREGADO' required='yes'>
		<cfargument name='ENVIA_MSG_PREVISAO_VAZIO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
         	
            <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					insert into oper.evento_dado_temp (dado_id,valor) values (1,#arguments.KM#)
            </cfquery>
            
            <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            	insert into oper.evento_dado_temp (dado_id,valor) values (7,oper.pkg_global.FNC_GET_COD_FUNCIONARIO('#arguments.COD_PESSOA#'))
            </cfquery>
				
            <cfstoredproc procedure='oper.pkg_evento_controle.prc_alt_evento_operacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_EVO_ID'  value='#arguments.CONTROLE_EVO_ID#'  null='#iif(len(trim(arguments.CONTROLE_EVO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA'  value='#arguments.DATA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_KM'  value='#arguments.KM#'  null='#iif(len(trim(arguments.KM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LATITUDE'  value='#arguments.LATITUDE#'  null='#iif(len(trim(arguments.LATITUDE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LONGITUDE'  value='#arguments.LONGITUDE#'  null='#iif(len(trim(arguments.LONGITUDE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_LOCAL'  value='#arguments.LOCAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DEBITAR_MOTORISTA'  value='#arguments.DEBITAR_MOTORISTA#'  null='#iif(len(trim(arguments.DEBITAR_MOTORISTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REFERENCIA_ID'  value='#arguments.REFERENCIA_ID#'  null='#iif(len(trim(arguments.REFERENCIA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENVIA_MSG_DESTINO'  value='#arguments.ENVIA_MSG_DESTINO#'  null='#iif(len(trim(arguments.ENVIA_MSG_DESTINO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENVIA_MSG_PREVISAO_CARREGADO'  value='#arguments.ENVIA_MSG_PREVISAO_CARREGADO#'  null='#iif(len(trim(arguments.ENVIA_MSG_PREVISAO_CARREGADO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENVIA_MSG_PREVISAO_VAZIO'  value='#arguments.ENVIA_MSG_PREVISAO_VAZIO#'  null='#iif(len(trim(arguments.ENVIA_MSG_PREVISAO_VAZIO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Evento alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
   
   <!--- 
	-- PROPSITO
	-- Excluir evento
	-- jonas 12/06/2009 09:22:58 - CRIADO
	--->
	<cffunction name='del_evento_operacao' displayname='Excluir evento' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTROLE_EVO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_evento_controle.prc_del_evento_operacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_EVO_ID'  value='#arguments.CONTROLE_EVO_ID#'  null='#iif(len(trim(arguments.CONTROLE_EVO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Evento excludo com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
   
   <!--- 
	-- PROPSITO
	-- Exclui troca de terceiro de recebimento
	-- jonas 12/06/2009 16:10:23 - CRIADO
	--->
	<cffunction name='del_troca_terceiro_rece' displayname='Exclui troca de terceiro de recebimento' access='remote' returntype='Struct' output='true'>
		<cfargument name='PLACA' required='yes'>
		<cfargument name='COD_PESSOA' required='yes'>
		<cfargument name='DATA_INICIO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_evento_controle.prc_exclui_troca_terceiro_rece' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO'  value='#arguments.DATA_INICIO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Troca de recebimento excluda com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
   <!--- 
	-- PROPSITO
	-- Exclui troca de terceiro de entrega
	-- jonas 12/06/2009 16:11:13 - CRIADO
	--->
	<cffunction name='del_troca_terceiro_entr' displayname='Exclui troca de terceiro de entrega' access='remote' returntype='Struct' output='true'>
		<cfargument name='PLACA' required='yes'>
		<cfargument name='COD_PESSOA' required='yes'>
		<cfargument name='DATA_INICIO' required='yes'>
		<cfargument name='DATA_FIM' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_evento_controle.prc_exclui_troca_terceiro_entr' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO'  value='#arguments.DATA_INICIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_FIM'  value='#arguments.DATA_FIM#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Troca de entrega excluda com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
   
   <!--- 
	-- PROPSITO
	-- Insere troca de motorista de terceiro.
	-- jonas 15/06/2009 16:17:09 - CRIADO
	--->
	<cffunction name='ins_troca_terceiro' displayname='Insere troca de motorista de terceiro.' access='remote' returntype='Struct' output='true'>
		<cfargument name='PLACA' required='yes'>
		<cfargument name='COD_PESSOA' required='yes'>
		<cfargument name='DATA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_evento_controle.prc_ins_troca_terceiro' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA'  value='#arguments.DATA#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Troca de motorista de terceiro inserido com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
   
   <!--- 
	-- PROPSITO
	-- Altera troca de motorista de terceiro.
	-- jonas 15/06/2009 16:20:10 - CRIADO
	--->
	<cffunction name='upd_troca_terceiro_rece' displayname='Altera troca de motorista de terceiro.' access='remote' returntype='Struct' output='true'>
		<cfargument name='PLACA' required='yes'>
		<cfargument name='COD_PESSOA' required='yes'>
		<cfargument name='DATA_INICIO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_evento_controle.prc_alt_troca_terceiro_rece' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO'  value='#arguments.DATA_INICIO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Troca de motorista de terceiro alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
   
   <!--- 
	-- PROPSITO
	-- Altera troca de motorista de terceiro de entrega.
	-- jonas 15/06/2009 16:21:54 - CRIADO
	--->
	<cffunction name='upd_troca_terceiro_entr' displayname='Altera troca de motorista de terceiro de entrega.' access='remote' returntype='Struct' output='true'>
		<cfargument name='PLACA' required='yes'>
		<cfargument name='COD_PESSOA' required='yes'>
		<cfargument name='DATA_FIM' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_evento_controle.prc_alt_troca_terceiro_entr' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_FIM'  value='#arguments.DATA_FIM#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Troca de motorista de terceiro alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Cancela uma ou mais cargas
	-- FABIOG 02/05/2011 17:05:20 - CRIADO
	--->
	<cffunction name='cancela_cargas' displayname='Cancela uma carga' access='remote' returntype='Struct' output='true'>
		<cfargument name='CARGA_ID' required='yes'>
		<cfargument name='COD_CANCELAMENTO' required='yes'>
		<cfargument name='DATA_CANCELAMENTO' required='yes'>
		<cfargument name='MOTIVO_CANCELAMENTO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
            	<cfloop list="#arguments.CARGA_ID#" delimiters="," index="carg_id">
					<cfscript>
						 ret_canc = this.cancela_carga(carga_id 		   = carg_id 
													  ,cod_cancelamento    = arguments.COD_CANCELAMENTO
													  ,data_cancelamento   = arguments.DATA_CANCELAMENTO
													  ,motivo_cancelamento = arguments.MOTIVO_CANCELAMENTO
													  );
					</cfscript>
                    <cfif ret_canc.erro>
                        <cfthrow object="#ret_canc.mensagem#">
                    </cfif>	
				</cfloop>    
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Carga(s) cancelada(s) com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Validar o manifesto.
	-- FABIOG 16/05/2011 09:13:52 - CRIADO
	--->
	<cffunction name='validar_manifesto' displayname='Validar o manifesto' access='remote' returntype='Struct' output='true'>
		<cfargument name='MANIFESTO_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='oper.pkg_manifesto_dml.prc_validar_manifesto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MANIFESTO_ID'  value='#arguments.MANIFESTO_ID#'  null='#iif(len(trim(arguments.MANIFESTO_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
        <cfcatch>
            <cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
            <cfset request.erro = cfcatch>
        </cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
   
</cfcomponent>