<!-- KM&M Componentes -->
<cfcomponent displayname="Manipulao da rea de lancamentos avulsos" extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO
	-- Apaga lanamento de despesas avulsas
	-- CRISTOFER 22/02/2006
	--->	
	<cffunction name="del_despesa_avulsa" displayname="Apaga lanamento de despesas avulsas" access="remote" returntype="struct" output="true">
		<cfargument name="num_lancamento" displayname="Nmero do lanamento"  required="true">
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_ccorrente.prc_excluir_lancto_ccorrente" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" dbvarname="p_num_lancamento" cfsqltype="cf_sql_integer" value="#arguments.num_lancamento#">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Lanamento excluido com sucesso!"> 			
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Deleta Liberao
	-- CRISTOFER 02/03/2006
	--->
	<cffunction name="del_liberacao" access="remote" returntype="Struct" output="true" >
		<cfargument name="num_liberacao" required="true"  displayname="Cdigo da Liberao" />
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_motorista.prc_del_liberacao_pagamento" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" dbvarname="p_num_liberacao" cfsqltype="cf_sql_integer" value="#arguments.num_liberacao#">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Liberao excluida com sucesso!"> 			
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Lanamento de despesas avulsas
	-- CRISTOFER 22/02/2006
	--->
	<cffunction name="ins_despesa_avulsa" displayname="Lanamento de despesas avulsas" access="remote" returntype="struct" output="true">
		<cfargument name="cod_pessoa" 		required="yes">
		<cfargument name="cod_funcionario" 	required="yes">
		<cfargument name="nome_funcionario" required="yes">
		<cfargument name="descricao" 		required="yes">
		<cfargument name="data_lancamento" 	required="no" default="#DateFormat(Now(),'dd/mm/yyyy')#">
		<cfargument name="valor" 			required="yes">
		<cfargument name="acerto_folha" 	required="no" default="0">
		<cfargument name="debito_credito" 	required="no" default="1">
		<cftry>
			<cftransaction action="begin">
			<!--- busca a conta corrente --->
			<cfquery datasource="#session.dsn#" name="qr_ccorrente" username="#session.usuario#" password="#session.senha#">
				select cc.cod_conta  
				  from oper.v$ccorrente cc 
				 where cc.cod_pessoa = oper.pkg_global.fnc_get_cod_pessoa_func(#arguments.cod_funcionario#)
				   and cc.modalidade_id = 4  
				   and cc.ativo = 1 
 			</cfquery>
			<cfif arguments.acerto_folha eq 1>
				<cfset arguments.descricao = arguments.descricao & '-S'>
			<cfelse>
				<cfset arguments.descricao = arguments.descricao & '-N'>
			</cfif>
			<cfif not qr_ccorrente.RecordCount>
				<cfthrow detail="Impossvel fazer o lanamento, conta corrente no encontrada!"
						 message="Impossvel fazer o lanamento, conta corrente no encontrada!">
			</cfif>
			<cfif arguments.debito_credito EQ 0>
				<cfquery datasource="#session.dsn#" name="qr_documento" username="#session.usuario#" password="#session.senha#">
						select oper.pkg_global.fnc_get_parametro(6,'VIAGEM') as cod_doc
						from dual				
				</cfquery>
				<cfset cod_documento = qr_documento.cod_doc>				
				<!---	<cfset cod_documento = 94> --->
			<cfelse>
				<cfset cod_documento = 332>			
			</cfif>

			<cfif NOT Len(Trim(session.cod_pessoa))>
				<cfthrow detail="Impossvel fazer o lanamento. Favor verificar se a lotao do usurio esta OK."
						 message="Impossvel fazer o lanamento. Favor verificar se a lotao do usurio esta OK.">
			</cfif>

			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_ccorrente.prc_insere_lancto_ccorrente" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="inout" 	dbvarname="p_num_lancamento" cfsqltype="cf_sql_integer" value="0" variable="retorno.num_lancamento">
				<cfprocparam type="in" 		dbvarname="p_cod_conta" cfsqltype="cf_sql_integer" value="#qr_ccorrente.cod_conta#">
				<cfprocparam type="in" 		dbvarname="p_cod_pessoa_un" cfsqltype="cf_sql_integer" value="#session.cod_pessoa#">
				<cfprocparam type="in" 		dbvarname="p_cod_documento" cfsqltype="cf_sql_integer" value="#cod_documento#">
				<cfprocparam type="in" 		dbvarname="p_num_documento" cfsqltype="cf_sql_integer" value="0">
				<cfprocparam type="in" 		dbvarname="p_data_lancamento" cfsqltype="cf_sql_varchar" value="#DateFormat(Now(),'dd/mm/yyyy')#">
				<cfprocparam type="in" 		dbvarname="p_data_vencto" cfsqltype="cf_sql_varchar" value="#DateFormat(Now(),'dd/mm/yyyy')#">
				<cfprocparam type="in" 		dbvarname="p_historico" cfsqltype="cf_sql_varchar" value="#arguments.descricao#">
				<cfprocparam type="in" 		dbvarname="p_valor_lancamento" cfsqltype="cf_sql_float" value="#arguments.valor#">
				<cfprocparam type="in" 		dbvarname="p_deb_cred" cfsqltype="cf_sql_integer" value="#arguments.debito_credito#">
				<cfprocparam type="in" 		dbvarname="p_favorecido" cfsqltype="cf_sql_varchar" value="#arguments.nome_funcionario#">
				<cfprocparam type="out" 	dbvarname="p_rowid" cfsqltype="cf_sql_varchar" value="retorno.rowid">
			</cfstoredproc>

			<cfif arguments.acerto_folha EQ 1>
				<cfstoredproc datasource="#session.dsn#" procedure="rh.pack_rh_lancto_internet.lancto_evento_acerto" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" cfsqltype="cf_sql_numeric" dbvarname="p_cod_funcionario" value="#arguments.cod_funcionario#">
					<cfprocparam type="in" cfsqltype="cf_sql_float"   dbvarname="p_valor" value="#arguments.valor#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_data_pagamento"  value="#arguments.data_lancamento#">
				</cfstoredproc>	
			</cfif>
			<cfset retorno.erro = false />
			<cfset retorno.mensagem = "Lanamento efetuado com sucesso!" /> 			
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback" />
				<cfset retorno.erro = true />
				<cfset retorno.mensagem = cfcatch />
				<cfset request.erro = cfcatch />
			</cfcatch>
		</cftry>	
		<cfreturn retorno>
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Insere Liberao
	-- CRISTOFER 02/03/2006
	--->	
	<cffunction name="ins_liberacao" access="remote" returntype="Struct" output="true" >
		<cfargument name="num_liberacao" 	required="no" default="-1" />
		<cfargument name="responsavel" 		required="no" default="#session.usuario#" />
		<cfargument name="cod_pessoa" 		required="yes" />
		<cfargument name="produto_id" 		required="yes" />
		<cfargument name="valor" 			required="yes" />
		<cfargument name="complemento" 		required="yes" />
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_motorista.prc_ins_liberacao_pagamento" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" dbvarname="p_responsavel" cfsqltype="cf_sql_varchar" value="#arguments.responsavel#">
					<cfprocparam type="in" dbvarname="p_cod_pessoa" cfsqltype="cf_sql_integer" value="#arguments.cod_pessoa#">
					<cfprocparam type="in" dbvarname="p_data_autorizacao" cfsqltype="cf_sql_varchar" value="#DateFormat(Now(),'dd/mm/yyyy')# #TimeFormat(Now(),'HH:MM')#">
					<cfprocparam type="in" dbvarname="p_produto_id" cfsqltype="cf_sql_integer" value="#arguments.produto_id#">
					<cfprocparam type="in" dbvarname="p_valor" cfsqltype="cf_sql_float" value="#arguments.valor#">
					<cfprocparam type="in" dbvarname="p_complemento" cfsqltype="cf_sql_varchar" value="#arguments.complemento#">
					<cfprocparam type="in" dbvarname="p_cod_pessoa_posto" cfsqltype="cf_sql_integer" null="yes">
					<cfprocparam type="in" dbvarname="p_placa" cfsqltype="cf_sql_varchar" null="yes">
					<cfprocparam type="inout" dbvarname="p_num_liberacao" cfsqltype="cf_sql_integer" value="0" variable="retorno.num_liberacao">
					<cfprocparam type="out" 	dbvarname="p_rowid" cfsqltype="cf_sql_varchar" value="retorno.rowid">
				</cfstoredproc>
				<cfset retorno.erro = false />
				<cfset retorno.mensagem = "Liberao Inserida com sucesso" /> 			
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback" />
				<cfset retorno.erro = true />
				<cfset retorno.mensagem = cfcatch />
				<cfset request.erro = cfcatch />
			</cfcatch>
		</cftry>		
		<cfreturn retorno/>
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere POQ
	-- CRISTOFER 22/02/2006
	--->	
	<cffunction name="ins_poq" displayname="Insere POQ" access="remote" returntype="struct" output="true">
		<cfargument	name="poq" required="yes">
		<cfargument name="cod_funcionario" required="yes">
		<cfargument name="valor" required="yes">
		<cftry>
			<cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				insert into oper.poq_funcionarios
				  (num_poq, cod_pessoa, data_limite, valor)
				values
				  ('#arguments.poq#', decode(oper.pkg_global.fnc_get_cod_pessoa_func(#arguments.cod_funcionario#),-1,#arguments.cod_funcionario#,oper.pkg_global.fnc_get_cod_pessoa_func(#arguments.cod_funcionario#)), sysdate+20, #arguments.valor#)
  			</cfquery>
			<cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>	
		<cfreturn retorno>
	</cffunction>		
</cfcomponent>