<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO 
	-- Insere um projeto
	-- CRISTOFER  28/04/2006
	--->
	<cffunction name="ins_projeto" displayname="Insere projeto" access="remote" returntype="struct" output="true">
		<cfargument name="cod_projeto" required="yes">
		<cfargument name="nome_projeto" required="yes">
		<cftry>
			<cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				insert into kss.kss_projeto
				  (cod_projeto, nome_projeto)
				values
				  (#cod_projeto#, '#nome_projeto#')
			</cfquery>
			<cfset retorno.mensagem = 'Projeto inserido com sucesso!'>
			<cfset retorno.erro     = false >	
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Altera um projeto
	-- CRISTOFER  28/04/2006
	--->
	<cffunction name="upd_projeto" displayname="Insere projeto" access="remote" returntype="struct" output="true">
		<cfargument name="cod_projeto" required="yes">
		<cfargument name="nome_projeto" required="yes">
		<cftry>
			<cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				update kss.kss_projeto
				   set nome_projeto = '#nome_projeto#'
				 where cod_projeto = #cod_projeto#
 			</cfquery>
			<cfset retorno.mensagem = 'Projeto alterado com sucesso!'>
			<cfset retorno.erro     = false >	
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Exclui um projeto
	-- CRISTOFER  28/04/2006
	--->
	<cffunction name="del_projeto" displayname="Insere projeto" access="remote" returntype="struct" output="true">
		<cfargument name="cod_projeto" required="yes">
		<cfargument name="nome_projeto" required="yes">
		<cftry>
			<cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				delete kss.kss_projeto
				 where cod_projeto = #cod_projeto#
			</cfquery>
			<cfset retorno.mensagem = 'Projeto excludo com sucesso!'>
			<cfset retorno.erro     = false >	
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Insere uma aplicacao
	-- CRISTOFER  28/04/2006
	--->
	<cffunction name="ins_aplicacao" displayname="Insere aplicao" access="remote" returntype="struct" output="true">
		<cfargument name="cod_projeto" required="yes">
		<cfargument name="cod_aplicacao" required="yes">
		<cfargument name="nome_aplicacao" required="yes">
		<cfargument name="tipo_aplicacao_id" required="yes">
		<cfargument name="role" required="no">
		<cftry>
			<cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				insert into kss.kss_aplicacao
				  (cod_projeto, cod_aplicacao, nome_aplicacao, tipo_aplicacao_id, role)
				values
				  (#arguments.cod_projeto#, '#arguments.cod_aplicacao#', '#arguments.nome_aplicacao#', #arguments.tipo_aplicacao_id#, '#arguments.role#')
  			</cfquery>
			<cfset retorno.mensagem = 'Aplicacao inserida com sucesso!'>
			<cfset retorno.erro     = false >	
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Altera uma aplicacao
	-- CRISTOFER  28/04/2006
	--->
	<cffunction name="upd_aplicacao" displayname="Altera aplicao" access="remote" returntype="struct" output="true">
		<cfargument name="cod_projeto" required="yes">
		<cfargument name="cod_aplicacao" required="yes">
		<cfargument name="nome_aplicacao" required="yes">
		<cfargument name="tipo_aplicacao_id" required="yes">
		<cfargument name="role" required="no">
		<cftry>
			<cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				update kss.kss_aplicacao
				   set cod_projeto = #arguments.cod_projeto#,
					   nome_aplicacao = '#arguments.nome_aplicacao#',
					   tipo_aplicacao_id = #arguments.tipo_aplicacao_id#,
					   role = '#arguments.role#'
				 where cod_projeto = #arguments.cod_projeto#
				   and cod_aplicacao = '#arguments.cod_aplicacao#'
   			</cfquery>
			<cfset retorno.mensagem = 'Aplicacao alterada com sucesso!'>
			<cfset retorno.erro     = false >	
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Exclui uma aplicacao
	-- CRISTOFER  28/04/2006
	--->
	<cffunction name="del_aplicacao" displayname="Altera aplicao" access="remote" returntype="struct" output="true">
		<cfargument name="cod_projeto" required="yes">
		<cfargument name="cod_aplicacao" required="yes">
		<cfargument name="nome_aplicacao" required="yes">
		<cftry>
			<cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				delete kss.kss_aplicacao
				 where cod_projeto = #arguments.cod_projeto#
				   and cod_aplicacao = '#arguments.cod_aplicacao#'
   			</cfquery>
			<cfset retorno.mensagem = 'Aplicacao excluda com sucesso!'>
			<cfset retorno.erro     = false >	
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Libera nivel acesso para aplicao do sistema
	-- CRISTOFER  28/04/2006
	--->
	<cffunction name="altera_nivel_acesso" displayname="" access="remote" returntype="struct" output="true">
		<cfargument name="usuario" required="yes">
		<cfargument name="nivel_acesso" required="yes">
		<cftry>
			<cftransaction action="begin">
				<cfloop index="aplic" list="#arguments.nivel_acesso#" delimiters=",">
					<cfstoredproc datasource="#session.dsn#" procedure="internet.pkg_kss_web.prc_ins_niv_acesso_usr_aplic" username="#session.usuario#" password="#session.senha#">
						<cfprocparam type="in" dbvarname="p_cod_projeto" cfsqltype="cf_sql_integer" value="#ListGetAt(aplic,1,'@')#">
						<cfprocparam type="in" dbvarname="p_cod_aplicacao" cfsqltype="cf_sql_varchar" value="#ListGetAt(aplic,2,'@')#">
						<cfprocparam type="in" dbvarname="p_cod_nivel_acesso" cfsqltype="cf_sql_integer" value="#ListGetAt(aplic,3,'@')#">
						<cfprocparam type="in" dbvarname="p_usuario" cfsqltype="cf_sql_varchar" value="#arguments.usuario#">
					</cfstoredproc>
				</cfloop>

			</cftransaction>
			<cfset retorno.mensagem = 'Niveis de acesso liberados com sucesso!'>
			<cfset retorno.erro     = false >	
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Inserir acesso a aplicao do sistema
	-- CRISTOFER  28/04/2006
	--->
	<cffunction name="libera_aplicacao_acesso" displayname="" access="remote" returntype="struct" output="true">
		<cfargument name="usuario" required="yes">
		<cfargument name="aplicacoes_liberadas" required="yes">
		<cftry>
			<cftransaction action="begin">
				<!--- Limpa acessos, para depois inserir todos novamente--->
				<cfquery name="qrAcessos" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					select cod_pessoa, cod_projeto, cod_aplicacao 
					  from kss.pessoa_usuario_aplicacao
					 where usuario = upper('#arguments.usuario#')
 				</cfquery>
				
				<cfloop query="qrAcessos">
					<cfstoredproc datasource="#session.dsn#" procedure="internet.pkg_kss_web.prc_del_pessoa_usr_aplicacao" username="#session.usuario#" password="#session.senha#">
						<cfprocparam type="in" dbvarname="p_cod_pessoa" cfsqltype="cf_sql_integer" value="#qrAcessos.cod_pessoa#">
						<cfprocparam type="in" dbvarname="p_cod_projeto" cfsqltype="cf_sql_integer" value="#qrAcessos.cod_projeto#">
						<cfprocparam type="in" dbvarname="p_cod_aplicacao" cfsqltype="cf_sql_varchar" value="#qrAcessos.cod_aplicacao#">
						<cfprocparam type="in" dbvarname="p_usuario" cfsqltype="cf_sql_varchar" value="#arguments.usuario#">
					</cfstoredproc>				
				</cfloop>				
				
				<!--- Insere acesso a aplicao--->
				<cfloop index="aplic" list="#arguments.aplicacoes_liberadas#" delimiters="||">
					<cfstoredproc datasource="#session.dsn#" procedure="internet.pkg_kss_web.prc_ins_pessoa_usr_aplicacao" username="#session.usuario#" password="#session.senha#">
						<cfprocparam type="in" dbvarname="p_cod_pessoa" cfsqltype="cf_sql_integer" value="#ListGetAt(aplic,3,';')#">
						<cfprocparam type="in" dbvarname="p_cod_projeto" cfsqltype="cf_sql_integer" value="#ListGetAt(aplic,1,';')#">
						<cfprocparam type="in" dbvarname="p_cod_aplicacao" cfsqltype="cf_sql_varchar" value="#ListGetAt(aplic,2,';')#">
						<cfprocparam type="in" dbvarname="p_usuario" cfsqltype="cf_sql_varchar" value="#arguments.usuario#">
						<cfprocparam type="in" dbvarname="p_administrador" cfsqltype="cf_sql_integer" null="yes">
					</cfstoredproc>
				</cfloop>

			</cftransaction>
			<cfset retorno.mensagem = 'Acessos liberados com sucesso!'>
			<cfset retorno.erro     = false >	
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
	<cfreturn retorno>	
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Inserir suporte a aplicao do sistema
	-- CRISTOFER  28/04/2006
	--->
	<cffunction name="libera_aplicacao_suporte" displayname="" access="remote" returntype="struct" output="true">
		<cfargument name="usuario" required="yes">
		<cfargument name="aplicacoes_liberadas" required="yes">
		<cftry>
			<cftransaction action="begin">
				<!--- Limpa acessos, para depois inserir todos novamente--->
				<cfquery name="qrAcessos" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					select cod_pessoa, cod_projeto, cod_aplicacao 
					  from internet.pessoa_usr_aplic_suporte
					 where usuario = upper('#arguments.usuario#')
  				</cfquery>
				
				<cfloop query="qrAcessos">
					<cfstoredproc datasource="#session.dsn#" procedure="internet.pkg_kss_web.prc_del_usr_aplic_suporte" username="#session.usuario#" password="#session.senha#">
						<cfprocparam type="in" dbvarname="p_cod_pessoa" cfsqltype="cf_sql_integer" value="#qrAcessos.cod_pessoa#">
						<cfprocparam type="in" dbvarname="p_cod_projeto" cfsqltype="cf_sql_integer" value="#qrAcessos.cod_projeto#">
						<cfprocparam type="in" dbvarname="p_cod_aplicacao" cfsqltype="cf_sql_varchar" value="#qrAcessos.cod_aplicacao#">
						<cfprocparam type="in" dbvarname="p_usuario" cfsqltype="cf_sql_varchar" value="#arguments.usuario#">
					</cfstoredproc>				
				</cfloop>				
				
				<!--- Insere acesso a aplicao--->
				<cfloop index="aplic" list="#arguments.aplicacoes_liberadas#" delimiters="||">
					<cfstoredproc datasource="#session.dsn#" procedure="internet.pkg_kss_web.prc_ins_usr_aplic_suporte" username="#session.usuario#" password="#session.senha#">
						<cfprocparam type="in" dbvarname="p_cod_pessoa" cfsqltype="cf_sql_integer" value="#ListGetAt(aplic,3,';')#">
						<cfprocparam type="in" dbvarname="p_cod_projeto" cfsqltype="cf_sql_integer" value="#ListGetAt(aplic,1,';')#">
						<cfprocparam type="in" dbvarname="p_cod_aplicacao" cfsqltype="cf_sql_varchar" value="#ListGetAt(aplic,2,';')#">
						<cfprocparam type="in" dbvarname="p_usuario" cfsqltype="cf_sql_varchar" value="#arguments.usuario#">
						<cfprocparam type="in" dbvarname="p_administrador" cfsqltype="cf_sql_integer" null="yes">
					</cfstoredproc>
				</cfloop>

			</cftransaction>
			<cfset retorno.mensagem = 'Acessos para suporte liberados com sucesso!'>
			<cfset retorno.erro     = false >	
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
	<cfreturn retorno>	
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Inserir tcnico de suporte a aplicao do sistema
	-- CRISTOFER  28/04/2006
	--->
	<cffunction name="ativa_tecnico_suporte" displayname="Inserir tcnico de suporte a aplicao do sistema" access="remote" returntype="struct" output="true">
		<cfargument name="usuario" required="yes">
		<cfargument name="aplicacoes_liberadas" required="yes">
		<cftry>	
			<cftransaction action="begin">
				<!--- Limpa acessos, para depois inserir todos novamente--->
				<cfquery name="qrAcessos" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					select cod_projeto, cod_aplicacao, tecnico_suporte
					  from kss.kss_usuarios_suporte
					 where tecnico_suporte = upper('#arguments.usuario#')
  				</cfquery>
				
				<cfloop query="qrAcessos">
					<cfstoredproc datasource="#session.dsn#" procedure="internet.pkg_kss_web.prc_del_tecnico_suporte" username="#session.usuario#" password="#session.senha#">
						<cfprocparam type="in" dbvarname="p_cod_projeto" cfsqltype="cf_sql_integer" value="#qrAcessos.cod_projeto#">
						<cfprocparam type="in" dbvarname="p_cod_aplicacao" cfsqltype="cf_sql_varchar" value="#qrAcessos.cod_aplicacao#">
						<cfprocparam type="in" dbvarname="p_tecnico_suporte" cfsqltype="cf_sql_varchar" value="#arguments.usuario#">
					</cfstoredproc>				
				</cfloop>				
				
				<!--- Insere acesso a aplicao--->
				<cfloop index="aplic" list="#arguments.aplicacoes_liberadas#" delimiters="||">
					<cfstoredproc datasource="#session.dsn#" procedure="internet.pkg_kss_web.prc_ins_tecnico_suporte" username="#session.usuario#" password="#session.senha#">
						<cfprocparam type="in" dbvarname="p_cod_projeto" cfsqltype="cf_sql_integer" value="#ListGetAt(aplic,1,';')#">
						<cfprocparam type="in" dbvarname="p_cod_aplicacao" cfsqltype="cf_sql_varchar" value="#ListGetAt(aplic,2,';')#">
						<cfprocparam type="in" dbvarname="p_tecnico_suporte" cfsqltype="cf_sql_varchar" value="#arguments.usuario#">
					</cfstoredproc>
				</cfloop>

			</cftransaction>
			<cfset retorno.mensagem = 'Tcnico de suporte cadastrado com sucesso!'>
			<cfset retorno.erro     = false >	
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
	<cfreturn retorno>	
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Vincula pessoa com aplicao
	-- CRISTOFER  28/04/2006
	--->
	<cffunction name="libera_pessoa_aplicacao" displayname="Vincula pessoa com aplicao" access="remote" returntype="struct" output="true">
		<cfargument name="cod_pessoa" required="yes">
		<cfargument name="cod_projeto" required="yes">
		<cfargument name="cod_aplicacao" required="yes">		
		
		<cftry>
			
			<cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				insert into kss.pessoa_aplicacao
				  (cod_pessoa, cod_projeto, cod_aplicacao, situacao)
				values
				  (#arguments.cod_pessoa#, #arguments.cod_projeto#, '#arguments.cod_aplicacao#', 1)
			</cfquery>
			<cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				insert into internet.pessoa_aplicacao_suporte
				  (cod_pessoa, cod_projeto, cod_aplicacao, situacao)
				values
				  (#arguments.cod_pessoa#, #arguments.cod_projeto#, '#arguments.cod_aplicacao#', 1)
			</cfquery>
			<cfset retorno.mensagem = 'Vnculo cadastrado com sucesso!'>
			<cfset retorno.erro     = false >
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
	<cfreturn retorno>	
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Cancela vnculo de pessoa com aplicao
	-- CRISTOFER  28/04/2006
	--->
	<cffunction name="cancela_pessoa_aplicacao" displayname="" access="remote" returntype="struct" output="true">
		<cfargument name="cod_pessoa_del" required="yes">
		<cfargument name="cod_projeto_del" required="yes">
		<cfargument name="cod_aplicacao_del" required="yes">	
		<cftry>
			<cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				delete from kss.pessoa_aplicacao
				 where	cod_pessoa = #arguments.cod_pessoa_del#
				 and cod_projeto = #arguments.cod_projeto_del#
				 and cod_aplicacao = '#arguments.cod_aplicacao_del#'
			</cfquery>
			<cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				delete from internet.pessoa_aplicacao_suporte
				 where cod_pessoa = #arguments.cod_pessoa_del#
  				   and cod_projeto = #arguments.cod_projeto_del#
				   and cod_aplicacao = '#arguments.cod_aplicacao_del#'
			</cfquery>
			<cfset retorno.mensagem = 'Vnculo excludo com sucesso!'>
			<cfset retorno.erro     = false >	
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
	<cfreturn retorno>	
	</cffunction>	

<!---
	<cffunction name="ins_formulario" displayname="Insere Formularios" access="remote" returntype="struct" output="true">
		<cfargument name="cod_projeto" required="yes">
		<cfargument name="cod_aplicacao" required="yes">
		<cfargument name="form_name" required="yes">
		<cfargument name="form_caption" required="yes">
		<cftry>
			<cfquery datasource="#application.dsn#" username="#session.usuario#" password="#session.senha#">
				insert into kss.kss_formulario
				  (cod_projeto, cod_aplicacao, form_name, form_caption)
				values
				  (#cod_projeto#, '#cod_aplicacao#', '#form_name#', '#form_caption#')
   			</cfquery>

			<cfset retorno.mensagem = 'Formulario ' & #form_name# & ' inserido com sucesso.'>
			<cfset retorno.erro     = false >	
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
	<cfreturn retorno>	
	</cffunction>		

	<cffunction name="upd_formulario" displayname="Alterar Formularios" access="remote" returntype="struct" output="true">
		<cfargument name="cod_projeto" required="yes">
		<cfargument name="cod_aplicacao" required="yes">
		<cfargument name="form_name" required="yes">
		<cfargument name="form_caption" required="yes">
		<cftry>
			<cfquery datasource="#application.dsn#" username="#session.usuario#" password="#session.senha#">
				update kss.kss_formulario
				   set cod_projeto   = #cod_projeto#,
					   cod_aplicacao = '#cod_aplicacao#',
					   form_caption  = '#form_caption#'
				 where cod_projeto   = #cod_projeto#
				   and cod_aplicacao = '#cod_aplicacao#'
				   and form_name     = '#form_name#'
   			</cfquery>
			<cfset retorno.mensagem = 'Formulrio ' & #form_name# & ' alterado com sucesso.'>
			<cfset retorno.erro     = false >	
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
	<cfreturn retorno>	
	</cffunction>		

	<cffunction name="del_formulario" displayname="Excluir Formularios" access="remote" returntype="struct" output="true">
		<cfargument name="cod_projeto" required="yes">
		<cfargument name="cod_aplicacao" required="yes">
		<cfargument name="form_name" required="yes">
		<cfargument name="form_caption" required="no">
		<cftry>
			<cfquery datasource="#application.dsn#" username="#session.usuario#" password="#session.senha#">
				delete kss.kss_formulario
				 where cod_projeto = #cod_projeto#
				   and cod_aplicacao = '#cod_aplicacao#'
				   and form_name = '#form_name#'
   			</cfquery>
			<cfset retorno.mensagem = 'Formulrio ' & #form_name# & ' excludo com sucesso.'>
			<cfset retorno.erro     = false >	
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
	<cfreturn retorno>	
	</cffunction>			

	<cffunction name="ins_nivel_acesso" displayname="Inserir nivel de acesso" access="remote" returntype="struct" output="true">
		<cfargument name="nome_nivel_acesso" required="yes">
		<cfargument name="intervalo_mudanca_senha" required="yes">
		<cftry>
			<cfquery datasource="#application.dsn#" username="#session.usuario#" password="#session.senha#">
				insert into kss.kss_nivel_acesso
				  (nome_nivel_acesso, intervalo_mudanca_senha)
				values
				  ('#nome_nivel_acesso#', #intervalo_mudanca_senha#)
  			</cfquery>
			<cfset retorno.mensagem = 'Nvel de acesso ' & #nome_nivel_acesso# & ' inserido com sucesso.'>
			<cfset retorno.erro     = false >	
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
	<cfreturn retorno>	
	</cffunction>				
	
	<cffunction name="upd_nivel_acesso" displayname="Inserir nivel de acesso" access="remote" returntype="struct" output="true">
		<cfargument name="cod_nivel_acesso" required="yes">
		<cfargument name="nome_nivel_acesso" required="yes">
		<cfargument name="intervalo_mudanca_senha" required="yes">
		<cftry>
			<cfquery datasource="#application.dsn#" username="#session.usuario#" password="#session.senha#">
				update kss.kss_nivel_acesso
				   set nome_nivel_acesso = '#nome_nivel_acesso#',
					   intervalo_mudanca_senha = '#intervalo_mudanca_senha#'
				 where cod_nivel_acesso = #cod_nivel_acesso#
   			</cfquery>
			<cfset retorno.mensagem = 'Nvel de acesso ' & #nome_nivel_acesso# & ' alterado com sucesso.'>
			<cfset retorno.erro     = false >	
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
	<cfreturn retorno>	
	</cffunction>				
	
	<cffunction name="del_nivel_acesso" displayname="Inserir nivel de acesso" access="remote" returntype="struct" output="true">
		<cfargument name="cod_nivel_acesso" required="yes">
		<cfargument name="nome_nivel_acesso" required="yes">
		<cftry>
			<cfquery datasource="#application.dsn#" username="#session.usuario#" password="#session.senha#">
				delete kss.kss_nivel_acesso
				 where cod_nivel_acesso = #cod_nivel_acesso#
   			</cfquery>
			<cfset retorno.mensagem = 'Nvel de acesso ' & #nome_nivel_acesso# & ' excludo com sucesso.'>
			<cfset retorno.erro     = false >	
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
	<cfreturn retorno>	
	</cffunction>							

	<cffunction name="ins_usuario" displayname="Inserir usuario no sistema" access="remote" returntype="struct" output="true">
		<cfargument name="usuario" required="yes">
		<cfargument name="nome" required="yes">
		<cfargument name="cod_pessoa" required="yes">
		<cfargument name="descricao" required="no">
		<cfargument name="ativo" required="yes">
		<cfargument name="email" required="yes">
		<cftry>
			<cftransaction action="begin">
				<!--- Insere o usurio --->
				<cfstoredproc datasource="#application.dsn#" procedure="internet.pkg_kss_web.prc_ins_usuario" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" dbvarname="p_usuario" cfsqltype="cf_sql_varchar" value="#arguments.usuario#">
					<cfprocparam type="in" dbvarname="p_nome" cfsqltype="cf_sql_varchar" value="#arguments.nome#">
					<cfprocparam type="in" dbvarname="p_descricao" cfsqltype="cf_sql_varchar" value="#arguments.descricao#">
					<cfprocparam type="in" dbvarname="p_cod_pessoa" cfsqltype="cf_sql_integer" value="#arguments.cod_pessoa#">
					<cfprocparam type="in" dbvarname="p_profile" cfsqltype="cf_sql_varchar" value="DEFAULT">
					<cfprocparam type="in" dbvarname="p_senha" cfsqltype="cf_sql_varchar" null="yes">
					<cfprocparam type="in" dbvarname="p_username" cfsqltype="cf_sql_varchar" value="#GetToken(arguments.email,1,'@')#">
					<cfprocparam type="in" dbvarname="p_provedor" cfsqltype="cf_sql_varchar" value="#GetToken(arguments.email,2,'@')#">
				</cfstoredproc>

			</cftransaction>
			<cfset retorno.mensagem = 'Usurio ' & #nome# & ' inserido com sucesso.'>
			<cfset retorno.erro     = false >	
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
	<cfreturn retorno>	
	</cffunction>									

	<cffunction name="upd_usuario" displayname="Inserir usuario no sistema" access="remote" returntype="struct" output="true">
		<cfargument name="usuario" required="yes">
		<cfargument name="nome" required="yes">
		<cfargument name="cod_pessoa" required="yes">
		<cfargument name="descricao" required="no">
		<cfargument name="ativo" required="yes">
		<cfargument name="email" required="yes">
		<cftry>
			<cftransaction action="begin">
				<!--- Insere o usurio --->
				<cfstoredproc datasource="#application.dsn#" procedure="internet.pkg_kss_web.prc_upd_usuario" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" dbvarname="p_usuario" cfsqltype="cf_sql_varchar" value="#arguments.usuario#">
					<cfprocparam type="in" dbvarname="p_nome" cfsqltype="cf_sql_varchar" value="#arguments.nome#">
					<cfprocparam type="in" dbvarname="p_descricao" cfsqltype="cf_sql_varchar" value="#arguments.descricao#">
					<cfprocparam type="in" dbvarname="p_cod_pessoa" cfsqltype="cf_sql_integer" value="#arguments.cod_pessoa#">
					<cfprocparam type="in" dbvarname="p_ativo" cfsqltype="cf_sql_integer" value="#arguments.ativo#">
					<cfprocparam type="in" dbvarname="p_username" cfsqltype="cf_sql_varchar" value="#GetToken(arguments.email,1,'@')#">
					<cfprocparam type="in" dbvarname="p_provedor" cfsqltype="cf_sql_varchar" value="#GetToken(arguments.email,2,'@')#">
				</cfstoredproc>

			</cftransaction>
			<cfset retorno.mensagem = 'Usurio ' & #nome# & ' alterado com sucesso.'>
			<cfset retorno.erro     = false >	
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
	<cfreturn retorno>	
	</cffunction>									


	<cffunction name="libera_aplicacao_suporte" displayname="Inserir suporte a aplicao do sistema" access="remote" returntype="struct" output="true">
		<cfargument name="usuario" required="yes">
		<cfargument name="aplicacoes_liberadas" required="yes">
		<cftry>
			<cftransaction action="begin">
				<!--- Limpa acessos, para depois inserir todos novamente--->
				<cfquery name="qrAcessos" datasource="#application.dsn#" username="#session.usuario#" password="#session.senha#">
					select cod_pessoa, cod_projeto, cod_aplicacao 
					  from internet.pessoa_usr_aplic_suporte
					 where usuario = upper('#arguments.usuario#')
  				</cfquery>
				
				<cfloop query="qrAcessos">
					<cfstoredproc datasource="#application.dsn#" procedure="internet.pkg_kss_web.prc_del_usr_aplic_suporte" username="#session.usuario#" password="#session.senha#">
						<cfprocparam type="in" dbvarname="p_cod_pessoa" cfsqltype="cf_sql_integer" value="#qrAcessos.cod_pessoa#">
						<cfprocparam type="in" dbvarname="p_cod_projeto" cfsqltype="cf_sql_integer" value="#qrAcessos.cod_projeto#">
						<cfprocparam type="in" dbvarname="p_cod_aplicacao" cfsqltype="cf_sql_varchar" value="#qrAcessos.cod_aplicacao#">
						<cfprocparam type="in" dbvarname="p_usuario" cfsqltype="cf_sql_varchar" value="#arguments.usuario#">
					</cfstoredproc>				
				</cfloop>				
				
				<!--- Insere acesso a aplicao--->
				<cfloop index="aplic" list="#arguments.aplicacoes_liberadas#" delimiters="||">
					<cfstoredproc datasource="#application.dsn#" procedure="internet.pkg_kss_web.prc_ins_usr_aplic_suporte" username="#session.usuario#" password="#session.senha#">
						<cfprocparam type="in" dbvarname="p_cod_pessoa" cfsqltype="cf_sql_integer" value="#ListGetAt(aplic,3,';')#">
						<cfprocparam type="in" dbvarname="p_cod_projeto" cfsqltype="cf_sql_integer" value="#ListGetAt(aplic,1,';')#">
						<cfprocparam type="in" dbvarname="p_cod_aplicacao" cfsqltype="cf_sql_varchar" value="#ListGetAt(aplic,2,';')#">
						<cfprocparam type="in" dbvarname="p_usuario" cfsqltype="cf_sql_varchar" value="#arguments.usuario#">
						<cfprocparam type="in" dbvarname="p_administrador" cfsqltype="cf_sql_integer" null="yes">
					</cfstoredproc>
				</cfloop>

			</cftransaction>
			<cfset retorno.mensagem = 'Acessos para suporte liberados com sucesso.'>
			<cfset retorno.erro     = false >	
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
	<cfreturn retorno>	
	</cffunction>										

	<cffunction name="ativa_tecnico_suporte" displayname="Inserir tcnico de suporte a aplicao do sistema" access="remote" returntype="struct" output="true">
		<cfargument name="usuario" required="yes">
		<cfargument name="aplicacoes_liberadas" required="yes">
		<cftry>	
			<cftransaction action="begin">
				<!--- Limpa acessos, para depois inserir todos novamente--->
				<cfquery name="qrAcessos" datasource="#application.dsn#" username="#session.usuario#" password="#session.senha#">
					select cod_projeto, cod_aplicacao, tecnico_suporte
					  from kss.kss_usuarios_suporte
					 where tecnico_suporte = upper('#arguments.usuario#')
  				</cfquery>
				
				<cfloop query="qrAcessos">
					<cfstoredproc datasource="#application.dsn#" procedure="internet.pkg_kss_web.prc_del_tecnico_suporte" username="#session.usuario#" password="#session.senha#">
						<cfprocparam type="in" dbvarname="p_cod_projeto" cfsqltype="cf_sql_integer" value="#qrAcessos.cod_projeto#">
						<cfprocparam type="in" dbvarname="p_cod_aplicacao" cfsqltype="cf_sql_varchar" value="#qrAcessos.cod_aplicacao#">
						<cfprocparam type="in" dbvarname="p_tecnico_suporte" cfsqltype="cf_sql_varchar" value="#arguments.usuario#">
					</cfstoredproc>				
				</cfloop>				
				
				<!--- Insere acesso a aplicao--->
				<cfloop index="aplic" list="#arguments.aplicacoes_liberadas#" delimiters="||">
					<cfstoredproc datasource="#application.dsn#" procedure="internet.pkg_kss_web.prc_ins_tecnico_suporte" username="#session.usuario#" password="#session.senha#">
						<cfprocparam type="in" dbvarname="p_cod_projeto" cfsqltype="cf_sql_integer" value="#ListGetAt(aplic,1,';')#">
						<cfprocparam type="in" dbvarname="p_cod_aplicacao" cfsqltype="cf_sql_varchar" value="#ListGetAt(aplic,2,';')#">
						<cfprocparam type="in" dbvarname="p_tecnico_suporte" cfsqltype="cf_sql_varchar" value="#arguments.usuario#">
					</cfstoredproc>
				</cfloop>

			</cftransaction>
			<cfset retorno.mensagem = 'Tcnico de suporte cadastrado com sucesso.'>
			<cfset retorno.erro     = false >	
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
	<cfreturn retorno>	
	</cffunction>										

	<cffunction name="altera_nivel_acesso" displayname="Libera nivel acesso para aplicao do sistema" access="remote" returntype="struct" output="true">
		<cfargument name="usuario" required="yes">
		<cfargument name="nivel_acesso" required="yes">
		<cftry>
			<cftransaction action="begin">
				<!--- Insere acesso a aplicao--->
				<cfloop index="aplic" list="#arguments.nivel_acesso#" delimiters=",">
					<cfstoredproc datasource="#session.dsn#" procedure="internet.pkg_kss_web.prc_ins_niv_acesso_usr_aplic" username="#session.usuario#" password="#session.senha#">
						<cfprocparam type="in" dbvarname="p_cod_projeto" cfsqltype="cf_sql_integer" value="#ListGetAt(aplic,1,'@')#">
						<cfprocparam type="in" dbvarname="p_cod_aplicacao" cfsqltype="cf_sql_varchar" value="#ListGetAt(aplic,2,'@')#">
						<cfprocparam type="in" dbvarname="p_cod_nivel_acesso" cfsqltype="cf_sql_integer" value="#ListGetAt(aplic,3,'@')#">
						<cfprocparam type="in" dbvarname="p_usuario" cfsqltype="cf_sql_varchar" value="#arguments.usuario#">
					</cfstoredproc>
				</cfloop>

			</cftransaction>
			<cfset retorno.mensagem = 'Nivel acesso liberados com sucesso.'>
			<cfset retorno.erro     = false >	
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
	<cfreturn retorno>	
	</cffunction>										
	
	<cffunction name="libera_pessoa_aplicacao" displayname="Vincula pessoa com aplicao" access="remote" returntype="struct" output="true">
		<cfargument name="cod_pessoa" required="yes">
		<cfargument name="cod_projeto" required="yes">
		<cfargument name="cod_aplicacao" required="yes">		
		
		<cftry>
			
			<cfquery datasource="#application.dsn#" username="#session.usuario#" password="#session.senha#">
				insert into kss.pessoa_aplicacao
				  (cod_pessoa, cod_projeto, cod_aplicacao, situacao)
				values
				  (#cod_pessoa#, #cod_projeto#, '#cod_aplicacao#', 1)
			</cfquery>
			<cfquery datasource="#application.dsn#" username="#session.usuario#" password="#session.senha#">
				insert into internet.pessoa_aplicacao_suporte
				  (cod_pessoa, cod_projeto, cod_aplicacao, situacao)
				values
				  (#cod_pessoa#, #cod_projeto#, '#cod_aplicacao#', 1)
			</cfquery>
			<cfset retorno.mensagem = 'Vnculo cadastrado com sucesso.'>
			<cfset retorno.erro     = false >
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
	<cfreturn retorno>	
	</cffunction>

	<cffunction name="cancela_pessoa_aplicacao" displayname="Cancela vnculo de pessoa com aplicao" access="remote" returntype="struct" output="true">
		<cfargument name="cod_pessoa_del" required="yes">
		<cfargument name="cod_projeto_del" required="yes">
		<cfargument name="cod_aplicacao_del" required="yes">	
		<cftry>
			<cfquery datasource="#application.dsn#" username="#session.usuario#" password="#session.senha#">
				delete from kss.pessoa_aplicacao
				 where	cod_pessoa = #cod_pessoa_del#
				 and cod_projeto = #cod_projeto_del#
				 and cod_aplicacao = '#cod_aplicacao_del#'
			</cfquery>
			<cfquery datasource="#application.dsn#" username="#session.usuario#" password="#session.senha#">
				delete from internet.pessoa_aplicacao_suporte
				 where cod_pessoa = #cod_pessoa_del#
  				   and cod_projeto = #cod_projeto_del#
				   and cod_aplicacao = '#cod_aplicacao_del#'
			</cfquery>
			<cfset retorno.mensagem = 'Vnculo excludo com sucesso.'>
			<cfset retorno.erro     = false >	
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
	<cfreturn retorno>	
	</cffunction>--->
	
</cfcomponent>				   