<cfcomponent displayname="Controle e manipulao de celules, grupo, mensagens SMS" extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO
	-- Insere um novo grupo de celulares
	-- guto 22/04/2006 12:01:16 - CRIADO
	--->
	<cffunction name='ins_grupo' displayname='Insere um novo grupo de celulares' access='remote' returntype='Struct' output='true'>;
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm_sms.pkg_controle_sms.prc_ins_grupo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_GRUPO_ID'  variable='retorno.GRUPO_ID'  null='yes'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Grupo inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere um novo grupo de celulares (PRIVATE)
	-- guto 22/04/2006 12:01:16 - CRIADO
	--->
	<cffunction name='ins_grupo_private' displayname='Insere um novo grupo de celulares' access='remote' returntype='Struct' output='true'>;
		<cfargument name='DESCRICAO' required='yes'>
			<cfstoredproc procedure='kmm_sms.pkg_controle_sms.prc_ins_grupo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
				<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_GRUPO_ID'  variable='retorno.GRUPO_ID'  null='yes'>
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Grupo inserido com sucesso!')>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Altera um novo grupo de celulares
	-- guto 22/04/2006 12:10:18 - CRIADO
	--->
	<cffunction name='upd_grupo' displayname='Altera um novo grupo de celulares' access='remote' returntype='Struct' output='true'>;
		<cfargument name='GRUPO_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm_sms.pkg_controle_sms.prc_alt_grupo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_GRUPO_ID'  value='#arguments.GRUPO_ID#'  null='#iif(len(trim(arguments.GRUPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Grupo alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Exclui um grupo de celulares
	-- guto 22/04/2006 12:11:21 - CRIADO
	--->
	<cffunction name='del_grupo' displayname='Exclui um grupo de celulares' access='remote' returntype='Struct' output='true'>;
		<cfargument name='GRUPO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm_sms.pkg_controle_sms.prc_del_grupo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_GRUPO_ID'  value='#arguments.GRUPO_ID#'  null='#iif(len(trim(arguments.GRUPO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Grupo excludo com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Insere um novo movel no sistema, (celular, palm, poz)
	-- guto 22/04/2006 14:55:21 - CRIADO
	--->
	<cffunction name='ins_movel' displayname='Insere um novo movel no sistema, (celular, palm, poz)' access='remote' returntype='Struct' output='true'>;
		<cfargument name='DDD' required='yes'>
		<cfargument name='NUMERO' required='yes'>
		<cfargument name='OPERADORA_ID' required='yes'>
		<cfargument name='GRUPO_ID' required='yes'>
		<cfargument name='PROPRIETARIO' required='yes'>
		<cfargument name='LISTA_ATRIBUTOS' required='no' default="">
		<cftry>			
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm_sms.pkg_controle_sms.prc_ins_movel' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DDD'  value='#arguments.DDD#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUMERO'  value='#arguments.NUMERO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OPERADORA_ID'  value='#arguments.OPERADORA_ID#'  null='#iif(len(trim(arguments.OPERADORA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_GRUPO_ID'  value='#arguments.GRUPO_ID#'  null='#iif(len(trim(arguments.GRUPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PROPRIETARIO'  value='#arguments.PROPRIETARIO#' >
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOVEL_ID'  variable='retorno.MOVEL_ID'  null='yes'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Celular inserido com sucesso!')>
				
				<cfif Len(Trim(arguments.LISTA_ATRIBUTOS))>
					<cfloop index="i" list="#arguments.LISTA_ATRIBUTOS#" delimiters=",">
						<cfset valor = arguments['atributo#i#']>
						<cfstoredproc procedure='kmm_sms.pkg_controle_sms.prc_set_atributo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
							<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOVEL_ID'  value='#retorno.MOVEL_ID#'>
							<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATRIBUTO_ID'  value='#i#'>
							<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_VALOR'  value='#Trim(valor)#' >
						</cfstoredproc>
					</cfloop>
				</cfif>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Altera os dados do movel
	-- guto 22/04/2006 14:56:54 - CRIADO
	--->
	<cffunction name='upd_movel' displayname='Altera os dados do movel' access='remote' returntype='Struct' output='true'>;
		<cfargument name='MOVEL_ID' required='yes'>
		<cfargument name='DDD' required='yes'>
		<cfargument name='NUMERO' required='yes'>
		<cfargument name='OPERADORA_ID' required='yes'>
		<cfargument name='GRUPO_ID' required='yes'>
		<cfargument name='PROPRIETARIO' required='yes'>
		<cfargument name='LISTA_ATRIBUTOS' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm_sms.pkg_controle_sms.prc_alt_movel' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOVEL_ID'  value='#arguments.MOVEL_ID#'  null='#iif(len(trim(arguments.MOVEL_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DDD'  value='#arguments.DDD#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUMERO'  value='#arguments.NUMERO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OPERADORA_ID'  value='#arguments.OPERADORA_ID#'  null='#iif(len(trim(arguments.OPERADORA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_GRUPO_ID'  value='#arguments.GRUPO_ID#'  null='#iif(len(trim(arguments.GRUPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PROPRIETARIO'  value='#arguments.PROPRIETARIO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Celular alterado com sucesso!')>

				<cfif Len(Trim(arguments.LISTA_ATRIBUTOS))>
					<cfloop index="i" list="#arguments.LISTA_ATRIBUTOS#" delimiters=",">
						<cfset valor = arguments['atributo#i#']>
						<cfstoredproc procedure='kmm_sms.pkg_controle_sms.prc_set_atributo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
							<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOVEL_ID'  value='#arguments.MOVEL_ID#'>
							<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATRIBUTO_ID'  value='#i#'>
							<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_VALOR'  value='#Trim(valor)#' >
						</cfstoredproc>
					</cfloop>
				</cfif>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Exlui movel do sistema
	-- guto 22/04/2006 14:57:54 - CRIADO
	--->
	<cffunction name='del_movel' displayname='Exlui movel do sistema' access='remote' returntype='Struct' output='true'>;
		<cfargument name='MOVEL_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm_sms.pkg_controle_sms.prc_del_movel' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOVEL_ID'  value='#arguments.MOVEL_ID#'  null='#iif(len(trim(arguments.MOVEL_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Celular excludo com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Insere nova conta para o usuario
	-- guto 25/04/2006 10:36:40 - CRIADO
	--->
	<cffunction name='ins_conta' displayname='Insere nova conta para o usuario' access='remote' returntype='Struct' output='true'>;
		<cfargument name='COD_PESSOA_CLIENTE' required='yes'>
		<cfargument name='COD_CONTA' required='yes'>
		<cfargument name='OPERADORA_ID' required='yes'>
		<cfargument name='USUARIO' required='yes'>
		<cfargument name='SENHA' required='yes'>
		<cfargument name='NUM_MENSAGENS_MES' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm_sms.pkg_controle_sms.prc_ins_conta' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_CLIENTE'  value='#arguments.COD_PESSOA_CLIENTE#'  null='#iif(len(trim(arguments.COD_PESSOA_CLIENTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CONTA'  value='#arguments.COD_CONTA#'  null='#iif(len(trim(arguments.COD_CONTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OPERADORA_ID'  value='#arguments.OPERADORA_ID#'  null='#iif(len(trim(arguments.OPERADORA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_USUARIO'  value='#arguments.USUARIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SENHA'  value='#arguments.SENHA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_MENSAGENS_MES'  value='#arguments.NUM_MENSAGENS_MES#'  null='#iif(len(trim(arguments.NUM_MENSAGENS_MES)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Conta inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Altera conta do cliente
	-- guto 25/04/2006 10:38:12 - CRIADO
	--->
	<cffunction name='upd_conta' displayname='Altera conta do cliente' access='remote' returntype='Struct' output='true'>;
		<cfargument name='COD_PESSOA_CLIENTE' required='yes'>
		<cfargument name='COD_CONTA' required='yes'>
		<cfargument name='OPERADORA_ID' required='yes'>
		<cfargument name='USUARIO' required='yes'>
		<cfargument name='SENHA' required='yes'>
		<cfargument name='NUM_MENSAGENS_MES' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm_sms.pkg_controle_sms.prc_alt_conta' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_CLIENTE'  value='#arguments.COD_PESSOA_CLIENTE#'  null='#iif(len(trim(arguments.COD_PESSOA_CLIENTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CONTA'  value='#arguments.COD_CONTA#'  null='#iif(len(trim(arguments.COD_CONTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OPERADORA_ID'  value='#arguments.OPERADORA_ID#'  null='#iif(len(trim(arguments.OPERADORA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_USUARIO'  value='#arguments.USUARIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SENHA'  value='#arguments.SENHA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_MENSAGENS_MES'  value='#arguments.NUM_MENSAGENS_MES#'  null='#iif(len(trim(arguments.NUM_MENSAGENS_MES)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Conta alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Exclui conta do cliente
	-- guto 25/04/2006 10:40:28 - CRIADO
	--->
	<cffunction name='del_conta' displayname='Exclui conta do cliente' access='remote' returntype='Struct' output='true'>;
		<cfargument name='COD_PESSOA_CLIENTE' required='yes'>
		<cfargument name='COD_CONTA' required='yes'>
		<cfargument name='OPERADORA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='kmm_sms.pkg_controle_sms.prc_del_conta' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_CLIENTE'  value='#arguments.COD_PESSOA_CLIENTE#'  null='#iif(len(trim(arguments.COD_PESSOA_CLIENTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CONTA'  value='#arguments.COD_CONTA#'  null='#iif(len(trim(arguments.COD_CONTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OPERADORA_ID'  value='#arguments.OPERADORA_ID#'  null='#iif(len(trim(arguments.OPERADORA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Conta excluda com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Envia mensagem para CELULAR
	-- guto 27/04/2006 08:54:42 - CRIADO
	--->
	<cffunction name='envia_mensagem' displayname='Envia mensagem para CELULAR' access='remote' returntype='Struct' output='true'>;
		<cfargument name='MOVEL_ID' required='yes'>
		<cfargument name='TEXTO' required='yes'>
		<cfargument name='DATA_ENVIO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfloop list="#arguments.MOVEL_ID#" index="i" delimiters=",">
					<cfstoredproc procedure='kmm_sms.pkg_sms.prc_envio_mensagem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CONTA'  null="yes">
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOVEL_ID'  value='#i#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TEXTO'  value='#arguments.TEXTO#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_ENVIO'  value='#arguments.DATA_ENVIO#' >
						<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MENSAGEM_ID'  variable='retorno.MENSAGEM_ID'  null='yes'>
					</cfstoredproc>
				</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Mensagem enviada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Insere um novo movel no sistema, (celular, palm, poz) a partir de um arquivo TXT/CSV
	-- guto 22/04/2006 14:55:21 - CRIADO
	--->
	<cffunction name='importa_movel' displayname='Insere um novo movel no sistema, (celular, palm, poz)' access='remote' returntype='Struct' output='false'>
		<cftry>
			<cftransaction action='begin'>
				<cfscript>
					v_movel_id     = this.ListaToArray (lista = arguments, variavel = "MOVEL_ID_CELULARES");
					v_ddd 	       = this.ListaToArray (lista = arguments, variavel = "DDD_CELULARES");
					v_numero       = this.ListaToArray (lista = arguments, variavel = "NUMERO_CELULARES");
					v_proprietario = this.ListaToArray (lista = arguments, variavel = "PROPRIETARIO_CELULARES");
					v_grupo_id     = this.ListaToArray (lista = arguments, variavel = "GRUPO_ID_CELULARES");
					v_grupo        = this.ListaToArray (lista = arguments, variavel = "GRUPO_CELULARES");
					v_operadora_id = this.ListaToArray (lista = arguments, variavel = "OPERADORA_ID_CELULARES");
				</cfscript>

				<cfloop from="1" to="#ArrayLen(v_movel_id)#" index="count">
					<cfif not Len(Trim(v_grupo_id[count]))>
						<cfscript>
							set_grupo = this.ins_grupo_private(descricao = v_grupo[count]);
							v_grupo_id[count] = set_grupo.GRUPO_ID;
						</cfscript>
					</cfif>
					<cfstoredproc procedure='kmm_sms.pkg_controle_sms.prc_ins_movel' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DDD'  value='#v_ddd[count]#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUMERO'  value='#v_numero[count]#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OPERADORA_ID'  value='#v_operadora_id[count]#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_GRUPO_ID'  value='#v_grupo_id[count]#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PROPRIETARIO'  value='#v_proprietario[count]#' >
						<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOVEL_ID'  variable='retorno.MOVEL_ID' value="#v_movel_id[count]#" null='#iif(len(trim(v_movel_id[count])), de('no'), de('yes'))#'>
					</cfstoredproc>
				</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Celular inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>		
</cfcomponent>