<cfcomponent extends="_transportes.funcoes.cfc_init">
	<cftry>
		<!--- delete na tabela de acesso corrente --->
		<cfquery datasource="#this.dsn#" username="#this.usuario#" password="#this.senha#">
			delete from kss.pessoa_usuario_acesso_cur c
			 where c.usuario = user
		</cfquery>
		<!--- insert na tabela de acesso corrente --->
		<cfquery datasource="#this.dsn#" username="#this.usuario#" password="#this.senha#">
			insert into kss.pessoa_usuario_acesso_cur
				 select cod_pessoa, user 
				   from kss.pessoa_unidade_negocio 
				  where cod_unidade_negocio > 0
					and cod_unidade_negocio is not null
		</cfquery>	
		
		<cfcatch type="any"></cfcatch>
		
	</cftry>	
	
	<!--- 
	-- PROPSITO
	-- Cadastra Contrato
	-- NOTAS EXPLICATIVAS
	-- JEFFERSON 13/11/2003 - criado
	--->			
	<cffunction name="ins_contrato" displayname="Insere Contrato" access="public" returntype="Struct" output="true">
		<cfargument name="num_serie" required="true" />
		<cfargument name="data_inicio_contrato" required="true" />
		<cfargument name="data_fim_contrato" required="true" />
		<cftry>
			<cfstoredproc procedure="atualizador.pkg_atualizador.prc_ins_contrato_copia" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam dbvarname="p_num_serie" type="in" 	value="#arguments.num_serie#" cfsqltype="cf_sql_varchar" />
					<cfprocparam dbvarname="p_data_inicio_contrato" type="in" value="#arguments.data_inicio_contrato#" cfsqltype="cf_sql_varchar" />
					<cfprocparam dbvarname="p_data_fim_contrato" type="in" value="#arguments.data_fim_contrato#" cfsqltype="cf_sql_varchar" />
			</cfstoredproc>							
			<cfset retorno.erro = False />
			<cfset retorno.mensagem = 'Contrato inserido com sucesso!' />
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>				 
		</cftry>
		<cfreturn retorno />		
	</cffunction> 	 	

	<!--- 
	-- PROPSITO
	-- Atualiza Data do Contrato
	-- JEFFERSON          13/11/2003 - criado
	--->			
	<cffunction name="upd_contrato" displayname="Atualiza Contrato" access="public" returntype="Struct" output="true">
		<cfargument name="num_serie" required="true" />
		<cfargument name="data_inicio_contrato" required="true" />
		<cfargument name="data_fim_contrato" required="true" />
		<cftry>
			<cfstoredproc procedure="atualizador.pkg_atualizador.prc_upd_contrato_copia" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				<cfprocparam dbvarname="p_num_serie" type="in" value="#arguments.num_serie#" cfsqltype="cf_sql_varchar" />
				<cfprocparam dbvarname="p_data_inicio_contrato" type="in" value="#arguments.data_inicio_contrato#" cfsqltype="cf_sql_varchar" />
				<cfprocparam dbvarname="p_data_fim_contrato" type="in" 	value="#arguments.data_fim_contrato#" cfsqltype="cf_sql_varchar" />
			</cfstoredproc>							
			<cfset retorno.mensagem = 'Contrato alterado com sucesso!'>
			<cfset retorno.erro     = false >	
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction> 

	<!--- 
	-- PROPSITO
	-- Cadastra dados Cpias do Produito
	-- JEFFERSON          13/11/2003 - criado
	--->			
	<cffunction name="ins_copia" displayname="Registra Cpia do Software" access="remote" returntype="Struct" output="true">
		<cfargument name="num_serie" required="true"  displayname="Nmero de Srie" type="string" />				
		<cfargument name="cnpj" required="true"  displayname="CNPJ" type="string" />
		<cfargument name="cod_projeto" required="true" displayname="Cdigo do Projeto" type="numeric" />
		<cfargument name="cod_aplicacao" required="true" displayname="Cdigo da Aplicao" type="string" />
		<cfargument name="data_instalacao" required="true" displayname="Data Instalao da Cpia" type="date" />				
		<cfargument name="limite_maquina" required="true" displayname="Limite de Mquinas" type="numeric" />				
		<cfargument name="atualizacao" required="true" displayname="Flag Atualizao" type="numeric" default="0" />				
		<cfargument name="direito_uso" required="true" displayname="Flag Direito Uso" type="numeric" default="0" />								
		<cfargument name="usuario"	required="true" displayname="Usurio Responsvel" type="string" />				
		<cfargument name="senha" required="true" displayname="Senha do Responsvel" type="string" />				
		<cfargument name="usuario_adm"	required="true" displayname="Usurio Administrador" type="string" />				
		<cfargument name="senha_adm" required="true" displayname="Senha do Administrador" type="string" />				
		<cfargument name="cadastra_contrato"    	required="false"   displayname="Insere contrato" 		type="string" />				
		<cfargument name="data_inicio_contrato"     required="false"   displayname="Data Incio do Contrato" 	type="string" />				
		<cfargument name="data_fim_contrato"    	required="false"   displayname="Data Fim do Contrato" 		type="string" />				
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="atualizador.pkg_atualizador.prc_ins_copia" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
						<cfprocparam dbvarname="p_num_serie" type="in" value="#arguments.num_serie#" cfsqltype="cf_sql_varchar" />
						<cfprocparam dbvarname="p_cnpj" type="in" value="#arguments.cnpj#" cfsqltype="cfc_sql_varchar" />
						<cfprocparam dbvarname="p_cod_projeto" type="in" value="#arguments.cod_projeto#" cfsqltype="cf_sql_integer" />
						<cfprocparam dbvarname="p_cod_aplicacao" type="in" value="#arguments.cod_aplicacao#" cfsqltype="cf_sql_varchar" />
						<cfprocparam dbvarname="p_data_instalacao" type="in" value="#arguments.data_instalacao#" cfsqltype="cf_sql_varchar" />
						<cfprocparam dbvarname="p_limite_maquina" type="in" value="#arguments.limite_maquina#" cfsqltype="cf_sql_integer" />
						<cfprocparam dbvarname="p_atualizacao" type="in" value="#arguments.atualizacao#" cfsqltype="cf_sql_integer" />
						<cfprocparam dbvarname="p_direito_uso" type="in" value="#arguments.direito_uso#" cfsqltype="cf_sql_integer" />
						<cfprocparam dbvarname="p_usuario" type="in" value="#arguments.usuario#" cfsqltype="cf_sql_varchar" />
						<cfprocparam dbvarname="p_senha" type="in" value="#arguments.senha#" cfsqltype="cf_sql_varchar" />
						<cfprocparam dbvarname="p_usuario_adm" type="in" value="#arguments.usuario_adm#" cfsqltype="cf_sql_varchar" />
						<cfprocparam dbvarname="p_senha_adm" type="in" value="#arguments.senha_adm#" cfsqltype="cf_sql_varchar" />
				</cfstoredproc>	
				<cfset retorno.erro = false>						
				<cfset retorno.mensagem	= ' O Servi' & chr( 231 ) &'o  ' & arguments.num_serie & ' foi cadastrado com sucesso !' />
				<cfscript>
					 if ( StructKeyExists( arguments, 'cadastra_contrato' ) and Len(Trim(arguments.cadastra_contrato))
					  and StructKeyExists( arguments, 'data_inicio_contrato' ) and IsDate(arguments.data_inicio_contrato)
					  and StructKeyExists( arguments, 'data_fim_contrato' ) and IsDate(arguments.data_fim_contrato) ) {
							retorno.contrato = this.ins_contrato( ArgumentCollection = Arguments );
							retorno.mensagem = 'A C' & chr( 243 ) & 'pia e o Contrato foram registrados com sucesso !';
					 } else { 
						retorno.mensagem	= 'A C' & chr( 243 ) & 'pia foi registrada com sucesso !';
					 }
				</cfscript>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback" />
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>	
		<cfreturn retorno/>
	</cffunction>
 
	<!--- 
	-- PROPSITO
	-- Atualiza dados da Cpias do Produito
	-- JEFFERSON          13/11/2003 - criado
	--->			
	<cffunction name="upd_copia" displayname="Atualiza Cpias do Software" access="remote" returntype="Struct" output="true">
		<cfargument name="num_serie" required="true" displayname="Nmero de Srie" type="string" />				
		<cfargument name="cnpj" required="true" displayname="CNPJ" type="string" />
		<cfargument name="cod_projeto" required="true" displayname="Cdigo do Projeto" type="numeric" />
		<cfargument name="cod_aplicacao" required="true" displayname="Cdigo da Aplicao" type="string" />
		<cfargument name="data_instalacao" required="true" displayname="Data Instalao da Cpia" type="date" />				
		<cfargument name="limite_maquina" required="true" displayname="Limite de Mquinas" type="numeric" />				
		<cfargument name="atualizacao" required="true" displayname="Flag Atualizao" type="numeric" default="0" />				
		<cfargument name="direito_uso" required="true" displayname="Flag Direito Uso" type="numeric" default="0" />								
		<cfargument name="usuario"	required="true" displayname="Usurio Responsvel" type="string" />				
		<cfargument name="senha" required="true" displayname="Senha do Responsvel" type="string" />				
		<cfargument name="usuario_adm"	required="true" displayname="Usurio Administrador" type="string" />				
		<cfargument name="senha_adm" required="true" displayname="Senha do Administrador" type="string" />				
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="atualizador.pkg_atualizador.prc_upd_copia" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam dbvarname="p_num_serie" type="in" value="#arguments.num_serie#" cfsqltype="cf_sql_varchar" />
					<cfprocparam dbvarname="p_cod_pessoa" type="in" value="#arguments.cnpj#" cfsqltype="cf_sql_varchar" />
					<cfprocparam dbvarname="p_cod_projeto" type="in" value="#arguments.cod_projeto#" cfsqltype="cf_sql_integer" />
					<cfprocparam dbvarname="p_cod_aplicacao" type="in" value="#arguments.cod_aplicacao#" cfsqltype="cf_sql_varchar" />
					<cfprocparam dbvarname="p_data_instalacao" type="in" value="#arguments.data_instalacao#" cfsqltype="cf_sql_date" />
					<cfprocparam dbvarname="p_limite_maquina" type="in" value="#arguments.limite_maquina#" cfsqltype="cf_sql_integer" />
					<cfprocparam dbvarname="p_atualizacao" type="in" value="#arguments.atualizacao#" cfsqltype="cf_sql_integer" />
					<cfprocparam dbvarname="p_direito_uso" type="in" value="#arguments.direito_uso#" cfsqltype="cf_sql_integer" />
					<cfprocparam dbvarname="p_usuario" type="in" value="#arguments.usuario#" cfsqltype="cf_sql_varchar" />
					<cfprocparam dbvarname="p_senha" type="in" value="#arguments.senha#" cfsqltype="cf_sql_varchar" />
					<cfprocparam dbvarname="p_usuario_adm" type="in" value="#arguments.usuario_adm#" cfsqltype="cf_sql_varchar" />
					<cfprocparam dbvarname="p_senha_adm" type="in" value="#arguments.senha_adm#" cfsqltype="cf_sql_varchar" />
				</cfstoredproc>
			</cftransaction>
			<cfset retorno.erro = false />
			<cfset retorno.mensagem = 'A Atualiza' & chr( 231 )& chr( 227) & 'o de da c' & chr( 243 ) & 'pia foi realizado com sucesso !' />
			<cfcatch type="database">
				<cftransaction action="rollback" />
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>	
		<cfreturn retorno/>
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Atualiza dados da Cpias do Produito
	-- JEFFERSON          13/11/2003 - criado
	--->			
	<cffunction name="ins_registro_aplicacao" displayname="Registrar produto" access="remote" returntype="struct" output="true">
		<cfargument name="cod_projeto" required="true" displayname="Cdigo do Projeto" type="numeric" />
		<cfargument name="cod_aplicacao" required="true" displayname="Cdigo da Aplicao" type="string" />
		<cfargument name="produto" required="true" displayname="Nome do Produto" type="string" />				
		<cfargument name="site_produto" required="false"   displayname="Site do Produto" type="string"/>					
		<cfargument name="ativo" required="true" displayname="Ativo/Inativo" type="numeric"/>							
		<cftry>
			<cfstoredproc procedure="atualizador.pkg_atualizador.prc_ins_registro_aplicacao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				<cfprocparam dbvarname="p_cod_projeto" type="in" value="#arguments.cod_projeto#" cfsqltype="cf_sql_integer" />
				<cfprocparam dbvarname="p_cod_aplicacao" type="in" value="#arguments.cod_aplicacao#" cfsqltype="cf_sql_varchar" />
				<cfprocparam dbvarname="p_produto" type="in" value="#arguments.produto#" cfsqltype="cf_sql_varchar" />
				<cfprocparam dbvarname="p_site_produto" type="in" value="#arguments.site_produto#" cfsqltype="cf_sql_varchar"  null="#iif( StructKeyExists( arguments, 'site_produto') and Len(Trim( arguments['site_produto'] )), de('no'),de('yes'))#"/>
				<cfprocparam dbvarname="p_ativo" type="in" value="#val( arguments.ativo )#" cfsqltype="cf_sql_integer" />
			</cfstoredproc>							
			<cfset retorno.erro = false />
			<cfset retorno.mensagem = 'O Produto ' & arguments.produto  & ' foi registrado com sucesso !'/>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>	
		 <cfreturn retorno/>
	</cffunction>				
	
	<!--- 
	-- PROPSITO
	-- Atualiza Registro da Aplicao ( para que permita ser atualizada ) ( Registro do Produto )
	-- JEFFERSON          13/11/2003 - criado
	--->			
	<cffunction name="upd_registro_aplicacao" displayname="Atualiza Registro de Aplicao" access="remote" returntype="Struct" output="true">
		<cfargument name="cod_projeto" required="true" displayname="Cdigo do Projeto" type="numeric" />
		<cfargument name="cod_aplicacao" required="true" displayname="Cdigo da Aplicao" type="string" />
		<cfargument name="produto" required="true" displayname="Nome do Produto" type="string" />				
		<cfargument name="ativo" required="true" displayname="Ativo/Inativo" type="numeric"/>							
		<cfargument name="mensagem" required="false" displayname="Mensagem" type="string"/>							
		<cfargument name="site_produto" required="false" displayname="Site do Produto" type="string"/>				
		<cftry>
			<cfstoredproc procedure="atualizador.pkg_atualizador.prc_upd_registro_aplicacao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam dbvarname="p_cod_projeto" type="in" value="#val( arguments.cod_projeto )#"	cfsqltype="cf_sql_integer" />
					<cfprocparam dbvarname="p_cod_aplicacao" type="in" value="#arguments.cod_aplicacao#" cfsqltype="cf_sql_varchar" />
					<cfprocparam dbvarname="p_produto" type="in" value="#arguments.produto#" cfsqltype="cf_sql_varchar" />
					<cfprocparam dbvarname="p_site_produto" type="in" value="#arguments.site_produto#" cfsqltype="cf_sql_varchar" null="#iif( StructKeyExists( arguments, 'site_produto') and Len(Trim( arguments.site_produto )), de('no'),de('yes'))#"/>
					<cfprocparam dbvarname="p_ativo" type="in" value="#val( arguments.ativo )#" cfsqltype="cf_sql_integer" />
					<cfprocparam dbvarname="p_mensagem" type="in" value="#arguments.mensagem#" cfsqltype="cf_sql_varchar" null="#iif( StructKeyExists( arguments, 'mensagem') and Len(Trim( arguments.mensagem )), de('no'),de('yes'))#"/>
			</cfstoredproc>							
			<cfset retorno.erro = false />
			<cfset retorno.mensagem = 'O Produto ' & arguments.produto & ' foi atualizado com sucesso !'/>
			<cfcatch type="database">
					<cfset retorno.erro = true>
					<cfset retorno.mensagem = cfcatch>
					<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>	
		<cfreturn retorno/>
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Cadastra Mquina
	-- JEFFERSON          13/11/2003 - criado
	--->			
	<cffunction name="ins_maquina" displayname="Cadastra Mquina" access="public" returntype="Struct" output="true">
		<cfargument name="num_serie" required="yes" displayname="Nmero de Srie" type="string" />				
		<cfargument name="maquina" required="yes" displayname="Nome da Mquina" type="string" />				
		<cfargument name="descricao" required="yes" displayname="Descrio" type="string" />				
		<cfargument name="situacao" required="yes" displayname="Situao da mquina" type="numeric" />				
		<cftry>
			<cfstoredproc procedure="atualizador.pkg_atualizador.prc_ins_maquina_copia" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam dbvarname="p_num_serie" type="in" value="#arguments.num_serie#" cfsqltype="cf_sql_varchar" />
					<cfprocparam dbvarname="p_maquina" type="in" value="#arguments.maquina#" cfsqltype="cf_sql_varchar" />
					<cfprocparam dbvarname="p_descricao" type="in" value="#arguments.descricao#" cfsqltype="cf_sql_varchar" />
					<cfprocparam dbvarname="p_situacao" type="in" value="#arguments.situacao#" cfsqltype="cf_sql_integer" />
			</cfstoredproc>							
			<cfset retorno.erro = False />
			<cfset retorno.mensagem = 'A M' & chr( 225 ) & 'quina ' & arguments.descricao & ' foi cadastrada com sucesso ! '/>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>				 
		</cftry>
		<cfreturn retorno />		
	</cffunction>			

	<!--- 
	-- PROPSITO
	-- Atualiza Mquina
	-- JEFFERSON          13/11/2003 - criado
	--->			
	<cffunction name="upd_maquina" displayname="Atualiza Mquina" access="public" returntype="Struct" output="true">
		<cfargument name="num_serie" required="true" displayname="Nmero de Srie" type="string" />				
		<cfargument name="maquina" required="true" displayname="Nome da Mquina" type="string" />				
		<cfargument name="descricao" required="true" displayname="Descrio" type="string" />
		<cfargument name="situacao" required="true" displayname="Situao da Mquina" type="string" />				
		<cftry>
			<cfstoredproc procedure="atualizador.pkg_atualizador.prc_upd_maquina_copia" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam dbvarname="p_num_serie" type="in" value="#arguments.num_serie#" cfsqltype="cf_sql_varchar" />
					<cfprocparam dbvarname="p_maquina" type="in" value="#arguments.maquina#" cfsqltype="cf_sql_varchar" />
					<cfprocparam dbvarname="p_descricao" type="in" value="#arguments.descricao#" cfsqltype="cf_sql_varchar" />
					<cfprocparam dbvarname="p_situacao" type="in" value="#arguments.situacao#" cfsqltype="cf_sql_integer" />
			</cfstoredproc>							
			<cfset retorno.erro = False />
			<cfset retorno.mensagem = 'A M'& chr( 225 ) &'quina ' & iif( Find(3, arguments.situacao), de( arguments.descricao ), de(' foi Atualizada ') ) & ' com sucesso ! '/>
			<cfcatch type="database">
					<cfset retorno.erro = true>
					<cfset retorno.mensagem = cfcatch>
					<cfset request.erro = cfcatch>
			</cfcatch>				 
		</cftry>
		<cfreturn retorno />		
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Cadastra Servios
	-- JEFFERSON          03/08/2004 - criado
	--->			
	<cffunction name="ins_servico" displayname="Cadastra Servio" output="true" returntype="Struct">
		<cfargument name="descricao" required="true" displayname="Descrio do Servio" type="string"/>
		<cfargument name="porta" required="true" displayname="Nmero da Porta"  type="numeric"/>	
		<cfargument name="nome_servidor" required="true" displayname="Nome do Servidor" type="string"/>
		<cfargument name="endereco_ip" required="true" displayname="Endereo de Ip do servidor" type="string"/>
		<cfargument name="path_servidor" required="true" displayname="Caminho Absoluto Arquivo Auxiliar de Regras" type="string"/>
		<cfargument name="servico_ativo" required="true" displayname="Flag Servio Ativo/Inativo" type="numeric" default="1"/>	
		<cftry>
			<cfstoredproc procedure="atualizador.pkg_controle_conexao.prc_ins_servico" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				<cfprocparam dbvarname="p_servico_id" type="in" 	cfsqltype="cf_sql_integer" null="yes" />
				<cfprocparam dbvarname="p_descricao" type="in" 	value="#arguments.descricao#" cfsqltype="cf_sql_varchar" />
				<cfprocparam dbvarname="p_porta" type="in" 	value="#arguments.porta#" cfsqltype="cf_sql_integer" />
				<cfprocparam dbvarname="p_nome_servidor" type="in" 	value="#arguments.nome_servidor#" cfsqltype="cf_sql_varchar" />
				<cfprocparam dbvarname="p_endereco_ip" type="in" 	value="#arguments.endereco_ip#" cfsqltype="cf_sql_varchar" />
				<cfprocparam dbvarname="p_path_servidor" type="in" 	value="#arguments.path_servidor#" cfsqltype="cf_sql_varchar" />
				<cfprocparam dbvarname="p_servico_ativo" type="in" 	value="#arguments.servico_ativo#" cfsqltype="cf_sql_integer" />
			</cfstoredproc>
			<cfset retorno.erro = False />
			<cfset retorno.mensagem	= ' O Servi' & chr( 231 ) &'o  ' & arguments.descricao & ' foi cadastrado com sucesso !' />
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />		
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Atualiza Servios
	-- JEFFERSON          03/08/2004 - criado
	--->			
	<cffunction name="upd_servico" displayname="Atualiza Servio" output="true" returntype="Struct">
		<cfargument name="servico_id" required="true" displayname="Nmero do Servio" type="numeric"/>
		<cfargument name="descricao" required="true" displayname="Descrio do Servio" type="string"/>
		<cfargument name="porta" required="true" displayname="Nmero da Porta" type="numeric"/>	
		<cfargument name="nome_servidor" required="true" displayname="Nome do Servidor" type="string"/>
		<cfargument name="endereco_ip" required="true" displayname="Endereo de Ip do servidor" type="string"/>
		<cfargument name="path_servidor" required="true" displayname="Caminho Absoluto Arquivo Auxiliar de Regras" type="string"/>
		<cfargument name="servico_ativo" required="false" displayname="Flag Servio Ativo/Inativo" type="numeric" default="0"/>	
		<cftry>
			<cfstoredproc procedure="atualizador.pkg_controle_conexao.prc_upd_servico" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				<cfprocparam dbvarname="p_servico_id" type="in" value="#arguments.servico_id#" cfsqltype="cf_sql_integer" />
				<cfprocparam dbvarname="p_descricao" type="in" value="#arguments.descricao#" cfsqltype="cf_sql_varchar" />
				<cfprocparam dbvarname="p_porta" type="in" 	value="#arguments.porta#" cfsqltype="cf_sql_integer" />
				<cfprocparam dbvarname="p_nome_servidor" type="in"	value="#arguments.nome_servidor#" cfsqltype="cf_sql_varchar" />
				<cfprocparam dbvarname="p_endereco_ip" type="in" value="#arguments.endereco_ip#" cfsqltype="cf_sql_varchar" />
				<cfprocparam dbvarname="p_path_servidor" type="in" value="#arguments.path_servidor#" cfsqltype="cf_sql_varchar" />
				<cfprocparam dbvarname="p_servico_ativo" type="in" value="#arguments.servico_ativo#" cfsqltype="cf_sql_integer" />
			</cfstoredproc>
			<cfset retorno.erro = False />
			<cfset retorno.mensagem	= ' O Servi' & chr( 231 ) &'o  ' & arguments.descricao & ' foi atualizado com sucesso !' />
			<cfcatch type="database">
					<cfset retorno.erro = true>
					<cfset retorno.mensagem = cfcatch>
					<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />		
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Deleta Servio
	-- JEFFERSON          03/08/2004 - criado
	--->			
	<cffunction name="del_servico" displayname="Cadastra servio" output="true" returntype="Struct">
		<cfargument name="servico_id" required="true" displayname="Nmero do Servio" type="numeric"/>
		<cfargument name="descricao"  required="true" displayname="Descrio do Servio" type="string"/>
		<cftry>
			<cfstoredproc procedure="atualizador.pkg_controle_conexao.prc_del_servico" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				<cfprocparam 	dbvarname="p_servico_id"  	type="in" 	value="#arguments['servico_id']#" 			cfsqltype="cf_sql_integer" />
			</cfstoredproc>
			<cfset retorno.erro = False />
			<cfset retorno.mensagem	= ' O Servi' & chr( 231 ) &'o  ' & arguments.descricao & ' foi exclu' & chr( 237) & 'do com sucesso !' />
			<cfcatch type="database">
					<cfset retorno.erro = true>
					<cfset retorno.mensagem = cfcatch>
					<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />		
	</cffunction>
</cfcomponent>