<!-- KM&M Componentes -->
<cfcomponent displayname="Manipulao da rea de vales" extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPSITO
    -- Inserir cliente de servidor dhcp
    -- LEOPOLDOS 30/06/2010 11:41:14 - CRIADO
    --->
    <cffunction name='ins_cliente_dhcp' displayname='Inserir cliente de servidor dhcp' access='remote' returntype='Struct' output='true'>
        <cfargument name='DESCRICAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='infraestrutura.pkg_infraestrutura.prc_ins_cliente_dhcp' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CLIENTE_ID' variable='retorno.CLIENTE_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
                <cfdump var="#retorno#">
                <cfscript>
					v_cliente_ip_id	 = this.ListaToArray(lista = arguments, variavel = 'CLIENTE_IP_ID');
                    v_cod_servidor 	 = this.ListaToArray(lista = arguments, variavel = 'COD_SERVIDOR');
					v_mac_address 	 = this.ListaToArray(lista = arguments, variavel = 'MAC_ADDRESS');
					v_ip        	 = this.ListaToArray(lista = arguments, variavel = 'IP');
                </cfscript>
                <cfloop from="1" to="#ArrayLen(v_cliente_ip_id)#" index="count">
                    <cfscript>
                        ret = this.ins_cliente_dhcp_ip(cod_servidor = v_cod_servidor[count]
													  ,cliente_id	= retorno.CLIENTE_ID
													  ,mac_address 	= v_mac_address[count]
													  ,ip			= v_ip[count]);
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>                
                
                
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Cliente inserido com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Inserir vinculo entre mac address e ip
	-- LEOPOLDOS 30/06/2010 11:45:31 - CRIADO
	--->
	<cffunction name='ins_cliente_dhcp_ip' displayname='Inserir vinculo entre mac address e ip' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_SERVIDOR' required='yes'>
		<cfargument name='CLIENTE_ID' required='yes'>
		<cfargument name='MAC_ADDRESS' required='yes'>
		<cfargument name='IP' required='yes'>
		<cftry>
            <cfstoredproc procedure='infraestrutura.pkg_infraestrutura.prc_ins_cliente_dhcp_ip' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CLIENTE_IP_ID' variable='retorno.CLIENTE_IP_ID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_SERVIDOR'  value='#arguments.COD_SERVIDOR#'  null='#iif(len(trim(arguments.COD_SERVIDOR)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CLIENTE_ID'  value='#arguments.CLIENTE_ID#'  null='#iif(len(trim(arguments.CLIENTE_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MAC_ADDRESS'  value='#arguments.MAC_ADDRESS#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_IP'  value='#arguments.IP#' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Vinculo inserido com sucesso.')>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Atualiza cliente de servidor dhcp
	-- LEOPOLDOS 30/06/2010 11:52:10 - CRIADO
	--->
	<cffunction name='upd_cliente_dhcp' displayname='Atualiza cliente de servidor dhcp' access='remote' returntype='Struct' output='true'>
		<cfargument name='CLIENTE_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='infraestrutura.pkg_infraestrutura.prc_alt_cliente_dhcp' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CLIENTE_ID'  value='#arguments.CLIENTE_ID#'  null='#iif(len(trim(arguments.CLIENTE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
				</cfstoredproc>
                
                <cfscript>
					v_cliente_ip_id	 = this.ListaToArray(lista = arguments, variavel = 'CLIENTE_IP_ID_CLIENTE_DHCP_IP');
                    v_cod_servidor 	 = this.ListaToArray(lista = arguments, variavel = 'COD_SERVIDOR_CLIENTE_DHCP_IP');
					v_mac_address 	 = this.ListaToArray(lista = arguments, variavel = 'MAC_ADDRESS_CLIENTE_DHCP_IP');
					v_ip        	 = this.ListaToArray(lista = arguments, variavel = 'IP_CLIENTE_DHCP_IP');
					v_excluir	     = this.ListDiff(lista1 = arguments.lista_deleted_CLIENTE_DHCP_IP, lista2 = ArrayToList(v_cliente_ip_id));
                </cfscript>
                
                <cfloop list="#v_excluir#" delimiters="," index="c_id">
                    <cfscript>
                        ret = this.del_cliente_dhcp_ip(cliente_ip_id = c_id);
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>
                
                <cfloop from="1" to="#ArrayLen(v_cliente_ip_id)#" index="count_ip">
                    <cfscript>
						if(Not Len(Trim(v_cliente_ip_id[count_ip]))) {
							ret = this.ins_cliente_dhcp_ip(cod_servidor = v_cod_servidor[count_ip]
														  ,cliente_id	= arguments.CLIENTE_ID
														  ,mac_address 	= v_mac_address[count_ip]
														  ,ip			= v_ip[count_ip]);
						}else{
							ret = this.upd_cliente_dhcp_ip(cliente_ip_id = v_cliente_ip_id[count_ip]
														  ,cod_servidor  = v_cod_servidor[count_ip]
														  ,cliente_id	 = arguments.CLIENTE_ID
														  ,mac_address 	 = v_mac_address[count_ip]
														  ,ip			 = v_ip[count_ip]);
						}
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>    
                
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Atualizado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Apagar cliente de servidor dhcp
	-- LEOPOLDOS 30/06/2010 11:53:59 - CRIADO
	--->
	<cffunction name='del_cliente_dhcp' displayname='Apagar cliente de servidor dhcp' access='remote' returntype='Struct' output='true'>
		<cfargument name='CLIENTE_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='infraestrutura.pkg_infraestrutura.prc_del_cliente_dhcp' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CLIENTE_ID'  value='#arguments.CLIENTE_ID#'  null='#iif(len(trim(arguments.CLIENTE_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Apagado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Apagar vinculo entre mac address e ip
	-- LEOPOLDOS 30/06/2010 11:53:15 - CRIADO
	--->
	<cffunction name='del_cliente_dhcp_ip' displayname='Apagar vinculo entre mac address e ip' access='remote' returntype='Struct' output='true'>
		<cfargument name='CLIENTE_IP_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='infraestrutura.pkg_infraestrutura.prc_del_cliente_dhcp_ip' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CLIENTE_IP_ID'  value='#arguments.CLIENTE_IP_ID#'  null='#iif(len(trim(arguments.CLIENTE_IP_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Apagado com sucesso.')>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Atualiza vinculo mac address e ip
	-- LEOPOLDOS 30/06/2010 11:59:21 - CRIADO
	--->
	<cffunction name='upd_cliente_dhcp_ip' displayname='Atualiza vinculo mac address e ip' access='remote' returntype='Struct' output='true'>
		<cfargument name='CLIENTE_IP_ID' required='yes'>
		<cfargument name='COD_SERVIDOR' required='yes'>
		<cfargument name='CLIENTE_ID' required='yes'>
		<cfargument name='MAC_ADDRESS' required='yes'>
		<cfargument name='IP' required='yes'>
		<cftry>
				<cfstoredproc procedure='infraestrutura.pkg_infraestrutura.prc_alt_cliente_dhcp_ip' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CLIENTE_IP_ID'  value='#arguments.CLIENTE_IP_ID#'  null='#iif(len(trim(arguments.CLIENTE_IP_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_SERVIDOR'  value='#arguments.COD_SERVIDOR#'  null='#iif(len(trim(arguments.COD_SERVIDOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CLIENTE_ID'  value='#arguments.CLIENTE_ID#'  null='#iif(len(trim(arguments.CLIENTE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MAC_ADDRESS'  value='#arguments.MAC_ADDRESS#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_IP'  value='#arguments.IP#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Atualizado com sucesso.')>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
</cfcomponent>