<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO
	-- Insere dados adicionais de produtores.
	-- arlen 23/10/2006 11:19:15 - CRIADO
	--->
	<cffunction name='ins_produtor' displayname='Insere dados adicionais de produtores.' access='remote' returntype='Struct' output='true'>
		<cfargument name='AREA_TOTAL' required='no' default="">
		<cfargument name='AREA_CONTRATO' required='no' default="">
		<cfargument name='POSSUI_ARMAZEM' required='no' default="0">
		<cfargument name='COD_PESSOA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='granex.pkg_granex.prc_ins_produtor' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_AREA_TOTAL'  value='#arguments.AREA_TOTAL#'  null='#iif(len(trim(arguments.AREA_TOTAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_AREA_CONTRATO'  value='#arguments.AREA_CONTRATO#'  null='#iif(len(trim(arguments.AREA_CONTRATO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_POSSUI_ARMAZEM'  value='#arguments.POSSUI_ARMAZEM#'  null='#iif(len(trim(arguments.POSSUI_ARMAZEM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type="OUT" cfsqltype="CF_SQL_VARCHAR" variable="rowid">
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Dados de produtores inseridos com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui dados adicionais do produtor.
	-- arlen 20/10/2006 16:27:32 - CRIADO
	--->
	<cffunction name='del_produtor' displayname='Exclui dados adicionais de produtores.' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_PESSOA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='granex.pkg_granex.prc_del_produtor' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
				</cfstoredproc>
						<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Dados de produtores inseridos com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere caractersticas.
	-- arlen 24/10/2006 16:30:47 - CRIADO
	--->
	<cffunction name='ins_atributo' displayname='Insere caractersticas.' access='remote' returntype='Struct' output='true'>
		<cfargument name='NOME' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
		<cfargument name='TIPO_DADO' required='yes'>
		<cfargument name='VISIVEL' required='no' default="0">
		<cfargument name='ATIVO' required='no' default="0">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='granex.pkg_granex.prc_ins_atributo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TIPO_DADO'  value='#arguments.TIPO_DADO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VISIVEL'  value='#arguments.VISIVEL#'  null='#iif(len(trim(arguments.VISIVEL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATIVO'  value='#arguments.ATIVO#'  null='#iif(len(trim(arguments.ATIVO)), de('no'), de('yes'))#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATRIBUTO_ID'  value='#arguments.ATRIBUTO_ID#' variable='retorno.ATRIBUTO_ID'  null='#iif(len(trim(arguments.ATRIBUTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<!--- Insere os itens dos atributos --->
				<cfscript>
					v_valor = this.ListaToArray (lista = arguments, variavel = "VALOR_ATRIBUTO_ITEM");
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_valor)#" index="count">
					<cfscript>
						this.ins_atributo_item(	atributo_id = retorno.atributo_id,
												valor       = v_valor[count]);
					</cfscript>
				</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Caracterstica do produto inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera caractersticas.
	-- arlen 24/10/2006 16:33:08 - CRIADO
	--->
	<cffunction name='alt_atributo' displayname='Altera caractersticas.' access='remote' returntype='Struct' output='true'>
		<cfargument name='ATRIBUTO_ID' required='yes'>
		<cfargument name='NOME' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
		<cfargument name='TIPO_DADO' required='yes'>
		<cfargument name='VISIVEL' required='yes'>
		<cfargument name='ATIVO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='granex.pkg_granex.prc_alt_atributo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATRIBUTO_ID'  value='#arguments.ATRIBUTO_ID#'  null='#iif(len(trim(arguments.ATRIBUTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TIPO_DADO'  value='#arguments.TIPO_DADO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VISIVEL'  value='#arguments.VISIVEL#'  null='#iif(len(trim(arguments.VISIVEL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATIVO'  value='#arguments.ATIVO#'  null='#iif(len(trim(arguments.ATIVO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfscript>
					v_valor_item = this.ListaToArray (lista = arguments, variavel = "VALOR_ATRIBUTO_ITEM");
					v_item_id = this.ListaToArray (lista = arguments, variavel = "ITEM_ID_ATRIBUTO_ITEM");
					v_item_excluir = this.ListDiff(lista1 = arguments.lista_deleted_ATRIBUTO_ITEM, lista2 = ArrayToList(v_item_id));
				</cfscript>
				
				<!--- Exclui os itens dos atributos--->
				<cfloop list="#v_item_excluir#" delimiters="," index="l_item_id">
					<cfscript>
						this.del_atributo_item ( atributo_id = arguments.atributo_id,
											     item_id     = l_item_id);
					</cfscript>
				</cfloop>
				<!--- Insere os itens dos atributos --->
				<cfloop from="1" to="#ArrayLen(v_valor_item)#" index="count">
					<cfscript>
						if(not len(trim(v_item_id[count]))) {
							this.ins_atributo_item(	atributo_id = arguments.atributo_id,
													valor       = v_valor_item[count]);
						}
						else {
							this.alt_atributo_item(	atributo_id = arguments.atributo_id,
													item_id     = v_item_id[count],
													valor       = v_valor_item[count]);
						}
					</cfscript>
				</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Caracterstica do produto alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui caractersticas.
	-- arlen 24/10/2006 16:34:46 - CRIADO
	--->
	<cffunction name='del_atributo' displayname='Exclui caractersticas.' access='remote' returntype='Struct' output='true'>
		<cfargument name='ATRIBUTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='granex.pkg_granex.prc_del_atributo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATRIBUTO_ID'  value='#arguments.ATRIBUTO_ID#'  null='#iif(len(trim(arguments.ATRIBUTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<!--- Exclui items relacionados ao atributo --->
				<cfscript>
				  v_item_id = this.ListaToArray (lista = arguments, variavel = "ITEM_ID_ATRIBUTO_ITEM");
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_item_id)#" index="count">
					<cfscript>
						this.del_atributo_item( atributo_id = arguments.atributo_id,
											item_id = v_item_id[count]);
					</cfscript>			
				</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Caracterstica do produto excluda com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere itens dos atributos
	-- arlen 24/10/2006 16:51:16 - CRIADO
	--->
	<cffunction name='ins_atributo_item' displayname='Insere itens dos atributos.' access='remote' returntype='Struct' output='true'>
		<cfargument name='ATRIBUTO_ID' required='yes'>
		<cfargument name='VALOR' required='yes'>
				<cfstoredproc procedure='granex.pkg_granex.prc_ins_atributo_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATRIBUTO_ID'  value='#arguments.ATRIBUTO_ID#'  null='#iif(len(trim(arguments.ATRIBUTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_VALOR'  value='#arguments.VALOR#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ITEM_ID' variable='retorno.ITEM_ID' >
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera itens dos atributos.
	-- arlen 24/10/2006 16:53:18 - CRIADO
	--->
	<cffunction name='alt_atributo_item' displayname='Altera itens dos atributos.' access='remote' returntype='Struct' output='true'>
		<cfargument name='ATRIBUTO_ID' required='yes'>
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='VALOR' required='yes'>
				<cfstoredproc procedure='granex.pkg_granex.prc_alt_atributo_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATRIBUTO_ID'  value='#arguments.ATRIBUTO_ID#'  null='#iif(len(trim(arguments.ATRIBUTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_VALOR'  value='#arguments.VALOR#' >
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui itens do atributo.
	-- arlen 25/10/2006 08:35:11 - CRIADO
	--->
	<cffunction name='del_atributo_item' displayname='Exclui itens dos atributos.' access='remote' returntype='Struct' output='true'>
		<cfargument name='ATRIBUTO_ID' required='yes'>
		<cfargument name='ITEM_ID' required='yes'>
				<cfstoredproc procedure='granex.pkg_granex.prc_del_atributo_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATRIBUTO_ID'  value='#arguments.ATRIBUTO_ID#'  null='#iif(len(trim(arguments.ATRIBUTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere culturas.
	-- arlen 25/10/2006 15:28:17 - CRIADO
	--->
	<cffunction name='ins_cultura' displayname='Insere culturas.' access='remote' returntype='Struct' output='true'>
		<cfargument name='CULTURA_ID' required='yes'>
		<cfargument name='NOME' required='yes'>
		<cfargument name='COMENTARIO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='granex.pkg_granex.prc_ins_cultura' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMENTARIO'  value='#arguments.COMENTARIO#' >
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CULTURA_ID'  value='#arguments.CULTURA_ID#' variable='retorno.CULTURA_ID'  null='#iif(len(trim(arguments.CULTURA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<!--- Insere as caractersticas das culturas --->
				<cfscript>
					v_atributo_id = this.ListaToArray (lista = arguments, variavel = "ATRIBUTO_ID_CARACTERISTICAS");
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_atributo_id)#" index="count">
					<cfscript>
						this.ins_cultura_atributo(cultura_id  = retorno.cultura_id,
												  atributo_id = v_atributo_id[count]);
					</cfscript>
				</cfloop>				
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Produto inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera culturas.
	-- arlen 25/10/2006 15:30:51 - CRIADO
	--->
	<cffunction name='alt_cultura' displayname='Altera culturas.' access='remote' returntype='Struct' output='true'>
		<cfargument name='CULTURA_ID' required='yes'>
		<cfargument name='NOME' required='yes'>
		<cfargument name='COMENTARIO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='granex.pkg_granex.prc_alt_cultura' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CULTURA_ID'  value='#arguments.CULTURA_ID#' variable='retorno.CULTURA_ID'  null='#iif(len(trim(arguments.CULTURA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMENTARIO'  value='#arguments.COMENTARIO#' >
				</cfstoredproc>
				<!--- Insere as caractersticas para culturas --->
				<cfscript>
					v_cultura_id = this.ListaToArray (lista = arguments, variavel = "CULTURA_CARACTERISTICAS");
					v_atributo_id = this.ListaToArray (lista = arguments, variavel = "ATRIBUTO_ID_CARACTERISTICAS");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_CARACTERISTICAS, lista2 = ArrayToList(v_atributo_id));
				</cfscript>
				<!--- Excluir os itens --->
				<cfloop list="#v_excluir#" delimiters="," index="l_atributo_id">
					<cfscript>
						this.del_cultura_atributo (	cultura_id = arguments.cultura_id,
													atributo_id = l_atributo_id);
					</cfscript>					
				</cfloop>
				
				<cfloop from="1" to="#ArrayLen(v_atributo_id)#" index="count">
					<cfscript>
						this.ins_cultura_atributo ( cultura_id = arguments.cultura_id,
													atributo_id = v_atributo_id[count] );
					</cfscript>
				</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Produto alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui culturas.
	-- arlen 25/10/2006 15:32:06 - CRIADO
	--->
	<cffunction name='del_cultura' displayname='Exclui culturas.' access='remote' returntype='Struct' output='true'>
		<cfargument name='CULTURA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='granex.pkg_granex.prc_del_cultura' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CULTURA_ID'  value='#arguments.CULTURA_ID#'  null='#iif(len(trim(arguments.CULTURA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<!--- Exclui caractersicas relacionadas  cultura --->
				<cfscript>
				  v_atributo_id = this.ListaToArray (lista = arguments, variavel = "ATRIBUTO_ID_CARACTERISTICAS");
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_atributo_id)#" index="count">
					<cfscript>
						this.del_cultura_atributo ( cultura_id  = arguments.cultura_id,
											 		atributo_id = v_atributo_id[count]);
					</cfscript>			
				</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Produto excludo com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere atributos para as culturas.
	-- arlen 25/10/2006 15:34:44 - CRIADO
	--->
	<cffunction name='ins_cultura_atributo' displayname='Insere atributos para as culturas.' access='remote' returntype='Struct' output='true'>
		<cfargument name='CULTURA_ID' required='yes'>
		<cfargument name='ATRIBUTO_ID' required='yes'>
				<cfstoredproc procedure='granex.pkg_granex.prc_ins_cultura_atributo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CULTURA_ID'  value='#arguments.CULTURA_ID#'  null='#iif(len(trim(arguments.CULTURA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATRIBUTO_ID'  value='#arguments.ATRIBUTO_ID#'  null='#iif(len(trim(arguments.ATRIBUTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera atributos das culturas.
	-- arlen 25/10/2006 15:38:45 - CRIADO
	--->
	<cffunction name='alt_cultura_atributo' displayname='Altera atributos das culturas.' access='remote' returntype='Struct' output='true'>
		<cfargument name='CULTURA_ID' required='yes'>
		<cfargument name='ATRIBUTO_ID' required='yes'>
				<cfstoredproc procedure='granex.pkg_granex.prc_alt_cultura_atributo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CULTURA_ID'  value='#arguments.CULTURA_ID#'  null='#iif(len(trim(arguments.CULTURA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATRIBUTO_ID'  value='#arguments.ATRIBUTO_ID#'  null='#iif(len(trim(arguments.ATRIBUTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui atributos das culturas.
	-- arlen 25/10/2006 15:40:20 - CRIADO
	--->
	<cffunction name='del_cultura_atributo' displayname='Exclui atributos das culturas.' access='remote' returntype='Struct' output='true'>
		<cfargument name='CULTURA_ID' required='yes'>
		<cfargument name='ATRIBUTO_ID' required='yes'>
				<cfstoredproc procedure='granex.pkg_granex.prc_del_cultura_atributo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CULTURA_ID'  value='#arguments.CULTURA_ID#'  null='#iif(len(trim(arguments.CULTURA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATRIBUTO_ID'  value='#arguments.ATRIBUTO_ID#'  null='#iif(len(trim(arguments.ATRIBUTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere dados adicionais de agrnomos.
	-- arlen 27/10/2006 08:55:31 - CRIADO
	--->
	<cffunction name='ins_agronomo' displayname='Insere dados adicionais de agrnomos.' access='remote' returntype='Struct' output='true'>
		<cfargument name='CREA' required='yes'>
		<cfargument name='INSTITUICAO_FORMACAO' required='yes'>
		<cfargument name='ANO_FORMACAO' required='yes'>
		<cfargument name='ESPECIALIZACAO' required='yes'>
		<cfargument name='INSTITUICAO_ESPECIALIZACAO' required='yes'>
		<cfargument name='REGIAO_ATUACAO' required='yes'>
		<cfargument name='COD_PESSOA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='granex.pkg_granex.prc_ins_agronomo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CREA'  value='#arguments.CREA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_INSTITUICAO_FORMACAO'  value='#arguments.INSTITUICAO_FORMACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ANO_FORMACAO'  value='#arguments.ANO_FORMACAO#'  null='#iif(len(trim(arguments.ANO_FORMACAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ESPECIALIZACAO'  value='#arguments.ESPECIALIZACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_INSTITUICAO_ESPECIALIZACAO'  value='#arguments.INSTITUICAO_ESPECIALIZACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REGIAO_ATUACAO'  value='#arguments.REGIAO_ATUACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Dados do agrnomo inseridos com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui dados adicionais de agrnomos.
	-- arlen 27/10/2006 08:58:30 - CRIADO
	--->
	<cffunction name='del_agronomo' displayname='Exclui dados adicionais de agrnomos.' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_PESSOA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='granex.pkg_granex.prc_del_agronomo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Dados do agrnomo excludos com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere propriedades de produtores.
	-- arlen 07/11/2006 18:04:33 - CRIADO
	--->
	<cffunction name='ins_propriedade' displayname='Insere propriedades de produtores.' access='remote' returntype='Struct' output='true'>
	<cfargument name='NOME' required='yes'>
	<cfargument name='COD_PESSOA_PROPRIETARIO' required='yes'>
	<cfargument name='AREA_METROS' required='yes'>
	<cfargument name='PROPRIEDADE_ID' required='yes'>
		<cftry>
			 <cftransaction action='begin'> 
				<cfstoredproc procedure='granex.pkg_granex.prc_ins_propriedade' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_PROPRIETARIO'  value='#arguments.COD_PESSOA_PROPRIETARIO#'  null='#iif(len(trim(arguments.COD_PESSOA_PROPRIETARIO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_AREA_METROS'  value='#arguments.AREA_METROS#'  null='#iif(len(trim(arguments.AREA_METROS)), de('no'), de('yes'))#'>
				<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROPRIEDADE_ID'  value='#arguments.PROPRIEDADE_ID#' variable='retorno.PROPRIEDADE_ID'  null='#iif(len(trim(arguments.PROPRIEDADE_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
			</cfstoredproc>
				<!--- Insere as localizaes das propriedades --->
				<cfscript>
					v_localizacao_id = this.ListaToArray (lista = arguments, variavel = "LOCALIZACAO_ID_LOCALIZACOES");
					v_codigo = this.ListaToArray (lista = arguments, variavel = "CODIGO_LOCALIZACOES");
					v_nome = this.ListaToArray (lista = arguments, variavel = "L_NOME_LOCALIZACOES");
					v_area_metros = this.ListaToArray (lista = arguments, variavel = "L_AREA_METROS_LOCALIZACOES");
					v_latitude = this.ListaToArray (lista = arguments, variavel = "LATITUDE_LOCALIZACOES");
					v_longitude = this.ListaToArray (lista = arguments, variavel = "LONGITUDE_LOCALIZACOES");
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_localizacao_id)#" index="count">
					<cfscript>
						retorno.propriedade_id = arguments.propriedade_id;
						this.ins_localizacao(propriedade_id = retorno.propriedade_id,
											 codigo = v_codigo[count],
											 nome = v_nome[count],
											 area_metros = v_area_metros[count],
											 latitude = v_latitude[count],
											 longitude = v_longitude[count],
											 localizacao_id = v_localizacao_id[count]);
					</cfscript>
				</cfloop>
				<!--- Alteraes --->
				<cfscript>
					 
					v_foto_id = this.ListaToArray (lista = arguments, variavel = "FOTO_ID_FOTOS");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_FOTOS, lista2 = ArrayToList(v_foto_id));
					conn = CreateObject("component", "_transportes.consulta.cfc_granex");
					qrFoto = conn.get_propriedade_imagem(propriedade_id = retorno.propriedade_id);
					
				</cfscript>
				<!--- Excluir os itens --->
				<cfloop query="qrFoto">
					<cfif not ListFind(ArrayToList(v_foto_id,','),qrFoto.foto_id,',')>
						<cfscript>
							ret = this.del_propriedade_imagem(propriedade_id = retorno.propriedade_id
														,foto_id = qrFoto.foto_id);
						</cfscript>
						<cfif ret.erro>
							<cfthrow object="#ret.mensagem#">
						</cfif>
					</cfif>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_foto_id)#" index="count">
					<cfscript>
						ret = this.ins_propriedade_imagem(propriedade_id 	= retorno.propriedade_id,
													foto_id		= v_foto_id[count]);
					</cfscript>
					<cfif ret.erro>
						<cfthrow object="#ret.mensagem#">
					</cfif>
				</cfloop>	
				
				
				
				
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Propriedade inserida com sucesso! ')>
			</cftransaction> 
			<cfcatch>
				 <cftransaction action='rollback'/> 
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	

	
	<!--- 
	-- PROPSITO
	-- Altera propriedades de produtores.
	-- arlen 07/11/2006 18:06:26 - CRIADO
	--->
	<cffunction name='upd_propriedade' displayname='Altera propriedades de produtores.' access='remote' returntype='Struct' output='true'>
		<cfargument name='PROPRIEDADE_ID' required='yes'>
		<cfargument name='NOME' required='yes'>
		<cfargument name='COD_PESSOA_PROPRIETARIO' required='yes'>
		<cfargument name='AREA_METROS' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='granex.pkg_granex.prc_alt_propriedade' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROPRIEDADE_ID'  value='#arguments.PROPRIEDADE_ID#'  null='#iif(len(trim(arguments.PROPRIEDADE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_PROPRIETARIO'  value='#arguments.COD_PESSOA_PROPRIETARIO#'  null='#iif(len(trim(arguments.COD_PESSOA_PROPRIETARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_AREA_METROS'  value='#arguments.AREA_METROS#'  null='#iif(len(trim(arguments.AREA_METROS)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<!--- Insere as localizaes das propriedades --->
				<cfscript>
					v_localizacao_id = this.ListaToArray (lista = arguments, variavel = "LOCALIZACAO_ID_LOCALIZACOES");
					v_propriedade_id = this.ListaToArray (lista = arguments, variavel = "PROPRIEDADE_LOCALIZACOES");
					v_codigo = this.ListaToArray (lista = arguments, variavel = "CODIGO_LOCALIZACOES");
					v_nome = this.ListaToArray (lista = arguments, variavel = "L_NOME_LOCALIZACOES");
					v_area_metros = this.ListaToArray (lista = arguments, variavel = "L_AREA_METROS_LOCALIZACOES");
					v_latitude = this.ListaToArray (lista = arguments, variavel = "LATITUDE_LOCALIZACOES");
					v_longitude = this.ListaToArray (lista = arguments, variavel = "LONGITUDE_LOCALIZACOES");
					v_localizacao_excluir = this.ListDiff(lista1 = arguments.lista_deleted_LOCALIZACOES, lista2 = ArrayToList(v_localizacao_id));
				</cfscript>
				<cfloop list="#v_localizacao_excluir#" delimiters="," index="l_localizacao_id">
					<cfscript>
					   this.del_localizacao(localizacao_id = l_localizacao_id);
					</cfscript>
				</cfloop>				
				<cfloop from="1" to="#ArrayLen(v_propriedade_id)#" index="count">
					<cfscript>
						if(not len(trim(v_localizacao_id[count]))) {
							//caso o v_localizacao_id seja nulo insere
							this.ins_localizacao( propriedade_id = arguments.propriedade_id,
											 codigo = v_codigo[count],
											 nome = v_nome[count],
											 area_metros = v_area_metros[count],
											 latitude = v_latitude[count],
											 longitude = v_longitude[count],
											 localizacao_id = v_localizacao_id[count]);
						} else {
							//senao altera
							this.alt_localizacao( localizacao_id = v_localizacao_id[count],
											 propriedade_id = arguments.propriedade_id,
											 codigo = v_codigo[count],
											 nome = v_nome[count],
											 area_metros = v_area_metros[count],
											 latitude = v_latitude[count],
											 longitude = v_longitude[count]);
						}
					</cfscript>			
				</cfloop>
				<!--- Alteraes --->
				<cfscript>
				    retorno.propriedade_id = arguments.propriedade_id;
					v_foto_id = this.ListaToArray (lista = arguments, variavel = "FOTO_ID_FOTOS");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_FOTOS, lista2 = ArrayToList(v_foto_id));
					conn = CreateObject("component", "_transportes.consulta.cfc_granex");
					qrFoto = conn.get_propriedade_imagem(propriedade_id = retorno.propriedade_id);
					
				</cfscript>
				<!--- Excluir os itens --->
				<cfloop query="qrFoto">
					<cfif not ListFind(ArrayToList(v_foto_id,','),qrFoto.foto_id,',')>
						<cfscript>
							ret = this.del_propriedade_imagem(propriedade_id = retorno.propriedade_id
														,foto_id = qrFoto.foto_id);
						</cfscript>
						<cfif ret.erro>
							<cfthrow object="#ret.mensagem#">
						</cfif>
					</cfif>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_foto_id)#" index="count">
					<cfscript>
						ret = this.ins_propriedade_imagem(propriedade_id 	= retorno.propriedade_id,
													foto_id		= v_foto_id[count]);
					</cfscript>
					<cfif ret.erro>
						<cfthrow object="#ret.mensagem#">
					</cfif>
				</cfloop>	
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Propriedade alterada com sucesso!')>
			</cftransaction>	
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui propriedades de produtores.
	-- arlen 07/11/2006 18:07:50 - CRIADO
	--->
	<cffunction name='del_propriedade' displayname='Exclui propriedades de produtores.' access='remote' returntype='Struct' output='true'>
		<cfargument name='PROPRIEDADE_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='granex.pkg_granex.prc_del_propriedade' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROPRIEDADE_ID'  value='#arguments.PROPRIEDADE_ID#'  null='#iif(len(trim(arguments.PROPRIEDADE_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<!--- Exclui localizaes das propriedades --->
				<cfscript>
				  v_localizacao_id = this.ListaToArray (lista = arguments, variavel = "LOCALIZACAO_ID_LOCALIZACOES");
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_localizacao_id)#" index="count">
					<cfscript>
						this.del_localizacao (localizacao_id  = v_localizacao_id[count]);
					</cfscript>			
				</cfloop>				
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Propriedade excluda com sucesso! ')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere localizaes das propriedades de produtores.
	-- arlen 07/11/2006 18:09:48 - CRIADO
	--->
	<cffunction name='ins_localizacao' displayname='Insere localizaes das propriedades de produtores.' access='remote' returntype='Struct' output='true'>
		<cfargument name='PROPRIEDADE_ID' required='yes'>
		<cfargument name='CODIGO' required='yes'>
		<cfargument name='NOME' required='yes'>
		<cfargument name='AREA_METROS' required='yes'>
		<cfargument name='LATITUDE' required='yes'>
		<cfargument name='LONGITUDE' required='yes'>
				<cfstoredproc procedure='granex.pkg_granex.prc_ins_localizacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROPRIEDADE_ID'  value='#arguments.PROPRIEDADE_ID#'  null='#iif(len(trim(arguments.PROPRIEDADE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CODIGO'  value='#arguments.CODIGO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_AREA_METROS'  value='#arguments.AREA_METROS#'  null='#iif(len(trim(arguments.AREA_METROS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_LATITUDE'  value='#arguments.LATITUDE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_LONGITUDE'  value='#arguments.LONGITUDE#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LOCALIZACAO_ID' variable='retorno.LOCALIZACAO_ID' >
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera localizaes das propriedades de produtores.
	-- arlen 07/11/2006 18:11:44 - CRIADO
	--->
	<cffunction name='alt_localizacao' displayname='Altera localizaes das propriedades de produtores.' access='remote' returntype='Struct' output='true'>
		<cfargument name='LOCALIZACAO_ID' required='yes'>
		<cfargument name='PROPRIEDADE_ID' required='yes'>
		<cfargument name='CODIGO' required='yes'>
		<cfargument name='NOME' required='yes'>
		<cfargument name='AREA_METROS' required='yes'>
		<cfargument name='LATITUDE' required='yes'>
		<cfargument name='LONGITUDE' required='yes'>
				<cfstoredproc procedure='granex.pkg_granex.prc_alt_localizacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LOCALIZACAO_ID'  value='#arguments.LOCALIZACAO_ID#'  null='#iif(len(trim(arguments.LOCALIZACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROPRIEDADE_ID'  value='#arguments.PROPRIEDADE_ID#'  null='#iif(len(trim(arguments.PROPRIEDADE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CODIGO'  value='#arguments.CODIGO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_AREA_METROS'  value='#arguments.AREA_METROS#'  null='#iif(len(trim(arguments.AREA_METROS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_LATITUDE'  value='#arguments.LATITUDE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_LONGITUDE'  value='#arguments.LONGITUDE#' >
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui localizaes das propriedades de produtores.
	-- arlen 07/11/2006 18:12:58 - CRIADO
	--->
	<cffunction name='del_localizacao' displayname='Exclui localizaes das propriedades de produtores.' access='remote' returntype='Struct' output='true'>
		<cfargument name='LOCALIZACAO_ID' required='yes'>
				<cfstoredproc procedure='granex.pkg_granex.prc_del_localizacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LOCALIZACAO_ID'  value='#arguments.LOCALIZACAO_ID#'  null='#iif(len(trim(arguments.LOCALIZACAO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere contratos.
	-- arlen 09/11/2006 11:11:03 - CRIADO
	--->
	<cffunction name='ins_contrato' displayname='Insere contratos.' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_PESSOA_INDUSTRIA' required='yes'>
		<cfargument name='PRODUTO_ID' required='yes'>
		<cfargument name='COD_UNIDADE' required='yes'>
		<cfargument name='EXPEDICAO' required='yes'>
		<cfargument name='QUANTIDADE' required='yes'>
		<cfargument name='CONTRATO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='granex.pkg_granex.prc_ins_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_INDUSTRIA'  value='#arguments.COD_PESSOA_INDUSTRIA#'  null='#iif(len(trim(arguments.COD_PESSOA_INDUSTRIA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRODUTO_ID'  value='#arguments.PRODUTO_ID#'  null='#iif(len(trim(arguments.PRODUTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_UNIDADE'  value='#arguments.COD_UNIDADE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EXPEDICAO'  value='#arguments.EXPEDICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QUANTIDADE'  value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTRATO_ID'  value='#arguments.CONTRATO_ID#' variable='retorno.CONTRATO_ID'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<!--- Insere as localizaes no contrato --->
				<cfscript>
					v_item_id = this.ListaToArray (lista = arguments, variavel = "ITEM_ID_LOCALIZACOES");
					v_localizacao_id = this.ListaToArray (lista = arguments, variavel = "LOCALIZACAO_ID_LOCALIZACOES");
					v_area_metros = this.ListaToArray (lista = arguments, variavel = "AREA_METROS_LOCALIZACOES");
					v_estimativa_producao = this.ListaToArray (lista = arguments, variavel = "ESTIMATIVA_PRODUCAO_LOCALIZACOES");
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_localizacao_id)#" index="count">
					<cfscript>
						this.ins_contrato_produtor( item_id = v_item_id[count],
											 contrato_id = retorno.contrato_id,
											 localizacao_id = v_localizacao_id[count],
											 area_metros = v_area_metros[count],
											 estimativa_producao = v_estimativa_producao[count]);
					</cfscript>
				</cfloop>
				<!--- Insere as caractersticas das culturas no contrato --->
				<cfscript>
					v_atributo_id = this.ListaToArray (lista = arguments, variavel = "ATRIBUTO_ID_VALORES");
					v_valor_atr = this.ListaToArray (lista = arguments, variavel = "VALOR_ATR_VALORES");
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_atributo_id)#" index="count">
					<cfscript>
						this.ins_contrato_prod_atributo(contrato_id = retorno.contrato_id,
											 atributo_id = v_atributo_id[count],
											 valor = v_valor_atr[count]);
					</cfscript>
				</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Contrato inserido com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera contratos.
	-- arlen 09/11/2006 11:12:49 - CRIADO
	--->
	<cffunction name='alt_contrato' displayname='Altera contratos.' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_ID' required='yes'>
		<cfargument name='COD_PESSOA_INDUSTRIA' required='yes'>
		<cfargument name='PRODUTO_ID' required='yes'>
		<cfargument name='COD_UNIDADE' required='yes'>
		<cfargument name='EXPEDICAO' required='yes'>
		<cfargument name='QUANTIDADE' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='granex.pkg_granex.prc_alt_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTRATO_ID'  value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_INDUSTRIA'  value='#arguments.COD_PESSOA_INDUSTRIA#'  null='#iif(len(trim(arguments.COD_PESSOA_INDUSTRIA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRODUTO_ID'  value='#arguments.PRODUTO_ID#'  null='#iif(len(trim(arguments.PRODUTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_UNIDADE'  value='#arguments.COD_UNIDADE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EXPEDICAO'  value='#arguments.EXPEDICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QUANTIDADE'  value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<!--- Insere as localizaes no contrato --->
				<cfscript>
					v_item_id = this.ListaToArray (lista = arguments, variavel = "ITEM_ID_LOCALIZACOES");
					v_localizacao_id = this.ListaToArray (lista = arguments, variavel = "LOCALIZACAO_ID_LOCALIZACOES");
					v_contrato_id = this.ListaToArray (lista = arguments, variavel = "CONTRATO_LOCALIZACOES");
					v_area_metros = this.ListaToArray (lista = arguments, variavel = "AREA_METROS_LOCALIZACOES");
					v_estimativa_producao = this.ListaToArray (lista = arguments, variavel = "ESTIMATIVA_PRODUCAO_LOCALIZACOES");
					v_item_excluir = this.ListDiff(lista1 = arguments.lista_deleted_LOCALIZACOES, lista2 = ArrayToList(v_item_id));
				</cfscript>
				<cfloop list="#v_item_excluir#" delimiters="," index="l_item_id">
					<cfscript>
						this.del_contrato_produtor( item_id = l_item_id);
					</cfscript>
				</cfloop>				
				<cfloop from="1" to="#ArrayLen(v_item_id)#" index="count">
					<cfscript>
						if(not len(trim(v_contrato_id[count]))) {
							//caso o v_contrato_id seja nulo insere
							this.ins_contrato_produtor( item_id = v_item_id[count],
										     contrato_id = arguments.contrato_id, 
											 localizacao_id = v_localizacao_id[count],
											 area_metros = v_area_metros[count],
											 estimativa_producao = v_estimativa_producao[count]);
						} else {
							//senao altera
							this.alt_contrato_produtor( item_id = v_item_id[count],
											 contrato_id = arguments.contrato_id,
											 localizacao_id = v_localizacao_id[count],
											 area_metros = v_area_metros[count],
											 estimativa_producao = v_estimativa_producao[count]);
						}
					</cfscript>			
				</cfloop>
				
				<!--- Insere as caractersticas das culturas no contrato --->
				<cfscript>
					v_atributo_id = this.ListaToArray (lista = arguments, variavel = "ATRIBUTO_ID_VALORES");
					v_contrato_id = this.ListaToArray (lista = arguments, variavel = "CONTRATO_ATR_VALORES");
					v_valor_atr = this.ListaToArray (lista = arguments, variavel = "VALOR_ATR_VALORES");
					v_atributo_excluir = this.ListDiff(lista1 = arguments.lista_deleted_VALORES, lista2 = ArrayToList(v_atributo_id));
				</cfscript>
				<cfloop list="#v_atributo_excluir#" delimiters="," index="l_atributo_id">
					<cfscript>
						this.del_contrato_prod_atributo ( contrato_id = arguments.contrato_id,
												atributo_id = l_atributo_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_atributo_id)#" index="indice">
					<cfscript>
						if(not len(trim(v_contrato_id[indice]))) {
							//caso o v_contrato_id seja nulo insere
							this.ins_contrato_prod_atributo(contrato_id = arguments.contrato_id,
											 atributo_id = v_atributo_id[indice],
											 valor = v_valor_atr[indice]);
						} else {
							//senao altera
							this.alt_contrato_prod_atributo(contrato_id = arguments.contrato_id,
											 atributo_id = v_atributo_id[indice],
											 valor = v_valor_atr[indice]);
						}
					</cfscript>			
				</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Contrato alterado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui contratos.
	-- arlen 09/11/2006 11:14:19 - CRIADO
	--->
	<cffunction name='del_contrato' displayname='Exclui contratos.' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='granex.pkg_granex.prc_del_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTRATO_ID'  value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Contrato excludo com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Insere as localizaes do contrato.
	-- arlen 22/11/2006 08:56:46 - CRIADO
	--->
	<cffunction name='ins_contrato_produtor' displayname='Insere as localizaes do contrato.' access='remote' returntype='Struct' output='true'>
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='CONTRATO_ID' required='yes'>
		<cfargument name='LOCALIZACAO_ID' required='yes'>
		<cfargument name='AREA_METROS' required='yes'>
		<cfargument name='ESTIMATIVA_PRODUCAO' required='yes'>
				<cfstoredproc procedure='granex.pkg_granex.prc_ins_contrato_produtor' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTRATO_ID'  value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LOCALIZACAO_ID'  value='#arguments.LOCALIZACAO_ID#'  null='#iif(len(trim(arguments.LOCALIZACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_AREA_METROS'  value='#arguments.AREA_METROS#'  null='#iif(len(trim(arguments.AREA_METROS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ESTIMATIVA_PRODUCAO'  value='#arguments.ESTIMATIVA_PRODUCAO#'  null='#iif(len(trim(arguments.ESTIMATIVA_PRODUCAO)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera as localizaes do contrato.
	-- arlen 22/11/2006 08:58:18 - CRIADO
	--->
	<cffunction name='alt_contrato_produtor' displayname='Altera as localizaes do contrato.' access='remote' returntype='Struct' output='true'>
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='CONTRATO_ID' required='yes'>
		<cfargument name='LOCALIZACAO_ID' required='yes'>
		<cfargument name='AREA_METROS' required='yes'>
		<cfargument name='ESTIMATIVA_PRODUCAO' required='yes'>
				<cfstoredproc procedure='granex.pkg_granex.prc_alt_contrato_produtor' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTRATO_ID'  value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LOCALIZACAO_ID'  value='#arguments.LOCALIZACAO_ID#'  null='#iif(len(trim(arguments.LOCALIZACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_AREA_METROS'  value='#arguments.AREA_METROS#'  null='#iif(len(trim(arguments.AREA_METROS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ESTIMATIVA_PRODUCAO'  value='#arguments.ESTIMATIVA_PRODUCAO#'  null='#iif(len(trim(arguments.ESTIMATIVA_PRODUCAO)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui as localizaes do contrato.
	-- arlen 22/11/2006 08:59:47 - CRIADO
	--->
	<cffunction name='del_contrato_produtor' displayname='Exclui as localizaes do contrato.' access='remote' returntype='Struct' output='true'>
		<cfargument name='ITEM_ID' required='yes'>
				<cfstoredproc procedure='granex.pkg_granex.prc_del_contrato_produtor' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere as caractersticas do contrato.
	-- arlen 09/11/2006 11:29:39 - CRIADO
	--->
	<cffunction name='ins_contrato_prod_atributo' displayname='Insere as caractersticas do contrato.' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_ID' required='yes'>
		<cfargument name='ATRIBUTO_ID' required='yes'>
		<cfargument name='VALOR' required='yes'>
				<cfstoredproc procedure='granex.pkg_granex.prc_ins_contrato_prod_atributo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTRATO_ID'  value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATRIBUTO_ID'  value='#arguments.ATRIBUTO_ID#'  null='#iif(len(trim(arguments.ATRIBUTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_VALOR'  value='#arguments.VALOR#' >
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera as caractersticas do contrato.
	-- arlen 09/11/2006 11:31:06 - CRIADO
	--->
	<cffunction name='alt_contrato_prod_atributo' displayname='Altera as caractersticas do contrato.' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_ID' required='yes'>
		<cfargument name='ATRIBUTO_ID' required='yes'>
		<cfargument name='VALOR' required='yes'>
				<cfstoredproc procedure='granex.pkg_granex.prc_alt_contrato_prod_atributo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTRATO_ID'  value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATRIBUTO_ID'  value='#arguments.ATRIBUTO_ID#'  null='#iif(len(trim(arguments.ATRIBUTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_VALOR'  value='#arguments.VALOR#' >
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui as caractersticas do contrato.
	-- arlen 09/11/2006 11:32:28 - CRIADO
	--->
	<cffunction name='del_contrato_prod_atributo' displayname='Exclui as caractersticas do contrato.' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_ID' required='yes'>
		<cfargument name='ATRIBUTO_ID' required='yes'>
				<cfstoredproc procedure='granex.pkg_granex.prc_del_contrato_prod_atributo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTRATO_ID'  value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATRIBUTO_ID'  value='#arguments.ATRIBUTO_ID#'  null='#iif(len(trim(arguments.ATRIBUTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere marcas de insumos.
	-- arlen 22/11/2006 16:49:17 - CRIADO
	--->
	<cffunction name='ins_insumos_marca' displayname='Insere marcas de insumos.' access='remote' returntype='Struct' output='true'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='MARCA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='granex.pkg_granex.prc_ins_insumos_marca' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MARCA_ID'  value='#arguments.MARCA_ID#' variable='retorno.MARCA_ID'  null='#iif(len(trim(arguments.MARCA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Marca inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera marcas de insumos.
	-- arlen 22/11/2006 16:50:36 - CRIADO
	--->
	<cffunction name='alt_insumos_marca' displayname='Altera marcas de insumos.' access='remote' returntype='Struct' output='true'>
		<cfargument name='MARCA_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='granex.pkg_granex.prc_alt_insumos_marca' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MARCA_ID'  value='#arguments.MARCA_ID#'  null='#iif(len(trim(arguments.MARCA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Marca alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui marcas de insumos.
	-- arlen 22/11/2006 16:51:42 - CRIADO
	--->
	<cffunction name='del_insumos_marca' displayname='Exclui marcas de insumos.' access='remote' returntype='Struct' output='true'>
		<cfargument name='MARCA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='granex.pkg_granex.prc_del_insumos_marca' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MARCA_ID'  value='#arguments.MARCA_ID#'  null='#iif(len(trim(arguments.MARCA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Marca excluda com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere grupos qumicos de insumos.
	-- arlen 22/11/2006 17:45:11 - CRIADO
	--->
	<cffunction name='ins_insumos_grupo_quimico' displayname='Insere grupos qumicos de insumos.' access='remote' returntype='Struct' output='true'>
		<cfargument name='NOME' required='yes'>
		<cfargument name='GRUPO_QUIMICO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='granex.pkg_granex.prc_ins_insumos_grupo_quimico' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_GRUPO_QUIMICO_ID'  value='#arguments.GRUPO_QUIMICO_ID#' variable='retorno.GRUPO_QUIMICO_ID'  null='#iif(len(trim(arguments.GRUPO_QUIMICO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Grupo qumico inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera grupos qumicos de insumos.
	-- arlen 22/11/2006 17:46:36 - CRIADO
	--->
	<cffunction name='alt_insumos_grupo_quimico' displayname='Altera grupos qumicos de insumos.' access='remote' returntype='Struct' output='true'>
		<cfargument name='GRUPO_QUIMICO_ID' required='yes'>
		<cfargument name='NOME' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='granex.pkg_granex.prc_alt_insumos_grupo_quimico' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_GRUPO_QUIMICO_ID'  value='#arguments.GRUPO_QUIMICO_ID#'  null='#iif(len(trim(arguments.GRUPO_QUIMICO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Grupo qumico alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Exclui grupos qumicos de insumos.
	-- arlen 22/11/2006 17:47:34 - CRIADO
	--->
	<cffunction name='del_insumos_grupo_quimico' displayname='Exclui grupos qumicos de insumos.' access='remote' returntype='Struct' output='true'>
		<cfargument name='GRUPO_QUIMICO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='granex.pkg_granex.prc_del_insumos_grupo_quimico' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_GRUPO_QUIMICO_ID'  value='#arguments.GRUPO_QUIMICO_ID#'  null='#iif(len(trim(arguments.GRUPO_QUIMICO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Grupo qumico excludo com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere classes de uso de insumos.
	-- arlen 22/11/2006 17:49:12 - CRIADO
	--->
	<cffunction name='ins_insumos_classe_uso' displayname='Insere classes de uso de insumos.' access='remote' returntype='Struct' output='true'>
		<cfargument name='NOME' required='yes'>
		<cfargument name='COD_CLASSE_USO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='granex.pkg_granex.prc_ins_insumos_classe_uso' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_CHAR' scale="4" dbvarname='P_COD_CLASSE_USO'  value='#arguments.COD_CLASSE_USO#' variable='retorno.COD_CLASSE_USO' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Classe de uso inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
		
	<!--- 
	-- PROPSITO
	-- Altera classes de uso de insumos.
	-- arlen 22/11/2006 17:50:12 - CRIADO
	--->
	<cffunction name='alt_insumos_classe_uso' displayname='Altera classes de uso de insumos.' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_CLASSE_USO' required='yes'>
		<cfargument name='NOME' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='granex.pkg_granex.prc_alt_insumos_classe_uso' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_CHAR' scale="4" dbvarname='P_COD_CLASSE_USO'  value='#arguments.COD_CLASSE_USO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Classe de uso alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui classes de uso de insumos.
	-- arlen 22/11/2006 17:51:20 - CRIADO
	--->
	<cffunction name='del_insumos_classe_uso' displayname='Exclui classes de uso de insumos.' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_CLASSE_USO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='granex.pkg_granex.prc_del_insumos_classe_uso' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_CLASSE_USO'  value='#arguments.COD_CLASSE_USO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Classe de uso excluda com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere ingredientes ativos de insumos.
	-- arlen 22/11/2006 17:53:09 - CRIADO
	--->
	<cffunction name='ins_insumos_ingred_ativo' displayname='Insere ingredientes ativos de insumos.' access='remote' returntype='Struct' output='true'>
		<cfargument name='NOME' required='yes'>
		<cfargument name='INGREDIENTE_ATIVO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='granex.pkg_granex.prc_ins_insumos_ingred_ativo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_INGREDIENTE_ATIVO_ID'  value='#arguments.INGREDIENTE_ATIVO_ID#' variable='retorno.INGREDIENTE_ATIVO_ID'  null='#iif(len(trim(arguments.INGREDIENTE_ATIVO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Ingrediente ativo inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera ingredientes ativos de insumos.
	-- arlen 22/11/2006 17:54:15 - CRIADO
	--->
	<cffunction name='alt_insumos_ingred_ativo' displayname='Altera ingredientes ativos de insumos.' access='remote' returntype='Struct' output='true'>
		<cfargument name='INGREDIENTE_ATIVO_ID' required='yes'>
		<cfargument name='NOME' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='granex.pkg_granex.prc_alt_insumos_ingred_ativo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_INGREDIENTE_ATIVO_ID'  value='#arguments.INGREDIENTE_ATIVO_ID#'  null='#iif(len(trim(arguments.INGREDIENTE_ATIVO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Ingrediente ativo alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui ingredientes ativos de insumos.
	-- arlen 22/11/2006 17:55:40 - CRIADO
	--->
	<cffunction name='del_insumos_ingred_ativo' displayname='Exclui ingredientes ativos de insumos.' access='remote' returntype='Struct' output='true'>
		<cfargument name='INGREDIENTE_ATIVO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='granex.pkg_granex.prc_del_insumos_ingred_ativo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_INGREDIENTE_ATIVO_ID'  value='#arguments.INGREDIENTE_ATIVO_ID#'  null='#iif(len(trim(arguments.INGREDIENTE_ATIVO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Ingrediente ativo excludo com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Insere insumos.
	-- arlen 22/11/2006 17:57:13 - CRIADO
	--->
	<cffunction name='ins_insumos' displayname='Insere insumos.' access='remote' returntype='Struct' output='true'>
		<cfargument name='SIGLA_UF' required='yes'>
		<cfargument name='MARCA_ID' required='yes'>
		<cfargument name='COD_CLASSE_USO' required='yes'>
		<cfargument name='COD_UNIDADE' required='yes'>
		<cfargument name='NUM_REGISTRO' required='yes'>
		<cfargument name='EMPRESA_REGISTRANTE' required='yes'>
		<cfargument name='CLASSE_TOXICA' required='yes'>
		<cfargument name='INGREDIENTE_ATIVO_ID' required='yes'>
		<cfargument name='GRUPO_QUIMICO_ID' required='yes'>
		<cfargument name='INSUMO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='granex.pkg_granex.prc_ins_insumos' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SIGLA_UF'  value='#arguments.SIGLA_UF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MARCA_ID'  value='#arguments.MARCA_ID#'  null='#iif(len(trim(arguments.MARCA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_CHAR' SCALE='4' dbvarname='P_COD_CLASSE_USO'  value='#arguments.COD_CLASSE_USO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_UNIDADE'  value='#arguments.COD_UNIDADE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUM_REGISTRO'  value='#arguments.NUM_REGISTRO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMPRESA_REGISTRANTE'  value='#arguments.EMPRESA_REGISTRANTE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_CHAR' SCALE='4' dbvarname='P_CLASSE_TOXICA'  value='#arguments.CLASSE_TOXICA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_INGREDIENTE_ATIVO_ID'  value='#arguments.INGREDIENTE_ATIVO_ID#'  null='#iif(len(trim(arguments.INGREDIENTE_ATIVO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_GRUPO_QUIMICO_ID'  value='#arguments.GRUPO_QUIMICO_ID#'  null='#iif(len(trim(arguments.GRUPO_QUIMICO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_INSUMO_ID'  value='#arguments.INSUMO_ID#' variable='retorno.INSUMO_ID'  null='#iif(len(trim(arguments.INSUMO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Insumo inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere insumos.
	-- arlen 22/11/2006 17:58:14 - CRIADO
	--->
	<cffunction name='alt_insumos' displayname='Insere insumos.' access='remote' returntype='Struct' output='true'>
		<cfargument name='INSUMO_ID' required='yes'>
		<cfargument name='SIGLA_UF' required='yes'>
		<cfargument name='MARCA_ID' required='yes'>
		<cfargument name='COD_CLASSE_USO' required='yes'>
		<cfargument name='COD_UNIDADE' required='yes'>
		<cfargument name='NUM_REGISTRO' required='yes'>
		<cfargument name='EMPRESA_REGISTRANTE' required='yes'>
		<cfargument name='CLASSE_TOXICA' required='yes'>
		<cfargument name='INGREDIENTE_ATIVO_ID' required='yes'>
		<cfargument name='GRUPO_QUIMICO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='granex.pkg_granex.prc_alt_insumos' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_INSUMO_ID'  value='#arguments.INSUMO_ID#' variable='retorno.INSUMO_ID'  null='#iif(len(trim(arguments.INSUMO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SIGLA_UF'  value='#arguments.SIGLA_UF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MARCA_ID'  value='#arguments.MARCA_ID#'  null='#iif(len(trim(arguments.MARCA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_CHAR' SCALE='4' dbvarname='P_COD_CLASSE_USO'  value='#arguments.COD_CLASSE_USO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_UNIDADE'  value='#arguments.COD_UNIDADE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUM_REGISTRO'  value='#arguments.NUM_REGISTRO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMPRESA_REGISTRANTE'  value='#arguments.EMPRESA_REGISTRANTE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_CHAR' SCALE='4' dbvarname='P_CLASSE_TOXICA'  value='#arguments.CLASSE_TOXICA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_INGREDIENTE_ATIVO_ID'  value='#arguments.INGREDIENTE_ATIVO_ID#'  null='#iif(len(trim(arguments.INGREDIENTE_ATIVO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_GRUPO_QUIMICO_ID'  value='#arguments.GRUPO_QUIMICO_ID#'  null='#iif(len(trim(arguments.GRUPO_QUIMICO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Insumo alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui insumos.
	-- arlen 22/11/2006 18:00:09 - CRIADO
	--->
	<cffunction name='del_insumos' displayname='Exclui insumos.' access='remote' returntype='Struct' output='true'>
		<cfargument name='INSUMO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='granex.pkg_granex.prc_del_insumos' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_INSUMO_ID'  value='#arguments.INSUMO_ID#'  null='#iif(len(trim(arguments.INSUMO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Insumo excludo com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere contratos de plantio.
	-- arlen 06/12/2006 10:31:50 - CRIADO
	--->
	<cffunction name='ins_contrato_plantio' displayname='Insere registros de plantio.' access='remote' returntype='Struct' output='true'>
		<cfargument name='DATA' required='yes'>
		<cfargument name='DATA_DESSECACAO' required='no' default="">
		<cfargument name='TEMPO_DIAS' required='yes'>
		<cfargument name='ESTIMATIVA_PRODUCAO' required='yes'>
		<cfargument name='COD_UNIDADE' required='yes'>
		<cfargument name='ITEM_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='granex.pkg_granex.prc_ins_contrato_plantio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_DESSECACAO'  value='#arguments.DATA_DESSECACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA'  value='#arguments.DATA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TEMPO_DIAS'  value='#arguments.TEMPO_DIAS#'  null='#iif(len(trim(arguments.TEMPO_DIAS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ESTIMATIVA_PRODUCAO'  value='#arguments.ESTIMATIVA_PRODUCAO#'  null='#iif(len(trim(arguments.ESTIMATIVA_PRODUCAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_UNIDADE'  value='#arguments.COD_UNIDADE#' >
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#' variable='retorno.ITEM_ID'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Registro de plantio inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera contratos de plantio.
	-- arlen 06/12/2006 10:33:25 - CRIADO
	--->
	<cffunction name='alt_contrato_plantio' displayname='Altera registros de plantio.' access='remote' returntype='Struct' output='true'>
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='DATA' required='yes'>
		<cfargument name='DATA_DESSECACAO' required='no' default="">
		<cfargument name='TEMPO_DIAS' required='yes'>
		<cfargument name='ESTIMATIVA_PRODUCAO' required='yes'>
		<cfargument name='COD_UNIDADE' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='granex.pkg_granex.prc_alt_contrato_plantio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_DESSECACAO'  value='#arguments.DATA_DESSECACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA'  value='#arguments.DATA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TEMPO_DIAS'  value='#arguments.TEMPO_DIAS#'  null='#iif(len(trim(arguments.TEMPO_DIAS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ESTIMATIVA_PRODUCAO'  value='#arguments.ESTIMATIVA_PRODUCAO#'  null='#iif(len(trim(arguments.ESTIMATIVA_PRODUCAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_UNIDADE'  value='#arguments.COD_UNIDADE#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Registro de plantio alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui contratos de plantio.
	-- arlen 06/12/2006 10:34:24 - CRIADO
	--->
	<cffunction name='del_contrato_plantio' displayname='Exclui registros de plantio.' access='remote' returntype='Struct' output='true'>
		<cfargument name='ITEM_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='granex.pkg_granex.prc_del_contrato_plantio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Registro de plantio excludo com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere contratos de aplicao.
	-- arlen 07/12/2006 18:01:15 - CRIADO
	--->
	<cffunction name='ins_contrato_aplicacao' displayname='Insere contratos de aplicao.' access='remote' returntype='Struct' output='true'>
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='TIPO_APLICACAO_ID' required='yes'>
		<cfargument name='DATA' required='yes'>
		<cfargument name='COD_PESSOA_AGRONOMO' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='APLICACAO_ID' required='yes'>
		<cfargument name='NUMERO_DIAS' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='granex.pkg_granex.prc_ins_contrato_aplicacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_APLICACAO_ID'  value='#arguments.TIPO_APLICACAO_ID#'  null='#iif(len(trim(arguments.TIPO_APLICACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA'  value='#arguments.DATA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_AGRONOMO'  value='#arguments.COD_PESSOA_AGRONOMO#'  null='#iif(len(trim(arguments.COD_PESSOA_AGRONOMO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUMERO_DIAS'  value='#arguments.numero_dias#'  null='#iif(len(trim(arguments.numero_dias)), de('no'), de('yes'))#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_APLICACAO_ID'  value='#arguments.APLICACAO_ID#' variable='retorno.APLICACAO_ID'  null='#iif(len(trim(arguments.APLICACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
                <cfscript>
					arguments.aplicacao_id = retorno.aplicacao_id;
					v_insumo_id_old = this.ListaToArray (lista = arguments, variavel = "INSUMO_ID_OLD_INSUMOS");
					v_insumo_id = this.ListaToArray (lista = arguments, variavel = "INSUMO_ID_INSUMOS");
					v_unidade_id = this.ListaToArray (lista = arguments, variavel = "UNIDADE_ID_INSUMOS");
					v_quantidade = this.ListaToArray (lista = arguments, variavel = "QUANTIDADE_INSUMOS");
					v_item_excluir = this.ListDiff(lista1 = arguments.lista_deleted_INSUMOS, lista2 = ArrayToList(v_insumo_id));
				</cfscript>
				
                <cfloop list="#v_item_excluir#" index="l_id">
                	<cfscript>
						ret = this.del_aplicacao_insumo(aplicacao_id = arguments.aplicacao_id,
														insumo_id = l_id);
					</cfscript>
                    <cfif ret.erro>
                    	<cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>
                <cfloop from="1" to="#ArrayLen(v_insumo_id_old)#" index="count">
                	<cfscript>
						if(len(trim(v_insumo_id_old[count]))) {
							ret = this.upd_aplicacao_insumo(insumo_id_old	= v_insumo_id_old[count],
															insumo_id		= v_insumo_id[count],
															unidade_id		= v_unidade_id[count],
															quantidade		= v_quantidade[count],
															aplicacao_id 	= arguments.aplicacao_id);
						} else {
							ret = this.ins_aplicacao_insumo(insumo_id		= v_insumo_id[count],
															unidade_id		= v_unidade_id[count],
															quantidade		= v_quantidade[count],
															aplicacao_id 	= arguments.aplicacao_id);
						}
					</cfscript>
                    <cfif ret.erro>
                    	<cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Registro de aplicao inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera contratos de aplicao.
	-- arlen 07/12/2006 18:02:58 - CRIADO
	--->
	<cffunction name='alt_contrato_aplicacao' displayname='Altera contratos de aplicao.' access='remote' returntype='Struct' output='true'>
		<cfargument name='APLICACAO_ID' required='yes'>
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='TIPO_APLICACAO_ID' required='yes'>
		<cfargument name='DATA' required='yes'>
		<cfargument name='COD_PESSOA_AGRONOMO' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='NUMERO_DIAS' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='granex.pkg_granex.prc_alt_contrato_aplicacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_APLICACAO_ID'  value='#arguments.APLICACAO_ID#'  null='#iif(len(trim(arguments.APLICACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_APLICACAO_ID'  value='#arguments.TIPO_APLICACAO_ID#'  null='#iif(len(trim(arguments.TIPO_APLICACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA'  value='#arguments.DATA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_AGRONOMO'  value='#arguments.COD_PESSOA_AGRONOMO#'  null='#iif(len(trim(arguments.COD_PESSOA_AGRONOMO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUMERO_DIAS'  value='#arguments.numero_dias#'  null='#iif(len(trim(arguments.numero_dias)), de('no'), de('yes'))#'>
				</cfstoredproc>
   				<cfscript>
					v_insumo_id_old = this.ListaToArray (lista = arguments, variavel = "INSUMO_ID_OLD_INSUMOS");
					v_insumo_id = this.ListaToArray (lista = arguments, variavel = "INSUMO_ID_INSUMOS");
					v_unidade_id = this.ListaToArray (lista = arguments, variavel = "UNIDADE_ID_INSUMOS");
					v_quantidade = this.ListaToArray (lista = arguments, variavel = "QUANTIDADE_INSUMOS");
					v_item_excluir = this.ListDiff(lista1 = arguments.lista_deleted_INSUMOS, lista2 = ArrayToList(v_insumo_id));
				</cfscript>
				
                <cfloop list="#v_item_excluir#" index="l_id">
                	<cfscript>
						ret = this.del_aplicacao_insumo(aplicacao_id = arguments.aplicacao_id,
														insumo_id = l_id);
					</cfscript>
                    <cfif ret.erro>
                    	<cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>
                <cfloop from="1" to="#ArrayLen(v_insumo_id_old)#" index="count">
                	<cfscript>
						if(len(trim(v_insumo_id_old[count]))) {
							ret = this.upd_aplicacao_insumo(insumo_id_old	= v_insumo_id_old[count],
															insumo_id		= v_insumo_id[count],
															unidade_id		= v_unidade_id[count],
															quantidade		= v_quantidade[count],
															aplicacao_id 	= arguments.aplicacao_id);
						} else {
							ret = this.ins_aplicacao_insumo(insumo_id		= v_insumo_id[count],
															unidade_id		= v_unidade_id[count],
															quantidade		= v_quantidade[count],
															aplicacao_id 	= arguments.aplicacao_id);
						}
					</cfscript>
                    <cfif ret.erro>
                    	<cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>
                
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Registro de aplicao alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui contratos de aplicao.
	-- arlen 07/12/2006 18:04:13 - CRIADO
	--->
	<cffunction name='del_contrato_aplicacao' displayname='Exclui contratos de aplicao.' access='remote' returntype='Struct' output='true'>
		<cfargument name='APLICACAO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='granex.pkg_granex.prc_del_contrato_aplicacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_APLICACAO_ID'  value='#arguments.APLICACAO_ID#'  null='#iif(len(trim(arguments.APLICACAO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Registro de aplicao excludo com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere tipos de aplicao.
	-- arlen 08/12/2006 11:27:45 - CRIADO
	--->
	<cffunction name='ins_tipo_aplicacao' displayname='Insere tipos de aplicao.' access='remote' returntype='Struct' output='true'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='TIPO_APLICACAO_ID' required='yes'>
		<cfargument name='COR' required='yes'>
		<cfargument name='URL_IMAGEM' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='granex.pkg_granex.prc_ins_tipo_aplicacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COR'  value='#arguments.COR#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_URL_IMAGEM'  value='#arguments.URL_IMAGEM#' >
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_APLICACAO_ID'  value='#arguments.TIPO_APLICACAO_ID#' variable='retorno.TIPO_APLICACAO_ID'  null='#iif(len(trim(arguments.TIPO_APLICACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tipo de aplicao inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera tipos de aplicao.
	-- arlen 08/12/2006 11:28:50 - CRIADO
	--->
	<cffunction name='alt_tipo_aplicacao' displayname='Altera tipos de aplicao.' access='remote' returntype='Struct' output='true'>
		<cfargument name='TIPO_APLICACAO_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='COR' required='yes'>
		<cfargument name='URL_IMAGEM' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='granex.pkg_granex.prc_alt_tipo_aplicacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_APLICACAO_ID'  value='#arguments.TIPO_APLICACAO_ID#'  null='#iif(len(trim(arguments.TIPO_APLICACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COR'  value='#arguments.COR#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_URL_IMAGEM'  value='#arguments.URL_IMAGEM#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tipo de aplicao alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui tipos de aplicao.
	-- arlen 08/12/2006 11:29:44 - CRIADO
	--->
	<cffunction name='del_tipo_aplicacao' displayname='Exclui tipos de aplicao.' access='remote' returntype='Struct' output='true'>
		<cfargument name='TIPO_APLICACAO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='granex.pkg_granex.prc_del_tipo_aplicacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_APLICACAO_ID'  value='#arguments.TIPO_APLICACAO_ID#'  null='#iif(len(trim(arguments.TIPO_APLICACAO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tipo de aplicao excludo com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere uma imagem vinculada as propriedades
	-- LOUIS 16/03/2007 09:15:02 - CRIADO
	--->
	<cffunction name='ins_foto' displayname='Insere uma imagem vinculada as propriedades' access='remote' returntype='Struct' output='true'>
	<cfargument name='DESCRICAO' required='yes'>
	<cfargument name='URL_IMAGEM' required='no' default="">
	<cfargument name='IMAGEM' required='yes'>
	<cftry>
		<cftransaction action='begin'>
		<cfdump var="#arguments#">
			<cfif len(trim(arguments.imagem))>
					
					<cffile action="upload"
							filefield="IMAGEM" 
							nameconflict="makeunique"
							destination="#arguments.imagem#"
							result="arguments.dados">
					
					<cffile action="upload"
							filefield="IMAGEM" 
							nameconflict="makeunique"
							destination="#ExpandPath('/')#granex/upload/imagens/imagem.#arguments.dados.clientfileext#"
							result="arguments.dados2">
					<cfdump var="#arguments.dados2#">
					<cfset arguments.url_imagem = "/granex/upload/imagens/#arguments.dados2.serverfile#">
				</cfif>
					<cfset retorno.url_imagem = arguments.url_imagem>
			
			<cfstoredproc procedure='granex.pkg_granex.prc_ins_foto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_URL_IMAGEM'  value='#arguments.URL_IMAGEM#' >
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FOTO_ID' variable='retorno.FOTO_ID' >
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Imagem inserida com sucesso!')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
	
		</cfcatch>
	</cftry>
	<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera uma imagem vinculada as propriedades
	-- LOUIS 16/03/2007 09:15:58 - CRIADO
	--->
	<cffunction name='upd_foto' displayname='Altera uma imagem vinculada as propriedades' access='remote' returntype='Struct' output='true'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='URL_IMAGEM' required='yes'>
		<cfargument name='FOTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='granex.pkg_granex.prc_alt_foto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_URL_IMAGEM'  value='#arguments.URL_IMAGEM#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FOTO_ID'  value='#arguments.FOTO_ID#'  null='#iif(len(trim(arguments.FOTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Imagem alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui uma imagem vinculada as propriedades
	-- LOUIS 16/03/2007 09:17:07 - CRIADO
	--->
	<cffunction name='del_foto' displayname='Exclui uma imagem vinculada as propriedades' access='remote' returntype='Struct' output='true'>
		<cfargument name='FOTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='granex.pkg_granex.prc_del_foto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FOTO_ID'  value='#arguments.FOTO_ID#'  null='#iif(len(trim(arguments.FOTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Imagem excluda com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>


	<!--- 
	-- PROPSITO
	-- Vincula uma imagem a uma propriedade
	-- LOUIS 16/03/2007 17:08:59 - CRIADO
	--->
	<cffunction name='ins_propriedade_imagem' displayname='Vincula uma imagem a uma propriedade' access='remote' returntype='Struct' output='true'>
	<cfargument name='PROPRIEDADE_ID' required='yes'>
	<cfargument name='FOTO_ID' required='yes'>
	<cftry>
		<!--- <cftransaction action='begin'> --->
			<cfstoredproc procedure='granex.pkg_granex.prc_ins_propriedade_imagem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROPRIEDADE_ID'  value='#arguments.PROPRIEDADE_ID#'  null='#iif(len(trim(arguments.PROPRIEDADE_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FOTO_ID'  value='#arguments.FOTO_ID#'  null='#iif(len(trim(arguments.FOTO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
			</cfstoredproc> 
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Imagem inserida com sucesso!')>
		<!--- </cftransaction> --->
		<cfcatch>
			<!--- <cftransaction action='rollback'/> --->
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Desvincula uma imagem a uma propriedade
	-- LOUIS 16/03/2007 17:11:50 - CRIADO
	--->
	<cffunction name='del_propriedade_imagem' displayname='Desvincula uma imagem a uma propriedade' access='remote' returntype='Struct' output='true'>
	<cfargument name='PROPRIEDADE_ID' required='yes'>
	<cfargument name='FOTO_ID' required='yes'>
	<cftry>
			<cfstoredproc procedure='granex.pkg_granex.prc_del_propriedade_imagem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROPRIEDADE_ID'  value='#arguments.PROPRIEDADE_ID#'  null='#iif(len(trim(arguments.PROPRIEDADE_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FOTO_ID'  value='#arguments.FOTO_ID#'  null='#iif(len(trim(arguments.FOTO_ID)), de('no'), de('yes'))#'>
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Imagem excluda com sucesso!')>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
	</cffunction>
    
    <!--- 
    -- PROPSITO
    -- Insere um insumo na aplicacao
    -- cristofer 10/07/2007 10:12:15 - CRIADO
    --->
    <cffunction name='ins_aplicacao_insumo' displayname='Insere um insumo na aplicacao' access='remote' returntype='Struct' output='true'>
        <cfargument name='APLICACAO_ID' required='yes'>
        <cfargument name='INSUMO_ID' required='yes'>
        <cfargument name='UNIDADE_ID' required='yes'>
        <cfargument name='QUANTIDADE' required='yes'>
        <cftry>
                <cfstoredproc procedure='granex.pkg_granex.prc_ins_aplicacao_insumo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_APLICACAO_ID'  value='#arguments.APLICACAO_ID#'  null='#iif(len(trim(arguments.APLICACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_INSUMO_ID'  value='#arguments.INSUMO_ID#'  null='#iif(len(trim(arguments.INSUMO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_UNIDADE_ID'  value='#arguments.UNIDADE_ID#'  null='#iif(len(trim(arguments.UNIDADE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QUANTIDADE'  value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Insumo inserido com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Altera um insumo na aplicacao
    -- cristofer 10/07/2007 10:14:04 - CRIADO
    --->
    <cffunction name='upd_aplicacao_insumo' displayname='Altera um insumo na aplicacao' access='remote' returntype='Struct' output='true'>
        <cfargument name='APLICACAO_ID' required='yes'>
        <cfargument name='INSUMO_ID' required='yes'>
        <cfargument name='UNIDADE_ID' required='yes'>
        <cfargument name='QUANTIDADE' required='yes'>
        <cfargument name='INSUMO_ID_OLD' required='yes'>
        <cftry>
                <cfstoredproc procedure='granex.pkg_granex.prc_alt_aplicacao_insumo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_APLICACAO_ID'  value='#arguments.APLICACAO_ID#'  null='#iif(len(trim(arguments.APLICACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_INSUMO_ID'  value='#arguments.INSUMO_ID#'  null='#iif(len(trim(arguments.INSUMO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_UNIDADE_ID'  value='#arguments.UNIDADE_ID#'  null='#iif(len(trim(arguments.UNIDADE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QUANTIDADE'  value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_INSUMO_ID_OLD'  value='#arguments.INSUMO_ID_OLD#'  null='#iif(len(trim(arguments.INSUMO_ID_OLD)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Insumo alterado com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Exclui um insumo na aplicacao
    -- cristofer 10/07/2007 10:14:48 - CRIADO
    --->
    <cffunction name='del_aplicacao_insumo' displayname='Exclui um insumo na aplicacao' access='remote' returntype='Struct' output='true'>
        <cfargument name='APLICACAO_ID' required='yes'>
        <cfargument name='INSUMO_ID' required='yes'>
        <cftry>
                <cfstoredproc procedure='granex.pkg_granex.prc_del_aplicacao_insumo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_APLICACAO_ID'  value='#arguments.APLICACAO_ID#'  null='#iif(len(trim(arguments.APLICACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_INSUMO_ID'  value='#arguments.INSUMO_ID#'  null='#iif(len(trim(arguments.INSUMO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Insumo excluido com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Insere uma unidade de aplicacao
    -- cristofer 10/07/2007 10:15:23 - CRIADO
    --->
    <cffunction name='ins_unidade' displayname='Insere uma unidade de aplicacao' access='remote' returntype='Struct' output='true'>
        <cfargument name='DESCRICAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='granex.pkg_granex.prc_ins_unidade' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_UNIDADE_ID' variable='retorno.UNIDADE_ID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Unidade inserida com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Altera uma unidade de aplicacao
    -- cristofer 10/07/2007 10:15:58 - CRIADO
    --->
    <cffunction name='upd_unidade' displayname='Altera uma unidade de aplicacao' access='remote' returntype='Struct' output='true'>
        <cfargument name='UNIDADE_ID' required='yes'>
        <cfargument name='DESCRICAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='granex.pkg_granex.prc_alt_unidade' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_UNIDADE_ID'  value='#arguments.UNIDADE_ID#'  null='#iif(len(trim(arguments.UNIDADE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Unidade alterada com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Exclui uma unidade de aplicacao
    -- cristofer 10/07/2007 10:16:28 - CRIADO
    --->
    <cffunction name='del_unidade' displayname='Exclui uma unidade de aplicacao' access='remote' returntype='Struct' output='true'>
        <cfargument name='UNIDADE_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='granex.pkg_granex.prc_del_unidade' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_UNIDADE_ID'  value='#arguments.UNIDADE_ID#'  null='#iif(len(trim(arguments.UNIDADE_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Unidade excluida com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
</cfcomponent>