<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPSITO
    -- Insere avaria!
    -- igor 24/09/2008 14:30:23 - CRIADO
    --->
    <cffunction name='prc_ins_avaria' displayname='Insere avaria!' access='remote' returntype='Struct' output='true'>
        <cfargument name='AVARIA_ID' required='yes'>
        <cfargument name='DATA_HORA' required='yes'>
        <cfargument name='COD_PESSOA_FILIAL' required='yes'>
        <cfargument name='COD_CENTRO_CUSTO' required='yes'>
        <cfargument name='CONHECIMENTO_ID' required='yes'>
        <cfargument name='CRT_CONHECIMENTO_ID' required='yes'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='PLACA_CARRETA' required='yes'>
        <cfargument name='COD_REMETENTE' required='yes'>
        <cfargument name='COD_DESTINATARIO' required='yes'>
        <cfargument name='MERCADORIA' required='yes'>
        <cfargument name='QTDE_TRANSPORTADA' required='yes'>
        <cfargument name='NF_ORIGEM' required='yes'>
        <cfargument name='NF_PESO' required='yes'>
        <cfargument name='NF_VALOR' required='yes'>
        <cfargument name='NF_COD_MOEDA' required='yes'>
        <cfargument name='NF_VALOR_MOEDA' required='yes'>
        <cfargument name='OBSERVACAO' required='yes'>
        <cfargument name='DESCRICAO' required='yes'>
        <cfargument name='QTDE_AVARIADA' required='yes'>
        <cfargument name='VALOR_AVARIA' required='yes'>
        <cfargument name='COD_MOEDA' required='yes'>
        <cfargument name='VALOR_AVARIA_MOEDA' required='yes'>
        <cfargument name='CAUSA_PROVAVEL' required='yes'>
        <cfargument name='SUGESTAO_ACAO' required='yes'>
        <cfargument name='RESPONSAVEL' required='yes'>
        <cfargument name='EMITENTE' required='yes'>
        <cfargument name='CARGO' required='yes'>
        <cfargument name='SITUACAO' required='yes'>
        <cfargument name='RECUPERACAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_avaria.prc_ins_avaria' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_AVARIA_ID'  value='#arguments.AVARIA_ID#' variable='retorno.AVARIA_ID'  null='#iif(len(trim(arguments.AVARIA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_HORA'  value='#arguments.DATA_HORA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_FILIAL'  value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CRT_CONHECIMENTO_ID'  value='#arguments.CRT_CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CRT_CONHECIMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA_CARRETA'  value='#arguments.PLACA_CARRETA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_REMETENTE'  value='#arguments.COD_REMETENTE#'  null='#iif(len(trim(arguments.COD_REMETENTE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_DESTINATARIO'  value='#arguments.COD_DESTINATARIO#'  null='#iif(len(trim(arguments.COD_DESTINATARIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MERCADORIA'  value='#arguments.MERCADORIA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_QTDE_TRANSPORTADA'  value='#arguments.QTDE_TRANSPORTADA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NF_ORIGEM'  value='#arguments.NF_ORIGEM#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NF_PESO'  value='#arguments.NF_PESO#'  null='#iif(len(trim(arguments.NF_PESO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NF_VALOR'  value='#arguments.NF_VALOR#'  null='#iif(len(trim(arguments.NF_VALOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NF_COD_MOEDA'  value='#arguments.NF_COD_MOEDA#'  null='#iif(len(trim(arguments.NF_COD_MOEDA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NF_VALOR_MOEDA'  value='#arguments.NF_VALOR_MOEDA#'  null='#iif(len(trim(arguments.NF_VALOR_MOEDA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_QTDE_AVARIADA'  value='#arguments.QTDE_AVARIADA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_AVARIA'  value='#arguments.VALOR_AVARIA#'  null='#iif(len(trim(arguments.VALOR_AVARIA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_MOEDA'  value='#arguments.COD_MOEDA#'  null='#iif(len(trim(arguments.COD_MOEDA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_AVARIA_MOEDA'  value='#arguments.VALOR_AVARIA_MOEDA#'  null='#iif(len(trim(arguments.VALOR_AVARIA_MOEDA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CAUSA_PROVAVEL'  value='#arguments.CAUSA_PROVAVEL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SUGESTAO_ACAO'  value='#arguments.SUGESTAO_ACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RESPONSAVEL'  value='#arguments.RESPONSAVEL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMITENTE'  value='#arguments.EMITENTE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CARGO'  value='#arguments.CARGO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SITUACAO'  value='#arguments.SITUACAO#'  null='#iif(len(trim(arguments.SITUACAO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RECUPERACAO'  value='#arguments.RECUPERACAO#'  null='#iif(len(trim(arguments.RECUPERACAO)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Item inserido com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    
    <!--- 
    -- PROPSITO
    -- Altera avaria!
    -- igor 24/09/2008 14:31:29 - CRIADO
    --->
    <cffunction name='prc_upd_avaria' displayname='Altera avaria!' access='remote' returntype='Struct' output='true'>
        <cfargument name='AVARIA_ID' required='yes'>
        <cfargument name='DATA_HORA' required='yes'>
        <cfargument name='COD_PESSOA_FILIAL' required='yes'>
        <cfargument name='COD_CENTRO_CUSTO' required='yes'>
        <cfargument name='CONHECIMENTO_ID' required='yes'>
        <cfargument name='CRT_CONHECIMENTO_ID' required='yes'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='PLACA_CARRETA' required='yes'>
        <cfargument name='COD_REMETENTE' required='yes'>
        <cfargument name='COD_DESTINATARIO' required='yes'>
        <cfargument name='MERCADORIA' required='yes'>
        <cfargument name='QTDE_TRANSPORTADA' required='yes'>
        <cfargument name='NF_ORIGEM' required='yes'>
        <cfargument name='NF_PESO' required='yes'>
        <cfargument name='NF_VALOR' required='yes'>
        <cfargument name='NF_COD_MOEDA' required='yes'>
        <cfargument name='NF_VALOR_MOEDA' required='yes'>
        <cfargument name='OBSERVACAO' required='yes'>
        <cfargument name='DESCRICAO' required='yes'>
        <cfargument name='QTDE_AVARIADA' required='yes'>
        <cfargument name='VALOR_AVARIA' required='yes'>
        <cfargument name='COD_MOEDA' required='yes'>
        <cfargument name='VALOR_AVARIA_MOEDA' required='yes'>
        <cfargument name='CAUSA_PROVAVEL' required='yes'>
        <cfargument name='SUGESTAO_ACAO' required='yes'>
        <cfargument name='RESPONSAVEL' required='yes'>
        <cfargument name='EMITENTE' required='yes'>
        <cfargument name='CARGO' required='yes'>
        <cfargument name='SITUACAO' required='yes'>
        <cfargument name='RECUPERACAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_avaria.prc_alt_avaria' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_AVARIA_ID'  value='#arguments.AVARIA_ID#'  null='#iif(len(trim(arguments.AVARIA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_HORA'  value='#arguments.DATA_HORA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_FILIAL'  value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CRT_CONHECIMENTO_ID'  value='#arguments.CRT_CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CRT_CONHECIMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA_CARRETA'  value='#arguments.PLACA_CARRETA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_REMETENTE'  value='#arguments.COD_REMETENTE#'  null='#iif(len(trim(arguments.COD_REMETENTE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_DESTINATARIO'  value='#arguments.COD_DESTINATARIO#'  null='#iif(len(trim(arguments.COD_DESTINATARIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MERCADORIA'  value='#arguments.MERCADORIA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_QTDE_TRANSPORTADA'  value='#arguments.QTDE_TRANSPORTADA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NF_ORIGEM'  value='#arguments.NF_ORIGEM#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NF_PESO'  value='#arguments.NF_PESO#'  null='#iif(len(trim(arguments.NF_PESO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NF_VALOR'  value='#arguments.NF_VALOR#'  null='#iif(len(trim(arguments.NF_VALOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NF_COD_MOEDA'  value='#arguments.NF_COD_MOEDA#'  null='#iif(len(trim(arguments.NF_COD_MOEDA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NF_VALOR_MOEDA'  value='#arguments.NF_VALOR_MOEDA#'  null='#iif(len(trim(arguments.NF_VALOR_MOEDA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_QTDE_AVARIADA'  value='#arguments.QTDE_AVARIADA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_AVARIA'  value='#arguments.VALOR_AVARIA#'  null='#iif(len(trim(arguments.VALOR_AVARIA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_MOEDA'  value='#arguments.COD_MOEDA#'  null='#iif(len(trim(arguments.COD_MOEDA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_AVARIA_MOEDA'  value='#arguments.VALOR_AVARIA_MOEDA#'  null='#iif(len(trim(arguments.VALOR_AVARIA_MOEDA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CAUSA_PROVAVEL'  value='#arguments.CAUSA_PROVAVEL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SUGESTAO_ACAO'  value='#arguments.SUGESTAO_ACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RESPONSAVEL'  value='#arguments.RESPONSAVEL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMITENTE'  value='#arguments.EMITENTE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CARGO'  value='#arguments.CARGO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SITUACAO'  value='#arguments.SITUACAO#'  null='#iif(len(trim(arguments.SITUACAO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RECUPERACAO'  value='#arguments.RECUPERACAO#'  null='#iif(len(trim(arguments.RECUPERACAO)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Item alterado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Deleta avaria!
    -- igor 24/09/2008 14:32:41 - CRIADO
    --->
    <cffunction name='prc_del_avaria' displayname='Deleta avaria!' access='remote' returntype='Struct' output='true'>
        <cfargument name='AVARIA_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_avaria.prc_del_avaria' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_AVARIA_ID'  value='#arguments.AVARIA_ID#'  null='#iif(len(trim(arguments.AVARIA_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Item excludo com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Insere histrico de avaria
    -- igor 29/09/2008 14:25:43 - CRIADO
    --->
    <cffunction name='ins_avaria_historico' displayname='Insere histrico de avaria' access='remote' returntype='Struct' output='true'>
        <cfargument name='AVARIA_ID' required='yes'>
        <cfargument name='HISTORICO_ID' required='yes'>
        <cfargument name='HISTORICO' required='yes'>
        <cfargument name='PERMITE_EDITAR' required='yes'>
        <cfargument name='ROWID' required='no'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_avaria.prc_ins_avaria_historico' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_AVARIA_ID'  value='#arguments.AVARIA_ID#'  null='#iif(len(trim(arguments.AVARIA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_HISTORICO_ID'  value='#arguments.HISTORICO_ID#' variable='retorno.HISTORICO_ID'  null='#iif(len(trim(arguments.HISTORICO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_HISTORICO'  value='#arguments.HISTORICO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PERMITE_EDITAR'  value='#arguments.PERMITE_EDITAR#'  null='#iif(len(trim(arguments.PERMITE_EDITAR)), de('no'), de('yes'))#'>
                    <cfprocparam type='INOUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID'  value='#arguments.ROWID#' variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Item inserido com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Altera histrico de avaria
    -- igor 29/09/2008 14:26:33 - CRIADO
    --->
    <cffunction name='upd_avaria_historico' displayname='Altera histrico de avaria' access='remote' returntype='Struct' output='true'>
        <cfargument name='AVARIA_ID' required='yes'>
        <cfargument name='HISTORICO_ID' required='yes'>
        <cfargument name='HISTORICO' required='yes'>
        <cfargument name='PERMITE_EDITAR' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_avaria.prc_alt_avaria_historico' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_AVARIA_ID'  value='#arguments.AVARIA_ID#'  null='#iif(len(trim(arguments.AVARIA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_HISTORICO_ID'  value='#arguments.HISTORICO_ID#'  null='#iif(len(trim(arguments.HISTORICO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_HISTORICO'  value='#arguments.HISTORICO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PERMITE_EDITAR'  value='#arguments.PERMITE_EDITAR#'  null='#iif(len(trim(arguments.PERMITE_EDITAR)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Item alterado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Deleta histrico de avaria
    -- igor 29/09/2008 14:27:15 - CRIADO
    --->
    <cffunction name='del_avaria_historico' displayname='Deleta histrico de avaria' access='remote' returntype='Struct' output='true'>
        <cfargument name='HISTORICO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_avaria.prc_del_avaria_historico' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_HISTORICO_ID'  value='#arguments.HISTORICO_ID#'  null='#iif(len(trim(arguments.HISTORICO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Item excluido com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere um status de pendncia
	-- ANDERSONC 26/04/2012 14:29:50 - CRIADO
	--->
	<cffunction name='ins_status_pendencia' displayname='Insere um status de pendncia' access='remote' returntype='Struct' output='true'>
		<cfargument name='CODIGO' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_avaria.prc_ins_status_pendencia' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_STATUS_PENDENCIA_ID' variable='retorno.STATUS_PENDENCIA_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CODIGO'  value='#arguments.CODIGO#'  null='#iif(len(trim(arguments.CODIGO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Status inserido com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Altera um status de pendncia
	-- ANDERSONC 26/04/2012 14:48:50 - CRIADO
	--->
	<cffunction name='upd_status_pendencia' displayname='Altera um status de pendncia' access='remote' returntype='Struct' output='true'>
		<cfargument name='STATUS_PENDENCIA_ID' required='yes'>
		<cfargument name='CODIGO' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_avaria.prc_alt_status_pendencia' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_STATUS_PENDENCIA_ID'  value='#arguments.STATUS_PENDENCIA_ID#'  null='#iif(len(trim(arguments.STATUS_PENDENCIA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CODIGO'  value='#arguments.CODIGO#'  null='#iif(len(trim(arguments.CODIGO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Status alterado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um status de pendncia
	-- ANDERSONC 26/04/2012 14:49:32 - CRIADO
	--->
	<cffunction name='del_status_pendencia' displayname='Exclui um status de pendncia' access='remote' returntype='Struct' output='true'>
		<cfargument name='STATUS_PENDENCIA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_avaria.prc_del_status_pendencia' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_STATUS_PENDENCIA_ID'  value='#arguments.STATUS_PENDENCIA_ID#'  null='#iif(len(trim(arguments.STATUS_PENDENCIA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Status excludo com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Atualiza as pendncia de um CTRC/CTe
	-- ANDERSONC 26/04/2012 14:49:32 - CRIADO
	--->
	<cffunction name='atualizar_pendencia_operacional' displayname='Atualiza as pendncia de um CTRC/CTe' access='remote' returntype='Struct' output='true'>
		<cftry>
			<cftransaction action='begin'>
				<cfscript>
                    v_pendencia_operacional_id = this.ListaToArray(lista = arguments, variavel = 'PENDENCIA_OPERACIONAL_ID_PENDENCIA');
					v_conhecimento_id          = this.ListaToArray(lista = arguments, variavel = 'CONHECIMENTO_ID_PENDENCIA');					
					v_data_ocorrencia          = this.ListaToArray(lista = arguments, variavel = 'DATA_OCORRENCIA_PENDENCIA');
					v_ocorrencia               = this.ListaToArray(lista = arguments, variavel = 'OCORRENCIA_PENDENCIA');
					v_solucao_apontada         = this.ListaToArray(lista = arguments, variavel = 'SOLUCAO_APONTADA_PENDENCIA');
					v_status_pendencia_id      = this.ListaToArray(lista = arguments, variavel = 'STATUS_PENDENCIA_ID_PENDENCIA');
					v_responsavel              = this.ListaToArray(lista = arguments, variavel = 'RESPONSAVEL_PENDENCIA');
					v_fone_ddd 			       = this.ListaToArray(lista = arguments, variavel = 'FONE_DDD_PENDENCIA');
					v_fone_prefixo 		       = this.ListaToArray(lista = arguments, variavel = 'FONE_PREFIXO_PENDENCIA');
					v_fone_numero 		       = this.ListaToArray(lista = arguments, variavel = 'FONE_NUMERO_PENDENCIA');
					v_data_finalizacao         = this.ListaToArray(lista = arguments, variavel = 'DATA_FINALIZACAO_PENDENCIA');
					v_num_nota_fiscal          = this.ListaToArray(lista = arguments, variavel = 'NUM_NOTA_FISCAL');
					v_serie                    = this.ListaToArray(lista = arguments, variavel = 'SERIE');
					v_data_emissao_nf          = this.ListaToArray(lista = arguments, variavel = 'DATA_EMISSAO_NF');
					
					v_cod_pessoa_rem           = this.ListaToArray(lista = arguments, variavel = 'COD_PESSOA_REM');
					v_cod_pessoa_dest          = this.ListaToArray(lista = arguments, variavel = 'COD_PESSOA_DEST');
					v_municipio_id_dest        = this.ListaToArray(lista = arguments, variavel = 'MUNICIPIO_ID_DESTINO');
					v_municipio_id_origem      = this.ListaToArray(lista = arguments, variavel = 'MUNICIPIO_ID_ORIGEM');
					
                    v_excluir	     	       = this.ListDiff(lista1 = arguments.lista_deleted_PENDENCIA, lista2 = ArrayToList(v_pendencia_operacional_id));
                </cfscript>
                
                <cfloop list="#v_excluir#" delimiters="," index="po_id">
                    <cfscript>
                        ret_del = this.del_pendencia_operacional(PENDENCIA_OPERACIONAL_ID = po_id);
                    </cfscript>
                    <cfif ret_del.erro>
                        <cfthrow object="#ret_del.mensagem#">
                    </cfif>
                </cfloop>
                
                <cfloop from="1" to="#ArrayLen(v_pendencia_operacional_id)#" index="count">
                    <cfscript>
                        if(Not Len(Trim(v_pendencia_operacional_id[count]))) {
							ret_po = this.ins_pendencia_operacional(conhecimento_id     = v_conhecimento_id[count]
													 			  , data_ocorrencia     = v_data_ocorrencia[count]																  
																  , ocorrencia          = v_ocorrencia[count]
																  , solucao_apontada    = v_solucao_apontada[count]
																  , status_pendencia_id = v_status_pendencia_id[count]
																  , responsavel         = v_responsavel[count]
																  , fone_ddd            = v_fone_ddd[count]
																  , fone_prefixo        = v_fone_prefixo[count]
																  , fone_numero         = v_fone_numero[count]
																  , data_finalizacao    = v_data_finalizacao[count]
																  , num_nota_fiscal     = v_num_nota_fiscal[count]
																  , serie               = v_serie[count]
																  , data_emissao_nf     = v_data_emissao_nf[count]
																  , cod_pessoa_rem      = v_cod_pessoa_rem[count]
																  , cod_pessoa_dest     = v_cod_pessoa_dest[count]
																  , municipio_id_dest   = v_municipio_id_dest[count]
																  , municipio_id_origem = v_municipio_id_origem[count]
																  );  
        
                        }
                        else {
							ret_po = this.upd_pendencia_operacional(pendencia_operacional_id = v_pendencia_operacional_id[count]
																  , conhecimento_id          = v_conhecimento_id[count]
													 			  , data_ocorrencia          = v_data_ocorrencia[count]															  
																  , ocorrencia               = v_ocorrencia[count]
																  , solucao_apontada         = v_solucao_apontada[count]
																  , status_pendencia_id      = v_status_pendencia_id[count]
																  , responsavel              = v_responsavel[count]
																  , fone_ddd                 = v_fone_ddd[count]
																  , fone_prefixo             = v_fone_prefixo[count]
																  , fone_numero              = v_fone_numero[count]
																  , data_finalizacao         = v_data_finalizacao[count]
																  , num_nota_fiscal          = v_num_nota_fiscal[count]
																  , serie                    = v_serie[count]
																  , data_emissao_nf          = v_data_emissao_nf[count]
																  , cod_pessoa_rem           = v_cod_pessoa_rem[count]
																  , cod_pessoa_dest          = v_cod_pessoa_dest[count]
																  , municipio_id_dest        = v_municipio_id_dest[count]
																  , municipio_id_origem      = v_municipio_id_origem[count]
																  );
                        }
                    </cfscript>
                    <cfif ret_po.erro>
                        <cfthrow object="#ret_po.mensagem#">
                    </cfif>
                </cfloop>
                
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Pendncia(s) atualizada(s) com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere uma pendncia operacional
	-- ANDERSONC 26/04/2012 14:50:35 - CRIADO
	--->
	<cffunction name='ins_pendencia_operacional' displayname='Insere uma pendncia operacional' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID' required='no'>
		<cfargument name='DATA_OCORRENCIA' required='yes'>
		<cfargument name='OCORRENCIA' required='yes'>
		<cfargument name='SOLUCAO_APONTADA' required='yes'>
		<cfargument name='STATUS_PENDENCIA_ID' required='yes'>
		<cfargument name='RESPONSAVEL' required='yes'>
		<cfargument name='FONE_DDD' required='yes'>
		<cfargument name='FONE_PREFIXO' required='yes'>
		<cfargument name='FONE_NUMERO' required='yes'>
		<cfargument name='DATA_FINALIZACAO' required='yes'>
		<cfargument name='NUM_NOTA_FISCAL' required='yes'>
		<cfargument name='SERIE' required='yes'>
		<cfargument name='DATA_EMISSAO_NF' required='yes'>
        <cfargument name='COD_PESSOA_REM' required='yes'>
        <cfargument name='COD_PESSOA_DEST' required='yes'>
        <cfargument name='MUNICIPIO_ID_DEST' required='yes'>
        <cfargument name='MUNICIPIO_ID_ORIGEM' required='yes'>
		<cftry>
            <cfstoredproc procedure='oper.pkg_avaria.prc_ins_pendencia_operacional' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PENDENCIA_OPERACIONAL_ID' variable='retorno.PENDENCIA_OPERACIONAL_ID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_OCORRENCIA'  value='#arguments.DATA_OCORRENCIA#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OCORRENCIA'  value='#arguments.OCORRENCIA#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SOLUCAO_APONTADA'  value='#arguments.SOLUCAO_APONTADA#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_STATUS_PENDENCIA_ID'  value='#arguments.STATUS_PENDENCIA_ID#'  null='#iif(len(trim(arguments.STATUS_PENDENCIA_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RESPONSAVEL'  value='#arguments.RESPONSAVEL#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_FONE_DDD'  value='#arguments.FONE_DDD#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_FONE_PREFIXO'  value='#arguments.FONE_PREFIXO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_FONE_NUMERO'  value='#arguments.FONE_NUMERO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_FINALIZACAO'  value='#arguments.DATA_FINALIZACAO#' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NOTA_FISCAL'  value='#arguments.NUM_NOTA_FISCAL#'  null='#iif(len(trim(arguments.NUM_NOTA_FISCAL)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5' dbvarname='P_SERIE'  value='#arguments.SERIE#'  null='#iif(len(trim(arguments.SERIE)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5' dbvarname='P_DATA_EMISSAO_NF'  value='#arguments.DATA_EMISSAO_NF#'  null='#iif(len(trim(arguments.DATA_EMISSAO_NF)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_REM'  value='#arguments.COD_PESSOA_REM#'  null='#iif(len(trim(arguments.COD_PESSOA_REM)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_DEST'  value='#arguments.COD_PESSOA_DEST#'  null='#iif(len(trim(arguments.COD_PESSOA_DEST)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MUNICIPIO_ID_ORIGEM'  value='#arguments.MUNICIPIO_ID_ORIGEM#'  null='#iif(len(trim(arguments.MUNICIPIO_ID_ORIGEM)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MUNICIPIO_ID_DESTINO'  value='#arguments.MUNICIPIO_ID_DEST#'  null='#iif(len(trim(arguments.MUNICIPIO_ID_DEST)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera uma pendncia operacional
	-- ANDERSONC 26/04/2012 14:51:17 - CRIADO
	--->
	<cffunction name='upd_pendencia_operacional' displayname='Altera uma pendncia operacional' access='remote' returntype='Struct' output='true'>
		<cfargument name='PENDENCIA_OPERACIONAL_ID' required='yes'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cfargument name='DATA_OCORRENCIA' required='yes'>
		<cfargument name='OCORRENCIA' required='yes'>
		<cfargument name='SOLUCAO_APONTADA' required='yes'>
		<cfargument name='STATUS_PENDENCIA_ID' required='yes'>
		<cfargument name='RESPONSAVEL' required='yes'>
		<cfargument name='FONE_DDD' required='yes'>
		<cfargument name='FONE_PREFIXO' required='yes'>
		<cfargument name='FONE_NUMERO' required='yes'>
		<cfargument name='DATA_FINALIZACAO' required='yes'>
		<cfargument name='NUM_NOTA_FISCAL' required='yes'>
		<cfargument name='SERIE' required='yes'>
		<cfargument name='DATA_EMISSAO_NF' required='yes'>
        <cfargument name='COD_PESSOA_REM' required='yes'>
        <cfargument name='COD_PESSOA_DEST' required='yes'>
        <cfargument name='MUNICIPIO_ID_DEST' required='yes'>
        <cfargument name='MUNICIPIO_ID_ORIGEM' required='yes'>
		<cftry>
            <cfstoredproc procedure='oper.pkg_avaria.prc_alt_pendencia_operacional' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PENDENCIA_OPERACIONAL_ID'  value='#arguments.PENDENCIA_OPERACIONAL_ID#'  null='#iif(len(trim(arguments.PENDENCIA_OPERACIONAL_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_OCORRENCIA'  value='#arguments.DATA_OCORRENCIA#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OCORRENCIA'  value='#arguments.OCORRENCIA#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SOLUCAO_APONTADA'  value='#arguments.SOLUCAO_APONTADA#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_STATUS_PENDENCIA_ID'  value='#arguments.STATUS_PENDENCIA_ID#'  null='#iif(len(trim(arguments.STATUS_PENDENCIA_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RESPONSAVEL'  value='#arguments.RESPONSAVEL#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_FONE_DDD'  value='#arguments.FONE_DDD#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_FONE_PREFIXO'  value='#arguments.FONE_PREFIXO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_FONE_NUMERO'  value='#arguments.FONE_NUMERO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_FINALIZACAO'  value='#arguments.DATA_FINALIZACAO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NOTA_FISCAL'  value='#arguments.NUM_NOTA_FISCAL#'  null='#iif(len(trim(arguments.NUM_NOTA_FISCAL)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SERIE'  value='#arguments.SERIE#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMISSAO_NF'  value='#arguments.DATA_EMISSAO_NF#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_REM'  value='#arguments.COD_PESSOA_REM#'  null='#iif(len(trim(arguments.COD_PESSOA_REM)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_DEST'  value='#arguments.COD_PESSOA_DEST#'  null='#iif(len(trim(arguments.COD_PESSOA_DEST)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MUNICIPIO_ID_ORIGEM'  value='#arguments.MUNICIPIO_ID_ORIGEM#'  null='#iif(len(trim(arguments.MUNICIPIO_ID_ORIGEM)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MUNICIPIO_ID_DESTINO'  value='#arguments.MUNICIPIO_ID_DEST#'  null='#iif(len(trim(arguments.MUNICIPIO_ID_DEST)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui uma pendncia operacional
	-- ANDERSONC 26/04/2012 14:52:09 - CRIADO
	--->
	<cffunction name='del_pendencia_operacional' displayname='Exclui uma pendncia operacional' access='remote' returntype='Struct' output='true'>
		<cfargument name='PENDENCIA_OPERACIONAL_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='oper.pkg_avaria.prc_del_pendencia_operacional' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PENDENCIA_OPERACIONAL_ID'  value='#arguments.PENDENCIA_OPERACIONAL_ID#'  null='#iif(len(trim(arguments.PENDENCIA_OPERACIONAL_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
</cfcomponent>