<cfcomponent extends="_transportes.funcoes.cfc_init">
	<cftry>
		<!--- delete na tabela de acesso corrente --->
		<cfquery datasource="#this.dsn#" username="#this.usuario#" password="#this.senha#">
			delete from kss.pessoa_usuario_acesso_cur c
			 where c.usuario = user
		</cfquery>
		<!--- insert na tabela de acesso corrente --->
		<cfquery datasource="#this.dsn#" username="#this.usuario#" password="#this.senha#">
			insert into kss.pessoa_usuario_acesso_cur
				 select cod_pessoa, user 
				   from kss.pessoa_unidade_negocio 
				  where cod_unidade_negocio > 0
					and cod_unidade_negocio is not null
		</cfquery>	
		
		<cfcatch type="any"></cfcatch>
		
	</cftry>	
	
	<!--- 
	-- PROPSITO
	-- Insere um arquivo
	-- CRISTOFER 02/07/2005 - criado
	--->			
	<cffunction name="ins_controle_arquivo" displayname="Cadastro de Arquivos"access="remote" returntype="Struct" output="true">
		<cfargument name="cod_arquivo" required="yes">
		<cfargument name="caption_formulario" required="yes">
		<cfargument name="nome_formulario" required="yes">
		<cfargument name="nome_arquivo" required="yes">
		<cfargument name="descricao_formulario" required="yes">
		<cfargument name="funcionalidade_arquivo" required="yes">
		<cfargument name="codigo_sequencial" required="yes">
		<cfargument name="grupo" required="yes">
		<cfargument name="alias" required="yes">
		<cfargument name="cod_projeto" required="yes">
		<cftry>
			<cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				insert into internet.v$controle_arquivos
				  (cod_arquivo, caption_formulario, nome_formulario, 
				  nome_arquivo, descricao_formulario, funcionalidade_arquivo, 
				  codigo_sequencial, grupo, alias, cod_projeto)
				values
				  ('#arguments.cod_arquivo#', '#arguments.caption_formulario#', '#arguments.nome_formulario#', 
				  '#arguments.nome_arquivo#', '#arguments.descricao_formulario#', '#arguments.funcionalidade_arquivo#', 
				  '#arguments.codigo_sequencial#', '#arguments.grupo#', '#arguments.alias#', '#arguments.cod_projeto#')
			</cfquery>
			<cfset retorno.erro 	= false />
			<cfset retorno.mensagem = JSStringFormat("Arquivo cadastrado com sucesso!")/>
			
			<cfcatch type="database">
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />		
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Altera um arquivo
	-- CRISTOFER 03/07/2005 - criado
	--->			
	<cffunction name="upd_controle_arquivo" displayname="Cadastro de Arquivos"access="remote" returntype="Struct" output="true">
		<cfargument name="cod_arquivo" required="yes">
		<cfargument name="caption_formulario" required="yes">
		<cfargument name="nome_formulario" required="yes">
		<cfargument name="nome_arquivo" required="yes">
		<cfargument name="descricao_formulario" required="yes">
		<cfargument name="funcionalidade_arquivo" required="yes">
		<cfargument name="codigo_sequencial" required="yes">
		<cfargument name="grupo" required="yes">
		<cfargument name="alias" required="yes">
		<cfargument name="cod_projeto" required="yes">
		<cftry>
			<cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				 update internet.v$controle_arquivos
					set caption_formulario = '#arguments.caption_formulario#', 
						nome_formulario = '#arguments.nome_formulario#', 
						nome_arquivo = '#arguments.nome_arquivo#', 
						descricao_formulario = '#arguments.descricao_formulario#', 
						funcionalidade_arquivo = '#arguments.funcionalidade_arquivo#',
						codigo_sequencial = '#arguments.codigo_sequencial#', 
						grupo = '#arguments.grupo#', 
						alias = '#arguments.alias#'
				  where cod_arquivo = '#arguments.cod_arquivo#' 
				    and cod_projeto = '#arguments.cod_projeto#' 
			</cfquery>
			<cfset retorno.erro 	= False />
			<cfset retorno.mensagem = JSStringFormat("Arquivo alterado com sucesso!")/>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />		
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Exclui um arquivo
	-- CRISTOFER 03/07/2005 - criado
	--->			
	<cffunction name="del_controle_arquivo" displayname="Cadastro de Arquivos"access="remote" returntype="Struct" output="true">
		<cfargument name="cod_arquivo" required="yes">
		<cfargument name="cod_projeto" required="yes">
		<cftry>
			<cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				delete internet.v$controle_arquivos
						where cod_arquivo = '#arguments.cod_arquivo#' 
						  and cod_projeto = '#arguments.cod_projeto#' 
			</cfquery>
			<cfset retorno.erro 	= False />
			<cfset retorno.mensagem = JSStringFormat("Arquivo excludo com sucesso!")/>
			<cfcatch type="database">
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />		
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Insere um Diretrio do Servidor
	-- JEFFERSON 04/11/2003 - criado
	--->			
	<cffunction name="ins_diretorio_servidor" access="remote" returntype="Struct" output="true">
		<cfargument name="cod_projeto" required="yes" />
		<cfargument name="cod_aplicacao" required="yes" />
		<cfargument name="dir" required="yes" />
		<cfargument name="descricao" required="yes" />
		<cftry>
			<cfstoredproc procedure="atualizador.pkg_gerenciador_arquivos.prc_ins_diretorio_servidor" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				<cfprocparam dbvarname="p_cod_projeto" type="in" value="#arguments.cod_projeto#" cfsqltype="cf_sql_integer" />
				<cfprocparam dbvarname="p_cod_aplicacao" type="in" value="#arguments.cod_aplicacao#" cfsqltype="cf_sql_varchar" />
				<cfprocparam dbvarname="p_dir" type="in" value="#arguments.dir#" cfsqltype="cf_sql_varchar" />
				<cfprocparam dbvarname="p_descricao" type="in" value="#arguments.descricao#" cfsqltype="cf_sql_varchar" />
			</cfstoredproc>							
			<cfset retorno.erro = False />
			<cfset retorno.mensagem	= 'Diret'&chr(243)&'rio do servidor inserido com sucesso!'/>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>				 
		</cftry>
		<cfreturn retorno />		
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Atualiza diretrio do servidor
	-- JEFFERSON 04/11/2003 - criado
	--->			
	<cffunction name="upd_diretorio_servidor" access="remote" returntype="Struct" output="true">
		<cfargument name="cod_projeto" required="yes" />
		<cfargument name="cod_aplicacao" required="yes" />
		<cfargument name="dir" required="yes" />
		<cfargument name="descricao" required="yes" />
		<cftry>
			<cfstoredproc procedure="atualizador.pkg_gerenciador_arquivos.prc_upd_diretorio_servidor" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				<cfprocparam dbvarname="p_cod_projeto" type="in" value="#val( arguments.cod_projeto )#" cfsqltype="cf_sql_integer" />
				<cfprocparam dbvarname="p_cod_aplicacao" type="in" value="#arguments.cod_aplicacao#" cfsqltype="cf_sql_varchar" />
				<cfprocparam dbvarname="p_dir"	type="in" value="#arguments.dir#" cfsqltype="cf_sql_varchar" />
				<cfprocparam dbvarname="p_descricao" type="in" value="#arguments.descricao#" cfsqltype="cf_sql_varchar" />
			</cfstoredproc>
			<cfset retorno.erro = False />
			<cfset retorno.mensagem	= 'Diret'&chr(243)&'rio do servidor alterado com sucesso!' />
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>				 
		</cftry>
		<cfreturn retorno />		
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Deleta Diretrio do usurio
	-- JEFFERSON 04/11/2003 - criado
	--->			
	<cffunction name="del_diretorio_servidor" access="remote" returntype="Struct" output="true">
		<cfargument name="cod_projeto" required="yes" />
		<cfargument name="cod_aplicacao" required="yes" />
		<cfargument name="dir" required="yes" />
		<cftry>
			<cfstoredproc procedure="atualizador.pkg_gerenciador_arquivos.prc_del_diretorio_servidor" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				<cfprocparam dbvarname="p_cod_projeto" type="in" value="#val( arguments.cod_projeto )#" cfsqltype="cf_sql_integer" />
				<cfprocparam dbvarname="p_cod_aplicacao" type="in" value="#arguments.cod_aplicacao#" cfsqltype="cf_sql_varchar" />
				<cfprocparam dbvarname="p_dir" type="in" value="#arguments.dir#" cfsqltype="cf_sql_varchar" />
			</cfstoredproc>
			<cfset retorno.erro = False />
			<cfset retorno.mensagem	= 'Diret'&chr(243)&'rio do servidor excluido com sucesso!'/>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>				 
		</cftry>
		<cfreturn retorno />		
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Insere Diretrio do Usurio
	-- JEFFERSON 04/11/2003 - criado
	--->			
	<cffunction name="ins_diretorio_usuario" access="remote" returntype="Struct" output="true">
		<cfargument name="cod_projeto" required="yes" />
		<cfargument name="cod_aplicacao" required="yes" />
		<cfargument name="tecnico_suporte" required="yes" />
		<cfargument name="dir_raiz" required="yes" />
		<cftry>
			<cfstoredproc procedure="atualizador.pkg_gerenciador_arquivos.prc_ins_diretorio_usuario" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				<cfprocparam dbvarname="p_cod_projeto" type="in" value="#val( arguments.cod_projeto )#" cfsqltype="cf_sql_integer" />
				<cfprocparam dbvarname="p_cod_aplicacao" type="in" value="#arguments.cod_aplicacao#" cfsqltype="cf_sql_varchar" />
				<cfprocparam dbvarname="p_usuario" type="in" value="#arguments.tecnico_suporte#" cfsqltype="cf_sql_varchar" />
				<cfprocparam dbvarname="p_dir_raiz" type="in" value="#arguments.dir_raiz#" cfsqltype="cf_sql_varchar" />
			</cfstoredproc>							
			<cfset retorno.erro 	= False />
			<cfset retorno.mensagem = 'Diret'&chr(243)&'rio do usu'&chr(225)&'rio foi inserido com sucesso!' />
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />		
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Altera diretorio do usurio
	-- JEFFERSON 04/11/2003 - criado
	--->			
	<cffunction name="upd_diretorio_usuario" access="remote" returntype="Struct" output="true">
		<cfargument name="cod_projeto"  required="true" displayname="Cdigo do Projeto" type="numeric"	/>
		<cfargument name="cod_aplicacao" required="true" displayname="Cdigo da Aplicao" type="string"/>
		<cfargument name="tecnico_suporte" required="true" 	displayname="Nome do Usurio" type="string"/>
		<cfargument name="dir_raiz" required="true" displayname="Diretrio Raiz " type="string"/>
		<cftry>
			<cfstoredproc procedure="atualizador.pkg_gerenciador_arquivos.prc_upd_diretorio_usuario" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				<cfprocparam dbvarname="p_cod_projeto" type="in" 	value="#arguments.cod_projeto#" cfsqltype="cf_sql_integer" />
				<cfprocparam dbvarname="p_cod_aplicacao" type="in" 	value="#arguments.cod_aplicacao#" cfsqltype="cf_sql_varchar" />
				<cfprocparam dbvarname="p_usuario"	type="in" 	value="#arguments.tecnico_suporte#" cfsqltype="cf_sql_varchar" />
				<cfprocparam dbvarname="p_dir_raiz"	type="in" 	value="#arguments.dir_raiz#" cfsqltype="cf_sql_varchar" />
			</cfstoredproc>
			<cfset retorno.mensagem	= 'Diret'&chr(243)&'rio do usu'&chr(225)&'rio alterado com sucesso!' />
			<cfset retorno.erro	= False />
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>				 
		</cftry>
		<cfreturn retorno />		
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Exclui Diretrio do usurio
	-- JEFFERSON 04/11/2003 - criado
	--->			
	<cffunction name="del_diretorio_usuario" access="remote" returntype="Struct" output="true">
		<cfargument name="cod_projeto" required="true" displayname="Cdigo do Projeto" type="numeric"	/>
		<cfargument name="cod_aplicacao" required="true" displayname="Cdigo da Aplicao" type="string"/>
		<cfargument name="tecnico_suporte"	required="true" displayname="Nome do Usurio" type="string"/>
		<cfargument name="dir_raiz"	required="false" displayname="Diretrio Raiz" type="string" default=""/>
		<cftry>
			<cfstoredproc procedure="atualizador.pkg_gerenciador_arquivos.prc_del_diretorio_usuario" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				<cfprocparam dbvarname="p_cod_projeto" 	type="in" 	value="#val( arguments.cod_projeto )#" cfsqltype="cf_sql_integer" />
				<cfprocparam dbvarname="p_cod_aplicacao" type="in" 	value="#arguments.cod_aplicacao#" cfsqltype="cf_sql_varchar" />
				<cfprocparam dbvarname="p_tecnico_suporte" type="in" value="#arguments.tecnico_suporte#" cfsqltype="cf_sql_varchar" />
			</cfstoredproc>
			<cfset retorno.mensagem = 'Diret'&chr(243)&'rio do usu'&chr(225)&'rio excluido com sucesso!' />
			<cfset retorno.erro	= False />
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>				 
	  </cftry>
	  <cfreturn retorno />		
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Cadastra e-mail na tabela de notificaes para que esse e-mail possa receber um aviso de disponibilizao de nova verso de atualizao
	-- JEFFERSON  13/11/2003 - criado
	--->			
	<cffunction name="ins_email_notificacao" access="remote" returntype="Struct" output="true">
		<cfargument name="cod_projeto" required="yes" />
		<cfargument name="cod_aplicacao" required="yes" />
		<cfargument name="email"  required="yes" />
		<cftry>
			<cfstoredproc procedure="atualizador.pkg_gerenciador_arquivos.prc_ins_email_notificacao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam dbvarname="p_cod_projeto" type="in" value="#arguments.cod_projeto#" cfsqltype="cf_sql_integer" />
					<cfprocparam dbvarname="p_cod_aplicacao" type="in" value="#arguments.cod_aplicacao#" cfsqltype="cf_sql_varchar" />
					<cfprocparam dbvarname="p_username" type="in" value="#ListFirst( arguments.email, '@')#" cfsqltype="cf_sql_varchar" />
					<cfprocparam dbvarname="p_provedor" type="in" value="#ListLast( arguments.email, '@')#"  cfsqltype="cf_sql_varchar" />
			</cfstoredproc>							
			<cfset retorno.mensagem	= 'Email vinculado para receber notifica'& chr( 231 )& chr( 245 )&'es de atualiza'& chr( 231 )& chr( 227 )&'o com sucesso!'/>
			<cfset retorno.erro	= false />
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>	
		<cfreturn retorno/>
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Remove  e-mail da tabela de notificaes para que esse e-mail possa receber um aviso de disponibilizao de nova verso de atualizao
	-- JEFFERSON 13/11/2003 - criado
	--->			
	<cffunction name="del_email_notificacao" displayname="Deleta Email da Notificao" access="remote" returntype="Struct" output="true">
		<cfargument name="cod_projeto" required="true" />
		<cfargument name="cod_aplicacao" required="true" />
		<cfargument name="email" required="true" />
		<cfargument name="email_id" required="true" />
		<cftry>
			<cfstoredproc procedure="atualizador.pkg_gerenciador_arquivos.prc_del_email_notificacao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				<cfprocparam dbvarname="p_cod_projeto" type="in" value="#arguments.cod_projeto#" cfsqltype="cf_sql_integer" />
				<cfprocparam dbvarname="p_cod_aplicacao" type="in" value="#arguments.cod_aplicacao#" cfsqltype="cf_sql_varchar" />
				<cfprocparam dbvarname="p_email_id" type="in" value="#arguments.email_id#" cfsqltype="cf_sql_integer" />
			</cfstoredproc>							
			<cfset retorno.mensagem	= 'O Email ' & JsStringFormat( arguments.email ) & ' foi desvinculado para receber notifica'& chr( 231 )& chr( 245 )&'es de atualiza'& chr( 231 )& chr( 227 )&'o com sucesso !'/>
			<cfset retorno.erro = false />
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>	
		<cfreturn retorno/>
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere um Tipo de Arquivo
	-- JEFFERSON  04/11/2003 - criado
	--->			
	<cffunction name="ins_tipo_arquivo" access="remote" returntype="Struct" output="true">
		<cfargument name="cod_tipo_arquivo" required="yes" />
		<cfargument name="descricao" required="yes"	/>
		<cftry>
			<cfstoredproc procedure="atualizador.pkg_gerenciador_arquivos.prc_ins_tipo_arquivo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				<cfprocparam dbvarname="p_cod_tipo_arquivo" type="in" value="#arguments.cod_tipo_arquivo#" cfsqltype="cf_sql_varchar" />
				<cfprocparam dbvarname="p_descricao" type="in" 	value="#arguments.descricao#" cfsqltype="cf_sql_varchar" />
			</cfstoredproc>							
			<cfset retorno.erro  = False />
			<cfset retorno.mensagem = 'Tipo de Arquivo inserido com sucesso!' />
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>				 
		</cftry>
		<cfreturn retorno />		
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Altera um Tipo do Arquivo
	-- JEFFERSON 04/11/2003 - criado
	--->			
	<cffunction name="upd_tipo_arquivo" displayname="Atualiza Tipos de Arquivo"access="remote" returntype="Struct" output="true">
		<cfargument name="cod_tipo_arquivo"	required="yes" displayname="Cdigo do Tipo de Arquivo" type="string"/>
		<cfargument name="descricao" required="yes" displayname="Descrio do Tipo de Arquivo" type="string"/>
		<cftry>
			<cfstoredproc procedure="atualizador.pkg_gerenciador_arquivos.prc_upd_tipo_arquivo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				<cfprocparam dbvarname="p_cod_tipo_arquivo" type="in" value="#arguments.cod_tipo_arquivo#" cfsqltype="cf_sql_varchar" />
				<cfprocparam dbvarname="p_descricao" type="in" value="#arguments.descricao#"	cfsqltype="cf_sql_varchar" />
			</cfstoredproc>
			<cfset retorno.erro  = False />
			<cfset retorno.mensagem	= 'Tipo de Arquivo alterado com sucesso!' />
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>				 
		</cftry>
		<cfreturn retorno />		
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Deleta Tipo do Arquivo 
	-- JEFFERSON 04/11/2003 - criado
	--->			
	<cffunction name="del_tipo_arquivo" access="remote" returntype="Struct" output="true">
		<cfargument name="cod_tipo_arquivo" required="true" displayname="Cdigo do Tipo de Arquivo" type="string"/>
		<cfargument name="descricao" required="true" displayname="Descrio do Tipo de Arquivo" type="string" default=""/>
		<cftry>
			<cfstoredproc procedure="atualizador.pkg_gerenciador_arquivos.prc_del_tipo_arquivo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				<cfprocparam dbvarname="p_cod_tipo_arquivo" type="in" value="#arguments.cod_tipo_arquivo#" cfsqltype="cf_sql_varchar" />
			</cfstoredproc>
			<cfset retorno.erro  = False />
			<cfset retorno.mensagem	= 'Tipo de Arquivo excluido com sucesso!' />
			<cfcatch type="database">
					<cfset retorno.erro = true>
					<cfset retorno.mensagem = cfcatch>
					<cfset request.erro = cfcatch>
			</cfcatch>				 
		</cftry>
		<cfreturn retorno />		
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Vincula Tipo de arquivo com o diretrio do servidor
	-- JEFFERSON 04/11/2003 - criado
	--->			
	<cffunction name="ins_tipo_arquivo_diretorio_servidor" access="remote" returntype="Struct" output="true">
		<cfargument name="cod_projeto" required="yes" />
		<cfargument name="cod_aplicacao" required="yes" />
		<cfargument name="dir"	required="yes" />
		<cfargument name="cod_tipo_arquivo" required="yes" />
		<cftry>
			<cfloop index="j" from="1" to="#ListLen( arguments.cod_tipo_arquivo )#">
				<cfstoredproc procedure="atualizador.pkg_gerenciador_arquivos.prc_vnc_tipo_arquivo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam dbvarname="p_cod_projeto" type="in" value="#val( arguments.cod_projeto )#" cfsqltype="cf_sql_integer" />
					<cfprocparam dbvarname="p_cod_aplicacao" type="in" value="#arguments.cod_aplicacao#" cfsqltype="cf_sql_varchar" />
					<cfprocparam dbvarname="p_dir" 	type="in" value="#arguments.dir#" cfsqltype="cf_sql_varchar" />
					<cfprocparam dbvarname="p_cod_tipo_arquivo" type="in" value="#ListGetAt(arguments.cod_tipo_arquivo, j)#" cfsqltype="cf_sql_varchar" />
				</cfstoredproc>
			</cfloop>
			<cfset retorno.erro	= False />
			<cfset retorno.mensagem	= 'Tipo de arquivo vinculado ao diret' & chr( 243 ) & 'rio com sucesso!' />
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>				 
		</cftry>
		<cfreturn retorno />		
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Deleta Vnculo do Tipo do Arquivo com o Diretrio do Servidor 
	-- JEFFERSON 04/11/2003 - criado
	--->			
	<cffunction name="del_tipo_arquivo_diretorio_servidor" displayname="Deleta Vnculos do Tipo do Arquivo" access="remote" returntype="Struct" output="true">
		<cfargument name="cod_projeto" required="true" />
		<cfargument name="cod_aplicacao" required="true" />
		<cfargument name="dir"	required="true" />
		<cfargument name="cod_tipo_arquivo" required="true" />
		<cftry>
			<cfstoredproc procedure="atualizador.pkg_gerenciador_arquivos.prc_dvnc_tipo_arquivo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				<cfprocparam dbvarname="p_cod_projeto" type="in" value="#val( arguments.cod_projeto )#" cfsqltype="cf_sql_integer" />
				<cfprocparam dbvarname="p_cod_aplicacao" type="in" value="#arguments.cod_aplicacao#" cfsqltype="cf_sql_varchar" />
				<cfprocparam dbvarname="p_dir" 	type="in" value="#arguments.dir#" cfsqltype="cf_sql_varchar" />
				<cfprocparam dbvarname="p_cod_tipo_arquivo" type="in" value="#arguments.cod_tipo_arquivo#" cfsqltype="cf_sql_varchar" />
			</cfstoredproc>
			<cfset retorno.erro	= False />
			<cfset retorno.mensagem	= 'Tipo de Arquivo desvinculado do diret'& chr( 243 )&'rio do servidor com sucesso!' />
			<cfcatch type="database">
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>				 
		</cftry>
		<cfreturn retorno />		
	 </cffunction>	

	<!--- 
	-- PROPSITO
	-- Envia mensagem de Verificao para os usurios cadastrados
	-- JEFFERSON          04/11/2003 - criado
	--->			
	<cffunction name="envia_verificacao" access="Remote" returntype="Struct" output="false">
		<cfargument name="cod_projeto" 		required="yes" />
		<cfargument name="cod_aplicacao" 	required="yes" />
		<cfargument name="email" 			required="yes" />
		<cftry>
			<cfstoredproc procedure="atualizador.pkg_gerenciador_arquivos.prc_notifica_atualizacao" datasource="#this.dsn#" username="#this.usuario#" password="#this.senha#">
				<cfprocparam 	dbvarname="p_destinatario" 	  	type="in" 	 value="#arguments.email#" 				cfsqltype="cf_sql_varchar" />
				<cfprocparam 	dbvarname="p_cod_projeto" 		type="in"  	 value="#val( arguments.cod_projeto )#" 	cfsqltype="cf_sql_integer" />
				<cfprocparam 	dbvarname="p_cod_aplicacao" 	type="in" 	 value="#arguments.cod_aplicacao#" 		cfsqltype="cf_sql_varchar" />
			</cfstoredproc>
			<cfset retorno.erro = false />
			<cfset retorno.mensagem = 'Notificao enviada com sucesso!'>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>	
		<cfreturn retorno />
	</cffunction>	
</cfcomponent>