<!-- KM&M Componentes -->
<cfcomponent displayname="Manipulao da rea de Funcionarios" extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO 
	-- Insere um recado a um motorista
	-- CRISTOFER  21/02/2006
	--->
	<cffunction name="ins_recado" displayname="" access="remote" returntype="struct" output="true">
		<cfargument name="cod_funcionario" 	required="yes">
		<cfargument name="recado" 			required="yes">
		<cfargument name="data_inicio" 		required="no" default="">
		<cfargument name="data_fim" 		required="no" default="">		
		<cfargument name="extrato" 			required="no" default="0">
		<cftry>
			<cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				<cfif arguments.extrato eq 0>
					insert into oper.v$motorista_recado
					  (recado_id, cod_pessoa, recado, ativo, extrato)
					values
					  (0, oper.pkg_global.fnc_get_cod_pessoa_func(#arguments.cod_funcionario#), '#arguments.recado#', 1, 0)
				<cfelse>
					insert into oper.v$motorista_recado
					  (recado_id, cod_pessoa, recado, data_inicio, data_fim, ativo, extrato)
					values
					  (0, oper.pkg_global.fnc_get_cod_pessoa_func(#arguments.cod_funcionario#), '#arguments.recado#', '#arguments.data_inicio#', '#arguments.data_fim#', 1, 1)
				</cfif>
			</cfquery>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Recado inserido com sucesso!">
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Altera dados do pedido de reserva
	-- CRISTOFER  22/02/2006
	--->	
	<cffunction name="alt_pedido_reserva" displayname="" access="remote" returntype="struct" output="true">
		<cfargument	name="controle_evo_id" required="yes">
		<cfargument	name="cod_pessoa" required="yes">
		<cfargument name="data_previsao" required="no" default="">
		<cfargument name="data_previsao_retorno" required="no" default="">
		<cfargument name="local_troca" required="no" default="">
		<cfargument name="situacao" required="no" default="">
		<cftry>
			<cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				update oper.v$motorista_ped_reserva
				   set cod_pessoa_alocado = nvl(#arguments.cod_pessoa#,cod_pessoa_alocado),
					   data_previsao = nvl('#arguments.data_previsao#',data_previsao),
					   local_troca = nvl('#arguments.local_troca#',local_troca),
					   data_previsao_retorno = nvl('#arguments.data_previsao_retorno#',data_previsao_retorno),
					   situacao = nvl(#arguments.situacao#,situacao)
				 where controle_evo_id = #arguments.controle_evo_id#
   			</cfquery>
			<cfset retorno.Mensagem = 'Pedido de reserva atualizado com sucesso.' />
			<cfset retorno.erro = false />
			<cfcatch>
				<cfset retorno.erro = true />
				<cfset retorno.mensagem = cfcatch />
				<cfset request.erro = cfcatch />
			</cfcatch>		
		</cftry>		
		<cfreturn retorno>
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Altera um recado a um motorista
	-- CRISTOFER  21/02/2006
	--->	
	<cffunction name="upd_recado" displayname="Insere um recado a um motorista" access="remote" returntype="struct" output="true">
		<cfargument name="ATIVO" required="true">
		<cfargument name="RECADO_ID" required="true">
		<cfif Len(arguments.ATIVO) eq 0>
			<cfset arguments.ATIVO = 0>
		</cfif>
		<cftry>
			<cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				update oper.v$motorista_recado
				   set ativo = #arguments.ATIVO#
				  where recado_id = #arguments.RECADO_ID#
			</cfquery>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Recado alterado com sucesso!">
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Insere declarao de mltiplos vnculos de funcionrios.
	-- arlen 30/10/2006 10:25:36 - CRIADO
	--->
	<cffunction name='ins_rh_declaracao_mv' displayname='Insere declarao de mltiplos vnculos de funcionrios.' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_DECLARACAO' required='yes'>
		<cfargument name='NUM_RPA' required='yes'>
		<cfargument name='DATA' required='yes'>
		<cfargument name='SERVICO' required='yes'>
		<cfargument name='INSS' required='yes'>
		<cfargument name='IRRF' required='yes'>
		<cfargument name='COMENTARIOS' required='yes'>
		<cfargument name='IDENTIFICADOR' required='yes'>
		<cfargument name='NOME_PESSOA' required='yes'>
		<cfargument name='CARRETEIRO' required='no' default="0">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='rh.package_ci.prc_ins_rh_declaracao_mv' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_DECLARACAO'  value='#arguments.NUM_DECLARACAO#' variable='retorno.NUM_DECLARACAO'  null='#iif(len(trim(arguments.NUM_DECLARACAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_RPA'  value='#arguments.NUM_RPA#'  null='#iif(len(trim(arguments.NUM_RPA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA'  value='#arguments.DATA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SERVICO'  value='#arguments.SERVICO#'  null='#iif(len(trim(arguments.SERVICO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_INSS'  value='#arguments.INSS#'  null='#iif(len(trim(arguments.INSS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_IRRF'  value='#arguments.IRRF#'  null='#iif(len(trim(arguments.IRRF)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMENTARIOS'  value='#arguments.COMENTARIOS#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_IDENTIFICADOR'  value='#arguments.IDENTIFICADOR#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME_PESSOA'  value='#arguments.NOME_PESSOA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CARRETEIRO'  value='#arguments.CARRETEIRO#'  null='#iif(len(trim(arguments.CARRETEIRO)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Declarao de mltiplos vnculos inserida com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera declarao de mltiplos vnculos de funcionrios.
	-- arlen 30/10/2006 10:27:08 - CRIADO
	--->
	<cffunction name='alt_rh_declaracao_mv' displayname='Altera declarao de mltiplos vnculos de funcionrios.' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_DECLARACAO' required='yes'>
		<cfargument name='NUM_RPA' required='yes'>
		<cfargument name='DATA' required='yes'>
		<cfargument name='SERVICO' required='yes'>
		<cfargument name='INSS' required='yes'>
		<cfargument name='IRRF' required='yes'>
		<cfargument name='COMENTARIOS' required='yes'>
		<cfargument name='IDENTIFICADOR' required='yes'>
		<cfargument name='NOME_PESSOA' required='yes'>
		<cfargument name='CARRETEIRO' required='no' default="0">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='rh.package_ci.prc_alt_rh_declaracao_mv' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_DECLARACAO'  value='#arguments.NUM_DECLARACAO#'  null='#iif(len(trim(arguments.NUM_DECLARACAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_RPA'  value='#arguments.NUM_RPA#'  null='#iif(len(trim(arguments.NUM_RPA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA'  value='#arguments.DATA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SERVICO'  value='#arguments.SERVICO#'  null='#iif(len(trim(arguments.SERVICO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_INSS'  value='#arguments.INSS#'  null='#iif(len(trim(arguments.INSS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_IRRF'  value='#arguments.IRRF#'  null='#iif(len(trim(arguments.IRRF)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMENTARIOS'  value='#arguments.COMENTARIOS#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_IDENTIFICADOR'  value='#arguments.IDENTIFICADOR#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME_PESSOA'  value='#arguments.NOME_PESSOA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CARRETEIRO'  value='#arguments.CARRETEIRO#'  null='#iif(len(trim(arguments.CARRETEIRO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Declarao de mltiplos vnculos alterada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui declarao de mltiplos vnculos de funcionrios.
	-- arlen 30/10/2006 10:28:21 - CRIADO
	--->
	<cffunction name='del_rh_declaracao_mv' displayname='Exclui declarao de mltiplos vnculos de funcionrios.' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_DECLARACAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='rh.package_ci.prc_del_rh_declaracao_mv' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_DECLARACAO'  value='#arguments.NUM_DECLARACAO#'  null='#iif(len(trim(arguments.NUM_DECLARACAO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Declarao de mltiplos vnculos excluda com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere motorista em gerenciadora de risco.
	-- arlen 03/11/2006 15:33:17 - CRIADO
	--->
	<cffunction name='ins_g_risco_pessoa' displayname='Insere motorista em gerenciadora de risco.' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_GERENCIADORA' required='yes'>
		<cfargument name='NUMERO_CONTROLE' required='yes'>
		<cfargument name='COD_COBERTURA' required='yes'>
		<cfargument name='DATA_VERIFICACAO' required='yes'>
		<cfargument name='DATA_VENCIMENTO' required='yes'>
		<cfargument name='VALOR_MAXIMO' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
		<cfargument name='COD_PESSOA_FISICA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_gerenciadora_risco.prc_ins_g_risco_pessoa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_GERENCIADORA'  value='#arguments.COD_GERENCIADORA#'  null='#iif(len(trim(arguments.COD_GERENCIADORA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUMERO_CONTROLE'  value='#arguments.NUMERO_CONTROLE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_COBERTURA'  value='#arguments.COD_COBERTURA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_TIMESTAMP' dbvarname='P_DATA_VERIFICACAO'  value='#DateFormat(arguments.DATA_VERIFICACAO, "dd/mm/yyyy")# #TimeFormat(arguments.DATA_VERIFICACAO, "HH:MM:ss")#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_TIMESTAMP' dbvarname='P_DATA_VENCIMENTO'  value='#DateFormat(arguments.DATA_VENCIMENTO, "dd/mm/yyyy")# #TimeFormat(arguments.DATA_VENCIMENTO, "HH:MM:ss")#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_MAXIMO'  value='#arguments.VALOR_MAXIMO#'  null='#iif(len(trim(arguments.VALOR_MAXIMO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_FISICA'  value='#arguments.COD_PESSOA_FISICA#' variable='retorno.COD_PESSOA_FISICA'  null='#iif(len(trim(arguments.COD_PESSOA_FISICA)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Motorista inserido em gerenciadora de risco com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera motorista cadastrado em gerenciadora de risco.
	-- arlen 03/11/2006 15:24:42 - CRIADO
	--->
	<cffunction name='alt_g_risco_pessoa' displayname='Altera motorista cadastrado em gerenciadora de risco.' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_PESSOA_FISICA' required='yes'>
		<cfargument name='COD_GERENCIADORA' required='yes'>
		<cfargument name='NUMERO_CONTROLE' required='yes'>
		<cfargument name='COD_COBERTURA' required='yes'>
		<cfargument name='DATA_VERIFICACAO' required='yes'>
		<cfargument name='DATA_VERIFICACAO_OLD' required='no' default="">
		<cfargument name='DATA_VENCIMENTO' required='yes'>
		<cfargument name='VALOR_MAXIMO' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_gerenciadora_risco.prc_alt_g_risco_pessoa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_FISICA'  value='#arguments.COD_PESSOA_FISICA#'  null='#iif(len(trim(arguments.COD_PESSOA_FISICA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_GERENCIADORA'  value='#arguments.COD_GERENCIADORA#'  null='#iif(len(trim(arguments.COD_GERENCIADORA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUMERO_CONTROLE'  value='#arguments.NUMERO_CONTROLE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_COBERTURA'  value='#arguments.COD_COBERTURA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_VERIFICACAO'  value='#arguments.DATA_VERIFICACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_VENCIMENTO'  value='#arguments.DATA_VENCIMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_MAXIMO'  value='#arguments.VALOR_MAXIMO#'  null='#iif(len(trim(arguments.VALOR_MAXIMO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OLD_DATA_VERIFICACAO'  value='#arguments.DATA_VERIFICACAO_OLD#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Motorista alterado em gerenciadora de risco com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui motorista cadastrado em gerenciadora de risco.
	-- arlen 03/11/2006 15:26:02 - CRIADO
	--->
	<cffunction name='del_g_risco_pessoa' displayname='Exclui motorista cadastrado em gerenciadora de risco.' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_PESSOA_FISICA' required='yes'>
		<cfargument name='COD_GERENCIADORA' required='yes'>
		<cfargument name='DATA_VERIFICACAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_gerenciadora_risco.prc_del_g_risco_pessoa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_FISICA'  value='#arguments.COD_PESSOA_FISICA#'  null='#iif(len(trim(arguments.COD_PESSOA_FISICA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_GERENCIADORA'  value='#arguments.COD_GERENCIADORA#'  null='#iif(len(trim(arguments.COD_GERENCIADORA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_VERIFICACAO'  value='#arguments.DATA_VERIFICACAO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Motorista excludo de gerenciadora de risco com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

    <cffunction name="set_liberacao_holerite" displayname="Registra a impresso do holerite" access="remote" output="false" returntype="struct">
    <cfargument name="usuario" displayname="usuario" required="yes" type="string">
    <cfargument name="cod_funcionario" displayname="Cdigo do funcionario" required="yes" type="numeric">
    <cftry>
        <cftransaction action='begin'>
            <cfquery name="qr_liberado" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                    select 'x'
                      from oper.liberacao_holerite
                     where usuario = '#arguments.usuario#'
                       and cod_funcionario = #arguments.cod_funcionario#
            </cfquery>

            <cfif qr_liberado.recordcount eq 0>
                    <cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                            insert into oper.liberacao_holerite
                              (cod_funcionario, usuario)
                            values
                              (#arguments.cod_funcionario#, '#arguments.usuario#')
                    </cfquery>
            </cfif>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = 'Liberao efetuada com sucesso.'>
        </cftransaction>
        <cfcatch>
            <cftransaction action='rollback'/>
            <cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
            <cfset request.erro = cfcatch>
        </cfcatch>
    </cftry>
    <cfreturn retorno />
    </cffunction>

   <cffunction name="del_liberacao_holerite" displayname="Registra a impresso do holerite" access="remote" output="false">
    <cfargument name="usuario" displayname="usuario" required="yes" type="string">
    <cfargument name="cod_funcionario" displayname="Cdigo do funcionario" required="yes" type="numeric">
    <cftry>
        <cftransaction action='begin'>
            <cfquery datasource="#application.dsn#" username="#session.usuario#" password="#session.senha#">
                    delete oper.liberacao_holerite
                     where cod_funcionario = #arguments.cod_funcionario#
                       and usuario = '#arguments.usuario#'
            </cfquery>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = 'Liberao cancelada com sucesso.'>
        </cftransaction>
        <cfcatch>
            <cftransaction action='rollback'/>
            <cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
            <cfset request.erro = cfcatch>
        </cfcatch>
    </cftry>
    <cfreturn retorno />
    </cffunction>
	
    <!--- 
	-- PROPSITO
	-- Inserir o histrico pessoal do motorista
	-- RAFAEL 02/03/2010 17:36:45 - CRIADO
	--->
	<cffunction name='prc_ins_historico_pessoal' displayname='Inserir o histrico pessoal do motorista' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_TIPO_HISTORICO' required='yes'>
		<cfargument name='COD_FUNCIONARIO' required='yes'>
		<cfargument name='DATA_HISTORICO' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
        <cfargument name='LANCTO_ID' required='yes'>
		<cftry>
				<cfstoredproc procedure='rh.package_rh.prc_ins_historico_pessoal' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_TIPO_HISTORICO'  value='#arguments.COD_TIPO_HISTORICO#'  null='#iif(len(trim(arguments.COD_TIPO_HISTORICO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_FUNCIONARIO'  value='#arguments.COD_FUNCIONARIO#'  null='#iif(len(trim(arguments.COD_FUNCIONARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_HISTORICO'  value='#arguments.DATA_HISTORICO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LANCTO_ID'  value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
</cfcomponent>