<!-- KM&M Componentes -->
<cfcomponent displayname="Manipulao da rea de pneus" extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO
	-- Confirma o Recebimento de documentos
	-- CRISTOFER 11/04/2006
	--->
	<cffunction name="confirma_chegada_documentos" displayname="Confirma o Recebimento de documentos" access="remote" returntype="struct" output="true">
		<cfargument name="lancto_id" required="true">
		<cfargument name="documento_id" required="true">
		<cfargument name="cod_etapa" required="true">
		<cftry>		
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_fluxo_documentos.prc_confirma_recebimento" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_lancto_id" value="#arguments.lancto_id#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_documento_id" value="#arguments.documento_id#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_cod_etapa" value="#arguments.cod_etapa#">
			</cfstoredproc>
			<cfset retorno.erro = false>		
			<cfset retorno.mensagem = 'Recebimento confirmado com sucesso!'>		
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Confirma o Recebimento de documentos
	-- CRISTOFER 07/04/2006
	--->
	<cffunction name="envia_documentos" displayname="Confirma o Recebimento de documentos" access="remote" returntype="struct" output="true">
		<cfargument name="lancto_id" required="true">
		<cfargument name="cod_pessoa" required="true">
		<cfargument name="cod_departamento" required="true">
		<cfargument name="cod_setor" required="true">
		<cfargument name="cod_centro_custo" required="true">
		<cfargument name="posto" required="false" default="0">
		<cftry>
			<cfquery datasource="#session.dsn#" name="qr_doctos" username="#session.usuario#" password="#session.senha#">
				select documento_id 
				  from oper.v$fluxo_docto_it
				 where lancto_id = #arguments.lancto_id#
				   and cod_etapa = 'A'
				   and situacao_id = 0
			</cfquery>
			<cfoutput query="qr_doctos">
				<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_fluxo_documentos.prc_envia_documentos" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_lancto_id" value="#arguments.lancto_id#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_documento_id" value="#qr_doctos.documento_id#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_cod_etapa" value="A">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_pessoa" value="#arguments.cod_pessoa#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_departamento" value="#arguments.cod_departamento#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_setor" value="#arguments.cod_setor#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_centro_custo" value="#arguments.cod_centro_custo#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_posto" value="#arguments.posto#">
				</cfstoredproc>
			</cfoutput>
			<cfset retorno.erro = false>		
			<cfset retorno.mensagem = 'Documentos enviados com sucesso.'>		
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Exclui um docto do fluxo
	-- CRISTOFER 11/04/2006
	--->
	<cffunction name="exclui_docto" displayname="Exclui um docto do fluxo" access="remote" returntype="struct" output="true">
		<cfargument name="lancto_id" required="true">
		<cfargument name="documento_id" required="true">
		<cftry>
			<cfquery datasource="#session.dsn#" name="qr_doctos" username="#session.usuario#" password="#session.senha#">
				delete oper.v$fluxo_docto_it
				 where lancto_id = #arguments.lancto_id#
				   and documento_id = #arguments.documento_id#
			</cfquery>
			<cfset retorno.erro = false>		
			<cfset retorno.mensagem = 'Documento excludo com sucesso!'>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um item do fluxo
	-- CRISTOFER 11/04/2006
	--->
	<cffunction name="exclui_item" displayname="Exclui um item do fluxo" access="remote" returntype="struct" output="true">
		<cfargument name="lancto_id" required="true">
		<cfargument name="documento_id" required="true">
		<cfargument name="cod_etapa" required="true">
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_fluxo_docto.prc_recusa_envio" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_lancto_id" value="#arguments.lancto_id#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_documento_id" value="#arguments.documento_id#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_cod_etapa" value="#arguments.cod_etapa#">
			</cfstoredproc>
			<cfset retorno.erro = false>		
			<cfset retorno.mensagem = 'Item excludo com sucesso!'>		
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Fecha o Fluxo mesmo que existam documentos pendentes
	-- CRISTOFER 11/04/2006
	--->
	<cffunction name="fecha_fluxo" displayname="Fecha o Fluxo mesmo que existam documentos pendentes" access="remote" returntype="struct" output="true">
		<cfargument name="lancto_id" required="true">
		<cfargument name="situacao_id" required="true">
		<cftry>
			<cfquery datasource="#session.dsn#" name="qr_doctos" username="#session.usuario#" password="#session.senha#">
				update oper.v$fluxo_docto
				   set situacao_id = #arguments.situacao_id#
				 where lancto_id = #arguments.lancto_id#
			</cfquery>
			<cfset retorno.erro = false>		
			<cfset retorno.mensagem = 'Fluxo fechado com sucesso! '>		
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Finaliza todo o fluxo
	-- CRISTOFER 11/04/2006
	--->
	<cffunction name="finaliza_fluxo" displayname="Finaliza todo o fluxo" access="remote" returntype="struct" output="true">
		<cfargument name="lancto_id" required="true">
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_fluxo_docto.prc_finaliza_fluxo" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_lancto_id" value="#arguments.lancto_id#">
			</cfstoredproc>
			<cfset retorno.erro = false>		
			<cfset retorno.mensagem = 'Fluxo fechado com sucesso!'>		
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Insere uma carta frete
	-- CRISTOFER 24/04/2006
	--->
	<cffunction name="ins_carta_frete" displayname="Insere Carta Frete" access="remote" returntype="struct" output="true">
		<cfargument name="item_id" required="yes">
		<cfargument name="num_romaneio" required="yes">
		<cfargument name="num_docto" required="yes">
		<cfargument name="lancto_id" required="yes">
		<cfargument name="data_emissao" required="yes">
		<cfargument name="peso" required="yes">
		<cfargument name="volume" required="yes">
		<cfargument name="m3" required="yes">
		<cfargument name="valor_unitario" required="yes">
		<cfargument name="frete_em" required="yes">
		<cfargument name="cod_unidade" required="yes">
		<cfargument name="valor_bruto" required="yes">
		<cfargument name="total_liquido" required="yes">
		<cfargument name="valor_agencia" required="yes">
		<cfargument name="valor_diferenca" required="yes">
		<cftry>
			<cftransaction action="begin">
				<cfif IsNumeric(arguments.num_docto) and arguments.num_docto eq 0>
					<cfthrow detail="Nmero do documento no pode ser ZERO. Caso no o possua escreva (sem docto), para facilitar a identificao."
						     message="Nmero do documento no pode ser ZERO. Caso no o possua escreva (sem docto), para facilitar a identificao."
							 errorcode="20000" type="Database">
				</cfif>
				<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_fluxo_docto.prc_insere_carta_frete" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_item_id" value="#arguments.item_id#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_num_romaneio" value="#arguments.num_romaneio#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_cod_documento" value="#arguments.num_docto#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_data_emissao" value="#arguments.data_emissao#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_peso" value="#arguments.peso#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_volume" value="#arguments.volume#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_m3" value="#arguments.m3#">
					<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="p_valor_unitario" value="#arguments.valor_unitario#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_frete_em" value="#arguments.frete_em#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_cod_unidade" value="#arguments.cod_unidade#">
					<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="p_valor_frete_bruto" value="#Replace(arguments.valor_bruto,',','')#">
					<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="p_valor_frete_liquido" value="#Replace(arguments.total_liquido,',','')#">
					<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="p_valor_agencia" value="#Replace(arguments.valor_agencia,',','')#">
					<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="p_valor_diferenca" value="#Replace(arguments.valor_diferenca,',','')#">
					<cfprocparam type="out" cfsqltype="cf_sql_integer" dbvarname="p_lancto_id" variable="retorno.lancto_id">
				</cfstoredproc>
				<cfquery datasource="#session.dsn#" name="qr_doctos" username="#session.usuario#" password="#session.senha#">
					update oper.v$fluxo_docto_it
					   set cod_pessoa_filial = #SESSION.COD_PESSOA#,
						   cod_departamento = #session.cod_departamento#,
						   cod_setor = #session.cod_setor#,
						   cod_centro_custo = #session.cod_centro_custo#,
						   data_entrega = '#DateFormat(Now(),'dd/mm/yyyy')# #TimeFormat(Now(),'HH:MM')#',
						   situacao_id = 1,
						   responsavel = user
					 where lancto_id = #arguments.lancto_id#
					   and documento_id = 3
					   and cod_etapa = 'M'
				</cfquery>		

				<cfstoredproc datasource="#session.dsn#" procedure="OPER.PKG_CARTA_FRETE.PRC_ALT_DESPACHO_ROO" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_num_romaneio" value="#arguments.num_romaneio#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_item_id" value="#arguments.item_id#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_lancto_id" value="#retorno.lancto_id#">
                </cfstoredproc>
                
                <!--- Insere Notas fiscais --->
				<cfscript>
                    v_nota_numero					= this.ListaToArray (lista = arguments, variavel = "NOTA_NUMERO_NOTAS_FISCAIS");
                    v_nota_data_emissao				= this.ListaToArray (lista = arguments, variavel = "NOTA_DATA_EMISSAO_NOTAS_FISCAIS");
                    v_nota_modelo					= this.ListaToArray (lista = arguments, variavel = "NOTA_MODELO_NOTAS_FISCAIS");
                    v_nota_serie					= this.ListaToArray (lista = arguments, variavel = "NOTA_SERIE_NOTAS_FISCAIS");
                    v_nota_sub_serie				= this.ListaToArray (lista = arguments, variavel = "NOTA_SUB_SERIE_NOTAS_FISCAIS");
                    v_nota_cfop						= this.ListaToArray (lista = arguments, variavel = "CFOP_NOTAS_FISCAIS");							
                </cfscript>
                
                <cfloop from="1" to="#ArrayLen(v_nota_numero)#" index="count">
                    <cfscript>
                        ret_nf = this.prc_ins_carta_frete_nf(NUMERO			= v_nota_numero[count],
                                                             LANCTO_ID		= retorno.lancto_id,
                                                             DATA_EMISSAO	= v_nota_data_emissao[count],
                                                             MODELO			= v_nota_modelo[count],
                                                             SERIE			= v_nota_serie[count],
                                                             SUB_SERIE		= v_nota_sub_serie[count],
                                                             VALOR_TOTAL	= '0.01',
                                                             CFOP			= v_nota_cfop[count]);
                    </cfscript>
                    <cfif ret_nf.erro>
                        <cfthrow object="#ret_nf.mensagem#">
                    </cfif>
                </cfloop>
                
                
                
				<cfset retorno.mensagem = 'Documento inserido com sucesso!'>				
				<cfset retorno.erro = false>						
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback">
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>					

	<cffunction name="ins_item_carta_frete" displayname="Insere uma item vinculado a carta frete" access="remote" returntype="struct" output="true">
		<cfargument name="lancto_id" displayname="Identificador do lanamento" required="true">
		<cfargument name="item_id" displayname="Identificador do item" required="true">
		<cfargument name="descricao" displayname="Descrio" required="true">
		<cfargument name="valor" displayname="Valor" required="true">
		<cfargument name="desconto" displayname="Desconto- FLAG" required="true">
		<cfargument name="compoe_frete" displayname="Compoe Frete- FLAG" required="true">
		<cfargument name="deb_cred_motorista" displayname="Compoe Frete- FLAG" required="true">
		<cftry>
			<cftransaction action="begin">
				<cfquery name="qr_lancado" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					select 'x'
					  from oper.v$carta_frete_item
					 where lancto_id  = #arguments.lancto_id#
					   and item_id = #arguments.item_id#
				</cfquery>			
				<cfif qr_lancado.RecordCount gt 0>
					<cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
						update oper.v$carta_frete_item
						   set valor = #arguments.valor#
						 where lancto_id  = #arguments.lancto_id#
						   and item_id = #arguments.item_id#
					</cfquery>
				<cfelse>
					<cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
						insert into oper.v$carta_frete_item
						  (lancto_id, item_id, descricao, valor, desconto, compoe_frete, deb_cred_motorista)
						values
						  (#arguments.lancto_id#, #arguments.item_id#, '#arguments.descricao#', #arguments.valor#, #arguments.desconto#, #arguments.compoe_frete#, #arguments.deb_cred_motorista#)
					</cfquery>			
				</cfif>
				<cfset retorno.erro = false>		
				<cfset retorno.mensagem = 'Item lanado com sucesso.'>		
			</cftransaction>					
			<cfcatch>
				<cftransaction action="rollback" />
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Altera uma carta frete
	-- CRISTOFER 24/04/2006
	--->
	<cffunction name="upd_carta_frete" displayname="Insere Carta Frete" access="remote" returntype="struct" output="true">
		<cfargument name="carta_frete_id" required="yes">
		<cfargument name="num_romaneio" required="yes">
		<cfargument name="lancto_id" required="yes">
		<cfargument name="data_emissao" required="yes">
		<cfargument name="peso" required="yes">
		<cfargument name="volume" required="yes">
		<cfargument name="m3" required="yes">
		<cfargument name="valor_unitario" required="yes">
		<cfargument name="valor_bruto" required="yes">
		<cfargument name="total_liquido" required="yes">
		<cfargument name="valor_agencia" required="yes">
		<cfargument name="valor_diferenca" required="yes">
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_fluxo_docto.prc_alt_carta_frete" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_carta_frete_id" value="#arguments.carta_frete_id#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_num_romaneio" value="#arguments.num_romaneio#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_data_emissao" value="#arguments.data_emissao#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_peso" value="#arguments.peso#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_volume" value="#arguments.volume#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_m3" value="#arguments.m3#">
					<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="p_valor_unitario" value="#arguments.valor_unitario#">
					<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="p_valor_frete_bruto" value="#Replace(arguments.valor_bruto,',','')#">
					<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="p_valor_frete_liquido" value="#Replace(arguments.total_liquido,',','')#">
					<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="p_valor_agencia" value="#Replace(arguments.valor_agencia,',','')#">
					<cfprocparam type="in" cfsqltype="cf_sql_float" dbvarname="p_valor_diferenca" value="#Replace(arguments.valor_diferenca,',','')#">
				</cfstoredproc>
		
				<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_fluxo_documentos.prc_recebe_doctos_motorista" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" dbvarname="p_lancto_id" cfsqltype="cf_sql_integer" value="#arguments.lancto_id#">
					<cfprocparam type="in" dbvarname="p_documento_id" cfsqltype="cf_sql_integer" value="3">
					<cfprocparam type="in" dbvarname="p_cod_etapa_atual" cfsqltype="cf_sql_varchar" value="M">
					<cfprocparam type="in" dbvarname="p_cod_pessoa" cfsqltype="cf_sql_integer" value="#session.cod_pessoa#">
					<cfprocparam type="in" dbvarname="p_cod_departamento" cfsqltype="cf_sql_integer" value="#session.cod_departamento#">
					<cfprocparam type="in" dbvarname="p_cod_setor" cfsqltype="cf_sql_integer" value="#session.cod_setor#">
					<cfprocparam type="in" dbvarname="p_cod_centro_custo" cfsqltype="cf_sql_integer" value="#session.cod_centro_custo#">
					<cfprocparam type="in" dbvarname="p_posto" cfsqltype="cf_sql_integer" value="0">
				</cfstoredproc>

				<cfset retorno.lancto_id = arguments.carta_frete_id>				
				<cfset retorno.mensagem = 'Documento inserido com sucesso!'>				
				<cfset retorno.erro = false>	
			</cftransaction>					
			<cfcatch>
				<cftransaction action="rollback" />
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>
	<!--- 
	-- PROPSITO
	-- Recebe os documentos do motorista
	-- CRISTOFER 12/04/2006
	--->	
	<cffunction name="recebe_doctos_motorista" displayname="Recebe os documentos do motorista" access="remote" returntype="struct" output="true">
 		<cfargument name="lancto_id" required="true">
		<cfargument name="documento_id" required="true">
		<cfargument name="cod_etapa" required="true">
		<cftry>
			<cfif arguments.documento_id neq 3>
				<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_fluxo_documentos.prc_recebe_doctos_motorista" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" dbvarname="p_lancto_id" cfsqltype="cf_sql_integer" value="#arguments.lancto_id#">
					<cfprocparam type="in" dbvarname="p_documento_id" cfsqltype="cf_sql_integer" value="#arguments.documento_id#">
					<cfprocparam type="in" dbvarname="p_cod_etapa_atual" cfsqltype="cf_sql_varchar" value="#arguments.cod_etapa#">
					<cfprocparam type="in" dbvarname="p_cod_pessoa" cfsqltype="cf_sql_integer" value="#session.cod_pessoa#">
					<cfprocparam type="in" dbvarname="p_cod_departamento" cfsqltype="cf_sql_integer" value="#session.cod_departamento#">
					<cfprocparam type="in" dbvarname="p_cod_setor" cfsqltype="cf_sql_integer" value="#session.cod_setor#">
					<cfprocparam type="in" dbvarname="p_cod_centro_custo" cfsqltype="cf_sql_integer" value="#session.cod_centro_custo#">
					<cfprocparam type="in" dbvarname="p_posto" cfsqltype="cf_sql_integer" value="0">
				</cfstoredproc>
			</cfif>
			<cfquery datasource="#session.dsn#" name="qr_carta_frete" username="#session.usuario#" password="#session.senha#">
				select count(*) possui_cf, fd.num_romaneio
				  from oper.v$fluxo_docto_it fi
				  inner join oper.v$fluxo_docto fd
				  on fi.lancto_id = fd.lancto_id
				 where fi.lancto_id = #arguments.lancto_id#
				   and fi.documento_id = 3
				   and fi.cod_etapa = 'M'
		         group by fd.num_romaneio
	   		</cfquery>
			
			<cfset retorno.documento = arguments.lancto_id>		
			<cfset retorno.possui_cf = qr_carta_frete.possui_cf>		
			<cfset retorno.num_romaneio = qr_carta_frete.num_romaneio>		
			<cfset retorno.erro = false>		
			<cfset retorno.mensagem = 'Coleta registrada com sucesso!'>		
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>	

	<cffunction name="recebe_documentos" displayname="Confirma o Recebimento de documentos" access="remote" returntype="struct" output="true">
		<cfargument name="lancto_id" required="true">
		<cfargument name="documento_id" required="true">
		<cftry>	
			<cftransaction action="begin"	>
				<cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					update oper.v$fluxo_docto_it
					   set situacao_id = 1,
						   data_entrega = sysdate
					 where lancto_id = #arguments.lancto_id#
					   and documento_id = #arguments.documento_id#
					   and cod_etapa = 'A'
					   and situacao_id = 0
				</cfquery>
				<cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					update oper.v$fluxo_docto_it
					   set data_recebimento = sysdate,
						   responsavel = user
					 where lancto_id = #arguments.lancto_id#
					   and documento_id = #arguments.documento_id#
					   and cod_etapa in ('F','MA')
					   and situacao_id = 0
				</cfquery>
				<cfset retorno.erro = false>		
				<cfset retorno.mensagem = 'Recebimento confirmado com sucesso!'>		
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback" />
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>	

	<!--- 
    -- PROPSITO
    -- Excluir fluxo
    -- guto 12/03/2009 17:32:46 - CRIADO
    --->
    <cffunction name='del_fluxo_docto' displayname='Excluir fluxo' access='remote' returntype='Struct' output='true'>
        <cfargument name='LANCTO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_fluxo_docto.prc_del_fluxo_docto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LANCTO_ID'  value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Fluxo excludo com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Vincula um fluxo de documento a um item de romaneio
    -- guto 13/03/2009 09:16:55 - CRIADO
    --->
    <cffunction name='vincula_fluxo_item_romaneio' displayname='Vincula um fluxo de documento a um item de romaneio' access='remote' returntype='Struct' output='true'>
        <cfargument name='LANCTO_ID' required='yes'>
        <cfargument name='NUM_ROMANEIO' required='yes'>
        <cfargument name='ITEM_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_fluxo_docto.prc_vincula_fluxo_item_rom' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LANCTO_ID'  value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Vinculo inserido com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Enviar documentos Mltiplos
	-- RAFAEL 30/11/2009 10:02:25 - CRIADO
	--->
	<cffunction name='envia_documentos_multiplo' displayname='Inserir/Vincular Anexos para Embarque / Programao Internacional' access='remote' returntype='Struct' output='true'>
		<cfargument name="doctos_enviar" required="true">
        	<cftry>
            <cfdump var="#arguments#" label="teste">
                <cftransaction action='begin'>
                	<cfdump var="#arguments#" label="transaction">
                	<cfloop list="#arguments.doctos_enviar#" delimiters="," index="lcto_id">
                    	<cfdump var="#lcto_id#" label="loop">
                        <cfquery datasource="#session.dsn#" name="qr_doctos" username="#session.usuario#" password="#session.senha#">
                            select documento_id 
                              from oper.v$fluxo_docto_it
                             where lancto_id = #lcto_id#
                               and cod_etapa = 'A'
                               and situacao_id = 0
                        </cfquery>
                        <cfset retorno.erro = false>
						<cfoutput query="qr_doctos">
                            <cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_fluxo_documentos.prc_envia_documentos" username="#session.usuario#" password="#session.senha#">
                                <cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_lancto_id" value="#lcto_id#">
                                <cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_documento_id" value="#qr_doctos.documento_id#">
                                <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_cod_etapa" value="A">
                                <cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_pessoa" value="#session.cod_pessoa#">
                                <cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_departamento" value="#session.cod_departamento#">
                                <cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_setor" value="#session.cod_setor#">
                                <cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_centro_custo" value="#session.cod_centro_custo#">
                                <cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_posto" value="0">
                            </cfstoredproc>
                        </cfoutput>
                    </cfloop>
                <cfset retorno.mensagem = JSStringFormat('Documentos enviados com sucesso.')>
                </cftransaction>            
            <cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
            </cftry>
            <cfreturn retorno />
	</cffunction>
    
	<!--- 
    -- PROPSITO
    -- Executa a baixa de documentos recebidos
    -- ANDERSONC 05/03/2010 10:47:21 - CRIADO
    --->
    <cffunction name='baixa_documentos_recebidos' displayname='Executa a baixa de um documento recebido' access='remote' returntype='Struct' output='true'>
        <cfargument name='LANCTO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfloop list="#arguments.LANCTO_ID#" delimiters="," index="i">
					<cfscript>
                        ret = this.baixa_docto_recebido(LANCTO_ID = i);
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>
                
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Baixa de documentos recebidos executada com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Executa a baixa de um documento recebido
	-- ANDERSONC 05/03/2010 10:47:21 - CRIADO
	--->
	<cffunction name='baixa_docto_recebido' displayname='Executa a baixa de um documento recebido' access='remote' returntype='Struct' output='true'>
		<cfargument name='LANCTO_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='oper.pkg_fluxo_documentos.prc_baixa_docto_recebido' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LANCTO_ID'  value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Baixa de documento recebido executada com sucesso.')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Insere NF a Carta Frete
	-- RAFAEL 01/12/2010 15:57:24 - CRIADO
	--->
	<cffunction name='prc_ins_carta_frete_nf' displayname='Insere NF a Carta Frete' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUMERO' required='yes'>
		<cfargument name='LANCTO_ID' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='MODELO' required='yes'>
		<cfargument name='SERIE' required='yes'>
		<cfargument name='SUB_SERIE' required='yes'>
		<cfargument name='VALOR_TOTAL' required='no' default="">
		<cfargument name='CFOP' required='no' default="">
		<cftry>
            <cfstoredproc procedure='oper.pkg_carta_frete.prc_ins_carta_frete_nf' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUMERO'  value='#arguments.NUMERO#'  null='#iif(len(trim(arguments.NUMERO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LANCTO_ID'  value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MODELO'  value='#arguments.MODELO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SERIE'  value='#arguments.SERIE#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SUB_SERIE'  value='#arguments.SUB_SERIE#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_TOTAL'  value='#arguments.VALOR_TOTAL#'  null='#iif(len(trim(arguments.VALOR_TOTAL)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CFOP'  value='#arguments.CFOP#'  null='#iif(len(trim(arguments.CFOP)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
            </cfstoredproc>
			<cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('NF vinculada a CF com sucesso')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
</cfcomponent>