<!-- KM&M Componentes -->
<cfcomponent displayname="Manipulao da rea financeira" extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO
	-- Cria uma conta corrente para a pessoa
	-- cristofer 15/03/2006 11:36:10 - CRIADO
	--->
	<cffunction name='gera_ccorrente_pessoa' displayname='Inativa uma conta corrente' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_PESSOA' required='yes'>
		<cfargument name='ATIVO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='finan.pkg_ccorrente.prc_insere_conta_pessoa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#' >
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' null="yes" variable="retorno.rowid" >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Conta corrente criada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Inativa uma conta corrente
	-- cristofer 15/03/2006 11:36:10 - CRIADO
	--->
	<cffunction name='inativa_ccorrente' displayname='Inativa uma conta corrente' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_CONTA' required='yes'>
		<cfargument name='ATIVO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfscript>
					conn = CreateObject("component", "_transportes.consulta.cfc_financeiro");
					qrCCorrente = conn.get_ccorrente(cod_conta = arguments.cod_conta);
				</cfscript>
				<cfif qrCCorrente.recordcount eq 1>
					<cfstoredproc procedure='finan.pkg_ccorrente.prc_atualiza_ccorrente' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CONTA'  value='#qrCCorrente.COD_CONTA#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO_CONTA'  value='#qrCCorrente.DESCRICAO_CONTA#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#qrCCorrente.COD_PESSOA#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MODALIDADE_ID'  value='#qrCCorrente.MODALIDADE_ID#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_TIMESTAMP' dbvarname='P_DATA_ABERTURA'  value='#qrCCorrente.DATA_ABERTURA#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATIVO'  value='#arguments.ATIVO#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_MOEDA'  value='#qrCCorrente.COD_MOEDA#' >
					</cfstoredproc>
				<cfelse>
					<cfthrow detail="No foi possivel localizar a conta corrente!"
							 message="No foi possivel localizar a conta corrente!">
				</cfif>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Conta corrente alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera os dados de uma conta corrente
	-- cristofer 17/03/2006 09:16:53 - CRIADO
	--->
	<cffunction name='altera_moeda_ccorrente' displayname='Altera os dados de uma conta corrente' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_CONTA' required='yes'>
		<cfargument name='COD_MOEDA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfscript>
					conn = CreateObject("component", "_transportes.consulta.cfc_financeiro");
					qrCCorrente = conn.get_ccorrente(cod_conta = arguments.cod_conta);
				</cfscript>
				<cfdump var="#qrCCorrente#">
				<cfif qrCCorrente.recordCount gt 0 and qrCCorrente.sem_lancamentos eq 1 and qrCCorrente.cod_conta eq arguments.cod_conta>
					<cfif qrCCorrente.cod_moeda neq arguments.cod_moeda>
						<cfstoredproc procedure='finan.pkg_ccorrente.prc_atualiza_ccorrente' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
							<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CONTA'  value='#qrCCorrente.COD_CONTA#'  null='#iif(len(trim(qrCCorrente.COD_CONTA)), de('no'), de('yes'))#'>
							<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO_CONTA'  value='#qrCCorrente.DESCRICAO_CONTA#' >
							<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#qrCCorrente.COD_PESSOA#'  null='#iif(len(trim(qrCCorrente.COD_PESSOA)), de('no'), de('yes'))#'>
							<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MODALIDADE_ID'  value='#qrCCorrente.MODALIDADE_ID#'  null='#iif(len(trim(qrCCorrente.MODALIDADE_ID)), de('no'), de('yes'))#'>
							<cfprocparam type='IN' cfsqltype='CF_SQL_TIMESTAMP' dbvarname='P_DATA_ABERTURA'  value='#qrCCorrente.DATA_ABERTURA#' >
							<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATIVO'  value='#qrCCorrente.ATIVO#'  null='#iif(len(trim(qrCCorrente.ATIVO)), de('no'), de('yes'))#'>
							<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_MOEDA'  value='#arguments.COD_MOEDA#'  null='#iif(len(trim(arguments.COD_MOEDA)), de('no'), de('yes'))#'>
						</cfstoredproc>
					</cfif>
				<cfelse>
					<cfthrow detail="No foi possvel alterar a Conta Corrente!"
							 message="No foi possvel alterar a Conta Corrente!">
				</cfif>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Conta Corrente alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Insere uma conta corrente
	-- cristofer 17/03/2006 09:45:56 - CRIADO
	--->
	<cffunction name='ins_ccorrente' displayname='Insere uma conta corrente' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_CONTA' required='no' default="">
		<cfargument name='DESCRICAO_CONTA' required='yes'>
		<cfargument name='COD_PESSOA' required='yes'>
		<cfargument name='MODALIDADE_ID' required='yes'>
		<cfargument name='DATA_ABERTURA' required='yes'>
		<cfargument name='ATIVO' required='yes'>
		<cfargument name='COD_MOEDA' required='yes'>
		<cfargument name='ROWID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='finan.pkg_ccorrente.prc_insere_ccorrente' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CONTA'  value='#arguments.COD_CONTA#' variable='retorno.COD_CONTA'  null='#iif(len(trim(arguments.COD_CONTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO_CONTA'  value='#arguments.DESCRICAO_CONTA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MODALIDADE_ID'  value='#arguments.MODALIDADE_ID#'  null='#iif(len(trim(arguments.MODALIDADE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_ABERTURA'  value='#arguments.DATA_ABERTURA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATIVO'  value='#arguments.ATIVO#'  null='#iif(len(trim(arguments.ATIVO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_MOEDA'  value='#arguments.COD_MOEDA#'  null='#iif(len(trim(arguments.COD_MOEDA)), de('no'), de('yes'))#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID'  value='#arguments.ROWID#' variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Conta Corrente inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere uma conta corrente
	-- cristofer 17/03/2006 09:45:56 - CRIADO
	--->
	<cffunction name='ins_ccorrente_pessoa' displayname='Insere uma conta corrente' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_PESSOA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfscript>
					conn = CreateObject("component", "_transportes.consulta.cfc_pessoa");
					qrPessoa = conn.getPessoa(cod_pessoa = arguments.cod_pessoa);
					switch(qrPessoa.tipo_pessoa) {
						case 0:
							v_modalidade_id = 1;
							break;
						case 1:
							v_modalidade_id = 2;
							break;
						case 2:
							v_modalidade_id = 6;
							break;
					}
				</cfscript>
				
				<cfstoredproc procedure='finan.pkg_ccorrente.prc_insere_ccorrente' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CONTA'  value='#arguments.COD_CONTA#' variable='retorno.COD_CONTA'  null='#iif(len(trim(arguments.COD_CONTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO_CONTA'  value='#qrPessoa.Cliente#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MODALIDADE_ID'  value='#v_MODALIDADE_ID#'  null='#iif(len(trim(v_MODALIDADE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_TIMESTAMP' dbvarname='P_DATA_ABERTURA'  value='#now()#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATIVO'  value='1'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_MOEDA'  value='705'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID'  null="yes" variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Conta Corrente inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Insere um lancamento na conta corrente
	-- cristofer 17/03/2006 10:13:47 - CRIADO
	--->
	<cffunction name='ins_lancto_ccorrente' displayname='Insere um lancamento na conta corrente' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_CONTA' required='yes'>
		<cfargument name='COD_PESSOA_UN' required='yes'>
		<cfargument name='COD_DOCUMENTO' required='yes'>
		<cfargument name='NUM_DOCUMENTO' required='yes'>
		<cfargument name='DATA_LANCAMENTO' required='yes'>
		<cfargument name='DATA_VENCTO' required='yes'>
		<cfargument name='HISTORICO' required='yes'>
		<cfargument name='VALOR_LANCAMENTO' required='yes'>
		<cfargument name='COD_MOEDA2' required='yes'>
		<cfargument name='COTACAO_MOEDA2' required='yes'>
		<cfargument name='VALOR_MOEDA2' required='yes'>
		<cfargument name='DEB_CRED' required='yes'>
		<cfargument name='FAVORECIDO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='finan.pkg_ccorrente.prc_insere_lancto_ccorrente' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_LANCAMENTO' null='yes' variable='retorno.NUM_LANCAMENTO'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CONTA'  value='#arguments.COD_CONTA#'  null='#iif(len(trim(arguments.COD_CONTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_UN'  value='#arguments.COD_PESSOA_UN#'  null='#iif(len(trim(arguments.COD_PESSOA_UN)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_DOCUMENTO'  value='#arguments.COD_DOCUMENTO#'  null='#iif(len(trim(arguments.COD_DOCUMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUM_DOCUMENTO'  value='#arguments.NUM_DOCUMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_LANCAMENTO'  value='#arguments.DATA_LANCAMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_VENCTO'  value='#arguments.DATA_VENCTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_HISTORICO'  value='#arguments.HISTORICO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_LANCAMENTO'  value='#arguments.VALOR_LANCAMENTO#'  null='#iif(len(trim(arguments.VALOR_LANCAMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_MOEDA2'  value='#arguments.COD_MOEDA2#'  null='#iif(len(trim(arguments.COD_MOEDA2)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COTACAO_MOEDA2'  value='#arguments.COTACAO_MOEDA2#'  null='#iif(len(trim(arguments.COTACAO_MOEDA2)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_MOEDA2'  value='#arguments.VALOR_MOEDA2#'  null='#iif(len(trim(arguments.VALOR_MOEDA2)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DEB_CRED'  value='#arguments.DEB_CRED#'  null='#iif(len(trim(arguments.DEB_CRED)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_FAVORECIDO'  value='#arguments.FAVORECIDO#' >
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' null="yes" variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Lanamento efetuado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera os dados de uma conta corrente
	-- cristofer 17/03/2006 09:16:53 - CRIADO
	--->
	<cffunction name='upd_ccorrente' displayname='Altera os dados de uma conta corrente' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_CONTA' required='yes'>
		<cfargument name='DESCRICAO_CONTA' required='yes'>
		<cfargument name='COD_PESSOA' required='yes'>
		<cfargument name='MODALIDADE_ID' required='yes'>
		<cfargument name='DATA_ABERTURA' required='yes'>
		<cfargument name='ATIVO' required='yes'>
		<cfargument name='COD_MOEDA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='finan.pkg_ccorrente.prc_atualiza_ccorrente' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CONTA'  value='#arguments.COD_CONTA#'  null='#iif(len(trim(arguments.COD_CONTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO_CONTA'  value='#arguments.DESCRICAO_CONTA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MODALIDADE_ID'  value='#arguments.MODALIDADE_ID#'  null='#iif(len(trim(arguments.MODALIDADE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_ABERTURA'  value='#arguments.DATA_ABERTURA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ATIVO'  value='#arguments.ATIVO#'  null='#iif(len(trim(arguments.ATIVO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_MOEDA'  value='#arguments.COD_MOEDA#'  null='#iif(len(trim(arguments.COD_MOEDA)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Conta Corrente alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Altera os dados de uma conta corrente
	-- cristofer 17/03/2006 09:16:53 - CRIADO
	--->
	<cffunction name='upd_finan_arquivo_kmm' displayname='Altera os dados de uma conta corrente' access='remote' returntype='Struct' output='true'>
		<cfargument name='TEXTO' required='yes'>
		<cfargument name='ORIGEM' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfquery datasource="KMM.KMM.COM.BR" username="cotacoes" password="!kc_|_08">
					delete from kss.pessoa_usuario_acesso_cur c
					 where c.usuario = user
				</cfquery>
	
				<cfquery datasource="KMM.KMM.COM.BR" username="cotacoes" password="!kc_|_08">
					  insert into kss.pessoa_usuario_acesso_cur(cod_pessoa, usuario)
					  values (40, user)
				</cfquery>			
				<cfquery name="qr_result" datasource="KMM.KMM.COM.BR" username="cotacoes" password="!kc_|_08">
					update finan.finan_arquivo
					   set arquivo = '#arguments.texto#'
				</cfquery>
				<cfstoredproc procedure='finan.pkg_financeiro.prc_importa_moeda_cotacao' datasource='KMM.KMM.COM.BR' username='cotacoes' password='!kc_|_08'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#LSDateFormat(now())# - Importao Automatica' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ORIGEM'  value='#arguments.origem#' >
				</cfstoredproc>				
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Arquivo atualizado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
</cfcomponent>